/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.common.DateFactory;
import com.scudata.common.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class Types {
    public static final byte DT_DEFAULT = 0;
    public static final byte DT_INT = 1;
    public static final byte DT_LONG = 2;
    public static final byte DT_SHORT = 3;
    public static final byte DT_BIGINT = 4;
    public static final byte DT_FLOAT = 5;
    public static final byte DT_DOUBLE = 6;
    public static final byte DT_DECIMAL = 7;
    public static final byte DT_DATE = 8;
    public static final byte DT_TIME = 9;
    public static final byte DT_DATETIME = 10;
    public static final byte DT_STRING = 11;
    public static final byte DT_BOOLEAN = 12;
    public static final byte DT_INT_SERIES = 51;
    public static final byte DT_LONG_SERIES = 52;
    public static final byte DT_SHORT_SERIES = 53;
    public static final byte DT_BIGINT_SERIES = 54;
    public static final byte DT_FLOAT_SERIES = 55;
    public static final byte DT_DOUBLE_SERIES = 56;
    public static final byte DT_DECIMAL_SERIES = 57;
    public static final byte DT_DATE_SERIES = 58;
    public static final byte DT_TIME_SERIES = 59;
    public static final byte DT_DATETIME_SERIES = 60;
    public static final byte DT_STRING_SERIES = 61;
    public static final byte DT_BYTE_SERIES = 62;
    public static final byte DT_CURSOR = 101;
    public static final byte DT_AUTOINCREMENT = 102;
    public static final byte DT_SERIALBYTES = 103;

    public static Object getProperData(byte type, String val) throws Exception {
        return Types.getProperData(type, val, false);
    }

    public static Object getProperData(byte type, String val, boolean ignoreString) throws Exception {
        if (val == null) {
            return null;
        }
        String orignal = val;
        if (!((val = val.trim()).length() != 0 || type == 11 && ignoreString)) {
            return null;
        }
        switch (type) {
            case 11: {
                return orignal;
            }
            case 1: {
                return Integer.valueOf(val);
            }
            case 6: {
                return Double.valueOf(val);
            }
            case 2: {
                return Long.valueOf(val);
            }
            case 3: {
                return Short.valueOf(val);
            }
            case 4: {
                return new BigInteger(val);
            }
            case 5: {
                return Float.valueOf(val);
            }
            case 7: {
                return new BigDecimal(val);
            }
            case 8: {
                return DateFactory.parseDate(val);
            }
            case 9: {
                return DateFactory.parseTime(val);
            }
            case 10: {
                return DateFactory.parseDateTime(val);
            }
            case 12: {
                if ("true".equalsIgnoreCase(val)) {
                    return Boolean.TRUE;
                }
                if ("false".equalsIgnoreCase(val)) {
                    return Boolean.FALSE;
                }
                return null;
            }
            case 51: {
                Vector v = StringUtils.string2Vector(val);
                ArrayList<Integer> ls = new ArrayList<Integer>();
                int i = 0;
                int size = v.size();
                while (i < size) {
                    ls.add(Integer.valueOf((String)v.get(i)));
                    ++i;
                }
                return ls;
            }
            case 52: {
                Vector v = StringUtils.string2Vector(val);
                ArrayList<Long> ls = new ArrayList<Long>();
                int i = 0;
                int size = v.size();
                while (i < size) {
                    ls.add(Long.valueOf((String)v.get(i)));
                    ++i;
                }
                return ls;
            }
            case 53: {
                Vector v = StringUtils.string2Vector(val);
                ArrayList<Short> ls = new ArrayList<Short>();
                int i = 0;
                int size = v.size();
                while (i < size) {
                    ls.add(Short.valueOf((String)v.get(i)));
                    ++i;
                }
                return ls;
            }
            case 54: {
                Vector v = StringUtils.string2Vector(val);
                ArrayList<BigInteger> ls = new ArrayList<BigInteger>();
                int i = 0;
                int size = v.size();
                while (i < size) {
                    ls.add(new BigInteger((String)v.get(i)));
                    ++i;
                }
                return ls;
            }
            case 55: {
                Vector v = StringUtils.string2Vector(val);
                ArrayList<Float> ls = new ArrayList<Float>();
                int i = 0;
                int size = v.size();
                while (i < size) {
                    ls.add(Float.valueOf((String)v.get(i)));
                    ++i;
                }
                return ls;
            }
            case 56: {
                Vector v = StringUtils.string2Vector(val);
                ArrayList<Double> ls = new ArrayList<Double>();
                int i = 0;
                int size = v.size();
                while (i < size) {
                    ls.add(Double.valueOf((String)v.get(i)));
                    ++i;
                }
                return ls;
            }
            case 57: {
                Vector v = StringUtils.string2Vector(val);
                ArrayList<BigDecimal> ls = new ArrayList<BigDecimal>();
                int i = 0;
                int size = v.size();
                while (i < size) {
                    ls.add(new BigDecimal((String)v.get(i)));
                    ++i;
                }
                return ls;
            }
            case 58: {
                Vector v = StringUtils.string2Vector(val);
                ArrayList<Date> ls = new ArrayList<Date>();
                int i = 0;
                int size = v.size();
                while (i < size) {
                    ls.add(DateFactory.parseDate((String)v.get(i)));
                    ++i;
                }
                return ls;
            }
            case 59: {
                Vector v = StringUtils.string2Vector(val);
                ArrayList<Date> ls = new ArrayList<Date>();
                int i = 0;
                int size = v.size();
                while (i < size) {
                    ls.add(DateFactory.parseTime((String)v.get(i)));
                    ++i;
                }
                return ls;
            }
            case 60: {
                Vector v = StringUtils.string2Vector(val);
                ArrayList<Date> ls = new ArrayList<Date>();
                int i = 0;
                int size = v.size();
                while (i < size) {
                    ls.add(DateFactory.parseDateTime((String)v.get(i)));
                    ++i;
                }
                return ls;
            }
            case 61: {
                Vector v = StringUtils.string2Vector(orignal);
                ArrayList<String> ls = new ArrayList<String>();
                int i = 0;
                int size = v.size();
                while (i < size) {
                    ls.add((String)v.get(i));
                    ++i;
                }
                return ls;
            }
        }
        return orignal;
    }

    public static byte getProperDataType(Object value) {
        if (value instanceof String) {
            return 11;
        }
        if (value instanceof Double || value instanceof Float) {
            return 6;
        }
        if (value instanceof Integer || value instanceof Long || value instanceof BigInteger) {
            return 2;
        }
        if (value instanceof Time) {
            return 9;
        }
        if (value instanceof Timestamp) {
            return 10;
        }
        if (value instanceof java.sql.Date) {
            return 8;
        }
        if (value instanceof BigDecimal) {
            return 7;
        }
        if (value instanceof Boolean) {
            return 12;
        }
        return 11;
    }

    public static byte getTypeBySQLType(int type) {
        switch (type) {
            case 4: {
                return 1;
            }
            case -6: 
            case 5: {
                return 3;
            }
            case -5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: 
            case 8: {
                return 6;
            }
            case 2: 
            case 3: {
                return 7;
            }
            case 91: {
                return 8;
            }
            case 92: {
                return 9;
            }
            case 93: {
                return 10;
            }
            case -1: 
            case 1: 
            case 12: {
                return 11;
            }
            case 16: {
                return 12;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return 62;
            }
        }
        return 0;
    }

    public static boolean isNumberType(byte type) {
        return type >= 1 && type <= 7;
    }

    public static boolean isDateType(byte type) {
        return type >= 8 && type <= 10;
    }
}

