/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.array.IArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.IRecord;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.IComputeItem;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.io.Externalizable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRecord
implements IComputeItem,
Externalizable,
IRecord,
Comparable<BaseRecord> {
    @Override
    public Object getCurrent() {
        return this;
    }

    @Override
    public int getCurrentIndex() {
        throw new RuntimeException();
    }

    @Override
    public Sequence getCurrentSequence() {
        return null;
    }

    @Override
    public boolean isInStack(ComputeStack stack) {
        return stack.isInComputeStack(this);
    }

    @Override
    public void popStack() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object calc(Expression exp, Context ctx) {
        if (exp == null) {
            return null;
        }
        ComputeStack stack = ctx.getComputeStack();
        stack.push(this);
        try {
            Object object = exp.calculate(ctx);
            return object;
        }
        finally {
            stack.pop();
        }
    }

    @Override
    public int compareTo(BaseRecord r) {
        int h2;
        if (r == this) {
            return 0;
        }
        int h1 = this.hashCode();
        if (h1 < (h2 = r.hashCode())) {
            return -1;
        }
        if (h1 > h2) {
            return 1;
        }
        Object[] vals1 = this.getFieldValues();
        Object[] vals2 = r.getFieldValues();
        int[] pkIndex1 = this.getPKIndex();
        int[] pkIndex2 = r.getPKIndex();
        if (pkIndex1 != null && pkIndex2 != null && pkIndex1.length == pkIndex2.length) {
            for (int i = 0; i < pkIndex1.length; ++i) {
                int result = Variant.compare(vals1[pkIndex1[i]], vals2[pkIndex2[i]], true);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
        int len1 = vals1.length;
        int len2 = vals2.length;
        int minLen = len1 > len2 ? len2 : len1;
        for (int i = 0; i < minLen; ++i) {
            int result = Variant.compare(vals1[i], vals2[i], true);
            if (result == 0) continue;
            return result;
        }
        return len1 == len2 ? 0 : (len1 > len2 ? 1 : -1);
    }

    public abstract int compare(int[] var1, Object[] var2);

    public int compare(BaseRecord r, int[] fields) {
        for (int f : fields) {
            int result = Variant.compare(this.getNormalFieldValue(f), r.getNormalFieldValue(f), true);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public int compare(BaseRecord r, int field) {
        return Variant.compare(this.getNormalFieldValue(field), r.getNormalFieldValue(field), true);
    }

    public abstract int compare(BaseRecord var1);

    public int compare(int field, IArray values, int index) {
        return Variant.compare(this.getFieldValue(field), values.get(index), true);
    }

    public abstract DataStruct dataStruct();

    public abstract int getFieldCount();

    public int getFieldIndex(String name) {
        return this.dataStruct().getFieldIndex(name);
    }

    public String[] getFieldNames() {
        return this.dataStruct().getFieldNames();
    }

    public abstract Object getFieldValue(int var1);

    public abstract Object getFieldValue(String var1);

    @Override
    public abstract Object getFieldValue2(int var1);

    public abstract Object[] getFieldValues();

    public abstract Object getNormalFieldValue(int var1);

    public abstract void getNormalFieldValue(int var1, IArray var2);

    public IArray createFieldValueArray(int f, int len) {
        return new ObjectArray(len);
    }

    public int[] getPKIndex() {
        return this.dataStruct().getPKIndex();
    }

    public Object getPKValue() {
        DataStruct ds = this.dataStruct();
        int[] pkIndex = ds.getPKIndex();
        if (pkIndex == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("ds.lessKey"));
        }
        int keyCount = pkIndex.length - ds.getTimeKeyCount();
        if (keyCount == 1) {
            Object obj = this.getNormalFieldValue(pkIndex[0]);
            if (obj instanceof BaseRecord) {
                return ((BaseRecord)obj).getPKValue();
            }
            return obj;
        }
        Sequence keySeries = new Sequence(keyCount);
        for (int i = 0; i < keyCount; ++i) {
            Object obj = this.getNormalFieldValue(pkIndex[i]);
            if (obj instanceof BaseRecord) {
                obj = ((BaseRecord)obj).getPKValue();
            }
            if (obj instanceof Sequence) {
                keySeries.addAll((Sequence)obj);
                continue;
            }
            keySeries.add(obj);
        }
        return keySeries;
    }

    public Object value() {
        DataStruct ds = this.dataStruct();
        int[] pkIndex = ds.getPKIndex();
        if (pkIndex == null) {
            int fcount = ds.getFieldCount();
            Sequence seq = new Sequence(fcount);
            for (int f = 0; f < fcount; ++f) {
                Object obj = this.getNormalFieldValue(f);
                if (obj instanceof BaseRecord) {
                    obj = ((BaseRecord)obj).key();
                }
                if (obj instanceof Sequence) {
                    seq.addAll((Sequence)obj);
                    continue;
                }
                seq.add(obj);
            }
            return seq;
        }
        int keyCount = pkIndex.length - ds.getTimeKeyCount();
        if (keyCount == 1) {
            Object obj = this.getNormalFieldValue(pkIndex[0]);
            if (obj instanceof BaseRecord) {
                return ((BaseRecord)obj).key();
            }
            return obj;
        }
        Sequence keySeries = new Sequence(keyCount);
        for (int i = 0; i < keyCount; ++i) {
            Object obj = this.getNormalFieldValue(pkIndex[i]);
            if (obj instanceof BaseRecord) {
                obj = ((BaseRecord)obj).key();
            }
            if (obj instanceof Sequence) {
                keySeries.addAll((Sequence)obj);
                continue;
            }
            keySeries.add(obj);
        }
        return keySeries;
    }

    public boolean hasTimeKey() {
        return this.dataStruct().getTimeKeyCount() > 0;
    }

    public abstract boolean isEquals(BaseRecord var1);

    public abstract boolean isEquals(BaseRecord var1, int[] var2);

    public boolean isSameDataStruct(BaseRecord cur) {
        return this.dataStruct() == cur.dataStruct();
    }

    public Object key() {
        DataStruct ds = this.dataStruct();
        int[] pkIndex = ds.getPKIndex();
        if (pkIndex == null) {
            return null;
        }
        int keyCount = pkIndex.length - ds.getTimeKeyCount();
        if (keyCount == 1) {
            Object obj = this.getNormalFieldValue(pkIndex[0]);
            if (obj instanceof BaseRecord) {
                return ((BaseRecord)obj).key();
            }
            return obj;
        }
        Sequence keySeries = new Sequence(keyCount);
        for (int i = 0; i < keyCount; ++i) {
            Object obj = this.getNormalFieldValue(pkIndex[i]);
            if (obj instanceof BaseRecord) {
                obj = ((BaseRecord)obj).key();
            }
            if (obj instanceof Sequence) {
                keySeries.addAll((Sequence)obj);
                continue;
            }
            keySeries.add(obj);
        }
        return keySeries;
    }

    public abstract void modify(Expression[] var1, String[] var2, Context var3);

    public abstract void paste(BaseRecord var1, boolean var2);

    public abstract void paste(Sequence var1);

    public abstract void paste(Sequence var1, int var2);

    public Sequence prior(String field, BaseRecord p, int maxLevel) {
        int f = this.getFieldIndex(field);
        if (f == -1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(field + mm.getMessage("ds.fieldNotExist"));
        }
        return this.prior(f, p, maxLevel);
    }

    public Sequence prior(int f, BaseRecord p, int maxLevel) {
        if (this == p) {
            return new Sequence(0);
        }
        Sequence seq = new Sequence();
        BaseRecord r = this;
        if (maxLevel > 0) {
            for (int i = 0; i < maxLevel; ++i) {
                Object obj = r.getNormalFieldValue(f);
                if (obj == p) {
                    seq.add(r);
                    return seq;
                }
                if (obj == null) {
                    return null;
                }
                if (!(obj instanceof BaseRecord)) {
                    return null;
                }
                seq.add(r);
                r = (BaseRecord)obj;
            }
            return null;
        }
        while (true) {
            Object obj;
            if ((obj = r.getNormalFieldValue(f)) == p) {
                seq.add(r);
                return seq;
            }
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof BaseRecord)) break;
            seq.add(r);
            r = (BaseRecord)obj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Expression exp, Context ctx) {
        if (exp == null) {
            return;
        }
        ComputeStack stack = ctx.getComputeStack();
        stack.push(this);
        try {
            exp.calculate(ctx);
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Expression[] assignExps, Expression[] exps, Context ctx) {
        if (exps == null || exps.length == 0) {
            return;
        }
        int colCount = exps.length;
        if (assignExps == null) {
            assignExps = new Expression[colCount];
        } else if (assignExps.length != colCount) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("run" + mm.getMessage("function.invalidParam"));
        }
        ComputeStack stack = ctx.getComputeStack();
        stack.push(this);
        try {
            for (int c = 0; c < colCount; ++c) {
                if (assignExps[c] == null) {
                    exps[c].calculate(ctx);
                    continue;
                }
                assignExps[c].assign(exps[c].calculate(ctx), ctx);
            }
        }
        finally {
            stack.pop();
        }
    }

    public abstract void set(int var1, Object var2);

    public abstract void set(String var1, Object var2);

    public abstract void set(BaseRecord var1);

    public abstract void setNormalFieldValue(int var1, Object var2);

    public abstract void set2(int var1, Object var2);

    public abstract void setStart(int var1, Object[] var2);

    public abstract void setStart(int var1, Object[] var2, int var3);

    public abstract void setStart(int var1, BaseRecord var2);

    public abstract String toString(String var1);

    public abstract Record toRecord();
}

