/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.dm.Env;
import com.scudata.dm.InputStreamManager;
import java.io.IOException;
import java.io.InputStream;

public class BlockInputStream
extends InputStream {
    protected InputStream is;
    protected byte[] buffer;
    protected volatile int count;
    protected IOException e;
    protected boolean isClosed;

    public BlockInputStream(InputStream is) {
        this(is, Env.getFileBufSize());
    }

    public BlockInputStream(InputStream is, int bufSize) {
        this.is = is;
        this.count = 0;
        this.buffer = new byte[bufSize];
        InputStreamManager.getInstance().read(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _$1() {
        InputStream inputStream = this.is;
        synchronized (inputStream) {
            block9: {
                if (!this.isClosed) {
                    try {
                        do {
                            this.count = this.is.read(this.buffer);
                        } while (this.count == 0);
                    }
                    catch (Exception e) {
                        if (e instanceof IOException) {
                            this.e = (IOException)e;
                            break block9;
                        }
                        this.e = new IOException(e);
                    }
                } else {
                    this.e = new IOException("Stream closed");
                }
            }
            this.is.notify();
        }
    }

    public int read() throws IOException {
        throw new IOException("read not supported");
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len != this.buffer.length) {
            throw new IOException("Invalid buffer size.");
        }
        InputStream inputStream = this.is;
        synchronized (inputStream) {
            if (this.count == 0) {
                if (this.e != null) {
                    throw this.e;
                }
                try {
                    this.is.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException(e.toString());
                }
            }
            if (this.count > 0) {
                int n = this.count;
                System.arraycopy(this.buffer, 0, b, off, n);
                this.count = 0;
                InputStreamManager.getInstance().read(this);
                return n;
            }
            if (this.count < 0) {
                return -1;
            }
            throw this.e;
        }
    }

    private static long _$1(InputStream is, long count) throws IOException {
        long num;
        long old = count;
        while (count > 0L && (num = is.skip(count)) > 0L) {
            count -= num;
        }
        return old - count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long n) throws IOException {
        if (n < 1L) {
            return -1L;
        }
        InputStream inputStream = this.is;
        synchronized (inputStream) {
            if (this.count > 0) {
                if ((long)this.count > n) {
                    int rest = this.count - (int)n;
                    System.arraycopy(this.buffer, (int)n, this.buffer, 0, rest);
                    this.count = rest;
                    return n;
                }
                if ((long)this.count < n) {
                    long total = BlockInputStream._$1(this.is, n - (long)this.count) + (long)this.count;
                    this.count = 0;
                    InputStreamManager.getInstance().read(this);
                    return total;
                }
                this.count = 0;
                InputStreamManager.getInstance().read(this);
                return n;
            }
            if (this.count < 0) {
                return 0L;
            }
            if (this.e != null) {
                throw this.e;
            }
            return BlockInputStream._$1(this.is, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        InputStream inputStream = this.is;
        synchronized (inputStream) {
            if (this.e != null) {
                throw this.e;
            }
            if (this.count > 0) {
                return this.buffer.length;
            }
            if (this.count < 0) {
                return 0;
            }
            return this.is.available() > 0 ? this.buffer.length : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        InputStream inputStream = this.is;
        synchronized (inputStream) {
            this.isClosed = true;
            this.is.close();
        }
    }
}

