/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.array.BoolArray;
import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.Env;
import com.scudata.dm.IlIIIllllIlIlIlI;
import com.scudata.dm.IndexTable;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.lIllIlIlllIIIlll;
import com.scudata.expression.Expression;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.MultithreadUtil;
import com.scudata.thread.ThreadPool;
import com.scudata.util.HashUtil;
import com.scudata.util.Variant;

public class HashArrayIndexTable
extends IndexTable {
    private Sequence _$2;
    protected HashUtil hashUtil;
    protected lIllIlIlllIIIlll[] entries;
    private boolean _$1;

    public HashArrayIndexTable(int capacity) {
        this.hashUtil = new HashUtil(capacity);
    }

    public HashArrayIndexTable(int capacity, String opt) {
        this.hashUtil = new HashUtil(capacity);
        this._$1 = opt != null && opt.indexOf(109) != -1;
    }

    private HashArrayIndexTable(Sequence code, HashUtil hashUtil, lIllIlIlllIIIlll[] entries) {
        this._$2 = code;
        this.hashUtil = hashUtil;
        this.entries = entries;
    }

    public int getCapacity() {
        return this.hashUtil.getCapacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Sequence code, Expression[] exps, Context ctx) {
        this._$2 = code;
        HashUtil hashUtil = this.hashUtil;
        lIllIlIlllIIIlll[] groups = new lIllIlIlllIIIlll[hashUtil.getCapacity()];
        this.entries = groups;
        int keyCount = exps.length;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(code);
        stack.push(current);
        try {
            int len = code.length();
            for (int i = 1; i <= len; ++i) {
                current.setCurrent(i);
                Object[] keys = new Object[keyCount];
                for (int c = 0; c < keyCount; ++c) {
                    keys[c] = exps[c].calculate(ctx);
                }
                int hash = hashUtil.hashCode(keys, keyCount);
                lIllIlIlllIIIlll entry = groups[hash];
                while (entry != null) {
                    if (Variant.compareArrays(entry._$3, keys, keyCount) == 0) {
                        MessageManager mm = EngineMessage.get();
                        String str = "[";
                        for (int k = 0; k < keyCount; ++k) {
                            if (k != 0) {
                                str = str + ",";
                            }
                            str = str + Variant.toString(keys[k]);
                        }
                        str = str + "]";
                        throw new RQException(str + mm.getMessage("engine.dupKeys"));
                    }
                    entry = entry._$1;
                }
                groups[hash] = new lIllIlIlllIIIlll(keys, i, groups[hash]);
            }
        }
        finally {
            stack.pop();
        }
    }

    private static void _$1(lIllIlIlllIIIlll[] result, lIllIlIlllIIIlll[] entries, boolean checkDupKey) {
        int len = result.length;
        block0: for (int i = 0; i < len; ++i) {
            if (result[i] == null) {
                result[i] = entries[i];
                continue;
            }
            if (entries[i] == null) continue;
            lIllIlIlllIIIlll entry = entries[i];
            while (true) {
                lIllIlIlllIIIlll resultEntry = result[i];
                while (resultEntry != null) {
                    if (Variant.compareArrays(entry._$3, resultEntry._$3) == 0) {
                        Object[] keys = entry._$3;
                        MessageManager mm = EngineMessage.get();
                        String str = "[";
                        for (int k = 0; k < keys.length; ++k) {
                            if (k != 0) {
                                str = str + ",";
                            }
                            str = str + Variant.toString(keys[k]);
                        }
                        str = str + "]";
                        throw new RQException(str + mm.getMessage("engine.dupKeys"));
                    }
                    resultEntry = resultEntry._$1;
                }
                if (entry._$1 == null) {
                    entry._$1 = result[i];
                    result[i] = entries[i];
                    continue block0;
                }
                entry = entry._$1;
            }
        }
    }

    public void create(Sequence code, int[] fields) {
        this.create(code, fields, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Sequence code, int[] fields, boolean checkDupKey) {
        this._$2 = code;
        int len = code.length();
        if (this._$1 && len > MultithreadUtil.SINGLE_PROSS_COUNT && Env.getParallelNum() > 1) {
            int threadCount = Env.getParallelNum();
            int singleCount = len / threadCount;
            IlIIIllllIlIlIlI[] jobs = new IlIIIllllIlIlIlI[threadCount];
            ThreadPool pool = ThreadPool.newInstance(threadCount);
            try {
                int i;
                int start = 1;
                for (i = 0; i < threadCount; ++i) {
                    if (i + 1 == threadCount) {
                        jobs[i] = new IlIIIllllIlIlIlI(this.hashUtil, code, fields, start, len + 1, checkDupKey);
                    } else {
                        jobs[i] = new IlIIIllllIlIlIlI(this.hashUtil, code, fields, start, start + singleCount, checkDupKey);
                        start += singleCount;
                    }
                    pool.submit(jobs[i]);
                }
                for (i = 0; i < threadCount; ++i) {
                    jobs[i].join();
                    if (this.entries == null) {
                        this.entries = jobs[i]._$1;
                        continue;
                    }
                    HashArrayIndexTable._$1(this.entries, jobs[i]._$1, checkDupKey);
                }
            }
            finally {
                pool.shutdown();
            }
        } else {
            IlIIIllllIlIlIlI job = new IlIIIllllIlIlIlI(this.hashUtil, code, fields, 1, len + 1, checkDupKey);
            job.run();
            this.entries = job._$1;
        }
    }

    public Object find(Object key) {
        throw new RuntimeException();
    }

    public Object find(Object[] keys) {
        int count = keys.length;
        int hash = this.hashUtil.hashCode(keys, count);
        lIllIlIlllIIIlll entry = this.entries[hash];
        while (entry != null) {
            if (Variant.compareArrays(entry._$3, keys) == 0) {
                return this._$2.getMem(entry._$2);
            }
            entry = entry._$1;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table select(Expression exp, Context ctx) {
        Sequence code = this._$2;
        lIllIlIlllIIIlll[] entries = this.entries;
        int len = code.length();
        int capacity = entries.length;
        lIllIlIlllIIIlll[] resultEntries = new lIllIlIlllIIIlll[capacity];
        Table result = new Table(code.dataStruct(), len);
        IArray mems = result.getMems();
        int newLen = 0;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(code);
        stack.push(current);
        try {
            block3: for (int i = 0; i < capacity; ++i) {
                lIllIlIlllIIIlll entry = entries[i];
                while (entry != null) {
                    current.setCurrent(entry._$2);
                    Object b = exp.calculate(ctx);
                    if (Variant.isTrue(b)) {
                        lIllIlIlllIIIlll prev;
                        mems.add(current.getCurrent());
                        resultEntries[i] = prev = new lIllIlIlllIIIlll(entry._$3, ++newLen);
                        entry = entry._$1;
                        while (entry != null) {
                            current.setCurrent(entry._$2);
                            b = exp.calculate(ctx);
                            if (Variant.isTrue(b)) {
                                mems.add(current.getCurrent());
                                prev = prev._$1 = new lIllIlIlllIIIlll(entry._$3, ++newLen);
                            }
                            entry = entry._$1;
                        }
                        continue block3;
                    }
                    entry = entry._$1;
                }
            }
        }
        finally {
            stack.pop();
        }
        result.trimToSize();
        HashArrayIndexTable indexTable = new HashArrayIndexTable(result, this.hashUtil, resultEntries);
        result.setIndexTable(indexTable);
        return result;
    }

    public int findPos(Object key) {
        throw new RuntimeException();
    }

    public int findPos(Object[] keys) {
        int count = keys.length;
        int hash = this.hashUtil.hashCode(keys, count);
        lIllIlIlllIIIlll entry = this.entries[hash];
        while (entry != null) {
            if (Variant.compareArrays(entry._$3, keys) == 0) {
                return entry._$2;
            }
            entry = entry._$1;
        }
        return 0;
    }

    public int[] findAllPos(IArray key) {
        throw new RuntimeException();
    }

    public int[] findAllPos(IArray[] keys) {
        lIllIlIlllIIIlll[] entries = this.entries;
        HashUtil hashUtil = this.hashUtil;
        int keyCount = keys.length;
        int len = keys[0].size();
        int[] pos = new int[len + 1];
        block0: for (int i = 1; i <= len; ++i) {
            int hash = hashUtil.hashCode(keys, i, keyCount);
            lIllIlIlllIIIlll entry = entries[hash];
            while (entry != null) {
                block4: {
                    Object[] keyValues = entry._$3;
                    for (int k = 0; k < keyCount; ++k) {
                        if (keys[k].isEquals(i, keyValues[k])) {
                            continue;
                        }
                        break block4;
                    }
                    pos[i] = entry._$2;
                    continue block0;
                }
                entry = entry._$1;
            }
        }
        return pos;
    }

    public int[] findAllPos(IArray key, BoolArray signArray) {
        throw new RuntimeException();
    }

    public int[] findAllPos(IArray[] keys, BoolArray signArray) {
        lIllIlIlllIIIlll[] entries = this.entries;
        HashUtil hashUtil = this.hashUtil;
        int keyCount = keys.length;
        int len = keys[0].size();
        int[] pos = new int[len + 1];
        block0: for (int i = 1; i <= len; ++i) {
            if (signArray.isFalse(i)) continue;
            int hash = hashUtil.hashCode(keys, i, keyCount);
            lIllIlIlllIIIlll entry = entries[hash];
            while (entry != null) {
                block4: {
                    Object[] keyValues = entry._$3;
                    for (int k = 0; k < keyCount; ++k) {
                        if (keys[k].isEquals(i, keyValues[k])) {
                            continue;
                        }
                        break block4;
                    }
                    pos[i] = entry._$2;
                    continue block0;
                }
                entry = entry._$1;
            }
        }
        return pos;
    }

    public int[] findAllFirstPos(IArray[] keys) {
        lIllIlIlllIIIlll[] entries = this.entries;
        HashUtil hashUtil = this.hashUtil;
        int keyCount = keys.length;
        int len = keys[0].size();
        int[] pos = new int[len + 1];
        for (int i = 1; i <= len; ++i) {
            int hash = hashUtil.hashCode(keys, i, keyCount);
            int seq = 0;
            lIllIlIlllIIIlll entry = entries[hash];
            while (entry != null) {
                block4: {
                    Object[] keyValues = entry._$3;
                    for (int k = 0; k < keyCount; ++k) {
                        if (keys[k].isEquals(i, keyValues[k])) {
                            continue;
                        }
                        break block4;
                    }
                    seq = entry._$2;
                }
                entry = entry._$1;
            }
            pos[i] = seq;
        }
        return pos;
    }

    public int[] findAllFirstPos(IArray[] keys, BoolArray signArray) {
        lIllIlIlllIIIlll[] entries = this.entries;
        HashUtil hashUtil = this.hashUtil;
        int keyCount = keys.length;
        int len = keys[0].size();
        int[] pos = new int[len + 1];
        for (int i = 1; i <= len; ++i) {
            if (signArray.isFalse(i)) continue;
            int hash = hashUtil.hashCode(keys, i, keyCount);
            int seq = 0;
            lIllIlIlllIIIlll entry = entries[hash];
            while (entry != null) {
                block4: {
                    Object[] keyValues = entry._$3;
                    for (int k = 0; k < keyCount; ++k) {
                        if (keys[k].isEquals(i, keyValues[k])) {
                            continue;
                        }
                        break block4;
                    }
                    seq = entry._$2;
                }
                entry = entry._$1;
            }
            pos[i] = seq;
        }
        return pos;
    }
}

