/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.array.BoolArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.Env;
import com.scudata.dm.IndexTable;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.lIIIIllllIlIlIlI;
import com.scudata.dm.llIlIlIlllIIIlll;
import com.scudata.dm.lllIIIllIIIllIll;
import com.scudata.expression.Expression;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.MultithreadUtil;
import com.scudata.thread.ThreadPool;
import com.scudata.util.HashUtil;
import com.scudata.util.Variant;

public class HashIndexTable
extends IndexTable {
    private Sequence _$2;
    protected HashUtil hashUtil;
    protected llIlIlIlllIIIlll[] entries;
    private boolean _$1;

    public HashIndexTable(int capacity) {
        this.hashUtil = new HashUtil(capacity);
    }

    public HashIndexTable(int capacity, String opt) {
        this.hashUtil = new HashUtil(capacity);
        this._$1 = opt != null && opt.indexOf(109) != -1;
    }

    private HashIndexTable(Sequence code, HashUtil hashUtil, llIlIlIlllIIIlll[] entries) {
        this._$2 = code;
        this.hashUtil = hashUtil;
        this.entries = entries;
    }

    public int getCapacity() {
        return this.hashUtil.getCapacity();
    }

    public void create(Sequence code) {
        this._$2 = code;
        HashUtil hashUtil = this.hashUtil;
        llIlIlIlllIIIlll[] groups = new llIlIlIlllIIIlll[hashUtil.getCapacity()];
        this.entries = groups;
        int len = code.length();
        for (int i = 1; i <= len; ++i) {
            Object r = code.getMem(i);
            Object key = r instanceof BaseRecord ? ((BaseRecord)r).getPKValue() : r;
            int hash = hashUtil.hashCode(key);
            llIlIlIlllIIIlll entry = groups[hash];
            while (entry != null) {
                if (Variant.compare(entry._$3, key, true) == 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(Variant.toString(key) + mm.getMessage("engine.dupKeys"));
                }
                entry = entry._$1;
            }
            groups[hash] = new llIlIlIlllIIIlll(key, i, groups[hash]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Sequence code, Expression exp, Context ctx) {
        Table table;
        int f;
        if (exp == null) {
            this.create(code);
            return;
        }
        if (code instanceof Table && (f = exp.getFieldIndex((table = (Table)code).dataStruct())) != -1) {
            this.create(table, f);
            return;
        }
        this._$2 = code;
        HashUtil hashUtil = this.hashUtil;
        llIlIlIlllIIIlll[] groups = new llIlIlIlllIIIlll[hashUtil.getCapacity()];
        this.entries = groups;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(code);
        stack.push(current);
        try {
            int len = code.length();
            for (int i = 1; i <= len; ++i) {
                current.setCurrent(i);
                Object key = exp.calculate(ctx);
                int hash = hashUtil.hashCode(key);
                llIlIlIlllIIIlll entry = groups[hash];
                while (entry != null) {
                    if (Variant.compare(entry._$3, key, true) == 0) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(Variant.toString(key) + mm.getMessage("engine.dupKeys"));
                    }
                    entry = entry._$1;
                }
                groups[hash] = new llIlIlIlllIIIlll(key, i, groups[hash]);
            }
        }
        finally {
            stack.pop();
        }
    }

    private static void _$1(llIlIlIlllIIIlll[] result, llIlIlIlllIIIlll[] entries, boolean checkDupKey) {
        int len = result.length;
        block0: for (int i = 0; i < len; ++i) {
            if (result[i] == null) {
                result[i] = entries[i];
                continue;
            }
            if (entries[i] == null) continue;
            llIlIlIlllIIIlll entry = entries[i];
            while (true) {
                llIlIlIlllIIIlll resultEntry = result[i];
                while (resultEntry != null) {
                    if (checkDupKey && Variant.isEquals(entry._$3, resultEntry._$3)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(Variant.toString(entry._$3) + mm.getMessage("engine.dupKeys"));
                    }
                    resultEntry = resultEntry._$1;
                }
                if (entry._$1 == null) {
                    entry._$1 = result[i];
                    result[i] = entries[i];
                    continue block0;
                }
                entry = entry._$1;
            }
        }
    }

    private static void _$1(llIlIlIlllIIIlll[] result, llIlIlIlllIIIlll[] entries) {
        int len = result.length;
        block0: for (int i = 0; i < len; ++i) {
            if (result[i] == null) {
                result[i] = entries[i];
                continue;
            }
            if (entries[i] == null) continue;
            llIlIlIlllIIIlll entry = result[i];
            while (true) {
                if (entry._$1 == null) {
                    entry._$1 = entries[i];
                    continue block0;
                }
                entry = entry._$1;
            }
        }
    }

    public void create(Sequence code, int field) {
        this.create(code, field, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Sequence code, int field, boolean checkDupKey) {
        this._$2 = code;
        int len = code.length();
        if (this._$1 && len > MultithreadUtil.SINGLE_PROSS_COUNT && Env.getParallelNum() > 1) {
            int threadCount = Env.getParallelNum();
            int singleCount = len / threadCount;
            lIIIIllllIlIlIlI[] jobs = new lIIIIllllIlIlIlI[threadCount];
            ThreadPool pool = ThreadPool.newInstance(threadCount);
            try {
                int i;
                int start = 1;
                for (i = 0; i < threadCount; ++i) {
                    if (i + 1 == threadCount) {
                        jobs[i] = new lIIIIllllIlIlIlI(this.hashUtil, code, field, start, len + 1, checkDupKey);
                    } else {
                        jobs[i] = new lIIIIllllIlIlIlI(this.hashUtil, code, field, start, start + singleCount, checkDupKey);
                        start += singleCount;
                    }
                    pool.submit(jobs[i]);
                }
                for (i = 0; i < threadCount; ++i) {
                    jobs[i].join();
                    if (this.entries == null) {
                        this.entries = jobs[i]._$1;
                        continue;
                    }
                    HashIndexTable._$1(this.entries, jobs[i]._$1, checkDupKey);
                }
            }
            finally {
                pool.shutdown();
            }
        } else {
            lIIIIllllIlIlIlI job = new lIIIIllllIlIlIlI(this.hashUtil, code, field, 1, len + 1, checkDupKey);
            job.run();
            this.entries = job._$1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create_i(Sequence code, int field) {
        this._$2 = code;
        int len = code.length();
        if (this._$1 && len > MultithreadUtil.SINGLE_PROSS_COUNT && Env.getParallelNum() > 1) {
            int threadCount = Env.getParallelNum();
            int singleCount = len / threadCount;
            lllIIIllIIIllIll[] jobs = new lllIIIllIIIllIll[threadCount];
            ThreadPool pool = ThreadPool.newInstance(threadCount);
            try {
                int i;
                int start = 1;
                for (i = 0; i < threadCount; ++i) {
                    if (i + 1 == threadCount) {
                        jobs[i] = new lllIIIllIIIllIll(this.hashUtil, code, field, start, len + 1);
                    } else {
                        jobs[i] = new lllIIIllIIIllIll(this.hashUtil, code, field, start, start + singleCount);
                        start += singleCount;
                    }
                    pool.submit(jobs[i]);
                }
                for (i = 0; i < threadCount; ++i) {
                    jobs[i].join();
                    if (this.entries == null) {
                        this.entries = jobs[i]._$1;
                        continue;
                    }
                    HashIndexTable._$1(this.entries, jobs[i]._$1);
                }
            }
            finally {
                pool.shutdown();
            }
        } else {
            lllIIIllIIIllIll job = new lllIIIllIIIllIll(this.hashUtil, code, field, 1, len + 1);
            job.run();
            this.entries = job._$1;
        }
    }

    public Object find(Object key) {
        int hash = this.hashUtil.hashCode(key);
        llIlIlIlllIIIlll entry = this.entries[hash];
        while (entry != null) {
            if (Variant.compare(entry._$3, key, true) == 0) {
                return this._$2.getMem(entry._$2);
            }
            entry = entry._$1;
        }
        return null;
    }

    public Object find(Object[] keys) {
        int hash = this.hashUtil.hashCode(keys[0]);
        llIlIlIlllIIIlll entry = this.entries[hash];
        while (entry != null) {
            if (Variant.compare(entry._$3, keys[0], true) == 0) {
                return this._$2.getMem(entry._$2);
            }
            entry = entry._$1;
        }
        return null;
    }

    public int findPos(Object key) {
        int hash = this.hashUtil.hashCode(key);
        llIlIlIlllIIIlll entry = this.entries[hash];
        while (entry != null) {
            if (Variant.compare(entry._$3, key, true) == 0) {
                return entry._$2;
            }
            entry = entry._$1;
        }
        return 0;
    }

    public int findPos(Object[] keys) {
        int hash = this.hashUtil.hashCode(keys[0]);
        llIlIlIlllIIIlll entry = this.entries[hash];
        while (entry != null) {
            if (Variant.compare(entry._$3, keys[0], true) == 0) {
                return entry._$2;
            }
            entry = entry._$1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table select(Expression exp, Context ctx) {
        Sequence code = this._$2;
        llIlIlIlllIIIlll[] entries = this.entries;
        int len = code.length();
        int capacity = entries.length;
        llIlIlIlllIIIlll[] resultEntries = new llIlIlIlllIIIlll[capacity];
        Table result = new Table(code.dataStruct(), len);
        IArray mems = result.getMems();
        int newLen = 0;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(code);
        stack.push(current);
        try {
            block3: for (int i = 0; i < capacity; ++i) {
                llIlIlIlllIIIlll entry = entries[i];
                while (entry != null) {
                    current.setCurrent(entry._$2);
                    Object b = exp.calculate(ctx);
                    if (Variant.isTrue(b)) {
                        llIlIlIlllIIIlll prev;
                        mems.add(current.getCurrent());
                        resultEntries[i] = prev = new llIlIlIlllIIIlll(entry._$3, ++newLen);
                        entry = entry._$1;
                        while (entry != null) {
                            current.setCurrent(entry._$2);
                            b = exp.calculate(ctx);
                            if (Variant.isTrue(b)) {
                                mems.add(current.getCurrent());
                                prev = prev._$1 = new llIlIlIlllIIIlll(entry._$3, ++newLen);
                            }
                            entry = entry._$1;
                        }
                        continue block3;
                    }
                    entry = entry._$1;
                }
            }
        }
        finally {
            stack.pop();
        }
        result.trimToSize();
        HashIndexTable indexTable = new HashIndexTable(result, this.hashUtil, resultEntries);
        result.setIndexTable(indexTable);
        return result;
    }

    public int[] findAllPos(IArray keys) {
        llIlIlIlllIIIlll[] entries = this.entries;
        HashUtil hashUtil = this.hashUtil;
        int len = keys.size();
        int[] pos = new int[len + 1];
        block0: for (int i = 1; i <= len; ++i) {
            int hash = hashUtil.hashCode(keys.hashCode(i));
            llIlIlIlllIIIlll entry = entries[hash];
            while (entry != null) {
                if (keys.isEquals(i, entry._$3)) {
                    pos[i] = entry._$2;
                    continue block0;
                }
                entry = entry._$1;
            }
        }
        return pos;
    }

    public int[] findAllPos(IArray[] keys) {
        return this.findAllPos(keys[0]);
    }

    public int[] findAllPos(IArray keys, BoolArray signArray) {
        llIlIlIlllIIIlll[] entries = this.entries;
        HashUtil hashUtil = this.hashUtil;
        int len = keys.size();
        int[] pos = new int[len + 1];
        block0: for (int i = 1; i <= len; ++i) {
            if (signArray.isFalse(i)) continue;
            int hash = hashUtil.hashCode(keys.hashCode(i));
            llIlIlIlllIIIlll entry = entries[hash];
            while (entry != null) {
                if (keys.isEquals(i, entry._$3)) {
                    pos[i] = entry._$2;
                    continue block0;
                }
                entry = entry._$1;
            }
        }
        return pos;
    }

    public int[] findAllPos(IArray[] keys, BoolArray signArray) {
        return this.findAllPos(keys[0], signArray);
    }

    public void findPos(Object key, IntArray out) {
        int hash = this.hashUtil.hashCode(key);
        llIlIlIlllIIIlll entry = this.entries[hash];
        while (entry != null) {
            if (Variant.compare(entry._$3, key, true) == 0) {
                out.addInt(entry._$2);
            }
            entry = entry._$1;
        }
    }

    public void findPos(Object[] keys, IntArray out) {
        int hash = this.hashUtil.hashCode(keys[0]);
        llIlIlIlllIIIlll entry = this.entries[hash];
        while (entry != null) {
            if (Variant.compare(entry._$3, keys[0], true) == 0) {
                out.addInt(entry._$2);
            }
            entry = entry._$1;
        }
    }

    public int[] findAllFirstPos(IArray keys) {
        llIlIlIlllIIIlll[] entries = this.entries;
        HashUtil hashUtil = this.hashUtil;
        int len = keys.size();
        int[] pos = new int[len + 1];
        block0: for (int i = 1; i <= len; ++i) {
            int hash = hashUtil.hashCode(keys.hashCode(i));
            llIlIlIlllIIIlll entry = entries[hash];
            while (entry != null) {
                if (keys.isEquals(i, entry._$3)) {
                    pos[i] = entry._$2;
                    continue block0;
                }
                entry = entry._$1;
            }
        }
        return pos;
    }

    public int[] findAllFirstPos(IArray[] keys) {
        return this.findAllFirstPos(keys[0]);
    }

    public int[] findAllFirstPos(IArray keys, BoolArray signArray) {
        llIlIlIlllIIIlll[] entries = this.entries;
        HashUtil hashUtil = this.hashUtil;
        int len = keys.size();
        int[] pos = new int[len + 1];
        block0: for (int i = 1; i <= len; ++i) {
            if (signArray.isFalse(i)) continue;
            int hash = hashUtil.hashCode(keys.hashCode(i));
            llIlIlIlllIIIlll entry = entries[hash];
            while (entry != null) {
                if (keys.isEquals(i, entry._$3)) {
                    pos[i] = entry._$2;
                    continue block0;
                }
                entry = entry._$1;
            }
        }
        return pos;
    }

    public int[] findAllFirstPos(IArray[] keys, BoolArray signArray) {
        return this.findAllFirstPos(keys[0], signArray);
    }
}

