/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.common.RQException;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.expression.Expression;
import com.scudata.thread.Job;
import com.scudata.util.HashUtil;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IlllIlllIIlIlIII
extends Job {
    protected ICursor cursor;
    protected int fetchCount;
    protected boolean isClosed;
    protected Expression[] exps;
    protected int keyCount;
    protected Context ctx;
    protected HashUtil hashUtil;
    protected int[] hashCodes;
    protected Queue<Object[]> readyDatas;
    protected int maxCacheSize;

    public IlllIlllIIlIlIII(ICursor cursor, int fetchCount, Expression[] exps, HashUtil hashUtil, Context ctx, int maxCacheSize, Queue<Object[]> readyDatas) {
        this.cursor = cursor;
        this.fetchCount = fetchCount;
        this.hashUtil = hashUtil;
        this.ctx = ctx;
        this.exps = exps;
        this.keyCount = exps.length;
        this.hashCodes = new int[this.keyCount];
        this.maxCacheSize = maxCacheSize;
        this.readyDatas = readyDatas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HashUtil hashUtil = this.hashUtil;
        ICursor cursor = this.cursor;
        Context ctx = this.ctx;
        Expression[] exps = this.exps;
        int keyCount = this.keyCount;
        while (true) {
            Sequence table;
            if ((table = cursor.fuzzyFetch(this.fetchCount)) == null) {
                this.isClosed = true;
                return;
            }
            Object[] data = new Object[3];
            data[0] = table;
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(table);
            stack.push(current);
            try {
                int len = table.length();
                int[] hash = new int[len + 1];
                if (keyCount == 1) {
                    IArray array = exps[0].calculateAll(ctx);
                    for (int i = 1; i <= len; ++i) {
                        hash[i] = hashUtil.hashCode(array.hashCode(i));
                    }
                    data[1] = array;
                } else {
                    IArray[] arrays = new IArray[keyCount];
                    int[] hashCodes = this.hashCodes;
                    for (int k = 0; k < keyCount; ++k) {
                        arrays[k] = exps[k].calculateAll(ctx);
                    }
                    for (int i = 1; i <= len; ++i) {
                        for (int k = 0; k < keyCount; ++k) {
                            hashCodes[k] = arrays[k].hashCode(i);
                        }
                        hash[i] = hashUtil.hashCode(hashCodes, keyCount);
                    }
                    data[1] = arrays;
                }
                data[2] = new IntArray(hash, null, len);
            }
            finally {
                stack.pop();
            }
            while (this.readyDatas.size() > this.maxCacheSize) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    throw new RQException(e);
                }
            }
            Queue<Object[]> queue = this.readyDatas;
            synchronized (queue) {
                this.readyDatas.add(data);
            }
        }
    }

    public ICursor getCursor() {
        return this.cursor;
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

