/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

public final class KeyWord {
    public static final String SUBCODEBLOCK = "??";
    public static final String ARGPREFIX = "?";
    public static final char OPTION = '@';
    public static final String CURRENTELEMENT = "~";
    public static final String CURRENTSEQ = "#";
    public static final String ITERATEPARAM = "~~";
    public static final String FIELDIDPREFIX = "#";
    public static final String CURRENTCELL = "@";
    public static final String CURRENTCELLSEQ = "#@";
    public static final char CELLPREFIX = '#';
    public static final String CONSTSTRINGPREFIX = "'";

    public static boolean isSymbol(char c) {
        return Character.isWhitespace(c) || c == '+' || c == '-' || c == '*' || c == '/' || c == '%' || c == '=' || c == '&' || c == '|' || c == '!' || c == '\\' || c == ',' || c == '>' || c == '<' || c == '(' || c == ')' || c == '[' || c == ']' || c == ':' || c == '{' || c == '}' || c == '^' || c == '.' || c == '\"' || c == '\'' || c == ';';
    }

    public static boolean isSubCodeBlock(String id) {
        return SUBCODEBLOCK.equals(id);
    }

    public static boolean isCurrentElement(String id) {
        return CURRENTELEMENT.equals(id);
    }

    public static boolean isCurrentSeq(String id) {
        return "#".equals(id);
    }

    public static boolean isCurrentCell(String id) {
        return CURRENTCELL.equals(id);
    }

    public static boolean isCurrentCellSeq(String id) {
        return CURRENTCELLSEQ.equals(id);
    }

    public static boolean isIterateParam(String id) {
        return ITERATEPARAM.equals(id);
    }

    public static boolean isFieldId(String id) {
        if (id == null || id.length() < 2 || !id.startsWith("#")) {
            return false;
        }
        int len = id.length();
        for (int i = 1; i < len; ++i) {
            char c = id.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isElementId(String id) {
        if (id == null || id.length() < 2 || !id.startsWith(CURRENTELEMENT)) {
            return false;
        }
        int len = id.length();
        for (int i = 1; i < len; ++i) {
            char c = id.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static int getFiledId(String id) {
        return Integer.parseInt(id.substring("#".length()));
    }

    public static boolean isArg(String id) {
        if (id == null || !id.startsWith(ARGPREFIX)) {
            return false;
        }
        int len = id.length();
        for (int i = 1; i < len; ++i) {
            char c = id.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static int scanId(String expStr, int start) {
        int len = expStr.length();
        while (start < len && !KeyWord.isSymbol(expStr.charAt(start))) {
            ++start;
        }
        return start;
    }

    public static String[] parseStringOptions(String[] strs) {
        int size = strs.length;
        String[] opts = new String[size];
        for (int i = 0; i < size; ++i) {
            int optIndex;
            String tmp = strs[i];
            if (tmp == null || (optIndex = tmp.indexOf(64)) == -1) continue;
            strs[i] = tmp.substring(0, optIndex);
            opts[i] = tmp.substring(optIndex + 1);
        }
        return opts;
    }
}

