/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.dm.Context;
import com.scudata.dm.IResource;

class LockObject
implements IResource {
    private volatile Thread thread;

    public LockObject(Context ctx) {
    }

    @Override
    public synchronized void close() {
        if (this.thread != null) {
            this.thread = null;
            this.notify();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean lock(long ms, Context ctx) {
        Thread cur = Thread.currentThread();
        if (this.thread == null) {
            this.thread = cur;
            ctx.addResource(this);
            return true;
        }
        if (this.thread == cur) {
            return false;
        }
        try {
            if (ms >= 0L) {
                this.wait(ms);
                if (this.thread != null) {
                    return false;
                }
            } else {
                do {
                    this.wait();
                } while (this.thread != null);
            }
            this.thread = cur;
            ctx.addResource(this);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized boolean unlock(Context ctx) {
        if (this.thread == null) {
            return true;
        }
        if (this.thread != Thread.currentThread()) {
            return false;
        }
        this.thread = null;
        ctx.removeResource(this);
        this.notify();
        return true;
    }
}

