/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.ibm.icu.text.Collator;
import com.scudata.array.BoolArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.NumberArray;
import com.scudata.array.ObjectArray;
import com.scudata.cellset.ICellSet;
import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.ByteArrayOutputRecord;
import com.scudata.common.Escape;
import com.scudata.common.IRecord;
import com.scudata.common.IntArrayList;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.DataStruct;
import com.scudata.dm.HashArrayIndexTable;
import com.scudata.dm.HashIndexTable;
import com.scudata.dm.IIlIllIlIIIlIlII;
import com.scudata.dm.IndexTable;
import com.scudata.dm.ListBase1;
import com.scudata.dm.MergeIndexTable;
import com.scudata.dm.Param;
import com.scudata.dm.Record;
import com.scudata.dm.Region;
import com.scudata.dm.Regions;
import com.scudata.dm.SeqIndexTable;
import com.scudata.dm.Table;
import com.scudata.dm.TimeIndexTable;
import com.scudata.dm.comparator.ArrayComparator;
import com.scudata.dm.comparator.ArrayComparator2;
import com.scudata.dm.comparator.BaseComparator;
import com.scudata.dm.comparator.CommonComparator;
import com.scudata.dm.comparator.DescComparator;
import com.scudata.dm.comparator.LocaleComparator;
import com.scudata.dm.comparator.PSortComparator;
import com.scudata.dm.comparator.PSortItem;
import com.scudata.dm.comparator.RecordFieldComparator;
import com.scudata.dm.comparator.RecordKeyComparator;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dm.op.IGroupsResult;
import com.scudata.dm.op.Join;
import com.scudata.dm.op.Operation;
import com.scudata.dm.op.PrimaryJoin;
import com.scudata.dm.op.Switch;
import com.scudata.dm.op.SwitchRemote;
import com.scudata.dw.IFilter;
import com.scudata.expression.CurrentElement;
import com.scudata.expression.Expression;
import com.scudata.expression.FieldId;
import com.scudata.expression.FieldRef;
import com.scudata.expression.Function;
import com.scudata.expression.Gather;
import com.scudata.expression.Node;
import com.scudata.expression.UnknownSymbol;
import com.scudata.expression.ValueList;
import com.scudata.expression.fn.gather.ICount;
import com.scudata.expression.operator.And;
import com.scudata.expression.operator.DotOperator;
import com.scudata.expression.operator.Equals;
import com.scudata.expression.operator.Greater;
import com.scudata.expression.operator.NotEquals;
import com.scudata.expression.operator.NotGreater;
import com.scudata.expression.operator.NotSmaller;
import com.scudata.expression.operator.Or;
import com.scudata.expression.operator.Smaller;
import com.scudata.parallel.ClusterMemoryTable;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.MultithreadUtil;
import com.scudata.util.CursorUtil;
import com.scudata.util.HashUtil;
import com.scudata.util.MaxHeap;
import com.scudata.util.MinHeap;
import com.scudata.util.Variant;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sequence
implements Externalizable,
IRecord,
Comparable<Sequence> {
    private static final long serialVersionUID = 33619971L;
    protected IArray mems;
    private static final char _$4 = ',';
    private static final char _$3 = '[';
    private static final char _$2 = ']';
    private static final int _$1 = 700;

    public Sequence() {
        this.mems = new ObjectArray(8);
    }

    protected Sequence(boolean createArray) {
        if (createArray) {
            this.mems = new ObjectArray(8);
        }
    }

    public Sequence(int initialCapacity) {
        this.mems = new ObjectArray(initialCapacity);
    }

    public Sequence(Object[] v) {
        this.mems = v == null ? new ObjectArray(10) : new ObjectArray(v);
    }

    public Sequence(Sequence seq) {
        this.mems = seq == null ? new ObjectArray(0) : seq.getMems().dup();
    }

    public Sequence(IArray array) {
        this.mems = array == null ? new ObjectArray(0) : array;
    }

    public Sequence(int start, int end) {
        if (start < end) {
            ObjectArray mems = new ObjectArray(end - start + 1);
            this.mems = mems;
            while (start <= end) {
                mems.add(ObjectCache.getInteger(start));
                ++start;
            }
        } else {
            ObjectArray mems = new ObjectArray(start - end + 1);
            this.mems = mems;
            while (start >= end) {
                mems.add(ObjectCache.getInteger(start));
                --start;
            }
        }
    }

    public Sequence(long start, long end) {
        if (start < end) {
            long len = end - start + 1L;
            if (len > Integer.MAX_VALUE) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("to" + mm.getMessage("function.invalidParam"));
            }
            ObjectArray mems = new ObjectArray((int)len);
            this.mems = mems;
            while (start <= end) {
                mems.add(new Long(start));
                ++start;
            }
        } else {
            long len = start - end + 1L;
            if (len > Integer.MAX_VALUE) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("to" + mm.getMessage("function.invalidParam"));
            }
            ObjectArray mems = new ObjectArray((int)len);
            this.mems = mems;
            while (start >= end) {
                mems.add(new Long(start));
                --start;
            }
        }
    }

    public IArray getMems() {
        return this.mems;
    }

    public IArray getCurrentMems() {
        return this.mems;
    }

    public void setMems(IArray mems) {
        this.mems = mems;
        this.rebuildIndexTable();
    }

    public int hashCode() {
        IArray mems = this.getMems();
        int size = mems.size();
        if (size == 0) {
            return 0;
        }
        int hash = mems.hashCode(1);
        for (int i = 2; i <= size; ++i) {
            hash = 31 * hash + mems.hashCode(i);
        }
        return hash;
    }

    public void ensureCapacity(int minCapacity) {
        this.getMems().ensureCapacity(minCapacity);
    }

    public int firstIndexOf(Object obj) {
        return this.getMems().firstIndexOf(obj, 1);
    }

    public int lastIndexof(Object obj) {
        return this.getMems().lastIndexOf(obj, this.length());
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputRecord out = new ByteArrayOutputRecord();
        IArray mems = this.mems;
        if (mems instanceof ObjectArray) {
            out.writeRecord(mems);
        } else {
            out.writeByte(-1);
            out.writeObject(mems, true);
        }
        return out.toByteArray();
    }

    @Override
    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        ByteArrayInputRecord in = new ByteArrayInputRecord(buf);
        if (buf[0] != -1) {
            this.mems = new ObjectArray();
            in.readRecord(this.mems);
        } else {
            in.readByte();
            in.readObject(true);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.getMems());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        Object obj = in.readObject();
        if (obj instanceof IArray) {
            this.mems = (IArray)obj;
        } else {
            ListBase1 list = (ListBase1)obj;
            this.mems = new ObjectArray(list._$1(), list.size());
        }
    }

    public void reset() {
        this.getMems().clear();
    }

    public void clear() {
        this.getMems().clear();
    }

    public void trimToSize() {
        this.getMems().trimToSize();
    }

    public Sequence transpose(int c) {
        IArray mems = this.getMems();
        int len = mems.size();
        int r = len / c;
        if (len % c != 0) {
            ++r;
        }
        Sequence result = new Sequence(len);
        IArray resultMems = result.getMems();
        for (int i = 1; i <= c; ++i) {
            for (int j = 0; j < r; ++j) {
                int index = j * c + i;
                if (index <= len) {
                    resultMems.add(mems.get(index));
                    continue;
                }
                resultMems.add(null);
            }
        }
        return result;
    }

    public int length() {
        return this.getMems().size();
    }

    public int count() {
        return this.getMems().count();
    }

    public Sequence step(int interval, int[] seqs) {
        if (interval < 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(interval + mm.getMessage("engine.indexOutofBound"));
        }
        int count = seqs.length;
        for (int i = 0; i < count; ++i) {
            if (seqs[i] >= 1) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(seqs[i] + mm.getMessage("engine.indexOutofBound"));
        }
        IArray mems = this.getMems();
        int srcLen = mems.size();
        Sequence result = new Sequence((srcLen / interval + 1) * count);
        IArray resultMems = result.getMems();
        int base = 0;
        while (true) {
            boolean addOne = false;
            for (int i = 0; i < count; ++i) {
                int seq = base + seqs[i];
                if (seq > srcLen) continue;
                resultMems.add(mems.get(seq));
                addOne = true;
            }
            if (!addOne) break;
            base += interval;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(Expression exp, Context ctx) {
        int size;
        if (exp == null) {
            return this.count();
        }
        int count = size = this.length();
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            for (int i = 1; i <= size; ++i) {
                current.setCurrent(i);
                Object obj = exp.calculate(ctx);
                if (!Variant.isFalse(obj)) continue;
                --count;
            }
        }
        finally {
            stack.pop();
        }
        return count;
    }

    public Object[] toArray() {
        return this.getMems().toArray();
    }

    public Object[] toArray(Object[] a) {
        this.getMems().toArray(a);
        return a;
    }

    public Object get(int seq) {
        if (seq < 1 || seq > this.length()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(seq + mm.getMessage("engine.indexOutofBound"));
        }
        return this.mems.get(seq);
    }

    public Object getMem(int seq) {
        return this.mems.get(seq);
    }

    public Object getCurrent(int seq) {
        return this.mems.get(seq);
    }

    public Sequence get(int start, int end) {
        return new Sequence(this.getMems().get(start, end));
    }

    public Sequence get(Sequence seq) {
        if (seq == null || seq.length() == 0) {
            return new Sequence(0);
        }
        int[] posArray = seq.toIntArray();
        IArray result = this.getMems().get(posArray);
        return new Sequence(result);
    }

    public boolean contains(Object obj, boolean isSorted) {
        if (isSorted) {
            return this.getMems().binarySearch(obj) > 0;
        }
        return this.getMems().contains(obj);
    }

    public void contains(boolean isSorted, IArray array, BoolArray result) {
        this.getMems().contains(isSorted, array, result);
    }

    private boolean _$3() {
        IArray mems = this.getMems();
        int size = mems.size();
        if (size == 0) {
            return false;
        }
        Object obj1 = mems.get(1);
        if (!(obj1 instanceof Number)) {
            return false;
        }
        if (size == 1) {
            return true;
        }
        Object obj2 = mems.get(2);
        if (!(obj2 instanceof Number)) {
            return false;
        }
        int prev = ((Number)obj2).intValue();
        int dif = prev - ((Number)obj1).intValue();
        if (dif == 1) {
            for (int i = 3; i <= size; ++i) {
                Object obj = mems.get(i);
                if (!(obj instanceof Number)) {
                    return false;
                }
                if (((Number)obj).intValue() == ++prev) continue;
                return false;
            }
        } else if (dif == -1) {
            for (int i = 3; i <= size; ++i) {
                Object obj = mems.get(i);
                if (!(obj instanceof Number)) {
                    return false;
                }
                if (((Number)obj).intValue() == --prev) continue;
                return false;
            }
        } else if (dif == 0) {
            if (size != 2) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean _$1(int n) {
        IArray mems = this.getMems();
        int len = mems.size();
        if (len != n) {
            return false;
        }
        boolean[] sign = new boolean[n + 1];
        for (int i = 1; i <= len; ++i) {
            Object obj = mems.get(i);
            if (!(obj instanceof Number)) {
                return false;
            }
            int tmp = ((Number)obj).intValue();
            if (tmp < 1 || tmp > n || sign[tmp]) {
                return false;
            }
            sign[tmp] = true;
        }
        return true;
    }

    public boolean hasRecord() {
        return this.getMems().hasRecord();
    }

    public boolean isPmt() {
        return this.getMems().isPmt(false);
    }

    public boolean isPurePmt() {
        return this.getMems().isPmt(true);
    }

    public Sequence inv(int n) {
        if (n < 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("inv" + mm.getMessage("function.invalidParam"));
        }
        IArray mems = this.getMems();
        Object[] seqs = new Integer[n];
        int len = mems.size();
        for (int i = 1; i <= len; ++i) {
            Object obj = mems.get(i);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needIntSeries"));
            }
            int pos = ((Number)obj).intValue();
            if (pos <= 0 || pos > n || seqs[pos - 1] != null) continue;
            seqs[pos - 1] = ObjectCache.getInteger(i);
        }
        Integer int0 = ObjectCache.getInteger(0);
        for (int i = 0; i < n; ++i) {
            if (seqs[i] != null) continue;
            seqs[i] = int0;
        }
        return new Sequence(seqs);
    }

    public Sequence inv(Sequence seq, String opt) {
        boolean isNew;
        IArray mems = this.getMems();
        IArray posMems = seq.getMems();
        int n = mems.size();
        int len = posMems.size();
        boolean bl = isNew = opt == null || opt.indexOf(111) == -1;
        if (!isNew && this instanceof Table && !seq._$1(n)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("inv" + mm.getMessage("function.invalidParam"));
        }
        Object[] objs = new Object[n];
        for (int i = 1; i <= len; ++i) {
            Object obj = posMems.get(i);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needIntSeries"));
            }
            int pos = ((Number)obj).intValue();
            if (pos <= 0 || pos > n) continue;
            objs[pos - 1] = mems.get(i);
        }
        if (isNew) {
            return new Sequence(objs);
        }
        mems.clear();
        mems.addAll(objs);
        return this;
    }

    public boolean isPeq(Sequence seq) {
        int size2;
        if (seq == null) {
            return false;
        }
        IArray mems = this.getMems();
        IArray mems2 = seq.getMems();
        int size = mems.size();
        if (size != (size2 = mems2.size())) {
            return false;
        }
        boolean[] founds = new boolean[size + 1];
        for (int t = 1; t <= size2; ++t) {
            block5: {
                Object obj = mems2.get(t);
                for (int s = 1; s <= size; ++s) {
                    if (founds[s] || !Variant.isEquals(mems.get(s), obj)) {
                        continue;
                    }
                    break block5;
                }
                return false;
            }
            founds[s] = true;
        }
        return true;
    }

    public Sequence rvs() {
        return new Sequence(this.getMems().rvs());
    }

    public Sequence psort(String opt) {
        IArray mems = this.getMems();
        int size = mems.size();
        if (size == 0) {
            return new Sequence(0);
        }
        boolean isDesc = false;
        boolean isNullLast = false;
        if (opt != null) {
            if (opt.indexOf(122) != -1) {
                isDesc = true;
            }
            if (opt.indexOf(48) != -1) {
                isNullLast = true;
            }
        }
        int len = size + 1;
        Object[] infos = new PSortItem[len];
        for (int i = 1; i < len; ++i) {
            infos[i] = new PSortItem(i, mems.get(i));
        }
        Comparator<Object> comparator = isNullLast || isDesc ? new CommonComparator(null, !isDesc, isNullLast) : new BaseComparator();
        MultithreadUtil.sort(infos, 1, len, new PSortComparator(comparator));
        Sequence result = new Sequence(size);
        IArray resultMems = result.getMems();
        for (int i = 1; i < len; ++i) {
            resultMems.add(((PSortItem)infos[i]).index);
        }
        return result;
    }

    public Sequence psort(Expression exp, String opt, Context ctx) {
        return this.calc(exp, opt, ctx).psort(opt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence psort(Expression[] exps, String opt, Context ctx) {
        Comparator<Object> comparator;
        IArray mems = this.getMems();
        int len = mems.size();
        if (len == 0) {
            return new Sequence(0);
        }
        boolean isDesc = false;
        boolean isNullLast = false;
        if (opt != null) {
            if (opt.indexOf(122) != -1) {
                isDesc = true;
            }
            if (opt.indexOf(48) != -1) {
                isNullLast = true;
            }
        }
        Object[][] values = new Object[len + 1][];
        int fcount = exps.length;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            int arrayLen = fcount + 1;
            for (int i = 1; i <= len; ++i) {
                current.setCurrent(i);
                Object[] curVals = new Object[arrayLen];
                values[i] = curVals;
                curVals[fcount] = i;
                for (int f = 0; f < fcount; ++f) {
                    curVals[f] = exps[f].calculate(ctx);
                }
            }
        }
        finally {
            stack.pop();
        }
        if (isDesc || isNullLast) {
            CommonComparator cmp = new CommonComparator(null, !isDesc, isNullLast);
            CommonComparator[] cmps = new CommonComparator[fcount];
            for (int i = 0; i < fcount; ++i) {
                cmps[i] = cmp;
            }
            comparator = new ArrayComparator2(cmps, fcount);
        } else {
            comparator = new ArrayComparator(fcount);
        }
        MultithreadUtil.sort((Object[])values, 1, values.length, comparator);
        Sequence result = new Sequence(len);
        mems = result.getMems();
        for (int i = 1; i <= len; ++i) {
            mems.add(values[i][fcount]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence psort(Expression[] exps, int[] orders, String opt, Context ctx) {
        if (this.length() == 0) {
            return new Sequence(0);
        }
        if (exps == null || orders == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("psort" + mm.getMessage("function.paramValNull"));
        }
        IArray mems = this.getMems();
        int len = mems.size();
        Object[][] values = new Object[len + 1][];
        int fcount = exps.length;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            int arrayLen = fcount + 1;
            for (int i = 1; i <= len; ++i) {
                current.setCurrent(i);
                Object[] curVals = new Object[arrayLen];
                values[i] = curVals;
                curVals[fcount] = i;
                for (int f = 0; f < fcount; ++f) {
                    curVals[f] = exps[f].calculate(ctx);
                }
            }
        }
        finally {
            stack.pop();
        }
        boolean isNullLast = opt != null && opt.indexOf(48) != -1;
        CommonComparator[] cmps = new CommonComparator[fcount];
        for (int i = 0; i < fcount; ++i) {
            cmps[i] = new CommonComparator(null, orders[i] >= 0, isNullLast);
        }
        ArrayComparator2 comparator = new ArrayComparator2(cmps, fcount);
        MultithreadUtil.sort((Object[])values, 1, values.length, comparator);
        Sequence result = new Sequence(len);
        mems = result.getMems();
        for (int i = 1; i <= len; ++i) {
            mems.add(values[i][fcount]);
        }
        return result;
    }

    public Sequence sort(String opt) {
        if (this.length() == 0) {
            if (this instanceof Table || opt != null && opt.indexOf(111) != -1) {
                return this;
            }
            return new Sequence(0);
        }
        boolean isDesc = false;
        boolean isOrg = false;
        boolean isNullLast = false;
        if (opt != null) {
            if (opt.indexOf(117) != -1) {
                return this._$2();
            }
            if (opt.indexOf(122) != -1) {
                isDesc = true;
            }
            if (opt.indexOf(111) != -1) {
                isOrg = true;
            }
            if (opt.indexOf(48) != -1) {
                isNullLast = true;
            }
            if (opt.indexOf(110) != -1) {
                Sequence seq = this._$1("s");
                if (isOrg) {
                    this.mems = seq.getMems();
                    return this;
                }
                return seq;
            }
        }
        Comparator<Object> comparator = isDesc || isNullLast ? new CommonComparator(null, !isDesc, isNullLast) : new BaseComparator();
        if (isOrg) {
            this.mems.sort(comparator);
            return this;
        }
        Sequence result = new Sequence(this);
        result.mems.sort(comparator);
        return result;
    }

    private static Locale _$2(String loc) {
        int index2;
        int index = loc.indexOf(95);
        if (index == -1) {
            return new Locale(loc);
        }
        String language = loc.substring(0, index);
        if ((index2 = loc.indexOf(95, ++index)) == -1) {
            String country = loc.substring(index);
            return new Locale(language, country);
        }
        String country = loc.substring(index, index2);
        String variant = loc.substring(index2 + 1);
        return new Locale(language, country, variant);
    }

    public Sequence sort(String loc, String opt) {
        if (this.length() == 0) {
            if (this instanceof Table || opt != null && opt.indexOf(111) != -1) {
                return this;
            }
            return new Sequence(0);
        }
        boolean isDesc = false;
        boolean isOrg = false;
        boolean isNullLast = false;
        if (opt != null) {
            if (opt.indexOf(117) != -1) {
                return this._$2();
            }
            if (opt.indexOf(122) != -1) {
                isDesc = true;
            }
            if (opt.indexOf(111) != -1) {
                isOrg = true;
            }
            if (opt.indexOf(48) != -1) {
                isNullLast = true;
            }
            if (opt.indexOf(110) != -1) {
                Sequence seq = this._$1("s");
                if (isOrg) {
                    this.mems = seq.getMems();
                    return this;
                }
                return seq;
            }
        }
        Collator collator = null;
        if (loc != null && loc.length() != 0) {
            Locale locale = Sequence._$2(loc);
            collator = Collator.getInstance((Locale)locale);
        }
        Comparator<Object> comparator = collator != null || isDesc || isNullLast ? new CommonComparator(collator, !isDesc, isNullLast) : new BaseComparator();
        if (isOrg) {
            this.mems.sort(comparator);
            return this;
        }
        Sequence result = new Sequence(this);
        result.mems.sort(comparator);
        return result;
    }

    private Sequence _$2() {
        IArray mems = this.getMems();
        int len = mems.size();
        if (len == 0) {
            return new Sequence(0);
        }
        Sequence result = new Sequence(len);
        IArray rm = result.getMems();
        boolean[] signs = new boolean[len + 1];
        for (int i = 1; i <= len; ++i) {
            if (signs[i]) continue;
            Object obj = mems.get(i);
            rm.add(obj);
            for (int j = i + 1; j <= len; ++j) {
                Object obj2 = mems.get(j);
                if (signs[j] || !Variant.isEquals(obj, obj2)) continue;
                signs[j] = true;
                rm.add(obj2);
            }
        }
        return result;
    }

    private Sequence _$1(Expression exp, Context ctx) {
        IArray mems = this.getMems();
        int len = mems.size();
        Sequence values = this.calc(exp, ctx);
        IArray valMems = values.getMems();
        Sequence result = new Sequence(len);
        IArray rm = result.getMems();
        boolean[] signs = new boolean[len + 1];
        for (int i = 1; i <= len; ++i) {
            if (signs[i]) continue;
            Object obj = valMems.get(i);
            rm.add(mems.get(i));
            for (int j = i + 1; j <= len; ++j) {
                if (signs[j] || !Variant.isEquals(obj, valMems.get(j))) continue;
                signs[j] = true;
                rm.add(mems.get(j));
            }
        }
        return result;
    }

    private Sequence _$2(Expression[] exps, Context ctx) {
        if (exps == null || exps.length == 0) {
            return this._$2();
        }
        if (exps.length == 1) {
            return this._$1(exps[0], ctx);
        }
        int len = this.length();
        if (len == 0) {
            return new Sequence(0);
        }
        Sequence result = this;
        int fcount = exps.length;
        IArray[] valMems = new IArray[fcount];
        for (int f = 0; f < fcount; ++f) {
            Sequence tmp = new Sequence(len);
            IArray tmpMems = tmp.getMems();
            IArray mems = result.getMems();
            boolean[] signs = new boolean[len + 1];
            for (int c = 0; c <= f; ++c) {
                valMems[c] = result.calc(exps[c], ctx).getMems();
            }
            for (int i = 1; i <= len; ++i) {
                if (signs[i]) continue;
                tmpMems.add(mems.get(i));
                block3: for (int j = i + 1; j <= len; ++j) {
                    if (signs[j]) continue;
                    for (int c = 0; c <= f; ++c) {
                        if (!Variant.isEquals(valMems[c].get(i), valMems[c].get(j))) continue block3;
                    }
                    signs[j] = true;
                    tmpMems.add(mems.get(j));
                }
            }
            result = tmp;
        }
        return result;
    }

    public Object lookup(Sequence[] sequences, Object[] vals, String opt) {
        if (sequences == null || vals == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("lookup" + mm.getMessage("function.invalidParam"));
        }
        int gcount = sequences.length;
        if (gcount == 0 || gcount != vals.length) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("lookup" + mm.getMessage("function.invalidParam"));
        }
        boolean bAll = opt != null && opt.indexOf(97) != -1;
        int srcLen = sequences[0].length();
        if (srcLen == 0) {
            return bAll ? new Sequence(0) : null;
        }
        Sequence seq = (Sequence)sequences[0].pos(vals[0], "a");
        if (seq.length() == 0) {
            return bAll ? new Sequence(0) : null;
        }
        for (int i = 1; i < gcount; ++i) {
            srcLen = sequences[i].length();
            if (srcLen < 1) {
                return bAll ? new Sequence(0) : null;
            }
            Sequence tmp = (Sequence)sequences[i].pos(vals[i], "a");
            if ((seq = seq.isect(tmp, true)).length() != 0) continue;
            return bAll ? new Sequence(0) : null;
        }
        IArray posMems = seq.getMems();
        IArray mems = this.getMems();
        int len = mems.size();
        if (bAll) {
            int posCount = posMems.size();
            Sequence result = new Sequence(posCount);
            for (int i = 1; i <= posCount; ++i) {
                int pos = (Integer)posMems.get(i);
                if (pos <= len) {
                    result.add(mems.get(pos));
                    continue;
                }
                result.add(null);
            }
            return result;
        }
        int pos = (Integer)posMems.get(1);
        if (pos <= len) {
            return mems.get(pos);
        }
        return null;
    }

    public Sequence conj(Sequence seq, int resultCapacity) {
        IArray resultMems;
        IArray mems = this.getMems();
        IArray mems2 = seq.getMems();
        if (mems.getClass() == mems2.getClass()) {
            resultMems = mems.newInstance(resultCapacity);
            resultMems.addAll(mems);
            resultMems.addAll(mems2);
        } else {
            resultMems = new ObjectArray(resultCapacity);
            resultMems.addAll(mems);
            resultMems.addAll(mems2);
        }
        return new Sequence(resultMems);
    }

    public Sequence conj(Sequence seq, boolean bMerge) {
        Sequence result;
        if (seq == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("conj" + mm.getMessage("function.paramValNull"));
        }
        IArray mems = this.getMems();
        IArray mems2 = seq.getMems();
        int len = mems.size();
        int len2 = mems2.size();
        if (bMerge) {
            result = new Sequence(len + len2);
            IArray resultMems = result.getMems();
            int s = 1;
            int t = 1;
            while (s <= len && t <= len2) {
                Object obj2;
                Object obj = mems.get(s);
                if (Variant.compare(obj, obj2 = mems2.get(t), true) > 0) {
                    resultMems.add(obj2);
                    ++t;
                    continue;
                }
                resultMems.add(obj);
                ++s;
            }
            while (s <= len) {
                resultMems.add(mems.get(s));
                ++s;
            }
            while (t <= len2) {
                resultMems.add(mems2.get(t));
                ++t;
            }
        } else if (mems.getClass() == mems2.getClass()) {
            IArray resultMems = mems.newInstance(len + len2);
            resultMems.addAll(mems);
            resultMems.addAll(mems2);
            result = new Sequence(resultMems);
        } else {
            result = new Sequence(len + len2);
            IArray resultMems = result.getMems();
            resultMems.addAll(mems);
            resultMems.addAll(mems2);
        }
        return result;
    }

    public Sequence diff(Sequence seq, boolean bMerge) {
        if (seq == null || seq.length() == 0) {
            return new Sequence(this);
        }
        if (!bMerge) {
            return CursorUtil.diff(this, seq);
        }
        IArray mems = this.getMems();
        IArray mems2 = seq.getMems();
        int len = mems.size();
        int len2 = mems2.size();
        Sequence result = new Sequence(len);
        IArray resultMems = result.getMems();
        int s = 1;
        int t = 1;
        while (s <= len && t <= len2) {
            Object obj = mems.get(s);
            int cmp = Variant.compare(obj, mems2.get(t), true);
            if (cmp < 0) {
                resultMems.add(obj);
                ++s;
                continue;
            }
            if (cmp == 0) {
                ++t;
                ++s;
                continue;
            }
            ++t;
        }
        while (s <= len) {
            resultMems.add(mems.get(s));
            ++s;
        }
        return result;
    }

    public Sequence isect(Sequence seq, boolean bMerge) {
        int len2;
        if (seq == null || seq.length() == 0) {
            return new Sequence();
        }
        if (!bMerge) {
            return CursorUtil.isect(this, seq);
        }
        IArray mems = this.getMems();
        IArray mems2 = seq.getMems();
        int len = mems.size();
        Sequence result = new Sequence(len > (len2 = mems2.size()) ? len2 : len);
        IArray resultMems = result.getMems();
        int s = 1;
        int t = 1;
        while (s <= len && t <= len2) {
            Object obj = mems.get(s);
            int cmp = Variant.compare(obj, mems2.get(t), true);
            if (cmp < 0) {
                ++s;
                continue;
            }
            if (cmp == 0) {
                resultMems.add(obj);
                ++t;
                ++s;
                continue;
            }
            ++t;
        }
        return result;
    }

    public Sequence union(Sequence seq, boolean bMerge) {
        if (seq == null || seq.length() == 0) {
            return new Sequence(this);
        }
        if (!bMerge) {
            return CursorUtil.union(this, seq);
        }
        IArray mems = this.getMems();
        IArray mems2 = seq.getMems();
        int len = mems.size();
        int len2 = mems2.size();
        Sequence result = new Sequence(len + len2);
        IArray resultMems = result.getMems();
        int s = 1;
        int t = 1;
        while (s <= len && t <= len2) {
            Object obj2;
            Object obj = mems.get(s);
            int cmp = Variant.compare(obj, obj2 = mems2.get(t), true);
            if (cmp < 0) {
                resultMems.add(obj);
                ++s;
                continue;
            }
            if (cmp == 0) {
                resultMems.add(obj);
                ++t;
                ++s;
                continue;
            }
            resultMems.add(obj2);
            ++t;
        }
        while (s <= len) {
            resultMems.add(mems.get(s));
            ++s;
        }
        while (t <= len2) {
            resultMems.add(mems2.get(t));
            ++t;
        }
        return result;
    }

    private static Sequence _$1(Sequence[] sequences) {
        int count = sequences.length;
        IArray[] lists = new IArray[count];
        int[] lens = new int[count];
        int total = 0;
        Comparator<Object> c = null;
        for (int i = 0; i < count; ++i) {
            if (sequences[i] == null) {
                sequences[i] = new Sequence(0);
            }
            lists[i] = sequences[i].getMems();
            lens[i] = lists[i].size();
            total += lens[i];
            if (c != null || lens[i] <= 0) continue;
            c = sequences[i].ifn() instanceof BaseRecord ? new RecordKeyComparator() : new BaseComparator();
        }
        if (total == 0) {
            return null;
        }
        if (count == 2) {
            IArray list1 = lists[0];
            IArray list2 = lists[1];
            int len1 = lens[0];
            int len2 = lens[1];
            Sequence result = new Sequence(total);
            IArray resultList = result.getMems();
            if (len1 == 0) {
                resultList.addAll(list2);
            } else if (len2 == 0) {
                resultList.addAll(list1);
            } else if (c.compare(list1.get(len1), list2.get(1)) <= 0) {
                resultList.addAll(list1);
                resultList.addAll(list2);
            } else if (c.compare(list2.get(len2), list1.get(1)) <= 0) {
                resultList.addAll(list2);
                resultList.addAll(list1);
            } else {
                int s1 = 1;
                int s2 = 1;
                while (s1 <= len1 && s2 <= len2) {
                    Object obj2;
                    Object obj1 = list1.get(s1);
                    int cmp = c.compare(obj1, obj2 = list2.get(s2));
                    if (cmp == 0) {
                        resultList.add(obj1);
                        resultList.add(obj2);
                        ++s1;
                        ++s2;
                        continue;
                    }
                    if (cmp > 0) {
                        resultList.add(obj2);
                        ++s2;
                        continue;
                    }
                    resultList.add(obj1);
                    ++s1;
                }
                while (s1 <= len1) {
                    resultList.add(list1.get(s1));
                    ++s1;
                }
                while (s2 <= len2) {
                    resultList.add(list2.get(s2));
                    ++s2;
                }
            }
            return result;
        }
        Object[] itemVals = new Object[count];
        int[] items = new int[count];
        int[] index = new int[count];
        block4: for (int i = 0; i < count; ++i) {
            Object val;
            index[i] = 1;
            if (lens[i] == 0) {
                items[i] = -1;
                continue;
            }
            itemVals[i] = val = lists[i].get(1);
            for (int j = 0; j < i; ++j) {
                if (items[j] == -1) {
                    items[j] = i;
                    items[i] = -1;
                    continue block4;
                }
                if (c.compare(val, itemVals[items[j]]) >= 0) continue;
                for (int k = i; k > j; --k) {
                    items[k] = items[k - 1];
                }
                items[j] = i;
                continue block4;
            }
            items[i] = i;
        }
        Sequence result = new Sequence(total);
        IArray resultSeqList = result.getMems();
        block7: for (int i = 1; i <= total; ++i) {
            int item;
            int n = item = items[0];
            index[n] = index[n] + 1;
            resultSeqList.add(itemVals[item]);
            if (index[item] <= lens[item]) {
                Object val;
                itemVals[item] = val = lists[item].get(index[item]);
                for (int j = 1; j < count; ++j) {
                    if (items[j] == -1 || c.compare(val, itemVals[items[j]]) <= 0) {
                        items[j - 1] = item;
                        continue block7;
                    }
                    items[j - 1] = items[j];
                }
                items[count - 1] = item;
                continue;
            }
            for (int j = 1; j < count; ++j) {
                items[j - 1] = items[j];
            }
            itemVals[item] = null;
            items[count - 1] = -1;
        }
        return result;
    }

    private static Sequence _$1(Sequence[] sequences, Expression exp, Context ctx) {
        if (exp == null) {
            return Sequence._$1(sequences);
        }
        int count = sequences.length;
        IArray[] lists = new IArray[count];
        Sequence[] values = new Sequence[count];
        IArray[] valueLists = new IArray[count];
        int[] lens = new int[count];
        int total = 0;
        for (int i = 0; i < count; ++i) {
            if (sequences[i] == null) {
                sequences[i] = new Sequence(0);
            }
            lists[i] = sequences[i].getMems();
            values[i] = sequences[i].calc(exp, ctx);
            valueLists[i] = values[i].getMems();
            lens[i] = lists[i].size();
            total += lens[i];
        }
        if (total == 0) {
            return null;
        }
        if (count == 2) {
            IArray list1 = lists[0];
            IArray list2 = lists[1];
            IArray valueList1 = valueLists[0];
            IArray valueList2 = valueLists[1];
            int len1 = lens[0];
            int len2 = lens[1];
            Sequence result = new Sequence(total);
            IArray resultList = result.getMems();
            if (len1 == 0) {
                resultList.addAll(list2);
            } else if (len2 == 0) {
                resultList.addAll(list1);
            } else if (Variant.compare(valueList1.get(len1), valueList2.get(1), true) <= 0) {
                resultList.addAll(list1);
                resultList.addAll(list2);
            } else if (Variant.compare(valueList2.get(len2), valueList1.get(1), true) <= 0) {
                resultList.addAll(list2);
                resultList.addAll(list1);
            } else {
                int s1 = 1;
                int s2 = 1;
                while (s1 <= len1 && s2 <= len2) {
                    Object obj2;
                    Object obj1 = valueList1.get(s1);
                    int cmp = Variant.compare(obj1, obj2 = valueList2.get(s2), true);
                    if (cmp == 0) {
                        resultList.add(list1.get(s1));
                        resultList.add(list2.get(s2));
                        ++s1;
                        ++s2;
                        continue;
                    }
                    if (cmp > 0) {
                        resultList.add(list2.get(s2));
                        ++s2;
                        continue;
                    }
                    resultList.add(list1.get(s1));
                    ++s1;
                }
                while (s1 <= len1) {
                    resultList.add(list1.get(s1));
                    ++s1;
                }
                while (s2 <= len2) {
                    resultList.add(list2.get(s2));
                    ++s2;
                }
            }
            return result;
        }
        Object[] itemVals = new Object[count];
        int[] items = new int[count];
        int[] index = new int[count];
        block4: for (int i = 0; i < count; ++i) {
            Object val;
            index[i] = 1;
            if (lens[i] == 0) {
                items[i] = -1;
                continue;
            }
            itemVals[i] = val = valueLists[i].get(1);
            for (int j = 0; j < i; ++j) {
                if (items[j] == -1) {
                    items[j] = i;
                    items[i] = -1;
                    continue block4;
                }
                if (Variant.compare(val, itemVals[items[j]], true) >= 0) continue;
                for (int k = i; k > j; --k) {
                    items[k] = items[k - 1];
                }
                items[j] = i;
                continue block4;
            }
            items[i] = i;
        }
        Sequence result = new Sequence(total);
        IArray resultList = result.getMems();
        block7: for (int i = 1; i <= total; ++i) {
            int item = items[0];
            resultList.add(lists[item].get(index[item]));
            int n = item;
            index[n] = index[n] + 1;
            if (index[item] <= lens[item]) {
                Object val;
                itemVals[item] = val = valueLists[item].get(index[item]);
                for (int j = 1; j < count; ++j) {
                    if (items[j] == -1 || Variant.compare(val, itemVals[items[j]], true) <= 0) {
                        items[j - 1] = item;
                        continue block7;
                    }
                    items[j - 1] = items[j];
                }
                items[count - 1] = item;
                continue;
            }
            for (int j = 1; j < count; ++j) {
                items[j - 1] = items[j];
            }
            itemVals[item] = null;
            items[count - 1] = -1;
        }
        return result;
    }

    private static Sequence _$1(Sequence[] sequences, Expression[] exps, Context ctx) {
        if (exps == null || exps.length == 0) {
            return Sequence._$1(sequences);
        }
        if (exps.length == 1) {
            return Sequence._$1(sequences, exps[0], ctx);
        }
        int count = sequences.length;
        int expCount = exps.length;
        IArray[] lists = new IArray[count];
        int[] lens = new int[count];
        int total = 0;
        for (int i = 0; i < count; ++i) {
            if (sequences[i] == null) {
                sequences[i] = new Sequence(0);
            }
            lists[i] = sequences[i].getMems();
            lens[i] = lists[i].size();
            total += lens[i];
        }
        if (total == 0) {
            return null;
        }
        if (count == 2) {
            IArray list1 = lists[0];
            IArray list2 = lists[1];
            int len1 = lens[0];
            int len2 = lens[1];
            Sequence result = new Sequence(total);
            IArray resultList = result.getMems();
            if (len1 == 0) {
                resultList.addAll(list2);
                return result;
            }
            if (len2 == 0) {
                resultList.addAll(list1);
                return result;
            }
            Object[] values1 = new Object[expCount];
            Object[] values2 = new Object[expCount];
            sequences[0].calc(len1, exps, ctx, values1);
            sequences[1].calc(1, exps, ctx, values2);
            if (Variant.compareArrays(values1, values2, expCount) <= 0) {
                resultList.addAll(list1);
                resultList.addAll(list2);
                return result;
            }
            sequences[0].calc(1, exps, ctx, values1);
            sequences[1].calc(len2, exps, ctx, values2);
            if (Variant.compareArrays(values2, values1, expCount) <= 0) {
                resultList.addAll(list2);
                resultList.addAll(list1);
                return result;
            }
            sequences[1].calc(1, exps, ctx, values2);
            int s1 = 1;
            int s2 = 1;
            while (true) {
                int cmp;
                if ((cmp = Variant.compareArrays(values1, values2, expCount)) == 0) {
                    resultList.add(list1.get(s1));
                    resultList.add(list2.get(s2));
                    if (++s1 > len1 || ++s2 > len2) break;
                    sequences[0].calc(s1, exps, ctx, values1);
                    sequences[1].calc(s2, exps, ctx, values2);
                    continue;
                }
                if (cmp > 0) {
                    resultList.add(list2.get(s2));
                    if (++s2 > len2) break;
                    sequences[1].calc(s2, exps, ctx, values2);
                    continue;
                }
                resultList.add(list1.get(s1));
                if (++s1 > len1) break;
                sequences[0].calc(s1, exps, ctx, values1);
            }
            while (s1 <= len1) {
                resultList.add(list1.get(s1));
                ++s1;
            }
            while (s2 <= len2) {
                resultList.add(list2.get(s2));
                ++s2;
            }
            return result;
        }
        Object[][] itemVals = new Object[count][];
        int[] items = new int[count];
        int[] index = new int[count];
        block4: for (int i = 0; i < count; ++i) {
            index[i] = 1;
            if (lens[i] == 0) {
                items[i] = -1;
                continue;
            }
            Object[] values = new Object[expCount];
            sequences[i].calc(1, exps, ctx, values);
            itemVals[i] = values;
            for (int j = 0; j < i; ++j) {
                if (items[j] == -1) {
                    items[j] = i;
                    items[i] = -1;
                    continue block4;
                }
                if (Variant.compareArrays(values, itemVals[items[j]], expCount) >= 0) continue;
                for (int k = i; k > j; --k) {
                    items[k] = items[k - 1];
                }
                items[j] = i;
                continue block4;
            }
            items[i] = i;
        }
        Sequence result = new Sequence(total);
        IArray resultList = result.getMems();
        block7: for (int i = 1; i <= total; ++i) {
            int item = items[0];
            resultList.add(lists[item].get(index[item]));
            int n = item;
            index[n] = index[n] + 1;
            if (index[item] <= lens[item]) {
                Object[] values = itemVals[item];
                sequences[item].calc(index[item], exps, ctx, values);
                for (int j = 1; j < count; ++j) {
                    if (items[j] == -1 || Variant.compareArrays(values, itemVals[items[j]], expCount) <= 0) {
                        items[j - 1] = item;
                        continue block7;
                    }
                    items[j - 1] = items[j];
                }
                items[count - 1] = item;
                continue;
            }
            for (int j = 1; j < count; ++j) {
                items[j - 1] = items[j];
            }
            itemVals[item] = null;
            items[count - 1] = -1;
        }
        return result;
    }

    private static Sequence _$4(Sequence[] sources, Sequence[] values) {
        int i;
        int count;
        int leaveCount = count = values.length;
        int[] len = new int[count];
        int[] index = new int[count];
        int totalLen = 0;
        IArray[] srcMems = new IArray[count];
        IArray[] valMems = new IArray[count];
        for (int i2 = 0; i2 < count; ++i2) {
            valMems[i2] = values[i2].getMems();
            srcMems[i2] = sources[i2].getMems();
            index[i2] = 1;
            len[i2] = valMems[i2].size();
            totalLen += len[i2];
            if (len[i2] != 0) continue;
            --leaveCount;
        }
        Object minValue = null;
        int[] minIndex = new int[count];
        Sequence result = new Sequence(totalLen);
        IArray resultMems = result.getMems();
        while (leaveCount > 1) {
            int i3;
            for (i = 0; i < count; ++i) {
                if (index[i] > len[i]) continue;
                minValue = valMems[i].get(index[i]);
                minIndex[0] = i;
                break;
            }
            int sameCount = 1;
            for (i3 = minIndex[0] + 1; i3 < count; ++i3) {
                if (index[i3] > len[i3]) continue;
                Object value = valMems[i3].get(index[i3]);
                int cmp = Variant.compare(minValue, value, true);
                if (cmp > 0) {
                    minValue = value;
                    minIndex[0] = i3;
                    sameCount = 1;
                    continue;
                }
                if (cmp != 0) continue;
                minIndex[sameCount] = i3;
                ++sameCount;
            }
            resultMems.add(srcMems[minIndex[0]].get(index[minIndex[0]]));
            for (i3 = 0; i3 < sameCount; ++i3) {
                int n = minIndex[i3];
                index[n] = index[n] + 1;
                if (index[minIndex[i3]] <= len[minIndex[i3]]) continue;
                --leaveCount;
            }
        }
        for (i = 0; i < count; ++i) {
            if (index[i] > len[i]) continue;
            for (int j = index[i]; j <= len[i]; ++j) {
                resultMems.add(srcMems[i].get(j));
            }
            break;
        }
        return result;
    }

    private static Sequence _$3(Sequence[] sources, Sequence[] values) {
        int i;
        int count;
        int leaveCount = count = values.length;
        int[] len = new int[count];
        int[] index = new int[count];
        int totalLen = 0;
        IArray[] srcMems = new IArray[count];
        IArray[] valMems = new IArray[count];
        for (int i2 = 0; i2 < count; ++i2) {
            valMems[i2] = values[i2].getMems();
            srcMems[i2] = sources[i2].getMems();
            index[i2] = 1;
            len[i2] = valMems[i2].size();
            totalLen += len[i2];
            if (len[i2] != 0) continue;
            --leaveCount;
        }
        Object minValue = null;
        int[] minIndex = new int[count];
        Sequence result = new Sequence(totalLen);
        IArray resultMems = result.getMems();
        while (leaveCount > 1) {
            int i3;
            for (i = 0; i < count; ++i) {
                if (index[i] > len[i]) continue;
                minValue = valMems[i].get(index[i]);
                minIndex[0] = i;
                break;
            }
            int sameCount = 1;
            for (i3 = minIndex[0] + 1; i3 < count; ++i3) {
                if (index[i3] > len[i3]) continue;
                Object value = valMems[i3].get(index[i3]);
                int cmp = Variant.compare(minValue, value, true);
                if (cmp > 0) {
                    minValue = value;
                    minIndex[0] = i3;
                    sameCount = 1;
                    continue;
                }
                if (cmp != 0) continue;
                minIndex[sameCount] = i3;
                ++sameCount;
            }
            if (sameCount == 1) {
                resultMems.add(srcMems[minIndex[0]].get(index[minIndex[0]]));
            }
            for (i3 = 0; i3 < sameCount; ++i3) {
                int n = minIndex[i3];
                index[n] = index[n] + 1;
                if (index[minIndex[i3]] <= len[minIndex[i3]]) continue;
                --leaveCount;
            }
        }
        for (i = 0; i < count; ++i) {
            if (index[i] > len[i]) continue;
            for (int j = index[i]; j <= len[i]; ++j) {
                resultMems.add(srcMems[i].get(j));
            }
            break;
        }
        return result;
    }

    private static Sequence _$2(Sequence[] sources, Sequence[] values) {
        int count = values.length;
        int[] len = new int[count];
        int[] index = new int[count];
        IArray[] srcMems = new IArray[count];
        IArray[] valMems = new IArray[count];
        int minLen = Integer.MAX_VALUE;
        for (int i = 0; i < count; ++i) {
            valMems[i] = values[i].getMems();
            srcMems[i] = sources[i].getMems();
            index[i] = 1;
            len[i] = valMems[i].size();
            if (len[i] == 0) {
                return new Sequence(0);
            }
            if (len[i] >= minLen) continue;
            minLen = len[i];
        }
        Sequence result = new Sequence(minLen);
        IArray resultMems = result.getMems();
        block1: for (int col1 = 1; col1 <= len[0]; ++col1) {
            Object val1 = valMems[0].get(col1);
            int i = 1;
            block2: while (i < count) {
                while (index[i] <= len[i]) {
                    Object value = valMems[i].get(index[i]);
                    int cmp = Variant.compare(val1, value, true);
                    if (cmp < 0) continue block1;
                    if (cmp != 0) {
                        int n = i;
                        index[n] = index[n] + 1;
                        continue;
                    }
                    int n = i++;
                    index[n] = index[n] + 1;
                    continue block2;
                }
                break block1;
            }
            resultMems.add(srcMems[0].get(col1));
        }
        return result;
    }

    private static Sequence _$1(Sequence[] sources, Sequence[] values) {
        int count = values.length;
        int[] len = new int[count];
        int[] index = new int[count];
        IArray[] srcMems = new IArray[count];
        IArray[] valMems = new IArray[count];
        for (int i = 0; i < count; ++i) {
            valMems[i] = values[i].getMems();
            srcMems[i] = sources[i].getMems();
            index[i] = 1;
            len[i] = valMems[i].size();
        }
        Sequence result = new Sequence(len[0]);
        IArray resultMems = result.getMems();
        for (int r = 1; r <= len[0]; ++r) {
            Object val1 = valMems[0].get(r);
            boolean find = false;
            block2: for (int i = 1; i < count; ++i) {
                Object value;
                int cmp;
                while (index[i] <= len[i] && (cmp = Variant.compare(val1, value = valMems[i].get(index[i]), true)) >= 0) {
                    if (cmp == 0) {
                        int n = i;
                        index[n] = index[n] + 1;
                        find = true;
                        continue block2;
                    }
                    int n = i;
                    index[n] = index[n] + 1;
                }
            }
            if (find) continue;
            resultMems.add(srcMems[0].get(r));
        }
        return result;
    }

    public Sequence merge(Expression[] exps, String opt, Context ctx) {
        int i;
        boolean bUnion = false;
        boolean bIsect = false;
        boolean bDiff = false;
        boolean bXor = false;
        if (opt != null) {
            if (opt.indexOf(117) != -1) {
                bUnion = true;
            } else if (opt.indexOf(105) != -1) {
                bIsect = true;
            } else if (opt.indexOf(100) != -1) {
                bDiff = true;
            } else if (opt.indexOf(120) != -1) {
                bXor = true;
            }
            if (opt.indexOf(111) != -1) {
                if (bUnion) {
                    return this.union(exps, ctx);
                }
                if (bIsect) {
                    return this.isect(exps, ctx);
                }
                if (bDiff) {
                    return this.diff(exps, ctx);
                }
                if (bXor) {
                    return this.xor(exps, ctx);
                }
                return this.conj(null);
            }
        }
        int count = this.count();
        int len = this.length();
        Sequence[] sequences = new Sequence[count];
        int seq = 0;
        for (int i2 = 1; i2 <= len; ++i2) {
            Object obj = this.getMem(i2);
            if (obj instanceof Sequence) {
                sequences[seq] = (Sequence)obj;
                ++seq;
                continue;
            }
            if (obj == null) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException("merge" + mm.getMessage("function.paramTypeError"));
        }
        if (bUnion) {
            if (exps == null || exps.length == 0) {
                Sequence retSeq = sequences[0];
                for (i = 1; i < count; ++i) {
                    retSeq = retSeq.union(sequences[i], true);
                }
                return retSeq;
            }
            Sequence[] values = new Sequence[count];
            for (i = 0; i < count; ++i) {
                values[i] = sequences[i]._$1(exps, ctx);
            }
            return Sequence._$4(sequences, values);
        }
        if (bIsect) {
            if (count != len) {
                return null;
            }
            if (exps == null || exps.length == 0) {
                Sequence retSeq = sequences[0];
                for (i = 1; i < count; ++i) {
                    retSeq = retSeq.isect(sequences[i], true);
                }
                return retSeq;
            }
            Sequence[] values = new Sequence[count];
            for (i = 0; i < count; ++i) {
                values[i] = sequences[i]._$1(exps, ctx);
            }
            return Sequence._$2(sequences, values);
        }
        if (bDiff) {
            if (this.getMem(1) == null) {
                return null;
            }
            if (count == 1) {
                return sequences[0];
            }
            if (exps == null || exps.length == 0) {
                Sequence seq2 = sequences[1];
                for (i = 2; i < count; ++i) {
                    seq2 = seq2.union(sequences[i], true);
                }
                return sequences[0].diff(seq2, true);
            }
            Sequence[] values = new Sequence[count];
            for (i = 0; i < count; ++i) {
                values[i] = sequences[i]._$1(exps, ctx);
            }
            return Sequence._$1(sequences, values);
        }
        if (bXor) {
            if (exps == null || exps.length == 0) {
                return Sequence._$3(sequences, sequences);
            }
            Sequence[] values = new Sequence[count];
            for (i = 0; i < count; ++i) {
                values[i] = sequences[i]._$1(exps, ctx);
            }
            return Sequence._$3(sequences, values);
        }
        return Sequence._$1(sequences, exps, ctx);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Sequence)) {
            return false;
        }
        return this.isEquals((Sequence)obj);
    }

    public boolean isEquals(Sequence seq) {
        if (seq == this) {
            return true;
        }
        if (seq == null) {
            return false;
        }
        IArray mems = this.getMems();
        IArray mems2 = seq.getMems();
        int len = mems.size();
        if (len != mems2.size()) {
            return false;
        }
        for (int i = 1; i <= len; ++i) {
            if (mems.isEquals(i, mems2, i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Sequence other) {
        if (other == this) {
            return 0;
        }
        if (other == null) {
            return 1;
        }
        return this.getMems().compareTo(other.getMems());
    }

    public int compareTo(Sequence seq, int len) {
        if (seq == this) {
            return 0;
        }
        if (seq == null) {
            return 1;
        }
        IArray mems = this.getMems();
        IArray mems2 = seq.getMems();
        for (int i = 1; i <= len; ++i) {
            int result = mems.compareTo(i, mems2, i);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public int compareTo(Sequence seq, Comparator<Object> comparator) {
        int len2;
        if (seq == this) {
            return 0;
        }
        if (seq == null) {
            return 1;
        }
        IArray mems = this.getMems();
        IArray mems2 = seq.getMems();
        int len = mems.size();
        int min = len > (len2 = mems2.size()) ? len2 : len;
        for (int i = 1; i <= min; ++i) {
            int result = Variant.compare(mems.get(i), mems2.get(i), comparator, true);
            if (result == 0) continue;
            return result;
        }
        return len == len2 ? 0 : (len > len2 ? 1 : -1);
    }

    public int nullMaxCompare(Sequence seq) {
        int len2;
        if (seq == this) {
            return 0;
        }
        if (seq == null) {
            return -1;
        }
        IArray mems = this.getMems();
        int len = mems.size();
        int min = len > (len2 = seq.length()) ? len2 : len;
        for (int i = 1; i <= min; ++i) {
            int result = Variant.compare_0(mems.get(i), seq.getMem(i));
            if (result == 0) continue;
            return result;
        }
        return len == len2 ? 0 : (len > len2 ? 1 : -1);
    }

    public int nullMaxCompare(Sequence seq, Comparator<Object> comparator) {
        int len2;
        if (seq == this) {
            return 0;
        }
        if (seq == null) {
            return -1;
        }
        IArray mems = this.getMems();
        int len = mems.size();
        int min = len > (len2 = seq.length()) ? len2 : len;
        for (int i = 1; i <= min; ++i) {
            int result = Variant.compare_0(mems.get(i), seq.getMem(i), comparator);
            if (result == 0) continue;
            return result;
        }
        return len == len2 ? 0 : (len > len2 ? 1 : -1);
    }

    public int compare0() {
        IArray mems = this.getMems();
        int size = mems.size();
        if (size == 0) {
            return -1;
        }
        Integer zero = ObjectCache.getInteger(0);
        for (int i = 1; i <= size; ++i) {
            int result = Variant.compare(mems.get(i), zero, true);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public boolean cand() {
        IArray mems = this.getMems();
        int len = mems.size();
        for (int i = 1; i <= len; ++i) {
            if (!Variant.isFalse(mems.get(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cand(Expression exp, Context ctx) {
        IArray mems = this.getMems();
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            int len = mems.size();
            for (int i = 1; i <= len; ++i) {
                current.setCurrent(i);
                if (!Variant.isFalse(exp.calculate(ctx))) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            stack.pop();
        }
        return true;
    }

    public boolean cor() {
        IArray mems = this.getMems();
        int len = mems.size();
        for (int i = 1; i <= len; ++i) {
            if (!mems.isTrue(i)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cor(Expression exp, Context ctx) {
        IArray mems = this.getMems();
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            int len = mems.size();
            for (int i = 1; i <= len; ++i) {
                current.setCurrent(i);
                if (!Variant.isTrue(exp.calculate(ctx))) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            stack.pop();
        }
        return false;
    }

    public Object ifn() {
        IArray mems = this.getMems();
        int size = mems.size();
        for (int i = 1; i <= size; ++i) {
            Object obj = mems.get(i);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public Object nvl() {
        IArray mems = this.getMems();
        int size = mems.size();
        for (int i = 1; i <= size; ++i) {
            Object obj = mems.get(i);
            if (obj == null || obj.equals("")) continue;
            return obj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object ifn(Expression exp, Context ctx) {
        if (exp == null) {
            return this.ifn();
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            int size = this.length();
            for (int i = 1; i <= size; ++i) {
                current.setCurrent(i);
                Object obj = exp.calculate(ctx);
                if (obj == null) continue;
                Object object = obj;
                return object;
            }
        }
        finally {
            stack.pop();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object nvl(Expression exp, Context ctx) {
        if (exp == null) {
            return this.nvl();
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            int size = this.length();
            for (int i = 1; i <= size; ++i) {
                current.setCurrent(i);
                Object obj = exp.calculate(ctx);
                if (obj == null || obj.equals("")) continue;
                Object object = obj;
                return object;
            }
        }
        finally {
            stack.pop();
        }
        return null;
    }

    public int icount(String opt) {
        IArray mems = this.getMems();
        int size = mems.size();
        if (opt != null && opt.indexOf(98) != -1) {
            ICount.ICountBitSet set = new ICount.ICountBitSet();
            for (int i = 1; i <= size; ++i) {
                Object obj = mems.get(i);
                if (!Variant.isTrue(obj) || !(obj instanceof Number)) continue;
                set.add(((Number)obj).intValue());
            }
            return set.size();
        }
        if (opt != null && opt.indexOf(110) != -1) {
            ICount.ICountPositionSet set = new ICount.ICountPositionSet();
            for (int i = 1; i <= size; ++i) {
                Object obj = mems.get(i);
                if (!Variant.isTrue(obj) || !(obj instanceof Number)) continue;
                set.add(((Number)obj).intValue());
            }
            return set.size();
        }
        if (opt == null || opt.indexOf(111) == -1) {
            HashSet<Object> set = new HashSet<Object>(size);
            for (int i = 1; i <= size; ++i) {
                Object obj = mems.get(i);
                if (!Variant.isTrue(obj)) continue;
                set.add(obj);
            }
            return set.size();
        }
        int count = 0;
        Object prev = null;
        for (int i = 1; i <= size; ++i) {
            Object obj = mems.get(i);
            if (!Variant.isTrue(obj) || Variant.isEquals(prev, obj)) continue;
            prev = obj;
            ++count;
        }
        return count;
    }

    public Sequence id(String opt) {
        if (opt == null) {
            if (this.length() > 700) {
                return CursorUtil.hashId(this, opt);
            }
            return this.sort(null).id("o");
        }
        if (opt.indexOf(104) != -1) {
            return this.sort(null).id(opt.replace('h', 'o'));
        }
        if (opt.indexOf(111) != -1) {
            boolean containNull = opt.indexOf(48) == -1;
            IArray mems = this.getMems();
            int size = mems.size();
            Sequence result = new Sequence(size);
            if (size == 0) {
                return result;
            }
            IArray resultMems = result.getMems();
            Object prev = mems.get(1);
            if (containNull || prev != null) {
                resultMems.add(prev);
            }
            for (int i = 2; i <= size; ++i) {
                Object obj = mems.get(i);
                if (Variant.isEquals(prev, obj)) continue;
                prev = obj;
                if (!containNull && obj == null) continue;
                resultMems.add(obj);
            }
            return result;
        }
        if (opt.indexOf(117) != -1) {
            return CursorUtil.hashId(this, opt);
        }
        if (opt.indexOf(110) != -1 || opt.indexOf(98) != -1) {
            return CursorUtil.hashId(this, opt);
        }
        if (this.length() > 700) {
            return CursorUtil.hashId(this, opt);
        }
        return this.sort(null).id("o" + opt);
    }

    public Object mode() {
        IArray mems = this.getMems();
        int len = mems.size();
        HashMap<Object, Integer> map = new HashMap<Object, Integer>(len);
        for (int i = 1; i <= len; ++i) {
            Object obj = mems.get(i);
            if (obj == null) continue;
            Integer n = (Integer)map.get(obj);
            if (n == null) {
                map.put(obj, 1);
                continue;
            }
            map.put(obj, n + 1);
        }
        Object result = null;
        int count = 0;
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            if ((Integer)entry.getValue() <= count) continue;
            result = entry.getKey();
            count = (Integer)entry.getValue();
        }
        return result;
    }

    public Object sum() {
        return this.getMems().sum();
    }

    public Object sum2() {
        IArray mems = this.getMems();
        int size = mems.size();
        if (size < 1) {
            return null;
        }
        Object result = Variant.square(mems.get(1));
        for (int i = 2; i <= size; ++i) {
            result = Variant.add(result, Variant.square(mems.get(i)));
        }
        return result;
    }

    public Object variance() {
        IArray mems = this.getMems();
        int size = mems.size();
        if (size < 1) {
            return null;
        }
        int count = size;
        Object sum = null;
        Object sum2 = null;
        for (int i = 1; i <= size; ++i) {
            Object obj = mems.get(i);
            if (obj != null) {
                sum = Variant.add(sum, obj);
                sum2 = Variant.add(sum2, Variant.square(obj));
                continue;
            }
            --count;
        }
        if (count == 0) {
            return null;
        }
        Integer countObj = ObjectCache.getInteger(count);
        Object avg = Variant.divide(sum, countObj);
        Object result = Variant.square(avg);
        result = Variant.multiply(countObj, result);
        result = Variant.add(result, sum2);
        Object avgSum2 = Variant.multiply(avg, sum);
        avgSum2 = Variant.multiply(avgSum2, ObjectCache.getInteger(2));
        result = Variant.subtract(result, avgSum2);
        return Variant.divide(result, countObj);
    }

    public Sequence cumulate() {
        IArray mems = this.getMems();
        int size = mems.size();
        Sequence result = new Sequence(size);
        IArray resultMems = result.getMems();
        Object value = null;
        for (int i = 1; i <= size; ++i) {
            value = Variant.add(value, mems.get(i));
            resultMems.push(value);
        }
        return result;
    }

    public Sequence proportion() {
        IArray mems = this.getMems();
        int size = mems.size();
        Sequence result = new Sequence(size);
        IArray resultMems = result.getMems();
        Object sum = this.sum();
        for (int i = 1; i <= size; ++i) {
            resultMems.push(Variant.divide(mems.get(i), sum));
        }
        return result;
    }

    public Object average() {
        return this.getMems().average();
    }

    public Object min() {
        return this.getMems().min();
    }

    public Object min(String opt) {
        if (opt == null || opt.indexOf(48) == -1) {
            return this.min();
        }
        IArray mems = this.getMems();
        int size = mems.size();
        if (size < 1) {
            return null;
        }
        Object minVal = mems.get(1);
        for (int i = 2; i <= size; ++i) {
            Object temp = mems.get(i);
            if (Variant.compare(temp, minVal, true) >= 0) continue;
            minVal = temp;
        }
        return minVal;
    }

    public Object max() {
        return this.getMems().max();
    }

    public Sequence min(int count) {
        IArray mems = this.getMems();
        int size = mems.size();
        if (size < 1) {
            return null;
        }
        MinHeap heap = new MinHeap(count);
        for (int i = 1; i <= size; ++i) {
            Object obj = mems.get(i);
            if (obj == null) continue;
            heap.insert(obj);
        }
        Object[] objs = heap.toArray();
        Sequence sequence = new Sequence(objs);
        return sequence.sort("o");
    }

    public Sequence max(int count) {
        IArray mems = this.getMems();
        int size = mems.size();
        if (size < 1) {
            return null;
        }
        MaxHeap heap = new MaxHeap(count);
        for (int i = 1; i <= size; ++i) {
            heap.insert(mems.get(i));
        }
        Object[] objs = heap.toArray();
        Sequence sequence = new Sequence(objs);
        return sequence.sort("zo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntArrayList _$1(Expression[] exps, boolean isMin, Context ctx) {
        int end = this.length();
        int fcount = exps.length;
        IntArrayList list = new IntArrayList();
        list.addInt(0);
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            int i;
            Object[] prevValues = new Object[fcount];
            current.setCurrent(1);
            for (int f = 0; f < fcount; ++f) {
                prevValues[f] = exps[f].calculate(ctx);
            }
            list.addInt(1);
            if (isMin) {
                block4: for (i = 2; i <= end; ++i) {
                    current.setCurrent(i);
                    for (int f = 0; f < fcount; ++f) {
                        Object obj = exps[f].calculate(ctx);
                        int result = Variant.compare(obj, prevValues[f], true);
                        if (result < 0) {
                            prevValues[f] = obj;
                            ++f;
                            while (f < fcount) {
                                prevValues[f] = exps[f].calculate(ctx);
                                ++f;
                            }
                            list.setSize(1);
                            list.addInt(i);
                            continue block4;
                        }
                        if (result > 0) continue block4;
                    }
                    list.addInt(i);
                }
            } else {
                block7: for (i = 2; i <= end; ++i) {
                    current.setCurrent(i);
                    for (int f = 0; f < fcount; ++f) {
                        Object obj = exps[f].calculate(ctx);
                        int result = Variant.compare(obj, prevValues[f], true);
                        if (result > 0) {
                            prevValues[f] = obj;
                            ++f;
                            while (f < fcount) {
                                prevValues[f] = exps[f].calculate(ctx);
                                ++f;
                            }
                            list.setSize(1);
                            list.addInt(i);
                            continue block7;
                        }
                        if (result < 0) continue block7;
                    }
                    list.addInt(i);
                }
            }
        }
        finally {
            stack.pop();
        }
        return list;
    }

    private IntArray _$1(int count, Expression exp, String opt, Context ctx) {
        boolean isAll = true;
        boolean ignoreNull = true;
        boolean isRank = false;
        boolean isDistinct = false;
        if (opt != null) {
            if (opt.indexOf(49) != -1) {
                isAll = false;
            }
            if (opt.indexOf(48) != -1) {
                ignoreNull = false;
            }
            if (opt.indexOf(105) != -1) {
                isRank = true;
                isDistinct = true;
            } else if (opt.indexOf(114) != -1) {
                isRank = true;
            }
        }
        if (exp == null) {
            if (isRank) {
                return this.getMems().ptopRank(count, ignoreNull, isDistinct);
            }
            return this.getMems().ptop(count, isAll, false, ignoreNull);
        }
        if (exp.isConstExpression()) {
            int len = this.length();
            if (len == 0) {
                return new IntArray(1);
            }
            if (isAll && (count == 1 || count == -1)) {
                return new IntArray(1, len);
            }
            if (count > 0) {
                if (count > len) {
                    count = len;
                }
                return new IntArray(1, count);
            }
            int i = len + count + 1;
            if (i < 1) {
                i = 1;
            }
            return new IntArray(i, len);
        }
        Sequence values = this.calc(exp, ctx);
        if (isRank) {
            return values.getMems().ptopRank(count, ignoreNull, isDistinct);
        }
        return values.getMems().ptop(count, isAll, false, ignoreNull);
    }

    public Object ptop(int count, Expression exp, String opt, Context ctx) {
        if (count == 0) {
            return null;
        }
        IntArray indexArray = this._$1(count, exp, opt, ctx);
        int size = indexArray.size();
        if (size == 0) {
            return null;
        }
        if (size == 1 && opt != null && opt.indexOf(49) != -1) {
            return indexArray.get(1);
        }
        return new Sequence(indexArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object top(int count, Expression[] exps, String opt, Context ctx, boolean getPos) {
        Object[] vals;
        int len = this.length();
        if (len == 0 || count == 0) {
            return null;
        }
        if (!(count != 1 && count != -1 || opt != null && opt.indexOf(49) != -1)) {
            IntArrayList indexList = this._$1(exps, count == 1, ctx);
            int size = indexList.size() - 1;
            Sequence result = new Sequence(size);
            if (getPos) {
                for (int i = 1; i <= size; ++i) {
                    result.add(indexList.get(i));
                }
            } else {
                for (int i = 1; i <= size; ++i) {
                    result.add(this.getMem(indexList.getInt(i)));
                }
            }
            return result;
        }
        int expCount = exps.length;
        int arrayLen = expCount + 1;
        Comparator<Object> comparator = new ArrayComparator(expCount);
        if (count < 0) {
            count = -count;
            comparator = new DescComparator(comparator);
        }
        MinHeap minHeap = new MinHeap(count, comparator);
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            for (int i = 1; i <= len; ++i) {
                current.setCurrent(i);
                vals = new Object[arrayLen];
                vals[expCount] = i;
                for (int j = 0; j < expCount; ++j) {
                    vals[j] = exps[j].calculate(ctx);
                }
                minHeap.insert(vals);
            }
        }
        finally {
            stack.pop();
        }
        if (count == 1 && opt != null && opt.indexOf(49) != -1) {
            Object[] vals2 = (Object[])minHeap.getTop();
            if (getPos) {
                return vals2[expCount];
            }
            return this.getMem((Integer)vals2[expCount]);
        }
        int size = minHeap.size();
        vals = minHeap.toArray();
        Arrays.sort(vals, comparator);
        Sequence result = new Sequence(size);
        if (getPos) {
            for (int i = 0; i < size; ++i) {
                Object[] curVals = (Object[])vals[i];
                result.add(curVals[expCount]);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                Object[] curVals = (Object[])vals[i];
                result.add(this.getMem((Integer)curVals[expCount]));
            }
        }
        return result;
    }

    public Object top(int count, Expression exp, String opt, Context ctx) {
        IntArray indexArray;
        int size;
        if (count == 0) {
            return null;
        }
        Sequence seq = this.calc(exp, ctx);
        int len = seq.length();
        IArray mems = seq.getMems();
        if (opt != null && opt.indexOf(50) != -1) {
            for (int i = 1; i <= len; ++i) {
                if (!(mems.get(i) instanceof Sequence)) continue;
                seq = seq.conj(null);
                mems = seq.getMems();
                break;
            }
        }
        if ((size = (indexArray = seq._$1(count, null, opt, ctx)).size()) == 0) {
            return null;
        }
        if (size == 1 && opt != null && opt.indexOf(49) != -1) {
            return mems.get(indexArray.getInt(1));
        }
        IArray resultArray = mems.get(indexArray);
        return new Sequence(resultArray);
    }

    public Object top(int count, Expression exp, Expression getExp, String opt, Context ctx) {
        IntArray indexArray;
        int size;
        if (count == 0) {
            return null;
        }
        Sequence seq = this.calc(getExp, ctx);
        int len = seq.length();
        IArray mems = seq.getMems();
        if (opt != null && opt.indexOf(50) != -1) {
            for (int i = 1; i <= len; ++i) {
                if (!(mems.get(i) instanceof Sequence)) continue;
                seq = seq.conj(null);
                mems = seq.getMems();
                break;
            }
        }
        if ((size = (indexArray = seq._$1(count, exp, opt, ctx)).size()) == 0) {
            return null;
        }
        if (size == 1 && opt != null && opt.indexOf(49) != -1) {
            return mems.get(indexArray.getInt(1));
        }
        IArray resultArray = mems.get(indexArray);
        return new Sequence(resultArray);
    }

    private IntArrayList _$1(int count, Comparator<Object> comparator) {
        IArray mems = this.getMems();
        int size = mems.size();
        IntArrayList indexList = new IntArrayList(count + 1);
        indexList.addInt(0);
        if (count == 1) {
            int p;
            Object minValue = null;
            for (p = 1; p <= size && (minValue = mems.get(p)) == null; ++p) {
            }
            for (int i = p + 1; i <= size; ++i) {
                Object temp = mems.get(i);
                if (temp == null || comparator.compare(temp, minValue) >= 0) continue;
                minValue = temp;
                p = i;
            }
            if (minValue != null) {
                indexList.addInt(p);
            }
        } else {
            ListBase1 values = new ListBase1(count);
            for (int i = 1; i <= size; ++i) {
                Object obj = mems.get(i);
                if (obj == null) continue;
                int index = values.binarySearch(obj, comparator);
                if (index < 1) {
                    index = -index;
                }
                if (index > count) continue;
                values.add(index, obj);
                indexList.addInt(index, i);
                if (values.size() <= count) continue;
                values.remove(count + 1);
                indexList.remove(count + 1);
            }
        }
        return indexList;
    }

    public Sequence minp(Expression exp, int count, Context ctx) {
        IArray mems = this.getMems();
        if (mems.size() < 1) {
            return null;
        }
        Sequence valSequence = this.calc(exp, ctx);
        IntArrayList indexList = valSequence._$1(count, new BaseComparator());
        count = indexList.size() - 1;
        Sequence result = new Sequence(count);
        for (int i = 1; i <= count; ++i) {
            int index = indexList.getInt(i);
            result.add(mems.get(index));
        }
        return result;
    }

    public Sequence maxp(Expression exp, int count, Context ctx) {
        IArray mems = this.getMems();
        if (mems.size() < 1) {
            return null;
        }
        Sequence valSequence = this.calc(exp, ctx);
        IntArrayList indexList = valSequence._$1(count, new DescComparator());
        count = indexList.size() - 1;
        Sequence result = new Sequence(count);
        for (int i = 1; i <= count; ++i) {
            int index = indexList.getInt(i);
            result.add(mems.get(index));
        }
        return result;
    }

    public Number rank(Object obj, String opt) {
        boolean isDesc = false;
        boolean isDistinct = false;
        boolean isStatistics = false;
        boolean isSorted = false;
        if (opt != null) {
            if (opt.indexOf(122) != -1) {
                isDesc = true;
            }
            if (opt.indexOf(105) != -1) {
                isDistinct = true;
            }
            if (opt.indexOf(115) != -1) {
                isStatistics = true;
            }
            if (opt.indexOf(111) != -1) {
                isSorted = true;
            }
        }
        IArray mems = this.getMems();
        int length = mems.size();
        int count = 1;
        if (isSorted) {
            if (isDistinct) {
                if (isDesc) {
                    for (int i = 1; i <= length && Variant.compare(mems.get(i), obj, true) > 0; ++i) {
                        if (i != 1 && Variant.isEquals(mems.get(i - 1), mems.get(i))) continue;
                        ++count;
                    }
                } else {
                    for (int i = 1; i <= length && Variant.compare(mems.get(i), obj, true) < 0; ++i) {
                        if (i != 0 && Variant.isEquals(mems.get(i - 1), mems.get(i))) continue;
                        ++count;
                    }
                }
            } else if (isDesc) {
                for (int i = 1; i <= length && Variant.compare(mems.get(i), obj, true) > 0; ++i) {
                    ++count;
                }
            } else {
                for (int i = 1; i < length && Variant.compare(mems.get(i), obj, true) < 0; ++i) {
                    ++count;
                }
            }
        } else if (isDistinct) {
            Object[] objs = mems.toArray();
            if (isDesc) {
                MultithreadUtil.sort(objs, new DescComparator());
                for (int i = 0; i < length && Variant.compare(objs[i], obj, true) > 0; ++i) {
                    if (i != 0 && Variant.isEquals(objs[i - 1], objs[i])) continue;
                    ++count;
                }
            } else {
                MultithreadUtil.sort(objs, new BaseComparator());
                for (int i = 0; i < length && Variant.compare(objs[i], obj, true) < 0; ++i) {
                    if (i != 0 && Variant.isEquals(objs[i - 1], objs[i])) continue;
                    ++count;
                }
            }
        } else {
            if (isStatistics) {
                int i;
                int sameCount = 0;
                if (isDesc) {
                    for (i = 1; i <= length; ++i) {
                        int cmp = Variant.compare(mems.get(i), obj, true);
                        if (cmp > 0) {
                            ++count;
                            continue;
                        }
                        if (cmp != 0) continue;
                        ++sameCount;
                    }
                } else {
                    for (i = 1; i <= length; ++i) {
                        int cmp = Variant.compare(mems.get(i), obj, true);
                        if (cmp < 0) {
                            ++count;
                            continue;
                        }
                        if (cmp != 0) continue;
                        ++sameCount;
                    }
                }
                if (sameCount > 1) {
                    double r = (1.0 + (double)sameCount) / 2.0 + (double)count - 1.0;
                    return new Double(r);
                }
                return new Double(count);
            }
            if (isDesc) {
                for (int i = 1; i <= length; ++i) {
                    if (Variant.compare(mems.get(i), obj, true) <= 0) continue;
                    ++count;
                }
            } else {
                for (int i = 1; i <= length; ++i) {
                    if (Variant.compare(mems.get(i), obj, true) >= 0) continue;
                    ++count;
                }
            }
        }
        return ObjectCache.getInteger(count);
    }

    public Sequence ranks(String opt) {
        IArray mems = this.getMems();
        int size = mems.size();
        if (size == 0) {
            return new Sequence(0);
        }
        boolean isDesc = false;
        boolean isDistinct = false;
        boolean isStatistics = false;
        if (opt != null) {
            if (opt.indexOf(122) != -1) {
                isDesc = true;
            }
            if (opt.indexOf(105) != -1) {
                isDistinct = true;
            }
            if (opt.indexOf(115) != -1) {
                isStatistics = true;
            }
            if (opt.indexOf(111) != -1) {
                ObjectArray array = new ObjectArray(size);
                Object prev = this.getMem(1);
                array.push(ObjectCache.getInteger(1));
                if (isDistinct) {
                    int rank = 1;
                    for (int i = 2; i <= size; ++i) {
                        Object cur = this.getMem(i);
                        if (!Variant.isEquals(prev, cur)) {
                            ++rank;
                            prev = cur;
                        }
                        array.push(ObjectCache.getInteger(rank));
                    }
                } else {
                    for (int i = 2; i <= size; ++i) {
                        Object cur = this.getMem(i);
                        if (Variant.isEquals(prev, cur)) {
                            array.push(array.get(i - 1));
                            continue;
                        }
                        prev = cur;
                        array.push(ObjectCache.getInteger(i));
                    }
                }
                return new Sequence(array);
            }
        }
        int len = size + 1;
        Object[] infos = new PSortItem[len];
        for (int i = 1; i < len; ++i) {
            infos[i] = new PSortItem(i, mems.get(i));
        }
        Comparator<Object> comparator = new BaseComparator();
        if (isDesc) {
            comparator = new DescComparator(comparator);
        }
        MultithreadUtil.sort(infos, 1, len, new PSortComparator(comparator));
        Object[] places = new Number[size];
        if (isDistinct) {
            places[((PSortItem)infos[1]).index - 1] = ObjectCache.getInteger(1);
            int count = 1;
            Object prev = mems.get(((PSortItem)infos[1]).index);
            for (int i = 2; i < len; ++i) {
                Object cur = mems.get(((PSortItem)infos[i]).index);
                if (!Variant.isEquals(prev, cur)) {
                    ++count;
                    prev = cur;
                }
                places[((PSortItem)infos[i]).index - 1] = ObjectCache.getInteger(count);
            }
        } else if (isStatistics) {
            int sameCount;
            for (int i = 1; i < len; i += sameCount) {
                Object val = mems.get(((PSortItem)infos[i]).index);
                sameCount = 1;
                for (int j = i + 1; j < len && Variant.isEquals(val, mems.get(((PSortItem)infos[j]).index)); ++j) {
                    ++sameCount;
                }
                if (sameCount > 1) {
                    double r = (1.0 + (double)sameCount) / 2.0 + (double)i - 1.0;
                    Double d = new Double(r);
                    for (int j = 0; j < sameCount; ++j) {
                        places[((PSortItem)infos[i + j]).index - 1] = d;
                    }
                    continue;
                }
                places[((PSortItem)infos[i]).index - 1] = new Double(i);
            }
        } else {
            places[((PSortItem)infos[1]).index - 1] = ObjectCache.getInteger(1);
            for (int i = 2; i < len; ++i) {
                places[((PSortItem)infos[i]).index - 1] = Variant.isEquals(mems.get(((PSortItem)infos[i - 1]).index), mems.get(((PSortItem)infos[i]).index)) ? places[((PSortItem)infos[i - 1]).index - 1] : ObjectCache.getInteger(i);
            }
        }
        return new Sequence(places);
    }

    private void _$1(Object obj) {
        if (obj instanceof Sequence) {
            Sequence seq = (Sequence)obj;
            int len = seq.length();
            for (int i = 1; i <= len; ++i) {
                this._$1(seq.getMem(i));
            }
        } else if (obj != null) {
            this.getMems().add(obj);
        }
    }

    public Object median(int start, int end, int k, int n) {
        Sequence resSeq = null;
        if (2 <= n && 0 == k) {
            resSeq = new Sequence();
        } else if (0 == n && 0 == k) {
            n = 1;
            k = 2;
        }
        int len = end - start + 1;
        try {
            if (null == resSeq) {
                if (start + len * k / n - 1 >= this.length()) {
                    return this.get(this.length());
                }
                if (len * k % n != 0) {
                    return this.get(start + len * k / n);
                }
                return Variant.divide(Variant.add(this.get(start + len * k / n - 1), this.get(start + len * k / n)), 2);
            }
            for (int i = 1; i < n; ++i) {
                if (start + len * i / n - 1 >= this.length()) {
                    resSeq.add(this.get(this.length()));
                    continue;
                }
                if (len * i % n != 0) {
                    resSeq.add(this.get(start + len * i / n));
                    continue;
                }
                Object obj = Variant.divide(Variant.add(this.get(start + len * i / n - 1), this.get(start + len * i / n)), 2);
                resSeq.add(obj);
            }
            return resSeq;
        }
        catch (Exception e) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("median" + mm.getMessage("function.invalidParam"));
        }
    }

    public Sequence conj(String opt) {
        Object obj;
        int i;
        int total;
        IArray mems = this.getMems();
        int size = mems.size();
        if (size < 1) {
            return new Sequence(0);
        }
        if (opt != null) {
            if (opt.indexOf(109) != -1) {
                Sequence sequence;
                Object obj2 = mems.get(1);
                if (obj2 instanceof Sequence) {
                    sequence = (Sequence)obj2;
                } else {
                    if (obj2 != null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("engine.needSeriesMember"));
                    }
                    sequence = new Sequence(0);
                }
                for (int i2 = 2; i2 <= size; ++i2) {
                    obj2 = mems.get(i2);
                    if (obj2 instanceof Sequence) {
                        sequence = sequence.conj((Sequence)obj2, true);
                        continue;
                    }
                    if (obj2 == null) continue;
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.needSeriesMember"));
                }
                return sequence;
            }
            if (opt.indexOf(114) != -1) {
                int len = this.length();
                Sequence result = new Sequence(len + 8);
                for (int i3 = 1; i3 <= len; ++i3) {
                    result._$1(this.getMem(i3));
                }
                return result;
            }
            if (opt.indexOf(118) != -1) {
                total = 0;
                boolean isSeq = true;
                for (i = 1; i <= size; ++i) {
                    obj = mems.get(i);
                    if (obj instanceof Sequence) {
                        total += ((Sequence)obj).length();
                        continue;
                    }
                    isSeq = false;
                    break;
                }
                if (isSeq) {
                    Sequence result = (Sequence)mems.get(1);
                    if (size == 1) {
                        return result;
                    }
                    Sequence seq = (Sequence)mems.get(2);
                    result = result.conj(seq, total);
                    for (int i4 = 3; i4 <= size; ++i4) {
                        seq = (Sequence)mems.get(i4);
                        result = result.append(seq);
                    }
                    return result;
                }
            }
        }
        total = 0;
        boolean hasSeq = false;
        for (i = 1; i <= size; ++i) {
            obj = mems.get(i);
            if (obj instanceof Sequence) {
                total += ((Sequence)obj).length();
                hasSeq = true;
                continue;
            }
            if (obj == null) continue;
            ++total;
        }
        if (total == 0) {
            return new Sequence();
        }
        if (!hasSeq && total == size) {
            return this;
        }
        Sequence result = new Sequence(total);
        IArray resultMems = result.getMems();
        for (int i5 = 1; i5 <= size; ++i5) {
            Object obj3 = mems.get(i5);
            if (obj3 instanceof Sequence) {
                resultMems.addAll(((Sequence)obj3).getMems());
                continue;
            }
            if (obj3 == null) continue;
            resultMems.add(obj3);
        }
        return result;
    }

    public Sequence fieldValues_r(String field) {
        IArray mems = this.getMems();
        int size = mems.size();
        Sequence result = new Sequence(size);
        DataStruct prevDs = null;
        int col = -1;
        block0: for (int i = 1; i <= size; ++i) {
            Object cur = mems.get(i);
            while (cur instanceof BaseRecord) {
                BaseRecord r = (BaseRecord)cur;
                DataStruct ds = r.dataStruct();
                if (prevDs != ds) {
                    prevDs = ds;
                    col = r.getFieldIndex(field);
                }
                if (col == -1) {
                    result.add(r);
                    continue block0;
                }
                cur = r.getNormalFieldValue(col);
            }
            if (cur instanceof Sequence) {
                Sequence seq = ((Sequence)cur).fieldValues_r(field);
                result.add(seq);
                continue;
            }
            result.add(cur);
        }
        return result;
    }

    public Sequence fieldValues_r(int col) {
        IArray mems = this.getMems();
        int size = mems.size();
        Sequence result = new Sequence(size);
        for (int i = 1; i <= size; ++i) {
            Sequence seq;
            Object cur = mems.get(i);
            if (cur instanceof BaseRecord) {
                BaseRecord r = (BaseRecord)cur;
                cur = r.getNormalFieldValue(col);
            }
            if (cur instanceof Sequence) {
                seq = ((Sequence)cur).fieldValues_r(col);
                result.add(seq);
                continue;
            }
            if (cur instanceof BaseRecord) {
                seq = new Sequence(1);
                seq.add(cur);
                seq = seq.fieldValues_r(col);
                result.addAll(seq);
                continue;
            }
            result.add(cur);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence conj(Expression exp, Context ctx) {
        int len = this.length();
        Sequence result = new Sequence(len);
        IArray resultMems = result.getMems();
        if (exp != null) {
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(this);
            stack.push(current);
            try {
                for (int i = 1; i <= len; ++i) {
                    current.setCurrent(i);
                    Object obj = exp.calculate(ctx);
                    if (obj instanceof Sequence) {
                        resultMems.addAll(((Sequence)obj).getMems());
                        continue;
                    }
                    if (obj == null) continue;
                    resultMems.add(obj);
                }
            }
            finally {
                stack.pop();
            }
        } else {
            IArray mems = this.getMems();
            for (int i = 1; i <= len; ++i) {
                Object obj = mems.get(i);
                if (obj instanceof Sequence) {
                    resultMems.addAll(((Sequence)obj).getMems());
                    continue;
                }
                if (obj == null) continue;
                resultMems.add(obj);
            }
        }
        return result;
    }

    public Sequence diff(String opt) {
        IArray mems = this.getMems();
        int size = mems.size();
        if (size < 1) {
            return new Sequence(0);
        }
        boolean bMerge = opt != null && opt.indexOf(109) != -1;
        Object obj = mems.get(1);
        if (!(obj instanceof Sequence)) {
            if (obj != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needSeriesMember"));
            }
            return new Sequence(0);
        }
        Sequence result = (Sequence)obj;
        for (int i = 2; i <= size; ++i) {
            obj = mems.get(i);
            if (obj instanceof Sequence) {
                result = result.diff((Sequence)obj, bMerge);
                continue;
            }
            if (obj == null) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needSeriesMember"));
        }
        return result;
    }

    public Sequence diff(Expression[] exps, Context ctx) {
        IArray mems = this.getMems();
        int size = mems.size();
        if (size < 1) {
            return new Sequence(0);
        }
        Object obj = mems.get(1);
        if (!(obj instanceof Sequence)) {
            if (obj != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needSeriesMember"));
            }
            return new Sequence(0);
        }
        Sequence result = (Sequence)obj;
        for (int i = 2; i <= size; ++i) {
            obj = mems.get(i);
            if (obj instanceof Sequence) {
                result = CursorUtil.diff(result, (Sequence)obj, exps, ctx);
                continue;
            }
            if (obj == null) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needSeriesMember"));
        }
        return result;
    }

    public Sequence isect(String opt) {
        IArray mems = this.getMems();
        int size = mems.size();
        if (size < 1) {
            return new Sequence(0);
        }
        boolean bMerge = opt != null && opt.indexOf(109) != -1;
        Object obj = mems.get(1);
        if (!(obj instanceof Sequence)) {
            if (obj != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needSeriesMember"));
            }
            return new Sequence(0);
        }
        Sequence result = (Sequence)obj;
        for (int i = 2; i <= size; ++i) {
            obj = mems.get(i);
            if (!(obj instanceof Sequence)) {
                if (obj != null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.needSeriesMember"));
                }
                return new Sequence(0);
            }
            result = result.isect((Sequence)obj, bMerge);
        }
        return result;
    }

    public Sequence isect(Expression[] exps, Context ctx) {
        IArray mems = this.getMems();
        int size = mems.size();
        if (size < 1) {
            return new Sequence(0);
        }
        Object obj = mems.get(1);
        if (!(obj instanceof Sequence)) {
            if (obj != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needSeriesMember"));
            }
            return new Sequence(0);
        }
        Sequence result = (Sequence)obj;
        for (int i = 2; i <= size; ++i) {
            obj = mems.get(i);
            if (!(obj instanceof Sequence)) {
                if (obj != null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.needSeriesMember"));
                }
                return new Sequence(0);
            }
            result = CursorUtil.isect(result, (Sequence)obj, exps, ctx);
        }
        return result;
    }

    public Sequence union(String opt) {
        Sequence result;
        IArray mems = this.getMems();
        int size = mems.size();
        if (size < 1) {
            return new Sequence(0);
        }
        boolean bMerge = opt != null && opt.indexOf(109) != -1;
        Object obj = mems.get(1);
        if (obj instanceof Sequence) {
            result = (Sequence)obj;
        } else {
            if (obj != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needSeriesMember"));
            }
            result = new Sequence(0);
        }
        for (int i = 2; i <= size; ++i) {
            obj = mems.get(i);
            if (obj instanceof Sequence) {
                result = result.union((Sequence)obj, bMerge);
                continue;
            }
            if (obj == null) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needSeriesMember"));
        }
        return result;
    }

    public Sequence union(Expression[] exps, Context ctx) {
        Sequence result;
        IArray mems = this.getMems();
        int size = mems.size();
        if (size < 1) {
            return new Sequence(0);
        }
        Object obj = mems.get(1);
        if (obj instanceof Sequence) {
            result = (Sequence)obj;
        } else {
            if (obj != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needSeriesMember"));
            }
            result = new Sequence(0);
        }
        for (int i = 2; i <= size; ++i) {
            obj = mems.get(i);
            if (obj instanceof Sequence) {
                result = CursorUtil.union(result, (Sequence)obj, exps, ctx);
                continue;
            }
            if (obj == null) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needSeriesMember"));
        }
        return result;
    }

    public Sequence xor(Expression[] exps, Context ctx) {
        Sequence result;
        IArray mems = this.getMems();
        int size = mems.size();
        if (size < 1) {
            return new Sequence(0);
        }
        Object obj = mems.get(1);
        if (obj instanceof Sequence) {
            result = (Sequence)obj;
        } else {
            if (obj != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needSeriesMember"));
            }
            result = new Sequence(0);
        }
        for (int i = 2; i <= size; ++i) {
            obj = mems.get(i);
            if (obj instanceof Sequence) {
                result = CursorUtil.xor(result, (Sequence)obj, exps, ctx);
                continue;
            }
            if (obj == null) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needSeriesMember"));
        }
        return result;
    }

    public Sequence xor() {
        Sequence result;
        IArray mems = this.getMems();
        int size = mems.size();
        if (size < 1) {
            return new Sequence(0);
        }
        Object obj = mems.get(1);
        if (obj instanceof Sequence) {
            result = (Sequence)obj;
        } else {
            if (obj != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needSeriesMember"));
            }
            result = new Sequence(0);
        }
        for (int i = 2; i <= size; ++i) {
            obj = mems.get(i);
            if (obj instanceof Sequence) {
                result = CursorUtil.xor(result, (Sequence)obj);
                continue;
            }
            if (obj == null) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needSeriesMember"));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence calc(Expression exp, String opt, Context ctx) {
        if (opt != null) {
            if (opt.indexOf(109) != -1) {
                return MultithreadUtil.calc(this, exp, ctx);
            }
            if (opt.indexOf(122) != -1) {
                int size = this.length();
                Sequence result = new Sequence(size);
                IArray array = result.getMems();
                array.setSize(size);
                ComputeStack stack = ctx.getComputeStack();
                Current current = new Current(this);
                stack.push(current);
                try {
                    for (int i = size; i > 0; --i) {
                        current.setCurrent(i);
                        array.set(i, exp.calculate(ctx));
                    }
                }
                finally {
                    stack.pop();
                }
                if (opt.indexOf(118) != -1) {
                    result.mems = array = array.toPureArray();
                }
                return result;
            }
            if (opt.indexOf(118) != -1) {
                Sequence result = this.calc(exp, ctx);
                result.mems = result.mems.toPureArray();
                return result;
            }
        }
        return this.calc(exp, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence calc(Expression exp, Context ctx) {
        if (exp == null) {
            return this;
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        if (this.mems instanceof ObjectArray) {
            int size = this.length();
            Sequence result = new Sequence(size);
            IArray resultMems = result.getMems();
            stack.push(current);
            try {
                for (int i = 1; i <= size; ++i) {
                    current.setCurrent(i);
                    resultMems.add(exp.calculate(ctx));
                }
            }
            finally {
                stack.pop();
            }
            return result;
        }
        stack.push(current);
        try {
            IArray array = exp.calculateAll(ctx);
            array = array.reserve(false);
            Sequence sequence = new Sequence(array);
            return sequence;
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence _$1(Expression[] exps, Context ctx) {
        if (exps == null) {
            return this;
        }
        int count = exps.length;
        if (count == 1) {
            return this.calc(exps[0], ctx);
        }
        int size = this.length();
        Sequence result = new Sequence(size);
        IArray resultMems = result.getMems();
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            for (int i = 1; i <= size; ++i) {
                current.setCurrent(i);
                Sequence sequence = new Sequence(count);
                resultMems.add(sequence);
                for (int e = 0; e < count; ++e) {
                    sequence.add(exps[e].calculate(ctx));
                }
            }
        }
        finally {
            stack.pop();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object calc(int index, Expression exp, Context ctx) {
        if (exp == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("calc" + mm.getMessage("function.invalidParam"));
        }
        int size = this.length();
        if (index < 0) {
            index += size + 1;
        }
        if (index < 1 || index > size) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(index + mm.getMessage("engine.indexOutofBound"));
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            current.setCurrent(index);
            Object object = exp.calculate(ctx);
            return object;
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calc(int index, Expression[] exps, Context ctx, Object[] outValues) {
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        current.setCurrent(index);
        stack.push(current);
        try {
            int len = exps.length;
            for (int i = 0; i < len; ++i) {
                outValues[i] = exps[i].calculate(ctx);
            }
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence calc(Sequence seq, Expression exp, Context ctx) {
        if (exp == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("calc" + mm.getMessage("function.invalidParam"));
        }
        int size = this.length();
        int[] posArray = seq.toIntArray();
        int len = posArray.length;
        for (int i = 0; i < len; ++i) {
            if (posArray[i] >= 0 && posArray[i] <= size) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(posArray[i] + mm.getMessage("engine.indexOutofBound"));
        }
        Sequence result = new Sequence(len);
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            for (int i = 0; i < len; ++i) {
                current.setCurrent(posArray[i]);
                result.add(exp.calculate(ctx));
            }
            Sequence sequence = result;
            return sequence;
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object iterate(Expression exp, Object initVal, Expression c, String opt, Context ctx) {
        Param param = ctx.getIterateParam();
        Object oldVal = param.getValue();
        param.setValue(initVal);
        int len = this.length();
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            int i;
            if (opt == null || opt.indexOf(97) == -1) {
                int i2;
                if (c == null) {
                    for (i2 = 1; i2 <= len; ++i2) {
                        current.setCurrent(i2);
                        initVal = exp.calculate(ctx);
                        param.setValue(initVal);
                    }
                } else {
                    for (i2 = 1; i2 <= len; ++i2) {
                        current.setCurrent(i2);
                        Object obj = c.calculate(ctx);
                        if (!Variant.isTrue(obj)) {
                            initVal = exp.calculate(ctx);
                            param.setValue(initVal);
                            continue;
                        }
                        break;
                    }
                }
                Object i3 = initVal;
                return i3;
            }
            Sequence result = new Sequence(len);
            IArray resultMems = result.getMems();
            if (c == null) {
                for (i = 1; i <= len; ++i) {
                    current.setCurrent(i);
                    initVal = exp.calculate(ctx);
                    param.setValue(initVal);
                    resultMems.add(initVal);
                }
            } else {
                for (i = 1; i <= len; ++i) {
                    current.setCurrent(i);
                    Object obj = c.calculate(ctx);
                    if (!Variant.isTrue(obj)) {
                        initVal = exp.calculate(ctx);
                        param.setValue(initVal);
                        resultMems.add(initVal);
                        continue;
                    }
                    break;
                }
            }
            Sequence sequence = result;
            return sequence;
        }
        finally {
            stack.pop();
            param.setValue(oldVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Expression exp, String opt, Context ctx) {
        if (opt == null) {
            this.run(exp, ctx);
        } else if (opt.indexOf(109) != -1) {
            MultithreadUtil.run(this, exp, ctx);
        } else if (opt.indexOf(122) != -1) {
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(this);
            stack.push(current);
            try {
                for (int i = this.length(); i > 0; --i) {
                    current.setCurrent(i);
                    exp.calculate(ctx);
                }
            }
            finally {
                stack.pop();
            }
        } else {
            this.run(exp, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Expression[] assignExps, Expression[] exps, String opt, Context ctx, Sequence[] syncSequences) {
        int i;
        int colCount = exps.length;
        if (assignExps == null) {
            assignExps = new Expression[colCount];
        } else if (assignExps.length != colCount) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("run" + mm.getMessage("function.invalidParam"));
        }
        int syncCount = syncSequences.length;
        ComputeStack stack = ctx.getComputeStack();
        Current[] currents = new Current[syncCount + 1];
        currents[0] = new Current(this);
        stack.push(currents[0]);
        for (i = 1; i <= syncCount; ++i) {
            currents[i] = new Current(syncSequences[i - 1]);
            stack.push(currents[i]);
        }
        try {
            int len = this.length();
            for (i = 1; i <= len; ++i) {
                for (Current current : currents) {
                    current.setCurrent(i);
                }
                for (int c = 0; c < colCount; ++c) {
                    if (assignExps[c] == null) {
                        exps[c].calculate(ctx);
                        continue;
                    }
                    assignExps[c].assign(exps[c].calculate(ctx), ctx);
                }
            }
        }
        finally {
            for (i = 0; i <= syncCount; ++i) {
                stack.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Expression exp, String opt, Context ctx, Sequence[] syncSequences) {
        int i;
        int size = this.length();
        int syncCount = syncSequences.length;
        ComputeStack stack = ctx.getComputeStack();
        Current[] currents = new Current[syncCount + 1];
        currents[0] = new Current(this);
        stack.push(currents[0]);
        for (i = 1; i <= syncCount; ++i) {
            currents[i] = new Current(syncSequences[i - 1]);
            stack.push(currents[i]);
        }
        try {
            for (i = 1; i <= size; ++i) {
                for (Current current : currents) {
                    current.setCurrent(i);
                }
                exp.calculate(ctx);
            }
        }
        finally {
            for (i = 0; i <= syncCount; ++i) {
                stack.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Expression exp, Context ctx) {
        if (exp == null) {
            return;
        }
        int size = this.length();
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            for (int i = 1; i <= size; ++i) {
                current.setCurrent(i);
                exp.calculate(ctx);
            }
        }
        finally {
            stack.pop();
        }
    }

    public void run(Expression[] assignExps, Expression[] exps, String opt, Context ctx) {
        if (opt == null || opt.indexOf(109) == -1) {
            this.run(assignExps, exps, ctx);
        } else {
            MultithreadUtil.run(this, assignExps, exps, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Expression[] assignExps, Expression[] exps, Context ctx) {
        if (exps == null || exps.length == 0) {
            return;
        }
        int colCount = exps.length;
        if (assignExps == null) {
            assignExps = new Expression[colCount];
        } else if (assignExps.length != colCount) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("run" + mm.getMessage("function.invalidParam"));
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            int len = this.length();
            for (int i = 1; i <= len; ++i) {
                current.setCurrent(i);
                for (int c = 0; c < colCount; ++c) {
                    if (assignExps[c] == null) {
                        exps[c].calculate(ctx);
                        continue;
                    }
                    assignExps[c].assign(exps[c].calculate(ctx), ctx);
                }
            }
        }
        finally {
            stack.pop();
        }
    }

    private Object _$1(Sequence sub, String opt) {
        IArray subMems = sub.getMems();
        if (subMems.size() == 0) {
            return null;
        }
        IArray mems = this.getMems();
        return mems.pos(subMems, opt);
    }

    public Object pos(Object obj, String opt) {
        if (obj instanceof Sequence && (opt == null || opt.indexOf(112) == -1)) {
            return this._$1((Sequence)obj, opt);
        }
        boolean isAll = false;
        boolean isFirst = true;
        boolean isZero = false;
        boolean isNull = true;
        boolean isSorted = false;
        boolean isInsertPos = false;
        if (opt != null) {
            if (opt.indexOf(97) != -1) {
                isAll = true;
            }
            if (opt.indexOf(122) != -1) {
                isFirst = false;
            }
            if (opt.indexOf(110) != -1) {
                isNull = false;
            }
            if (opt.indexOf(48) != -1) {
                isZero = true;
            }
            if (opt.indexOf(98) != -1) {
                isSorted = true;
            }
            if (opt.indexOf(115) != -1) {
                isSorted = true;
                isInsertPos = true;
            }
        }
        if (isAll) {
            IntArray result = isFirst ? this.getMems().indexOfAll(obj, 1, isSorted, isFirst) : this.getMems().indexOfAll(obj, this.length(), isSorted, isFirst);
            return new Sequence(result);
        }
        int pos = isSorted ? this.getMems().binarySearch(obj) : (isFirst ? this.getMems().firstIndexOf(obj, 1) : this.getMems().lastIndexOf(obj, this.length()));
        if (pos > 0 || isInsertPos) {
            return ObjectCache.getInteger(pos);
        }
        if (isZero) {
            return ObjectCache.getInteger(0);
        }
        if (isNull) {
            return null;
        }
        return ObjectCache.getInteger(this.length() + 1);
    }

    public Object pos(Object obj, int startPos, String opt) {
        int end = this.length();
        if (startPos < 1 || startPos > end) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(startPos + mm.getMessage("engine.indexOutofBound"));
        }
        boolean isAll = false;
        boolean isFirst = true;
        boolean isZero = false;
        boolean isNull = true;
        boolean isSorted = false;
        if (opt != null) {
            if (opt.indexOf(97) != -1) {
                isAll = true;
            }
            if (opt.indexOf(122) != -1) {
                isFirst = false;
            }
            if (opt.indexOf(110) != -1) {
                isNull = false;
            }
            if (opt.indexOf(48) != -1) {
                isZero = true;
            }
            if (opt.indexOf(98) != -1) {
                isSorted = true;
            }
        }
        if (isAll) {
            IntArray result = this.getMems().indexOfAll(obj, startPos, false, isFirst);
            return new Sequence(result);
        }
        int pos = isSorted ? this.getMems().binarySearch(obj, startPos, end) : (isFirst ? this.getMems().firstIndexOf(obj, startPos) : this.getMems().lastIndexOf(obj, startPos));
        if (pos > 0) {
            return ObjectCache.getInteger(pos);
        }
        if (isZero) {
            return ObjectCache.getInteger(0);
        }
        if (isNull) {
            return null;
        }
        return ObjectCache.getInteger(this.length() + 1);
    }

    public int pseg(Object obj, String opt) {
        int index = this.getMems().binarySearch(obj);
        if (index < 1) {
            return -index - 1;
        }
        if (opt == null || opt.indexOf(114) == -1) {
            return index;
        }
        return index - 1;
    }

    public Object pmin(Expression exp, String opt, Context ctx) {
        int size = this.length();
        if (size == 0) {
            if (opt == null || opt.indexOf(97) == -1) {
                return null;
            }
            return new Sequence(0);
        }
        Sequence result = this.calc(exp, ctx);
        return result._$2(opt, 1, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pmin(Expression exp, int pos, String opt, Context ctx) {
        Sequence sequence;
        int len = this.length();
        if (pos < 1 || pos > len) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(pos + mm.getMessage("engine.indexOutofBound"));
        }
        int start = pos;
        int end = len;
        if (opt != null && opt.indexOf(122) != -1) {
            start = 1;
            end = pos;
        }
        if (exp == null) {
            sequence = this;
        } else {
            sequence = new Sequence(len);
            IArray valMems = sequence.getMems();
            for (int i = 1; i < start; ++i) {
                valMems.add(null);
            }
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(this);
            stack.push(current);
            try {
                for (int i = start; i <= end; ++i) {
                    current.setCurrent(i);
                    valMems.add(exp.calculate(ctx));
                }
            }
            finally {
                stack.pop();
            }
        }
        return sequence._$2(opt, start, end);
    }

    public Object pmax(Expression exp, String opt, Context ctx) {
        int size = this.length();
        if (size == 0) {
            if (opt == null || opt.indexOf(97) == -1) {
                return null;
            }
            return new Sequence(0);
        }
        Sequence sequence = this.calc(exp, ctx);
        return sequence._$1(opt, 1, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pmax(Expression exp, int pos, String opt, Context ctx) {
        Sequence sequence;
        int len = this.length();
        if (pos < 1 || pos > len) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(pos + mm.getMessage("engine.indexOutofBound"));
        }
        int start = pos;
        int end = len;
        if (opt != null && opt.indexOf(122) != -1) {
            start = 1;
            end = pos;
        }
        if (exp == null) {
            sequence = this;
        } else {
            sequence = new Sequence(len);
            IArray valMems = sequence.getMems();
            for (int i = 1; i < start; ++i) {
                valMems.add(null);
            }
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(this);
            stack.push(current);
            try {
                for (int i = start; i <= end; ++i) {
                    current.setCurrent(i);
                    valMems.add(exp.calculate(ctx));
                }
            }
            finally {
                stack.pop();
            }
        }
        return sequence._$1(opt, start, end);
    }

    private Object _$2(String opt, int start, int end) {
        boolean bAll = false;
        boolean bLast = false;
        boolean ignoreNull = true;
        if (opt != null) {
            if (opt.indexOf(97) != -1) {
                bAll = true;
            }
            if (opt.indexOf(122) != -1) {
                bLast = true;
            }
            if (opt.indexOf(48) != -1) {
                ignoreNull = false;
            }
        }
        IArray mems = this.getMems();
        Object minValue = null;
        if (bAll) {
            int result;
            Object temp;
            int i;
            IntArrayList indexList = new IntArrayList();
            if (ignoreNull) {
                for (i = start; i <= end; ++i) {
                    minValue = mems.get(i);
                    if (minValue == null) continue;
                    indexList.addInt(i);
                    break;
                }
                ++i;
                while (i <= end) {
                    temp = mems.get(i);
                    if (temp != null) {
                        result = Variant.compare(temp, minValue, true);
                        if (result < 0) {
                            minValue = temp;
                            indexList.clear();
                            indexList.addInt(i);
                        } else if (result == 0) {
                            indexList.addInt(i);
                        }
                    }
                    ++i;
                }
            } else {
                minValue = mems.get(start);
                indexList.addInt(start);
                for (i = start + 1; i <= end; ++i) {
                    temp = mems.get(i);
                    result = Variant.compare(temp, minValue, true);
                    if (result < 0) {
                        minValue = temp;
                        indexList.clear();
                        indexList.addInt(i);
                        continue;
                    }
                    if (result != 0) continue;
                    indexList.addInt(i);
                }
            }
            int resultSize = indexList.size();
            Sequence result2 = new Sequence(resultSize);
            IArray resultMems = result2.getMems();
            if (bLast) {
                for (int i2 = resultSize - 1; i2 >= 0; --i2) {
                    resultMems.add(ObjectCache.getInteger(indexList.get(i2)));
                }
            } else {
                for (int i3 = 0; i3 < resultSize; ++i3) {
                    resultMems.add(ObjectCache.getInteger(indexList.get(i3)));
                }
            }
            return result2;
        }
        int minPos = -1;
        if (ignoreNull) {
            int i;
            for (i = start; i <= end; ++i) {
                minValue = mems.get(i);
                if (minValue == null) continue;
                minPos = i;
                break;
            }
            ++i;
            while (i <= end) {
                Object temp = mems.get(i);
                if (temp != null) {
                    int result = Variant.compare(temp, minValue, true);
                    if (result < 0) {
                        minValue = temp;
                        minPos = i;
                    } else if (result == 0 && bLast) {
                        minPos = i;
                    }
                }
                ++i;
            }
            if (minPos != -1) {
                return ObjectCache.getInteger(minPos);
            }
            return null;
        }
        minValue = mems.get(start);
        minPos = start;
        for (int i = start + 1; i <= end; ++i) {
            Object temp = mems.get(i);
            int result = Variant.compare(temp, minValue, true);
            if (result < 0) {
                minValue = temp;
                minPos = i;
                continue;
            }
            if (result != 0 || !bLast) continue;
            minPos = i;
        }
        return ObjectCache.getInteger(minPos);
    }

    private Object _$1(String opt, int start, int end) {
        boolean bAll = false;
        boolean bLast = false;
        if (opt != null) {
            if (opt.indexOf(97) != -1) {
                bAll = true;
            }
            if (opt.indexOf(122) != -1) {
                bLast = true;
            }
        }
        IArray mems = this.getMems();
        IntArrayList indexList = new IntArrayList();
        Object maxValue = mems.get(start);
        indexList.addInt(start);
        for (int i = start + 1; i <= end; ++i) {
            Object temp = mems.get(i);
            int result = Variant.compare(maxValue, temp, true);
            if (result < 0) {
                maxValue = temp;
                indexList.clear();
                indexList.addInt(i);
                continue;
            }
            if (result != 0) continue;
            indexList.addInt(i);
        }
        if (maxValue == null) {
            indexList.clear();
        }
        int resultSize = indexList.size();
        if (bAll) {
            Sequence result = new Sequence(resultSize);
            IArray resultMems = result.getMems();
            if (bLast) {
                for (int i = resultSize - 1; i >= 0; --i) {
                    resultMems.add(indexList.get(i));
                }
            } else {
                for (int i = 0; i < resultSize; ++i) {
                    resultMems.add(indexList.get(i));
                }
            }
            return result;
        }
        if (resultSize == 0) {
            return null;
        }
        if (bLast) {
            return indexList.get(resultSize - 1);
        }
        return indexList.get(0);
    }

    public Object pselect(Expression exp, String opt, Context ctx) {
        Object result;
        boolean isAll = false;
        boolean isFirst = true;
        boolean isZero = false;
        boolean isNull = true;
        boolean isSorted = false;
        boolean isInsertPos = false;
        if (opt != null) {
            if (opt.indexOf(97) != -1) {
                isAll = true;
            }
            if (opt.indexOf(122) != -1) {
                isFirst = false;
            }
            if (opt.indexOf(110) != -1) {
                isNull = false;
            }
            if (opt.indexOf(48) != -1) {
                isZero = true;
            }
            if (opt.indexOf(98) != -1) {
                isSorted = true;
            }
            if (opt.indexOf(115) != -1) {
                isSorted = true;
                isInsertPos = true;
            }
        }
        if (exp == null) {
            if (isFirst) {
                return new Sequence(1, this.length());
            }
            return new Sequence(this.length(), 1);
        }
        int size = this.length();
        if (size == 0) {
            if (isAll) {
                if (isZero) {
                    return null;
                }
                return new Sequence(0);
            }
            if (isInsertPos) {
                return -1;
            }
            if (isZero) {
                return ObjectCache.getInteger(0);
            }
            if (isNull) {
                return null;
            }
            return 1;
        }
        if (isSorted) {
            if (isAll) {
                DataStruct ds = null;
                if (this instanceof Table) {
                    ds = this.dataStruct();
                } else {
                    Object val = this.getMem(1);
                    if (val instanceof BaseRecord) {
                        ds = ((BaseRecord)val).dataStruct();
                    }
                }
                Regions regions = this.binarySelect(exp.getHome(), ds, ctx);
                if (regions != null) {
                    ArrayList<Region> list = regions.getRegionList();
                    int total = 0;
                    for (Region region : list) {
                        total += region.end - region.start + 1;
                    }
                    if (total == 0) {
                        if (isZero) {
                            return null;
                        }
                        return new Sequence(0);
                    }
                    IntArray resultArray = new IntArray(total);
                    for (Region region : list) {
                        int end = region.end;
                        for (int i = region.start; i <= end; ++i) {
                            resultArray.pushInt(i);
                        }
                    }
                    return new Sequence(resultArray);
                }
            }
            result = this._$1(exp, isAll, isFirst, isInsertPos, 1, size, ctx);
        } else {
            result = this._$1(exp, isAll, isFirst, 1, size, ctx);
        }
        if (result != null) {
            Sequence seq;
            if (isAll && isZero && (seq = (Sequence)result).length() == 0) {
                return null;
            }
            return result;
        }
        if (isZero) {
            return ObjectCache.getInteger(0);
        }
        if (isNull) {
            return null;
        }
        return ObjectCache.getInteger(size + 1);
    }

    public Object pselect(Expression exp, int pos, String opt, Context ctx) {
        Object result;
        int len = this.length();
        if (pos < 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(pos + mm.getMessage("engine.indexOutofBound"));
        }
        if (pos > len) {
            if (opt == null) {
                return null;
            }
            if (opt.indexOf(97) != -1) {
                if (opt.indexOf(48) != -1) {
                    return null;
                }
                return new Sequence(0);
            }
            if (opt.indexOf(110) != -1) {
                return ObjectCache.getInteger(len + 1);
            }
            if (opt.indexOf(48) != -1) {
                return ObjectCache.getInteger(0);
            }
            return null;
        }
        boolean isAll = false;
        boolean isFirst = true;
        boolean isZero = false;
        boolean isNull = true;
        boolean isSorted = false;
        boolean isInsertPos = false;
        if (opt != null) {
            if (opt.indexOf(97) != -1) {
                isAll = true;
            }
            if (opt.indexOf(122) != -1) {
                isFirst = false;
            }
            if (opt.indexOf(110) != -1) {
                isNull = false;
            }
            if (opt.indexOf(48) != -1) {
                isZero = true;
            }
            if (opt.indexOf(98) != -1) {
                isSorted = true;
            }
            if (opt.indexOf(115) != -1) {
                isSorted = true;
                isInsertPos = true;
            }
        }
        if (exp == null) {
            if (isFirst) {
                return new Sequence(pos, len);
            }
            return new Sequence(pos, 1);
        }
        int start = pos;
        int end = len;
        if (!isFirst) {
            start = 1;
            end = pos;
        }
        if ((result = isSorted ? this._$1(exp, isAll, isFirst, isInsertPos, start, end, ctx) : this._$1(exp, isAll, isFirst, start, end, ctx)) != null) {
            Sequence seq;
            if (isAll && isZero && (seq = (Sequence)result).length() == 0) {
                return null;
            }
            return result;
        }
        if (isZero) {
            return ObjectCache.getInteger(0);
        }
        if (isNull) {
            return null;
        }
        return ObjectCache.getInteger(len + 1);
    }

    public Object pselect(Expression[] fltExps, Object[] vals, int pos, String opt, Context ctx) {
        if (fltExps == null || fltExps.length == 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("pselect" + mm.getMessage("function.paramValNull"));
        }
        if (vals == null || vals.length != fltExps.length) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("pselect" + mm.getMessage("function.paramCountNotMatch"));
        }
        int len = this.length();
        if (pos < 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(pos + mm.getMessage("engine.indexOutofBound"));
        }
        if (pos > len) {
            if (opt == null) {
                return null;
            }
            if (opt.indexOf(97) != -1) {
                if (opt.indexOf(48) != -1) {
                    return null;
                }
                return new Sequence(0);
            }
            if (opt.indexOf(48) != -1) {
                return ObjectCache.getInteger(0);
            }
            if (opt.indexOf(110) != -1) {
                return ObjectCache.getInteger(len + 1);
            }
            return null;
        }
        if (opt == null || opt.indexOf(122) == -1) {
            return this._$1(fltExps, vals, opt, pos, len, ctx);
        }
        return this._$1(fltExps, vals, opt, 1, pos, ctx);
    }

    public Object pselect(Expression[] fltExps, Object[] vals, String opt, Context ctx) {
        if (fltExps == null || fltExps.length == 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("pselect" + mm.getMessage("function.paramValNull"));
        }
        if (vals == null || vals.length != fltExps.length) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("pselect" + mm.getMessage("function.paramCountNotMatch"));
        }
        int size = this.length();
        if (size == 0) {
            if (opt == null) {
                return null;
            }
            if (opt.indexOf(97) != -1) {
                if (opt.indexOf(48) != -1) {
                    return null;
                }
                return new Sequence(0);
            }
            if (opt.indexOf(115) != -1) {
                return -1;
            }
            if (opt.indexOf(48) != -1) {
                return ObjectCache.getInteger(0);
            }
            if (opt.indexOf(110) != -1) {
                return ObjectCache.getInteger(1);
            }
            return null;
        }
        return this._$1(fltExps, vals, opt, 1, size, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _$1(Expression[] fltExps, Object[] vals, String opt, int start, int end, Context ctx) {
        boolean bAll = false;
        boolean bLast = false;
        boolean isSorted = false;
        boolean isInsertPos = false;
        boolean isZero = false;
        Integer NULL = null;
        if (opt != null) {
            if (opt.indexOf(97) != -1) {
                bAll = true;
            }
            if (opt.indexOf(122) != -1) {
                bLast = true;
            }
            if (opt.indexOf(98) != -1) {
                isSorted = true;
            }
            if (opt.indexOf(115) != -1) {
                isSorted = true;
                isInsertPos = true;
            }
            if (opt.indexOf(110) != -1) {
                NULL = ObjectCache.getInteger(this.length() + 1);
            } else if (opt.indexOf(48) != -1) {
                NULL = ObjectCache.getInteger(0);
                isZero = true;
            }
        }
        int colCount = fltExps.length;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            int i;
            Sequence result;
            if (isSorted) {
                Object flt;
                int c;
                int low = start;
                int high = end;
                int pos = -1;
                while (low <= high) {
                    int mid = low + high >> 1;
                    current.setCurrent(mid);
                    int cmp = 0;
                    for (c = 0; c < colCount && (cmp = Variant.compare(flt = fltExps[c].calculate(ctx), vals[c], true)) == 0; ++c) {
                    }
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    pos = mid;
                    break;
                }
                if (pos == -1) {
                    if (bAll) {
                        if (isZero) {
                            Object mid = null;
                            return mid;
                        }
                        Sequence mid = new Sequence(0);
                        return mid;
                    }
                    if (isInsertPos) {
                        Integer mid = -low;
                        return mid;
                    }
                    Integer mid = NULL;
                    return mid;
                }
                int first = 0;
                int last = 0;
                if (bAll || !bLast) {
                    block16: for (first = pos; first > start; --first) {
                        current.setCurrent(first - 1);
                        for (c = 0; c < colCount; ++c) {
                            flt = fltExps[c].calculate(ctx);
                            if (!Variant.isEquals(flt, vals[c])) break block16;
                        }
                    }
                }
                if (bAll || bLast) {
                    block18: for (last = pos; last < end; ++last) {
                        current.setCurrent(last + 1);
                        for (c = 0; c < colCount; ++c) {
                            flt = fltExps[c].calculate(ctx);
                            if (!Variant.isEquals(flt, vals[c])) break block18;
                        }
                    }
                }
                if (bAll) {
                    Sequence result2 = new Sequence(last - first + 1);
                    IArray resultMems = result2.getMems();
                    if (bLast) {
                        while (last >= first) {
                            resultMems.add(last);
                            --last;
                        }
                    } else {
                        while (first <= last) {
                            resultMems.add(first);
                            ++first;
                        }
                    }
                    Sequence sequence = result2;
                    return sequence;
                }
                if (bLast) {
                    Integer n = last;
                    return n;
                }
                Integer n = first;
                return n;
            }
            Sequence sequence = result = bAll ? new Sequence() : null;
            if (bLast) {
                block22: for (i = end; i >= start; --i) {
                    current.setCurrent(i);
                    for (int c = 0; c < colCount; ++c) {
                        Object flt = fltExps[c].calculate(ctx);
                        if (!Variant.isEquals(flt, vals[c])) continue block22;
                    }
                    if (!bAll) {
                        Integer c = i;
                        return c;
                    }
                    result.add(i);
                }
            } else {
                block24: for (i = start; i <= end; ++i) {
                    current.setCurrent(i);
                    for (int c = 0; c < colCount; ++c) {
                        Object flt = fltExps[c].calculate(ctx);
                        if (!Variant.isEquals(flt, vals[c])) continue block24;
                    }
                    if (!bAll) {
                        Integer n = i;
                        return n;
                    }
                    result.add(i);
                }
            }
            if (bAll) {
                if (isZero && result.length() == 0) {
                    Object var17_20 = null;
                    return var17_20;
                }
                Sequence sequence2 = result;
                return sequence2;
            }
            Integer n = NULL;
            return n;
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _$1(Node exp, Object val, boolean bLast, int start, int end, Context ctx) {
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            int mid;
            int low = start;
            int high = end;
            int pos = -1;
            while (low <= high) {
                mid = low + high >> 1;
                current.setCurrent(mid);
                Object flt = exp.calculate(ctx);
                int cmp = Variant.compare(flt, val, true);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                if (bLast) {
                    if (high - mid > 15) {
                        low = mid;
                        continue;
                    }
                    pos = mid;
                    break;
                }
                if (mid - low > 15) {
                    high = mid;
                    continue;
                }
                pos = mid;
                break;
            }
            if (pos == -1) {
                mid = -low;
                return mid;
            }
            if (bLast) {
                ++pos;
                while (pos <= high) {
                    current.setCurrent(pos);
                    Object flt = exp.calculate(ctx);
                    if (!Variant.isEquals(flt, val)) break;
                    ++pos;
                }
                int flt = pos - 1;
                return flt;
            }
            --pos;
            while (pos >= low) {
                current.setCurrent(pos);
                Object flt = exp.calculate(ctx);
                if (!Variant.isEquals(flt, val)) break;
                --pos;
            }
            int n = pos + 1;
            return n;
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _$1(Expression exp, boolean isAll, boolean isFirst, int start, int end, Context ctx) {
        Sequence result = isAll ? new Sequence() : null;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            if (isFirst) {
                for (int i = start; i <= end; ++i) {
                    current.setCurrent(i);
                    Object obj = exp.calculate(ctx);
                    if (!Variant.isTrue(obj)) continue;
                    if (!isAll) {
                        Integer n = i;
                        return n;
                    }
                    result.add(i);
                }
            } else {
                for (int i = end; i >= start; --i) {
                    current.setCurrent(i);
                    Object obj = exp.calculate(ctx);
                    if (!Variant.isTrue(obj)) continue;
                    if (!isAll) {
                        Integer n = i;
                        return n;
                    }
                    result.add(i);
                }
            }
        }
        finally {
            stack.pop();
        }
        if (isAll) {
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _$1(Expression exp, boolean isAll, boolean isFirst, boolean isInsertPos, int start, int end, Context ctx) {
        int last;
        int first;
        block39: {
            first = 0;
            last = 0;
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(this);
            stack.push(current);
            try {
                MessageManager mm;
                current.setCurrent(start);
                Object objFirst = exp.calculate(ctx);
                current.setCurrent(end);
                Object objLast = exp.calculate(ctx);
                if (!(objFirst instanceof Number) || !(objLast instanceof Number)) {
                    MessageManager mm2 = EngineMessage.get();
                    throw new RQException(mm2.getMessage("engine.needIntExp"));
                }
                double valFirst = ((Number)objFirst).doubleValue();
                double valLast = ((Number)objLast).doubleValue();
                if (valFirst > 0.0) {
                    if (isAll) {
                        Sequence sequence = new Sequence(0);
                        return sequence;
                    }
                    if (isInsertPos) {
                        Integer n = -1;
                        return n;
                    }
                    Object var18_19 = null;
                    return var18_19;
                }
                if (valLast < 0.0) {
                    if (isAll) {
                        Sequence sequence = new Sequence(0);
                        return sequence;
                    }
                    if (isInsertPos) {
                        Integer n = -end - 1;
                        return n;
                    }
                    Object var18_22 = null;
                    return var18_22;
                }
                if (valFirst == valLast) {
                    first = start;
                    last = end;
                    break block39;
                }
                int low = start;
                int high = end;
                int pos = -1;
                while (low <= high) {
                    int mid = low + high >> 1;
                    current.setCurrent(mid);
                    Object obj = exp.calculate(ctx);
                    if (!(obj instanceof Number)) {
                        MessageManager mm3 = EngineMessage.get();
                        throw new RQException(mm3.getMessage("engine.needIntExp"));
                    }
                    double value = ((Number)obj).doubleValue();
                    if (value < 0.0) {
                        low = mid + 1;
                        continue;
                    }
                    if (value > 0.0) {
                        high = mid - 1;
                        continue;
                    }
                    pos = mid;
                    break;
                }
                if (pos == -1) {
                    if (isAll) {
                        Sequence mid = new Sequence(0);
                        return mid;
                    }
                    if (isInsertPos) {
                        Integer mid = -low;
                        return mid;
                    }
                    Object mid = null;
                    return mid;
                }
                if (isAll || isFirst) {
                    for (first = pos; first > start; --first) {
                        current.setCurrent(first - 1);
                        Object obj = exp.calculate(ctx);
                        if (!(obj instanceof Number)) {
                            mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("engine.needIntExp"));
                        }
                        if (((Number)obj).doubleValue() != 0.0) break;
                    }
                }
                if (!isAll && isFirst) break block39;
                for (last = pos; last < end; ++last) {
                    current.setCurrent(last + 1);
                    Object obj = exp.calculate(ctx);
                    if (!(obj instanceof Number)) {
                        mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("engine.needIntExp"));
                    }
                    if (((Number)obj).doubleValue() == 0.0) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                stack.pop();
            }
        }
        if (isAll) {
            Sequence result = new Sequence(last - first + 1);
            IArray resultMems = result.getMems();
            if (isFirst) {
                while (first <= last) {
                    resultMems.add(first);
                    ++first;
                }
            } else {
                while (last >= first) {
                    resultMems.add(last);
                    --last;
                }
            }
            return result;
        }
        if (isFirst) {
            return first;
        }
        return last;
    }

    public Object minp(Expression exp, String opt, Context ctx) {
        int len = this.length();
        if (exp == null) {
            return len > 0 ? this.getMem(1) : null;
        }
        boolean bAll = false;
        boolean bLast = false;
        boolean ignoreNull = true;
        if (opt != null) {
            if (opt.indexOf(97) != -1) {
                bAll = true;
            }
            if (opt.indexOf(122) != -1) {
                bLast = true;
            }
            if (opt.indexOf(48) != -1) {
                ignoreNull = false;
            }
        }
        if (len == 0) {
            return bAll ? new Sequence(0) : null;
        }
        Sequence values = this.calc(exp, ctx);
        IntArray indexArray = values.getMems().ptop(1, bAll, bLast, ignoreNull);
        int resultSize = indexArray.size();
        if (resultSize == 0) {
            if (bAll) {
                return new Sequence();
            }
            return null;
        }
        if (bAll) {
            IArray mems = this.getMems();
            Sequence result = new Sequence(resultSize);
            for (int i = 1; i <= resultSize; ++i) {
                result.add(mems.get(indexArray.getInt(i)));
            }
            return result;
        }
        return this.getMem(indexArray.getInt(1));
    }

    public Object maxp(Expression exp, String opt, Context ctx) {
        int i;
        int len = this.length();
        if (exp == null) {
            return len > 0 ? this.getMem(len) : null;
        }
        boolean bAll = false;
        boolean bLast = false;
        if (opt != null) {
            if (opt.indexOf(97) != -1) {
                bAll = true;
            }
            if (opt.indexOf(122) != -1) {
                bLast = true;
            }
        }
        if (len == 0) {
            return bAll ? new Sequence(0) : null;
        }
        Sequence values = this.calc(exp, ctx);
        IArray valMems = values.getMems();
        Object maxValue = null;
        for (i = 1; i <= len && (maxValue = valMems.get(i)) == null; ++i) {
        }
        if (i > len) {
            if (bAll) {
                return new Sequence();
            }
            return null;
        }
        if (bAll) {
            IntArrayList indexList = new IntArrayList();
            indexList.addInt(i);
            ++i;
            while (i <= len) {
                Object temp = valMems.get(i);
                int result = Variant.compare(maxValue, temp, true);
                if (result < 0) {
                    maxValue = temp;
                    indexList.clear();
                    indexList.addInt(i);
                } else if (result == 0) {
                    indexList.addInt(i);
                }
                ++i;
            }
            int count = indexList.size();
            IArray mems = this.getMems();
            Sequence result = new Sequence(count);
            IArray resultMems = result.getMems();
            if (bLast) {
                for (i = count - 1; i >= 0; --i) {
                    resultMems.add(mems.get(indexList.getInt(i)));
                }
            } else {
                for (i = 0; i < count; ++i) {
                    resultMems.add(mems.get(indexList.getInt(i)));
                }
            }
            return result;
        }
        int q = i++;
        if (bLast) {
            while (i <= len) {
                Object temp = valMems.get(i);
                int result = Variant.compare(maxValue, temp, true);
                if (result < 0) {
                    maxValue = temp;
                    q = i;
                } else if (result == 0) {
                    q = i;
                }
                ++i;
            }
        } else {
            ++i;
            while (i <= len) {
                Object temp = valMems.get(i);
                if (Variant.compare(maxValue, temp, true) < 0) {
                    maxValue = temp;
                    q = i;
                }
                ++i;
            }
        }
        return this.getMem(q);
    }

    private Sequence _$1() {
        IArray mems = this.getMems();
        int size = mems.size();
        Sequence result = new Sequence(size);
        IArray resultMems = result.getMems();
        for (int i = 1; i <= size; ++i) {
            Object obj = mems.get(i);
            if (obj == null) continue;
            resultMems.add(obj);
        }
        return result;
    }

    public Object select(Expression exp, String opt, Context ctx) {
        Regions regions;
        boolean isAll = true;
        boolean isForward = true;
        boolean isBool = true;
        boolean isOrg = false;
        boolean returnTable = false;
        boolean isZero = false;
        if (opt != null) {
            if (opt.indexOf(109) != -1) {
                return MultithreadUtil.select(this, exp, ctx);
            }
            if (opt.indexOf(49) != -1) {
                isAll = false;
            }
            if (opt.indexOf(122) != -1) {
                isForward = false;
            }
            if (opt.indexOf(98) != -1) {
                isBool = false;
            }
            if (opt.indexOf(111) != -1) {
                isOrg = true;
            }
            if (opt.indexOf(116) != -1) {
                returnTable = true;
            }
            if (opt.indexOf(48) != -1) {
                isZero = true;
            }
        }
        if (this.length() == 0) {
            if (isOrg) {
                return this;
            }
            if (returnTable && this.dataStruct() != null) {
                return new Table(this.dataStruct());
            }
            if (isAll && !isZero) {
                return new Sequence(0);
            }
            return null;
        }
        if (exp == null) {
            if (isForward) {
                if (isOrg) {
                    return this;
                }
                return new Sequence(this);
            }
            if (isOrg) {
                this.mems = this.rvs().getMems();
                return this;
            }
            return this.rvs();
        }
        if (isBool) {
            return this._$5(exp, opt, ctx);
        }
        IArray mems = this.getMems();
        Object val = mems.get(1);
        DataStruct ds = null;
        if (val instanceof BaseRecord) {
            ds = ((BaseRecord)val).dataStruct();
        }
        if ((regions = this.binarySelect(exp.getHome(), ds, ctx)) == null) {
            return this._$4(exp, opt, ctx);
        }
        ArrayList<Region> list = regions.getRegionList();
        int total = 0;
        for (Region region : list) {
            total += region.end - region.start + 1;
        }
        if (total == 0) {
            if (returnTable && this.dataStruct() != null) {
                return new Table(this.dataStruct());
            }
            if (isAll && !isZero) {
                return new Sequence(0);
            }
            return null;
        }
        IArray resultArray = mems.newInstance(total);
        for (Region region : list) {
            int end = region.end;
            for (int i = region.start; i <= end; ++i) {
                resultArray.add(mems, i);
            }
        }
        return new Sequence(resultArray);
    }

    private boolean _$1(DataStruct ds, Node node) {
        if (node instanceof ValueList) {
            if (ds != null) {
                ValueList valueList = (ValueList)node;
                Expression[] exps = valueList.getParamExpressions("select", true);
                if (exps[0] != null) {
                    return this._$1(ds, exps[0].getHome());
                }
                return false;
            }
            return false;
        }
        if (node instanceof UnknownSymbol) {
            if (ds != null) {
                String name = ((UnknownSymbol)node).getName();
                if (name.charAt(0) == '\'' && name.charAt(name.length() - 1) == '\'') {
                    name = name.substring(1, name.length() - 1);
                }
                return ds.getFieldIndex(name) != -1;
            }
            return false;
        }
        if (node instanceof DotOperator) {
            node = node.getRight();
            if (ds != null && node instanceof FieldRef) {
                String name = ((FieldRef)node).getName();
                if (name.charAt(0) == '\'' && name.charAt(name.length() - 1) == '\'') {
                    name = name.substring(1, name.length() - 1);
                }
                return ds.getFieldIndex(name) != -1;
            }
            return ds == null && node instanceof CurrentElement;
        }
        if (node instanceof FieldId) {
            return ds != null;
        }
        return ds == null && node instanceof CurrentElement;
    }

    protected Regions binarySelect(Node node, DataStruct ds, Context ctx) {
        try {
            Object value;
            Node fieldNode;
            int operator;
            if (node instanceof Equals) {
                operator = 1;
            } else if (node instanceof Greater) {
                operator = 2;
            } else if (node instanceof NotSmaller) {
                operator = 3;
            } else if (node instanceof Smaller) {
                operator = 4;
            } else if (node instanceof NotGreater) {
                operator = 5;
            } else if (node instanceof NotEquals) {
                operator = 6;
            } else {
                if (node instanceof And) {
                    Regions r1 = this.binarySelect(node.getLeft(), ds, ctx);
                    Regions r2 = this.binarySelect(node.getRight(), ds, ctx);
                    return r1.and(r2);
                }
                if (node instanceof Or) {
                    Regions r1 = this.binarySelect(node.getLeft(), ds, ctx);
                    Regions r2 = this.binarySelect(node.getRight(), ds, ctx);
                    return r1.or(r2);
                }
                return null;
            }
            Node left = node.getLeft();
            Node right = node.getRight();
            if (this._$1(ds, left)) {
                fieldNode = left;
                value = right.calculate(ctx);
            } else if (this._$1(ds, right)) {
                fieldNode = right;
                value = left.calculate(ctx);
                operator = IFilter.getInverseOP(operator);
            } else {
                return null;
            }
            Regions regions = new Regions();
            int len = this.length();
            if (operator == 1) {
                int start = this._$1(fieldNode, value, false, 1, len, ctx);
                if (start < 1) {
                    return regions;
                }
                int end = this._$1(fieldNode, value, true, start, len, ctx);
                regions.addRegion(new Region(start, end));
            } else if (operator == 2) {
                int start = this._$1(fieldNode, value, true, 1, len, ctx);
                start = start < 1 ? -start : ++start;
                if (start <= len) {
                    regions.addRegion(new Region(start, len));
                }
            } else if (operator == 3) {
                int start = this._$1(fieldNode, value, false, 1, len, ctx);
                if (start < 1) {
                    start = -start;
                }
                if (start <= len) {
                    regions.addRegion(new Region(start, len));
                }
            } else if (operator == 4) {
                int end = this._$1(fieldNode, value, false, 1, len, ctx);
                if (end < 1) {
                    end = -end;
                }
                if (--end >= 1) {
                    regions.addRegion(new Region(1, end));
                }
            } else if (operator == 5) {
                int end = this._$1(fieldNode, value, true, 1, len, ctx);
                if (end < 1) {
                    end = -end - 1;
                }
                if (end >= 1) {
                    regions.addRegion(new Region(1, end));
                }
            } else {
                int start = this._$1(fieldNode, value, false, 1, len, ctx);
                if (start < 1) {
                    regions.addRegion(new Region(1, len));
                } else {
                    int end = this._$1(fieldNode, value, true, start, len, ctx);
                    if (start > 1) {
                        regions.addRegion(new Region(1, start - 1));
                    }
                    if (end < len) {
                        regions.addRegion(new Region(end + 1, len));
                    }
                }
            }
            return regions;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _$5(Expression exp, String opt, Context ctx) {
        IArray resultArray;
        boolean isZero;
        boolean returnTable;
        boolean isOrg;
        boolean bOne;
        block40: {
            bOne = false;
            boolean bLast = false;
            isOrg = false;
            returnTable = false;
            boolean continuous = false;
            boolean rc = false;
            isZero = false;
            if (opt != null) {
                if (opt.indexOf(49) != -1) {
                    bOne = true;
                } else if (opt.indexOf(114) != -1) {
                    rc = true;
                } else if (opt.indexOf(99) != -1) {
                    continuous = true;
                }
                if (opt.indexOf(122) != -1) {
                    bLast = true;
                }
                if (opt.indexOf(111) != -1) {
                    isOrg = true;
                }
                if (opt.indexOf(116) != -1) {
                    returnTable = true;
                }
                if (opt.indexOf(48) != -1) {
                    isZero = true;
                }
                if (opt.indexOf(105) != -1 && this.getIndexTable() != null) {
                    IndexTable index = this.getIndexTable();
                    if (index instanceof HashIndexTable) {
                        return ((HashIndexTable)index).select(exp, ctx);
                    }
                    if (index instanceof HashArrayIndexTable) {
                        return ((HashArrayIndexTable)index).select(exp, ctx);
                    }
                }
            }
            IArray mems = this.getMems();
            int len = mems.size();
            resultArray = bOne ? null : mems.newInstance(15);
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(this);
            stack.push(current);
            try {
                int i;
                if (!bLast) {
                    for (i = 1; i <= len; ++i) {
                        current.setCurrent(i);
                        Object obj = exp.calculate(ctx);
                        if (Variant.isTrue(obj)) {
                            if (rc) {
                                resultArray.add(mems, i);
                                ++i;
                                while (i <= len) {
                                    resultArray.add(mems, i);
                                    ++i;
                                }
                                continue;
                            }
                            if (bOne) {
                                if (isOrg) {
                                    this.mems = mems.newInstance(1);
                                    this.getMems().add(mems, i);
                                    Sequence sequence = this;
                                    return sequence;
                                }
                                Object object = mems.get(i);
                                return object;
                            }
                            resultArray.add(mems, i);
                            continue;
                        }
                        if (!continuous) continue;
                        break block40;
                    }
                    break block40;
                }
                for (i = len; i > 0; --i) {
                    current.setCurrent(i);
                    Object obj = exp.calculate(ctx);
                    if (Variant.isTrue(obj)) {
                        if (rc) {
                            resultArray.add(mems, i);
                            --i;
                            while (i > 0) {
                                resultArray.add(mems, i);
                                --i;
                            }
                            continue;
                        }
                        if (bOne) {
                            if (isOrg) {
                                this.mems = mems.newInstance(1);
                                this.getMems().add(mems, i);
                                Sequence sequence = this;
                                return sequence;
                            }
                            Object object = mems.get(i);
                            return object;
                        }
                        resultArray.add(mems, i);
                        continue;
                    }
                    if (!continuous) continue;
                    break;
                }
            }
            finally {
                stack.pop();
            }
        }
        if (bOne) {
            if (isOrg) {
                this.mems = new ObjectArray(0);
                return this;
            }
            return null;
        }
        if (isOrg) {
            this.mems = resultArray;
            return this;
        }
        if (resultArray.size() == 0) {
            if (returnTable) {
                Object obj = this.ifn();
                if (obj instanceof BaseRecord) {
                    return new Table(((BaseRecord)obj).dataStruct());
                }
                return new Sequence(resultArray);
            }
            if (isZero) {
                return null;
            }
            return new Sequence(resultArray);
        }
        return new Sequence(resultArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _$4(Expression exp, String opt, Context ctx) {
        int last;
        int first;
        boolean isOrg;
        boolean bLast;
        boolean bOne;
        block48: {
            bOne = false;
            bLast = false;
            isOrg = false;
            boolean returnTable = false;
            boolean isZero = false;
            if (opt != null) {
                if (opt.indexOf(49) != -1) {
                    bOne = true;
                }
                if (opt.indexOf(122) != -1) {
                    bLast = true;
                }
                if (opt.indexOf(111) != -1) {
                    isOrg = true;
                }
                if (opt.indexOf(116) != -1) {
                    returnTable = true;
                }
                if (opt.indexOf(48) != -1) {
                    isZero = true;
                }
            }
            int size = this.length();
            first = 0;
            last = 0;
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(this);
            stack.push(current);
            try {
                MessageManager mm;
                Object obj;
                current.setCurrent(1);
                Object objFirst = exp.calculate(ctx);
                current.setCurrent(size);
                Object objLast = exp.calculate(ctx);
                if (!(objFirst instanceof Number) || !(objLast instanceof Number)) {
                    MessageManager mm2 = EngineMessage.get();
                    throw new RQException(mm2.getMessage("engine.needIntExp"));
                }
                double valFirst = ((Number)objFirst).doubleValue();
                double valLast = ((Number)objLast).doubleValue();
                if (valFirst > 0.0 || valLast < 0.0) {
                    if (isOrg) {
                        this.mems = new ObjectArray(0);
                        Sequence sequence = this;
                        return sequence;
                    }
                    if (bOne || isZero) {
                        Object var20_20 = null;
                        return var20_20;
                    }
                    if (returnTable) {
                        Object obj2 = this.ifn();
                        if (obj2 instanceof BaseRecord) {
                            Table table = new Table(((BaseRecord)obj2).dataStruct());
                            return table;
                        }
                        Sequence sequence = new Sequence(0);
                        return sequence;
                    }
                    Sequence obj2 = new Sequence(0);
                    return obj2;
                }
                if (valFirst == valLast) {
                    first = 1;
                    last = size;
                    break block48;
                }
                int low = 1;
                int high = size;
                int pos = -1;
                while (low <= high) {
                    int mid = low + high >> 1;
                    current.setCurrent(mid);
                    obj = exp.calculate(ctx);
                    if (!(obj instanceof Number)) {
                        MessageManager mm3 = EngineMessage.get();
                        throw new RQException(mm3.getMessage("engine.needIntExp"));
                    }
                    double value = ((Number)obj).doubleValue();
                    if (value < 0.0) {
                        low = mid + 1;
                        continue;
                    }
                    if (value > 0.0) {
                        high = mid - 1;
                        continue;
                    }
                    pos = mid;
                    break;
                }
                if (pos == -1) {
                    if (isOrg) {
                        this.mems = new ObjectArray(0);
                        Sequence mid = this;
                        return mid;
                    }
                    if (bOne || isZero) {
                        Object mid = null;
                        return mid;
                    }
                    if (returnTable) {
                        Object obj3 = this.ifn();
                        if (obj3 instanceof BaseRecord) {
                            obj = new Table(((BaseRecord)obj3).dataStruct());
                            return obj;
                        }
                        obj = new Sequence(0);
                        return obj;
                    }
                    Sequence obj3 = new Sequence(0);
                    return obj3;
                }
                if (!bOne || !bLast) {
                    for (first = pos; first > 1; --first) {
                        current.setCurrent(first - 1);
                        Object obj4 = exp.calculate(ctx);
                        if (!(obj4 instanceof Number)) {
                            mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("engine.needIntExp"));
                        }
                        if (((Number)obj4).doubleValue() != 0.0) break;
                    }
                }
                if (bOne && !bLast) break block48;
                for (last = pos; last < size; ++last) {
                    current.setCurrent(last + 1);
                    Object obj5 = exp.calculate(ctx);
                    if (!(obj5 instanceof Number)) {
                        mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("engine.needIntExp"));
                    }
                    if (((Number)obj5).doubleValue() == 0.0) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                stack.pop();
            }
        }
        if (bOne) {
            if (isOrg) {
                Object val = bLast ? this.getMem(last) : this.getMem(first);
                this.mems = new ObjectArray(1);
                this.getMems().add(val);
                return this;
            }
            return bLast ? this.getMem(last) : this.getMem(first);
        }
        IArray resultArray = this.mems.newInstance(last - first + 1);
        IArray mems = this.getMems();
        if (bLast) {
            while (last >= first) {
                resultArray.add(mems, last);
                --last;
            }
        } else {
            while (first <= last) {
                resultArray.add(mems, first);
                ++first;
            }
        }
        if (isOrg) {
            this.mems = resultArray;
            return this;
        }
        return new Sequence(resultArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object select(Expression[] fltExps, Object[] vals, String opt, Context ctx) {
        int end;
        if (fltExps == null || fltExps.length == 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("select" + mm.getMessage("function.paramValNull"));
        }
        int colCount = fltExps.length;
        if (vals == null || vals.length != colCount) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("select" + mm.getMessage("function.paramCountNotMatch"));
        }
        boolean bOne = false;
        boolean bLast = false;
        boolean isSorted = false;
        boolean isOrg = false;
        boolean returnTable = false;
        boolean continuous = false;
        boolean rc = false;
        boolean isZero = false;
        if (opt != null) {
            if (opt.indexOf(109) != -1) {
                return MultithreadUtil.select(this, fltExps, vals, opt, ctx);
            }
            if (opt.indexOf(49) != -1) {
                bOne = true;
            } else if (opt.indexOf(114) != -1) {
                rc = true;
            } else if (opt.indexOf(99) != -1) {
                continuous = true;
            }
            if (opt.indexOf(122) != -1) {
                bLast = true;
            }
            if (opt.indexOf(98) != -1) {
                isSorted = true;
            }
            if (opt.indexOf(111) != -1) {
                isOrg = true;
            }
            if (opt.indexOf(116) != -1) {
                returnTable = true;
            }
            if (opt.indexOf(48) != -1) {
                isZero = true;
            }
        }
        if ((end = this.length()) == 0) {
            if (isOrg) {
                return this;
            }
            if (returnTable && this.dataStruct() != null) {
                return new Table(this.dataStruct());
            }
            if (bOne || isZero) {
                return null;
            }
            return new Sequence(0);
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            Sequence result;
            block88: {
                int i;
                if (isSorted) {
                    Object flt;
                    int c;
                    int low = 1;
                    int high = end;
                    int pos = -1;
                    while (low <= high) {
                        int mid = low + high >> 1;
                        current.setCurrent(mid);
                        int cmp = 0;
                        for (c = 0; c < colCount && (cmp = Variant.compare(flt = fltExps[c].calculate(ctx), vals[c], true)) == 0; ++c) {
                        }
                        if (cmp < 0) {
                            low = mid + 1;
                            continue;
                        }
                        if (cmp > 0) {
                            high = mid - 1;
                            continue;
                        }
                        pos = mid;
                        break;
                    }
                    if (pos == -1) {
                        if (isOrg) {
                            this.mems = new ObjectArray(0);
                            Sequence mid = this;
                            return mid;
                        }
                        if (bOne || isZero) {
                            Object mid = null;
                            return mid;
                        }
                        if (returnTable) {
                            Object obj = this.ifn();
                            if (obj instanceof BaseRecord) {
                                Table cmp = new Table(((BaseRecord)obj).dataStruct());
                                return cmp;
                            }
                            Sequence cmp = new Sequence(0);
                            return cmp;
                        }
                        Sequence obj = new Sequence(0);
                        return obj;
                    }
                    int first = 0;
                    int last = 0;
                    if (!bOne || !bLast) {
                        block26: for (first = pos; first > 1; --first) {
                            current.setCurrent(first - 1);
                            for (c = 0; c < colCount; ++c) {
                                flt = fltExps[c].calculate(ctx);
                                if (!Variant.isEquals(flt, vals[c])) break block26;
                            }
                        }
                    }
                    if (!bOne || bLast) {
                        block28: for (last = pos; last < end; ++last) {
                            current.setCurrent(last + 1);
                            for (c = 0; c < colCount; ++c) {
                                flt = fltExps[c].calculate(ctx);
                                if (!Variant.isEquals(flt, vals[c])) break block28;
                            }
                        }
                    }
                    if (bOne) {
                        if (isOrg) {
                            Object val = bLast ? this.getMem(last) : this.getMem(first);
                            this.mems = new ObjectArray(1);
                            this.getMems().add(val);
                            flt = this;
                            return flt;
                        }
                        Object val = bLast ? this.getMem(last) : this.getMem(first);
                        return val;
                    }
                    Sequence result2 = new Sequence(last - first + 1);
                    IArray mems = this.getMems();
                    IArray resultMems = result2.getMems();
                    if (bLast) {
                        while (last >= first) {
                            resultMems.add(mems.get(last));
                            --last;
                        }
                    } else {
                        while (first <= last) {
                            resultMems.add(mems.get(first));
                            ++first;
                        }
                    }
                    if (isOrg) {
                        this.mems = resultMems;
                        Sequence sequence = this;
                        return sequence;
                    }
                    if (returnTable && result2.length() == 0) {
                        Object obj = this.ifn();
                        if (obj instanceof BaseRecord) {
                            Table table = new Table(((BaseRecord)obj).dataStruct());
                            return table;
                        }
                        Sequence sequence = result2;
                        return sequence;
                    }
                    Sequence sequence = result2;
                    return sequence;
                }
                result = bOne ? null : new Sequence();
                IArray mems = this.getMems();
                if (bLast) {
                    block32: for (i = end; i > 0; --i) {
                        Object cur = mems.get(i);
                        current.setCurrent(i);
                        for (int c = 0; c < colCount; ++c) {
                            Object flt = fltExps[c].calculate(ctx);
                            if (Variant.isEquals(flt, vals[c])) continue;
                            if (!continuous) continue block32;
                            break block88;
                        }
                        if (rc) {
                            result.add(mems.get(i));
                            --i;
                            while (i > 0) {
                                result.add(mems.get(i));
                                --i;
                            }
                            continue;
                        }
                        if (bOne) {
                            if (isOrg) {
                                this.mems = new ObjectArray(1);
                                this.getMems().add(cur);
                                Sequence c = this;
                                return c;
                            }
                            Object c = cur;
                            return c;
                        }
                        result.add(cur);
                    }
                } else {
                    block35: for (i = 1; i <= end; ++i) {
                        current.setCurrent(i);
                        for (int c = 0; c < colCount; ++c) {
                            Object flt = fltExps[c].calculate(ctx);
                            if (Variant.isEquals(flt, vals[c])) continue;
                            if (!continuous) continue block35;
                            break block88;
                        }
                        if (rc) {
                            result.add(mems.get(i));
                            ++i;
                            while (i <= end) {
                                result.add(mems.get(i));
                                ++i;
                            }
                            continue;
                        }
                        if (bOne) {
                            if (isOrg) {
                                this.mems = new ObjectArray(1);
                                this.getMems().add(mems.get(i));
                                Sequence sequence = this;
                                return sequence;
                            }
                            Object object = mems.get(i);
                            return object;
                        }
                        result.add(mems.get(i));
                    }
                }
            }
            if (bOne) {
                if (isOrg) {
                    this.mems = new ObjectArray(0);
                    Sequence i = this;
                    return i;
                }
                Object i = null;
                return i;
            }
            if (isOrg) {
                this.mems = result.getMems();
                Sequence i = this;
                return i;
            }
            if (result.length() == 0) {
                if (returnTable) {
                    Object obj = this.ifn();
                    if (obj instanceof BaseRecord) {
                        Table table = new Table(((BaseRecord)obj).dataStruct());
                        return table;
                    }
                    Sequence sequence = result;
                    return sequence;
                }
                if (isZero) {
                    Object var19_29 = null;
                    return var19_29;
                }
            }
            Sequence sequence = result;
            return sequence;
        }
        finally {
            stack.pop();
        }
    }

    public Sequence sort(Expression exp, String loc, String opt, Context ctx) {
        if (this.length() == 0) {
            if (this instanceof Table || opt != null && opt.indexOf(111) != -1) {
                return this;
            }
            return new Sequence(0);
        }
        boolean isDesc = false;
        boolean isOrg = false;
        boolean isNullLast = false;
        if (opt != null) {
            if (opt.indexOf(117) != -1) {
                return this._$1(exp, ctx);
            }
            if (opt.indexOf(122) != -1) {
                isDesc = true;
            }
            if (opt.indexOf(111) != -1) {
                isOrg = true;
            }
            if (opt.indexOf(48) != -1) {
                isNullLast = true;
            }
            if (opt.indexOf(110) != -1) {
                Sequence seq = this._$1(exp, "s", ctx);
                if (isOrg) {
                    this.mems = seq.getMems();
                    return this;
                }
                return seq;
            }
        }
        IArray mems = this.getMems();
        int len = mems.size();
        Sequence values = this.calc(exp, opt, ctx);
        IArray valMems = values.getMems();
        Object[] infos = new PSortItem[len + 1];
        for (int i = 1; i <= len; ++i) {
            infos[i] = new PSortItem(i, valMems.get(i));
        }
        Collator collator = null;
        if (loc != null && loc.length() != 0) {
            Locale locale = Sequence._$2(loc);
            collator = Collator.getInstance((Locale)locale);
        }
        Comparator<Object> comparator = isDesc || isNullLast ? new CommonComparator(collator, !isDesc, isNullLast) : (collator != null ? new LocaleComparator(collator, true) : new BaseComparator());
        comparator = new PSortComparator(comparator);
        MultithreadUtil.sort(infos, 1, infos.length, comparator);
        Sequence result = new Sequence(len);
        IArray resultMems = result.getMems();
        for (int i = 1; i <= len; ++i) {
            resultMems.add(mems.get(((PSortItem)infos[i]).index));
        }
        if (isOrg) {
            this.mems = resultMems;
            return this;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence sort(Expression[] exps, String loc, String opt, Context ctx) {
        Comparator<Object> comparator;
        if (this.length() == 0) {
            if (this instanceof Table || opt != null && opt.indexOf(111) != -1) {
                return this;
            }
            return new Sequence(0);
        }
        boolean isDesc = false;
        boolean isOrg = false;
        boolean isNullLast = false;
        if (opt != null) {
            if (opt.indexOf(117) != -1) {
                return this._$2(exps, ctx);
            }
            if (opt.indexOf(122) != -1) {
                isDesc = true;
            }
            if (opt.indexOf(111) != -1) {
                isOrg = true;
            }
            if (opt.indexOf(48) != -1) {
                isNullLast = true;
            }
        }
        IArray mems = this.getMems();
        int len = mems.size();
        Object[][] values = new Object[len + 1][];
        int fcount = exps.length;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            int arrayLen = fcount + 1;
            for (int i = 1; i <= len; ++i) {
                current.setCurrent(i);
                Object[] curVals = new Object[arrayLen];
                values[i] = curVals;
                curVals[fcount] = mems.get(i);
                for (int f = 0; f < fcount; ++f) {
                    curVals[f] = exps[f].calculate(ctx);
                }
            }
        }
        finally {
            stack.pop();
        }
        Collator collator = null;
        if (loc != null && loc.length() != 0) {
            Locale locale = Sequence._$2(loc);
            collator = Collator.getInstance((Locale)locale);
        }
        if (collator != null || isDesc || isNullLast) {
            CommonComparator cmp = new CommonComparator(collator, !isDesc, isNullLast);
            CommonComparator[] cmps = new CommonComparator[fcount];
            for (int i = 0; i < fcount; ++i) {
                cmps[i] = cmp;
            }
            comparator = new ArrayComparator2(cmps, fcount);
        } else {
            comparator = new ArrayComparator(fcount);
        }
        MultithreadUtil.sort((Object[])values, 1, values.length, comparator);
        if (isOrg) {
            for (int i = 1; i <= len; ++i) {
                mems.set(i, values[i][fcount]);
            }
            return this;
        }
        Sequence result = new Sequence(len);
        mems = result.getMems();
        for (int i = 1; i <= len; ++i) {
            mems.add(values[i][fcount]);
        }
        return result;
    }

    public Sequence sort(Expression[] exps, String loc, String opt, int[] findex, Context ctx) {
        if (this.length() == 0) {
            if (this instanceof Table || opt != null && opt.indexOf(111) != -1) {
                return this;
            }
            return new Sequence(0);
        }
        boolean isDesc = false;
        boolean isOrg = false;
        boolean isNullLast = false;
        if (opt != null) {
            if (opt.indexOf(117) != -1) {
                return this._$2(exps, ctx);
            }
            if (opt.indexOf(122) != -1) {
                isDesc = true;
            }
            if (opt.indexOf(111) != -1) {
                isOrg = true;
            }
            if (opt.indexOf(48) != -1) {
                isNullLast = true;
            }
        }
        if (!isOrg) {
            return this.sort(exps, loc, opt, ctx);
        }
        Collator collator = null;
        if (loc != null && loc.length() != 0) {
            Locale locale = Sequence._$2(loc);
            collator = Collator.getInstance((Locale)locale);
        }
        if (collator != null || isDesc || isNullLast) {
            return this.sort(exps, loc, opt, ctx);
        }
        RecordFieldComparator comparator = new RecordFieldComparator(findex);
        Object[] values = ((ObjectArray)this.mems).getDatas();
        int len = this.mems.size() + 1;
        MultithreadUtil.sort(values, 1, len, comparator);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence sort(Expression[] exps, int[] orders, String loc, String opt, Context ctx) {
        if (this.length() == 0) {
            if (this instanceof Table || opt != null && opt.indexOf(111) != -1) {
                return this;
            }
            return new Sequence(0);
        }
        boolean isOrg = false;
        boolean isNullLast = false;
        if (opt != null) {
            if (opt.indexOf(117) != -1) {
                return this._$2(exps, ctx);
            }
            if (opt.indexOf(111) != -1) {
                isOrg = true;
            }
            if (opt.indexOf(48) != -1) {
                isNullLast = true;
            }
        }
        IArray mems = this.getMems();
        int len = mems.size();
        Object[][] values = new Object[len + 1][];
        int fcount = exps.length;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            int arrayLen = fcount + 1;
            for (int i = 1; i <= len; ++i) {
                current.setCurrent(i);
                Object[] curVals = new Object[arrayLen];
                values[i] = curVals;
                curVals[fcount] = mems.get(i);
                for (int f = 0; f < fcount; ++f) {
                    curVals[f] = exps[f].calculate(ctx);
                }
            }
        }
        finally {
            stack.pop();
        }
        Collator collator = null;
        if (loc != null && loc.length() != 0) {
            Locale locale = Sequence._$2(loc);
            collator = Collator.getInstance((Locale)locale);
        }
        CommonComparator[] cmps = new CommonComparator[fcount];
        for (int i = 0; i < fcount; ++i) {
            cmps[i] = new CommonComparator(collator, orders[i] >= 0, isNullLast);
        }
        ArrayComparator2 comparator = new ArrayComparator2(cmps, fcount);
        MultithreadUtil.sort((Object[])values, 1, values.length, comparator);
        if (isOrg) {
            for (int i = 1; i <= len; ++i) {
                mems.set(i, values[i][fcount]);
            }
            return this;
        }
        Sequence result = new Sequence(len);
        mems = result.getMems();
        for (int i = 1; i <= len; ++i) {
            mems.add(values[i][fcount]);
        }
        return result;
    }

    public Object median(int index, int seqCount) {
        if (this.length() == 0) {
            return null;
        }
        if (0 == index && 0 == seqCount) {
            index = 1;
            seqCount = 2;
        }
        if (0 > index || index > seqCount || seqCount < 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("median" + mm.getMessage("function.invalidParam"));
        }
        Sequence seq = this.sort(null);
        return seq.median(1, this.length(), index, seqCount);
    }

    public void add(Object val) {
        this.getMems().add(val);
    }

    public void addAll(Sequence sequence) {
        if (sequence != null) {
            this.getMems().addAll(sequence.getMems());
        }
    }

    public void append(Sequence sequence, int index, int count) {
        this.getMems().addAll(sequence.getMems(), index, count);
    }

    public void addAll(Object[] objs) {
        if (objs != null) {
            this.getMems().addAll(objs);
        }
    }

    public Sequence append(Sequence seq) {
        this.getMems().addAll(seq.getMems());
        return this;
    }

    public Object delete(int index, String opt) {
        int oldLen = this.length();
        if (index > 0 && index <= oldLen) {
            if (opt == null || opt.indexOf(110) == -1) {
                this.getMems().remove(index);
                this.rebuildIndexTable();
                return this;
            }
            Object obj = this.getMems().get(index);
            this.getMems().remove(index);
            this.rebuildIndexTable();
            return obj;
        }
        if (index < 0 && (index += oldLen + 1) > 0) {
            if (opt == null || opt.indexOf(110) == -1) {
                this.getMems().remove(index);
                this.rebuildIndexTable();
                return this;
            }
            Object obj = this.getMems().get(index);
            this.getMems().remove(index);
            this.rebuildIndexTable();
            return obj;
        }
        if (opt == null || opt.indexOf(110) == -1) {
            return this;
        }
        return null;
    }

    public void delete(int index) {
        int oldLen = this.length();
        if (index > 0 && index <= oldLen) {
            this.getMems().remove(index);
        } else if (index < 0 && (index += oldLen + 1) > 0) {
            this.getMems().remove(index);
        }
    }

    public void delete(int from, int to) {
        if (from < 1 || to < from || to > this.length()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(from + ":" + to + mm.getMessage("engine.indexOutofBound"));
        }
        this.getMems().removeRange(from, to);
    }

    public int[] toIndexArray(int totalCount) {
        IArray mems = this.getMems();
        if (!mems.isNumberArray()) {
            return null;
        }
        int size = mems.size();
        int[] values = new int[size];
        int count = 0;
        for (int i = 1; i <= size; ++i) {
            int index = mems.getInt(i);
            if (index > 0 && index <= totalCount) {
                values[count++] = index;
                continue;
            }
            if (index >= 0 || (index += totalCount + 1) <= 0) continue;
            values[count++] = index;
        }
        Arrays.sort(values, 0, count);
        int repeatCount = 0;
        for (int i = 1; i < count; ++i) {
            if (values[i] != values[i - 1]) continue;
            ++repeatCount;
        }
        if (repeatCount > 0) {
            int resultCount = count - repeatCount;
            int[] result = new int[resultCount];
            result[0] = values[0];
            int q = 1;
            for (int i = 1; i < count; ++i) {
                if (values[i] == values[i - 1]) continue;
                result[q++] = values[i];
            }
            return result;
        }
        if (count == size) {
            return values;
        }
        int[] result = new int[count];
        System.arraycopy(values, 0, result, 0, count);
        return result;
    }

    public Sequence delete(Sequence sequence, String opt) {
        if (sequence == null || sequence.length() == 0) {
            if (opt == null || opt.indexOf(110) == -1) {
                return this;
            }
            return new Sequence(0);
        }
        int srcCount = this.length();
        int[] index = sequence.toIndexArray(srcCount);
        if (index == null) {
            Sequence tmp = this.diff(sequence, false);
            this.mems = tmp.getMems();
            if (opt == null || opt.indexOf(110) == -1) {
                return this;
            }
            return sequence;
        }
        if (opt == null || opt.indexOf(110) == -1) {
            this.getMems().remove(index);
            return this;
        }
        int delCount = index.length;
        IArray mems = this.getMems();
        Sequence result = new Sequence(delCount);
        for (int i = 0; i < delCount; ++i) {
            result.add(mems.get(index[i]));
        }
        mems.remove(index);
        return result;
    }

    public void deleteNull(boolean emptySeq) {
        IArray mems = this.getMems();
        int len = mems.size();
        int nullCount = 0;
        if (emptySeq) {
            for (int i = 1; i <= len; ++i) {
                Sequence seq = (Sequence)mems.get(i);
                if (seq.length() != 0) continue;
                ++nullCount;
            }
            if (nullCount == len) {
                this.mems = new ObjectArray(1);
            } else if (nullCount > 0) {
                ObjectArray tmp = new ObjectArray(len - nullCount);
                for (int i = 1; i <= len; ++i) {
                    Sequence seq = (Sequence)mems.get(i);
                    if (seq.length() == 0) continue;
                    tmp.add(seq);
                }
                this.mems = tmp;
            }
        } else {
            for (int i = 1; i <= len; ++i) {
                Object obj = mems.get(i);
                if (obj != null) continue;
                ++nullCount;
            }
            if (nullCount == len) {
                this.mems = new ObjectArray(1);
            } else if (nullCount > 0) {
                ObjectArray tmp = new ObjectArray(len - nullCount);
                for (int i = 1; i <= len; ++i) {
                    Object obj = mems.get(i);
                    if (obj == null) continue;
                    tmp.add(obj);
                }
                this.mems = tmp;
            }
        }
    }

    public void deleteNullFieldRecord(int f) {
        IArray mems = this.getMems();
        int len = mems.size();
        int nullCount = 0;
        for (int i = 1; i <= len; ++i) {
            BaseRecord r = (BaseRecord)mems.get(i);
            if (r.getFieldValue(f) != null) continue;
            ++nullCount;
        }
        if (nullCount == len) {
            this.mems = new ObjectArray(1);
            this.rebuildIndexTable();
        } else if (nullCount > 0) {
            ObjectArray tmp = new ObjectArray(len - nullCount);
            for (int i = 1; i <= len; ++i) {
                BaseRecord r = (BaseRecord)mems.get(i);
                if (r.getFieldValue(f) == null) continue;
                tmp.add(r);
            }
            this.mems = tmp;
            this.rebuildIndexTable();
        }
    }

    public void deleteNullFieldRecord(String fieldName) {
        IArray mems = this.getMems();
        int len = mems.size();
        int nullCount = 0;
        int col = -1;
        BaseRecord prevRecord = null;
        for (int i = 1; i <= len; ++i) {
            Object obj = mems.get(i);
            if (obj instanceof BaseRecord) {
                BaseRecord cur = (BaseRecord)obj;
                if (prevRecord == null || !prevRecord.isSameDataStruct(cur)) {
                    col = cur.getFieldIndex(fieldName);
                    if (col < 0) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(fieldName + mm.getMessage("ds.fieldNotExist"));
                    }
                    prevRecord = cur;
                }
                if (cur.getFieldValue(col) != null) continue;
                ++nullCount;
                continue;
            }
            ++nullCount;
        }
        if (nullCount == len) {
            this.mems = new ObjectArray(1);
            this.rebuildIndexTable();
        } else if (nullCount > 0) {
            ObjectArray tmp = new ObjectArray(len - nullCount);
            for (int i = 1; i <= len; ++i) {
                Object obj = mems.get(i);
                if (!(obj instanceof BaseRecord)) continue;
                BaseRecord cur = (BaseRecord)obj;
                if (prevRecord == null || !prevRecord.isSameDataStruct(cur)) {
                    col = cur.getFieldIndex(fieldName);
                    if (col < 0) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(fieldName + mm.getMessage("ds.fieldNotExist"));
                    }
                    prevRecord = cur;
                }
                if (cur.getFieldValue(col) == null) continue;
                tmp.add(cur);
            }
            this.mems = tmp;
            this.rebuildIndexTable();
        }
    }

    public void rebuildIndexTable() {
    }

    public void reserve(int start, int end) {
        int size = this.length();
        if (start == 0) {
            start = 1;
        } else if (start < 0 && (start += size + 1) < 1) {
            start = 1;
        }
        if (end == 0) {
            end = size;
        } else if (end < 0) {
            end += size + 1;
        } else if (end > size) {
            end = size;
        }
        if (start == 1 && end == size) {
            return;
        }
        if (end < start) {
            this.getMems().clear();
        } else {
            this.getMems().reserve(start, end);
        }
    }

    public Sequence split(int from, int to) {
        if (from < 1 || to < from || to > this.length()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(from + ":" + to + mm.getMessage("engine.indexOutofBound"));
        }
        return new Sequence(this.getMems().split(from, to));
    }

    public Sequence split(int pos) {
        return new Sequence(this.getMems().split(pos));
    }

    public void insert(int pos, Object val) {
        IArray mems = this.getMems();
        int oldLen = mems.size();
        if (pos == 0) {
            pos = oldLen + 1;
        } else if (pos < 0) {
            if ((pos += oldLen + 1) < 1) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(pos - oldLen - 1 + mm.getMessage("engine.indexOutofBound"));
            }
        } else if (pos > oldLen + 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(pos + mm.getMessage("engine.indexOutofBound"));
        }
        if (val instanceof Sequence) {
            IArray srcMems = ((Sequence)val).getMems();
            mems.insertAll(pos, srcMems);
        } else {
            mems.insert(pos, val);
        }
    }

    public void sortedInsert(Object val) {
        if (val instanceof Sequence) {
            IArray mems = this.getMems();
            IArray src = ((Sequence)val).getMems();
            int len = src.size();
            for (int i = 1; i <= len; ++i) {
                val = src.get(i);
                int index = mems.binarySearch(val);
                if (index >= 0) continue;
                mems.insert(-index, val);
            }
        } else {
            int index = this.mems.binarySearch(val);
            if (index < 0) {
                this.mems.insert(-index, val);
            }
        }
    }

    public Object modify(int pos, Object val, String opt) {
        IArray mems = this.getMems();
        int oldLen = mems.size();
        if (pos < 0) {
            if ((pos += oldLen + 1) < 1) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(pos - oldLen - 1 + mm.getMessage("engine.indexOutofBound"));
            }
        } else if (pos == 0) {
            pos = oldLen + 1;
        }
        if (val instanceof Sequence) {
            IArray srcMems = ((Sequence)val).getMems();
            int srcLen = srcMems.size();
            int endPos = pos + srcLen - 1;
            if (endPos > oldLen) {
                mems.addAll(new Object[endPos - oldLen]);
            }
            if (opt == null || opt.indexOf(110) == -1) {
                int i = 1;
                while (i <= srcLen) {
                    mems.set(pos, srcMems.get(i));
                    ++i;
                    ++pos;
                }
                return this;
            }
            Sequence result = new Sequence(srcLen);
            int i = 1;
            while (i <= srcLen) {
                result.add(mems.get(pos));
                mems.set(pos, srcMems.get(i));
                ++i;
                ++pos;
            }
            return result;
        }
        if (pos > oldLen) {
            mems.addAll(new Object[pos - oldLen]);
        }
        if (opt == null || opt.indexOf(110) == -1) {
            mems.set(pos, val);
            return this;
        }
        Object old = mems.get(pos);
        mems.set(pos, val);
        return old;
    }

    public int[] toIntArray() {
        IArray mems = this.getMems();
        if (!mems.isNumberArray()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needIntSeries"));
        }
        int size = mems.size();
        int[] values = new int[size];
        for (int i = 1; i <= size; ++i) {
            values[i - 1] = mems.getInt(i);
        }
        return values;
    }

    public void set(int pos, Object obj) {
        if (pos < 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(pos + mm.getMessage("engine.indexOutofBound"));
        }
        int oldSize = this.length();
        if (pos > oldSize) {
            this.mems.addAll(new Object[pos - oldSize]);
        }
        this.mems.set(pos, obj);
    }

    public Sequence swap(Sequence iseq1, Sequence iseq2) {
        int i;
        int temp;
        if (iseq1 == null || iseq2 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("swap" + mm.getMessage("function.paramValNull"));
        }
        if (!iseq1._$3() || !iseq2._$3()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needIntInterval"));
        }
        int length1 = iseq1.length();
        int length2 = iseq2.length();
        IArray mems = this.getMems();
        int total = mems.size();
        int s1 = ((Number)iseq1.getMem(1)).intValue();
        int e1 = ((Number)iseq1.getMem(length1)).intValue();
        int s2 = ((Number)iseq2.getMem(1)).intValue();
        int e2 = ((Number)iseq2.getMem(length2)).intValue();
        if (e1 < s1) {
            temp = e1;
            e1 = s1;
            s1 = temp;
        }
        if (s1 < 1 || e1 > total) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.indexOutofBound"));
        }
        if (e2 < s2) {
            temp = e2;
            e2 = s2;
            s2 = temp;
        }
        if (s2 < 1 || e2 > total) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.indexOutofBound"));
        }
        if (s1 > s2) {
            temp = s1;
            s1 = s2;
            s2 = temp;
            temp = e1;
            e1 = e2;
            e2 = temp;
        }
        if (e1 >= s2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.areaOverlap"));
        }
        Sequence result = new Sequence(total);
        IArray resultMems = result.getMems();
        for (i = 1; i < s1; ++i) {
            resultMems.add(mems.get(i));
        }
        for (i = s2; i <= e2; ++i) {
            resultMems.add(mems.get(i));
        }
        for (i = e1 + 1; i < s2; ++i) {
            resultMems.add(mems.get(i));
        }
        for (i = s1; i <= e1; ++i) {
            resultMems.add(mems.get(i));
        }
        for (i = e2 + 1; i <= total; ++i) {
            resultMems.add(mems.get(i));
        }
        return result;
    }

    public Sequence pad(Object val, int n, String opt) {
        if (n < 1) {
            return this;
        }
        int len = this.length();
        int addCount = 0;
        if (opt == null || opt.indexOf(109) == -1) {
            addCount = n - len;
        } else {
            int mod = len % n;
            if (mod == 0) {
                return this;
            }
            addCount = n - mod;
        }
        if (addCount < 1) {
            return this;
        }
        Sequence result = new Sequence(len + addCount);
        if (val instanceof Sequence) {
            Sequence seq = (Sequence)val;
            int count = seq.length();
            if (count > 1) {
                if (opt == null || opt.indexOf(108) == -1) {
                    result.addAll(this);
                    while (count <= addCount) {
                        result.addAll(seq);
                        addCount -= count;
                    }
                    if (addCount > 0) {
                        result.getMems().addAll(seq.getMems(), addCount);
                    }
                } else {
                    while (count <= addCount) {
                        result.addAll(seq);
                        addCount -= count;
                    }
                    if (addCount > 0) {
                        result.getMems().addAll(seq.getMems(), addCount);
                    }
                    result.addAll(this);
                }
                return result;
            }
            if (count == 1) {
                val = seq.getMem(1);
            }
        }
        if (opt == null || opt.indexOf(108) == -1) {
            result.addAll(this);
            for (int i = 0; i < addCount; ++i) {
                result.add(val);
            }
        } else {
            for (int i = 0; i < addCount; ++i) {
                result.add(val);
            }
            result.addAll(this);
        }
        return result;
    }

    public void getNewFieldNames(Expression[] exps, String[] names, String funcName) {
        int colCount = exps.length;
        DataStruct ds = this.getFirstRecordDataStruct();
        for (int i = 0; i < colCount; ++i) {
            if (names[i] == null || names[i].length() == 0) {
                if (exps[i] == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(funcName + mm.getMessage("function.invalidParam"));
                }
                names[i] = exps[i].getFieldName(ds);
                continue;
            }
            if (exps[i] != null) continue;
            exps[i] = Expression.NULL;
        }
    }

    public Table newTable(String[] names, Expression[] exps, Context ctx) {
        return this.newTable(names, exps, null, ctx);
    }

    public Table newTable(String[] names, Expression[] exps, String opt, Context ctx) {
        if (names == null) {
            if (exps == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("new" + mm.getMessage("function.invalidParam"));
            }
            names = new String[exps.length];
        } else if (exps == null || names.length != exps.length) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("new" + mm.getMessage("function.invalidParam"));
        }
        this.getNewFieldNames(exps, names, "new");
        DataStruct ds = new DataStruct(names);
        if (opt == null || opt.indexOf(109) == -1) {
            return this.newTable(ds, exps, opt, ctx);
        }
        return MultithreadUtil.newTable(this, ds, exps, opt, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table newTable(DataStruct ds, Expression[] exps, String opt, Context ctx) {
        int len = this.length();
        int colCount = ds.getFieldCount();
        Table table = new Table(ds, len);
        IArray resultMems = table.getMems();
        boolean iopt = false;
        boolean zopt = false;
        if (opt != null) {
            if (opt.indexOf(105) != -1) {
                iopt = true;
            }
            if (opt.indexOf(122) != -1) {
                zopt = true;
            }
        }
        ComputeStack stack = ctx.getComputeStack();
        Current newCurrent = new Current(table);
        stack.push(newCurrent);
        Current current = new Current(this);
        stack.push(current);
        try {
            if (zopt) {
                table.getRecord(len);
                if (iopt) {
                    block3: for (int i = len; i > 0; --i) {
                        Record r = (Record)resultMems.get(i);
                        newCurrent.setCurrent(i);
                        current.setCurrent(i);
                        for (int c = 0; c < colCount; ++c) {
                            Object obj = exps[c].calculate(ctx);
                            if (obj == null) {
                                resultMems.remove(i);
                                continue block3;
                            }
                            r.setNormalFieldValue(c, obj);
                        }
                    }
                } else {
                    for (int i = len; i > 0; --i) {
                        Record r = (Record)resultMems.get(i);
                        newCurrent.setCurrent(i);
                        current.setCurrent(i);
                        for (int c = 0; c < colCount; ++c) {
                            r.setNormalFieldValue(c, exps[c].calculate(ctx));
                        }
                    }
                }
            } else if (iopt) {
                int q = 1;
                block7: for (int i = 1; i <= len; ++i) {
                    Record r = new Record(ds);
                    resultMems.add(r);
                    newCurrent.setCurrent(q);
                    current.setCurrent(i);
                    for (int c = 0; c < colCount; ++c) {
                        Object obj = exps[c].calculate(ctx);
                        if (obj == null) {
                            resultMems.remove(q);
                            continue block7;
                        }
                        r.setNormalFieldValue(c, obj);
                    }
                    ++q;
                }
            } else {
                for (int i = 1; i <= len; ++i) {
                    Record r = new Record(ds);
                    resultMems.add(r);
                    newCurrent.setCurrent(i);
                    current.setCurrent(i);
                    for (int c = 0; c < colCount; ++c) {
                        r.setNormalFieldValue(c, exps[c].calculate(ctx));
                    }
                }
            }
        }
        finally {
            stack.pop();
            stack.pop();
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence newSequences(Expression gexp, Expression exp, Context ctx) {
        int len = this.length();
        Sequence result = new Sequence(len * 2);
        IArray resultMems = result.getMems();
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            for (int i = 1; i <= len; ++i) {
                current.setCurrent(i);
                Object obj = gexp.calculate(ctx);
                Sequence seq = null;
                if (obj instanceof Sequence) {
                    seq = (Sequence)obj;
                } else if (obj instanceof Number) {
                    int n = ((Number)obj).intValue();
                    if (n > 0) {
                        seq = new Sequence(1, n);
                    }
                } else if (obj != null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("news" + mm.getMessage("function.paramTypeError"));
                }
                if (seq == null || seq.length() == 0) continue;
                try {
                    Current curCurrent = new Current(seq);
                    stack.push(curCurrent);
                    int curLen = seq.length();
                    for (int m = 1; m <= curLen; ++m) {
                        curCurrent.setCurrent(m);
                        resultMems.add(exp.calculate(ctx));
                    }
                    continue;
                }
                finally {
                    stack.pop();
                }
            }
        }
        finally {
            stack.pop();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table newTables(Expression gexp, Expression[] exps, DataStruct ds, String opt, Context ctx) {
        int len = this.length();
        Table result = new Table(ds, len * 2);
        IArray resultMems = result.getMems();
        int fcount = ds.getFieldCount();
        int resultSeq = 1;
        boolean isLeft = opt != null && opt.indexOf(49) != -1;
        Sequence ns = null;
        if (isLeft) {
            ArrayList<String> fieldList = new ArrayList<String>();
            for (Expression exp : exps) {
                exp.getUsedFields(ctx, fieldList);
            }
            Object obj = this.ifn();
            DataStruct oldDs = null;
            if (obj instanceof BaseRecord) {
                oldDs = ((BaseRecord)obj).dataStruct();
            }
            HashSet<String> set = new HashSet<String>();
            for (String name : fieldList) {
                if (oldDs != null && oldDs.getFieldIndex(name) != -1) continue;
                set.add(name);
            }
            ns = new Sequence(1);
            int count = set.size();
            if (count == 0) {
                ns.add(null);
            } else {
                String[] names = new String[set.size()];
                set.toArray(names);
                Record nullRecord = new Record(new DataStruct(names));
                ns.add(nullRecord);
            }
        }
        ComputeStack stack = ctx.getComputeStack();
        Current resultCurrent = new Current(result);
        Current current = new Current(this);
        stack.push(resultCurrent);
        stack.push(current);
        try {
            for (int i = 1; i <= len; ++i) {
                current.setCurrent(i);
                Object obj = gexp.calculate(ctx);
                Sequence seq = null;
                if (obj instanceof Sequence) {
                    seq = (Sequence)obj;
                } else if (obj instanceof Number) {
                    int n = ((Number)obj).intValue();
                    if (n > 0) {
                        seq = new Sequence(1, n);
                    }
                } else {
                    if (obj instanceof BaseRecord) {
                        try {
                            stack.push((BaseRecord)obj);
                            resultCurrent.setCurrent(resultSeq);
                            Record r = new Record(ds);
                            resultMems.add(r);
                            ++resultSeq;
                            for (int f = 0; f < fcount; ++f) {
                                r.setNormalFieldValue(f, exps[f].calculate(ctx));
                            }
                            continue;
                        }
                        finally {
                            stack.pop();
                        }
                    }
                    if (obj != null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("news" + mm.getMessage("function.paramTypeError"));
                    }
                }
                if (seq == null || seq.length() == 0) {
                    if (!isLeft) continue;
                    seq = ns;
                }
                try {
                    Current curCurrent = new Current(seq);
                    stack.push(curCurrent);
                    int curLen = seq.length();
                    int m = 1;
                    while (m <= curLen) {
                        resultCurrent.setCurrent(resultSeq);
                        curCurrent.setCurrent(m);
                        Record r = new Record(ds);
                        resultMems.add(r);
                        for (int f = 0; f < fcount; ++f) {
                            r.setNormalFieldValue(f, exps[f].calculate(ctx));
                        }
                        ++m;
                        ++resultSeq;
                    }
                    continue;
                }
                finally {
                    stack.pop();
                }
            }
        }
        finally {
            stack.pop();
            stack.pop();
        }
        return result;
    }

    public Table newTables(Expression gexp, String[] names, Expression[] exps, String opt, Context ctx) {
        if (names == null) {
            if (exps == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("news" + mm.getMessage("function.invalidParam"));
            }
            names = new String[exps.length];
        } else if (exps == null || names.length != exps.length) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("news" + mm.getMessage("function.invalidParam"));
        }
        int colCount = names.length;
        for (int i = 0; i < colCount; ++i) {
            if (names[i] == null || names[i].length() == 0) {
                if (exps[i] == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("news" + mm.getMessage("function.invalidParam"));
                }
                names[i] = exps[i].getFieldName();
                continue;
            }
            if (exps[i] != null) continue;
            exps[i] = Expression.NULL;
        }
        DataStruct ds = new DataStruct(names);
        if (opt == null || opt.indexOf(109) == -1) {
            return this.newTables(gexp, exps, ds, opt, ctx);
        }
        return MultithreadUtil.newTables(this, gexp, exps, ds, opt, ctx);
    }

    public Table toTable() {
        IArray mems = this.getMems();
        int len = mems.size();
        if (len == 0) {
            return null;
        }
        Object obj = mems.get(1);
        if (!(obj instanceof Sequence)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needSeriesMember"));
        }
        Sequence seq = (Sequence)obj;
        int fcount = seq.length();
        Object[] names = new String[fcount];
        seq.toArray(names);
        Table table = new Table((String[])names, len - 1);
        for (int i = 2; i <= len; ++i) {
            obj = mems.get(i);
            if (obj instanceof Sequence) {
                seq = (Sequence)obj;
                int curLen = seq.length();
                if (curLen > fcount) {
                    curLen = fcount;
                }
                BaseRecord r = table.newLast();
                for (int f = 0; f < curLen; ++f) {
                    r.setNormalFieldValue(f, seq.getMem(f + 1));
                }
                continue;
            }
            if (obj == null) {
                table.newLast();
                continue;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needSeriesMember"));
        }
        return table;
    }

    public Table derive(String opt) {
        IArray mems = this.getMems();
        int len = mems.size();
        DataStruct ds = this.dataStruct();
        if (ds == null) {
            if (len == 0) {
                return null;
            }
            Object val = mems.get(1);
            if (val instanceof BaseRecord) {
                ds = ((BaseRecord)val).dataStruct();
            }
            if (ds == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needPurePmt"));
            }
            ds = ds.dup();
            Context ctx = new Context();
            String[] names = ds.getFieldNames();
            int fcount = names.length;
            Expression[] exps = new Expression[fcount];
            for (int f = 0; f < fcount; ++f) {
                exps[f] = new Expression(ctx, "'" + names[f] + "'");
            }
            return this.newTable(ds, exps, null, ctx);
        }
        ds = ds.dup();
        Table table = new Table(ds, len);
        if (opt == null || opt.indexOf(111) == -1) {
            for (int i = 1; i <= len; ++i) {
                BaseRecord r = (BaseRecord)mems.get(i);
                table.newLast(r.getFieldValues());
            }
        } else {
            IArray dest = table.getMems();
            for (int i = 1; i <= len; ++i) {
                BaseRecord br = (BaseRecord)mems.get(i);
                Record r = br.toRecord();
                r.setDataStruct(ds);
                dest.add(r);
            }
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table derive(DataStruct newDs, Expression[] exps, String opt, Context ctx) {
        IArray mems = this.getMems();
        int len = mems.size();
        int colCount = exps.length;
        int oldColCount = newDs.getFieldCount() - colCount;
        Table table = new Table(newDs, len);
        IArray resultMems = table.getMems();
        ComputeStack stack = ctx.getComputeStack();
        Current newCurrent = new Current(table);
        stack.push(newCurrent);
        Current current = new Current(this);
        stack.push(current);
        try {
            if (opt == null || opt.indexOf(105) == -1) {
                for (int i = 1; i <= len; ++i) {
                    Record r = new Record(newDs);
                    resultMems.add(r);
                    r.set((BaseRecord)mems.get(i));
                    newCurrent.setCurrent(i);
                    current.setCurrent(i);
                    for (int c = 0; c < colCount; ++c) {
                        r.setNormalFieldValue(c + oldColCount, exps[c].calculate(ctx));
                    }
                }
            } else {
                int q = 1;
                block5: for (int i = 1; i <= len; ++i) {
                    Record r = new Record(newDs);
                    resultMems.add(r);
                    r.set((BaseRecord)mems.get(i));
                    newCurrent.setCurrent(q);
                    current.setCurrent(i);
                    for (int c = 0; c < colCount; ++c) {
                        Object obj = exps[c].calculate(ctx);
                        if (obj == null) {
                            resultMems.remove(q);
                            continue block5;
                        }
                        r.setNormalFieldValue(c + oldColCount, obj);
                    }
                    ++q;
                }
            }
        }
        finally {
            stack.pop();
            stack.pop();
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table derive(String[] names, Expression[] exps, String opt, Context ctx) {
        boolean iopt = false;
        boolean zopt = false;
        if (opt != null) {
            if (opt.indexOf(109) != -1) {
                return MultithreadUtil.derive(this, names, exps, opt, ctx);
            }
            if (opt.indexOf(105) != -1) {
                iopt = true;
            }
            if (opt.indexOf(122) != -1) {
                zopt = true;
            }
        }
        IArray mems = this.getMems();
        int len = mems.size();
        DataStruct ds = this.dataStruct();
        int colCount = exps.length;
        if (ds == null) {
            if (len == 0) {
                return null;
            }
            Object val = mems.get(1);
            if (val instanceof BaseRecord) {
                ds = ((BaseRecord)val).dataStruct();
            }
            if (ds == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needPurePmt"));
            }
            String[] srcNames = ds.getFieldNames();
            int srcCount = srcNames.length;
            int totalCount = srcCount + colCount;
            String[] totalNames = new String[totalCount];
            Expression[] totalExps = new Expression[totalCount];
            for (int f = 0; f < srcCount; ++f) {
                totalExps[f] = new Expression(ctx, "~.'" + srcNames[f] + "'");
            }
            System.arraycopy(srcNames, 0, totalNames, 0, srcCount);
            System.arraycopy(names, 0, totalNames, srcCount, colCount);
            System.arraycopy(exps, 0, totalExps, srcCount, colCount);
            return this.newTable(totalNames, totalExps, null, ctx);
        }
        for (int i = 0; i < colCount; ++i) {
            if (names[i] == null || names[i].length() == 0) {
                if (exps[i] == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("derive" + mm.getMessage("function.invalidParam"));
                }
                names[i] = exps[i].getFieldName(ds);
                continue;
            }
            if (exps[i] != null) continue;
            exps[i] = Expression.NULL;
        }
        String[] oldNames = ds.getFieldNames();
        int oldColCount = oldNames.length;
        int newColCount = oldColCount + colCount;
        String[] totalNames = new String[newColCount];
        System.arraycopy(oldNames, 0, totalNames, 0, oldColCount);
        System.arraycopy(names, 0, totalNames, oldColCount, colCount);
        DataStruct newDs = ds.create(totalNames);
        Table table = new Table(newDs, len);
        IArray resultMems = table.getMems();
        ComputeStack stack = ctx.getComputeStack();
        Current newCurrent = new Current(table);
        stack.push(newCurrent);
        Current current = new Current(this);
        stack.push(current);
        try {
            if (zopt) {
                table.getRecord(len);
                if (iopt) {
                    block5: for (int i = len; i > 0; --i) {
                        Record r = (Record)resultMems.get(i);
                        newCurrent.setCurrent(i);
                        current.setCurrent(i);
                        for (int c = 0; c < colCount; ++c) {
                            Object obj = exps[c].calculate(ctx);
                            if (obj == null) {
                                resultMems.remove(i);
                                continue block5;
                            }
                            r.setNormalFieldValue(c + oldColCount, obj);
                        }
                        r.set((BaseRecord)mems.get(i));
                    }
                } else {
                    for (int i = len; i > 0; --i) {
                        Record r = (Record)resultMems.get(i);
                        r.set((BaseRecord)mems.get(i));
                        newCurrent.setCurrent(i);
                        current.setCurrent(i);
                        for (int c = 0; c < colCount; ++c) {
                            r.setNormalFieldValue(c + oldColCount, exps[c].calculate(ctx));
                        }
                    }
                }
            } else if (iopt) {
                int q = 1;
                block9: for (int i = 1; i <= len; ++i) {
                    Record r = new Record(newDs);
                    resultMems.add(r);
                    r.set((BaseRecord)mems.get(i));
                    newCurrent.setCurrent(q);
                    current.setCurrent(i);
                    for (int c = 0; c < colCount; ++c) {
                        Object obj = exps[c].calculate(ctx);
                        if (obj == null) {
                            resultMems.remove(q);
                            continue block9;
                        }
                        r.setNormalFieldValue(c + oldColCount, obj);
                    }
                    ++q;
                }
            } else {
                for (int i = 1; i <= len; ++i) {
                    Record r = new Record(newDs);
                    resultMems.add(r);
                    r.set((BaseRecord)mems.get(i));
                    newCurrent.setCurrent(i);
                    current.setCurrent(i);
                    for (int c = 0; c < colCount; ++c) {
                        r.setNormalFieldValue(c + oldColCount, exps[c].calculate(ctx));
                    }
                }
            }
        }
        finally {
            stack.pop();
            stack.pop();
        }
        return table;
    }

    public Table derive(String[] names, Expression[] exps, String opt, Context ctx, int level) {
        int len = this.length();
        if (len == 0) {
            return null;
        }
        DataStruct ds = this.dataStruct();
        if (ds == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        String[] srcFieldNames = ds.getFieldNames();
        int fcount = srcFieldNames.length;
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<Expression> expList = new ArrayList<Expression>();
        IArray mems = this.getMems();
        for (int f = 0; f < fcount; ++f) {
            BaseRecord r;
            Object fval = null;
            for (int i = 1; i <= len && (fval = (r = (BaseRecord)mems.get(i)).getNormalFieldValue(f)) == null; ++i) {
            }
            String expStr = "#" + (f + 1);
            if (fval instanceof BaseRecord) {
                Sequence._$1((BaseRecord)fval, expStr, srcFieldNames[f], 2, level, ctx, nameList, expList);
                continue;
            }
            nameList.add(srcFieldNames[f]);
            Expression exp = new Expression(ctx, expStr);
            expList.add(exp);
        }
        fcount = nameList.size();
        int newCount = names != null ? names.length : 0;
        String[] totalNames = new String[fcount + newCount];
        Expression[] totalExps = new Expression[fcount + newCount];
        nameList.toArray(totalNames);
        expList.toArray(totalExps);
        if (newCount > 0) {
            System.arraycopy(names, 0, totalNames, fcount, newCount);
            System.arraycopy(exps, 0, totalExps, fcount, newCount);
        }
        return this.newTable(totalNames, totalExps, opt, ctx);
    }

    private static void _$1(BaseRecord r, String prevField, String prevFieldName, int curLevel, int totalLevel, Context ctx, ArrayList<String> nameList, ArrayList<Expression> expList) {
        String[] srcFieldNames = r.getFieldNames();
        int fcount = srcFieldNames.length;
        if (curLevel == totalLevel) {
            for (int f = 0; f < fcount; ++f) {
                String expStr = prevField + ".#" + (f + 1);
                if (nameList.contains(srcFieldNames[f])) {
                    nameList.add(prevFieldName + '_' + srcFieldNames[f]);
                } else {
                    nameList.add(srcFieldNames[f]);
                }
                Expression exp = new Expression(ctx, expStr);
                expList.add(exp);
            }
        } else {
            ++curLevel;
            for (int f = 0; f < fcount; ++f) {
                Object fval = r.getNormalFieldValue(f);
                String expStr = prevField + ".#" + (f + 1);
                if (fval instanceof BaseRecord) {
                    String name = prevFieldName + '_' + srcFieldNames[f];
                    Sequence._$1((BaseRecord)fval, expStr, name, curLevel, totalLevel, ctx, nameList, expList);
                    continue;
                }
                nameList.add(srcFieldNames[f]);
                Expression exp = new Expression(ctx, expStr);
                expList.add(exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object penum(Object obj, String opt, Context ctx, ICellSet cs) {
        int len = this.length();
        boolean isRepeat = opt != null && opt.indexOf(114) != -1;
        Sequence sequence = isRepeat ? new Sequence(2) : null;
        Sequence arg = new Sequence(1);
        arg.add(obj);
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            for (int i = 1; i <= len; ++i) {
                current.setCurrent(i);
                Object idgVal = this.getMem(i);
                if (idgVal != null && !(idgVal instanceof String)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("ds.idfTypeError"));
                }
                String temp = (String)idgVal;
                if (temp == null || temp.length() == 0) {
                    Object mm;
                    if (i != len) {
                        mm = EngineMessage.get();
                        throw new RQException(((MessageManager)mm).getMessage("engine.enumFilterNull"));
                    }
                    if (isRepeat) {
                        if (sequence.length() == 0) {
                            sequence.add(i);
                        }
                        mm = sequence;
                        return mm;
                    }
                    mm = i;
                    return mm;
                }
                Object result = this._$1(temp, cs, ctx, arg);
                if (!Variant.isTrue(result)) continue;
                if (isRepeat) {
                    sequence.add(i);
                    continue;
                }
                Integer n = i;
                return n;
            }
        }
        finally {
            stack.pop();
        }
        if (isRepeat) {
            if (sequence.length() == 0 && opt != null && opt.indexOf(110) != -1) {
                sequence.add(len + 1);
            }
            return sequence;
        }
        if (opt == null || opt.indexOf(110) == -1) {
            return null;
        }
        return len + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _$1(String strExp, ICellSet cs, Context ctx, Sequence arg) {
        Expression exp = new Expression(cs, ctx, strExp);
        ComputeStack stack = ctx.getComputeStack();
        try {
            stack.pushArg(arg);
            Object object = exp.calculate(ctx);
            return object;
        }
        finally {
            stack.popArg();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence enumerate(Sequence filters, Expression argExp, String opt, Context ctx, ICellSet cs) {
        if (filters == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("enum" + mm.getMessage("function.paramValNull"));
        }
        boolean notRepeat = true;
        boolean bPos = false;
        boolean isNull = false;
        if (opt != null) {
            if (opt.indexOf(114) != -1) {
                notRepeat = false;
            }
            if (opt.indexOf(112) != -1) {
                bPos = true;
            }
            if (opt.indexOf(110) != -1) {
                isNull = true;
            }
        }
        IArray filterMems = filters.getMems();
        int fsize = filterMems.size();
        Expression[] enumFilter = new Expression[fsize + 2];
        for (int i = 1; i <= fsize; ++i) {
            Object idgVal = filterMems.get(i);
            if (idgVal != null && !(idgVal instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("ds.idfTypeError"));
            }
            String temp = (String)idgVal;
            if (temp == null || temp.length() == 0) {
                if (i == fsize) continue;
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.enumFilterNull"));
            }
            enumFilter[i] = new Expression(cs, ctx, temp);
        }
        if (isNull && enumFilter[fsize] != null) {
            ++fsize;
        }
        Sequence result = new Sequence(fsize);
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            int i;
            IArray selMems = this.getMems();
            int selLen = selMems.size();
            Sequence arg = new Sequence(1);
            arg.add(null);
            Sequence[] groups = new Sequence[fsize + 1];
            for (i = 1; i <= fsize; ++i) {
                groups[i] = new Sequence();
                result.add(groups[i]);
            }
            if (enumFilter[fsize] == null) {
                for (i = 1; i <= selLen; ++i) {
                    current.setCurrent(i);
                    arg.set(1, argExp.calculate(ctx));
                    stack.pushArg(arg);
                    try {
                        boolean bAdd = false;
                        for (int s = 1; s < fsize; ++s) {
                            Object value = enumFilter[s].calculate(ctx);
                            if (!Variant.isTrue(value)) continue;
                            if (!bPos) {
                                groups[s].add(selMems.get(i));
                            } else {
                                groups[s].add(ObjectCache.getInteger(i));
                            }
                            bAdd = true;
                            if (notRepeat) break;
                        }
                        if (bAdd) continue;
                        if (!bPos) {
                            groups[fsize].add(selMems.get(i));
                            continue;
                        }
                        groups[fsize].add(ObjectCache.getInteger(i));
                        continue;
                    }
                    finally {
                        stack.popArg();
                    }
                }
            } else {
                block13: for (i = 1; i <= selLen; ++i) {
                    current.setCurrent(i);
                    arg.set(1, argExp.calculate(ctx));
                    stack.pushArg(arg);
                    try {
                        for (int s = 1; s <= fsize; ++s) {
                            Object value = enumFilter[s].calculate(ctx);
                            if (!Variant.isTrue(value)) continue;
                            if (!bPos) {
                                groups[s].add(selMems.get(i));
                            } else {
                                groups[s].add(ObjectCache.getInteger(i));
                            }
                            if (!notRepeat) continue;
                            continue block13;
                        }
                        continue;
                    }
                    finally {
                        stack.popArg();
                    }
                }
            }
        }
        finally {
            stack.pop();
        }
        return result;
    }

    public Sequence align(Expression exp, Sequence target, String opt, Context ctx) {
        if (target == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("align" + mm.getMessage("function.paramValNull"));
        }
        boolean isAll = false;
        boolean isSorted = false;
        boolean isPos = false;
        boolean isNull = false;
        boolean isConj = false;
        boolean isMerge = false;
        if (opt != null) {
            if (opt.indexOf(97) != -1) {
                isAll = true;
            }
            if (opt.indexOf(98) != -1) {
                isSorted = true;
            }
            if (opt.indexOf(112) != -1) {
                isPos = true;
            }
            if (opt.indexOf(111) != -1) {
                isMerge = true;
            }
            if (opt.indexOf(110) != -1) {
                isAll = true;
                isNull = true;
            }
            if (opt.indexOf(115) != -1) {
                isAll = true;
                isNull = true;
                isConj = true;
            }
        }
        Sequence values = this.calc(exp, ctx);
        IArray mems = this.getMems();
        IArray valMems = values.getMems();
        IArray tgtMems = target.getMems();
        int valSize = valMems.size();
        int tgtSize = tgtMems.size();
        if (isMerge) {
            if (isAll) {
                Sequence result = new Sequence(tgtSize);
                int index = 1;
                for (int i = 1; i <= tgtSize; ++i) {
                    Object val = tgtMems.get(i);
                    Sequence sub = new Sequence(4);
                    while (index <= valSize) {
                        int cmp = Variant.compare(valMems.get(index), val, isMerge);
                        if (cmp == 0) {
                            sub.add(mems.get(index));
                            ++index;
                            continue;
                        }
                        if (cmp > 0) break;
                        ++index;
                    }
                    result.add(sub);
                }
                return result;
            }
            Sequence result = new Sequence(tgtSize);
            int index = 1;
            block2: for (int i = 1; i <= tgtSize; ++i) {
                Object val = tgtMems.get(i);
                while (index <= valSize) {
                    int cmp = Variant.compare(valMems.get(index), val, isMerge);
                    if (cmp == 0) {
                        result.add(mems.get(index));
                        ++index;
                        continue block2;
                    }
                    if (cmp > 0) {
                        result.add(null);
                        continue block2;
                    }
                    ++index;
                }
                result.add(null);
            }
            return result;
        }
        if (isAll) {
            Sequence result;
            int i;
            Sequence other = isNull ? new Sequence() : null;
            Object[] retVals = new Sequence[tgtSize];
            for (i = 0; i < tgtSize; ++i) {
                retVals[i] = new Sequence(4);
            }
            for (i = 1; i <= valSize; ++i) {
                Object val = valMems.get(i);
                int index = isSorted ? tgtMems.binarySearch(val) : tgtMems.firstIndexOf(val, 1);
                if (index > 0) {
                    if (isPos) {
                        ((Sequence)retVals[index - 1]).add(ObjectCache.getInteger(i));
                        continue;
                    }
                    ((Sequence)retVals[index - 1]).add(mems.get(i));
                    continue;
                }
                if (!isNull) continue;
                if (isPos) {
                    other.add(ObjectCache.getInteger(i));
                    continue;
                }
                other.add(mems.get(i));
            }
            if (isConj) {
                result = new Sequence(valSize);
                for (int i2 = 0; i2 < tgtSize; ++i2) {
                    result.addAll((Sequence)retVals[i2]);
                }
                result.addAll(other);
            } else if (isNull) {
                result = new Sequence(tgtSize + 1);
                result.addAll(retVals);
                result.add(other);
            } else {
                result = new Sequence(retVals);
            }
            return result;
        }
        Object[] retVals = new Object[tgtSize];
        for (int i = 1; i <= valSize; ++i) {
            Object val = valMems.get(i);
            int index = isSorted ? tgtMems.binarySearch(val) : tgtMems.firstIndexOf(val, 1);
            if (index <= 0 || retVals[index - 1] != null) continue;
            retVals[index - 1] = isPos ? ObjectCache.getInteger(i) : mems.get(i);
        }
        return new Sequence(retVals);
    }

    public Sequence align(Expression exp, int n, String opt, Context ctx) {
        if (n <= 0) {
            return null;
        }
        boolean isAll = false;
        boolean isRepeat = false;
        boolean isPos = false;
        if (opt != null) {
            if (opt.indexOf(97) != -1) {
                isAll = true;
            }
            if (opt.indexOf(112) != -1) {
                isPos = true;
            }
            if (opt.indexOf(114) != -1) {
                isAll = true;
                isRepeat = true;
            }
        }
        Sequence values = this.calc(exp, ctx);
        IArray mems = this.getMems();
        IArray valMems = values.getMems();
        int valSize = valMems.size();
        if (isAll) {
            int i;
            Object[] resultVals = new Sequence[n];
            for (i = 0; i < n; ++i) {
                resultVals[i] = new Sequence(4);
            }
            if (isRepeat) {
                for (i = 1; i <= valSize; ++i) {
                    Object val = valMems.get(i);
                    if (val == null) continue;
                    if (!(val instanceof Sequence)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("engine.needIntSeries"));
                    }
                    for (int index : ((Sequence)val).toIntArray()) {
                        if (index <= 0 || index > n) continue;
                        if (isPos) {
                            ((Sequence)resultVals[index - 1]).add(i);
                            continue;
                        }
                        ((Sequence)resultVals[index - 1]).add(mems.get(i));
                    }
                }
            } else {
                for (i = 1; i <= valSize; ++i) {
                    Object val = valMems.get(i);
                    if (val == null) continue;
                    if (!(val instanceof Number)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("engine.needIntExp"));
                    }
                    int index = ((Number)val).intValue();
                    if (index <= 0 || index > n) continue;
                    if (isPos) {
                        ((Sequence)resultVals[index - 1]).add(i);
                        continue;
                    }
                    ((Sequence)resultVals[index - 1]).add(mems.get(i));
                }
            }
            return new Sequence(resultVals);
        }
        Object[] resultVals = new Object[n];
        for (int i = 1; i <= valSize; ++i) {
            Object val = valMems.get(i);
            if (val == null) continue;
            if (!(val instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needIntExp"));
            }
            int index = ((Number)val).intValue();
            if (index <= 0 || index > n || resultVals[index - 1] != null) continue;
            resultVals[index - 1] = isPos ? Integer.valueOf(i) : mems.get(i);
        }
        return new Sequence(resultVals);
    }

    public Sequence group(String opt) {
        boolean removeNull = false;
        boolean isOrg = false;
        boolean isNumber = false;
        boolean isSort = true;
        if (opt != null) {
            if (opt.indexOf(104) != -1) {
                opt = opt.replace('h', 'o');
                return this.sort(null).group(opt);
            }
            if (opt.indexOf(48) != -1) {
                removeNull = true;
            }
            if (opt.indexOf(111) != -1) {
                isOrg = true;
            }
            if (opt.indexOf(110) != -1) {
                isNumber = true;
            }
            if (opt.indexOf(117) != -1) {
                isSort = false;
            }
        }
        Sequence seq = this;
        if (removeNull) {
            seq = this._$1();
        }
        if (isNumber) {
            return this._$1(opt);
        }
        if (!isOrg) {
            if (!isSort || this.length() > 700) {
                return CursorUtil.hashGroup(seq, opt);
            }
            if (opt == null) {
                return seq.sort(null).group("o");
            }
            return seq.sort(null).group("o" + opt);
        }
        IArray mems = seq.getMems();
        int size = mems.size();
        if (size == 0) {
            return new Sequence(0);
        }
        Sequence result = new Sequence(size / 4);
        IArray resultMems = result.getMems();
        Object prev = mems.get(1);
        if (opt.indexOf(112) == -1) {
            if (opt.indexOf(49) == -1) {
                Sequence group = new Sequence(7);
                group.add(prev);
                resultMems.add(group);
                for (int i = 2; i <= size; ++i) {
                    Object cur = mems.get(i);
                    if (Variant.isEquals(prev, cur)) {
                        group.add(cur);
                        continue;
                    }
                    prev = cur;
                    group = new Sequence(7);
                    group.add(cur);
                    resultMems.add(group);
                }
            } else {
                resultMems.add(prev);
                for (int i = 2; i <= size; ++i) {
                    Object cur = mems.get(i);
                    if (Variant.isEquals(prev, cur)) continue;
                    prev = cur;
                    resultMems.add(cur);
                }
            }
        } else if (opt.indexOf(49) == -1) {
            Sequence group = new Sequence(7);
            group.add(ObjectCache.getInteger(1));
            resultMems.add(group);
            for (int i = 2; i <= size; ++i) {
                Object cur = mems.get(i);
                if (Variant.isEquals(prev, cur)) {
                    group.add(ObjectCache.getInteger(i));
                    continue;
                }
                prev = cur;
                group = new Sequence(7);
                group.add(ObjectCache.getInteger(i));
                resultMems.add(group);
            }
        } else {
            resultMems.add(prev);
            for (int i = 2; i <= size; ++i) {
                Object cur = mems.get(i);
                if (Variant.isEquals(prev, cur)) continue;
                prev = cur;
                resultMems.add(ObjectCache.getInteger(i));
            }
        }
        return result;
    }

    public Sequence group(Expression exp, String opt, Context ctx) {
        if (opt == null) {
            return CursorUtil.hashGroup(this, new Expression[]{exp}, opt, ctx);
        }
        if (opt.indexOf(104) != -1) {
            opt = opt.replace('h', 'o');
            return this.sort(exp, null, null, ctx)._$2(exp, opt, ctx);
        }
        if (opt.indexOf(111) != -1) {
            return this._$2(exp, opt, ctx);
        }
        if (opt.indexOf(105) != -1) {
            return this._$3(exp, opt, ctx);
        }
        if (opt.indexOf(110) != -1) {
            return this._$1(exp, opt, ctx);
        }
        return CursorUtil.hashGroup(this, new Expression[]{exp}, opt, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence _$3(Expression exp, String opt, Context ctx) {
        IArray mems = this.getMems();
        int size = mems.size();
        if (size == 0) {
            return new Sequence(0);
        }
        Sequence result = new Sequence(size / 4);
        IArray resultMems = result.getMems();
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            if (opt.indexOf(112) == -1) {
                if (opt.indexOf(49) == -1) {
                    Sequence group = new Sequence(7);
                    group.add(mems.get(1));
                    resultMems.add(group);
                    current.setCurrent(1);
                    exp.calculate(ctx);
                    for (int i = 2; i <= size; ++i) {
                        current.setCurrent(i);
                        if (Variant.isTrue(exp.calculate(ctx))) {
                            group = new Sequence(7);
                            group.add(mems.get(i));
                            resultMems.add(group);
                            continue;
                        }
                        group.add(mems.get(i));
                    }
                } else {
                    resultMems.add(mems.get(1));
                    current.setCurrent(1);
                    exp.calculate(ctx);
                    for (int i = 2; i <= size; ++i) {
                        current.setCurrent(i);
                        if (!Variant.isTrue(exp.calculate(ctx))) continue;
                        resultMems.add(mems.get(i));
                    }
                }
            } else if (opt.indexOf(49) == -1) {
                Sequence group = new Sequence(7);
                group.add(ObjectCache.getInteger(1));
                resultMems.add(group);
                current.setCurrent(1);
                exp.calculate(ctx);
                for (int i = 2; i <= size; ++i) {
                    current.setCurrent(i);
                    if (Variant.isTrue(exp.calculate(ctx))) {
                        group = new Sequence(7);
                        group.add(ObjectCache.getInteger(i));
                        resultMems.add(group);
                        continue;
                    }
                    group.add(ObjectCache.getInteger(i));
                }
            } else {
                resultMems.add(ObjectCache.getInteger(1));
                current.setCurrent(1);
                exp.calculate(ctx);
                for (int i = 2; i <= size; ++i) {
                    current.setCurrent(i);
                    if (!Variant.isTrue(exp.calculate(ctx))) continue;
                    resultMems.add(ObjectCache.getInteger(i));
                }
            }
        }
        finally {
            stack.pop();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Sequence _$2(Expression exp, String opt, Context ctx) {
        IArray mems = this.getMems();
        int size = mems.size();
        if (size == 0) {
            return new Sequence(0);
        }
        Sequence result = new Sequence(size / 4);
        IArray resultMems = result.getMems();
        boolean reserveNull = opt == null || opt.indexOf(48) == -1;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            current.setCurrent(1);
            Object prevValue = exp.calculate(ctx);
            if (opt.indexOf(112) == -1) {
                if (opt.indexOf(49) == -1) {
                    Sequence group = new Sequence(7);
                    group.add(mems.get(1));
                    if (reserveNull || prevValue != null) {
                        resultMems.add(group);
                    }
                    for (int i = 2; i <= size; ++i) {
                        current.setCurrent(i);
                        Object curValue = exp.calculate(ctx);
                        if (Variant.isEquals(prevValue, curValue)) {
                            group.add(mems.get(i));
                            continue;
                        }
                        prevValue = curValue;
                        group = new Sequence(7);
                        group.add(mems.get(i));
                        if (!reserveNull && prevValue == null) continue;
                        resultMems.add(group);
                    }
                } else {
                    if (reserveNull || prevValue != null) {
                        resultMems.add(mems.get(1));
                    }
                    for (int i = 2; i <= size; ++i) {
                        current.setCurrent(i);
                        Object curValue = exp.calculate(ctx);
                        if (Variant.isEquals(prevValue, curValue)) continue;
                        prevValue = curValue;
                        if (!reserveNull && prevValue == null) continue;
                        resultMems.add(mems.get(i));
                    }
                }
            } else if (opt.indexOf(49) == -1) {
                Sequence group = new Sequence(7);
                group.add(ObjectCache.getInteger(1));
                if (reserveNull || prevValue != null) {
                    resultMems.add(group);
                }
                for (int i = 2; i <= size; ++i) {
                    current.setCurrent(i);
                    Object curValue = exp.calculate(ctx);
                    if (Variant.isEquals(prevValue, curValue)) {
                        group.add(ObjectCache.getInteger(i));
                        continue;
                    }
                    prevValue = curValue;
                    group = new Sequence(7);
                    group.add(ObjectCache.getInteger(i));
                    if (!reserveNull && prevValue == null) continue;
                    resultMems.add(group);
                }
            } else {
                if (reserveNull || prevValue != null) {
                    resultMems.add(ObjectCache.getInteger(1));
                }
                for (int i = 2; i <= size; ++i) {
                    current.setCurrent(i);
                    Object curValue = exp.calculate(ctx);
                    if (Variant.isEquals(prevValue, curValue)) continue;
                    prevValue = curValue;
                    if (!reserveNull && prevValue == null) continue;
                    resultMems.add(ObjectCache.getInteger(i));
                }
            }
        }
        finally {
            stack.pop();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence _$1(Expression[] exps, String opt, Context ctx) {
        int keyCount = exps.length;
        IArray mems = this.getMems();
        int size = mems.size();
        if (size == 0) {
            return new Sequence(0);
        }
        Object[] prevValues = new Object[keyCount];
        Object[] curValues = new Object[keyCount];
        Sequence result = new Sequence(size / 4);
        IArray resultMems = result.getMems();
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            int i;
            current.setCurrent(1);
            for (int k = 0; k < keyCount; ++k) {
                prevValues[k] = exps[k].calculate(ctx);
            }
            if (opt.indexOf(112) == -1) {
                if (opt.indexOf(49) == -1) {
                    Sequence group = new Sequence(7);
                    group.add(mems.get(1));
                    resultMems.add(group);
                    for (int i2 = 2; i2 <= size; ++i2) {
                        current.setCurrent(i2);
                        for (int k = 0; k < keyCount; ++k) {
                            curValues[k] = exps[k].calculate(ctx);
                        }
                        if (Variant.compareArrays(prevValues, curValues) == 0) {
                            group.add(mems.get(i2));
                            continue;
                        }
                        Object[] tmp = prevValues;
                        prevValues = curValues;
                        curValues = tmp;
                        group = new Sequence(7);
                        group.add(mems.get(i2));
                        resultMems.add(group);
                    }
                } else {
                    resultMems.add(mems.get(1));
                    for (i = 2; i <= size; ++i) {
                        current.setCurrent(i);
                        for (int k = 0; k < keyCount; ++k) {
                            curValues[k] = exps[k].calculate(ctx);
                        }
                        if (Variant.compareArrays(prevValues, curValues) == 0) continue;
                        Object[] tmp = prevValues;
                        prevValues = curValues;
                        curValues = tmp;
                        resultMems.add(mems.get(i));
                    }
                }
            } else if (opt.indexOf(49) == -1) {
                Sequence group = new Sequence(7);
                group.add(ObjectCache.getInteger(1));
                resultMems.add(group);
                for (int i3 = 2; i3 <= size; ++i3) {
                    current.setCurrent(i3);
                    for (int k = 0; k < keyCount; ++k) {
                        curValues[k] = exps[k].calculate(ctx);
                    }
                    if (Variant.compareArrays(prevValues, curValues) == 0) {
                        group.add(ObjectCache.getInteger(i3));
                        continue;
                    }
                    Object[] tmp = prevValues;
                    prevValues = curValues;
                    curValues = tmp;
                    group = new Sequence(7);
                    group.add(ObjectCache.getInteger(i3));
                    resultMems.add(group);
                }
            } else {
                resultMems.add(ObjectCache.getInteger(1));
                for (i = 2; i <= size; ++i) {
                    current.setCurrent(i);
                    for (int k = 0; k < keyCount; ++k) {
                        curValues[k] = exps[k].calculate(ctx);
                    }
                    if (Variant.compareArrays(prevValues, curValues) == 0) continue;
                    Object[] tmp = prevValues;
                    prevValues = curValues;
                    curValues = tmp;
                    resultMems.add(ObjectCache.getInteger(i));
                }
            }
        }
        finally {
            stack.pop();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence _$1(Expression exp, String opt, Context ctx) {
        IArray mems = this.getMems();
        int size = mems.size();
        if (size == 0) {
            return new Sequence(0);
        }
        Sequence result = new Sequence(size / 4);
        IArray resultMems = result.getMems();
        int len = 0;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            if (opt.indexOf(49) == -1) {
                for (int i = 1; i <= size; ++i) {
                    current.setCurrent(i);
                    Object obj = exp.calculate(ctx);
                    if (!(obj instanceof Number)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("group: " + mm.getMessage("engine.needIntExp"));
                    }
                    int index = ((Number)obj).intValue();
                    if (index > len) {
                        resultMems.ensureCapacity(index);
                        for (int j = len; j < index; ++j) {
                            resultMems.add(new Sequence(7));
                        }
                        len = index;
                    } else if (index < 1) continue;
                    Sequence group = (Sequence)resultMems.get(index);
                    group.add(mems.get(i));
                }
                if (opt.indexOf(115) != -1) {
                    result = result.conj(null);
                } else if (opt.indexOf(48) != -1) {
                    result.deleteNull(true);
                }
            } else {
                for (int i = 1; i <= size; ++i) {
                    current.setCurrent(i);
                    Object obj = exp.calculate(ctx);
                    if (!(obj instanceof Number)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("group: " + mm.getMessage("engine.needIntExp"));
                    }
                    int index = ((Number)obj).intValue();
                    if (index > len) {
                        resultMems.ensureCapacity(index);
                        for (int j = len; j < index; ++j) {
                            resultMems.add(null);
                        }
                        len = index;
                    } else if (index < 1) continue;
                    if (resultMems.get(index) != null) continue;
                    resultMems.set(index, mems.get(i));
                }
                if (opt.indexOf(48) != -1) {
                    result.deleteNull(false);
                }
            }
        }
        finally {
            stack.pop();
        }
        return result;
    }

    private Sequence _$1(String opt) {
        IArray mems = this.getMems();
        int size = mems.size();
        if (size == 0) {
            return new Sequence(0);
        }
        Sequence result = new Sequence(size / 4);
        IArray resultMems = result.getMems();
        int len = 0;
        if (opt.indexOf(49) == -1) {
            for (int i = 1; i <= size; ++i) {
                Object obj = mems.get(i);
                if (!(obj instanceof Number)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("group: " + mm.getMessage("engine.needIntExp"));
                }
                int index = ((Number)obj).intValue();
                if (index > len) {
                    resultMems.ensureCapacity(index);
                    for (int j = len; j < index; ++j) {
                        resultMems.add(new Sequence(7));
                    }
                    len = index;
                } else if (index < 1) continue;
                Sequence group = (Sequence)resultMems.get(index);
                group.add(mems.get(i));
            }
            if (opt.indexOf(115) != -1) {
                result = result.conj(null);
            } else if (opt.indexOf(48) != -1) {
                result.deleteNull(true);
            }
        } else {
            for (int i = 1; i <= size; ++i) {
                Object obj = mems.get(i);
                if (!(obj instanceof Number)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("group: " + mm.getMessage("engine.needIntExp"));
                }
                int index = ((Number)obj).intValue();
                if (index > len) {
                    resultMems.ensureCapacity(index);
                    for (int j = len; j < index; ++j) {
                        resultMems.add(null);
                    }
                    len = index;
                } else if (index < 1) continue;
                if (resultMems.get(index) != null) continue;
                resultMems.set(index, mems.get(i));
            }
            if (opt.indexOf(48) != -1) {
                result.deleteNull(false);
            }
        }
        return result;
    }

    public Sequence group(Expression[] exps, String opt, Context ctx) {
        int keyCount = exps.length;
        if (keyCount == 1) {
            return this.group(exps[0], opt, ctx);
        }
        if (opt == null) {
            return CursorUtil.hashGroup(this, exps, opt, ctx);
        }
        if (opt.indexOf(104) != -1) {
            opt = opt.replace('h', 'o');
            return this.sort(exps, null, null, ctx).group(exps, opt, ctx);
        }
        if (opt.indexOf(111) != -1) {
            return this._$1(exps, opt, ctx);
        }
        if (opt.indexOf(115) != -1) {
            int[] orders = new int[keyCount];
            for (int i = 0; i < keyCount; ++i) {
                orders[i] = 1;
            }
            return this.sort(exps, orders, null, null, ctx);
        }
        return CursorUtil.hashGroup(this, exps, opt, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table group(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx) {
        int c;
        BaseRecord r;
        int i;
        if (opt != null && opt.indexOf(115) != -1) {
            return this.groups(exps, names, calcExps, calcNames, opt, ctx);
        }
        if (this.length() == 0) {
            if (opt == null || opt.indexOf(116) == -1) {
                return null;
            }
            boolean needGroupField = opt == null || opt.indexOf(98) == -1;
            int keyCount = needGroupField && exps != null ? exps.length : 0;
            int valCount = calcExps != null ? calcExps.length : 0;
            Expression[] totalExps = new Expression[keyCount + valCount];
            String[] totalNames = new String[keyCount + valCount];
            if (keyCount > 0) {
                System.arraycopy(exps, 0, totalExps, 0, keyCount);
                System.arraycopy(names, 0, totalNames, 0, keyCount);
            }
            if (valCount > 0) {
                System.arraycopy(calcExps, 0, totalExps, keyCount, valCount);
                System.arraycopy(calcNames, 0, totalNames, keyCount, valCount);
            }
            this.getNewFieldNames(totalExps, totalNames, "group");
            DataStruct ds = new DataStruct(totalNames);
            if (keyCount > 0) {
                String[] keyNames = new String[keyCount];
                System.arraycopy(totalNames, 0, keyNames, 0, keyCount);
                ds.setPrimary(keyNames);
            }
            return new Table(ds);
        }
        if (exps == null || exps.length == 0) {
            Sequence seq = new Sequence(1);
            seq.add(this);
            return seq.newTable(calcNames, calcExps, ctx);
        }
        if (calcExps == null || calcExps.length == 0) {
            return this.groups(exps, names, null, null, opt, ctx);
        }
        Sequence groups = this.group(exps, opt, ctx);
        if (opt != null && opt.indexOf(98) != -1) {
            return groups.newTable(calcNames, calcExps, ctx);
        }
        int keyCount = exps.length;
        int valCount = calcExps.length;
        Expression[] totalExps = new Expression[keyCount + valCount];
        String[] totalNames = new String[keyCount + valCount];
        System.arraycopy(exps, 0, totalExps, 0, keyCount);
        System.arraycopy(calcExps, 0, totalExps, keyCount, valCount);
        System.arraycopy(names, 0, totalNames, 0, keyCount);
        System.arraycopy(calcNames, 0, totalNames, keyCount, valCount);
        this.getNewFieldNames(totalExps, totalNames, "group");
        int len = groups.length();
        Sequence keyGroups = new Sequence(len);
        for (int i2 = 1; i2 <= len; ++i2) {
            Sequence seq = (Sequence)groups.getMem(i2);
            keyGroups.add(seq.getMem(1));
        }
        Table result = new Table(totalNames, len);
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(keyGroups);
        stack.push(current);
        try {
            for (i = 1; i <= len; ++i) {
                r = result.newLast();
                current.setCurrent(i);
                for (c = 0; c < keyCount; ++c) {
                    r.setNormalFieldValue(c, exps[c].calculate(ctx));
                }
            }
        }
        finally {
            stack.pop();
        }
        current = new Current(groups);
        stack.push(current);
        try {
            for (i = 1; i <= len; ++i) {
                r = (BaseRecord)result.getMem(i);
                current.setCurrent(i);
                for (c = 0; c < valCount; ++c) {
                    r.setNormalFieldValue(c + keyCount, calcExps[c].calculate(ctx));
                }
            }
        }
        finally {
            stack.pop();
        }
        String[] keyNames = new String[keyCount];
        System.arraycopy(totalNames, 0, keyNames, 0, keyCount);
        result.setPrimary(keyNames);
        return result;
    }

    public static Node[] prepareGatherMethods(Expression[] exps, Context ctx) {
        if (exps == null) {
            return null;
        }
        int count = exps.length;
        Node[] gathers = new Node[count];
        for (int i = 0; i < count; ++i) {
            Node home;
            gathers[i] = home = exps[i].getHome();
            gathers[i].prepare(ctx);
        }
        return gathers;
    }

    public static void prepareGatherMethods(Node[] gathers, Context ctx) {
        if (gathers == null) {
            return;
        }
        int count = gathers.length;
        for (int i = 0; i < count; ++i) {
            gathers[i].prepare(ctx);
        }
    }

    public void finishGather(Node[] gathers) {
        if (gathers == null || this.length() == 0) {
            return;
        }
        int valCount = gathers.length;
        boolean[] signs = new boolean[valCount];
        boolean sign = false;
        for (int i = 0; i < valCount; ++i) {
            signs[i] = gathers[i].needFinish();
            if (!signs[i]) continue;
            sign = true;
        }
        if (!sign) {
            return;
        }
        BaseRecord r = (BaseRecord)this.getMem(1);
        int keyCount = r.dataStruct().getPKCount();
        IArray mems = this.getMems();
        int len = mems.size();
        for (int i = 1; i <= len; ++i) {
            r = (BaseRecord)mems.get(i);
            int v = 0;
            int f = keyCount;
            while (v < valCount) {
                if (signs[v]) {
                    Object val = gathers[v].finish(r.getNormalFieldValue(f));
                    r.setNormalFieldValue(f, val);
                }
                ++v;
                ++f;
            }
        }
    }

    public void finishGather1(Node[] gathers) {
        if (gathers == null || this.length() == 0) {
            return;
        }
        int valCount = gathers.length;
        boolean[] signs = new boolean[valCount];
        boolean sign = false;
        for (int i = 0; i < valCount; ++i) {
            signs[i] = gathers[i].needFinish1();
            if (!signs[i]) continue;
            sign = true;
        }
        if (!sign) {
            return;
        }
        BaseRecord r = (BaseRecord)this.getMem(1);
        int keyCount = r.dataStruct().getPKCount();
        IArray mems = this.getMems();
        int len = mems.size();
        for (int i = 1; i <= len; ++i) {
            r = (BaseRecord)mems.get(i);
            int v = 0;
            int f = keyCount;
            while (v < valCount) {
                if (signs[v]) {
                    Object val = gathers[v].finish1(r.getNormalFieldValue(f));
                    r.setNormalFieldValue(f, val);
                }
                ++v;
                ++f;
            }
        }
    }

    public void shift(int pos, int move) {
        IArray mems = this.getMems();
        int size = mems.size();
        int end = size - move;
        while (pos <= end) {
            mems.set(pos, mems.get(pos + move));
            ++pos;
        }
    }

    public DataStruct getFirstRecordDataStruct() {
        Object obj;
        if (this.length() > 0 && (obj = this.getMem(1)) instanceof BaseRecord) {
            return ((BaseRecord)obj).dataStruct();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table pivotGather(Expression[] gexps, String[] gnames, Expression fexp, Expression vexp, Expression[] nexps, Object[] nameObjects, Context ctx) {
        int i;
        Sequence groups;
        String[] names;
        Object[] vals;
        int nullIndex = -1;
        if (nexps == null) {
            Sequence seq = this.calc(fexp, ctx).id("u");
            vals = seq.toArray();
            int count = vals.length;
            names = new String[count];
            for (int i2 = 0; i2 < count; ++i2) {
                names[i2] = Variant.toString(vals[i2]);
            }
        } else {
            int count = nexps.length;
            vals = new Object[count];
            names = new String[count];
            for (int i3 = 0; i3 < count; ++i3) {
                if (nexps[i3] == null) {
                    if (nullIndex != -1) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("pivot" + mm.getMessage("function.invalidParam"));
                    }
                    nullIndex = i3;
                    if (nameObjects[i3] == null) continue;
                    names[i3] = Variant.toString(nameObjects[i3]);
                    continue;
                }
                vals[i3] = nexps[i3].calculate(ctx);
                names[i3] = nameObjects[i3] == null ? Variant.toString(vals[i3]) : Variant.toString(nameObjects[i3]);
            }
        }
        Node home = vexp.getHome();
        Gather gather = null;
        if (home instanceof Gather) {
            gather = (Gather)home;
            gather.prepare(ctx);
        }
        int keyCount = gexps == null ? 0 : gexps.length;
        int ncount = names.length;
        int totalCount = keyCount + ncount;
        String[] totalNames = new String[totalCount];
        System.arraycopy(names, 0, totalNames, keyCount, ncount);
        DataStruct ds = this.getFirstRecordDataStruct();
        for (int i4 = 0; i4 < keyCount; ++i4) {
            totalNames[i4] = gnames != null && gnames[i4] != null ? gnames[i4] : gexps[i4].getFieldName(ds);
        }
        if (keyCount > 0) {
            groups = this.group(gexps, null, ctx);
        } else {
            groups = new Sequence(1);
            groups.add(this);
        }
        int len = groups.length();
        Table result = new Table(totalNames, len);
        ComputeStack stack = ctx.getComputeStack();
        for (i = 1; i <= len; ++i) {
            Sequence group = (Sequence)groups.getMem(i);
            BaseRecord r = result.newLast();
            Current current = new Current(group);
            stack.push(current);
            try {
                int f;
                current.setCurrent(1);
                for (f = 0; f < keyCount; ++f) {
                    r.setNormalFieldValue(f, gexps[f].calculate(ctx));
                }
                for (f = keyCount; f < totalCount; ++f) {
                    r.setNormalFieldValue(f, new Sequence());
                }
                int size = group.length();
                block12: for (int m = 1; m <= size; ++m) {
                    current.setCurrent(m);
                    Object fval = fexp.calculate(ctx);
                    for (int n = 0; n < ncount; ++n) {
                        if (n == nullIndex || !Variant.isEquals(fval, vals[n])) continue;
                        Sequence seq = (Sequence)r.getNormalFieldValue(keyCount + n);
                        seq.add(group.getMem(m));
                        continue block12;
                    }
                    if (nullIndex == -1) continue;
                    Sequence seq = (Sequence)r.getNormalFieldValue(keyCount + nullIndex);
                    seq.add(group.getMem(m));
                }
                continue;
            }
            finally {
                stack.pop();
            }
        }
        if (gather != null) {
            for (i = 1; i <= len; ++i) {
                BaseRecord r = (BaseRecord)result.getMem(i);
                for (int n = 0; n < ncount; ++n) {
                    Sequence seq = (Sequence)r.getNormalFieldValue(keyCount + n);
                    r.setNormalFieldValue(keyCount + n, gather.gather(seq, ctx));
                }
            }
        } else {
            Sequence tmp = new Sequence(1);
            tmp.add(null);
            IArray array = tmp.getMems();
            Current current = new Current(tmp, 1);
            stack.push(current);
            try {
                for (int i5 = 1; i5 <= len; ++i5) {
                    BaseRecord r = (BaseRecord)result.getMem(i5);
                    for (int n = 0; n < ncount; ++n) {
                        Sequence seq = (Sequence)r.getNormalFieldValue(keyCount + n);
                        array.set(1, seq);
                        r.setNormalFieldValue(keyCount + n, home.calculate(ctx));
                    }
                }
            }
            finally {
                stack.pop();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table pivot(Expression[] gexps, String[] gnames, Expression fexp, Expression vexp, Expression[] nexps, Object[] nameObjects, String opt, Context ctx) {
        Sequence groups;
        String[] names;
        Object[] vals;
        if (this.length() == 0) {
            return null;
        }
        if (opt != null && opt.indexOf(115) != -1) {
            return this.pivotGather(gexps, gnames, fexp, vexp, nexps, nameObjects, ctx);
        }
        if (nexps == null) {
            Sequence seq = this.calc(fexp, ctx).id("u");
            vals = seq.toArray();
            int count = vals.length;
            names = new String[count];
            for (int i = 0; i < count; ++i) {
                names[i] = Variant.toString(vals[i]);
            }
        } else {
            int count = nexps.length;
            vals = new Object[count];
            names = new String[count];
            for (int i = 0; i < count; ++i) {
                if (nexps[i] == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("pivot" + mm.getMessage("function.invalidParam"));
                }
                vals[i] = nexps[i].calculate(ctx);
                names[i] = nameObjects[i] == null ? Variant.toString(vals[i]) : Variant.toString(nameObjects[i]);
            }
        }
        int ncount = names.length;
        int keyCount = gexps == null ? 0 : gexps.length;
        String[] totalNames = new String[keyCount + ncount];
        System.arraycopy(names, 0, totalNames, keyCount, ncount);
        DataStruct ds = this.getFirstRecordDataStruct();
        for (int i = 0; i < keyCount; ++i) {
            totalNames[i] = gnames != null && gnames[i] != null ? gnames[i] : gexps[i].getFieldName(ds);
        }
        if (keyCount > 0) {
            groups = this.group(gexps, null, ctx);
        } else {
            groups = new Sequence(1);
            groups.add(this);
        }
        int len = groups.length();
        Table result = new Table(totalNames, len);
        ComputeStack stack = ctx.getComputeStack();
        for (int i = 1; i <= len; ++i) {
            Sequence group = (Sequence)groups.getMem(i);
            BaseRecord r = result.newLast();
            Current current = new Current(group);
            stack.push(current);
            try {
                current.setCurrent(1);
                for (int f = 0; f < keyCount; ++f) {
                    r.setNormalFieldValue(f, gexps[f].calculate(ctx));
                }
                int size = group.length();
                block8: for (int m = 1; m <= size; ++m) {
                    current.setCurrent(m);
                    Object fval = fexp.calculate(ctx);
                    for (int n = 0; n < ncount; ++n) {
                        if (!Variant.isEquals(fval, vals[n])) continue;
                        r.setNormalFieldValue(keyCount + n, vexp.calculate(ctx));
                        continue block8;
                    }
                }
                continue;
            }
            finally {
                stack.pop();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table unpivot(Expression[] gexps, String[] gnames, String fname, String vname, Expression[] nexps, Object[] nameObjects, Context ctx) {
        int len = this.length();
        if (len == 0) {
            return null;
        }
        int keyCount = gexps == null ? 0 : gexps.length;
        DataStruct ds = this.getFirstRecordDataStruct();
        if (nexps == null) {
            int fcount = ds.getFieldCount();
            boolean[] signs = new boolean[fcount];
            int ncount = fcount;
            ArrayList<String> fieldList = new ArrayList<String>();
            for (int i = 0; i < keyCount; ++i) {
                gexps[i].getUsedFields(ctx, fieldList);
            }
            for (String name : fieldList) {
                int index = ds.getFieldIndex(name);
                if (index == -1 || signs[index]) continue;
                signs[index] = true;
                --ncount;
            }
            nexps = new Expression[ncount];
            nameObjects = new String[ncount];
            int seq = 0;
            for (int i = 0; i < fcount; ++i) {
                if (signs[i]) continue;
                String str = ds.getFieldName(i);
                nexps[seq] = new Expression("#" + (i + 1));
                nameObjects[seq] = str;
                ++seq;
            }
        } else {
            for (int i = 0; i < nexps.length; ++i) {
                if (nexps[i] != null) continue;
                MessageManager mm = EngineMessage.get();
                throw new RQException("pivot" + mm.getMessage("function.invalidParam"));
            }
        }
        String[] totalNames = new String[keyCount + 2];
        totalNames[keyCount] = fname;
        totalNames[keyCount + 1] = vname;
        for (int i = 0; i < keyCount; ++i) {
            totalNames[i] = gnames != null && gnames[i] != null ? gnames[i] : gexps[i].getFieldName(ds);
        }
        int ncount = nexps.length;
        Object[] names = new Object[ncount];
        for (int i = 0; i < ncount; ++i) {
            names[i] = nameObjects[i] == null ? nexps[i].getFieldName(ds) : nameObjects[i];
        }
        Object[] keys = new Object[keyCount];
        Table result = new Table(totalNames, len * ncount);
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            for (int i = 1; i <= len; ++i) {
                current.setCurrent(i);
                for (int k = 0; k < keyCount; ++k) {
                    keys[k] = gexps[k].calculate(ctx);
                }
                for (int n = 0; n < ncount; ++n) {
                    BaseRecord r = result.newLast(keys);
                    r.setNormalFieldValue(keyCount, names[n]);
                    r.setNormalFieldValue(keyCount + 1, nexps[n].calculate(ctx));
                }
            }
        }
        finally {
            stack.pop();
        }
        return result;
    }

    public Table groupc(Expression[] gexps, String[] gnames, Expression[] vexps, String[] newNames, Context ctx) {
        int vcount;
        if (this.length() == 0) {
            return null;
        }
        DataStruct ds = this.dataStruct();
        Sequence table = this;
        int gcount = gexps.length;
        for (int i = 0; i < gcount; ++i) {
            if (gnames[i] != null && gnames[i].length() != 0) continue;
            gnames[i] = gexps[i].getFieldName(ds);
        }
        if (ds == null) {
            if (vexps == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("groupc" + mm.getMessage("function.invalidParam"));
            }
            vcount = vexps.length;
            Expression[] exps = new Expression[gcount + vcount];
            String[] names = new String[gcount + vcount];
            System.arraycopy(gnames, 0, names, 0, gcount);
            System.arraycopy(gexps, 0, exps, 0, gcount);
            System.arraycopy(vexps, 0, exps, gcount, vcount);
            table = this.newTable(names, exps, ctx);
            ds = table.dataStruct();
        } else {
            int i;
            boolean isOrder = true;
            for (i = 0; i < gcount; ++i) {
                if (gexps[i].getFieldIndex(ds) == i) continue;
                isOrder = false;
                break;
            }
            if (vexps == null) {
                int fcount = ds.getFieldCount();
                vcount = fcount - gcount;
                if (!isOrder) {
                    int expCount = 0;
                    int[] cols = new int[fcount];
                    for (int i2 = 0; i2 < gcount; ++i2) {
                        cols[i2] = gexps[i2].getFieldIndex(ds);
                        if (cols[i2] != -1) continue;
                        ++expCount;
                    }
                    if (expCount > 0) {
                        vcount += expCount;
                        Expression[] exps = new Expression[fcount + expCount];
                        String[] names = new String[fcount + expCount];
                        System.arraycopy(gnames, 0, names, 0, gcount);
                        System.arraycopy(gexps, 0, exps, 0, gcount);
                        int q = gcount;
                        block3: for (int f = 0; f < fcount; ++f) {
                            for (int g = 0; g < gcount; ++g) {
                                if (cols[g] == f) continue block3;
                            }
                            exps[q] = new Expression(ctx, "#" + (f + 1));
                            names[q] = ds.getFieldName(f);
                            ++q;
                        }
                        table = this.newTable(names, exps, ctx);
                        ds = table.dataStruct();
                    } else {
                        int q = gcount;
                        block5: for (int f = 0; f < fcount; ++f) {
                            for (int g = 0; g < gcount; ++g) {
                                if (cols[g] == f) continue block5;
                            }
                            cols[q] = f;
                            ++q;
                        }
                        table = this.fieldsValues(cols);
                        ds = table.dataStruct();
                    }
                }
            } else {
                vcount = vexps.length;
                if (isOrder) {
                    for (i = 0; i < vcount; ++i) {
                        if (vexps[i].getFieldIndex(ds) == gcount + i) continue;
                        isOrder = false;
                        break;
                    }
                }
                if (!isOrder) {
                    Expression[] exps = new Expression[gcount + vcount];
                    String[] names = new String[gcount + vcount];
                    System.arraycopy(gnames, 0, names, 0, gcount);
                    System.arraycopy(gexps, 0, exps, 0, gcount);
                    System.arraycopy(vexps, 0, exps, gcount, vcount);
                    table = this.newTable(names, exps, ctx);
                    ds = table.dataStruct();
                }
            }
        }
        Expression[] gexps2 = new Expression[gcount];
        for (int i = 1; i <= gcount; ++i) {
            gexps2[i - 1] = new Expression(ctx, "#" + i);
        }
        Sequence groups = table.group(gexps2, "u", ctx);
        int resultCount = groups.length();
        int maxCount = 1;
        for (int i = 1; i <= resultCount; ++i) {
            Sequence seq = (Sequence)groups.getMem(i);
            if (seq.length() <= maxCount) continue;
            maxCount = seq.length();
        }
        int maxNewCount = maxCount * vcount;
        String[] totalNames = new String[gcount + maxNewCount];
        System.arraycopy(gnames, 0, totalNames, 0, gcount);
        if (newNames != null) {
            if (newNames.length >= maxNewCount) {
                System.arraycopy(newNames, 0, totalNames, gcount, maxNewCount);
            } else {
                System.arraycopy(newNames, 0, totalNames, gcount, newNames.length);
            }
        }
        Table result = new Table(totalNames, resultCount);
        int srcFieldCount = gcount + vcount;
        for (int i = 1; i <= resultCount; ++i) {
            Sequence seq = (Sequence)groups.getMem(i);
            BaseRecord r = (BaseRecord)seq.getMem(1);
            BaseRecord newRecord = result.newLast();
            for (int f = 0; f < srcFieldCount; ++f) {
                newRecord.setNormalFieldValue(f, r.getNormalFieldValue(f));
            }
            int q = srcFieldCount;
            int len = seq.length();
            for (int j = 2; j <= len; ++j) {
                r = (BaseRecord)seq.getMem(j);
                int f = gcount;
                while (f < srcFieldCount) {
                    newRecord.setNormalFieldValue(q, r.getNormalFieldValue(f));
                    ++f;
                    ++q;
                }
            }
        }
        return result;
    }

    public Table ungroupc(Expression[] gexps, String[] gnames, Expression[] vexps, String[] newNames, Context ctx) {
        int vcount;
        if (newNames == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("groupc" + mm.getMessage("function.invalidParam"));
        }
        int len = this.length();
        if (len == 0) {
            return null;
        }
        DataStruct ds = this.dataStruct();
        Sequence table = this;
        int gcount = gexps.length;
        if (ds == null) {
            if (vexps == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("groupc" + mm.getMessage("function.invalidParam"));
            }
            vcount = vexps.length;
            Expression[] exps = new Expression[gcount + vcount];
            System.arraycopy(gexps, 0, exps, 0, gcount);
            System.arraycopy(vexps, 0, exps, gcount, vcount);
            table = this.newTable(null, exps, ctx);
        } else {
            int i;
            boolean isOrder = true;
            for (i = 0; i < gcount; ++i) {
                if (gexps[i].getFieldIndex(ds) == i) continue;
                isOrder = false;
                break;
            }
            if (vexps == null) {
                int fcount = ds.getFieldCount();
                if (isOrder) {
                    vcount = fcount - gcount;
                } else {
                    int f;
                    boolean[] signs = new boolean[fcount];
                    int totalFieldCount = gcount + fcount;
                    for (int i2 = 0; i2 < gcount; ++i2) {
                        f = gexps[i2].getFieldIndex(ds);
                        if (f == -1 || signs[f]) continue;
                        signs[f] = true;
                        --totalFieldCount;
                    }
                    Expression[] totalExps = new Expression[totalFieldCount];
                    System.arraycopy(gexps, 0, totalExps, 0, gcount);
                    int q = gcount;
                    for (f = 0; f < fcount; ++f) {
                        if (signs[f]) continue;
                        totalExps[q++] = new Expression(ctx, "#" + (f + 1));
                    }
                    vcount = totalFieldCount - gcount;
                    table = this.newTable(null, totalExps, ctx);
                }
            } else {
                vcount = vexps.length;
                if (isOrder) {
                    for (i = 0; i < vcount; ++i) {
                        if (vexps[i].getFieldIndex(ds) == gcount + i) continue;
                        isOrder = false;
                        break;
                    }
                }
                if (!isOrder) {
                    Expression[] exps = new Expression[gcount + vcount];
                    System.arraycopy(gexps, 0, exps, 0, gcount);
                    System.arraycopy(vexps, 0, exps, gcount, vcount);
                    table = this.newTable(null, exps, ctx);
                }
            }
        }
        int newCount = newNames.length;
        String[] totalNames = new String[gcount + newCount];
        for (int i = 0; i < gcount; ++i) {
            totalNames[i] = gnames != null && gnames[i] != null ? gnames[i] : gexps[i].getFieldName(ds);
        }
        System.arraycopy(newNames, 0, totalNames, gcount, newCount);
        int times = vcount / newCount;
        Table result = new Table(totalNames, len * times);
        int fcount = gcount + newCount;
        Object[] values = new Object[fcount];
        for (int i = 1; i <= len; ++i) {
            BaseRecord r = (BaseRecord)table.getMem(i);
            for (int f = 0; f < gcount; ++f) {
                values[f] = r.getNormalFieldValue(f);
            }
            int q = gcount;
            for (int j = 0; j < times; ++j) {
                boolean sign = false;
                int f = gcount;
                while (f < fcount) {
                    values[f] = r.getNormalFieldValue(q);
                    if (values[f] != null) {
                        sign = true;
                    }
                    ++f;
                    ++q;
                }
                if (!sign) continue;
                result.newLast(values);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence groupc(Expression gexp, Expression vexp, Context ctx) {
        int len = this.length();
        if (len == 0) {
            return null;
        }
        HashUtil hashUtil = new HashUtil(len);
        int[] entries = new int[hashUtil.getCapacity()];
        int[] linkArray = new int[len + 1];
        Object[] keyValues = new Object[len + 1];
        Sequence[] results = new Sequence[len + 1];
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            block3: for (int i = 1; i <= len; ++i) {
                current.setCurrent(i);
                Object key = gexp.calculate(ctx);
                Object value = vexp.calculate(ctx);
                int hash = hashUtil.hashCode(key);
                int seq = entries[hash];
                while (seq != 0) {
                    if (Variant.isEquals(key, keyValues[seq])) {
                        if (value instanceof Sequence) {
                            results[seq].addAll((Sequence)value);
                            continue block3;
                        }
                        results[seq].add(value);
                        continue block3;
                    }
                    seq = linkArray[seq];
                }
                Sequence newGroup = new Sequence();
                if (key instanceof Sequence) {
                    newGroup.addAll((Sequence)key);
                } else {
                    newGroup.add(key);
                }
                if (value instanceof Sequence) {
                    newGroup.addAll((Sequence)value);
                } else {
                    newGroup.add(value);
                }
                linkArray[i] = entries[hash];
                entries[hash] = i;
                keyValues[i] = key;
                results[i] = newGroup;
            }
        }
        finally {
            stack.pop();
        }
        int gcount = 0;
        for (Sequence group : results) {
            if (group == null) continue;
            ++gcount;
        }
        Sequence result = new Sequence(gcount);
        for (Sequence group : results) {
            if (group == null) continue;
            result.add(group);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sequence ungroupc(Expression gexp, Expression vexp, int k, Context ctx) {
        int len = this.length();
        if (len == 0) {
            return null;
        }
        Sequence result = new Sequence(len * 2);
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            int i = 1;
            while (true) {
                block13: {
                    int count;
                    int keyCount;
                    Sequence keySeq;
                    int q;
                    Sequence valueSeq;
                    block12: {
                        block10: {
                            int curLen;
                            Object key;
                            block11: {
                                if (i > len) break block10;
                                current.setCurrent(i);
                                key = gexp.calculate(ctx);
                                Object value = vexp.calculate(ctx);
                                if (!(value instanceof Sequence)) {
                                    MessageManager mm = EngineMessage.get();
                                    throw new RQException("groupc" + mm.getMessage("function.paramTypeError"));
                                }
                                valueSeq = (Sequence)value;
                                curLen = valueSeq.length();
                                q = 1;
                                if (!(key instanceof Sequence)) break block11;
                                keySeq = (Sequence)key;
                                keyCount = keySeq.length();
                                count = curLen / k;
                                break block12;
                            }
                            int count2 = curLen / k;
                            for (int c = 0; c < count2; ++c) {
                                Sequence tmp = new Sequence(k + 1);
                                tmp.add(key);
                                boolean sign = false;
                                for (int j = 0; j < k; ++j) {
                                    Object v = valueSeq.getMem(q++);
                                    tmp.add(v);
                                    if (v == null) continue;
                                    sign = true;
                                }
                                if (!sign) continue;
                                result.add(tmp);
                            }
                            break block13;
                        }
                        return result;
                    }
                    for (int c = 0; c < count; ++c) {
                        Sequence tmp = new Sequence(k + keyCount);
                        tmp.addAll(keySeq);
                        boolean sign = false;
                        for (int j = 0; j < k; ++j) {
                            Object v = valueSeq.getMem(q++);
                            tmp.add(v);
                            if (v == null) continue;
                            sign = true;
                        }
                        if (!sign) continue;
                        result.add(tmp);
                    }
                }
                ++i;
            }
        }
        finally {
            stack.pop();
        }
    }

    public IGroupsResult getGroupsResult(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx) {
        DataStruct ds = this.getFirstRecordDataStruct();
        return IGroupsResult.instance(exps, names, calcExps, calcNames, ds, opt, ctx);
    }

    public Table groups(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx, int hashCapacity) {
        if (opt != null && opt.indexOf(122) != -1) {
            return CursorUtil.groups_z(this, exps, names, calcExps, calcNames, opt, ctx, hashCapacity);
        }
        return this.groups(exps, names, calcExps, calcNames, opt, ctx);
    }

    public Table groups(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx) {
        int len = this.length();
        if (len < 1) {
            if (opt == null || opt.indexOf(116) == -1) {
                return null;
            }
            int keyCount = exps != null ? exps.length : 0;
            int valCount = calcExps != null ? calcExps.length : 0;
            Expression[] totalExps = new Expression[keyCount + valCount];
            String[] totalNames = new String[keyCount + valCount];
            if (keyCount > 0) {
                System.arraycopy(exps, 0, totalExps, 0, keyCount);
                System.arraycopy(names, 0, totalNames, 0, keyCount);
            }
            if (valCount > 0) {
                System.arraycopy(calcExps, 0, totalExps, keyCount, valCount);
                System.arraycopy(calcNames, 0, totalNames, keyCount, valCount);
            }
            this.getNewFieldNames(totalExps, totalNames, "group");
            DataStruct ds = new DataStruct(totalNames);
            if (keyCount > 0) {
                String[] keyNames = new String[keyCount];
                System.arraycopy(totalNames, 0, keyNames, 0, keyCount);
                ds.setPrimary(keyNames);
            }
            return new Table(ds);
        }
        if (opt != null && opt.indexOf(109) != -1) {
            opt = opt.replace("m", "");
            return CursorUtil.groups_m(this, exps, names, calcExps, calcNames, opt, ctx);
        }
        DataStruct ds = this.getFirstRecordDataStruct();
        IGroupsResult groups = IGroupsResult.instance(exps, names, calcExps, calcNames, ds, opt, ctx, len / 2);
        groups.push(this, ctx);
        return groups.getResultTable();
    }

    public Table groupi(Expression[] gexps, String opt, Context ctx) {
        int fcount = gexps.length;
        String[] names = new String[fcount];
        Table table = this.newTable(names, gexps, ctx);
        int[] colIndex = new int[fcount];
        for (int i = 0; i < fcount; ++i) {
            colIndex[i] = i;
        }
        if (opt == null || opt.indexOf(111) == -1) {
            table.sortFields(colIndex);
        }
        Expression fexp = new Expression(ctx, "#1");
        Sequence group = table._$2(fexp, "o", ctx);
        int len = group.length();
        Table result = new Table(table.dataStruct(), len);
        for (int i = 1; i <= len; ++i) {
            Sequence curGroup = (Sequence)group.getMem(i);
            BaseRecord r = result.newLast();
            BaseRecord sr = (BaseRecord)curGroup.getMem(1);
            r.setNormalFieldValue(0, sr.getNormalFieldValue(0));
            if (fcount == 1) continue;
            fexp = new Expression(ctx, "#2");
            curGroup = curGroup._$2(fexp, "o", ctx);
            r.setNormalFieldValue(1, curGroup.calc(fexp, ctx));
            for (int f = 3; f <= fcount; ++f) {
                String gstr = "~.group@o(#" + f + ")";
                String vstr = "~.(#" + f + ")";
                fexp = new Expression(ctx, "#" + f);
                for (int n = 3; n < f; ++n) {
                    gstr = "~.(" + gstr + ")";
                    vstr = "~.(" + vstr + ")";
                }
                curGroup = curGroup.calc(new Expression(ctx, gstr), ctx);
                Sequence curVal = curGroup.calc(new Expression(ctx, vstr), ctx);
                r.setNormalFieldValue(f - 1, curVal);
            }
        }
        return result;
    }

    public static Table cross(Sequence[] sequences, String[] names) {
        if (sequences == null || sequences.length < 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cross" + mm.getMessage("function.invalidParam"));
        }
        int newLen = 1;
        int count = sequences.length;
        for (int i = 0; i < count; ++i) {
            if ((newLen *= sequences[i].length()) != 0) continue;
            return new Table(names, 0);
        }
        Table table = new Table(names, newLen);
        BaseRecord[] rs = new BaseRecord[newLen];
        for (int i = 0; i < newLen; ++i) {
            rs[i] = table.newLast();
        }
        int repeat = 1;
        for (int field = count - 1; field >= 0; --field) {
            IArray subMems = sequences[field].getMems();
            int subCount = subMems.size();
            int index = 0;
            while (index < newLen) {
                for (int i = 1; i <= subCount; ++i) {
                    Object val = subMems.get(i);
                    for (int j = 0; j < repeat; ++j) {
                        rs[index++].setNormalFieldValue(field, val);
                    }
                }
            }
            repeat *= subCount;
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Table xjoin(Sequence[] sequences, Expression[] fltExps, String[] fltOpts, String[] names, String opt, Context ctx) {
        if (sequences == null || sequences.length < 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("xjoin" + mm.getMessage("function.invalidParam"));
        }
        int count = sequences.length;
        if (names == null) {
            names = new String[count];
        } else if (names.length != count) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("xjoin" + mm.getMessage("function.invalidParam"));
        }
        if (fltExps == null) {
            fltExps = new Expression[count];
        } else if (fltExps.length != count) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("xjoin" + mm.getMessage("function.invalidParam"));
        }
        if (fltOpts == null) {
            fltOpts = new String[count];
        } else if (fltOpts.length != count) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("xjoin" + mm.getMessage("function.invalidParam"));
        }
        if (sequences[0] == null) {
            return new Table(names);
        }
        int len = sequences[0].length();
        len = len < 512 ? 1024 : (len *= 2);
        Table result = new Table(names, len);
        Table tmp = new Table(result.dataStruct(), 1);
        boolean isLeft = opt != null && opt.indexOf(49) != -1;
        BaseRecord newCur = tmp.newLast();
        ComputeStack stack = ctx.getComputeStack();
        stack.push(newCur);
        try {
            Sequence._$1(sequences, fltExps, fltOpts, 0, newCur, result, isLeft, ctx);
        }
        finally {
            stack.pop();
        }
        return result;
    }

    private static void _$1(Sequence[] sequences, Expression[] fltExps, String[] fltOpts, int col, BaseRecord newCur, Table retTable, boolean isLeft, Context ctx) {
        BaseRecord r;
        Sequence sequence = sequences[col];
        Object value = null;
        if (fltExps[col] != null && sequence != null) {
            Object obj = sequence.select(fltExps[col], fltOpts[col], ctx);
            if (obj instanceof Sequence) {
                sequence = (Sequence)obj;
            } else {
                value = obj;
                sequence = null;
            }
        }
        if (sequence != null && sequence.length() > 0) {
            IArray colMems = sequence.getMems();
            int length = colMems.size();
            if (col == sequences.length - 1) {
                for (int i = 1; i <= length; ++i) {
                    newCur.setNormalFieldValue(col, colMems.get(i));
                    BaseRecord r2 = retTable.newLast();
                    r2.set(newCur);
                }
            } else {
                int nextCol = col + 1;
                for (int i = 1; i <= length; ++i) {
                    newCur.setNormalFieldValue(col, colMems.get(i));
                    Sequence._$1(sequences, fltExps, fltOpts, nextCol, newCur, retTable, isLeft, ctx);
                }
            }
        } else if (value != null) {
            newCur.setNormalFieldValue(col, value);
            if (col == sequences.length - 1) {
                r = retTable.newLast();
                r.set(newCur);
            } else {
                Sequence._$1(sequences, fltExps, fltOpts, col + 1, newCur, retTable, isLeft, ctx);
            }
        } else if (isLeft && col > 0) {
            newCur.setNormalFieldValue(col, null);
            if (col == sequences.length - 1) {
                r = retTable.newLast();
                r.set(newCur);
            } else {
                Sequence._$1(sequences, fltExps, fltOpts, col + 1, newCur, retTable, isLeft, ctx);
            }
        }
    }

    public static Table pjoin(Sequence[] sequences, String[] names, String opt) {
        int c;
        int totalLen;
        if (sequences == null || sequences.length < 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("pjoin" + mm.getMessage("function.invalidParam"));
        }
        int count = sequences.length;
        for (int i = 0; i < count; ++i) {
            if (sequences[i] != null) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException("pjoin" + mm.getMessage("function.invalidParam"));
        }
        if (names == null) {
            names = new String[count];
        } else if (names.length != count) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("pjoin" + mm.getMessage("function.invalidParam"));
        }
        boolean bFirst = false;
        boolean bUnion = false;
        if (opt != null) {
            if (opt.indexOf(49) != -1) {
                bFirst = true;
            }
            if (opt.indexOf(102) != -1) {
                bUnion = true;
            }
        }
        if (bUnion && bFirst) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(opt + mm.getMessage("engine.optConflict"));
        }
        IArray[] srcMems = new IArray[count];
        int[] srcLen = new int[count];
        for (int i = 0; i < count; ++i) {
            srcMems[i] = sequences[i].getMems();
            srcLen[i] = srcMems[i].size();
        }
        if (bFirst) {
            totalLen = srcLen[0];
            Table result = new Table(names, totalLen);
            for (int i = 1; i <= totalLen; ++i) {
                BaseRecord r = result.newLast();
                r.setNormalFieldValue(0, srcMems[0].get(i));
                for (int c2 = 1; c2 < count; ++c2) {
                    if (i > srcLen[c2]) continue;
                    r.setNormalFieldValue(c2, srcMems[c2].get(i));
                }
            }
            return result;
        }
        totalLen = srcLen[0];
        if (bUnion) {
            for (c = 1; c < count; ++c) {
                if (totalLen >= srcLen[c]) continue;
                totalLen = srcLen[c];
            }
        } else {
            for (c = 1; c < count; ++c) {
                if (totalLen <= srcLen[c]) continue;
                totalLen = srcLen[c];
            }
        }
        Table result = new Table(names, totalLen);
        for (int i = 1; i <= totalLen; ++i) {
            BaseRecord r = result.newLast();
            for (int c3 = 0; c3 < count; ++c3) {
                if (i > srcLen[c3]) continue;
                r.setNormalFieldValue(c3, srcMems[c3].get(i));
            }
        }
        return result;
    }

    public static Table join(Sequence[] sequences, Expression[][] exps, String[] names, String opt, Context ctx) {
        int count = sequences.length;
        if (names == null) {
            names = new String[count];
        }
        if (exps == null) {
            exps = new Expression[count][];
        }
        int type = 0;
        if (opt != null) {
            if (opt.indexOf(49) != -1) {
                type = 1;
                if (opt.indexOf(102) != -1) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(opt + mm.getMessage("engine.optConflict"));
                }
            } else if (opt.indexOf(102) != -1) {
                type = 2;
            }
        }
        if (opt == null || opt.indexOf(109) == -1) {
            return CursorUtil.hashJoin(sequences, exps, names, type, ctx);
        }
        return CursorUtil.mergeJoin(sequences, exps, names, type, ctx);
    }

    public Sequence fieldValues(int field) {
        IArray mems = this.getMems();
        int size = mems.size();
        Sequence result = new Sequence(size);
        IArray resultMems = result.getMems();
        for (int i = 1; i <= size; ++i) {
            BaseRecord cur = (BaseRecord)mems.get(i);
            if (cur == null) {
                resultMems.add(null);
                continue;
            }
            resultMems.add(cur.getFieldValue(field));
        }
        return result;
    }

    public Sequence fieldValues(String fieldName) {
        Object obj;
        IArray mems = this.getMems();
        int size = mems.size();
        Sequence result = new Sequence(size);
        IArray resultMems = result.getMems();
        int col = -1;
        BaseRecord prevRecord = null;
        int i = 1;
        while (i <= size) {
            if ((obj = mems.get(i++)) != null) {
                if (!(obj instanceof BaseRecord)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.needPmt"));
                }
                prevRecord = (BaseRecord)obj;
                col = prevRecord.getFieldIndex(fieldName);
                if (col < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(fieldName + mm.getMessage("ds.fieldNotExist"));
                }
                resultMems.add(prevRecord.getFieldValue(col));
                break;
            }
            resultMems.add(null);
        }
        while (i <= size) {
            obj = mems.get(i);
            if (obj != null) {
                if (!(obj instanceof BaseRecord)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.needPmt"));
                }
                BaseRecord cur = (BaseRecord)obj;
                if (!prevRecord.isSameDataStruct(cur)) {
                    col = cur.getFieldIndex(fieldName);
                    if (col < 0) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(fieldName + mm.getMessage("ds.fieldNotExist"));
                    }
                    prevRecord = cur;
                }
                resultMems.add(cur.getFieldValue(col));
            } else {
                resultMems.add(null);
            }
            ++i;
        }
        return result;
    }

    public Table fieldsValues(int[] cols) {
        IArray mems = this.getMems();
        int size = this.length();
        if (size == 0) {
            return null;
        }
        DataStruct ds = ((BaseRecord)this.getMem(1)).dataStruct();
        int fcount = cols.length;
        String[] fieldNames = new String[fcount];
        for (int i = 0; i < fcount; ++i) {
            fieldNames[i] = ds.getFieldName(cols[i]);
        }
        Table retTable = new Table(fieldNames, size);
        for (int i = 1; i <= size; ++i) {
            Object obj = mems.get(i);
            if (!(obj instanceof BaseRecord)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needPmt"));
            }
            BaseRecord cur = (BaseRecord)obj;
            BaseRecord newRecord = retTable.newLast();
            for (int f = 0; f < fcount; ++f) {
                newRecord.setNormalFieldValue(f, cur.getFieldValue(cols[f]));
            }
        }
        return retTable;
    }

    public Table fieldsValues(String[] fieldNames) {
        IArray mems = this.getMems();
        int size = this.length();
        Table retTable = new Table(fieldNames, size);
        int fcount = fieldNames.length;
        BaseRecord prevRecord = null;
        int[] cols = new int[fcount];
        for (int i = 1; i <= size; ++i) {
            int f;
            BaseRecord newRecord = retTable.newLast();
            Object obj = mems.get(i);
            if (obj == null) continue;
            if (!(obj instanceof BaseRecord)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needPmt"));
            }
            BaseRecord cur = (BaseRecord)obj;
            if (prevRecord != null && prevRecord.isSameDataStruct(cur)) {
                for (f = 0; f < fcount; ++f) {
                    newRecord.setNormalFieldValue(f, cur.getFieldValue(cols[f]));
                }
                continue;
            }
            for (f = 0; f < fcount; ++f) {
                cols[f] = cur.getFieldIndex(fieldNames[f]);
                if (cols[f] < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(fieldNames[f] + mm.getMessage("ds.fieldNotExist"));
                }
                newRecord.setNormalFieldValue(f, cur.getFieldValue(cols[f]));
            }
            prevRecord = cur;
        }
        return retTable;
    }

    public Table fieldsValues(String[] fieldNames, String opt) {
        if (opt == null || opt.indexOf(101) == -1) {
            return this.fieldsValues(fieldNames);
        }
        int len = this.length();
        if (len == 0) {
            return new Table(fieldNames);
        }
        DataStruct ds = ((BaseRecord)this.ifn()).dataStruct();
        int fcount = fieldNames.length;
        int[] index = new int[fcount];
        String[] names = ds.getFieldNames();
        for (int f = 0; f < fcount; ++f) {
            index[f] = ds.getFieldIndex(fieldNames[f]);
            if (index[f] == -1) continue;
            fieldNames[f] = names[index[f]];
        }
        Table result = new Table(fieldNames, len);
        for (int i = 1; i <= len; ++i) {
            BaseRecord nr = result.newLast();
            BaseRecord r = (BaseRecord)this.getMem(i);
            for (int f = 0; f < fcount; ++f) {
                if (index[f] < 0) continue;
                nr.setNormalFieldValue(f, r.getFieldValue(index[f]));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void modifyFields(Expression[] exps, String[] fields, Context ctx) {
        IArray mems = this.getMems();
        int size = mems.size();
        int fcount = exps.length;
        BaseRecord prevRecord = null;
        int[] cols = new int[fcount];
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            int i = 1;
            while (i <= size) {
                int f;
                Object obj = mems.get(i);
                if (!(obj instanceof BaseRecord)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.needPmt"));
                }
                current.setCurrent(i);
                BaseRecord r = (BaseRecord)obj;
                if (prevRecord != null && prevRecord.isSameDataStruct(r)) {
                    for (f = 0; f < fcount; ++f) {
                        r.setNormalFieldValue(cols[f], exps[f].calculate(ctx));
                    }
                } else {
                    for (f = 0; f < fcount; ++f) {
                        cols[f] = r.getFieldIndex(fields[f]);
                        if (cols[f] < 0) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(fields[f] + mm.getMessage("ds.fieldNotExist"));
                        }
                        r.setNormalFieldValue(cols[f], exps[f].calculate(ctx));
                    }
                    prevRecord = r;
                }
                ++i;
            }
            return;
        }
        finally {
            stack.pop();
        }
    }

    public String toString() {
        IArray mems = this.getMems();
        int length = mems.size();
        StringBuffer sb = new StringBuffer(50 * length);
        sb.append('[');
        for (int i = 1; i <= length; ++i) {
            Object obj;
            if (i > 1) {
                sb.append(',');
            }
            if ((obj = mems.get(i)) instanceof String) {
                sb.append(Escape.addEscAndQuote((String)obj));
                continue;
            }
            sb.append(Variant.toString(obj));
        }
        sb.append(']');
        return sb.toString();
    }

    public String toString(String sep, String opt) {
        boolean addQuotes = false;
        boolean addSingleQuotes = false;
        boolean addEnter = false;
        boolean removeNull = false;
        if (opt != null) {
            if (opt.indexOf(99) != -1) {
                sep = ",";
            }
            if (opt.indexOf(113) != -1) {
                addQuotes = true;
            }
            if (opt.indexOf(105) != -1) {
                addSingleQuotes = true;
            }
            if (opt.indexOf(110) != -1) {
                addEnter = true;
            }
            if (opt.indexOf(48) != -1) {
                removeNull = true;
            }
        }
        IArray mems = this.getMems();
        int length = mems.size();
        StringBuffer sb = new StringBuffer(50 * length);
        if (removeNull) {
            int count = 0;
            if (addEnter) {
                opt = opt.replace('n', ' ');
                for (int i = 1; i <= length; ++i) {
                    Object obj = mems.get(i);
                    if (obj == null || obj.equals("")) continue;
                    if (++count > 1) {
                        sb.append('\n');
                    }
                    if (obj instanceof String) {
                        if (addQuotes) {
                            sb.append(Escape.addEscAndQuote((String)obj));
                            continue;
                        }
                        if (addSingleQuotes) {
                            sb.append('\'');
                            sb.append((String)obj);
                            sb.append('\'');
                            continue;
                        }
                        sb.append((String)obj);
                        continue;
                    }
                    if (obj instanceof Sequence) {
                        sb.append(((Sequence)obj).toString(sep, opt));
                        continue;
                    }
                    sb.append(Variant.toString(obj));
                }
                return sb.toString();
            }
            if (sep == null) {
                sep = ",";
            }
            for (int i = 1; i <= length; ++i) {
                Object obj = mems.get(i);
                if (obj == null || obj.equals("")) continue;
                if (++count > 1) {
                    sb.append(sep);
                }
                if (obj instanceof String) {
                    if (addQuotes) {
                        sb.append(Escape.addEscAndQuote((String)obj));
                        continue;
                    }
                    if (addSingleQuotes) {
                        sb.append('\'');
                        sb.append((String)obj);
                        sb.append('\'');
                        continue;
                    }
                    sb.append((String)obj);
                    continue;
                }
                if (obj instanceof Sequence) {
                    sb.append('[');
                    sb.append(((Sequence)obj).toString(sep, opt));
                    sb.append(']');
                    continue;
                }
                sb.append(Variant.toString(obj));
            }
            return sb.toString();
        }
        if (addEnter) {
            opt = opt.replace('n', ' ');
            for (int i = 1; i <= length; ++i) {
                Object obj = mems.get(i);
                if (i > 1) {
                    sb.append('\n');
                }
                if (obj instanceof String) {
                    if (addQuotes) {
                        sb.append(Escape.addEscAndQuote((String)obj));
                        continue;
                    }
                    if (addSingleQuotes) {
                        sb.append('\'');
                        sb.append((String)obj);
                        sb.append('\'');
                        continue;
                    }
                    sb.append((String)obj);
                    continue;
                }
                if (obj instanceof Sequence) {
                    sb.append(((Sequence)obj).toString(sep, opt));
                    continue;
                }
                if (obj == null) continue;
                sb.append(Variant.toString(obj));
            }
            return sb.toString();
        }
        if (sep == null) {
            sep = ",";
        }
        for (int i = 1; i <= length; ++i) {
            Object obj = mems.get(i);
            if (i > 1) {
                sb.append(sep);
            }
            if (obj instanceof String) {
                if (addQuotes) {
                    sb.append(Escape.addEscAndQuote((String)obj));
                    continue;
                }
                if (addSingleQuotes) {
                    sb.append('\'');
                    sb.append((String)obj);
                    sb.append('\'');
                    continue;
                }
                sb.append((String)obj);
                continue;
            }
            if (obj instanceof Sequence) {
                sb.append('[');
                sb.append(((Sequence)obj).toString(sep, opt));
                sb.append(']');
                continue;
            }
            if (obj == null) continue;
            sb.append(Variant.toString(obj));
        }
        return sb.toString();
    }

    public String toExportString() {
        IArray mems = this.getMems();
        int length = mems.size();
        StringBuffer sb = new StringBuffer(50 * length);
        sb.append('[');
        for (int i = 1; i <= length; ++i) {
            if (i > 1) {
                sb.append(',');
            }
            Object obj = mems.get(i);
            sb.append(Variant.toExportString(obj));
        }
        sb.append(']');
        return sb.toString();
    }

    public static Sequence toSequence(String src, String sep, String opt) {
        if (src == null || src.length() == 0) {
            return new Sequence(0);
        }
        boolean bFirst = false;
        boolean bMatch = true;
        boolean bData = false;
        boolean bTrim = false;
        boolean bRegex = false;
        boolean bEnter = false;
        boolean bLast = false;
        boolean gopt = false;
        if (opt != null) {
            if (opt.indexOf(112) != -1) {
                bData = true;
            }
            if (opt.indexOf(49) != -1) {
                bFirst = true;
            } else if (opt.indexOf(122) != -1) {
                bLast = true;
            }
            if (opt.indexOf(98) != -1) {
                bMatch = false;
            }
            if (opt.indexOf(116) != -1) {
                bTrim = true;
            }
            if (opt.indexOf(99) != -1) {
                sep = ",";
            }
            if (opt.indexOf(114) != -1) {
                bRegex = true;
            }
            if (opt.indexOf(110) != -1) {
                bEnter = true;
            }
            if (opt.indexOf(103) != -1) {
                gopt = true;
            }
        }
        if (bRegex) {
            String[] strs = src.split(sep);
            Sequence seq = new Sequence(strs.length);
            if (bTrim) {
                for (String str : strs) {
                    str = str.trim();
                    if (bData) {
                        seq.add(Variant.parse(str));
                        continue;
                    }
                    seq.add(str);
                }
            } else {
                for (String str : strs) {
                    if (bData) {
                        seq.add(Variant.parse(str));
                        continue;
                    }
                    seq.add(str);
                }
            }
            return seq;
        }
        if (bEnter) {
            char c;
            int end;
            int srcLen = src.length();
            for (end = srcLen - 1; end >= 0 && Character.isWhitespace(c = src.charAt(end)); --end) {
            }
            if (++end != srcLen) {
                src = src.substring(0, end);
                srcLen = end;
            }
            Sequence result = new Sequence();
            opt = opt.replace('n', ' ');
            if (bMatch) {
                int start = 0;
                int i = 0;
                block27: while (i < srcLen) {
                    String sub;
                    char c2 = src.charAt(i);
                    switch (c2) {
                        case '\"': 
                        case '\'': {
                            int match = Sentence.scanQuotation(src, i);
                            i = match == -1 ? srcLen : match + 1;
                            continue block27;
                        }
                        case '(': {
                            int match = Sentence.scanParenthesis(src, i);
                            i = match == -1 ? srcLen : match + 1;
                            continue block27;
                        }
                        case '[': {
                            int match = Sentence.scanBracket(src, i);
                            i = match == -1 ? srcLen : match + 1;
                            continue block27;
                        }
                        case '{': {
                            int match = Sentence.scanBrace(src, i);
                            i = match == -1 ? srcLen : match + 1;
                            continue block27;
                        }
                        case '\u300a': 
                        case '\u3010': 
                        case '\uff08': {
                            int match = Sentence.scanChineseBracket(src, i);
                            i = match == -1 ? srcLen : match + 1;
                            continue block27;
                        }
                        case '<': {
                            int match;
                            if (gopt) {
                                match = Sentence.scanChineseBracket(src, i);
                                i = match == -1 ? srcLen : match + 1;
                                continue block27;
                            }
                            ++i;
                            continue block27;
                        }
                    }
                    if (c2 == '\r') {
                        sub = src.substring(start, i);
                        result.add(Sequence.toSequence(sub, sep, opt));
                        if (++i < srcLen && src.charAt(i) == '\n') {
                            start = ++i;
                            continue;
                        }
                        start = i;
                        continue;
                    }
                    if (c2 == '\n') {
                        sub = src.substring(start, i);
                        result.add(Sequence.toSequence(sub, sep, opt));
                        start = ++i;
                        continue;
                    }
                    ++i;
                }
                String sub = src.substring(start);
                if (bTrim) {
                    sub = sub.trim();
                }
                result.add(Sequence.toSequence(sub, sep, opt));
            } else {
                int start = 0;
                while (true) {
                    String sub;
                    int index;
                    if ((index = src.indexOf(10, start)) == -1) {
                        sub = src.substring(start);
                        if (bTrim) {
                            sub = sub.trim();
                        }
                        result.add(Sequence.toSequence(sub, sep, opt));
                        break;
                    }
                    sub = index > start && src.charAt(index - 1) == '\r' ? src.substring(start, index - 1) : src.substring(start, index);
                    if (bTrim) {
                        sub = sub.trim();
                    }
                    result.add(Sequence.toSequence(sub, sep, opt));
                    start = index + 1;
                }
            }
            return result;
        }
        if (sep == null) {
            sep = ",";
        } else if (sep.length() == 0) {
            if (bTrim) {
                int i;
                int srcLen = src.length();
                int start = -1;
                for (i = 0; i < srcLen; ++i) {
                    if (Character.isWhitespace(src.charAt(i))) continue;
                    start = i;
                    break;
                }
                if (start == -1) {
                    return new Sequence(0);
                }
                Sequence result = new Sequence();
                if (bMatch) {
                    block30: while (i < srcLen) {
                        char c = src.charAt(i);
                        switch (c) {
                            case '\"': 
                            case '\'': {
                                i = Sentence.scanQuotation(src, i);
                                if (i == -1) break;
                                ++i;
                                continue block30;
                            }
                            case '(': {
                                i = Sentence.scanParenthesis(src, i);
                                if (i == -1) break;
                                ++i;
                                continue block30;
                            }
                            case '[': {
                                i = Sentence.scanBracket(src, i);
                                if (i == -1) break;
                                ++i;
                                continue block30;
                            }
                            case '{': {
                                i = Sentence.scanBrace(src, i);
                                if (i == -1) break;
                                ++i;
                                continue block30;
                            }
                            case '\u300a': 
                            case '\u3010': 
                            case '\uff08': {
                                i = Sentence.scanChineseBracket(src, i);
                                if (i == -1) break;
                                ++i;
                                continue block30;
                            }
                            case '<': {
                                if (gopt) {
                                    if ((i = Sentence.scanChineseBracket(src, i)) == -1) break;
                                    ++i;
                                    continue block30;
                                }
                                ++i;
                                continue block30;
                            }
                        }
                        if (Character.isWhitespace(c)) {
                            String sub = src.substring(start, i);
                            if (bData) {
                                result.add(Variant.parse(sub));
                            } else {
                                result.add(sub);
                            }
                            start = -1;
                            ++i;
                            while (i < srcLen) {
                                if (!Character.isWhitespace(src.charAt(i))) {
                                    start = i;
                                    continue block30;
                                }
                                ++i;
                            }
                            continue;
                        }
                        ++i;
                    }
                } else {
                    ++i;
                    while (i < srcLen) {
                        if (Character.isWhitespace(src.charAt(i))) {
                            String sub = src.substring(start, i);
                            if (bData) {
                                result.add(Variant.parse(sub));
                            } else {
                                result.add(sub);
                            }
                            start = -1;
                            ++i;
                            while (i < srcLen) {
                                if (!Character.isWhitespace(src.charAt(i))) {
                                    start = i;
                                    break;
                                }
                                ++i;
                            }
                        }
                        ++i;
                    }
                }
                if (start != -1) {
                    String sub = src.substring(start, srcLen);
                    if (bData) {
                        result.add(Variant.parse(sub));
                    } else {
                        result.add(sub);
                    }
                }
                return result;
            }
            char[] chars = src.toCharArray();
            int len = chars.length;
            Sequence result = new Sequence(len);
            if (bData) {
                for (int i = 0; i < len; ++i) {
                    String s = new String(chars, i, 1);
                    result.add(Variant.parse(s));
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    result.add(new String(chars, i, 1));
                }
            }
            return result;
        }
        Sequence result = new Sequence();
        int srcLen = src.length();
        int sepLen = sep.length();
        if (bLast) {
            int index = bMatch ? Sentence.lastIndexOf(src, sep) : src.lastIndexOf(sep);
            if (index == -1) {
                if (bTrim) {
                    src = src.trim();
                }
                result.add(bData ? Variant.parse(src) : src);
            } else {
                String sub = src.substring(0, index);
                if (bTrim) {
                    sub = sub.trim();
                }
                result.add(bData ? Variant.parse(sub) : sub);
                sub = src.substring(index + sepLen);
                if (bTrim) {
                    sub = sub.trim();
                }
                result.add(bData ? Variant.parse(sub) : sub);
            }
        } else if (bMatch) {
            int start = 0;
            int i = 0;
            block36: while (i < srcLen) {
                char c = src.charAt(i);
                switch (c) {
                    case '\"': 
                    case '\'': {
                        int match = Sentence.scanQuotation(src, i);
                        i = match == -1 ? srcLen : match + 1;
                        continue block36;
                    }
                    case '(': {
                        int match = Sentence.scanParenthesis(src, i);
                        i = match == -1 ? srcLen : match + 1;
                        continue block36;
                    }
                    case '[': {
                        int match = Sentence.scanBracket(src, i);
                        i = match == -1 ? srcLen : match + 1;
                        continue block36;
                    }
                    case '{': {
                        int match = Sentence.scanBrace(src, i);
                        i = match == -1 ? srcLen : match + 1;
                        continue block36;
                    }
                    case '\u300a': 
                    case '\u3010': 
                    case '\uff08': {
                        int match = Sentence.scanChineseBracket(src, i);
                        i = match == -1 ? srcLen : match + 1;
                        continue block36;
                    }
                    case '<': {
                        int match;
                        if (gopt) {
                            match = Sentence.scanChineseBracket(src, i);
                            i = match == -1 ? srcLen : match + 1;
                            continue block36;
                        }
                        ++i;
                        continue block36;
                    }
                }
                if (src.startsWith(sep, i)) {
                    String sub;
                    if (bData) {
                        if (src.charAt(start) == '[' && i > 0 && src.charAt(i - 1) == ']') {
                            sub = src.substring(start + 1, i - 1);
                            result.add(Sequence.toSequence(sub, sep, opt));
                        } else {
                            sub = src.substring(start, i);
                            if (bTrim) {
                                sub = sub.trim();
                            }
                            result.add(Variant.parse(sub));
                        }
                    } else {
                        sub = src.substring(start, i);
                        if (bTrim) {
                            sub = sub.trim();
                        }
                        result.add(sub);
                    }
                    if (bFirst) {
                        if (bData) {
                            if (src.charAt(i + sepLen) == '[' && src.charAt(srcLen - 1) == ']') {
                                sub = src.substring(i + sepLen + 1, srcLen - 1);
                                result.add(Sequence.toSequence(sub, sep, opt));
                            } else {
                                sub = src.substring(i + sepLen);
                                if (bTrim) {
                                    sub = sub.trim();
                                }
                                result.add(Variant.parse(sub));
                            }
                        } else {
                            sub = src.substring(i + sepLen);
                            if (bTrim) {
                                sub = sub.trim();
                            }
                            result.add(sub);
                        }
                        return result;
                    }
                    start = i += sepLen;
                    continue;
                }
                ++i;
            }
            String sub = src.substring(start);
            if (bTrim) {
                sub = sub.trim();
            }
            result.add(bData ? Variant.parse(sub) : sub);
        } else {
            int start = 0;
            while (true) {
                String sub;
                int index;
                if ((index = src.indexOf(sep, start)) == -1) {
                    sub = src.substring(start);
                    if (bTrim) {
                        sub = sub.trim();
                    }
                    result.add(bData ? Variant.parse(sub) : sub);
                    break;
                }
                sub = src.substring(start, index);
                if (bTrim) {
                    sub = sub.trim();
                }
                result.add(bData ? Variant.parse(sub) : sub);
                if (bFirst) {
                    sub = src.substring(index + sepLen);
                    if (bTrim) {
                        sub = sub.trim();
                    }
                    result.add(bData ? Variant.parse(sub) : sub);
                    break;
                }
                start = index + sepLen;
            }
        }
        return result;
    }

    public DataStruct dataStruct() {
        if (!this.isPurePmt()) {
            return null;
        }
        return ((BaseRecord)this.ifn()).dataStruct();
    }

    public Table create() {
        Object obj = this.ifn();
        if (obj instanceof BaseRecord) {
            Table table = new Table(((BaseRecord)obj).dataStruct());
            return table;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("engine.needPurePmt"));
    }

    /*
     * Enabled aggressive block sorting
     */
    public int pfindByKey(Object key, boolean isSorted) {
        int len;
        IArray mems;
        block46: {
            block45: {
                Object timeKeyValue;
                Object[] baseKeyValues;
                int timeKeyIndex;
                int[] baseKeyIndex;
                block43: {
                    int cmp;
                    BaseRecord r;
                    int index;
                    block51: {
                        block50: {
                            block48: {
                                block49: {
                                    block47: {
                                        int high;
                                        int low;
                                        block44: {
                                            Object startVal;
                                            block42: {
                                                IndexTable indexTable;
                                                if (!isSorted && (indexTable = this.getIndexTable()) != null) {
                                                    if (!(key instanceof Sequence)) return indexTable.findPos(key);
                                                    Object[] values = ((Sequence)key).toArray();
                                                    return indexTable.findPos(values);
                                                }
                                                mems = this.getMems();
                                                len = mems.size();
                                                if (len == 0) {
                                                    return -1;
                                                }
                                                startVal = mems.get(1);
                                                DataStruct ds = null;
                                                if (startVal instanceof BaseRecord) {
                                                    ds = ((BaseRecord)startVal).dataStruct();
                                                }
                                                if (ds == null || ds.getTimeKeyCount() <= 0) break block42;
                                                baseKeyIndex = ds.getBaseKeyIndex();
                                                timeKeyIndex = ds.getTimeKeyIndex();
                                                int baseKeyCount = baseKeyIndex.length;
                                                baseKeyValues = null;
                                                timeKeyValue = null;
                                                if (key instanceof Sequence) {
                                                    Sequence seq = (Sequence)key;
                                                    if (seq.length() == baseKeyCount) {
                                                        baseKeyValues = seq.toArray();
                                                    } else {
                                                        if (seq.length() != baseKeyCount + 1) {
                                                            MessageManager mm = EngineMessage.get();
                                                            throw new RQException(mm.getMessage("engine.keyValCountNotMatch"));
                                                        }
                                                        baseKeyValues = new Object[baseKeyCount];
                                                        timeKeyValue = seq.getMem(baseKeyCount + 1);
                                                        for (int i = 1; i <= baseKeyCount; ++i) {
                                                            baseKeyValues[i - 1] = seq.getMem(i);
                                                        }
                                                    }
                                                } else {
                                                    if (baseKeyCount != 1) {
                                                        MessageManager mm = EngineMessage.get();
                                                        throw new RQException(mm.getMessage("engine.keyValCountNotMatch"));
                                                    }
                                                    baseKeyValues = new Object[]{key};
                                                }
                                                if (!isSorted) break block43;
                                                index = -1;
                                                low = 1;
                                                high = len;
                                                break block44;
                                            }
                                            if (key instanceof Sequence) {
                                                Sequence seq = (Sequence)key;
                                                int klen = seq.length();
                                                if (klen == 0) {
                                                    return 0;
                                                }
                                                if (startVal instanceof BaseRecord) {
                                                    startVal = ((BaseRecord)startVal).getPKValue();
                                                }
                                                if (startVal instanceof Sequence) {
                                                    int klen2 = ((Sequence)startVal).length();
                                                    if (klen > klen2) {
                                                        key = seq.get(1, klen2 + 1);
                                                    }
                                                } else {
                                                    key = seq.getMem(1);
                                                }
                                            }
                                            if (isSorted) break block45;
                                            break block46;
                                        }
                                        while (low <= high) {
                                            int mid = low + high >> 1;
                                            BaseRecord r2 = (BaseRecord)mems.get(mid);
                                            int value = r2.compare(baseKeyIndex, baseKeyValues);
                                            if (value < 0) {
                                                low = mid + 1;
                                                continue;
                                            }
                                            if (value > 0) {
                                                high = mid - 1;
                                                continue;
                                            }
                                            index = mid;
                                            break;
                                        }
                                        if (index == -1) {
                                            return -low;
                                        }
                                        if (timeKeyValue != null) break block47;
                                        ++index;
                                        break block48;
                                    }
                                    r = (BaseRecord)mems.get(index);
                                    cmp = Variant.compare(r.getNormalFieldValue(timeKeyIndex), timeKeyValue, true);
                                    if (cmp == 0) {
                                        return index;
                                    }
                                    if (cmp <= 0) break block49;
                                    --index;
                                    break block50;
                                }
                                ++index;
                                break block51;
                            }
                            while (index <= len) {
                                BaseRecord r3 = (BaseRecord)mems.get(index);
                                if (r3.compare(baseKeyIndex, baseKeyValues) != 0) {
                                    return index - 1;
                                }
                                ++index;
                            }
                            return index - 1;
                        }
                        while (index > 0) {
                            r = (BaseRecord)mems.get(index);
                            if (r.compare(baseKeyIndex, baseKeyValues) != 0) {
                                return -index - 1;
                            }
                            if (Variant.compare(r.getNormalFieldValue(timeKeyIndex), timeKeyValue, true) <= 0) {
                                return index;
                            }
                            --index;
                        }
                        return -1;
                    }
                    while (index <= len) {
                        r = (BaseRecord)mems.get(index);
                        if (r.compare(baseKeyIndex, baseKeyValues) != 0) {
                            return index - 1;
                        }
                        cmp = Variant.compare(r.getNormalFieldValue(timeKeyIndex), timeKeyValue, true);
                        if (cmp == 0) {
                            return index;
                        }
                        if (cmp > 0) {
                            return index - 1;
                        }
                        ++index;
                    }
                    return index - 1;
                }
                int prevIndex = 0;
                Object prevTimeValue = null;
                int i = 1;
                while (i <= len) {
                    Object obj = mems.get(i);
                    BaseRecord r = (BaseRecord)obj;
                    if (r.compare(baseKeyIndex, baseKeyValues) == 0) {
                        Object curTimeValue = r.getNormalFieldValue(timeKeyIndex);
                        if (timeKeyValue == null) {
                            if (prevIndex == 0 || Variant.compare(curTimeValue, prevTimeValue) > 0) {
                                prevIndex = i;
                                prevTimeValue = curTimeValue;
                            }
                        } else {
                            int cmp = Variant.compare(curTimeValue, timeKeyValue);
                            if (cmp == 0) {
                                return i;
                            }
                            if (cmp < 0 && (prevIndex == 0 || Variant.compare(curTimeValue, prevTimeValue) > 0)) {
                                prevIndex = i;
                                prevTimeValue = curTimeValue;
                            }
                        }
                    }
                    ++i;
                }
                return prevIndex;
            }
            int low = 1;
            int high = len;
            while (low <= high) {
                int mid = low + high >> 1;
                Object obj = mems.get(mid);
                Object keyVal = obj instanceof BaseRecord ? ((BaseRecord)obj).getPKValue() : obj;
                int value = Variant.compare(keyVal, key);
                if (value < 0) {
                    low = mid + 1;
                    continue;
                }
                if (value <= 0) return mid;
                high = mid - 1;
            }
            return -low;
        }
        int i = 1;
        while (i <= len) {
            Object obj = mems.get(i);
            if (obj instanceof BaseRecord ? Variant.isEquals(((BaseRecord)obj).getPKValue(), key) : Variant.isEquals(obj, key)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public int pfindByFields(Object[] fvals, int[] findex) {
        IArray mems = this.getMems();
        int len = mems.size();
        int fcount = findex.length;
        Object[] vals = new Object[fcount];
        int low = 1;
        int high = len;
        while (low <= high) {
            int mid = low + high >> 1;
            BaseRecord r = (BaseRecord)mems.get(mid);
            for (int f = 0; f < fcount; ++f) {
                vals[f] = r.getNormalFieldValue(findex[f]);
            }
            int value = Variant.compareArrays(vals, fvals);
            if (value < 0) {
                low = mid + 1;
                continue;
            }
            if (value > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low;
    }

    public Object findByKey(Object key, boolean isSorted) {
        if (isSorted) {
            int index = this.pfindByKey(key, isSorted);
            return index > 0 ? this.getMem(index) : null;
        }
        IndexTable indexTable = this.getIndexTable();
        if (indexTable == null) {
            int index = this.pfindByKey(key, isSorted);
            return index > 0 ? this.getMem(index) : null;
        }
        if (key instanceof Sequence) {
            Sequence seq = (Sequence)key;
            int klen = seq.length();
            if (klen == 0 || this.length() == 0) {
                return null;
            }
            int keyCount = 1;
            Object startVal = this.getMem(1);
            if (startVal instanceof BaseRecord) {
                int[] pkIndex = ((BaseRecord)startVal).getPKIndex();
                if (pkIndex == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("ds.lessKey"));
                }
                keyCount = pkIndex.length;
            } else if (startVal instanceof Sequence) {
                keyCount = ((Sequence)startVal).length();
            }
            if (keyCount > 1) {
                if (klen > keyCount) {
                    Object[] vals = new Object[keyCount];
                    for (int i = 1; i <= keyCount; ++i) {
                        vals[i - 1] = seq.getMem(i);
                    }
                    return indexTable.find(vals);
                }
                return indexTable.find(seq.toArray());
            }
            return indexTable.find(seq.getMem(1));
        }
        return indexTable.find(key);
    }

    public BaseRecord select(int[] keyIndex, Object[] values, boolean isSorted) {
        IArray mems = this.getMems();
        int sLength = mems.size();
        if (isSorted) {
            int low = 1;
            int high = sLength;
            while (low <= high) {
                int mid = low + high >> 1;
                BaseRecord r = (BaseRecord)mems.get(mid);
                int value = r.compare(keyIndex, values);
                if (value < 0) {
                    low = mid + 1;
                    continue;
                }
                if (value > 0) {
                    high = mid - 1;
                    continue;
                }
                return r;
            }
        } else {
            int fcount = keyIndex.length;
            block1: for (int i = 1; i <= sLength; ++i) {
                BaseRecord r = (BaseRecord)mems.get(i);
                for (int f = 0; f < fcount; ++f) {
                    if (!Variant.isEquals(r.getFieldValue(keyIndex[f]), values[f])) continue block1;
                }
                return r;
            }
        }
        return null;
    }

    public Sequence getPKeyValues() {
        IArray mems = this.getMems();
        int len = mems.size();
        Sequence result = new Sequence(len);
        IArray resultMems = result.getMems();
        for (int i = 1; i <= len; ++i) {
            Object obj = mems.get(i);
            if (obj instanceof BaseRecord) {
                resultMems.add(((BaseRecord)obj).getPKValue());
                continue;
            }
            resultMems.add(obj);
        }
        return result;
    }

    public Object switchFk(Function function, String[] fkNames, String[] timeNames, Object[] codes, Expression[] exps, Expression[] timeExps, String opt, Context ctx) {
        int count = codes.length;
        Sequence[] seqs = new Sequence[count];
        boolean hasClusterTable = false;
        for (int i = 0; i < count; ++i) {
            if (codes[i] instanceof Sequence) {
                seqs[i] = (Sequence)codes[i];
                continue;
            }
            if (codes[i] instanceof ClusterMemoryTable) {
                hasClusterTable = true;
                continue;
            }
            if (codes[i] == null) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException("switch" + mm.getMessage("function.paramTypeError"));
        }
        Operation op = hasClusterTable ? new SwitchRemote(function, fkNames, codes, exps, opt) : new Switch(function, fkNames, timeNames, seqs, exps, timeExps, opt);
        Sequence result = ((Operation)op).process(this, ctx);
        if (result == null || result.length() == 0) {
            this.clear();
        } else {
            this.mems = result.mems;
        }
        return this;
    }

    public void switchFk(String fkName, Sequence code, Expression exp, String opt, Context ctx) {
        IArray mems = this.getMems();
        if (mems.size() == 0) {
            return;
        }
        if (code != null) {
            CursorUtil.hashSwitch(this, fkName, code, exp, opt, ctx);
            return;
        }
        int col = -1;
        BaseRecord prevRecord = null;
        int len = mems.size();
        for (int i = 1; i <= len; ++i) {
            Object obj = mems.get(i);
            if (obj instanceof BaseRecord) {
                Object fval;
                BaseRecord cur = (BaseRecord)obj;
                if (prevRecord == null || !prevRecord.isSameDataStruct(cur)) {
                    col = cur.getFieldIndex(fkName);
                    if (col < 0) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(fkName + mm.getMessage("ds.fieldNotExist"));
                    }
                    prevRecord = cur;
                }
                if (!((fval = cur.getNormalFieldValue(col)) instanceof BaseRecord)) continue;
                cur.setNormalFieldValue(col, ((BaseRecord)fval).getPKValue());
                continue;
            }
            if (obj == null) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPmt"));
        }
    }

    public Sequence Join(Expression[][] exps, Sequence[] codes, Expression[][] dataExps, Expression[][] newExps, String[][] newNames, String opt, Context ctx) {
        Join join = new Join(null, exps, codes, dataExps, newExps, newNames, null);
        return join.process(this, ctx);
    }

    public void sortFields(String[] cols) {
        DataStruct ds = this.dataStruct();
        if (ds == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        int colCount = cols.length;
        int[] colIndex = new int[colCount];
        for (int i = 0; i < colCount; ++i) {
            colIndex[i] = ds.getFieldIndex(cols[i]);
            if (colIndex[i] != -1) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(cols[i] + mm.getMessage("ds.fieldNotExist"));
        }
        RecordFieldComparator comparator = new RecordFieldComparator(colIndex);
        this.getMems().sort(comparator);
    }

    public IndexTable getIndexTable() {
        return null;
    }

    public IndexTable getIndexTable(Expression exp, Context ctx) {
        return null;
    }

    public IndexTable getIndexTable(Expression[] exps, Context ctx) {
        return null;
    }

    public Sequence memberAdd(Sequence sequence) {
        if (this.length() != sequence.length()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.memCountNotMatch"));
        }
        IArray result = this.getMems().memberAdd(sequence.getMems());
        return new Sequence(result);
    }

    public Sequence memberSubtract(Sequence sequence) {
        if (this.length() != sequence.length()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.memCountNotMatch"));
        }
        IArray result = this.getMems().memberSubtract(sequence.getMems());
        return new Sequence(result);
    }

    public Sequence memberMultiply(Sequence sequence) {
        if (this.length() != sequence.length()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.memCountNotMatch"));
        }
        IArray result = this.getMems().memberMultiply(sequence.getMems());
        return new Sequence(result);
    }

    public Sequence memberDivide(Sequence sequence) {
        if (this.length() != sequence.length()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.memCountNotMatch"));
        }
        IArray result = this.getMems().memberDivide(sequence.getMems());
        return new Sequence(result);
    }

    public Sequence memberIntDivide(Sequence sequence) {
        if (this.length() != sequence.length()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.memCountNotMatch"));
        }
        IArray result = this.getMems().memberIntDivide(sequence.getMems());
        return new Sequence(result);
    }

    public Sequence memberMod(Sequence sequence) {
        if (this.length() != sequence.length()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.memCountNotMatch"));
        }
        IArray result = this.getMems().memberMod(sequence.getMems());
        return new Sequence(result);
    }

    public Sequence multiply(int k) {
        int size = this.length();
        IArray mems = this.getMems();
        IArray result = mems.newInstance(size * k);
        for (int i = 0; i < k; ++i) {
            result.addAll(mems);
        }
        return new Sequence(result);
    }

    public boolean isTrue(int index) {
        return this.getMems().isTrue(index);
    }

    public boolean containField(String fieldName) {
        Object obj = this.ifn();
        if (obj instanceof BaseRecord) {
            DataStruct ds = ((BaseRecord)obj).dataStruct();
            return ds.getFieldIndex(fieldName) != -1;
        }
        return false;
    }

    public IArray getFieldValueArray(String fieldName) {
        Object obj;
        IArray mems = this.getMems();
        int size = mems.size();
        if (size == 0) {
            return new ObjectArray(0);
        }
        int col = -1;
        BaseRecord r = null;
        DataStruct prevDs = null;
        IArray result = null;
        int i = 1;
        while (i <= size) {
            if ((obj = mems.get(i++)) instanceof BaseRecord) {
                r = (BaseRecord)obj;
                col = r.getFieldIndex(fieldName);
                if (col < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(fieldName + mm.getMessage("ds.fieldNotExist"));
                }
                prevDs = r.dataStruct();
                result = r.createFieldValueArray(col, size);
                for (int n = 2; n < i; ++n) {
                    result.pushNull();
                }
                r.getNormalFieldValue(col, result);
                break;
            }
            if (obj == null) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPmt"));
        }
        if (result == null) {
            Object[] datas = new Object[size + 1];
            result = new ObjectArray(datas, size);
            return result;
        }
        while (i <= size) {
            obj = mems.get(i);
            if (obj instanceof BaseRecord) {
                r = (BaseRecord)obj;
                if (r.dataStruct() != prevDs && (col = (prevDs = r.dataStruct()).getFieldIndex(fieldName)) < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(fieldName + mm.getMessage("ds.fieldNotExist"));
                }
                r.getNormalFieldValue(col, result);
            } else if (obj == null) {
                result.pushNull();
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needPmt"));
            }
            ++i;
        }
        return result;
    }

    public IArray getFieldValueArray(int field) {
        IArray mems = this.getMems();
        int size = mems.size();
        if (size == 0) {
            return new ObjectArray(0);
        }
        BaseRecord r = null;
        IArray result = null;
        int i = 1;
        while (i <= size) {
            if ((r = (BaseRecord)mems.get(i++)) == null) continue;
            result = r.createFieldValueArray(field, size);
            for (int n = 2; n < i; ++n) {
                result.pushNull();
            }
            r.getNormalFieldValue(field, result);
            break;
        }
        if (result == null) {
            Object[] datas = new Object[size + 1];
            result = new ObjectArray(datas, size);
            return result;
        }
        while (i <= size) {
            r = (BaseRecord)mems.get(i);
            if (r != null) {
                r.getNormalFieldValue(field, result);
            } else {
                result.pushNull();
            }
            ++i;
        }
        return result;
    }

    public IArray getFieldValueArray(IArray posArray, String fieldName) {
        int index;
        Object obj;
        int len = posArray.size();
        if (len == 0) {
            return new ObjectArray(0);
        }
        IArray mems = this.getMems();
        int col = -1;
        BaseRecord r = null;
        DataStruct prevDs = null;
        IArray result = null;
        int i = 1;
        while (i <= len) {
            if ((obj = mems.get(index = posArray.getInt(i++))) instanceof BaseRecord) {
                r = (BaseRecord)obj;
                col = r.getFieldIndex(fieldName);
                if (col < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(fieldName + mm.getMessage("ds.fieldNotExist"));
                }
                prevDs = r.dataStruct();
                result = r.createFieldValueArray(col, len);
                for (int n = 2; n < i; ++n) {
                    result.pushNull();
                }
                r.getNormalFieldValue(col, result);
                break;
            }
            if (obj == null) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPmt"));
        }
        if (result == null) {
            Object[] datas = new Object[len + 1];
            result = new ObjectArray(datas, len);
            return result;
        }
        while (i <= len) {
            index = posArray.getInt(i);
            obj = mems.get(index);
            if (obj instanceof BaseRecord) {
                r = (BaseRecord)obj;
                if (r.dataStruct() != prevDs && (col = (prevDs = r.dataStruct()).getFieldIndex(fieldName)) < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(fieldName + mm.getMessage("ds.fieldNotExist"));
                }
                r.getNormalFieldValue(col, result);
            } else if (obj == null) {
                result.pushNull();
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needPmt"));
            }
            ++i;
        }
        return result;
    }

    public IArray getFieldValueArray(IArray posArray, int field) {
        int index;
        int len = posArray.size();
        if (len == 0) {
            return new ObjectArray(0);
        }
        IArray mems = this.getMems();
        BaseRecord r = null;
        IArray result = null;
        int i = 1;
        while (i <= len) {
            if ((r = (BaseRecord)mems.get(index = posArray.getInt(i++))) == null) continue;
            result = r.createFieldValueArray(field, len);
            for (int n = 2; n < i; ++n) {
                result.pushNull();
            }
            r.getNormalFieldValue(field, result);
            break;
        }
        if (result == null) {
            Object[] datas = new Object[len + 1];
            result = new ObjectArray(datas, len);
            return result;
        }
        while (i <= len) {
            index = posArray.getInt(i);
            r = (BaseRecord)mems.get(index);
            if (r != null) {
                r.getNormalFieldValue(field, result);
            } else {
                result.pushNull();
            }
            ++i;
        }
        return result;
    }

    public Object getFieldValue2(int row, int field) {
        Object obj = this.get(row);
        if (obj instanceof BaseRecord) {
            return ((BaseRecord)obj).getFieldValue2(field);
        }
        if (obj == null) {
            return null;
        }
        if (obj instanceof Sequence) {
            if (((Sequence)obj).length() == 0) {
                return null;
            }
            if ((obj = ((Sequence)obj).get(1)) instanceof BaseRecord) {
                return ((BaseRecord)obj).getFieldValue2(field);
            }
            if (obj == null) {
                return null;
            }
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("#" + (field + 1) + mm.getMessage("ds.fieldNotExist"));
    }

    public IArray getMemberArray(int[] indexArray) {
        return this.getMems().get(indexArray);
    }

    public IArray getMemberArray(NumberArray indexArray) {
        return this.getMems().get(indexArray);
    }

    public IndexTable newIndexTable() {
        return this.newIndexTable(this.length());
    }

    public IndexTable newIndexTable(int capacity) {
        BaseRecord r;
        IndexTable it = this.getIndexTable();
        if (it != null) {
            return it;
        }
        Object obj = null;
        if (this.length() > 0) {
            obj = this.getMem(1);
        }
        if (obj instanceof BaseRecord && (r = (BaseRecord)obj).dataStruct().getTimeKeyCount() == 1) {
            int[] pkIndex = r.dataStruct().getPKIndex();
            return new TimeIndexTable(this, pkIndex, capacity);
        }
        HashIndexTable hashIndexTable = new HashIndexTable(capacity);
        hashIndexTable.create(this);
        return hashIndexTable;
    }

    public IndexTable newIndexTable(Expression exp, Context ctx) {
        return this.newIndexTable(exp, ctx, this.length());
    }

    public IndexTable newIndexTable(Expression exp, Context ctx, int capacity) {
        if (exp == null) {
            return this.newIndexTable(capacity);
        }
        HashIndexTable it = new HashIndexTable(capacity);
        it.create(this, exp, ctx);
        return it;
    }

    public IndexTable newIndexTable(int[] fields, int capacity, String opt) {
        BaseRecord r;
        if (fields.length == 1) {
            DataStruct ds = this.dataStruct();
            if (ds != null && ds.isSeqKey() || opt != null && opt.indexOf(110) != -1) {
                return new SeqIndexTable(this, fields[0]);
            }
            HashIndexTable it = new HashIndexTable(capacity, opt);
            it.create(this, fields[0], true);
            return it;
        }
        if (this.length() > 0 && (r = (BaseRecord)this.getMem(1)).dataStruct().getTimeKeyCount() == 1) {
            return new TimeIndexTable(this, fields, capacity);
        }
        HashArrayIndexTable it = new HashArrayIndexTable(capacity, opt);
        it.create(this, fields, true);
        return it;
    }

    public IndexTable newIndexTable(Expression[] exps, Context ctx) {
        return this.newIndexTable(exps, ctx, this.length());
    }

    public IndexTable newIndexTable(Expression[] exps, Context ctx, int capacity) {
        int[] pkIndex;
        DataStruct ds;
        if (exps == null) {
            return this.newIndexTable(capacity);
        }
        if (exps.length == 1) {
            return this.newIndexTable(exps[0], ctx, capacity);
        }
        Object obj = null;
        if (this.length() > 0) {
            obj = this.getMem(1);
        }
        if (obj instanceof BaseRecord && (ds = ((BaseRecord)obj).dataStruct()).getTimeKeyCount() == 1 && ds.isSameFields(exps, pkIndex = ds.getPKIndex())) {
            return new TimeIndexTable(this, pkIndex, capacity);
        }
        HashArrayIndexTable it = new HashArrayIndexTable(capacity);
        it.create(this, exps, ctx);
        return it;
    }

    public IndexTable newMergeIndexTable(Expression[] exps, Context ctx) {
        return new MergeIndexTable(this, exps, ctx);
    }

    public ICursor cursor() {
        return new MemoryCursor(this);
    }

    public ICursor cursor(int start, int end) {
        return new MemoryCursor(this, start, end);
    }

    public Sequence bits(String opt) {
        if (opt != null && opt.indexOf(109) != -1) {
            return MultithreadUtil.bits(this, opt);
        }
        IArray mems = this.getMems();
        int len = mems.size();
        if (len == 0) {
            return new Sequence(0);
        }
        int q = 1;
        int numCount = len / 64;
        Sequence result = len % 64 == 0 ? new Sequence(numCount) : new Sequence(numCount + 1);
        if (opt == null || opt.indexOf(98) == -1) {
            for (int i = 0; i < numCount; ++i) {
                long value = 0L;
                int j = 63;
                while (j >= 0) {
                    value += mems.getLong(q) << j;
                    --j;
                    ++q;
                }
                result.add(value);
            }
            if (q <= len) {
                long value = 0L;
                int j = 63;
                while (q <= len) {
                    value += mems.getLong(q) << j;
                    --j;
                    ++q;
                }
                result.add(value);
            }
        } else {
            for (int i = 0; i < numCount; ++i) {
                long value = 0L;
                int j = 63;
                while (j >= 0) {
                    if (mems.isTrue(q)) {
                        value += 1L << j;
                    }
                    --j;
                    ++q;
                }
                result.add(value);
            }
            if (q <= len) {
                long value = 0L;
                int j = 63;
                while (q <= len) {
                    if (mems.isTrue(q)) {
                        value += 1L << j;
                    }
                    --j;
                    ++q;
                }
                result.add(value);
            }
        }
        return result;
    }

    public Sequence bits(int start, int end, String opt) {
        IArray mems = this.getMems();
        int count = end - start;
        int numCount = count / 64;
        int q = start;
        Sequence result = count % 64 == 0 ? new Sequence(numCount) : new Sequence(numCount + 1);
        if (opt == null || opt.indexOf(98) == -1) {
            for (int i = 0; i < numCount; ++i) {
                long value = 0L;
                int j = 63;
                while (j >= 0) {
                    value += mems.getLong(q) << j;
                    --j;
                    ++q;
                }
                result.add(value);
            }
            if (q < end) {
                long value = 0L;
                int j = 63;
                while (q < end) {
                    value += mems.getLong(q) << j;
                    --j;
                    ++q;
                }
                result.add(value);
            }
        } else {
            for (int i = 0; i < numCount; ++i) {
                long value = 0L;
                int j = 63;
                while (j >= 0) {
                    if (mems.isTrue(q)) {
                        value += 1L << j;
                    }
                    --j;
                    ++q;
                }
                result.add(value);
            }
            if (q < end) {
                long value = 0L;
                int j = 63;
                while (q < end) {
                    if (mems.isTrue(q)) {
                        value += 1L << j;
                    }
                    --j;
                    ++q;
                }
                result.add(value);
            }
        }
        return result;
    }

    public Object bits(int n, String opt) {
        int q = (n - 1) / 64 + 1;
        IArray mems = this.getMems();
        if (opt == null || opt.indexOf(98) == -1) {
            if (q <= mems.size()) {
                long value = mems.getLong(q);
                value = value >>> 64 - n % 64 & 1L;
                return ObjectCache.getInteger((int)value);
            }
            return ObjectCache.getInteger(0);
        }
        if (q <= mems.size()) {
            long value = mems.getLong(q);
            if ((value >>> 64 - n % 64 & 1L) == 1L) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public int bit1(Sequence seq) {
        return this.getMems().bit1(seq.getMems());
    }

    public Sequence pjoin(Expression[] srcKeyExps, Expression[] srcNewExps, String[] srcNewNames, Sequence[] sequences, String[] options, Expression[][] keyExps, Expression[][] newExps, String[][] newNames, String opt, Context ctx) {
        if (opt != null && opt.indexOf(111) != -1) {
            int tableCount = sequences.length;
            ICursor[] cursors = new ICursor[tableCount];
            for (int i = 0; i < tableCount; ++i) {
                cursors[i] = sequences[i].cursor();
            }
            PrimaryJoin op = new PrimaryJoin(null, srcKeyExps, srcNewExps, srcNewNames, cursors, options, keyExps, newExps, newNames, opt, ctx);
            Sequence result = op.process(this, ctx);
            Sequence result2 = op.finish(ctx);
            if (result2 != null && result2.length() > 0) {
                if (result != null && result.length() > 0) {
                    return result.append(result2);
                }
                return result2;
            }
            return result;
        }
        IIlIllIlIIIlIlII hashTable = new IIlIllIlIIIlIlII(this, srcKeyExps, srcNewExps, srcNewNames, sequences, options, keyExps, newExps, newNames, opt, ctx);
        return hashTable.result();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence mjoin(Expression exp, Sequence seq, Expression keyExp, Object from, Object to, Expression[] newExps, String[] newNames, String opt, Context ctx) {
        Table table;
        block17: {
            if (this.length() == 0 || seq == null || seq.length() == 0) {
                return this;
            }
            if (to == null) {
                to = from;
            }
            IArray mems = this.getMems();
            IArray mems2 = seq.getMems();
            BaseRecord rec = (BaseRecord)mems.get(1);
            int newFieldsCount = newNames.length;
            DataStruct newDs = rec.dataStruct().dup();
            int fcount = newDs.getFieldCount();
            String[] names = Arrays.copyOf(newDs.getFieldNames(), fcount + newFieldsCount);
            System.arraycopy(newNames, 0, names, fcount, newFieldsCount);
            newDs.setFieldName(names);
            int len = this.length();
            int len2 = seq.length();
            int cur = 1;
            boolean hasR = opt != null && opt.indexOf("r") != -1;
            boolean hasG = false;
            if (opt != null && opt.indexOf("g") != -1 && newExps.length == 1 && newExps[0].getHome() instanceof CurrentElement) {
                hasG = true;
            }
            table = new Table(newDs, len);
            IArray resultMems = table.getMems();
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(this);
            Current current2 = new Current(seq);
            stack.push(current);
            stack.push(current2);
            try {
                if (hasG) {
                    for (int i = 1; i <= len; ++i) {
                        int tempCur;
                        current.setCurrent(i);
                        Object obj = exp.calculate(ctx);
                        Object a = Variant.subtract(obj, from);
                        Object b = Variant.add(obj, to);
                        Sequence temp = new Sequence();
                        for (tempCur = cur; tempCur <= len2; ++tempCur) {
                            current2.setCurrent(tempCur);
                            Object obj2 = keyExp.calculate(ctx);
                            if (Variant.compare(obj2, a) >= 0) {
                                if (Variant.compare(obj2, b) > 0) break;
                                BaseRecord rec2 = (BaseRecord)mems2.get(tempCur);
                                temp.add(rec2);
                                continue;
                            }
                            ++cur;
                        }
                        Record r = new Record(newDs);
                        resultMems.add(r);
                        r.set((BaseRecord)mems.get(i));
                        if (temp.length() != 0) {
                            r.setNormalFieldValue(fcount, temp);
                        }
                        if (!hasR) {
                            cur = tempCur;
                        }
                        if (cur <= len2) continue;
                        break block17;
                    }
                    break block17;
                }
                for (int i = 1; i <= len; ++i) {
                    int tempCur;
                    current.setCurrent(i);
                    Object obj = exp.calculate(ctx);
                    Object a = Variant.subtract(obj, from);
                    Object b = Variant.add(obj, to);
                    BaseRecord rec1 = (BaseRecord)mems.get(i);
                    for (tempCur = cur; tempCur <= len2; ++tempCur) {
                        current2.setCurrent(tempCur);
                        Object obj2 = keyExp.calculate(ctx);
                        if (Variant.compare(obj2, a) >= 0) {
                            if (Variant.compare(obj2, b) > 0) break;
                            Record r = new Record(newDs);
                            resultMems.add(r);
                            r.set(rec1);
                            for (int f = 0; f < newFieldsCount; ++f) {
                                r.setNormalFieldValue(fcount + f, newExps[f].calculate(ctx));
                            }
                            continue;
                        }
                        ++cur;
                    }
                    if (!hasR) {
                        cur = tempCur;
                    }
                    if (cur <= len2) continue;
                    break;
                }
            }
            finally {
                stack.pop();
                stack.pop();
            }
        }
        return table;
    }

    public ICursor cursor(Expression[] exps, String[] names, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, Context ctx) {
        return this.cursor(1, this.length() + 1, exps, names, filter, fkNames, codes, opts, ctx);
    }

    public ICursor cursor(int start, int end, Expression[] exps, String[] names, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, Context ctx) {
        int i;
        ICursor cs = this.cursor(start, end);
        if (filter != null) {
            cs.select(null, filter, null, ctx);
        }
        if (fkNames != null && codes != null) {
            int fkCount = codes.length;
            for (i = 0; i < fkCount; ++i) {
                String option;
                String[] tempFkNames = new String[]{fkNames[i]};
                Sequence[] tempCodes = new Sequence[]{codes[i]};
                Expression[] codeExps = null;
                String string = option = opts == null ? null : opts[i];
                if (option == null) {
                    option = "i";
                } else if (option.equals("null")) {
                    option = "d";
                } else if (option.equals("#")) {
                    option = "i";
                    codeExps = new Expression[]{new Expression(ctx, "#")};
                } else {
                    option = "i";
                }
                cs.switchFk(null, tempFkNames, null, tempCodes, codeExps, null, option, ctx);
            }
        }
        if (exps == null && names != null) {
            int size = names.length;
            exps = new Expression[size];
            for (i = 0; i < size; ++i) {
                exps[i] = new Expression(names[i]);
            }
        }
        if (exps != null) {
            cs.newTable(null, exps, names, null, ctx);
        }
        return cs;
    }

    public MultipathCursors cursor(MultipathCursors syncCursor, String[] sortedFields, Expression[] exps, String[] names, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, String opt, Context ctx) {
        ICursor[] srcCursors = syncCursor.getParallelCursors();
        int segCount = srcCursors.length;
        if (segCount == 1) {
            ICursor cs = this.cursor(exps, names, filter, fkNames, codes, opts, ctx);
            ICursor[] cursors = new ICursor[]{cs};
            return new MultipathCursors(cursors, ctx);
        }
        Object[][] minValues = new Object[segCount][];
        int fcount = -1;
        for (int i = 1; i < segCount; ++i) {
            minValues[i] = srcCursors[i].getSegmentStartValues(opt);
            if (minValues[i] == null) continue;
            if (fcount == -1) {
                fcount = minValues[i].length;
                continue;
            }
            if (fcount == minValues[i].length) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.segFieldNotMatch"));
        }
        if (fcount == -1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.segFieldNotMatch"));
        }
        if (opt != null && opt.indexOf(107) != -1) {
            fcount = 1;
        } else if (sortedFields.length < fcount) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.segFieldNotMatch"));
        }
        int start = 1;
        ICursor[] resultCursors = new ICursor[segCount];
        Expression[] findExps = new Expression[fcount];
        for (int f = 0; f < fcount; ++f) {
            findExps[f] = new Expression(ctx, sortedFields[f]);
        }
        for (int i = 1; i < segCount; ++i) {
            int index = (Integer)this.pselect(findExps, minValues[i], start, "s", ctx);
            if (index < 0) {
                index = -index;
            }
            resultCursors[i - 1] = this.cursor(start, index, exps, names, filter, fkNames, codes, opts, ctx);
            start = index;
        }
        resultCursors[segCount - 1] = this.cursor(start, this.length() + 1, exps, names, filter, fkNames, codes, opts, ctx);
        return new MultipathCursors(resultCursors, ctx);
    }
}

