/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.array.BoolArray;
import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.IndexTable;
import com.scudata.dm.Sequence;
import com.scudata.dm.SerialBytes;
import com.scudata.resources.EngineMessage;

class SerialBytesIndexTable
extends IndexTable {
    private static final int SERIALBYTE_LEN = 256;
    private Object[] datas = new Object[256];
    private int level;

    public void create(Sequence code, int field) {
        int level;
        int len = code.length();
        if (len == 0) {
            return;
        }
        BaseRecord r = (BaseRecord)code.getMem(1);
        Object fval = r.getNormalFieldValue(field);
        if (!(fval instanceof SerialBytes)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.optError"));
        }
        SerialBytes sb = (SerialBytes)fval;
        this.level = level = sb.length();
        Object[] root = this.datas;
        int i = 1;
        while (i <= len) {
            MessageManager mm;
            r = (BaseRecord)code.getMem(i);
            fval = r.getNormalFieldValue(field);
            if (!(fval instanceof SerialBytes)) {
                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.optError"));
            }
            sb = (SerialBytes)fval;
            if (sb.length() != level) {
                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.keyValCountNotMatch"));
            }
            Object[] prev = root;
            int c = 1;
            while (c < level) {
                int n = (int)sb.getByte(c);
                if (prev[n] == null) {
                    prev[n] = new Object[256];
                }
                prev = (Object[])prev[n];
                ++c;
            }
            prev[(int)sb.getByte((int)level)] = r;
            ++i;
        }
    }

    @Override
    public Object find(Object key) {
        if (!(key instanceof SerialBytes)) {
            return null;
        }
        SerialBytes sb = (SerialBytes)key;
        int len = sb.length();
        if (len != this.level) {
            return null;
        }
        Object[] prev = this.datas;
        int c = 1;
        while (c < len) {
            int n = (int)sb.getByte(c);
            if (prev[n] == null) {
                return null;
            }
            prev = (Object[])prev[n];
            ++c;
        }
        return prev[(int)sb.getByte(this.level)];
    }

    @Override
    public Object find(Object[] keys) {
        if (keys.length == 1) {
            return this.find(keys[0]);
        }
        return null;
    }

    @Override
    public int findPos(Object key) {
        if (!(key instanceof SerialBytes)) {
            return -1;
        }
        SerialBytes sb = (SerialBytes)key;
        int len = sb.length();
        if (len != this.level) {
            return -1;
        }
        Object[] prev = this.datas;
        int c = 1;
        while (c < len) {
            int n = (int)sb.getByte(c);
            if (prev[n] == null) {
                return -1;
            }
            prev = (Object[])prev[n];
            ++c;
        }
        return (int)sb.getByte(this.level);
    }

    @Override
    public int findPos(Object[] keys) {
        if (keys.length == 1) {
            return this.findPos(keys[0]);
        }
        return 0;
    }

    @Override
    public int[] findAllPos(IArray key) {
        if (key == null) {
            return null;
        }
        int len = key.size();
        int[] pos = new int[len + 1];
        int i = 1;
        while (i <= len) {
            Object obj = key.get(i);
            pos[i] = this.findPos(obj);
            ++i;
        }
        return pos;
    }

    @Override
    public int[] findAllPos(IArray[] keys) {
        if (keys == null) {
            return null;
        }
        int keyCount = keys.length;
        int len = keys[0].size();
        int[] pos = new int[len + 1];
        if (keyCount != 1) {
            return pos;
        }
        return this.findAllPos(keys[0]);
    }

    @Override
    public int[] findAllPos(IArray key, BoolArray signArray) {
        if (key == null) {
            return null;
        }
        int len = key.size();
        int[] pos = new int[len + 1];
        int i = 1;
        while (i <= len) {
            if (!signArray.isFalse(i)) {
                Object obj = key.get(i);
                pos[i] = this.findPos(obj);
            }
            ++i;
        }
        return pos;
    }

    @Override
    public int[] findAllPos(IArray[] keys, BoolArray signArray) {
        if (keys == null) {
            return null;
        }
        int keyCount = keys.length;
        int len = keys[0].size();
        int[] pos = new int[len + 1];
        if (keyCount != 1) {
            return pos;
        }
        return this.findAllPos(keys[0], signArray);
    }
}

