/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.cursor;

import com.scudata.common.RQException;
import com.scudata.dm.BFileReader;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import java.io.IOException;

public class BFileCursor
extends ICursor {
    private FileObject _$12;
    private String[] _$11;
    private int _$10;
    private int _$9;
    private String _$8;
    private int _$7 = Env.FILE_BUFSIZE;
    private BFileReader _$6;
    private boolean _$5;
    private long _$4 = -1L;
    private long _$3;

    public BFileCursor(FileObject fileObject, String[] fields, String opt, Context ctx) {
        this(fileObject, fields, 1, 1, opt, ctx);
    }

    public BFileCursor(FileObject fileObject, String[] fields, int segSeq, int segCount, String opt, Context ctx) {
        this._$12 = fileObject;
        this._$11 = fields;
        this._$10 = segSeq;
        this._$9 = segCount;
        this._$8 = opt;
        this.ctx = ctx;
        this._$6 = new BFileReader(fileObject, fields, segSeq, segCount, opt);
        if (opt != null && opt.indexOf(120) != -1) {
            if (ctx != null) {
                ctx.addResource(this);
            }
            this._$5 = true;
        }
    }

    public void setPosRange(long startPos, long endPos) {
        this._$4 = startPos;
        this._$3 = endPos;
    }

    public void setFileBufferSize(int size) {
        this._$7 = size;
    }

    protected Sequence get(int n) {
        if (n < 1 || this._$6 == null) {
            return null;
        }
        try {
            if (!this._$6.isOpen()) {
                this._$6.open(this._$7);
                DataStruct ds = this._$6.getResultSetDataStruct();
                this.setDataStruct(ds);
                if (!this._$5 && this.ctx != null) {
                    this.ctx.addResource(this);
                }
                if (this._$4 > 0L) {
                    this._$6.seek(this._$4);
                    this._$6.setEndPos(this._$3);
                }
            }
            Sequence seq = this._$6.read(n);
            return seq;
        }
        catch (Exception e) {
            this.close();
            throw new RQException(e.getMessage(), e);
        }
    }

    protected long skipOver(long n) {
        if (n < 1L || this._$6 == null) {
            return 0L;
        }
        try {
            if (!this._$6.isOpen()) {
                this._$6.open(this._$7);
                DataStruct ds = this._$6.getResultSetDataStruct();
                this.setDataStruct(ds);
                if (this._$4 > 0L) {
                    this._$6.seek(this._$4);
                    this._$6.setEndPos(this._$3);
                }
            }
            long count = this._$6.skip(n);
            return count;
        }
        catch (Exception e) {
            this.close();
            throw new RQException(e.getMessage(), e);
        }
    }

    public synchronized void close() {
        super.close();
        if (this._$12 != null) {
            if (this._$6 != null) {
                if (this.ctx != null) {
                    this.ctx.removeResource(this);
                }
                try {
                    this._$6.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this._$6 = null;
            }
            if (this._$5) {
                this._$12.delete();
                this._$12 = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public boolean reset() {
        this.close();
        if (this._$12 != null) {
            this._$6 = new BFileReader(this._$12, this._$11, this._$10, this._$9, this._$8);
            return true;
        }
        return false;
    }
}

