/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.cursor;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.FileObject;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.SyncReader;
import com.scudata.dm.cursor.BFileCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.op.Derive;
import com.scudata.dm.op.DiffJoin;
import com.scudata.dm.op.FilterJoin;
import com.scudata.dm.op.Join;
import com.scudata.dm.op.New;
import com.scudata.dm.op.Operation;
import com.scudata.expression.Expression;
import com.scudata.resources.EngineMessage;
import com.scudata.util.CursorUtil;
import com.scudata.util.Variant;
import java.util.ArrayList;

public class CSJoinxCursor
extends ICursor {
    public static final String SEQ_FIELDNAME = "rq_csjoinx_seq_";
    private boolean _$30;
    private boolean _$29;
    private boolean _$28;
    private boolean _$27 = false;
    private boolean _$26 = false;
    private int _$25;
    private int _$24;
    private ICursor _$23;
    private SyncReader[] _$22;
    private Expression[][] _$21;
    private Expression[][] _$20;
    private Expression[][] _$19;
    private String[][] _$18;
    private String _$17;
    private String _$16;
    private int _$15;
    private transient ICursor _$14;
    private transient int _$13 = 0;
    private transient int _$12;
    private transient ICursor _$11;
    private transient ICursor[] _$10;
    private transient Sequence[] _$9;
    private transient ICursor _$8;
    private SyncReader _$7;
    private transient Expression[][] _$6;
    private transient Expression[][] _$5;
    private transient Expression[][] _$4;
    private transient String[][] _$3;

    public CSJoinxCursor(ICursor cursor, SyncReader[] fileOrTable, Expression[][] fields, Expression[][] keys, Expression[][] exps, String[][] names, String fname, Context ctx, String option, int n) {
        this._$23 = cursor;
        this._$22 = fileOrTable;
        this._$21 = fields;
        this._$20 = keys;
        this._$19 = exps;
        this._$18 = names;
        this.ctx = ctx;
        this._$17 = option;
        this._$15 = n;
        this._$16 = fname;
        int len = this._$19.length;
        for (int i = 0; i < len; ++i) {
            String[] arr = this._$18[i];
            int len2 = arr.length;
            for (int j = 0; j < len2; ++j) {
                if (arr[j] != null) continue;
                arr[j] = this._$19[i][j].getFieldName();
            }
        }
        if (option != null) {
            if (option.indexOf(117) != -1) {
                this._$30 = true;
            }
            if (option.indexOf(111) != -1) {
                this._$29 = true;
            }
        }
        this._$9 = new Sequence[1];
    }

    public void resetContext(Context ctx) {
        if (this.ctx != ctx) {
            this._$19 = Operation.dupExpressions(this._$19, ctx);
            super.resetContext(ctx);
        }
    }

    private void _$4() {
        ICursor cs = this._$23;
        int fcount = this._$22.length;
        if (this._$29 && (fcount > 1 || !this._$30)) {
            this._$17 = this._$17.replace("o", "");
            this._$26 = true;
        }
        ArrayList opListBk = this.opList;
        this.opList = null;
        for (int i = 0; i < fcount; ++i) {
            boolean hasData;
            boolean needSeq;
            Sequence values = this._$22[i].getValues();
            boolean bl = this._$30 ? false : (needSeq = i == 0);
            if (needSeq && !this._$27) {
                this._$27 = true;
                Derive newOp = new Derive(new Expression[]{new Expression("0L")}, new String[]{SEQ_FIELDNAME}, null);
                cs.addOperation(newOp, this.ctx);
                Sequence seq = cs.peek(1);
                if (seq == null || seq.length() == 0) {
                    this._$28 = true;
                    return;
                }
                this._$24 = seq.dataStruct().getFieldCount() - 1;
            }
            if (this._$26 && i == 0) {
                if (this._$27) {
                    this._$25 = this._$24;
                } else {
                    Sequence seq = cs.peek(1);
                    if (seq == null || seq.length() == 0) {
                        this._$28 = true;
                        return;
                    }
                    this._$25 = seq.dataStruct().getFieldCount();
                }
            }
            if (!(hasData = this._$1(cs, this._$21[i], values, needSeq))) {
                this._$28 = true;
                return;
            }
            FileObject tempFile = null;
            BFileCursor fCursor = null;
            try {
                if (i == fcount - 1) {
                    this._$13 = 0;
                    this._$12 = this._$10.length;
                    this._$7 = this._$22[i];
                    this._$6 = new Expression[][]{this._$21[i]};
                    this._$5 = new Expression[][]{this._$20[i]};
                    this._$4 = new Expression[][]{this._$19[i]};
                    this._$3 = new String[][]{this._$18[i]};
                    this._$11 = null;
                    if (!this._$30) {
                        this._$1(this._$3[0]);
                        this._$8 = this._$1();
                        if (this._$8 == null) {
                            this._$28 = true;
                            return;
                        }
                        this._$28 = false;
                    } else if (this._$26) {
                        this._$8 = this._$2();
                    }
                    this.opList = opListBk;
                    return;
                }
                tempFile = FileObject.createTempFileObject();
                cs = new BFileCursor(tempFile, null, "x", this.ctx);
                tempFile.setFileSize(0L);
                Sequence[] seqs = new Sequence[1];
                Expression[][] fields = new Expression[][]{this._$21[i]};
                Expression[][] keys = new Expression[][]{this._$20[i]};
                Expression[][] newExps = new Expression[][]{this._$19[i]};
                String[][] newNames = new String[][]{this._$18[i]};
                boolean hasNewExps = false;
                if (newExps[0] != null && newExps[0].length > 0) {
                    hasNewExps = true;
                }
                boolean isIsect = false;
                boolean isDiff = false;
                if (!hasNewExps && this._$17 != null) {
                    if (this._$17.indexOf(105) != -1) {
                        isIsect = true;
                    } else if (this._$17.indexOf(100) != -1) {
                        isDiff = true;
                    }
                }
                int filesCount = this._$10.length;
                for (int j = 0; j < filesCount; ++j) {
                    ICursor c = this._$10[j];
                    if (c == null) {
                        this._$22[i].getData(j);
                        continue;
                    }
                    seqs[0] = this._$22[i].getData(j);
                    fCursor = (BFileCursor)c;
                    Operation op = isIsect ? new FilterJoin(null, fields, seqs, keys, this._$17) : (isDiff ? new DiffJoin(null, fields, seqs, keys, this._$17) : new Join(null, fields, seqs, keys, newExps, newNames, this._$17));
                    fCursor.addOperation(op, this.ctx);
                    Sequence table = fCursor.fetch(FETCHCOUNT);
                    while (table != null && table.length() != 0) {
                        tempFile.exportSeries(table, "ab", null);
                        table = fCursor.fetch(FETCHCOUNT);
                    }
                }
            }
            catch (Exception e) {
                if (fCursor != null) {
                    fCursor.close();
                }
                if (tempFile != null && tempFile.isExists()) {
                    tempFile.delete();
                }
                if (e instanceof RQException) {
                    throw (RQException)e;
                }
                throw new RQException(e.getMessage(), e);
            }
            if (tempFile.size() != 0L) continue;
            tempFile.delete();
            this._$28 = true;
            return;
        }
    }

    private boolean _$3() {
        boolean hasNewExps = false;
        if (this._$4[0] != null && this._$4[0].length > 0) {
            hasNewExps = true;
        }
        boolean isIsect = false;
        boolean isDiff = false;
        if (!hasNewExps && this._$17 != null) {
            if (this._$17.indexOf(105) != -1) {
                isIsect = true;
            } else if (this._$17.indexOf(100) != -1) {
                isDiff = true;
            }
        }
        while (this._$13 < this._$12) {
            if (this._$10[this._$13] == null) {
                this._$7.getData(this._$13);
                ++this._$13;
                continue;
            }
            this._$9[0] = null;
            this._$9[0] = this._$7.getData(this._$13);
            this._$11 = this._$10[this._$13];
            Operation op = isIsect ? new FilterJoin(null, this._$6, this._$9, this._$5, this._$17) : (isDiff ? new DiffJoin(null, this._$6, this._$9, this._$5, this._$17) : new Join(this._$16, this._$6, this._$9, this._$5, this._$4, this._$3, this._$17));
            this._$11.addOperation(op, this.ctx);
            ++this._$13;
            return true;
        }
        this._$28 = true;
        return false;
    }

    protected Sequence get(int n) {
        if (this._$10 == null && this._$8 == null) {
            this._$4();
        }
        if (this._$28 || n < 1) {
            return null;
        }
        if (this._$8 != null) {
            if (this._$26) {
                Sequence data = this._$8.fetch(n);
                if (data == null || data.length() == 0) {
                    return null;
                }
                DataStruct ds = data.dataStruct();
                String[] field = ds.getFieldNames();
                String[] newField = new String[field.length + 1 - this._$25];
                String[] subField = new String[this._$25];
                newField[0] = this._$16;
                System.arraycopy(field, this._$25, newField, 1, newField.length - 1);
                System.arraycopy(field, 0, subField, 0, this._$25);
                DataStruct newDs = new DataStruct(newField);
                DataStruct subDs = new DataStruct(subField);
                int newFieldLen = newField.length;
                int subFieldLen = this._$25;
                int len = data.length();
                Sequence result = new Sequence(len);
                for (int i = 1; i <= len; ++i) {
                    int j;
                    Record rec = (Record)data.get(i);
                    Record newRec = new Record(newDs);
                    Record subRec = new Record(subDs);
                    for (j = 0; j < subFieldLen; ++j) {
                        subRec.setNormalFieldValue(j, rec.getNormalFieldValue(j));
                    }
                    for (j = 0; j < newFieldLen - 1; ++j) {
                        newRec.setNormalFieldValue(j + 1, rec.getNormalFieldValue(j + subFieldLen));
                    }
                    newRec.setNormalFieldValue(0, subRec);
                    result.add(newRec);
                }
                return result;
            }
            return this._$8.fetch(n);
        }
        Sequence newTable = null;
        if (this._$11 == null && !this._$3()) {
            return null;
        }
        Sequence data = null;
        int count = 0;
        try {
            while (count < n) {
                data = this._$11.fetch(n - count);
                if (data == null || data.length() == 0) {
                    this._$11.close();
                    if (this._$3()) continue;
                    return newTable;
                }
                if (newTable == null) {
                    newTable = data;
                } else {
                    newTable.addAll(data);
                }
                count += data.length();
            }
        }
        catch (Exception e) {
            this.close();
            if (e instanceof RQException) {
                throw (RQException)e;
            }
            throw new RQException(e.getMessage(), e);
        }
        if (newTable.length() > 0) {
            return newTable;
        }
        return null;
    }

    protected long skipOver(long n) {
        if (this._$8 != null) {
            return this._$8.skip(n);
        }
        if (this._$28 || n < 1L) {
            return 0L;
        }
        if (this._$11 == null && !this._$3()) {
            return 0L;
        }
        long count = 0L;
        while (count < n) {
            long c = this._$11.skip(n - count);
            if (c == 0L) {
                if (this._$3()) continue;
                return count;
            }
            count += c;
        }
        return count;
    }

    public synchronized void close() {
        super.close();
        if (this._$11 != null) {
            this._$11.close();
            this._$11 = null;
        }
        this._$10 = null;
        if (this._$8 != null) {
            this._$8.close();
            this._$8 = null;
        }
        if (this._$14 != null) {
            this._$14.close();
        }
        this._$23.close();
        this._$28 = true;
    }

    public boolean reset() {
        super.close();
        if (this._$11 != null) {
            this._$11.close();
        }
        if (this._$14 != null) {
            this._$14.close();
        }
        if (this._$8 != null) {
            this._$8.close();
            this._$8 = null;
        }
        this._$23.reset();
        this._$28 = false;
        this._$4();
        return true;
    }

    private boolean _$1(ICursor cursor, Expression[] fields, Sequence values, boolean needSeq) {
        int fetchCount = this._$15;
        Sequence table = cursor.fetch(fetchCount);
        if (table == null || table.length() == 0) {
            return false;
        }
        DataStruct ds = table.dataStruct();
        this.setDataStruct(ds);
        int seqIndex = this._$24;
        int fcount = fields.length;
        int[] findex = new int[fcount];
        for (int f = 0; f < fcount; ++f) {
            findex[f] = ds.getFieldIndex(fields[f].toString());
            if (findex[f] != -1) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(fields[f] + mm.getMessage("ds.fieldNotExist"));
        }
        Object[] curVals = new Object[fcount];
        int segCount = values.length();
        Sequence[] outSeqs = new Sequence[segCount + 1];
        FileObject[] files = new FileObject[segCount + 1];
        this._$10 = new BFileCursor[segCount + 1];
        for (int i = 0; i <= segCount; ++i) {
            files[i] = FileObject.createTempFileObject();
            files[i].setFileSize(0L);
            this._$10[i] = new BFileCursor(files[i], null, "x", this.ctx);
            outSeqs[i] = new Sequence();
        }
        long seq = 0L;
        try {
            while (table != null && table.length() > 0) {
                int i;
                int len = table.length();
                for (i = 1; i <= len; ++i) {
                    BaseRecord record = (BaseRecord)table.getMem(i);
                    for (int f = 0; f < fcount; ++f) {
                        curVals[f] = record.getNormalFieldValue(findex[f]);
                    }
                    if (needSeq) {
                        record.setNormalFieldValue(seqIndex, ++seq);
                    }
                    int low = 1;
                    int high = segCount;
                    int middle = 0;
                    if (segCount != 0) {
                        Object[] vals;
                        while (low <= high) {
                            middle = (low + high) / 2;
                            vals = (Object[])values.getMem(middle);
                            int cmp = Variant.compareArrays(vals, curVals);
                            if (cmp > 0) {
                                high = middle - 1;
                                continue;
                            }
                            if (cmp >= 0) break;
                            low = middle + 1;
                        }
                        if (Variant.compareArrays(vals = (Object[])values.getMem(middle), curVals) > 0) {
                            --middle;
                        }
                    } else {
                        middle = 0;
                    }
                    outSeqs[middle].add(record);
                    record = null;
                }
                for (i = 0; i <= segCount; ++i) {
                    files[i].exportSeries(outSeqs[i], "ab", null);
                    outSeqs[i].clear();
                }
                table = null;
                table = cursor.fetch(fetchCount);
            }
        }
        catch (Exception e) {
            if (e instanceof RQException) {
                throw (RQException)e;
            }
            throw new RQException(e.getMessage(), e);
        }
        for (int i = 0; i <= segCount; ++i) {
            FileObject f = files[i];
            if (f.size() != 0L) continue;
            this._$10[i].close();
            files[i] = null;
            this._$10[i] = null;
        }
        return true;
    }

    private ICursor _$2() {
        CSJoinxCursor cursor = this;
        Sequence table = cursor.fetch(ICursor.FETCHCOUNT);
        if (table == null || table.length() == 0) {
            return null;
        }
        FileObject file = FileObject.createTempFileObject();
        try {
            while (table != null && table.length() > 0) {
                file.exportSeries(table, "ab", null);
                table = cursor.fetch(ICursor.FETCHCOUNT);
            }
        }
        catch (Exception e) {
            if (e instanceof RQException) {
                throw (RQException)e;
            }
            throw new RQException(e.getMessage(), e);
        }
        return new BFileCursor(file, null, "x", this.ctx);
    }

    private void _$1(String[] newNames) {
        String[] oldNames = this.dataStruct.getFieldNames();
        int oldColCount = oldNames.length;
        int newColCount = oldColCount + newNames.length;
        String[] totalNames = new String[newColCount];
        System.arraycopy(oldNames, 0, totalNames, 0, oldColCount);
        System.arraycopy(newNames, 0, totalNames, oldColCount, newNames.length);
        this.setDataStruct(this.dataStruct.create(totalNames));
    }

    private ICursor _$1() {
        int seqIndex = this._$24;
        DataStruct ds = this.getDataStruct();
        Expression[] exps = new Expression[]{new Expression(SEQ_FIELDNAME)};
        ICursor cs = CursorUtil.sortx((ICursor)this, exps, this.ctx, this._$15, null);
        String[] oldFields = ds.getFieldNames();
        int oldLen = oldFields.length;
        int newLen = oldLen - 1;
        String[] newFields = new String[newLen];
        Expression[] expressions = new Expression[newLen];
        int c = 0;
        for (int i = 0; i < oldLen; ++i) {
            if (i == seqIndex) continue;
            expressions[c] = new Expression(this.ctx, "#" + (i + 1));
            newFields[c] = oldFields[i];
            ++c;
        }
        New newOp = new New(expressions, newFields, null);
        if (cs != null) {
            cs.addOperation(newOp, this.ctx);
        }
        return cs;
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

