/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.cursor;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.BlockInputStream;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.FileObject;
import com.scudata.dm.KeyWord;
import com.scudata.dm.LineImporter;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class FileCursor
extends ICursor {
    private FileObject _$23;
    private LineImporter _$22;
    private DataStruct _$21;
    private long _$20;
    private long _$19 = -1L;
    private String[] _$18;
    private byte[] _$17;
    private String[] _$16;
    private int[] _$15;
    private int[] _$14;
    private DataStruct _$13;
    private String _$12;
    private byte[] _$11;
    private boolean _$10;
    private boolean _$9;
    private boolean _$8;
    private boolean _$7;
    private int _$6;
    private boolean _$5 = true;
    private boolean _$4 = false;
    private boolean _$3 = true;

    public FileCursor(FileObject fileObject, int segSeq, int segCount, String s, String opt, Context ctx) {
        this(fileObject, segSeq, segCount, null, null, s, opt, ctx);
    }

    public FileCursor(FileObject fileObject, int segSeq, int segCount, String[] fields, byte[] types, String s, String opt, Context ctx) {
        if (segCount > 1) {
            if (segSeq < 1 || segSeq > segCount) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(segSeq + mm.getMessage("function.invalidParam"));
            }
            long size = fileObject.size();
            long blockSize = size / (long)segCount;
            if (segSeq == segCount) {
                this._$19 = size;
                this._$20 = blockSize * (long)(segSeq - 1);
            } else {
                this._$19 = blockSize * (long)segSeq;
                this._$20 = blockSize * (long)(segSeq - 1);
            }
        }
        this._$23 = fileObject;
        this._$17 = types;
        this._$12 = opt;
        this.ctx = ctx;
        if (fields != null) {
            this._$18 = new String[fields.length];
            System.arraycopy(fields, 0, this._$18, 0, fields.length);
        }
        boolean isCsv = false;
        if (opt != null) {
            if (opt.indexOf(116) != -1) {
                this._$10 = true;
            }
            if (opt.indexOf(99) != -1) {
                isCsv = true;
            }
            if (opt.indexOf(105) != -1) {
                this._$8 = true;
            }
            if (opt.indexOf(101) != -1) {
                this._$5 = false;
            }
            if (opt.indexOf(120) != -1) {
                this._$9 = true;
                if (ctx != null) {
                    ctx.addResource(this);
                }
            }
            if (opt.indexOf(119) != -1) {
                this._$7 = true;
            }
        }
        if (s != null && s.length() > 0) {
            String charset = fileObject.getCharset();
            try {
                this._$11 = s.getBytes(charset);
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        } else {
            this._$11 = isCsv ? new byte[]{44} : FileObject.COL_SEPARATOR;
        }
    }

    public void setStart(long start) {
        this._$20 = start;
    }

    public void setEnd(long end) {
        this._$19 = end;
    }

    public void setFormats(String[] fmts) {
        this._$16 = fmts;
    }

    public int[] getFieldLens() {
        return this._$15;
    }

    public void setFieldLens(int[] fieldLens) {
        this._$15 = fieldLens;
    }

    public FileObject getFileObject() {
        return this._$23;
    }

    public String getOption() {
        return this._$12;
    }

    private LineImporter _$1() {
        if (this._$22 != null) {
            return this._$22;
        }
        if (this._$23 == null || this._$4) {
            return null;
        }
        if (!this._$9 && this.ctx != null) {
            this.ctx.addResource(this);
        }
        BlockInputStream in = null;
        String[] selFields = null;
        if (this._$18 != null) {
            selFields = new String[this._$18.length];
            System.arraycopy(this._$18, 0, selFields, 0, selFields.length);
        }
        try {
            in = this._$23.getBlockInputStream();
            String charset = this._$23.getCharset();
            this._$22 = new LineImporter(in, charset, this._$11, this._$12);
            if (this._$15 != null) {
                if (this._$5) {
                    int fcount = selFields.length;
                    this._$14 = new int[fcount];
                    ArrayList<String> fieldList = new ArrayList<String>(fcount);
                    for (int f = 0; f < fcount; ++f) {
                        if (this._$15[f] < 1) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(selFields[f] + mm.getMessage("ds.fieldNotExist"));
                        }
                        if (selFields[f] != null && selFields[f].length() > 0) {
                            this._$14[f] = fieldList.size();
                            fieldList.add(selFields[f]);
                            continue;
                        }
                        this._$14[f] = -1;
                    }
                    this._$21 = new DataStruct(selFields);
                    if (fieldList.size() == fcount) {
                        this._$13 = this._$21;
                    } else {
                        String[] fieldNames = new String[fieldList.size()];
                        fieldList.toArray(fieldNames);
                        this._$13 = new DataStruct(fieldNames);
                        this._$22.setColSelectIndex(this._$14);
                    }
                    this._$22.setColLens(this._$15);
                    this._$22.setColTypes(this._$17, this._$16);
                } else {
                    int totalFieldCount = selFields.length;
                    int fileFieldCount = 0;
                    int resultFieldCount = 0;
                    for (int f = 0; f < totalFieldCount; ++f) {
                        if (selFields[f] != null && selFields[f].length() > 0) {
                            ++resultFieldCount;
                            if (this._$15[f] <= 0) continue;
                            ++fileFieldCount;
                            continue;
                        }
                        ++fileFieldCount;
                        if (this._$15[f] >= 1) continue;
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                    }
                    this._$14 = new int[fileFieldCount];
                    int[] lens = new int[fileFieldCount];
                    byte[] fileFieldTypes = new byte[fileFieldCount];
                    String[] fileFieldFormats = new String[fileFieldCount];
                    String[] fileFields = new String[fileFieldCount];
                    String[] resultFields = new String[resultFieldCount];
                    fileFieldCount = 0;
                    resultFieldCount = 0;
                    for (int f = 0; f < totalFieldCount; ++f) {
                        if (selFields[f] != null && selFields[f].length() > 0) {
                            resultFields[resultFieldCount] = selFields[f];
                            if (this._$15[f] > 0) {
                                this._$14[fileFieldCount] = resultFieldCount;
                                lens[fileFieldCount] = this._$15[f];
                                fileFields[fileFieldCount] = selFields[f];
                                fileFieldTypes[fileFieldCount] = this._$17[f];
                                fileFieldFormats[fileFieldCount] = this._$16[f];
                                ++fileFieldCount;
                            }
                            ++resultFieldCount;
                            continue;
                        }
                        this._$14[fileFieldCount] = -1;
                        lens[fileFieldCount] = this._$15[f];
                        ++fileFieldCount;
                    }
                    this._$21 = new DataStruct(fileFields);
                    this._$13 = new DataStruct(resultFields);
                    this._$22.setColLens(lens);
                    this._$22.setColTypes(fileFieldTypes, fileFieldFormats);
                    this._$22.setColSelectIndex(this._$14);
                }
            } else if (this._$10) {
                Object[] line = this._$22.readFirstLine();
                if (line == null) {
                    return null;
                }
                if (line.length == 0 && ((line = this._$22.readFirstLine()) == null || line.length == 0)) {
                    return null;
                }
                int fcount = line.length;
                String[] fieldNames = new String[fcount];
                for (int f = 0; f < fcount; ++f) {
                    fieldNames[f] = Variant.toString(line[f]);
                }
                this._$21 = new DataStruct(fieldNames);
                if (selFields != null) {
                    int i;
                    if (this._$8) {
                        this._$8 = selFields.length == 1;
                    }
                    int maxSeq = 0;
                    int[] index = new int[fcount];
                    for (i = 0; i < fcount; ++i) {
                        index[i] = -1;
                    }
                    int count = selFields.length;
                    for (i = 0; i < count; ++i) {
                        int q = this._$21.getFieldIndex(selFields[i]);
                        if (q >= 0) {
                            if (index[q] != -1) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException(selFields[i] + mm.getMessage("ds.colNameRepeat"));
                            }
                            index[q] = i;
                            selFields[i] = this._$21.getFieldName(q);
                            this._$6 = q;
                            if (q <= maxSeq) continue;
                            maxSeq = q;
                            continue;
                        }
                        if (!this._$5) continue;
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(selFields[i] + mm.getMessage("ds.fieldNotExist"));
                    }
                    this._$13 = new DataStruct(selFields);
                    this.setDataStruct(this._$13);
                    if (++maxSeq < fcount) {
                        int[] tmp = new int[maxSeq];
                        System.arraycopy(index, 0, tmp, 0, maxSeq);
                        index = tmp;
                    }
                    this._$14 = index;
                    this._$22.setColSelectIndex(index);
                    if (this._$3) {
                        int i2;
                        byte[] colTypes = new byte[maxSeq];
                        String[] colFormats = new String[maxSeq];
                        if (this._$17 != null) {
                            for (i2 = 0; i2 < maxSeq; ++i2) {
                                if (index[i2] == -1) continue;
                                colTypes[i2] = this._$17[index[i2]];
                            }
                        }
                        if (this._$16 != null) {
                            for (i2 = 0; i2 < maxSeq; ++i2) {
                                if (index[i2] == -1) continue;
                                colFormats[i2] = this._$16[index[i2]];
                            }
                        }
                        this._$22.setColTypes(colTypes, colFormats);
                    }
                } else {
                    this.setDataStruct(this._$21);
                    if (this._$8 && fcount != 1) {
                        this._$8 = false;
                    }
                    if (this._$3) {
                        byte[] colTypes = new byte[fcount];
                        this._$22.setColTypes(colTypes, this._$16);
                    }
                }
            } else if (selFields != null) {
                if (this._$8) {
                    this._$8 = selFields.length == 1;
                }
                int fcount = 0;
                int count = selFields.length;
                for (int i = 0; i < count; ++i) {
                    if (KeyWord.isFieldId(selFields[i])) {
                        int f = KeyWord.getFiledId(selFields[i]);
                        if (f <= fcount) continue;
                        fcount = f;
                        continue;
                    }
                    if (!this._$5) continue;
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(selFields[i] + mm.getMessage("ds.fieldNotExist"));
                }
                int[] index = new int[fcount];
                for (int i = 0; i < fcount; ++i) {
                    index[i] = -1;
                }
                String[] fieldNames = new String[fcount];
                this._$21 = new DataStruct(fieldNames);
                int count2 = selFields.length;
                for (int i = 0; i < count2; ++i) {
                    int q = this._$21.getFieldIndex(selFields[i]);
                    if (q < 0) continue;
                    if (index[q] != -1) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(selFields[i] + mm.getMessage("ds.colNameRepeat"));
                    }
                    index[q] = i;
                    selFields[i] = this._$21.getFieldName(q);
                    this._$6 = q;
                }
                this._$13 = new DataStruct(selFields);
                this._$14 = index;
                this._$22.setColSelectIndex(index);
                if (this._$3) {
                    int i;
                    byte[] colTypes = new byte[fcount];
                    String[] colFormats = new String[fcount];
                    if (this._$17 != null) {
                        for (i = 0; i < fcount; ++i) {
                            if (index[i] == -1) continue;
                            colTypes[i] = this._$17[index[i]];
                        }
                    }
                    if (this._$16 != null) {
                        for (i = 0; i < fcount; ++i) {
                            if (index[i] == -1) continue;
                            colFormats[i] = this._$16[index[i]];
                        }
                    }
                    this._$22.setColTypes(colTypes, colFormats);
                }
            }
            this._$22.seek(this._$20);
            if (this._$19 != -1L && this._$22.getCurrentPosition() > this._$19) {
                return null;
            }
            return this._$22;
        }
        catch (Exception e) {
            if (in != null && this._$22 == null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ie) {
                    // empty catch block
                }
            }
            this.close();
            if (e instanceof RQException) {
                throw (RQException)e;
            }
            throw new RQException(e.getMessage(), e);
        }
    }

    private Sequence _$2(LineImporter importer, int n) throws IOException {
        int fcount;
        Object[] line;
        int initSize;
        long end = this._$19;
        int n2 = initSize = n > INITSIZE ? INITSIZE : n;
        if (this._$7) {
            Object[] line2;
            Sequence seq = new Sequence(initSize);
            for (int i = 0; i < n && (end == -1L || importer.getCurrentPosition() <= end) && (line2 = importer.readLine()) != null; ++i) {
                seq.add(new Sequence(line2));
            }
            if (seq.length() != 0) {
                return seq;
            }
            return null;
        }
        if (end > 0L && importer.getCurrentPosition() > end) {
            return null;
        }
        if (this._$21 == null) {
            line = importer.readFirstLine();
            if (line == null) {
                return null;
            }
            fcount = line.length;
            String[] fieldNames = new String[fcount];
            this._$21 = new DataStruct(fieldNames);
            if (this._$8 && fcount != 1) {
                this._$8 = false;
            }
            if (this._$3) {
                byte[] colTypes = new byte[fcount];
                for (int i = 0; i < fcount; ++i) {
                    colTypes[i] = Variant.getObjectType(line[i]);
                }
                importer.setColTypes(colTypes, this._$16);
            }
        } else {
            fcount = this._$21.getFieldCount();
            line = importer.readLine();
            if (line == null) {
                return null;
            }
        }
        if (this._$8) {
            Sequence seq = new Sequence(initSize);
            seq.add(line[0]);
            for (int i = 1; i < n && (end == -1L || importer.getCurrentPosition() <= end) && (line = importer.readLine()) != null; ++i) {
                seq.add(line[0]);
            }
            return seq;
        }
        Table table = new Table(this._$21, initSize);
        BaseRecord r = table.newLast();
        int curLen = line.length;
        if (curLen > fcount) {
            curLen = fcount;
        }
        for (int f = 0; f < curLen; ++f) {
            r.setNormalFieldValue(f, line[f]);
        }
        for (int i = 1; i < n && (end == -1L || importer.getCurrentPosition() <= end) && (line = importer.readLine()) != null; ++i) {
            r = table.newLast();
            curLen = line.length;
            if (curLen > fcount) {
                curLen = fcount;
            }
            for (int f = 0; f < curLen; ++f) {
                r.setNormalFieldValue(f, line[f]);
            }
        }
        return table;
    }

    private Sequence _$1(LineImporter importer, int n) throws IOException {
        Object[] line;
        long end = this._$19;
        int initSize = n > INITSIZE ? INITSIZE : n;
        int[] selIndex = this._$14;
        if (this._$8) {
            Object[] line2;
            int index = this._$6;
            Sequence seq = new Sequence(initSize);
            for (int i = 0; i < n && (end == -1L || importer.getCurrentPosition() <= end) && (line2 = importer.readLine()) != null; ++i) {
                if (index < line2.length) {
                    seq.add(line2[index]);
                    continue;
                }
                seq.add(null);
            }
            if (seq.length() != 0) {
                return seq;
            }
            return null;
        }
        Table table = new Table(this._$13, initSize);
        for (int i = 0; i < n && (end == -1L || importer.getCurrentPosition() <= end) && (line = importer.readLine()) != null; ++i) {
            BaseRecord r = table.newLast();
            int curLen = line.length;
            for (int f = 0; f < curLen; ++f) {
                if (selIndex[f] == -1) continue;
                r.setNormalFieldValue(selIndex[f], line[f]);
            }
        }
        if (table.length() != 0) {
            return table;
        }
        return null;
    }

    protected Sequence get(int n) {
        if (n < 1) {
            return null;
        }
        LineImporter importer = this._$1();
        if (importer == null) {
            return null;
        }
        try {
            if (this._$18 == null || this._$21 == this._$13) {
                return this._$2(importer, n);
            }
            return this._$1(importer, n);
        }
        catch (IOException e) {
            this.close();
            throw new RQException(e.getMessage(), e);
        }
    }

    protected long skipOver(long n) {
        if (n < 1L) {
            return 0L;
        }
        LineImporter importer = this._$1();
        if (importer == null) {
            return 0L;
        }
        try {
            long end = this._$19;
            for (long i = 0L; i < n && (end == -1L || importer.getCurrentPosition() <= end); ++i) {
                if (importer.skipLine()) continue;
                return i;
            }
        }
        catch (IOException e) {
            this.close();
            throw new RQException(e.getMessage(), e);
        }
        return n;
    }

    public synchronized void close() {
        super.close();
        if (this._$23 != null) {
            this._$4 = true;
            if (this._$22 != null) {
                if (this.ctx != null) {
                    this.ctx.removeResource(this);
                }
                try {
                    this._$22.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this._$9) {
                this._$23.delete();
                this._$23 = null;
            }
            this._$22 = null;
            this._$21 = null;
            this._$13 = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public boolean reset() {
        this.close();
        if (this._$23 != null) {
            this._$4 = false;
            return true;
        }
        return false;
    }

    public void setOptimize(boolean optimize) {
        this._$3 = optimize;
    }

    public LineImporter getImporter() {
        return this._$22;
    }
}

