/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.cursor;

import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.FileObject;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.BFileCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dm.op.IGroupsResult;
import com.scudata.expression.Expression;
import com.scudata.expression.Node;

public class GroupxnCursor
extends ICursor {
    private FileObject[] _$9;
    private int _$8 = -1;
    private Expression[] _$7;
    private String[] _$6;
    private Expression[] _$5;
    private String[] _$4;
    private MemoryCursor _$3;

    public GroupxnCursor(FileObject[] files, Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, Context ctx) {
        this._$9 = files;
        this._$6 = names;
        this._$4 = calcNames;
        this.ctx = ctx;
        int keyCount = exps.length;
        int valCount = calcExps == null ? 0 : calcExps.length;
        String[] colNames = new String[keyCount + valCount];
        System.arraycopy(names, 0, colNames, 0, keyCount);
        if (this._$4 != null) {
            System.arraycopy(this._$4, 0, colNames, keyCount, valCount);
        }
        DataStruct ds = new DataStruct(colNames);
        ds.setPrimary(names);
        this.setDataStruct(ds);
        Node[] gathers = Sequence.prepareGatherMethods(calcExps, ctx);
        Expression[] keyExps = new Expression[keyCount];
        int i = 0;
        int q = 1;
        while (i < keyCount) {
            keyExps[i] = new Expression(ctx, "#" + q);
            ++i;
            ++q;
        }
        Expression[] valExps = new Expression[valCount];
        int i2 = 0;
        int q2 = keyCount + 1;
        while (i2 < valCount) {
            valExps[i2] = gathers[i2].getRegatherExpression(q2);
            ++i2;
            ++q2;
        }
        this._$7 = keyExps;
        this._$5 = valExps;
    }

    public void resetContext(Context ctx) {
        this.ctx = ctx;
    }

    protected Sequence get(int n) {
        Sequence table;
        if (this._$9 == null || n < 1) {
            return null;
        }
        if (this._$8 == -1) {
            ++this._$8;
            BFileCursor cs = new BFileCursor(this._$9[0], null, "x", this.ctx);
            DataStruct ds = cs.getDataStruct();
            IGroupsResult groups = IGroupsResult.instance(this._$7, this._$6, this._$5, this._$4, ds, "", this.ctx);
            groups.push(cs);
            Table seq = groups.getResultTable();
            this._$3 = new MemoryCursor(seq);
        }
        if ((table = this._$3.fetch(n)) == null || table.length() < n) {
            ++this._$8;
            if (this._$8 < this._$9.length) {
                BFileCursor cs = new BFileCursor(this._$9[this._$8], null, "x", this.ctx);
                DataStruct ds = cs.getDataStruct();
                IGroupsResult groups = IGroupsResult.instance(this._$7, this._$6, this._$5, this._$4, ds, "", this.ctx);
                groups.push(cs);
                Table seq = groups.getResultTable();
                this._$3 = new MemoryCursor(seq);
                if (table == null) {
                    return this.get(n);
                }
                Sequence rest = n == 0x7FFFFFFE ? this.get(n) : this.get(n - table.length());
                table = GroupxnCursor.append(table, rest);
            } else {
                this._$9 = null;
                this._$3 = null;
            }
        }
        return table;
    }

    protected long skipOver(long n) {
        long count;
        if (this._$9 == null || n < 1L) {
            return 0L;
        }
        if (this._$8 == -1) {
            ++this._$8;
            BFileCursor cs = new BFileCursor(this._$9[0], null, "x", this.ctx);
            DataStruct ds = cs.getDataStruct();
            IGroupsResult groups = IGroupsResult.instance(this._$7, this._$6, this._$5, this._$4, ds, "", this.ctx);
            groups.push(cs);
            Table seq = groups.getResultTable();
            this._$3 = new MemoryCursor(seq);
        }
        if ((count = this._$3.skip(n)) < n) {
            ++this._$8;
            if (this._$8 < this._$9.length) {
                BFileCursor cs = new BFileCursor(this._$9[this._$8], null, "x", this.ctx);
                DataStruct ds = cs.getDataStruct();
                IGroupsResult groups = IGroupsResult.instance(this._$7, this._$6, this._$5, this._$4, ds, "", this.ctx);
                groups.push(cs);
                Table seq = groups.getResultTable();
                this._$3 = new MemoryCursor(seq);
                count += this.skipOver(n - count);
            }
        }
        return count;
    }

    public synchronized void close() {
        super.close();
        if (this._$9 != null) {
            for (FileObject file : this._$9) {
                if (file == null) continue;
                file.delete();
            }
            this._$9 = null;
            this._$3 = null;
        }
    }
}

