/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.cursor;

import com.scudata.array.IArray;
import com.scudata.cellset.INormalCell;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.DataStruct;
import com.scudata.dm.IResource;
import com.scudata.dm.Param;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.MergeJoinxCursor;
import com.scudata.dm.op.Channel;
import com.scudata.dm.op.GroupxResult;
import com.scudata.dm.op.IDResult;
import com.scudata.dm.op.IGroupsResult;
import com.scudata.dm.op.IHugeGroupsResult;
import com.scudata.dm.op.Operable;
import com.scudata.dm.op.Operation;
import com.scudata.dw.ColPhyTable;
import com.scudata.dw.JoinCursor;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;
import com.scudata.util.CursorUtil;
import com.scudata.util.Variant;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ICursor
extends Operable
implements IResource {
    public static final int MAXSIZE = 0x7FFFFFFE;
    public static final long MAXSKIPSIZE = Long.MAX_VALUE;
    public static int INITSIZE = 99999;
    public static int FETCHCOUNT = 9999;
    public static final int FETCHCOUNT_M = 999;
    protected Sequence cache;
    protected ArrayList<Operation> opList;
    protected Context ctx;
    protected DataStruct dataStruct;
    private boolean _$2 = false;
    private boolean _$1 = false;

    public static int getFetchCount() {
        return FETCHCOUNT;
    }

    public static void setFetchCount(int count) {
        FETCHCOUNT = count;
    }

    public static int getInitSize() {
        return INITSIZE;
    }

    public static void setInitSize(int size) {
        INITSIZE = size;
    }

    public void resetContext(Context ctx) {
        if (this.ctx != ctx) {
            this.ctx = ctx;
            this.opList = this._$1(ctx);
        }
    }

    public Context getContext() {
        return this.ctx;
    }

    private ArrayList<Operation> _$1(Context ctx) {
        ArrayList<Operation> opList = this.opList;
        if (opList == null) {
            return null;
        }
        ArrayList<Operation> newList = new ArrayList<Operation>(opList.size());
        for (Operation op : opList) {
            newList.add(op.duplicate(ctx));
        }
        return newList;
    }

    public void setContext(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public Operable addOperation(Operation op, Context ctx) {
        if (this.opList == null) {
            this.opList = new ArrayList();
        }
        this.opList.add(op);
        if (op.isDecrease()) {
            this._$2 = true;
        }
        if (this.ctx == null) {
            this.ctx = ctx;
        }
        if (this.cache != null) {
            this.cache = op.process(this.cache, ctx);
        }
        return this;
    }

    public static Sequence append(Sequence dest, Sequence src) {
        if (src != null) {
            return dest.append(src);
        }
        return dest;
    }

    protected Sequence doOperation(Sequence result, ArrayList<Operation> opList, Context ctx) {
        for (Operation op : opList) {
            if (result == null || result.length() == 0) {
                return null;
            }
            try {
                result = op.process(result, ctx);
            }
            catch (RQException e) {
                INormalCell cell = op.getCurrentCell();
                if (cell != null) {
                    MessageManager mm = EngineMessage.get();
                    e.setMessage(mm.getMessage("error.cell", cell.getCellId()) + e.getMessage());
                }
                throw e;
            }
            catch (RuntimeException e) {
                INormalCell cell = op.getCurrentCell();
                if (cell != null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("error.cell", cell.getCellId()) + e.getMessage(), e);
                }
                throw e;
            }
        }
        return result;
    }

    protected Sequence finish(ArrayList<Operation> opList, Context ctx) {
        this._$1 = true;
        Sequence result = null;
        for (Operation op : opList) {
            if (result == null || result.length() == 0) {
                result = op.finish(ctx);
                continue;
            }
            result = op.process(result, ctx);
            Sequence tmp = op.finish(ctx);
            if (tmp == null) continue;
            if (result != null) {
                result = ICursor.append(result, tmp);
                continue;
            }
            result = tmp;
        }
        return result;
    }

    public synchronized Sequence peek(int n) {
        ArrayList<Operation> opList = this.opList;
        if (opList == null) {
            if (this.cache == null) {
                this.cache = this.get(n);
            } else if (this.cache.length() < n) {
                this.cache = ICursor.append(this.cache, this.get(n - this.cache.length()));
            } else if (this.cache.length() > n) {
                return this.cache.get(1, n + 1);
            }
            return this.cache;
        }
        int size = n > FETCHCOUNT && n < 0x7FFFFFFE ? n : FETCHCOUNT;
        while (this.cache == null || this.cache.length() < n) {
            Sequence cur = this.get(size);
            if (cur == null || cur.length() == 0) {
                Sequence tmp = this.finish(opList, this.ctx);
                if (tmp != null) {
                    this.cache = this.cache == null ? tmp : ICursor.append(this.cache, tmp);
                }
                return this.cache;
            }
            cur = this.doOperation(cur, opList, this.ctx);
            if (this.cache == null) {
                this.cache = cur;
                continue;
            }
            if (cur == null) continue;
            this.cache = ICursor.append(this.cache, cur);
        }
        if (this.cache.length() == n) {
            return this.cache;
        }
        if (this.cache instanceof Table) {
            Table table = new Table(this.cache.dataStruct(), n);
            table.getMems().addAll(this.cache.getMems(), n);
            return table;
        }
        Sequence seq = new Sequence(n);
        seq.getMems().addAll(this.cache.getMems(), n);
        return seq;
    }

    public Sequence fuzzyFetch(int n) {
        if (this.cache == null) {
            Sequence result = null;
            ArrayList<Operation> opList = this.opList;
            do {
                Sequence tmp;
                Sequence cur;
                if ((cur = this.fuzzyGet(n)) != null) {
                    if (opList != null) {
                        cur = this.doOperation(cur, opList, this.ctx);
                        if (result == null) {
                            result = cur;
                            continue;
                        }
                        if (cur == null) continue;
                        result = ICursor.append(result, cur);
                        continue;
                    }
                    if (result == null) {
                        result = cur;
                        continue;
                    }
                    result = ICursor.append(result, cur);
                    continue;
                }
                if (opList != null && (tmp = this.finish(opList, this.ctx)) != null) {
                    result = result == null ? tmp : ICursor.append(result, tmp);
                }
                this.close();
                return result;
            } while (result == null || result.length() < n);
            return result;
        }
        Sequence result = this.cache;
        this.cache = null;
        return result;
    }

    public Sequence fetch() {
        return this.fetch(0x7FFFFFFE);
    }

    public synchronized Sequence fetch(int n) {
        if (n < 1) {
            return null;
        }
        ArrayList<Operation> opList = this.opList;
        Sequence result = this.cache;
        if (opList == null) {
            if (result == null) {
                result = this.get(n);
                if (result == null || result.length() < n) {
                    this.close();
                }
                return result;
            }
            if (result.length() > n) {
                return result.split(1, n);
            }
            if (result.length() == n) {
                this.cache = null;
                return result;
            }
            this.cache = null;
            if ((result = ICursor.append(result, this.get(n - result.length()))) == null || result.length() < n) {
                this.close();
            }
            return result;
        }
        int size = (n > FETCHCOUNT || !this._$2) && n < 0x7FFFFFFE ? n : FETCHCOUNT;
        while (result == null || result.length() < n) {
            Sequence cur = this.get(size);
            if (cur == null) {
                Sequence tmp = this.finish(opList, this.ctx);
                if (tmp != null) {
                    result = result == null ? tmp : ICursor.append(result, tmp);
                }
                this.close();
                return result;
            }
            int len = cur.length();
            cur = this.doOperation(cur, opList, this.ctx);
            if (result == null) {
                result = cur;
            } else if (cur != null) {
                result = ICursor.append(result, cur);
            }
            if (len >= size) continue;
            Sequence tmp = this.finish(opList, this.ctx);
            if (tmp != null) {
                result = result == null ? tmp : ICursor.append(result, tmp);
            }
            if (result != null && result.length() >= n) continue;
            this.close();
            return result;
        }
        if (result.length() == n) {
            this.cache = null;
            return result;
        }
        this.cache = result.split(n + 1);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Sequence fetchGroup(Expression[] exps, int n, Context ctx) {
        int index;
        Sequence newTable;
        Sequence data;
        block16: {
            data = this.fuzzyFetch(FETCHCOUNT);
            if (data == null) {
                return null;
            }
            newTable = null;
            int keyCount = exps.length;
            Object[] keys = new Object[keyCount];
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(data);
            stack.push(current);
            current.setCurrent(1);
            index = 2;
            int count = 0;
            try {
                for (int k = 0; k < keyCount; ++k) {
                    keys[k] = exps[k].calculate(ctx);
                }
                while (true) {
                    int len = data.length();
                    while (index <= len) {
                        current.setCurrent(index);
                        for (int k = 0; k < keyCount; ++k) {
                            if (Variant.isEquals(keys[k], exps[k].calculate(ctx))) continue;
                            if (count + index >= n) {
                                break block16;
                            }
                            for (int j = 0; j < keyCount; ++j) {
                                keys[j] = exps[j].calculate(ctx);
                            }
                        }
                        ++index;
                    }
                    if (newTable == null) {
                        newTable = data;
                    } else {
                        newTable.getMems().addAll(data.getMems());
                    }
                    count = newTable.length();
                    data = this.fuzzyFetch(FETCHCOUNT);
                    if (data == null) {
                        break;
                    }
                    index = 1;
                    stack.pop();
                    current = new Current(data);
                    stack.push(current);
                }
            }
            finally {
                stack.pop();
            }
        }
        if (data != null && data.length() >= index) {
            this.cache = data.split(index);
            if (newTable == null) {
                newTable = data;
            } else {
                newTable.getMems().addAll(data.getMems());
            }
        }
        return newTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Sequence fetchGroup(Expression[] exps, Context ctx) {
        int index;
        Sequence newTable;
        Sequence data;
        block14: {
            data = this.fuzzyFetch(FETCHCOUNT);
            if (data == null) {
                return null;
            }
            newTable = null;
            int keyCount = exps.length;
            Object[] keys = new Object[keyCount];
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(data);
            stack.push(current);
            current.setCurrent(1);
            index = 2;
            try {
                for (int k = 0; k < keyCount; ++k) {
                    keys[k] = exps[k].calculate(ctx);
                }
                while (true) {
                    int len = data.length();
                    while (index <= len) {
                        current.setCurrent(index);
                        for (int k = 0; k < keyCount; ++k) {
                            if (Variant.isEquals(keys[k], exps[k].calculate(ctx))) continue;
                            break block14;
                        }
                        ++index;
                    }
                    if (newTable == null) {
                        newTable = data;
                    } else {
                        newTable.getMems().addAll(data.getMems());
                    }
                    data = this.fuzzyFetch(FETCHCOUNT);
                    if (data == null) {
                        break;
                    }
                    index = 1;
                    stack.pop();
                    current = new Current(data);
                    stack.push(current);
                }
            }
            finally {
                stack.pop();
            }
        }
        if (data != null && data.length() >= index) {
            this.cache = data.split(index);
            if (newTable == null) {
                newTable = data;
            } else {
                newTable.getMems().addAll(data.getMems());
            }
        }
        return newTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Sequence fetchGroup(Expression exp, Context ctx) {
        int index;
        Sequence newTable;
        Sequence data;
        block20: {
            data = this.fuzzyFetch(FETCHCOUNT);
            if (data == null) {
                return null;
            }
            newTable = null;
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(data);
            stack.push(current);
            current.setCurrent(1);
            index = 2;
            try {
                Object key = exp.calculate(ctx);
                if (key instanceof Boolean) {
                    while (true) {
                        int len = data.length();
                        while (index <= len) {
                            current.setCurrent(index);
                            if (Variant.isTrue(exp.calculate(ctx))) {
                                break block20;
                            }
                            ++index;
                        }
                        if (newTable == null) {
                            newTable = data;
                        } else {
                            newTable.getMems().addAll(data.getMems());
                        }
                        data = this.fuzzyFetch(FETCHCOUNT);
                        if (data == null) {
                            break block20;
                        }
                        index = 1;
                        stack.pop();
                        current = new Current(data);
                        stack.push(current);
                    }
                }
                while (true) {
                    int len = data.length();
                    while (index <= len) {
                        current.setCurrent(index);
                        if (!Variant.isEquals(key, exp.calculate(ctx))) {
                            break block20;
                        }
                        ++index;
                    }
                    if (newTable == null) {
                        newTable = data;
                    } else {
                        newTable.getMems().addAll(data.getMems());
                    }
                    data = this.fuzzyFetch(FETCHCOUNT);
                    if (data == null) {
                        break;
                    }
                    index = 1;
                    stack.pop();
                    current = new Current(data);
                    stack.push(current);
                }
            }
            finally {
                stack.pop();
            }
        }
        if (data != null && data.length() >= index) {
            this.cache = data.split(index);
            if (newTable == null) {
                newTable = data;
            } else {
                newTable.getMems().addAll(data.getMems());
            }
        }
        return newTable;
    }

    public Sequence fetchGroup(int field) {
        Sequence data = this.fuzzyFetch(FETCHCOUNT);
        if (data == null) {
            return null;
        }
        IArray mems = data.getMems();
        BaseRecord r = (BaseRecord)mems.get(1);
        Sequence newTable = null;
        Object key = r.getNormalFieldValue(field);
        int index = 2;
        block0: while (true) {
            int len = data.length();
            while (index <= len) {
                r = (BaseRecord)mems.get(index);
                if (!Variant.isEquals(key, r.getNormalFieldValue(field))) break block0;
                ++index;
            }
            if (newTable == null) {
                newTable = data;
            } else {
                newTable.getMems().addAll(mems);
            }
            data = this.fuzzyFetch(FETCHCOUNT);
            if (data == null) break;
            mems = data.getMems();
            index = 1;
        }
        if (data != null && data.length() >= index) {
            this.cache = data.split(index);
            if (newTable == null) {
                newTable = data;
            } else {
                newTable.getMems().addAll(mems);
            }
        }
        return newTable;
    }

    public Sequence fetchGroup(int[] fields) {
        int keyCount = fields.length;
        if (keyCount == 1) {
            return this.fetchGroup(fields[0]);
        }
        Sequence data = this.fuzzyFetch(FETCHCOUNT);
        if (data == null) {
            return null;
        }
        Sequence newTable = null;
        IArray mems = data.getMems();
        BaseRecord r = (BaseRecord)mems.get(1);
        int index = 2;
        Object[] keys = new Object[keyCount];
        for (int i = 0; i < keyCount; ++i) {
            keys[i] = r.getNormalFieldValue(fields[i]);
        }
        block1: while (true) {
            int len = data.length();
            while (index <= len) {
                r = (BaseRecord)mems.get(index);
                for (int i = 0; i < keyCount; ++i) {
                    if (!Variant.isEquals(keys[i], r.getNormalFieldValue(fields[i]))) break block1;
                }
                ++index;
            }
            if (newTable == null) {
                newTable = data;
            } else {
                newTable.getMems().addAll(mems);
            }
            data = this.fuzzyFetch(FETCHCOUNT);
            if (data == null) break;
            mems = data.getMems();
            index = 1;
        }
        if (data != null && data.length() >= index) {
            this.cache = data.split(index);
            if (newTable == null) {
                newTable = data;
            } else {
                newTable.getMems().addAll(mems);
            }
        }
        return newTable;
    }

    public Sequence fetchGroup(int[] fields, int limit) {
        Sequence data = this.fuzzyFetch(FETCHCOUNT);
        if (data == null) {
            return null;
        }
        int keyCount = fields.length;
        Sequence newTable = null;
        IArray mems = data.getMems();
        BaseRecord r = (BaseRecord)mems.get(1);
        int index = 2;
        int count = 0;
        Object[] keys = new Object[keyCount];
        for (int i = 0; i < keyCount; ++i) {
            keys[i] = r.getNormalFieldValue(fields[i]);
        }
        block1: while (true) {
            int len = data.length();
            while (index <= len) {
                r = (BaseRecord)mems.get(index);
                for (int i = 0; i < keyCount; ++i) {
                    if (!Variant.isEquals(keys[i], r.getNormalFieldValue(fields[i]))) break block1;
                }
                if (count + index >= limit + 1) break block1;
                ++index;
            }
            if (newTable == null) {
                newTable = data;
            } else {
                newTable.getMems().addAll(mems);
            }
            count = newTable.length();
            data = this.fuzzyFetch(FETCHCOUNT);
            if (data == null) break;
            mems = data.getMems();
            index = 1;
        }
        if (data != null && data.length() >= index) {
            this.cache = data.split(index);
            if (newTable == null) {
                newTable = data;
            } else {
                newTable.getMems().addAll(mems);
            }
        }
        return newTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int skipGroup(Expression[] exps, Context ctx) {
        int index;
        int count;
        Sequence data;
        block10: {
            data = this.fuzzyFetch(FETCHCOUNT);
            if (data == null) {
                return 0;
            }
            int keyCount = exps.length;
            Object[] keys = new Object[keyCount];
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(data);
            stack.push(current);
            current.setCurrent(1);
            count = 1;
            index = 2;
            try {
                for (int k = 0; k < keyCount; ++k) {
                    keys[k] = exps[k].calculate(ctx);
                }
                while (true) {
                    int len = data.length();
                    while (index <= len) {
                        current.setCurrent(index);
                        for (int k = 0; k < keyCount; ++k) {
                            if (Variant.isEquals(keys[k], exps[k].calculate(ctx))) continue;
                            break block10;
                        }
                        ++index;
                        ++count;
                    }
                    data = this.fuzzyFetch(FETCHCOUNT);
                    if (data == null) {
                        break;
                    }
                    index = 1;
                    stack.pop();
                    current = new Current(data);
                    stack.push(current);
                }
            }
            finally {
                stack.pop();
            }
        }
        if (data != null && data.length() > index) {
            this.cache = data.split(index);
        }
        return count;
    }

    public long skip() {
        return this.skip(Long.MAX_VALUE);
    }

    public synchronized long skip(long n) {
        if (this.opList == null) {
            if (this.cache == null) {
                long count = this.skipOver(n);
                if (count < n) {
                    this.close();
                }
                return count;
            }
            int len = this.cache.length();
            if ((long)len == n) {
                this.cache = null;
                return n;
            }
            if ((long)len > n) {
                this.cache.split(1, (int)n);
                return n;
            }
            this.cache = null;
            long count = (long)len + this.skipOver(n - (long)len);
            if (count < n) {
                this.close();
            }
            return count;
        }
        long total = 0L;
        while (n > 0L) {
            Sequence seq = n > (long)FETCHCOUNT ? this.fetch(FETCHCOUNT) : this.fetch((int)n);
            if (seq == null || seq.length() == 0) {
                this.close();
                break;
            }
            total += (long)seq.length();
            n -= (long)seq.length();
        }
        return total;
    }

    @Override
    public void close() {
        this.cache = null;
        if (this._$1) {
            this._$1 = false;
        } else if (this.opList != null) {
            this.finish(this.opList, this.ctx);
        }
    }

    protected abstract Sequence get(int var1);

    protected Sequence fuzzyGet(int n) {
        return this.get(n);
    }

    protected abstract long skipOver(long var1);

    public boolean reset() {
        return false;
    }

    public DataStruct getDataStruct() {
        return this.dataStruct;
    }

    public void setDataStruct(DataStruct ds) {
        this.dataStruct = ds;
    }

    public String[] getSortFields() {
        return null;
    }

    public IGroupsResult getGroupsResult(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx) {
        DataStruct ds = this.getDataStruct();
        return IGroupsResult.instance(exps, names, calcExps, calcNames, ds, opt, ctx);
    }

    public IHugeGroupsResult getHugeGroupsResult(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, int capacity, Context ctx) {
        throw new RuntimeException();
    }

    public Table groups(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx) {
        IGroupsResult groups = this.getGroupsResult(exps, names, calcExps, calcNames, opt, ctx);
        groups.push(this);
        return groups.getResultTable();
    }

    public Table groups(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx, int groupCount) {
        if (groupCount < 1 || exps == null || exps.length == 0) {
            return this.groups(exps, names, calcExps, calcNames, opt, ctx);
        }
        if (opt != null && opt.indexOf(110) != -1) {
            IGroupsResult groups = this.getGroupsResult(exps, names, calcExps, calcNames, opt, ctx);
            groups.setGroupCount(groupCount);
            groups.push(this);
            return groups.getResultTable();
        }
        return CursorUtil.fuzzyGroups(this, exps, names, calcExps, calcNames, opt, ctx, groupCount);
    }

    public ICursor groupx(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx, int capacity) {
        Sequence src;
        if (opt != null && opt.indexOf(110) != -1) {
            return CursorUtil.groupx_n(this, exps, names, calcExps, calcNames, ctx, capacity);
        }
        GroupxResult groupx = new GroupxResult(exps, names, calcExps, calcNames, opt, ctx, capacity);
        while ((src = this.fetch(INITSIZE)) != null && src.length() != 0) {
            groupx.push(src, ctx);
        }
        return groupx.getResultCursor();
    }

    public Sequence id(Expression[] exps, int count, String opt, Context ctx) {
        IDResult id = new IDResult(exps, count, opt, ctx);
        id.push(this);
        return id.getResultSequence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object iterator(Expression exp, Object initVal, Expression c, Context ctx) {
        ComputeStack stack = ctx.getComputeStack();
        Param param = ctx.getIterateParam();
        Object oldVal = param.getValue();
        param.setValue(initVal);
        try {
            Sequence src;
            block8: while ((src = this.fuzzyFetch(FETCHCOUNT)) != null) {
                if (src.length() == 0) {
                    return initVal;
                }
                Current current = new Current(src);
                stack.push(current);
                try {
                    int size;
                    int i;
                    if (c == null) {
                        i = 1;
                        size = src.length();
                        while (true) {
                            if (i > size) continue block8;
                            current.setCurrent(i);
                            initVal = exp.calculate(ctx);
                            param.setValue(initVal);
                            ++i;
                        }
                    }
                    i = 1;
                    size = src.length();
                    while (true) {
                        if (i > size) continue block8;
                        current.setCurrent(i);
                        Object obj = c.calculate(ctx);
                        if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
                            Object object = initVal;
                            return object;
                        }
                        initVal = exp.calculate(ctx);
                        param.setValue(initVal);
                        ++i;
                    }
                }
                finally {
                    stack.pop();
                }
            }
            return initVal;
        }
        finally {
            param.setValue(oldVal);
        }
    }

    public ICursor sortx(Expression[] exps, Context ctx, int capacity, String opt) {
        return CursorUtil.sortx(this, exps, ctx, capacity, opt);
    }

    public ICursor sortx(Expression[] exps, Expression gexp, Context ctx, String opt) {
        return CursorUtil.sortx(this, exps, gexp, ctx, opt);
    }

    public Object total(Expression[] calcExps, Context ctx) {
        Table table = this.groups(null, null, calcExps, null, null, ctx);
        if (table == null || table.length() == 0) {
            return null;
        }
        BaseRecord r = table.getRecord(1);
        int count = calcExps.length;
        if (count == 1) {
            return r.getNormalFieldValue(0);
        }
        Sequence seq = new Sequence(count);
        for (int i = 0; i < count; ++i) {
            seq.add(r.getNormalFieldValue(i));
        }
        return seq;
    }

    @Override
    public Operable mergeJoinx(Function function, Expression[][] exps, ICursor[] cursors, Expression[][] codeExps, Expression[][] newExps, String[][] newNames, String opt, Context ctx) {
        return new MergeJoinxCursor(this, exps, cursors, codeExps, newExps, newNames, opt, ctx);
    }

    public ICursor attachNews(ColPhyTable table, String[] csNames, Expression filter, Expression[] exps, String[] names, String[] fkNames, Sequence[] codes, String[] opts, String option, int type, Context ctx) {
        return new JoinCursor(table, exps, names, this, csNames, type, option, filter, fkNames, codes, opts, ctx);
    }

    public Object[] getSegmentStartValues(String option) {
        throw new RQException();
    }

    public Channel newChannel(Context ctx, boolean doPush) {
        if (doPush) {
            return new Channel(ctx, this);
        }
        return new Channel(ctx);
    }

    public boolean canSkipBlock() {
        return false;
    }

    public IArray[] getSkipBlockInfo(String key) {
        return null;
    }

    public void setSkipBlockInfo(String key, IArray[] values) {
    }

    public void setSkipBlock(Expression[] srcKeyExps, ICursor[] cursors, String[] options, Expression[][] keyExps, Expression[][] newExps, String option) {
        block6: {
            int tableCount = cursors.length;
            String key = srcKeyExps[0].getFieldName();
            if (option != null && option.indexOf(102) != -1) break block6;
            if ((option == null || option.indexOf(114) == -1) && this.canSkipBlock()) {
                IArray[] values = null;
                boolean isGet = false;
                for (int t = 0; t < tableCount; ++t) {
                    String opt;
                    if (cursors[t] == null || (opt = options[t]) != null && opt.equals("null") && newExps[t] == null) continue;
                    if (!isGet) {
                        isGet = true;
                        values = this.getSkipBlockInfo(key);
                        if (values == null) break;
                    }
                    cursors[t].setSkipBlockInfo(keyExps[t][0].getFieldName(), values);
                }
            } else {
                IArray[] values = null;
                for (int t = 0; t < tableCount; ++t) {
                    String opt;
                    if (cursors[t] == null || !cursors[t].canSkipBlock() || (opt = options[t]) != null && opt.equals("null") || (values = cursors[t].getSkipBlockInfo(keyExps[t][0].getFieldName())) == null) continue;
                    this.setSkipBlockInfo(key, values);
                    break;
                }
            }
        }
    }
}

