/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.cursor;

import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.op.Operation;
import com.scudata.expression.Expression;
import com.scudata.util.Variant;

public class JoinxCursor
extends ICursor {
    private ICursor[] _$15;
    private Expression[][] _$14;
    private DataStruct _$13;
    private int _$12 = 0;
    private boolean _$11 = false;
    private Sequence[] _$10;
    private Object[][] _$9;
    private int[] _$8;
    private int[] _$7;
    private Sequence[] _$6;
    private Object[][] _$5;
    private Context[] _$4;
    private Current[] _$3;

    public JoinxCursor(ICursor[] cursors, Expression[][] exps, String[] names, String opt, Context ctx) {
        this._$15 = cursors;
        this._$14 = exps;
        this.ctx = ctx;
        if (names == null) {
            names = new String[cursors.length];
        }
        this._$13 = new DataStruct(names);
        this.setDataStruct(this._$13);
        if (opt != null) {
            if (opt.indexOf(49) != -1) {
                this._$12 = 1;
            } else if (opt.indexOf(102) != -1) {
                this._$12 = 2;
            }
        }
    }

    public void resetContext(Context ctx) {
        if (this.ctx != ctx) {
            for (ICursor cursor : this._$15) {
                cursor.resetContext(ctx);
            }
            this._$14 = Operation.dupExpressions(this._$14, ctx);
            super.resetContext(ctx);
        }
    }

    protected Sequence get(int n) {
        Table newTable;
        block18: {
            if (this._$11 || n < 1) {
                return null;
            }
            this._$1();
            Sequence[] tables = this._$10;
            int[] seqs = this._$8;
            int[] ranks = this._$7;
            int tcount = tables.length;
            newTable = n > INITSIZE ? new Table(this._$13, INITSIZE) : new Table(this._$13, n);
            Object[] records = new Object[tcount];
            if (this._$12 == 0) {
                block0: while (n != 0) {
                    for (int i = 0; i < tcount; ++i) {
                        if (ranks[i] != 0) {
                            if (ranks[i] != -1) {
                                this._$3();
                                continue block0;
                            }
                            break block18;
                        }
                        records[i] = tables[i].getMem(seqs[i]);
                    }
                    --n;
                    this._$2();
                    newTable.newLast(records);
                }
            } else if (this._$12 == 1) {
                while (n != 0) {
                    if (ranks[0] != 0) {
                        if (ranks[0] != -1) {
                            this._$3();
                            continue;
                        }
                        break;
                    }
                    records[0] = tables[0].getMem(seqs[0]);
                    for (int i = 1; i < tcount; ++i) {
                        records[i] = ranks[i] == 0 ? tables[i].getMem(seqs[i]) : null;
                    }
                    --n;
                    this._$2();
                    newTable.newLast(records);
                }
            } else {
                while (n != 0) {
                    boolean sign = false;
                    for (int i = 0; i < tcount; ++i) {
                        if (ranks[i] == 0) {
                            sign = true;
                            records[i] = tables[i].getMem(seqs[i]);
                            continue;
                        }
                        records[i] = null;
                    }
                    if (sign) {
                        --n;
                        this._$2();
                        newTable.newLast(records);
                        continue;
                    }
                    break;
                }
            }
        }
        if (newTable.length() > 0) {
            return newTable;
        }
        return null;
    }

    private void _$3() {
        Sequence[] tables = this._$10;
        Object[][] values = this._$9;
        int[] seqs = this._$8;
        int[] ranks = this._$7;
        int count = tables.length;
        block0: for (int i = 0; i < count; ++i) {
            Object[] curValues = values[i];
            if (ranks[i] == 0) {
                int next = seqs[i] + 1;
                if (next > tables[i].length()) {
                    tables[i] = this._$15[i].fuzzyFetch(FETCHCOUNT);
                    if (tables[i] != null && tables[i].length() > 0) {
                        ComputeStack stack = this._$4[i].getComputeStack();
                        stack.pop();
                        this._$3[i] = new Current(tables[i], 1);
                        stack.push(this._$3[i]);
                        JoinxCursor._$1(this._$14[i], this._$4[i], curValues);
                        seqs[i] = 1;
                    } else {
                        curValues = null;
                        values[i] = null;
                        ranks[i] = -1;
                    }
                } else {
                    this._$3[i].setCurrent(next);
                    JoinxCursor._$1(this._$14[i], this._$4[i], curValues);
                    seqs[i] = next;
                }
            }
            if (curValues == null) continue;
            ranks[i] = 0;
            for (int j = 0; j < i; ++j) {
                if (ranks[j] != 0) continue;
                int cmp = Variant.compareArrays(curValues, values[j]);
                if (cmp < 0) {
                    ranks[j] = 1;
                    ++j;
                    while (j < i) {
                        if (ranks[j] == 0) {
                            ranks[j] = 1;
                        }
                        ++j;
                    }
                    continue block0;
                }
                if (cmp <= 0) continue block0;
                ranks[i] = 1;
                continue block0;
            }
        }
    }

    private void _$2() {
        int i;
        Sequence[] tables = this._$10;
        Object[][] values = this._$9;
        int[] seqs = this._$8;
        int[] ranks = this._$7;
        int count = tables.length;
        Sequence[] nextTables = this._$6;
        Object[][] nextValues = this._$5;
        Context[] ctxs = this._$4;
        boolean hasRepeated = false;
        for (i = 0; i < count; ++i) {
            if (ranks[i] != 0) continue;
            int next = seqs[i] + 1;
            if (next > tables[i].length()) {
                nextTables[i] = this._$15[i].fuzzyFetch(FETCHCOUNT);
                if (nextTables[i] != null && nextTables[i].length() > 0) {
                    ComputeStack stack = ctxs[i].getComputeStack();
                    stack.pop();
                    this._$3[i] = new Current(nextTables[i], 1);
                    stack.push(this._$3[i]);
                    JoinxCursor._$1(this._$14[i], ctxs[i], nextValues[i]);
                    if (Variant.compareArrays(nextValues[i], values[i]) != 0) continue;
                    hasRepeated = true;
                    tables[i] = nextTables[i];
                    seqs[i] = 1;
                    nextTables[i] = null;
                    continue;
                }
                nextTables[i] = null;
                nextValues[i] = null;
                continue;
            }
            this._$3[i].setCurrent(next);
            JoinxCursor._$1(this._$14[i], ctxs[i], nextValues[i]);
            if (Variant.compareArrays(nextValues[i], values[i]) != 0) continue;
            seqs[i] = next;
            hasRepeated = true;
        }
        if (hasRepeated) {
            for (i = 0; i < count; ++i) {
                if (ranks[i] != 0 || nextTables[i] == null) continue;
                Sequence table = nextTables[i];
                nextTables[i] = null;
                table.getMems().insert(1, tables[i].getMem(seqs[i]));
                tables[i] = table;
                seqs[i] = 1;
            }
        } else {
            block2: for (i = 0; i < count; ++i) {
                if (ranks[i] == 0) {
                    if (nextTables[i] != null) {
                        System.arraycopy(nextValues[i], 0, values[i], 0, values[i].length);
                        tables[i] = nextTables[i];
                        nextTables[i] = null;
                        seqs[i] = 1;
                    } else if (nextValues[i] != null) {
                        System.arraycopy(nextValues[i], 0, values[i], 0, values[i].length);
                        int n = i;
                        seqs[n] = seqs[n] + 1;
                    } else {
                        tables[i] = null;
                        values[i] = null;
                        ranks[i] = -1;
                    }
                }
                if (values[i] == null) continue;
                ranks[i] = 0;
                for (int j = 0; j < i; ++j) {
                    if (ranks[j] != 0) continue;
                    int cmp = Variant.compareArrays(values[i], values[j]);
                    if (cmp < 0) {
                        ranks[j] = 1;
                        ++j;
                        while (j < i) {
                            if (ranks[j] == 0) {
                                ranks[j] = 1;
                            }
                            ++j;
                        }
                        continue block2;
                    }
                    if (cmp <= 0) continue block2;
                    ranks[i] = 1;
                    continue block2;
                }
            }
        }
    }

    private static void _$1(Expression[] exps, Context ctx, Object[] outValues) {
        int len = exps.length;
        for (int i = 0; i < len; ++i) {
            outValues[i] = exps[i].calculate(ctx);
        }
    }

    private void _$1() {
        if (this._$10 != null) {
            return;
        }
        Expression[][] arr$ = this._$14;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Expression[] curExps;
            for (Expression exp : curExps = arr$[i$]) {
                exp.reset();
            }
        }
        int tcount = this._$15.length;
        int valCount = this._$14[0].length;
        this._$10 = new Sequence[tcount];
        this._$9 = new Object[tcount][];
        this._$8 = new int[tcount];
        this._$7 = new int[tcount];
        this._$6 = new Sequence[tcount];
        this._$5 = new Object[tcount][];
        this._$4 = new Context[tcount];
        this._$3 = new Current[tcount];
        block2: for (int i = 0; i < tcount; ++i) {
            this._$4[i] = this.ctx.newComputeContext();
            Sequence table = this._$15[i].fuzzyFetch(FETCHCOUNT);
            if (table != null && table.length() > 0) {
                Object[] curValues = new Object[valCount];
                this._$8[i] = 1;
                this._$3[i] = new Current(table, 1);
                this._$4[i].getComputeStack().push(this._$3[i]);
                JoinxCursor._$1(this._$14[i], this._$4[i], curValues);
                this._$10[i] = table;
                this._$9[i] = curValues;
                this._$7[i] = 0;
                this._$5[i] = new Object[valCount];
                for (int j = 0; j < i; ++j) {
                    if (this._$7[j] != 0) continue;
                    int cmp = Variant.compareArrays(curValues, this._$9[j]);
                    if (cmp < 0) {
                        this._$7[j] = 1;
                        ++j;
                        while (j < i) {
                            if (this._$7[j] == 0) {
                                this._$7[j] = 1;
                            }
                            ++j;
                        }
                        continue block2;
                    }
                    if (cmp <= 0) continue block2;
                    this._$7[i] = 1;
                    continue block2;
                }
                continue;
            }
            this._$7[i] = -1;
        }
    }

    protected long skipOver(long n) {
        long count;
        block14: {
            if (this._$11 || n < 1L) {
                return 0L;
            }
            this._$1();
            int[] ranks = this._$7;
            int tcount = this._$10.length;
            if (this._$12 == 0) {
                block0: while (count < n) {
                    for (int i = 0; i < tcount; ++i) {
                        if (ranks[i] == 0) continue;
                        if (ranks[i] != -1) {
                            this._$3();
                            continue block0;
                        }
                        break block14;
                    }
                    ++count;
                    this._$2();
                }
            } else if (this._$12 == 1) {
                while (count < n) {
                    if (ranks[0] == 0) {
                        ++count;
                        this._$2();
                        continue;
                    }
                    if (ranks[0] != -1) {
                        this._$3();
                        continue;
                    }
                    break;
                }
            } else {
                for (count = 0L; count < n; ++count) {
                    boolean sign = false;
                    for (int i = 0; i < tcount; ++i) {
                        if (ranks[i] != 0) continue;
                        sign = true;
                        break;
                    }
                    if (sign) {
                        this._$2();
                        continue;
                    }
                    break;
                }
            }
        }
        return count;
    }

    public synchronized void close() {
        super.close();
        if (this._$15 != null) {
            int count = this._$15.length;
            for (int i = 0; i < count; ++i) {
                this._$15[i].close();
            }
            this._$10 = null;
            this._$9 = null;
            this._$6 = null;
            this._$5 = null;
            this._$11 = true;
        }
    }

    public boolean reset() {
        this.close();
        int count = this._$15.length;
        for (int i = 0; i < count; ++i) {
            if (this._$15[i].reset()) continue;
            return false;
        }
        this._$11 = false;
        return true;
    }
}

