/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.cursor;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.resources.EngineMessage;

public class PJoinCursor
extends ICursor {
    private ICursor[] _$6;
    private String[] _$5;
    private DataStruct _$4;
    private boolean _$3 = false;

    public PJoinCursor(ICursor[] cursors, String[] names) {
        this._$6 = cursors;
        this._$5 = names;
        if (names != null) {
            this._$4 = new DataStruct(names);
            this.setDataStruct(this._$4);
        }
    }

    public PJoinCursor(ICursor[] cursors) {
        this(cursors, null);
    }

    public void resetContext(Context ctx) {
        if (this.ctx != ctx) {
            for (ICursor cursor : this._$6) {
                cursor.resetContext(ctx);
            }
            super.resetContext(ctx);
        }
    }

    private Sequence _$1(int n) {
        int minLen = n;
        int fcount = this._$6.length;
        Sequence[] tables = new Sequence[fcount];
        for (int i = 0; i < fcount; ++i) {
            Sequence table = this._$6[i].fetch(n);
            if (table == null || table.length() == 0) {
                return null;
            }
            tables[i] = table;
            if (table.length() >= minLen) continue;
            minLen = table.length();
        }
        Table table = new Table(this._$4, minLen);
        for (int i = 1; i <= minLen; ++i) {
            BaseRecord r = table.newLast();
            for (int f = 0; f < fcount; ++f) {
                r.setNormalFieldValue(f, tables[f].getMem(i));
            }
        }
        return table;
    }

    protected Sequence get(int n) {
        if (this._$3 || n < 1) {
            return null;
        }
        if (this._$5 != null) {
            return this._$1(n);
        }
        int minLen = n;
        int tcount = this._$6.length;
        Sequence[] tables = new Sequence[tcount];
        int[] fcounts = new int[tcount];
        int fcount = 0;
        for (int i = 0; i < tcount; ++i) {
            Sequence table = this._$6[i].fetch(n);
            if (table == null || table.length() == 0) {
                return null;
            }
            DataStruct ds = table.dataStruct();
            if (ds == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needPurePmt"));
            }
            tables[i] = table;
            fcounts[i] = ds.getFieldCount();
            fcount += fcounts[i];
            if (table.length() >= minLen) continue;
            minLen = table.length();
        }
        if (this._$4 == null) {
            String[] fnames = new String[fcount];
            int findex = 0;
            for (int i = 0; i < tcount; ++i) {
                String[] curNames = tables[i].dataStruct().getFieldNames();
                System.arraycopy(curNames, 0, fnames, findex, fcounts[i]);
                findex += fcounts[i];
            }
            this._$4 = new DataStruct(fnames);
        }
        Table table = new Table(this._$4, minLen);
        Object[] values = new Object[fcount];
        for (int i = 1; i <= minLen; ++i) {
            int findex = 0;
            for (int t = 0; t < tcount; ++t) {
                BaseRecord r = (BaseRecord)tables[t].getMem(i);
                Object[] curVals = r.getFieldValues();
                System.arraycopy(curVals, 0, values, findex, fcounts[t]);
                findex += fcounts[t];
            }
            table.newLast(values);
        }
        return table;
    }

    protected long skipOver(long n) {
        if (this._$3 || n < 1L) {
            return 0L;
        }
        ICursor[] cursors = this._$6;
        long minLen = n;
        int tcount = cursors.length;
        for (int i = 0; i < tcount; ++i) {
            long curLen = cursors[i].skip(n);
            if (curLen < 1L) {
                return 0L;
            }
            if (curLen >= minLen) continue;
            minLen = curLen;
        }
        return minLen;
    }

    public synchronized void close() {
        super.close();
        if (this._$6 != null) {
            int count = this._$6.length;
            for (int i = 0; i < count; ++i) {
                this._$6[i].close();
            }
            this._$3 = true;
        }
    }

    public boolean reset() {
        this.close();
        int count = this._$6.length;
        for (int i = 0; i < count; ++i) {
            if (this._$6[i].reset()) continue;
            return false;
        }
        this._$3 = false;
        return true;
    }
}

