/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.op;

import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.FileObject;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dm.op.Channel;
import com.scudata.dm.op.CsJoinxResult;
import com.scudata.dm.op.FetchResult;
import com.scudata.dm.op.GroupxResult;
import com.scudata.dm.op.IDResult;
import com.scudata.dm.op.IGroupsResult;
import com.scudata.dm.op.IPipe;
import com.scudata.dm.op.IterateResult;
import com.scudata.dm.op.Operable;
import com.scudata.dm.op.Operation;
import com.scudata.dm.op.Push;
import com.scudata.dm.op.SortxResult;
import com.scudata.dm.op.TotalResult;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;

public class MultipathChannel
extends Channel {
    private Channel[] _$2;

    public MultipathChannel(Context ctx, MultipathCursors mcs) {
        this(ctx, mcs, true);
    }

    public MultipathChannel(Context ctx, MultipathCursors mcs, boolean doPush) {
        super(ctx);
        ICursor[] cursors = mcs.getCursors();
        int count = cursors.length;
        this._$2 = new Channel[count];
        for (int i = 0; i < count; ++i) {
            this._$2[i] = cursors[i].newChannel(cursors[i].getContext(), doPush);
        }
    }

    public void addPushToCursor(ICursor cs) {
        MultipathCursors mcs = (MultipathCursors)cs;
        ICursor[] cursors = mcs.getCursors();
        int count = cursors.length;
        for (int i = 0; i < count; ++i) {
            Push push = new Push(this._$2[i]);
            cursors[i].addOperation(push, cursors[i].getContext());
        }
    }

    public Operable addOperation(Operation op, Context ctx) {
        this.checkResultChannel();
        for (Channel channel : this._$2) {
            ctx = channel.getContext();
            channel.addOperation(op.duplicate(ctx), ctx);
        }
        return this;
    }

    public Operable select(Function function, Expression fltExp, String opt, Context ctx) {
        this.checkResultChannel();
        for (Channel channel : this._$2) {
            ctx = channel.getContext();
            Expression curFilter = Operation.dupExpression(fltExp, ctx);
            channel.select(function, curFilter, opt, ctx);
        }
        return this;
    }

    public Operable select(Function function, Expression fltExp, String opt, IPipe pipe, Context ctx) {
        this.checkResultChannel();
        for (Channel channel : this._$2) {
            ctx = channel.getContext();
            Expression curFilter = Operation.dupExpression(fltExp, ctx);
            channel.select(function, curFilter, opt, pipe, ctx);
        }
        return this;
    }

    public Operable filterJoin(Function function, Expression[][] exps, Sequence[] codes, Expression[][] dataExps, String opt, Context ctx) {
        this.checkResultChannel();
        for (Channel channel : this._$2) {
            ctx = channel.getContext();
            Expression[][] curExps = Operation.dupExpressions(exps, ctx);
            Expression[][] curDataExps = Operation.dupExpressions(dataExps, ctx);
            channel.filterJoin(function, curExps, codes, curDataExps, opt, ctx);
        }
        return this;
    }

    public Operable diffJoin(Function function, Expression[][] exps, Sequence[] codes, Expression[][] dataExps, String opt, Context ctx) {
        this.checkResultChannel();
        for (Channel channel : this._$2) {
            ctx = channel.getContext();
            Expression[][] curExps = Operation.dupExpressions(exps, ctx);
            Expression[][] curDataExps = Operation.dupExpressions(dataExps, ctx);
            channel.diffJoin(function, curExps, codes, curDataExps, opt, ctx);
        }
        return this;
    }

    public Operable join(Function function, String fname, Expression[][] exps, Sequence[] codes, Expression[][] dataExps, Expression[][] newExps, String[][] newNames, String opt, Context ctx) {
        this.checkResultChannel();
        for (Channel channel : this._$2) {
            ctx = channel.getContext();
            Expression[][] curExps = Operation.dupExpressions(exps, ctx);
            Expression[][] curDataExps = Operation.dupExpressions(dataExps, ctx);
            Expression[][] curNewExps = Operation.dupExpressions(newExps, ctx);
            channel.join(function, fname, curExps, codes, curDataExps, curNewExps, newNames, opt, ctx);
        }
        return this;
    }

    public Operable joinRemote(Function function, String fname, Expression[][] exps, Object[] codes, Expression[][] dataExps, Expression[][] newExps, String[][] newNames, String opt, Context ctx) {
        this.checkResultChannel();
        for (Channel channel : this._$2) {
            ctx = channel.getContext();
            Expression[][] curExps = Operation.dupExpressions(exps, ctx);
            Expression[][] curDataExps = Operation.dupExpressions(dataExps, ctx);
            Expression[][] curNewExps = Operation.dupExpressions(newExps, ctx);
            channel.joinRemote(function, fname, curExps, codes, curDataExps, curNewExps, newNames, opt, ctx);
        }
        return this;
    }

    public Operable fjoin(Function function, Expression[] dimExps, String[] aliasNames, Expression[][] newExps, String[][] newNames, String opt, Context ctx) {
        this.checkResultChannel();
        for (Channel channel : this._$2) {
            ctx = channel.getContext();
            Expression[] curDimExps = Operation.dupExpressions(dimExps, ctx);
            Expression[][] curNewExps = Operation.dupExpressions(newExps, ctx);
            channel.fjoin(function, curDimExps, aliasNames, curNewExps, newNames, opt, ctx);
        }
        return this;
    }

    public Operable derive(Function function, Expression[] exps, String[] names, String opt, int level, Context ctx) {
        this.checkResultChannel();
        for (Channel channel : this._$2) {
            ctx = channel.getContext();
            Expression[] curExps = Operation.dupExpressions(exps, ctx);
            channel.derive(function, curExps, names, opt, level, ctx);
        }
        return this;
    }

    public Operable newTable(Function function, Expression[] newExps, String[] names, String opt, Context ctx) {
        this.checkResultChannel();
        for (Channel channel : this._$2) {
            ctx = channel.getContext();
            Expression[] curExps = Operation.dupExpressions(newExps, ctx);
            channel.newTable(function, curExps, names, opt, ctx);
        }
        return this;
    }

    public Operable group(Function function, Expression[] exps, String opt, Context ctx) {
        this.checkResultChannel();
        for (Channel channel : this._$2) {
            ctx = channel.getContext();
            Expression[] curExps = Operation.dupExpressions(exps, ctx);
            channel.group(function, curExps, opt, ctx);
        }
        return this;
    }

    public Operable group(Function function, Expression[] exps, Expression[] sortExps, String opt, Context ctx) {
        this.checkResultChannel();
        for (Channel channel : this._$2) {
            ctx = channel.getContext();
            Expression[] curExps = Operation.dupExpressions(exps, ctx);
            Expression[] curSortExps = Operation.dupExpressions(sortExps, ctx);
            channel.group(function, curExps, curSortExps, opt, ctx);
        }
        return this;
    }

    public Operable group(Function function, Expression[] exps, String[] names, Expression[] newExps, String[] newNames, String opt, Context ctx) {
        this.checkResultChannel();
        for (Channel channel : this._$2) {
            ctx = channel.getContext();
            Expression[] curExps = Operation.dupExpressions(exps, ctx);
            Expression[] curNewExps = Operation.dupExpressions(newExps, ctx);
            channel.group(function, curExps, names, curNewExps, newNames, opt, ctx);
        }
        return this;
    }

    public Operable group(Function function, Expression[] exps, String[] names, Expression[] sortExps, String[] sortNames, Expression[] newExps, String[] newNames, String opt, Context ctx) {
        this.checkResultChannel();
        for (Channel channel : this._$2) {
            ctx = channel.getContext();
            Expression[] curExps = Operation.dupExpressions(exps, ctx);
            Expression[] curSortExps = Operation.dupExpressions(sortExps, ctx);
            Expression[] curNewExps = Operation.dupExpressions(newExps, ctx);
            channel.group(function, curExps, names, curSortExps, sortNames, curNewExps, newNames, opt, ctx);
        }
        return this;
    }

    public Operable switchFk(Function function, String[] fkNames, String[] timeFkNames, Sequence[] codes, Expression[] exps, Expression[] timeExps, String opt, Context ctx) {
        this.checkResultChannel();
        for (Channel channel : this._$2) {
            ctx = channel.getContext();
            Expression[] curexps = Operation.dupExpressions(exps, ctx);
            Expression[] curTimeExps = Operation.dupExpressions(timeExps, ctx);
            channel.switchFk(function, fkNames, timeFkNames, codes, curexps, curTimeExps, opt, ctx);
        }
        return this;
    }

    protected void checkResultChannel() {
        if (this.result != null) {
            throw new RQException("\u9644\u52a0\u7ed3\u679c\u96c6\u4e4b\u540e\u4e0d\u80fd\u518d\u7ee7\u7eed\u9644\u52a0\u5176\u5b83\u8fd0\u7b97");
        }
    }

    public synchronized void push(Sequence seq, Context ctx) {
        if (this.result != null && seq != null) {
            this.result.push(seq, ctx);
        }
    }

    public void finish(Context ctx) {
    }

    public Object result() {
        if (this.result instanceof IGroupsResult) {
            int count = this._$2.length;
            IGroupsResult groupsResult = (IGroupsResult)this._$2[0].getResult();
            IGroupsResult[] groupsResults = new IGroupsResult[count - 1];
            for (int i = 1; i < count; ++i) {
                groupsResults[i - 1] = (IGroupsResult)this._$2[i].getResult();
            }
            Table value = groupsResult.combineGroupsResult(groupsResults, this.ctx);
            if (this.resultNew == null) {
                return value;
            }
            Sequence table = this.resultNew.process(value, this.ctx);
            if (this.pkCount > 0 && table instanceof Table) {
                String[] pks = new String[this.pkCount];
                for (int i = 1; i <= this.pkCount; ++i) {
                    pks[i - 1] = "#" + i;
                }
                ((Table)table).setPrimary(pks);
                return table;
            }
            return table;
        }
        if (this.result instanceof TotalResult) {
            int count = this._$2.length;
            IGroupsResult groupsResult = (IGroupsResult)this._$2[0].getResult();
            IGroupsResult[] groupsResults = new IGroupsResult[count - 1];
            for (int i = 1; i < count; ++i) {
                groupsResults[i - 1] = (IGroupsResult)this._$2[i].getResult();
            }
            Table table = groupsResult.combineGroupsResult(groupsResults, this.ctx);
            if (table == null || table.length() == 0) {
                return null;
            }
            TotalResult total = (TotalResult)this.result;
            BaseRecord r = table.getRecord(1);
            int valCount = total.getCalcExps().length;
            if (valCount == 1) {
                return r.getNormalFieldValue(0);
            }
            Sequence seq = new Sequence(valCount);
            for (int i = 0; i < valCount; ++i) {
                seq.add(r.getNormalFieldValue(i));
            }
            return seq;
        }
        if (this.result != null) {
            Object val = this.result.result();
            this.result = null;
            return val;
        }
        return null;
    }

    public Channel fetch() {
        this.checkResultChannel();
        this.result = new FetchResult();
        for (Channel channel : this._$2) {
            Push push = new Push(this);
            this.ctx = channel.getContext();
            channel.addOperation(push, this.ctx);
        }
        return this;
    }

    public Channel fetch(FileObject file) {
        this.checkResultChannel();
        this.result = new FetchResult(file);
        for (Channel channel : this._$2) {
            Push push = new Push(this);
            this.ctx = channel.getContext();
            channel.addOperation(push, this.ctx);
        }
        return this;
    }

    public Channel groups(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt) {
        this.checkResultChannel();
        this.result = IGroupsResult.instance(exps, names, calcExps, calcNames, null, opt, this.ctx);
        for (Channel channel : this._$2) {
            Context ctx = channel.getContext();
            exps = Operation.dupExpressions(exps, ctx);
            calcExps = Operation.dupExpressions(calcExps, ctx);
            channel.groups(exps, names, calcExps, calcNames, opt);
        }
        return this;
    }

    public Channel total(Expression[] calcExps) {
        this.checkResultChannel();
        this.result = new TotalResult(calcExps, this.ctx, null);
        for (Channel channel : this._$2) {
            Context ctx = channel.getContext();
            calcExps = Operation.dupExpressions(calcExps, ctx);
            channel.groups(null, null, calcExps, null, null);
        }
        return this;
    }

    public Channel groupx(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, int capacity) {
        this.checkResultChannel();
        this.result = new GroupxResult(exps, names, calcExps, calcNames, opt, this.ctx, capacity);
        for (Channel channel : this._$2) {
            Push push = new Push(this);
            this.ctx = channel.getContext();
            channel.addOperation(push, this.ctx);
        }
        return this;
    }

    public Channel sortx(Expression[] exps, int capacity, String opt) {
        this.checkResultChannel();
        this.result = new SortxResult(exps, this.ctx, capacity, opt);
        for (Channel channel : this._$2) {
            Push push = new Push(this);
            this.ctx = channel.getContext();
            channel.addOperation(push, this.ctx);
        }
        return this;
    }

    public Channel joinx(Expression[][] fields, Object[] fileTable, Expression[][] keys, Expression[][] exps, String[][] expNames, String fname, Context ctx, String option, int capacity) {
        this.checkResultChannel();
        this.result = new CsJoinxResult(fields, fileTable, keys, exps, expNames, fname, ctx, option, capacity);
        for (Channel channel : this._$2) {
            Push push = new Push(this);
            ctx = channel.getContext();
            channel.addOperation(push, ctx);
        }
        return this;
    }

    public Channel iterate(Expression exp, Object initVal, Expression c, Context ctx) {
        this.checkResultChannel();
        this.result = new IterateResult(exp, initVal, c, ctx);
        for (Channel channel : this._$2) {
            Push push = new Push(this);
            ctx = channel.getContext();
            channel.addOperation(push, ctx);
        }
        return this;
    }

    public Channel id(Expression[] exps, int count, String opt) {
        this.checkResultChannel();
        this.result = new IDResult(exps, count, opt, this.ctx);
        for (Channel channel : this._$2) {
            Push push = new Push(this);
            this.ctx = channel.getContext();
            channel.addOperation(push, this.ctx);
        }
        return this;
    }
}

