/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query;

import com.scudata.cellset.ICellSet;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dm.query.IlIIIlIIIllIllIl;
import com.scudata.dm.query.Select;
import com.scudata.dm.query.SetOperation;
import com.scudata.dm.query.TableNode;
import com.scudata.dm.query.Token;
import com.scudata.dm.query.Tokenizer;
import com.scudata.dm.query.lIlIIlIIlIlIIIII;
import com.scudata.dm.query.lIllIlIIllIIIIlI;
import com.scudata.dm.query.lIlllIIIIIllIllI;
import com.scudata.expression.Expression;
import com.scudata.resources.ParseMessage;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSQL {
    private static final String _$7 = "sql_temp_param_";
    private ICellSet _$6;
    private Context _$5;
    private Token[] _$4;
    private ArrayList<lIlIIlIIlIlIIIII> _$3 = new ArrayList();
    private IlIIIlIIIllIllIl _$2;
    private int _$1 = 0;

    public SimpleSQL(String sql, List<Object> paramValues) {
        this(null, sql, paramValues, null);
    }

    public SimpleSQL(String sql, List<Object> paramValues, Context ctx) {
        this(null, sql, paramValues, ctx);
    }

    public SimpleSQL(ICellSet cs, String sql, List<Object> paramValues, Context ctx) {
        this._$6 = cs;
        this._$4 = Tokenizer.parse(sql);
        this._$5 = ctx == null ? new Context() : new Context(ctx);
        if (paramValues != null && paramValues.size() > 0) {
            ParamList paramList = this._$5.getParamList();
            long now = System.currentTimeMillis();
            String prefix = _$7 + now + "_";
            int seq = 1;
            for (Object val : paramValues) {
                Param param = new Param(prefix + seq, 0, val);
                paramList.add(param);
                ++seq;
            }
            for (Token token : this._$4) {
                if (token.getType() != '?') continue;
                seq = Integer.parseInt(token.getString());
                if (seq > paramList.count()) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("function.paramError") + token.getPos());
                }
                Param param = paramList.get(seq - 1);
                token.setString(param.getName());
            }
        }
    }

    public lIlIIlIIlIlIIIII getWithItem(String tableName) {
        for (lIlIIlIIlIlIIIII with : this._$3) {
            if (!with.equals(tableName)) continue;
            return with;
        }
        return null;
    }

    public ICellSet getCellSet() {
        return this._$6;
    }

    public Context getContext() {
        return this._$5;
    }

    private int _$3(Token[] tokens, int start, int next) {
        if (++start == next) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
        }
        if (tokens[start].isKeyWord("RECURSIVE") && ++start == next) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
        }
        while (start < next) {
            if ((start = this._$2(tokens, start, next)) == next) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
            }
            if (!tokens[start].isComma()) break;
            if (++start != next) continue;
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
        }
        return start;
    }

    private int _$2(Token[] tokens, int start, int next) {
        IlIIIlIIIllIllIl query;
        if (tokens[start].getType() != '\u0001') {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
        }
        String name = tokens[start].getOriginString();
        ArrayList<String> columnNames = null;
        if (++start == next) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
        }
        if (tokens[start].getType() == '(') {
            if (++start == next) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
            }
            columnNames = new ArrayList<String>();
            while (start < next) {
                if (tokens[start].getType() != '\u0001') {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
                }
                columnNames.add(tokens[start].getOriginString());
                if (++start == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
                }
                if (tokens[start].isComma()) {
                    ++start;
                    continue;
                }
                if (tokens[start].getType() == ')') {
                    ++start;
                    break;
                }
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
            }
            if (start == next) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
            }
        }
        if (!tokens[start].isKeyWord("AS")) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
        }
        if (++start == next) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
        }
        if (tokens[start].getType() != '(') {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
        }
        int end = Tokenizer.scanParen(tokens, start, next);
        if (tokens[++start].isKeyWord("SELECT")) {
            query = this._$1(tokens, start, end);
        } else {
            String expStr = "";
            for (int i = start; i < end; ++i) {
                expStr = expStr + tokens[i].getOriginString();
                expStr = expStr + tokens[i].getSpaces();
            }
            Expression exp = new Expression(this._$6, this._$5, expStr);
            Object obj = exp.calculate(this._$5);
            if (obj instanceof ICursor) {
                query = new TableNode(null, (ICursor)obj, expStr, name);
            } else if (obj instanceof Sequence) {
                query = new TableNode(null, (Sequence)obj, expStr, name);
            } else {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + ":scanFrom, \u4e0d\u652f\u6301\u7684\u8868\u53d8\u91cf\u7c7b\u578b");
            }
        }
        lIlIIlIIlIlIIIII withItem = new lIlIIlIIlIlIIIII(name, columnNames, query);
        this._$3.add(withItem);
        return end + 1;
    }

    private IlIIIlIIIllIllIl _$1(Token[] tokens, int start, int next) {
        lIllIlIIllIIIIlI operation = null;
        int i = start;
        while (i < next) {
            lIlllIIIIIllIllI newOperation;
            MessageManager mm;
            Select select;
            Token token = tokens[i];
            if (token.getType() == '(') {
                i = Tokenizer.scanParen(tokens, i, next) + 1;
                continue;
            }
            if (token.isKeyWord("UNION")) {
                select = new Select(this, tokens, start, i);
                if (++i == next) {
                    mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                }
                SetOperation.Type type = SetOperation.Type.UNION;
                if (tokens[i].isKeyWord("ALL")) {
                    type = SetOperation.Type.UNIONALL;
                    ++i;
                }
                if (operation == null) {
                    operation = new lIlllIIIIIllIllI(type);
                    operation.setLeft(select);
                } else {
                    operation.setRight(select);
                    lIlllIIIIIllIllI newOperation2 = new lIlllIIIIIllIllI(type);
                    newOperation2.setLeft(operation);
                    operation = newOperation2;
                }
                start = i;
                continue;
            }
            if (token.isKeyWord("INTERSECT")) {
                select = new Select(this, tokens, start, i);
                if (++i == next) {
                    mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                }
                if (operation == null) {
                    operation = new lIlllIIIIIllIllI(SetOperation.Type.INTERSECT);
                    operation.setLeft(select);
                } else {
                    operation.setRight(select);
                    newOperation = new lIlllIIIIIllIllI(SetOperation.Type.INTERSECT);
                    newOperation.setLeft(operation);
                    operation = newOperation;
                }
                start = i;
                continue;
            }
            if (token.isKeyWord("MINUS")) {
                select = new Select(this, tokens, start, i);
                if (++i == next) {
                    mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                }
                if (operation == null) {
                    operation = new lIlllIIIIIllIllI(SetOperation.Type.MINUS);
                    operation.setLeft(select);
                } else {
                    operation.setRight(select);
                    newOperation = new lIlllIIIIIllIllI(SetOperation.Type.MINUS);
                    newOperation.setLeft(operation);
                    operation = newOperation;
                }
                start = i;
                continue;
            }
            ++i;
        }
        if (operation == null) {
            return new Select(this, tokens, start, next);
        }
        Select select = new Select(this, tokens, start, next);
        operation.setRight(select);
        return operation;
    }

    private void _$2() {
        int start = 0;
        int next = this._$4.length;
        if (this._$4[start].isKeyWord("WITH")) {
            start = this._$3(this._$4, start, next);
        }
        this._$2 = this._$1(this._$4, start, next);
    }

    String _$1() {
        ++this._$1;
        return "subsql_table_param_name" + this._$1;
    }

    public Object execute() {
        this._$2();
        return this._$2.getData();
    }

    public ICursor query() {
        Object obj = this.execute();
        if (obj instanceof ICursor) {
            return (ICursor)obj;
        }
        if (obj instanceof Sequence) {
            return new MemoryCursor((Sequence)obj);
        }
        return null;
    }

    public DataStruct getDataStruct() {
        return this._$2.getDataStruct();
    }
}

