/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query;

import com.scudata.cellset.ICellSet;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.Sequence;
import com.scudata.dm.UserUtils;
import com.scudata.dm.cursor.BFileCursor;
import com.scudata.dm.cursor.ConjxCursor;
import com.scudata.dm.cursor.FileCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dm.query.IlIIIlIIIllIllIl;
import com.scudata.dm.query.Select;
import com.scudata.dm.query.lIlIIlIIlIlIIIII;
import com.scudata.dm.query.utils.FileUtil;
import com.scudata.dw.ComTable;
import com.scudata.dw.PhyTable;
import com.scudata.excel.ExcelTool;
import com.scudata.excel.XlsxSImporter;
import com.scudata.expression.Constant;
import com.scudata.expression.Expression;
import com.scudata.expression.mfn.dw.CreateCursor;
import com.scudata.resources.EngineMessage;
import com.scudata.resources.ParseMessage;
import com.scudata.util.JSONUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableNode
extends IlIIIlIIIllIllIl {
    public static final int TYPE_BIN = 0;
    public static final int TYPE_TXT = 1;
    public static final int TYPE_CSV = 2;
    public static final int TYPE_XLS = 3;
    public static final int TYPE_XLSX = 4;
    public static final int TYPE_JSON = 5;
    public static final int TYPE_CTX = 6;
    private String _$7;
    private ICursor _$6;
    private Sequence _$5;
    private ArrayList<FileObject> _$4;
    private int _$3;
    private DataStruct _$2;
    private ArrayList<String> _$1;

    public TableNode(Select select, Sequence sequence, String name, String aliasName) {
        this.select = select;
        this._$7 = name;
        this.aliasName = aliasName;
        this._$1(sequence);
    }

    public TableNode(Select select, ICursor cs, String name, String aliasName) {
        this.select = select;
        this._$7 = name;
        this.aliasName = aliasName;
        this._$1(cs);
    }

    public TableNode(Select select, String fileName, String aliasName) {
        String strFile;
        this.select = select;
        this._$7 = fileName;
        this.aliasName = aliasName;
        lIlIIlIIlIlIIIII with = select._$5(fileName);
        if (with != null) {
            Sequence data = with.getData();
            this._$1(data);
            return;
        }
        Context ctx = select._$6();
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex == -1) {
            Expression exp = new Expression(select._$5(), ctx, fileName);
            Object obj = exp.calculate(ctx);
            if (obj instanceof ICursor) {
                this._$1((ICursor)obj);
            } else if (obj instanceof Sequence) {
                this._$1((Sequence)obj);
            } else {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + ":scanFrom, \u4e0d\u652f\u6301\u7684\u8868\u53d8\u91cf\u7c7b\u578b");
            }
            return;
        }
        String fileType = fileName.substring(dotIndex);
        File appHome = ctx.getAppHome();
        String mainPath = Env.getMainPath();
        File[] files = null;
        if (appHome != null) {
            strFile = appHome.getAbsolutePath();
            if (mainPath != null && mainPath.length() > 0) {
                strFile = strFile + "/" + mainPath;
            }
            if ((files = FileUtil.getFiles(strFile = strFile + "/" + fileName)) != null && files.length > 0) {
                this._$1(files, fileType);
                return;
            }
            if (Env.getPaths() != null) {
                for (String path : Env.getPaths()) {
                    strFile = appHome.getAbsolutePath() + "/" + path + "/" + fileName;
                    files = FileUtil.getFiles(strFile);
                    if (files == null || files.length <= 0) continue;
                    this._$1(files, fileType);
                    return;
                }
            }
        } else {
            files = FileUtil.getFiles(fileName);
            if (files != null && files.length > 0) {
                this._$1(files, fileType);
                return;
            }
            if (mainPath != null && mainPath.length() > 0 && (files = FileUtil.getFiles(strFile = mainPath + "/" + fileName)) != null && files.length > 0) {
                this._$1(files, fileType);
                return;
            }
            if (Env.getPaths() != null) {
                for (String path : Env.getPaths()) {
                    String strFile2 = path + "/" + fileName;
                    files = FileUtil.getFiles(strFile2);
                    if (files == null || files.length <= 0) continue;
                    this._$1(files, fileType);
                    return;
                }
            }
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("file.fileNotExist", fileName));
    }

    public void addFileAttribute(String attr) {
        if (this._$1 == null) {
            this._$1 = new ArrayList();
            this._$1.add(attr);
        } else if (!this._$1.contains(attr)) {
            this._$1.add(attr);
        }
    }

    @Override
    public int getFileAttributeCount() {
        return this._$1 == null ? 0 : this._$1.size();
    }

    private void _$1(FileObject fo, ICursor cs) {
        if (this._$1 == null || cs == null) {
            return;
        }
        int count = this._$1.size();
        Expression[] exps = new Expression[count];
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            Object val;
            String name;
            names[i] = this._$1.get(i);
            if (names[i].equals("_file")) {
                name = fo.getFileName();
                File file = new File(name);
                val = file.getName();
            } else {
                int dot;
                val = names[i].equals("_ext") ? ((dot = (name = fo.getFileName()).lastIndexOf(46)) != -1 ? name.substring(dot) : name) : (names[i].equals("_date") ? fo.lastModified() : Long.valueOf(fo.size()));
            }
            Constant constant = new Constant(val);
            exps[i] = new Expression(constant);
        }
        Context ctx = this.select._$6();
        cs.derive(null, exps, names, null, 0, ctx);
    }

    private Sequence _$1(FileObject fo, Sequence sequence) {
        if (this._$1 == null || sequence == null) {
            return sequence;
        }
        int count = this._$1.size();
        Expression[] exps = new Expression[count];
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            Object val;
            String name;
            names[i] = this._$1.get(i);
            if (names[i].equals("_file")) {
                name = fo.getFileName();
                File file = new File(name);
                val = file.getName();
            } else {
                int dot;
                val = names[i].equals("_ext") ? ((dot = (name = fo.getFileName()).lastIndexOf(46)) != -1 ? name.substring(dot) : name) : (names[i].equals("_date") ? fo.lastModified() : Long.valueOf(fo.size()));
            }
            Constant constant = new Constant(val);
            exps[i] = new Expression(constant);
        }
        Context ctx = this.select._$6();
        return sequence.derive(names, exps, null, ctx);
    }

    @Override
    public IlIIIlIIIllIllIl getQueryBody(String tableName) {
        if (this.aliasName != null) {
            if (Select.isEquals(this.aliasName, tableName)) {
                return this;
            }
            return null;
        }
        if (Select.isEquals(this._$7, tableName)) {
            return this;
        }
        return null;
    }

    @Override
    public IlIIIlIIIllIllIl getQueryBody(String tableName, String fieldName) {
        if (tableName != null) {
            if (this.aliasName != null) {
                if (Select.isEquals(this.aliasName, tableName)) {
                    return this;
                }
                return null;
            }
            if (Select.isEquals(this._$7, tableName)) {
                return this;
            }
            return null;
        }
        if (this._$1(fieldName) != -1) {
            return this;
        }
        return null;
    }

    private int _$1(String fieldName) {
        DataStruct ds = this.getDataStruct();
        if (ds == null) {
            return -1;
        }
        return Select.getFieldIndex(ds, fieldName);
    }

    private void _$1(Sequence sequence) {
        this._$5 = sequence;
        this._$2 = sequence.dataStruct();
    }

    private void _$1(File[] files, String fileType) {
        this._$4 = new ArrayList();
        for (File file : files) {
            this._$4.add(new FileObject(file.getAbsolutePath()));
        }
        if ((fileType = fileType.toLowerCase()).equals(".btx")) {
            this._$3 = 0;
        } else if (fileType.equals(".txt")) {
            this._$3 = 1;
        } else if (fileType.equals(".csv")) {
            this._$3 = 2;
        } else if (fileType.equals(".xls")) {
            this._$3 = 3;
        } else if (fileType.equals(".xlsx")) {
            this._$3 = 4;
        } else if (fileType.equals(".json")) {
            this._$3 = 5;
        } else if (fileType.equals(".ctx")) {
            this._$3 = 6;
        } else {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + ":scanFrom, \u5f02\u5e38\u7684\u8868\u540d(\u6ce8\u610f\u8868\u540d\u4e0d\u80fd\u4e3a\u5173\u952e\u5b57\u6216\u4ee5\u6570\u5b57\u5f00\u5934):" + this._$7);
        }
    }

    private void _$1(ICursor cs) {
        Sequence data;
        this._$6 = cs;
        this._$2 = cs.getDataStruct();
        if (this._$2 == null && (data = cs.peek(1)) != null) {
            this._$2 = data.dataStruct();
        }
    }

    public ArrayList<FileObject> getFiles() {
        return this._$4;
    }

    public ICursor getDataCursor() {
        ICursor cursor;
        if (this._$6 != null) {
            return this._$6;
        }
        if (this._$5 != null) {
            this._$6 = new MemoryCursor(this._$5);
            return this._$6;
        }
        int fileCount = this._$4.size();
        Context ctx = this.select._$6();
        if (this._$3 == 0) {
            if (fileCount == 1) {
                FileObject fo = this._$4.get(0);
                cursor = new BFileCursor(fo, null, null, ctx);
                this._$1(fo, cursor);
            } else {
                ICursor[] cursors = new ICursor[fileCount];
                for (int i = 0; i < fileCount; ++i) {
                    FileObject fo = this._$4.get(i);
                    cursors[i] = new BFileCursor(fo, null, null, ctx);
                    this._$1(fo, cursors[i]);
                }
                cursor = new ConjxCursor(cursors);
            }
        } else if (this._$3 == 1) {
            if (fileCount == 1) {
                FileObject fo = this._$4.get(0);
                cursor = new FileCursor(fo, 1, 1, null, "t", ctx);
                this._$1(fo, cursor);
            } else {
                ICursor[] cursors = new ICursor[fileCount];
                for (int i = 0; i < fileCount; ++i) {
                    FileObject fo = this._$4.get(i);
                    cursors[i] = new FileCursor(fo, 1, 1, null, "t", ctx);
                    this._$1(fo, cursors[i]);
                }
                cursor = new ConjxCursor(cursors);
            }
        } else if (this._$3 == 2) {
            if (fileCount == 1) {
                FileObject fo = this._$4.get(0);
                cursor = new FileCursor(fo, 1, 1, null, "tc", ctx);
                this._$1(fo, cursor);
            } else {
                ICursor[] cursors = new ICursor[fileCount];
                for (int i = 0; i < fileCount; ++i) {
                    FileObject fo = this._$4.get(i);
                    cursors[i] = new FileCursor(fo, 1, 1, null, "tc", ctx);
                    this._$1(fo, cursors[i]);
                }
                cursor = new ConjxCursor(cursors);
            }
        } else if (this._$3 == 3) {
            InputStream in = null;
            BufferedInputStream bis = null;
            Sequence data = null;
            try {
                for (int i = 0; i < fileCount; ++i) {
                    in = this._$4.get(i).getInputStream();
                    bis = new BufferedInputStream(in, Env.FILE_BUFSIZE);
                    ExcelTool importer = new ExcelTool(in, false, null);
                    Sequence seq = (Sequence)importer.fileXlsImport("t");
                    seq = this._$1(this._$4.get(i), seq);
                    if (data == null) {
                        data = seq;
                        continue;
                    }
                    data.append(seq);
                }
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    throw new RQException(e.getMessage(), e);
                }
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (IOException e) {
                    throw new RQException(e.getMessage(), e);
                }
            }
            cursor = new MemoryCursor(data);
        } else if (this._$3 == 4) {
            if (fileCount == 1) {
                FileObject fo = this._$4.get(0);
                XlsxSImporter importer = new XlsxSImporter(fo, null, 0, 0, new Integer(1), "t");
                cursor = UserUtils.newCursor(importer, "t");
                this._$1(fo, cursor);
            } else {
                ICursor[] cursors = new ICursor[fileCount];
                for (int i = 0; i < fileCount; ++i) {
                    FileObject fo = this._$4.get(i);
                    XlsxSImporter importer = new XlsxSImporter(fo, null, 0, 0, new Integer(1), "t");
                    cursors[i] = UserUtils.newCursor(importer, "t");
                    this._$1(fo, cursors[i]);
                }
                cursor = new ConjxCursor(cursors);
            }
        } else if (this._$3 == 5) {
            Sequence data = null;
            for (int i = 0; i < fileCount; ++i) {
                char[] chars;
                FileObject fo = this._$4.get(i);
                try {
                    String str = (String)fo.read(0L, -1L, null);
                    chars = str.toCharArray();
                }
                catch (IOException e) {
                    throw new RQException(e.getMessage(), e);
                }
                Object result = JSONUtil.parseJSON(chars, 0, chars.length - 1);
                if (result instanceof Sequence) {
                    Sequence sequence = (Sequence)result;
                    sequence = this._$1(fo, sequence);
                    if (data == null) {
                        data = sequence;
                        continue;
                    }
                    data.append(sequence);
                    continue;
                }
                if (data == null) {
                    data = new Sequence();
                }
                data.add(result);
            }
            cursor = new MemoryCursor(data);
        } else if (fileCount == 1) {
            FileObject fo = this._$4.get(0);
            PhyTable phyTable = ComTable.openBaseTable(fo, ctx);
            cursor = CreateCursor.createCursor(phyTable, null, "x", ctx);
            this._$1(fo, cursor);
        } else {
            ICursor[] cursors = new ICursor[fileCount];
            for (int i = 0; i < fileCount; ++i) {
                FileObject fo = this._$4.get(i);
                PhyTable phyTable = ComTable.openBaseTable(fo, ctx);
                cursors[i] = CreateCursor.createCursor(phyTable, null, "x", ctx);
                this._$1(fo, cursors[i]);
            }
            cursor = new ConjxCursor(cursors);
        }
        this._$1(cursor);
        return cursor;
    }

    @Override
    public DataStruct getDataStruct() {
        if (this._$2 == null) {
            this.getDataCursor();
        }
        return this._$2;
    }

    @Override
    public Object getData(Select.Exp where) {
        ICursor cs = this.getDataCursor();
        if (where != null && cs != null) {
            String expStr = where.toSPL();
            Context ctx = this.select._$6();
            ICellSet cellSet = this.select._$5();
            Expression exp = new Expression(cellSet, ctx, expStr);
            cs.select(null, exp, null, ctx);
        }
        return cs;
    }
}

