/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query;

import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.query.QueryBody;
import com.scudata.expression.Expression;
import java.util.List;

class WithItem {
    private String name;
    private List<String> columnNames;
    private QueryBody query;
    private Sequence data;

    public WithItem(String name, List<String> columnNames, QueryBody query) {
        this.name = name;
        this.columnNames = columnNames;
        this.query = query;
    }

    public boolean equals(String s) {
        return this.name.equalsIgnoreCase(s);
    }

    public Sequence getData() {
        if (this.data == null) {
            Object value = this.query.getData();
            this.data = value instanceof ICursor ? ((ICursor)value).fetch() : (Sequence)value;
            if (this.columnNames != null && this.columnNames.size() > 0) {
                int fcount = this.columnNames.size();
                String[] names = new String[fcount];
                this.columnNames.toArray(names);
                if (this.data == null || this.data.length() == 0) {
                    this.data = new Table(names);
                    return this.data;
                }
                DataStruct ds = this.data.dataStruct();
                if (!ds.isCompatible(names)) {
                    Context ctx = new Context();
                    Expression[] exps = new Expression[fcount];
                    int f = 0;
                    while (f < fcount) {
                        exps[f] = new Expression(ctx, "#" + (f + 1));
                        ++f;
                    }
                    this.data = this.data.newTable(names, exps, ctx);
                }
            }
        }
        return this.data;
    }
}

