/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.sql;

import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.IntArrayList;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.sql.FunInfoManager;
import com.scudata.dm.sql.Token;
import com.scudata.dm.sql.Tokenizer;
import com.scudata.resources.EngineMessage;

public final class SQLUtil {
    private static DataStruct _$2 = new DataStruct(new String[]{"type", "id", "value"});
    private static String _$1 = "keyword";

    private static Sequence _$1(String sql, Token[] tokens, int index, int endPos) {
        Sequence seq = new Sequence();
        IntArrayList andList = new IntArrayList();
        int count = tokens.length;
        for (int i = index + 1; i < count && tokens[i].getPos() < endPos; ++i) {
            Token token = tokens[i];
            if (token.isKeyWord("AND")) {
                andList.addInt(i);
                continue;
            }
            if (token.isKeyWord("OR")) {
                andList.clear();
                continue;
            }
            if (token.getType() != '(') continue;
            i = Tokenizer.scanParen(tokens, i, count);
        }
        int size = andList.size();
        int prev = tokens[index].getPos();
        for (int i = 0; i < size; ++i) {
            int t = andList.getInt(i);
            String exp = sql.substring(prev, tokens[t].getPos());
            seq.add(exp.trim());
            prev = tokens[t + 1].getPos();
        }
        String exp = sql.substring(prev, endPos);
        seq.add(exp.trim());
        return seq;
    }

    private static int _$1(int p1, Token[] tokens, int len) {
        if (p1 > 0) {
            return tokens[p1].getPos();
        }
        return len;
    }

    private static int _$1(int p1, int p2, Token[] tokens, int len) {
        if (p1 > 0) {
            return tokens[p1].getPos();
        }
        if (p2 > 0) {
            return tokens[p2].getPos();
        }
        return len;
    }

    private static int _$1(int p1, int p2, int p3, Token[] tokens, int len) {
        if (p1 > 0) {
            return tokens[p1].getPos();
        }
        if (p2 > 0) {
            return tokens[p2].getPos();
        }
        if (p3 > 0) {
            return tokens[p3].getPos();
        }
        return len;
    }

    private static int _$1(int p1, int p2, int p3, int p4, Token[] tokens, int len) {
        if (p1 > 0) {
            return tokens[p1].getPos();
        }
        if (p2 > 0) {
            return tokens[p2].getPos();
        }
        if (p3 > 0) {
            return tokens[p3].getPos();
        }
        if (p4 > 0) {
            return tokens[p4].getPos();
        }
        return len;
    }

    public static int scanParen(Token[] tokens, int start, int next) {
        int deep = 0;
        for (int i = start + 1; i < next; ++i) {
            if (tokens[i].getType() == '(') {
                ++deep;
                continue;
            }
            if (tokens[i].getType() != ')') continue;
            if (deep == 0) {
                return i;
            }
            --deep;
        }
        return -1;
    }

    private static int _$2(Token[] tokens, int pos, Record result) {
        return -1;
    }

    private static int _$1(Token[] tokens, int pos, Record result) {
        return -1;
    }

    public static Sequence splitSql(String sql) {
        int end;
        Record r;
        Token[] tokens = Tokenizer.parse(sql);
        int len = tokens.length;
        if (len == 0) {
            return null;
        }
        Sequence result = new Sequence();
        int pos = 0;
        Token token = tokens[0];
        if (token.isKeyWord("WITH")) {
            r = new Record(_$2);
            r.setNormalFieldValue(0, _$1);
            r.setNormalFieldValue(1, "WITH");
            end = SQLUtil._$2(tokens, 0, r);
            result.add(r);
            if (end < len) {
                pos = end;
                token = tokens[pos];
            } else {
                return result;
            }
        }
        if (token.isKeyWord("SELECT")) {
            r = new Record(_$2);
            r.setNormalFieldValue(0, _$1);
            r.setNormalFieldValue(1, "SELECT");
            end = SQLUtil._$1(tokens, 0, r);
            result.add(r);
            if (end < len) {
                pos = end;
                token = tokens[pos];
            } else {
                return result;
            }
        }
        return null;
    }

    public static Object parse(String sql, String option) {
        Sequence seq;
        Sequence seq2;
        ArgumentTokenizer arg;
        boolean isSelect = false;
        boolean isFrom = false;
        boolean isWhere = false;
        boolean isGroupBy = false;
        boolean isHaving = false;
        boolean isOrderBy = false;
        boolean isArray = false;
        boolean isAll = true;
        if (option != null) {
            if (option.indexOf(115) != -1) {
                isSelect = true;
                isAll = false;
            }
            if (option.indexOf(102) != -1) {
                isFrom = true;
                isAll = false;
            }
            if (option.indexOf(119) != -1) {
                isWhere = true;
                isAll = false;
            }
            if (option.indexOf(103) != -1) {
                isGroupBy = true;
                isAll = false;
            }
            if (option.indexOf(104) != -1) {
                isHaving = true;
                isAll = false;
            }
            if (option.indexOf(111) != -1) {
                isOrderBy = true;
                isAll = false;
            }
            if (option.indexOf(97) != -1) {
                isArray = true;
            }
        }
        int len = sql.length();
        Token[] tokens = Tokenizer.parse(sql);
        int select = -1;
        int count = tokens.length;
        for (int i = 0; i < count; ++i) {
            if (tokens[i].isKeyWord("SELECT")) {
                select = i;
                break;
            }
            if (tokens[i].getType() != '(' || (i = SQLUtil.scanParen(tokens, i, count)) != -1) continue;
            return null;
        }
        if (select == -1) {
            return null;
        }
        int from = -1;
        for (int i = select + 1; i < count; ++i) {
            if (tokens[i].isKeyWord("FROM")) {
                from = i;
                break;
            }
            if (tokens[i].getType() != '(' || (i = SQLUtil.scanParen(tokens, i, count)) != -1) continue;
            return null;
        }
        if (from == -1) {
            return null;
        }
        int where = -1;
        int group = -1;
        int having = -1;
        int order = -1;
        for (int i = from + 1; i < count; ++i) {
            if (where == -1 && tokens[i].isKeyWord("WHERE")) {
                where = i;
                continue;
            }
            if (group == -1 && tokens[i].isKeyWord("GROUP")) {
                group = i;
                continue;
            }
            if (having == -1 && tokens[i].isKeyWord("HAVING")) {
                having = i;
                continue;
            }
            if (order == -1 && tokens[i].isKeyWord("ORDER")) {
                order = i;
                continue;
            }
            if (tokens[i].getType() != '(' || (i = SQLUtil.scanParen(tokens, i, count)) != -1) continue;
            return null;
        }
        if (isAll) {
            Sequence seq3;
            ArgumentTokenizer arg2;
            Sequence seq4;
            Sequence result = new Sequence(6);
            String cols = sql.substring(tokens[select + 1].getPos(), tokens[from].getPos());
            cols = cols.trim();
            if (isArray) {
                ArgumentTokenizer arg3 = new ArgumentTokenizer(cols);
                seq4 = new Sequence();
                result.add(seq4);
                while (arg3.hasMoreElements()) {
                    seq4.add(arg3.nextElement());
                }
            } else {
                result.add(cols);
            }
            String tables = sql.substring(tokens[from + 1].getPos(), SQLUtil._$1(where, group, having, order, tokens, len));
            result.add(tables.trim());
            if (where == -1) {
                result.add(null);
            } else if (isArray) {
                seq4 = SQLUtil._$1(sql, tokens, where + 1, SQLUtil._$1(group, having, order, tokens, len));
                result.add(seq4);
            } else {
                String whereExp = sql.substring(tokens[where + 1].getPos(), SQLUtil._$1(group, having, order, tokens, len));
                result.add(whereExp.trim());
            }
            if (group == -1) {
                result.add(null);
            } else {
                if (++group == count || !tokens[group].isKeyWord("BY")) {
                    throw new RQException("Invalid group.");
                }
                String groupExp = sql.substring(tokens[group + 1].getPos(), SQLUtil._$1(having, order, tokens, len));
                groupExp = groupExp.trim();
                if (isArray) {
                    arg2 = new ArgumentTokenizer(groupExp);
                    seq3 = new Sequence();
                    result.add(seq3);
                    while (arg2.hasMoreElements()) {
                        seq3.add(arg2.nextElement());
                    }
                } else {
                    result.add(groupExp);
                }
            }
            if (having == -1) {
                result.add(null);
            } else if (isArray) {
                seq4 = SQLUtil._$1(sql, tokens, having + 1, SQLUtil._$1(order, tokens, len));
                result.add(seq4);
            } else {
                String havingExp = sql.substring(tokens[having + 1].getPos(), SQLUtil._$1(order, tokens, len));
                result.add(havingExp.trim());
            }
            if (order == -1) {
                result.add(null);
            } else {
                if (++order == count || !tokens[order].isKeyWord("BY")) {
                    throw new RQException("Invalid order.");
                }
                String orderExp = sql.substring(tokens[order + 1].getPos());
                orderExp = orderExp.trim();
                if (isArray) {
                    arg2 = new ArgumentTokenizer(orderExp);
                    seq3 = new Sequence();
                    result.add(seq3);
                    while (arg2.hasMoreElements()) {
                        seq3.add(arg2.nextElement());
                    }
                } else {
                    result.add(orderExp);
                }
            }
            return result;
        }
        Sequence result = new Sequence(6);
        if (isSelect) {
            String cols = sql.substring(tokens[select + 1].getPos(), tokens[from].getPos());
            cols = cols.trim();
            if (isArray) {
                arg = new ArgumentTokenizer(cols);
                seq2 = new Sequence();
                result.add(seq2);
                while (arg.hasMoreElements()) {
                    seq2.add(arg.nextElement());
                }
            } else {
                result.add(cols);
            }
        }
        if (isFrom) {
            String tables = sql.substring(tokens[from + 1].getPos(), SQLUtil._$1(where, group, having, order, tokens, len));
            result.add(tables.trim());
        }
        if (isWhere) {
            if (where == -1) {
                result.add(null);
            } else if (isArray) {
                seq = SQLUtil._$1(sql, tokens, where + 1, SQLUtil._$1(group, having, order, tokens, len));
                result.add(seq);
            } else {
                String whereExp = sql.substring(tokens[where + 1].getPos(), SQLUtil._$1(group, having, order, tokens, len));
                result.add(whereExp.trim());
            }
        }
        if (isGroupBy) {
            if (group == -1) {
                result.add(null);
            } else {
                if (++group == count || !tokens[group].isKeyWord("BY")) {
                    throw new RQException("Invalid group.");
                }
                String groupExp = sql.substring(tokens[group + 1].getPos(), SQLUtil._$1(having, order, tokens, len));
                groupExp = groupExp.trim();
                if (isArray) {
                    arg = new ArgumentTokenizer(groupExp);
                    seq2 = new Sequence();
                    result.add(seq2);
                    while (arg.hasMoreElements()) {
                        seq2.add(arg.nextElement());
                    }
                } else {
                    result.add(groupExp);
                }
            }
        }
        if (isHaving) {
            if (having == -1) {
                result.add(null);
            } else if (isArray) {
                seq = SQLUtil._$1(sql, tokens, having + 1, SQLUtil._$1(order, tokens, len));
                result.add(seq);
            } else {
                String havingExp = sql.substring(tokens[having + 1].getPos(), SQLUtil._$1(order, tokens, len));
                result.add(havingExp.trim());
            }
        }
        if (isOrderBy) {
            if (order == -1) {
                result.add(null);
            } else {
                if (++order == count || !tokens[order].isKeyWord("BY")) {
                    throw new RQException("Invalid order.");
                }
                String orderExp = sql.substring(tokens[order + 1].getPos());
                orderExp = orderExp.trim();
                if (isArray) {
                    arg = new ArgumentTokenizer(orderExp);
                    seq2 = new Sequence();
                    result.add(seq2);
                    while (arg.hasMoreElements()) {
                        seq2.add(arg.nextElement());
                    }
                } else {
                    result.add(orderExp);
                }
            }
        }
        if (result.length() == 1) {
            return result.get(1);
        }
        return result;
    }

    public static String replace(String sql, String replacement, String option) {
        String keyWord;
        if (option == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("sqlparse" + mm.getMessage("engine.optError"));
        }
        if (replacement == null) {
            replacement = "";
        }
        Token[] tokens = Tokenizer.parse(sql);
        int count = tokens.length;
        int keyPos = -1;
        int start = -1;
        int end = -1;
        if (option.indexOf(115) != -1) {
            int i;
            keyWord = "SELECT";
            for (i = 0; i < count; ++i) {
                if (tokens[i].isKeyWord("SELECT")) {
                    keyPos = i;
                    start = i;
                    break;
                }
                if (tokens[i].getType() != '(' || (i = SQLUtil.scanParen(tokens, i, count)) != -1) continue;
                return sql;
            }
            if (start == -1) {
                return sql;
            }
            for (i = ++start; i < count; ++i) {
                Token token = tokens[i];
                if (token.isKeyWord("FROM")) {
                    end = i;
                    break;
                }
                if (token.isKeyWord("TOP")) {
                    start = ++i + 1;
                    continue;
                }
                if (token.isKeyWord("DISTINCT")) {
                    start = i + 1;
                    continue;
                }
                if (token.getType() != '(' || (i = SQLUtil.scanParen(tokens, i, count)) != -1) continue;
                return sql;
            }
            if (end == -1) {
                return sql;
            }
        } else {
            int i;
            String[] endKeyWords;
            String startKeyWord;
            if (option.indexOf(102) != -1) {
                startKeyWord = "FROM";
                keyWord = "FROM";
                endKeyWords = new String[]{"WHERE", "GROUP", "HAVING", "ORDER", "LIMIT"};
            } else if (option.indexOf(119) != -1) {
                startKeyWord = "WHERE";
                keyWord = "WHERE";
                endKeyWords = new String[]{"GROUP", "HAVING", "ORDER", "LIMIT"};
            } else if (option.indexOf(103) != -1) {
                startKeyWord = "GROUP";
                keyWord = "GROUP BY";
                endKeyWords = new String[]{"HAVING", "ORDER", "LIMIT"};
            } else if (option.indexOf(104) != -1) {
                startKeyWord = "HAVING";
                keyWord = "HAVING";
                endKeyWords = new String[]{"ORDER", "LIMIT"};
            } else if (option.indexOf(111) != -1) {
                startKeyWord = "ORDER";
                keyWord = "ORDER BY";
                endKeyWords = new String[]{"LIMIT"};
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException("sqlparse" + mm.getMessage("engine.optError"));
            }
            for (int i2 = 0; i2 < count; ++i2) {
                if (tokens[i2].isKeyWord(startKeyWord)) {
                    keyPos = i2;
                    start = i2 + 1;
                    if (start >= count || !tokens[start].isKeyWord("BY")) break;
                    ++start;
                    break;
                }
                if (tokens[i2].getType() != '(' || (i2 = SQLUtil.scanParen(tokens, i2, count)) != -1) continue;
                return sql;
            }
            int len = endKeyWords.length;
            int n = i = start == -1 ? 0 : start;
            block3: while (i < count) {
                Token token = tokens[i];
                if (token.isKeyWord()) {
                    for (int k = 0; k < len; ++k) {
                        if (!token.isKeyWord(endKeyWords[k])) continue;
                        end = i;
                        break block3;
                    }
                } else if (token.getType() == '(' && (i = SQLUtil.scanParen(tokens, i, count)) == -1) {
                    return sql;
                }
                ++i;
            }
        }
        if (start == -1) {
            if (replacement.length() == 0) {
                return sql;
            }
            if (end == -1) {
                return sql + ' ' + keyWord + ' ' + replacement;
            }
            int endPos = tokens[end].getPos();
            return sql.substring(0, endPos) + keyWord + ' ' + replacement + sql.substring(endPos - 1);
        }
        if (start == count) {
            if (replacement.length() == 0) {
                int startPos = tokens[keyPos].getPos();
                return sql.substring(0, startPos);
            }
            return sql + ' ' + replacement;
        }
        if (replacement.length() == 0) {
            start = keyPos;
        }
        int startPos = tokens[start].getPos();
        if (end == -1) {
            return sql.substring(0, startPos) + replacement;
        }
        int endPos = tokens[end].getPos();
        return sql.substring(0, startPos) + replacement + sql.substring(endPos - 1);
    }

    public static String translate(String sql, String dbType) {
        Token[] tokens = Tokenizer.parse(sql);
        int count = tokens.length;
        int prevPos = 0;
        String rowNum = null;
        StringBuffer sb = new StringBuffer(sql.length() * 2);
        int last = count - 1;
        for (int i = 0; i < last; ++i) {
            Token token = tokens[i];
            if (tokens[i + 1].getType() == '(' && FunInfoManager.isFunction(dbType, token.getString())) {
                int match = Tokenizer.scanParen(tokens, i + 1, count);
                String exp = SQLUtil._$1(sql, tokens, i, match, dbType);
                if (exp != null) {
                    sb.append(sql.substring(prevPos, token.getPos()));
                    sb.append(exp);
                    prevPos = tokens[match].getPos() + 1;
                    i = match;
                    continue;
                }
                ++i;
                continue;
            }
            if (!token.isKeyWord("TOP") || tokens[i + 1].getType() != '\u0003') continue;
            if ("ORACLE".endsWith(dbType) || "DB2".endsWith(dbType) || "MYSQL".endsWith(dbType) || "HSQL".endsWith(dbType) || "POSTGRES".endsWith(dbType) || "HIVE".endsWith(dbType) || "IMPALA".endsWith(dbType) || "GREENPLUM".endsWith(dbType)) {
                rowNum = tokens[++i].getString();
                sb.append(sql.substring(prevPos, token.getPos()));
                prevPos = tokens[i].getPos() + rowNum.length();
                continue;
            }
            if (!"INFMIX".endsWith(dbType)) continue;
            sb.append(sql.substring(prevPos, token.getPos()));
            sb.append(" FIRST ");
            sb.append(tokens[++i].getString());
            prevPos = tokens[i].getPos() + tokens[i].getString().length();
        }
        if (sb.length() == 0) {
            return sql;
        }
        sb.append(sql.substring(prevPos));
        if (rowNum != null) {
            if ("ORACLE".endsWith(dbType)) {
                sb.insert(0, "SELECT * FROM (");
                sb.append(")t WHERE ROWNUM<=");
                sb.append(rowNum);
            } else if ("DB2".endsWith(dbType)) {
                sb.append(" FETCH FIRST ");
                sb.append(rowNum);
                sb.append(" ROWS ONLY");
            } else if ("MYSQL".endsWith(dbType) || "HSQL".endsWith(dbType) || "POSTGRES".endsWith(dbType) || "HIVE".endsWith(dbType) || "IMPALA".endsWith(dbType) || "GREENPLUM".endsWith(dbType)) {
                sb.append(" LIMIT ");
                sb.append(rowNum);
            } else {
                throw new RQException();
            }
        }
        return sb.toString();
    }

    private static String _$2(String sql, Token[] tokens, int start, int end, String dbType) {
        StringBuffer sb = new StringBuffer();
        int prevPos = tokens[start].getPos();
        for (int i = start; i < end; ++i) {
            Token token = tokens[i];
            if (tokens[i + 1].getType() != '(' || !FunInfoManager.isFunction(dbType, token.getString())) continue;
            int match = Tokenizer.scanParen(tokens, i + 1, end);
            String exp = SQLUtil._$1(sql, tokens, i, match, dbType);
            if (exp != null) {
                sb.append(sql.substring(prevPos, token.getPos()));
                sb.append(exp);
                prevPos = tokens[match].getPos() + 1;
                i = match;
                continue;
            }
            ++i;
        }
        if (sb.length() == 0) {
            return null;
        }
        sb.append(sql.substring(prevPos, tokens[end].getPos()));
        return sb.toString();
    }

    private static String _$1(String sql, Token[] tokens, int start, int next, String dbType) {
        int p;
        String name = tokens[start].getString();
        if ((start += 2) == next) {
            return FunInfoManager.getFunctionExp(dbType, name, new String[0]);
        }
        IntArrayList commaList = new IntArrayList();
        int i = start;
        while (i < next && (p = Tokenizer.scanComma(tokens, i, next)) > 0) {
            commaList.addInt(p);
            i = p + 1;
        }
        int commaCount = commaList.size();
        int pcount = commaCount + 1;
        String[] params = new String[pcount];
        for (int i2 = 0; i2 < commaCount; ++i2) {
            int pos = commaList.getInt(i2);
            params[i2] = SQLUtil._$2(sql, tokens, start, pos, dbType);
            if (params[i2] == null) {
                params[i2] = sql.substring(tokens[start].getPos(), tokens[pos].getPos());
            }
            start = pos + 1;
        }
        params[commaCount] = SQLUtil._$2(sql, tokens, start, next, dbType);
        if (params[commaCount] == null) {
            params[commaCount] = sql.substring(tokens[start].getPos(), tokens[next].getPos());
        }
        return FunInfoManager.getFunctionExp(dbType, name, params);
    }
}

