/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.dm.Sequence;
import com.scudata.dw.BlockLink;
import com.scudata.dw.BufferReader;
import com.scudata.dw.IBlockStorage;
import com.scudata.dw.LZ4Util;
import com.scudata.dw.PureBufferReader;
import com.scudata.dw.RowBufferReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class BlockLinkReader
extends InputStream {
    private BlockLink _$12;
    private IBlockStorage _$11;
    private final int _$10;
    private final int _$9;
    private long _$8 = Long.MAX_VALUE;
    private byte[] _$7;
    private int _$6;
    private byte[] _$5 = new byte[32];
    private LZ4Util _$4 = LZ4Util.instance();
    private byte[] _$3;
    private boolean _$2;
    private Sequence _$1;

    public BlockLinkReader(BlockLink blockLink) {
        this(blockLink, 0);
    }

    public BlockLinkReader(BlockLink blockLink, int sbLen) {
        this._$12 = blockLink;
        this._$11 = blockLink.getBlockStorage();
        this._$10 = this._$11.getBlockSize();
        this._$9 = this._$10 - 5;
        this._$7 = new byte[this._$10];
        this._$2 = this._$11.isPureFormat();
    }

    public BlockLinkReader(BlockLinkReader blockLinkReader) {
        this._$12 = blockLinkReader._$12;
        this._$11 = blockLinkReader._$11;
        this._$10 = blockLinkReader._$10;
        this._$9 = blockLinkReader._$9;
        this._$8 = blockLinkReader._$8;
        this._$7 = Arrays.copyOf(blockLinkReader._$7, this._$10);
        this._$6 = blockLinkReader._$6;
        this._$3 = new byte[4096];
        this._$2 = this._$11.isPureFormat();
        this._$1 = blockLinkReader._$1;
    }

    public void close() {
        this._$7 = null;
    }

    void _$2(int size) {
        this._$3 = new byte[size];
    }

    public void loadFirstBlock() throws IOException {
        this.loadBlock(this._$12._$4);
    }

    public void loadBlock(long pos) throws IOException {
        this._$8 = pos;
        this._$11.loadBlock(pos, this._$7);
        this._$6 = 0;
    }

    public int read() throws IOException {
        if (this._$6 == this._$9) {
            this.loadBlock(this._$1(this._$9));
        }
        return this._$7[this._$6++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int freeSize;
        int count = len;
        while (true) {
            if (len <= (freeSize = this._$9 - this._$6)) {
                System.arraycopy(this._$7, this._$6, b, off, len);
                this._$6 += len;
                return count;
            }
            System.arraycopy(this._$7, this._$6, b, off, freeSize);
            if (this._$8 >= this._$12._$3) break;
            off += freeSize;
            len -= freeSize;
            this.loadBlock(this._$1(this._$9));
        }
        this._$6 = this._$9;
        return count - len + freeSize;
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        while (true) {
            int freeSize;
            if (len <= (freeSize = this._$9 - this._$6)) {
                System.arraycopy(this._$7, this._$6, b, off, len);
                this._$6 += len;
                break;
            }
            System.arraycopy(this._$7, this._$6, b, off, freeSize);
            off += freeSize;
            len -= freeSize;
            this.loadBlock(this._$1(this._$9));
        }
    }

    public int readInt32() throws IOException {
        if (this._$9 - this._$6 >= 4) {
            byte[] data = this._$7;
            int index = this._$6;
            this._$6 += 4;
            return (data[index] << 24) + ((data[index + 1] & 0xFF) << 16) + ((data[index + 2] & 0xFF) << 8) + (data[index + 3] & 0xFF);
        }
        byte[] readBuffer = this._$5;
        this.readFully(readBuffer, 0, 4);
        return (readBuffer[0] << 24) + ((readBuffer[1] & 0xFF) << 16) + ((readBuffer[2] & 0xFF) << 8) + (readBuffer[3] & 0xFF);
    }

    public byte[] readDataBlock() throws IOException {
        int srcCount = this.readInt32();
        if (this._$11.isCompress()) {
            int count = this.readInt32();
            if (count > 0) {
                byte[] buffer = new byte[count];
                this.readFully(buffer, 0, count);
                if (srcCount > this._$3.length) {
                    this._$3 = new byte[srcCount];
                }
                this._$4.decompress(buffer, this._$3, srcCount);
                return this._$3;
            }
            byte[] buffer = new byte[srcCount];
            this.readFully(buffer, 0, srcCount);
            return buffer;
        }
        byte[] buffer = new byte[srcCount];
        this.readFully(buffer, 0, srcCount);
        return buffer;
    }

    public byte[] readDataBlock0() throws IOException {
        byte[] readBuffer = this._$5;
        this.readFully(readBuffer, 0, 4);
        int srcCount = (readBuffer[0] << 24) + ((readBuffer[1] & 0xFF) << 16) + ((readBuffer[2] & 0xFF) << 8) + (readBuffer[3] & 0xFF);
        if (this._$11.isCompress()) {
            this.readFully(readBuffer, 4, 4);
            int count = (readBuffer[4] << 24) + ((readBuffer[5] & 0xFF) << 16) + ((readBuffer[6] & 0xFF) << 8) + (readBuffer[7] & 0xFF);
            if (count > 0) {
                byte[] buffer = new byte[count + 8];
                this.readFully(buffer, 8, count);
                System.arraycopy(readBuffer, 0, buffer, 0, 8);
                return buffer;
            }
            byte[] buffer = new byte[srcCount + 8];
            this.readFully(buffer, 8, srcCount);
            System.arraycopy(readBuffer, 0, buffer, 0, 8);
            return buffer;
        }
        byte[] buffer = new byte[srcCount + 4];
        this.readFully(buffer, 4, srcCount);
        System.arraycopy(readBuffer, 0, buffer, 0, 4);
        return buffer;
    }

    private long _$1(long pos) {
        return pos - pos % (long)this._$10;
    }

    public void seek(long pos) throws IOException {
        long blockPos = this._$1(pos);
        if (blockPos != this._$8) {
            this._$11.loadBlock(blockPos, this._$7);
            this._$8 = blockPos;
        }
        this._$6 = (int)(pos - blockPos);
    }

    public byte[] readDataBlock(long pos) throws IOException {
        this.seek(pos);
        return this.readDataBlock();
    }

    private long _$1(int i) {
        byte[] block = this._$7;
        return ((long)(block[i] & 0xFF) << 32) + ((long)(block[i + 1] & 0xFF) << 24) + (long)((block[i + 2] & 0xFF) << 16) + (long)((block[i + 3] & 0xFF) << 8) + (long)(block[i + 4] & 0xFF);
    }

    public byte[] readBlocks() throws IOException {
        int blockCount = this._$12._$1;
        if (blockCount > 1) {
            byte[] bytes = new byte[this._$9 * blockCount];
            long blockPos = this._$12._$4;
            int i = 0;
            int j = 0;
            while (i < blockCount) {
                this._$11.loadBlock(blockPos, this._$7);
                System.arraycopy(this._$7, 0, bytes, j, this._$9);
                blockPos = this._$1(this._$9);
                ++i;
                j += this._$9;
            }
            return bytes;
        }
        this._$11.loadBlock(this._$12._$4, this._$7);
        return this._$7;
    }

    public BufferReader readBlockData(int recordCount) throws IOException {
        return this._$1(this.readDataBlock(), recordCount);
    }

    public BufferReader readBlockData(long pos, int recordCount) throws IOException {
        byte[] buffer = this.readDataBlock(pos);
        return this._$1(buffer, recordCount);
    }

    public BufferReader readPureBlockData(int recordCount) throws IOException {
        return new BufferReader(this._$11.getStructManager(), this.readDataBlock());
    }

    public BufferReader readPureBlockData(long pos, int recordCount) throws IOException {
        return new BufferReader(this._$11.getStructManager(), this.readDataBlock(pos));
    }

    private BufferReader _$1(byte[] buffer, int recordCount) {
        if (this._$2) {
            if (PureBufferReader.canUseBufferReader(buffer, 0)) {
                BufferReader reader = new BufferReader(this._$11.getStructManager(), buffer);
                ++reader.index;
                return reader;
            }
            return new PureBufferReader(this._$11.getStructManager(), buffer, recordCount, this._$1);
        }
        return new BufferReader(this._$11.getStructManager(), buffer);
    }

    public RowBufferReader readBlockBuffer() throws IOException {
        int count = this.readInt32();
        byte[] buffer = new byte[count];
        this.readFully(buffer, 0, count);
        return new RowBufferReader(this._$11.getStructManager(), buffer);
    }

    public BufferReader readBlockBuffer(long pos) throws IOException {
        this.seek(pos);
        int count = this.readInt32();
        byte[] buffer = new byte[count];
        this.readFully(buffer, 0, count);
        return new BufferReader(this._$11.getStructManager(), buffer);
    }

    public long position() {
        return this._$8;
    }

    public int getCaret() {
        return this._$6;
    }

    public IBlockStorage getStorage() {
        return this._$11;
    }

    public Sequence getDict() {
        return this._$1;
    }

    public void setDict(Sequence dict) {
        this._$1 = dict;
    }
}

