/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.DateCache;
import com.scudata.common.ObjectCache;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.SerialBytes;
import com.scudata.dm.Table;
import com.scudata.dw.BufferWriter;
import com.scudata.dw.StructManager;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class BufferReader {
    protected StructManager structManager;
    public byte[] buffer;
    public int index;
    public int count;
    private byte[] _$5 = new byte[32];
    protected char[] charBuffer = new char[128];
    public Object repeatValue;
    public int repeatCount = 0;
    protected static final String[] HEXSTRINGS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    private static final Long _$4 = new Long(0L);
    private static final Double _$3 = new Double(0.0);
    private static final BigDecimal _$2 = new BigDecimal(BigInteger.ZERO);
    protected static final Integer[] INT15 = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15)};
    private static final Object _$1 = new Object();

    public BufferReader(StructManager structManager, byte[] buffer) {
        this.structManager = structManager;
        this.buffer = buffer;
        this.count = buffer.length;
    }

    public BufferReader(StructManager structManager, byte[] buffer, int index, int count) {
        this.structManager = structManager;
        this.buffer = buffer;
        this.index = index;
        this.count = count;
    }

    public long position() {
        return this.index;
    }

    public void skipFully(int n) throws IOException {
        int total = this.count - this.index;
        if (total >= n) {
            this.index += n;
        } else {
            this.index = this.count;
            throw new EOFException();
        }
    }

    public int skipBytes(int n) throws IOException {
        if (n < 1) {
            return 0;
        }
        int total = this.count - this.index;
        if (total >= n) {
            this.index += n;
            return n;
        }
        this.index = this.count;
        return total;
    }

    public long skip(long n) throws IOException {
        if (n < 1L) {
            return 0L;
        }
        long total = this.count - this.index;
        if (total >= n) {
            this.index += (int)n;
            return n;
        }
        this.index = this.count;
        return total;
    }

    public boolean hasNext() throws IOException {
        return this.count > this.index;
    }

    public int available() throws IOException {
        return this.count - this.index;
    }

    public void reset() {
        this.index = 0;
        this.repeatCount = 0;
    }

    public void close() throws IOException {
        this.index = this.count;
    }

    public boolean readBoolean() throws IOException {
        return this.buffer[this.index++] != 0;
    }

    public int get() throws IOException {
        return this.buffer[this.index] & 0xFF;
    }

    public int read() throws IOException {
        return this.buffer[this.index++] & 0xFF;
    }

    protected int read2() throws IOException {
        return this.buffer[this.index++] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int total = this.count - this.index;
        if (total >= len) {
            System.arraycopy(this.buffer, this.index, b, off, len);
            this.index += len;
            return len;
        }
        if (total > 0) {
            System.arraycopy(this.buffer, this.index, b, off, total);
            this.index = this.count;
            return total;
        }
        return -1;
    }

    public void readFully(byte[] b) throws IOException {
        if (this.read(b, 0, b.length) != b.length) {
            throw new EOFException();
        }
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (this.read(b, off, len) != len) {
            throw new EOFException();
        }
    }

    public byte readByte() throws IOException {
        return this.buffer[this.index++];
    }

    public int readUnsignedByte() throws IOException {
        return this.buffer[this.index++] & 0xFF;
    }

    public short readShort() throws IOException {
        int ch1 = this.buffer[this.index++] << 8;
        return (short)(ch1 + (this.buffer[this.index++] & 0xFF));
    }

    public int readUnsignedShort() throws IOException {
        int ch1 = (this.buffer[this.index++] & 0xFF) << 8;
        return ch1 + (this.buffer[this.index++] & 0xFF);
    }

    public char readChar() throws IOException {
        int ch1 = this.buffer[this.index++] << 8;
        return (char)(ch1 + (this.buffer[this.index++] & 0xFF));
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        int b = this.read2();
        if (b == 21) {
            int n = this.readUInt16();
            int scale = n >>> 14;
            n &= 0x3FFF;
            if (scale == 0) {
                return n;
            }
            if (scale == 1) {
                return (double)n / 100.0;
            }
            if (scale == 2) {
                return (double)n / 10000.0;
            }
            return n * 100;
        }
        if (b == 22) {
            int n = this.readInt32();
            int scale = n >>> 30;
            n &= 0x3FFFFFFF;
            if (scale == 0) {
                return n;
            }
            if (scale == 1) {
                return (double)n / 100.0;
            }
            if (scale == 2) {
                return (double)n / 10000.0;
            }
            return (double)n * 100.0;
        }
        return Double.longBitsToDouble(this.readLong64());
    }

    public String readLine() throws IOException {
        throw new IOException("readLine not supported");
    }

    public String readUTF() throws IOException {
        return this.readString();
    }

    public byte[] readByteArray() throws IOException {
        int len = this.readInt();
        if (len < 0) {
            return null;
        }
        byte[] buf = new byte[len];
        this.readFully(buf, 0, len);
        return buf;
    }

    public String[] readStrings() throws IOException {
        int len = this.readInt();
        if (len < 0) {
            return null;
        }
        String[] strs = new String[len];
        for (int i = 0; i < len; ++i) {
            strs[i] = this.readString();
        }
        return strs;
    }

    public String readString() throws IOException {
        int b = this.read2();
        if (b == 0) {
            return null;
        }
        int t1 = b & 0xF0;
        if (t1 == 224 || t1 == 240) {
            return this.readStringAssic(b & 0x1F);
        }
        if (t1 == 192 || t1 == 208) {
            return this.readString(b & 0x1F);
        }
        if (t1 == 176) {
            return this.readDigits(b & 0xF);
        }
        if (t1 == 160) {
            return HEXSTRINGS[b & 0xF];
        }
        int n = this.readInt();
        return this.readString(n);
    }

    protected String readDigits(int size) throws IOException {
        char[] chars;
        int len;
        byte[] readBuffer = this._$5;
        this.readFully(readBuffer, 0, size);
        int b = readBuffer[size - 1] & 0xFF;
        int low = b & 0xF;
        if (low > 9) {
            len = 2 * size - 1;
            chars = new char[len];
            chars[len - 1] = (char)(48 + (b >>> 4));
        } else {
            len = 2 * size;
            chars = new char[len];
            chars[len - 2] = (char)(48 + (b >>> 4));
            chars[len - 1] = (char)(48 + low);
        }
        --size;
        int q = 0;
        for (int i = 0; i < size; ++i) {
            b = readBuffer[i] & 0xFF;
            chars[q++] = (char)(48 + (b >>> 4));
            chars[q++] = (char)(48 + (b & 0xF));
        }
        return new String(chars);
    }

    protected String readString(int size) throws IOException {
        byte[] bytearr;
        if (size == 0) {
            return "";
        }
        char[] charBuffer = this.charBuffer;
        if (size > charBuffer.length) {
            this.charBuffer = charBuffer = new char[size];
        }
        int seq = 0;
        int i = 0;
        if (this.count - this.index >= size) {
            bytearr = this.buffer;
            i = this.index;
            this.index += size;
            size += i;
        } else {
            bytearr = new byte[size];
            this.readFully(bytearr, 0, size);
        }
        block5: while (i < size) {
            int c = bytearr[i] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++i;
                    charBuffer[seq++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((i += 2) > size) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[i - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    charBuffer[seq++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((i += 3) > size) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[i - 2];
                    byte char3 = bytearr[i - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    charBuffer[seq++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        if (seq == 1) {
            return ObjectCache.getString(charBuffer);
        }
        return new String(charBuffer, 0, seq);
    }

    protected String readStringAssic(int size) throws IOException {
        if (size == 0) {
            return "";
        }
        String str = size == 1 ? ObjectCache.getString(this.buffer[this.index]) : new String(this.buffer, this.index, size);
        this.index += size;
        return str;
    }

    public long readLong() throws IOException {
        int b = this.read2();
        if (b == 3) {
            return 0L;
        }
        if (b == 18) {
            return this.readUInt16();
        }
        if (b == 19) {
            return this.readInt32();
        }
        return this.readLong64();
    }

    public int readInt() throws IOException {
        int b = this.read2();
        if (b == 16) {
            return this.readUInt16();
        }
        if (b == 17) {
            return this.readInt32();
        }
        if ((b & 0xF0) == 144) {
            return ((b & 0xF) << 8) + this.read2();
        }
        return b & 0xF;
    }

    protected int readUInt16() throws IOException {
        int n = ((this.buffer[this.index] & 0xFF) << 8) + (this.buffer[this.index + 1] & 0xFF);
        this.index += 2;
        return n;
    }

    private int _$9() throws IOException {
        byte[] data = this.buffer;
        int index = this.index;
        this.index += 3;
        return ((data[index] & 0xFF) << 16) + ((data[index + 1] & 0xFF) << 8) + (data[index + 2] & 0xFF);
    }

    public int readInt32() throws IOException {
        byte[] data = this.buffer;
        int index = this.index;
        this.index += 4;
        return (data[index] << 24) + ((data[index + 1] & 0xFF) << 16) + ((data[index + 2] & 0xFF) << 8) + (data[index + 3] & 0xFF);
    }

    private long _$8() throws IOException {
        byte[] data = this.buffer;
        int index = this.index;
        this.index += 4;
        return ((long)(data[index] & 0xFF) << 24) + (long)((data[index + 1] & 0xFF) << 16) + (long)((data[index + 2] & 0xFF) << 8) + (long)(data[index + 3] & 0xFF);
    }

    public long readLong40() throws IOException {
        byte[] data = this.buffer;
        int index = this.index;
        this.index += 5;
        return ((long)(data[index] & 0xFF) << 32) + ((long)(data[index + 1] & 0xFF) << 24) + (long)((data[index + 2] & 0xFF) << 16) + (long)((data[index + 3] & 0xFF) << 8) + (long)(data[index + 4] & 0xFF);
    }

    public long readLong48() throws IOException {
        byte[] data = this.buffer;
        int index = this.index;
        this.index += 6;
        return ((long)(data[index] & 0xFF) << 40) + ((long)(data[index + 1] & 0xFF) << 32) + ((long)(data[index + 2] & 0xFF) << 24) + (long)((data[index + 3] & 0xFF) << 16) + (long)((data[index + 4] & 0xFF) << 8) + (long)(data[index + 5] & 0xFF);
    }

    public long readLong64() throws IOException {
        byte[] data = this.buffer;
        int index = this.index;
        this.index += 8;
        return ((long)data[index] << 56) + ((long)(data[index + 1] & 0xFF) << 48) + ((long)(data[index + 2] & 0xFF) << 40) + ((long)(data[index + 3] & 0xFF) << 32) + ((long)(data[index + 4] & 0xFF) << 24) + (long)((data[index + 5] & 0xFF) << 16) + (long)((data[index + 6] & 0xFF) << 8) + (long)(data[index + 7] & 0xFF);
    }

    protected Object readMark0(int b) throws IOException {
        switch (b) {
            case 0: {
                return null;
            }
            case 4: {
                return _$3;
            }
            case 5: {
                return _$2;
            }
            case 3: {
                return _$4;
            }
            case 1: {
                return Boolean.TRUE;
            }
            case 2: {
                return Boolean.FALSE;
            }
        }
        return _$1;
    }

    protected Object readMark1(int b) throws IOException {
        switch (b) {
            case 16: {
                return ObjectCache.getInteger(this.readUInt16());
            }
            case 17: {
                return new Integer(this.readInt32());
            }
            case 21: {
                int n = this.readUInt16();
                switch (n >>> 14) {
                    case 0: {
                        return new Double(n & 0x3FFF);
                    }
                    case 1: {
                        return new Double((double)(n & 0x3FFF) / 100.0);
                    }
                    case 2: {
                        return new Double((double)(n & 0x3FFF) / 10000.0);
                    }
                }
                return new Double((n & 0x3FFF) * 100);
            }
            case 22: {
                int n = this.readInt32();
                switch (n >>> 30) {
                    case 0: {
                        return new Double(n & 0x3FFFFFFF);
                    }
                    case 1: {
                        return new Double((double)(n & 0x3FFFFFFF) / 100.0);
                    }
                    case 2: {
                        return new Double((double)(n & 0x3FFFFFFF) / 10000.0);
                    }
                }
                return new Double((n & 0x3FFFFFFF) * 100);
            }
            case 23: {
                return new Double(Double.longBitsToDouble(this.readLong64()));
            }
            case 18: {
                return new Long(this.readUInt16());
            }
            case 19: {
                return new Long(this.readInt32());
            }
            case 24: {
                return this._$7();
            }
            case 25: {
                return this._$6();
            }
            case 26: {
                return this._$5();
            }
            case 27: {
                return this._$4();
            }
        }
        return new Long(this.readLong64());
    }

    protected void skipMark1(int b) throws IOException {
        switch (b) {
            case 16: 
            case 18: 
            case 21: {
                this.index += 2;
                break;
            }
            case 17: 
            case 19: 
            case 22: {
                this.index += 4;
                break;
            }
            case 24: {
                this._$3();
                break;
            }
            case 25: {
                this._$2();
                break;
            }
            case 26: 
            case 27: {
                this._$1();
                break;
            }
            default: {
                this.index += 8;
            }
        }
    }

    protected Object readMark2(int b) throws IOException {
        switch (b) {
            case 33: {
                return this.readString(this.readInt());
            }
            case 32: {
                int scale = this.read2();
                int len = this.read2();
                byte[] buf = new byte[len];
                this.readFully(buf, 0, len);
                return new BigDecimal(new BigInteger(buf), scale);
            }
            case 34: {
                int len = this.readInt();
                Sequence seq = new Sequence(len);
                for (int i = 0; i < len; ++i) {
                    seq.add(this.innerReadObject());
                }
                return seq;
            }
            case 35: {
                return this.readTable();
            }
            case 37: {
                return this.readRecord();
            }
        }
        return this.readByteArray();
    }

    protected void skipMark2(int b) throws IOException {
        switch (b) {
            case 33: {
                this.skipFully(this.readInt());
                break;
            }
            case 32: {
                this.skipFully(1);
                this.skipFully(this.read2());
                break;
            }
            case 34: {
                int len = this.readInt();
                for (int i = 0; i < len; ++i) {
                    this.skipObject();
                }
                break;
            }
            case 35: {
                this.skipTable();
                break;
            }
            case 37: {
                this.skipRecord();
                break;
            }
            default: {
                int n = this.readInt();
                if (n <= 0) break;
                this.skipFully(n);
            }
        }
    }

    protected Object readMark3(int b) throws IOException {
        switch (b) {
            case 48: {
                return DateCache.getDate(this.readUInt16());
            }
            case 49: {
                return new Date(BufferWriter.BASEDATE - this._$8() * 1000L);
            }
            case 52: {
                return new Timestamp(this._$8() * 1000L);
            }
            case 53: {
                return new Timestamp(this._$8() * -1000L);
            }
            case 54: {
                return new Timestamp(this.readLong64());
            }
            case 50: {
                return new Time(BufferWriter._$7 + (long)(this.readUInt16() * 1000));
            }
            case 51: {
                return new Time(BufferWriter._$7 + (long)((0x10000 | this.readUInt16()) * 1000));
            }
            case 55: {
                return new Time(BufferWriter._$7 + (long)this.readInt32());
            }
            case 56: {
                return new Date(BufferWriter.BASEDATE + (long)this._$9() * 86400000L);
            }
        }
        return new Date(this.readLong64());
    }

    protected void skipMark3(int b) throws IOException {
        switch (b) {
            case 49: 
            case 52: 
            case 53: 
            case 55: {
                this.skipFully(4);
                break;
            }
            case 54: 
            case 57: {
                this.skipFully(8);
                break;
            }
            case 56: {
                this.skipFully(3);
                break;
            }
            default: {
                this.skipFully(2);
            }
        }
    }

    public boolean isNone(Object obj) {
        return obj == _$1;
    }

    public Object readObject() throws IOException {
        if (this.repeatCount > 0) {
            --this.repeatCount;
            return this.repeatValue;
        }
        return this.innerReadObject();
    }

    protected Object innerReadObject() throws IOException {
        int b = this.read2();
        switch (b & 0xF0) {
            case 0: {
                return this.readMark0(b);
            }
            case 16: {
                return this.readMark1(b);
            }
            case 32: {
                return this.readMark2(b);
            }
            case 48: {
                return this.readMark3(b);
            }
            case 128: {
                return INT15[b & 0xF];
            }
            case 144: {
                return ObjectCache.getInteger(((b & 0xF) << 8) + this.read2());
            }
            case 192: 
            case 208: {
                return this.readString(b & 0x1F);
            }
            case 224: 
            case 240: {
                return this.readStringAssic(b & 0x1F);
            }
            case 176: {
                return this.readDigits(b & 0xF);
            }
            case 160: {
                return HEXSTRINGS[b & 0xF];
            }
            case 112: {
                return this.readRepeat(b);
            }
            case 64: {
                int len = b & 0xF;
                if (len == 0) {
                    long v1 = this.readLong64();
                    long v2 = this.readLong64();
                    return new SerialBytes(v1, v2);
                }
                byte[] bytes = new byte[len];
                this.read(bytes);
                return new SerialBytes(bytes, len);
            }
        }
        throw new RuntimeException();
    }

    public Object readRepeat(int b) throws IOException {
        int count = (b & 8) == 0 ? (b & 7) + 1 : ((b & 7) << 8) + this.read2() + 1;
        this.repeatValue = this.innerReadObject();
        this.repeatCount = count;
        return this.repeatValue;
    }

    public void skipObject() throws IOException {
        if (this.repeatCount > 0) {
            --this.repeatCount;
            return;
        }
        int b = this.read2();
        switch (b & 0xF0) {
            case 0: {
                break;
            }
            case 16: {
                this.skipMark1(b);
                break;
            }
            case 32: {
                this.skipMark2(b);
                break;
            }
            case 48: {
                this.skipMark3(b);
                break;
            }
            case 128: {
                break;
            }
            case 144: {
                this.skipFully(1);
                break;
            }
            case 192: 
            case 208: 
            case 224: 
            case 240: {
                this.skipFully(b & 0x1F);
                break;
            }
            case 176: {
                this.skipFully(b & 0xF);
                break;
            }
            case 160: {
                break;
            }
            case 112: {
                this.readRepeat(b);
                break;
            }
            case 64: {
                int len = b & 0xF;
                if (len > 0) {
                    this.skipFully(len);
                    break;
                }
                this.skipFully(16);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    protected Record readRecord() throws IOException {
        int id = this.readInt();
        DataStruct ds = this.structManager.getDataStruct(id);
        int fcount = ds.getFieldCount();
        Object[] vals = new Object[fcount];
        for (int f = 0; f < fcount; ++f) {
            vals[f] = this.innerReadObject();
        }
        return new Record(ds, vals);
    }

    protected Table readTable() throws IOException {
        int id = this.readInt();
        int len = this.readInt();
        DataStruct ds = this.structManager.getDataStruct(id);
        int fcount = ds.getFieldCount();
        Object[] vals = new Object[fcount];
        Table table = new Table(ds, len);
        for (int i = 1; i <= len; ++i) {
            for (int f = 0; f < fcount; ++f) {
                vals[f] = this.innerReadObject();
            }
            table.newLast(vals);
        }
        return table;
    }

    protected void skipRecord() throws IOException {
        int id = this.readInt();
        DataStruct ds = this.structManager.getDataStruct(id);
        int fcount = ds.getFieldCount();
        for (int f = 0; f < fcount; ++f) {
            this.skipObject();
        }
    }

    protected void skipTable() throws IOException {
        int id = this.readInt();
        int len = this.readInt();
        DataStruct ds = this.structManager.getDataStruct(id);
        int fcount = ds.getFieldCount();
        for (int i = 1; i <= len; ++i) {
            for (int f = 0; f < fcount; ++f) {
                this.skipObject();
            }
        }
    }

    public int getCurPos() {
        return this.index;
    }

    public int readBaseInt() throws IOException {
        if (this.repeatCount > 0) {
            --this.repeatCount;
            return (Integer)this.repeatValue;
        }
        int b = this.read2();
        if (b == 16) {
            return this.readUInt16();
        }
        if (b == 17) {
            return this.readInt32();
        }
        int mask = b & 0xF0;
        if (mask == 128) {
            return b & 0xF;
        }
        if (mask == 144) {
            return ((b & 0xF) << 8) + this.read2();
        }
        return (Integer)this.readRepeat(b);
    }

    public long readBaseLong() throws IOException {
        if (this.repeatCount > 0) {
            --this.repeatCount;
            return (Long)this.repeatValue;
        }
        int b = this.read2();
        if (b == 16) {
            return this.readUInt16();
        }
        if (b == 17) {
            return this.readInt32();
        }
        int mask = b & 0xF0;
        if (mask == 128) {
            return b & 0xF;
        }
        if (mask == 144) {
            return ((b & 0xF) << 8) + this.read2();
        }
        if (b == 3) {
            return 0L;
        }
        if (b == 18) {
            return this.readUInt16();
        }
        if (b == 19) {
            return this.readInt32();
        }
        if (b == 20) {
            return this.readLong64();
        }
        return (Long)this.readRepeat(b);
    }

    public double readBaseDouble() throws IOException {
        if (this.repeatCount > 0) {
            --this.repeatCount;
            return (Double)this.repeatValue;
        }
        int b = this.read2();
        if (b == 4) {
            return 0.0;
        }
        if (b == 21) {
            int n = this.readUInt16();
            int scale = n >>> 14;
            n &= 0x3FFF;
            if (scale == 0) {
                return n;
            }
            if (scale == 1) {
                return (double)n / 100.0;
            }
            if (scale == 2) {
                return (double)n / 10000.0;
            }
            return n * 100;
        }
        if (b == 22) {
            int n = this.readInt32();
            int scale = n >>> 30;
            n &= 0x3FFFFFFF;
            if (scale == 0) {
                return n;
            }
            if (scale == 1) {
                return (double)n / 100.0;
            }
            if (scale == 2) {
                return (double)n / 10000.0;
            }
            return (double)n * 100.0;
        }
        if (b == 23) {
            return Double.longBitsToDouble(this.readLong64());
        }
        return (Double)this.readRepeat(b);
    }

    public long readBaseDate() throws IOException {
        if (this.repeatCount > 0) {
            --this.repeatCount;
            return (Long)this.repeatValue;
        }
        int b = this.read2();
        switch (b) {
            case 48: {
                return BufferWriter.BASEDATE + (long)this.readUInt16() * 86400000L;
            }
            case 49: {
                return BufferWriter.BASEDATE - this._$8() * 1000L;
            }
            case 52: {
                throw new RuntimeException();
            }
            case 53: {
                throw new RuntimeException();
            }
            case 54: {
                throw new RuntimeException();
            }
            case 50: {
                throw new RuntimeException();
            }
            case 51: {
                throw new RuntimeException();
            }
            case 55: {
                throw new RuntimeException();
            }
            case 56: {
                return BufferWriter.BASEDATE + (long)this._$9() * 86400000L;
            }
            case 57: {
                return this.readLong64();
            }
        }
        Date date = (Date)this.readRepeat(b);
        return date.getTime();
    }

    public void skipBaseInt() throws IOException {
        if (this.repeatCount > 0) {
            --this.repeatCount;
            return;
        }
        int b = this.read2();
        switch (b & 0xF0) {
            case 0: {
                break;
            }
            case 16: {
                this.skipMark1(b);
                break;
            }
            case 32: {
                this.skipMark2(b);
                break;
            }
            case 48: {
                this.skipMark3(b);
                break;
            }
            case 128: {
                break;
            }
            case 144: {
                this.skipFully(1);
                break;
            }
            case 192: 
            case 208: 
            case 224: 
            case 240: {
                this.skipFully(b & 0x1F);
                break;
            }
            case 176: {
                this.skipFully(b & 0xF);
                break;
            }
            case 160: {
                break;
            }
            case 112: {
                this.readRepeat(b);
                break;
            }
            case 64: {
                int len = b & 0xF;
                if (len > 0) {
                    this.skipFully(len);
                    break;
                }
                this.skipFully(16);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public void skipBaseLong() throws IOException {
        if (this.repeatCount > 0) {
            --this.repeatCount;
            return;
        }
        int b = this.read2();
        switch (b & 0xF0) {
            case 0: {
                break;
            }
            case 16: {
                this.skipMark1(b);
                break;
            }
            case 32: {
                this.skipMark2(b);
                break;
            }
            case 48: {
                this.skipMark3(b);
                break;
            }
            case 128: {
                break;
            }
            case 144: {
                this.skipFully(1);
                break;
            }
            case 192: 
            case 208: 
            case 224: 
            case 240: {
                this.skipFully(b & 0x1F);
                break;
            }
            case 176: {
                this.skipFully(b & 0xF);
                break;
            }
            case 160: {
                break;
            }
            case 112: {
                this.readRepeat(b);
                break;
            }
            case 64: {
                int len = b & 0xF;
                if (len > 0) {
                    this.skipFully(len);
                    break;
                }
                this.skipFully(16);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public void skipBaseDouble() throws IOException {
        if (this.repeatCount > 0) {
            --this.repeatCount;
            return;
        }
        int b = this.read2();
        switch (b & 0xF0) {
            case 0: {
                break;
            }
            case 16: {
                this.skipMark1(b);
                break;
            }
            case 32: {
                this.skipMark2(b);
                break;
            }
            case 48: {
                this.skipMark3(b);
                break;
            }
            case 128: {
                break;
            }
            case 144: {
                this.skipFully(1);
                break;
            }
            case 192: 
            case 208: 
            case 224: 
            case 240: {
                this.skipFully(b & 0x1F);
                break;
            }
            case 176: {
                this.skipFully(b & 0xF);
                break;
            }
            case 160: {
                break;
            }
            case 112: {
                this.readRepeat(b);
                break;
            }
            case 64: {
                int len = b & 0xF;
                if (len > 0) {
                    this.skipFully(len);
                    break;
                }
                this.skipFully(16);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public void skipBaseDate() throws IOException {
        if (this.repeatCount > 0) {
            --this.repeatCount;
            return;
        }
        int b = this.read2();
        switch (b & 0xF0) {
            case 0: {
                break;
            }
            case 16: {
                this.skipMark1(b);
                break;
            }
            case 32: {
                this.skipMark2(b);
                break;
            }
            case 48: {
                this.skipMark3(b);
                break;
            }
            case 128: {
                break;
            }
            case 144: {
                this.skipFully(1);
                break;
            }
            case 192: 
            case 208: 
            case 224: 
            case 240: {
                this.skipFully(b & 0x1F);
                break;
            }
            case 176: {
                this.skipFully(b & 0xF);
                break;
            }
            case 160: {
                break;
            }
            case 112: {
                this.readRepeat(b);
                break;
            }
            case 64: {
                int len = b & 0xF;
                if (len > 0) {
                    this.skipFully(len);
                    break;
                }
                this.skipFully(16);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public boolean isNull() {
        if (this.repeatCount > 0) {
            return this.repeatValue == null;
        }
        return this.buffer[this.index] == 0;
    }

    public void readObject(IArray array, int index) throws IOException {
        if (this.repeatCount > 0) {
            --this.repeatCount;
            array.set(index, this.repeatValue);
            return;
        }
        array.set(index, this.innerReadObject());
    }

    public IArray getEmptyArray(int count) {
        return new ObjectArray(count);
    }

    private Sequence _$7() throws IOException {
        int len = this.readUInt16();
        IntArray array = new IntArray(len);
        for (int i = 0; i < len; ++i) {
            array.pushInt(this.readUInt16());
        }
        Sequence seq = new Sequence(array);
        return seq;
    }

    private Sequence _$6() throws IOException {
        int len = this.readUInt16();
        IntArray array = new IntArray(len);
        for (int i = 0; i < len; ++i) {
            array.pushInt(this.readInt32());
        }
        Sequence seq = new Sequence(array);
        return seq;
    }

    private Sequence _$5() throws IOException {
        int len = this.readUInt16();
        LongArray array = new LongArray(len);
        for (int i = 0; i < len; ++i) {
            array.pushLong(this.readLong64());
        }
        Sequence seq = new Sequence(array);
        return seq;
    }

    private Sequence _$4() throws IOException {
        int len = this.readUInt16();
        DoubleArray array = new DoubleArray(len);
        for (int i = 0; i < len; ++i) {
            array.pushDouble(Double.longBitsToDouble(this.readLong64()));
        }
        Sequence seq = new Sequence(array);
        return seq;
    }

    private void _$3() throws IOException {
        int len = this.readUInt16();
        this.index += 2 * len;
    }

    private void _$2() throws IOException {
        int len = this.readUInt16();
        this.index += 4 * len;
    }

    private void _$1() throws IOException {
        int len = this.readUInt16();
        this.index += 8 * len;
    }

    public void setStructManager(StructManager structManager) {
        this.structManager = structManager;
    }
}

