/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.array.IArray;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Sequence;
import com.scudata.dm.SerialBytes;
import com.scudata.dw.DataBlockType;
import com.scudata.dw.StructManager;
import com.scudata.util.Variant;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.util.Arrays;
import java.util.Calendar;

public class BufferWriter {
    public static final int MARK0 = 0;
    public static final int NULL = 0;
    static final int _$26 = 1;
    static final int _$25 = 2;
    public static final int LONG0 = 3;
    public static final int FLOAT0 = 4;
    static final int _$24 = 5;
    static final int _$23 = 7;
    public static final int MARK1 = 16;
    public static final int INT16 = 16;
    public static final int INT32 = 17;
    public static final int LONG16 = 18;
    public static final int LONG32 = 19;
    public static final int LONG64 = 20;
    public static final int FLOAT16 = 21;
    public static final int FLOAT32 = 22;
    public static final int FLOAT64 = 23;
    public static final int INT16_SEQUENCE = 24;
    public static final int INT32_SEQUENCE = 25;
    public static final int LONG64_SEQUENCE = 26;
    public static final int FLOAT64_SEQUENCE = 27;
    public static final int MARK2 = 32;
    static final int _$22 = 32;
    public static final int STRING = 33;
    static final int _$21 = 34;
    static final int _$20 = 35;
    static final int _$19 = 36;
    static final int _$18 = 37;
    public static final int MARK3 = 48;
    public static final int DATE16 = 48;
    public static final int DATE32 = 49;
    static final int _$17 = 50;
    static final int _$16 = 51;
    static final int _$15 = 52;
    static final int _$14 = 53;
    static final int _$13 = 54;
    static final int _$12 = 55;
    public static final int DATE24 = 56;
    public static final int DATE64 = 57;
    public static final int SERIALBYTES = 64;
    public static final int REPEAT3 = 112;
    static final int _$11 = 120;
    static final int _$10 = 9;
    static final int _$9 = 2049;
    public static final int INT4 = 128;
    public static final int INT12 = 144;
    public static final int HEX4 = 160;
    public static final int DIGIT4 = 176;
    public static final int STRING4 = 192;
    public static final int STRING5 = 208;
    public static final int STRING4_ASSIC = 224;
    public static final int STRING5_ASSIC = 240;
    public static final int FLOAT_SCALE0 = 0;
    public static final int FLOAT_SCALE1 = 64;
    public static final int FLOAT_SCALE2 = 128;
    public static final int FLOAT_SCALE3 = 192;
    public static final double MINFLOAT = 1.0E-6;
    private static final int _$8 = 30;
    public static final long BASEDATE;
    static final long _$7;
    static final int _$6 = 65536;
    private byte[] _$5;
    private int _$4 = 0;
    private StructManager _$3;
    private Object _$2;
    private int _$1 = 0;

    public BufferWriter(StructManager structManager) {
        this._$5 = new byte[65536];
        this._$3 = structManager;
    }

    public BufferWriter(StructManager structManager, byte[] buffer) {
        this._$5 = buffer;
        this._$3 = structManager;
    }

    public byte[] finish() throws IOException {
        if (this._$1 > 0) {
            this._$1();
        }
        int len = this._$4;
        this._$4 = 0;
        return Arrays.copyOf(this._$5, len);
    }

    private void _$2() {
        this._$5 = Arrays.copyOf(this._$5, this._$5.length << 1);
    }

    private void _$1(int newLen) {
        this._$5 = Arrays.copyOf(this._$5, Math.max(this._$5.length << 1, newLen));
    }

    public void write(int b) throws IOException {
        if (this._$4 >= this._$5.length) {
            this._$2();
        }
        this._$5[this._$4++] = (byte)b;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len > this._$5.length - this._$4) {
            this._$1(this._$4 + len);
        }
        System.arraycopy(b, off, this._$5, this._$4, len);
        this._$4 += len;
    }

    public void writeByte(int v) throws IOException {
        if (this._$4 >= this._$5.length) {
            this._$2();
        }
        this._$5[this._$4++] = (byte)v;
    }

    public void writeBoolean(boolean v) throws IOException {
        if (this._$4 >= this._$5.length) {
            this._$2();
        }
        this._$5[this._$4++] = v ? (byte)1 : 0;
    }

    public void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeBytes(String s) throws IOException {
        for (char c : s.toCharArray()) {
            this.write(c);
        }
    }

    public void writeChars(String s) throws IOException {
        for (char c : s.toCharArray()) {
            this.writeChar(c);
        }
    }

    public void writeUTF(String str) throws IOException {
        this.writeString(str);
    }

    public void writeBytes(byte[] v) throws IOException {
        if (v == null) {
            this.writeInt(-1);
        } else {
            int len = v.length;
            this.writeInt(len);
            this.write(v, 0, len);
        }
    }

    public void writeStrings(String[] strs) throws IOException {
        if (strs == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(strs.length);
            for (String str : strs) {
                this.writeString(str);
            }
        }
    }

    private boolean _$2(char[] charr, int len) {
        if (len > 30) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (charr[i] >= '0' && charr[i] <= '9') continue;
            return false;
        }
        return true;
    }

    private void _$1(char[] charr, int len) throws IOException {
        if (this._$5.length - this._$4 < 30) {
            this._$2();
        }
        byte[] writeBuffer = this._$5;
        int seq = this._$4;
        if (len % 2 == 0) {
            writeBuffer[seq++] = (byte)(0xB0 | len / 2);
            int i = 0;
            while (i < len) {
                int d1 = charr[i++] - 48;
                int d2 = charr[i++] - 48;
                writeBuffer[seq++] = (byte)(d1 << 4 | d2);
            }
        } else {
            writeBuffer[seq++] = (byte)(0xB0 | len / 2 + 1);
            --len;
            int i = 0;
            while (i < len) {
                int d1 = charr[i++] - 48;
                int d2 = charr[i++] - 48;
                writeBuffer[seq++] = (byte)(d1 << 4 | d2);
            }
            writeBuffer[seq++] = (byte)(charr[len] - 48 << 4 | 0xF);
        }
        this._$4 = seq;
    }

    public void writeString(String str) throws IOException {
        char c;
        if (str == null) {
            this.write(0);
            return;
        }
        int strlen = str.length();
        if (strlen == 0) {
            this.write(192);
            return;
        }
        if (strlen == 1) {
            char c2 = str.charAt(0);
            if (c2 >= '0' && c2 <= '9') {
                this.write(0xA0 | c2 - 48);
                return;
            }
            if (c2 >= 'A' && c2 <= 'F') {
                this.write(0xA0 | c2 - 65 + 10);
                return;
            }
        }
        char[] charr = new char[strlen];
        str.getChars(0, strlen, charr, 0);
        if (this._$2(charr, strlen)) {
            this._$1(charr, strlen);
            return;
        }
        int utflen = 0;
        int count = 0;
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        byte[] bytearr = new byte[utflen];
        boolean isAssicString = true;
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                isAssicString = false;
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            isAssicString = false;
        }
        if (isAssicString) {
            if (utflen <= 31) {
                this.write(0xE0 | utflen);
                this.write(bytearr);
            } else {
                this.write(33);
                this.writeInt(utflen);
                this.write(bytearr);
            }
        } else if (utflen <= 31) {
            this.write(0xC0 | utflen);
            this.write(bytearr);
        } else {
            this.write(33);
            this.writeInt(utflen);
            this.write(bytearr);
        }
    }

    private void _$1(BigDecimal bd) throws IOException {
        byte[] bts = bd.unscaledValue().toByteArray();
        int scale = bd.scale();
        if (scale == 0 && bts[0] == 0 && bts.length == 1) {
            this.write(5);
        } else {
            this.write(32);
            this.write(scale);
            this.write(bts.length);
            this.write(bts);
        }
    }

    private void _$1(BigInteger bi) throws IOException {
        byte[] bts = bi.toByteArray();
        if (bts[0] == 0 && bts.length == 1) {
            this.write(5);
        } else {
            this.write(32);
            this.write(0);
            this.write(bts.length);
            this.write(bts);
        }
    }

    private void _$1(double d, long v, int scale) throws IOException {
        if (v <= 16383L) {
            int n = (int)v;
            this.write(21);
            this.write(n >>> 8 | scale);
            this.write(n & 0xFF);
        } else if (v <= 0x3FFFFFFFL) {
            int n = (int)v;
            this.write(22);
            this.write(n >>> 24 | scale);
            this.write(n >>> 16 & 0xFF);
            this.write(n >>> 8 & 0xFF);
            this.write(n & 0xFF);
        } else {
            this._$1(d);
        }
    }

    private void _$1(double d) throws IOException {
        this.write(23);
        long v = Double.doubleToLongBits(d);
        this.writeLong64(v);
    }

    public void writeDouble(double d) throws IOException {
        if (d > 0.0 && d <= 1.073741823E9) {
            double v = Math.ceil(d);
            if (v - d < 1.0E-6) {
                long l = (long)v;
                if (l % 100L == 0L) {
                    this._$1(d, l / 100L, 192);
                } else {
                    this._$1(d, (long)v, 0);
                }
            } else {
                double d1 = d * 100.0;
                v = Math.ceil(d1);
                if (v - d1 < 1.0E-6) {
                    this._$1(d, (long)v, 64);
                } else {
                    d1 = d * 10000.0;
                    v = Math.ceil(d1);
                    if (v - d1 < 1.0E-6) {
                        this._$1(d, (long)v, 128);
                    } else {
                        this._$1(d);
                    }
                }
            }
        } else if (d == 0.0) {
            this.write(4);
        } else {
            this._$1(d);
        }
    }

    public void writeLong(long v) throws IOException {
        if (v == 0L) {
            this.write(3);
        } else if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
            int n = (int)v;
            if (n >= 0) {
                if (n <= 65535) {
                    this.write(18);
                    this.write(n >>> 8);
                    this.write(n & 0xFF);
                } else {
                    this.write(19);
                    this.write(n >>> 24);
                    this.write(n >>> 16 & 0xFF);
                    this.write(n >>> 8 & 0xFF);
                    this.write(n & 0xFF);
                }
            } else {
                this.write(19);
                this.write(n >>> 24);
                this.write(n >>> 16 & 0xFF);
                this.write(n >>> 8 & 0xFF);
                this.write(n & 0xFF);
            }
        } else {
            this.write(20);
            this.writeLong64(v);
        }
    }

    public void writeInt32(int n) throws IOException {
        this.write(n >>> 24);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public void writeLong40(long v) throws IOException {
        if (this._$5.length - this._$4 < 5) {
            this._$2();
        }
        byte[] writeBuffer = this._$5;
        int seq = this._$4;
        writeBuffer[seq++] = (byte)(v >>> 32);
        writeBuffer[seq++] = (byte)(v >>> 24);
        writeBuffer[seq++] = (byte)(v >>> 16);
        writeBuffer[seq++] = (byte)(v >>> 8);
        writeBuffer[seq++] = (byte)(v >>> 0);
        this._$4 = seq;
    }

    public void writeLong48(long v) throws IOException {
        if (this._$5.length - this._$4 < 6) {
            this._$2();
        }
        byte[] writeBuffer = this._$5;
        int seq = this._$4;
        writeBuffer[seq++] = (byte)(v >>> 40);
        writeBuffer[seq++] = (byte)(v >>> 32);
        writeBuffer[seq++] = (byte)(v >>> 24);
        writeBuffer[seq++] = (byte)(v >>> 16);
        writeBuffer[seq++] = (byte)(v >>> 8);
        writeBuffer[seq++] = (byte)(v >>> 0);
        this._$4 = seq;
    }

    public void writeLong64(long v) throws IOException {
        if (this._$5.length - this._$4 < 8) {
            this._$2();
        }
        byte[] writeBuffer = this._$5;
        int seq = this._$4;
        writeBuffer[seq++] = (byte)(v >>> 56);
        writeBuffer[seq++] = (byte)(v >>> 48);
        writeBuffer[seq++] = (byte)(v >>> 40);
        writeBuffer[seq++] = (byte)(v >>> 32);
        writeBuffer[seq++] = (byte)(v >>> 24);
        writeBuffer[seq++] = (byte)(v >>> 16);
        writeBuffer[seq++] = (byte)(v >>> 8);
        writeBuffer[seq++] = (byte)(v >>> 0);
        this._$4 = seq;
    }

    public void writeInt(int n) throws IOException {
        if (n >= 0) {
            if (n <= 15) {
                this.write(0x80 | n);
            } else if (n <= 4095) {
                this.write(0x90 | n >>> 8);
                this.write(n & 0xFF);
            } else if (n <= 65535) {
                this.write(16);
                this.write(n >>> 8);
                this.write(n & 0xFF);
            } else {
                this.write(17);
                this.write(n >>> 24);
                this.write(n >>> 16 & 0xFF);
                this.write(n >>> 8 & 0xFF);
                this.write(n & 0xFF);
            }
        } else {
            this.write(17);
            this.write(n >>> 24);
            this.write(n >>> 16 & 0xFF);
            this.write(n >>> 8 & 0xFF);
            this.write(n & 0xFF);
        }
    }

    private void _$1(java.util.Date dt) throws IOException {
        long t = dt.getTime();
        if (t % 1000L == 0L) {
            long v = t / 1000L;
            if (v < 0L) {
                if ((v = -v) <= 0xFFFFFFFFL) {
                    this.write(53);
                    this.write((int)(v >>> 24));
                    this.write((int)(v >>> 16));
                    this.write((int)(v >>> 8));
                    this.write((int)(v >>> 0));
                    return;
                }
            } else if (v <= 0xFFFFFFFFL) {
                this.write(52);
                this.write((int)(v >>> 24));
                this.write((int)(v >>> 16));
                this.write((int)(v >>> 8));
                this.write((int)(v >>> 0));
                return;
            }
        }
        this.write(54);
        this.writeLong64(t);
    }

    private void _$1(Date date) throws IOException {
        long v = date.getTime();
        if (v >= BASEDATE) {
            int d = (int)((v - BASEDATE) / 86400000L);
            if (d > 65535) {
                if (d > 0xFFFFFF) {
                    this.write(57);
                    this.writeLong64(v);
                } else {
                    this.write(56);
                    this.write(d >>> 16);
                    this.write(d >>> 8 & 0xFF);
                    this.write(d & 0xFF);
                }
            } else {
                this.write(48);
                this.write(d >>> 8);
                this.write(d & 0xFF);
            }
        } else {
            long d = (BASEDATE - v) / 1000L;
            if (d > 0xFFFFFFFFL) {
                this.write(57);
                this.writeLong64(v);
            } else {
                this.write(49);
                this.writeInt32((int)d);
            }
        }
    }

    private void _$1(Time time) throws IOException {
        int t = (int)((time.getTime() - _$7) % 86400000L);
        if (t < 0) {
            t += 86400000;
        }
        if (t % 1000 == 0) {
            if ((t /= 1000) > 65535) {
                this.write(51);
                this.write(t >>> 8 & 0xFF);
                this.write(t & 0xFF);
            } else {
                this.write(50);
                this.write(t >>> 8);
                this.write(t & 0xFF);
            }
        } else {
            this.write(55);
            this.write(t >>> 24);
            this.write(t >>> 16 & 0xFF);
            this.write(t >>> 8 & 0xFF);
            this.write(t & 0xFF);
        }
    }

    private void _$1(BaseRecord r) throws IOException {
        DataStruct ds = r.dataStruct();
        int fcount = ds.getFieldCount();
        int id = this._$3.getDataStructID(ds);
        Object[] vals = r.getFieldValues();
        this.write(37);
        this.writeInt(id);
        for (int f = 0; f < fcount; ++f) {
            this._$1(vals[f]);
        }
    }

    private void _$1(Sequence seq) throws IOException {
        IArray mems = seq.getMems();
        int len = mems.size();
        DataStruct ds = seq.dataStruct();
        if (ds == null) {
            int type = DataBlockType.getSequenceDataType(seq, 1, len);
            if (type != 0 && len <= 65535) {
                if (type == 18) {
                    this.write(24);
                    this.write(len >>> 8);
                    this.write(len & 0xFF);
                    for (int i = 1; i <= len; ++i) {
                        int value = (Integer)mems.get(i);
                        this.write(value >>> 8);
                        this.write(value & 0xFF);
                    }
                } else if (type == 20) {
                    this.write(25);
                    this.write(len >>> 8);
                    this.write(len & 0xFF);
                    for (int i = 1; i <= len; ++i) {
                        int value = (Integer)mems.get(i);
                        this.writeInt32(value);
                    }
                } else if (type == 40) {
                    this.write(26);
                    this.write(len >>> 8);
                    this.write(len & 0xFF);
                    for (int i = 1; i <= len; ++i) {
                        long value = (Long)mems.get(i);
                        this.writeLong64(value);
                    }
                } else if (type == 56) {
                    this.write(27);
                    this.write(len >>> 8);
                    this.write(len & 0xFF);
                    for (int i = 1; i <= len; ++i) {
                        double value = (Double)mems.get(i);
                        long v = Double.doubleToLongBits(value);
                        this.writeLong64(v);
                    }
                } else {
                    this.write(34);
                    this.writeInt(len);
                    for (int i = 1; i <= len; ++i) {
                        this._$1(mems.get(i));
                    }
                }
            } else {
                this.write(34);
                this.writeInt(len);
                for (int i = 1; i <= len; ++i) {
                    this._$1(mems.get(i));
                }
            }
        } else {
            int fcount = ds.getFieldCount();
            int id = this._$3.getDataStructID(ds);
            this.write(35);
            this.writeInt(id);
            this.writeInt(len);
            for (int i = 1; i <= len; ++i) {
                BaseRecord r = (BaseRecord)mems.get(i);
                Object[] vals = r.getFieldValues();
                for (int f = 0; f < fcount; ++f) {
                    this._$1(vals[f]);
                }
            }
        }
    }

    private void _$1() throws IOException {
        int count = this._$1;
        if (count > 1) {
            if (count <= 9) {
                this.write(0x70 | count - 2);
            } else {
                this.write(0x78 | (count -= 2) >> 8);
                this.write(count & 0xFF);
            }
        }
        this._$1 = 0;
        this._$1(this._$2);
    }

    private void _$1(Object obj) throws IOException {
        if (obj == null) {
            this.write(0);
        } else if (obj instanceof String) {
            this.writeString((String)obj);
        } else if (obj instanceof Integer) {
            this.writeInt(((Number)obj).intValue());
        } else if (obj instanceof Double) {
            this.writeDouble(((Number)obj).doubleValue());
        } else if (obj instanceof BigDecimal) {
            this._$1((BigDecimal)obj);
        } else if (obj instanceof Long) {
            this.writeLong(((Number)obj).longValue());
        } else if (obj instanceof Date) {
            this._$1((Date)obj);
        } else if (obj instanceof Time) {
            this._$1((Time)obj);
        } else if (obj instanceof java.util.Date) {
            this._$1((java.util.Date)obj);
        } else if (obj instanceof Boolean) {
            if (((Boolean)obj).booleanValue()) {
                this.write(1);
            } else {
                this.write(2);
            }
        } else if (obj instanceof BigInteger) {
            this._$1((BigInteger)obj);
        } else if (obj instanceof Float) {
            this.writeDouble(((Number)obj).doubleValue());
        } else if (obj instanceof Number) {
            this.writeInt(((Number)obj).intValue());
        } else if (obj instanceof Sequence) {
            this._$1((Sequence)obj);
        } else if (obj instanceof BaseRecord) {
            this._$1((BaseRecord)obj);
        } else if (obj instanceof byte[]) {
            this.write(36);
            this.writeBytes((byte[])obj);
        } else if (obj instanceof SerialBytes) {
            SerialBytes sb = (SerialBytes)obj;
            this.write(64);
            this.writeLong64(sb.getValue1());
            this.writeLong64(sb.getValue2());
        } else {
            throw new RQException("error type: " + obj.getClass().getName());
        }
    }

    public void writeNone() throws IOException {
        if (this._$1 > 0) {
            this._$1();
        }
        this.write(7);
    }

    public void writeObject(Object obj) throws IOException {
        if (this._$1 > 0) {
            if (Variant.isEquals(this._$2, obj) && (obj == null || obj.getClass() == this._$2.getClass())) {
                ++this._$1;
                if (this._$1 == 2049) {
                    this._$1();
                }
            } else {
                this._$1();
                this._$1 = 1;
                this._$2 = obj;
            }
        } else {
            this._$2 = obj;
            this._$1 = 1;
        }
    }

    public void flush() throws IOException {
        if (this._$1 > 0) {
            this._$1();
        }
    }

    public void writeLittleEndianShort(int v) throws IOException {
        this.write(v >>> 0 & 0xFF);
        this.write(v >>> 8 & 0xFF);
    }

    public void writeLittleEndianInt(int n) throws IOException {
        this.write(n & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 24);
    }

    public void writeLittleEndianLong(long v) throws IOException {
        if (this._$5.length - this._$4 < 8) {
            this._$2();
        }
        byte[] writeBuffer = this._$5;
        int seq = this._$4;
        writeBuffer[seq++] = (byte)(v >>> 0);
        writeBuffer[seq++] = (byte)(v >>> 8);
        writeBuffer[seq++] = (byte)(v >>> 16);
        writeBuffer[seq++] = (byte)(v >>> 24);
        writeBuffer[seq++] = (byte)(v >>> 32);
        writeBuffer[seq++] = (byte)(v >>> 40);
        writeBuffer[seq++] = (byte)(v >>> 48);
        writeBuffer[seq++] = (byte)(v >>> 56);
        this._$4 = seq;
    }

    public void reset() {
        this._$2 = null;
        this._$1 = 0;
        this._$4 = 0;
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1970, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        _$7 = calendar.getTimeInMillis();
        calendar.set(1, 2000);
        BASEDATE = calendar.getTimeInMillis();
    }
}

