/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.array.LongArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dw.BlockLink;
import com.scudata.dw.BlockLinkReader;
import com.scudata.dw.BlockLinkWriter;
import com.scudata.dw.BufferReader;
import com.scudata.dw.BufferWriter;
import com.scudata.dw.ColPhyTable;
import com.scudata.dw.ColumnMetaData;
import com.scudata.dw.ComTable;
import com.scudata.dw.PhyTable;
import com.scudata.dw.StructManager;
import com.scudata.resources.EngineMessage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class ColComTable
extends ComTable {
    public ColComTable(File file, RandomAccessFile raf, Context ctx) throws IOException {
        this.file = file;
        this.raf = raf;
        this.ctx = ctx;
        if (ctx != null) {
            ctx.addResource(this);
        }
        this.readHeader();
    }

    public ColComTable(File file, Context ctx) throws IOException {
        this.file = file;
        this.raf = new RandomAccessFile(file, "rw");
        this.ctx = ctx;
        if (ctx != null) {
            ctx.addResource(this);
        }
        this.readHeader();
    }

    public ColComTable(File file) throws IOException {
        this.file = file;
        this.raf = new RandomAccessFile(file, "rw");
        this.readHeader();
    }

    public ColComTable(File file, String[] colNames, String distribute, String opt, Context ctx) throws IOException {
        this(file, colNames, distribute, opt, null, ctx);
    }

    public ColComTable(File file, String[] colNames, String distribute, String opt, Integer blockSize, Context ctx) throws IOException {
        this(file, null, colNames, distribute, opt, blockSize, ctx);
    }

    public ColComTable(File file, RandomAccessFile raf, String[] colNames, String distribute, String opt, Integer blockSize, Context ctx) throws IOException {
        file.delete();
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        this.file = file;
        this.raf = raf == null ? new RandomAccessFile(file, "rw") : raf;
        this.ctx = ctx;
        if (ctx != null) {
            ctx.addResource(this);
        }
        if (opt != null && opt.indexOf(117) != -1) {
            this.setCompress(false);
        }
        if (opt != null && opt.indexOf(118) != -1) {
            this.setCheckDataPure(true);
        }
        if (opt != null && opt.indexOf(116) != -1) {
            this.setTimeKey(true);
        }
        if (opt != null && opt.indexOf(100) != -1) {
            this.setDeleteKey(true);
        }
        if (blockSize == null) {
            blockSize = Env.getBlockSize();
        } else {
            int tempSize = blockSize % MIN_BLOCK_SIZE;
            if (tempSize != 0) {
                blockSize = blockSize - tempSize + MIN_BLOCK_SIZE;
            }
            if (blockSize < MIN_BLOCK_SIZE) {
                blockSize = MIN_BLOCK_SIZE;
            }
        }
        this.setBlockSize(blockSize);
        this.enlargeSize = blockSize * 16;
        this.headerBlockLink = new BlockLink(this);
        this.headerBlockLink.setFirstBlockPos(this.applyNewBlock());
        this.baseTable = new ColPhyTable((ComTable)this, colNames);
        this.structManager = new StructManager();
        if (opt != null && opt.indexOf(112) != -1) {
            this.baseTable.segmentCol = this.baseTable.getColName(0);
        }
        this.distribute = distribute;
        this.reserve[0] = 4;
        this._$3();
    }

    public ColComTable(File file, ColComTable src) throws IOException {
        block3: {
            this.file = file;
            this.raf = new RandomAccessFile(file, "rw");
            this.ctx = src.ctx;
            if (this.ctx != null) {
                this.ctx.addResource(this);
            }
            System.arraycopy(src.reserve, 0, this.reserve, 0, this.reserve.length);
            this.blockSize = src.blockSize;
            this.enlargeSize = src.enlargeSize;
            this.headerBlockLink = new BlockLink(this);
            this.headerBlockLink.setFirstBlockPos(this.applyNewBlock());
            this.writePswHash = src.writePswHash;
            this.readPswHash = src.readPswHash;
            this.distribute = src.distribute;
            this.structManager = src.structManager;
            try {
                this.baseTable = new ColPhyTable((ComTable)this, null, (ColPhyTable)src.baseTable);
            }
            catch (Exception e) {
                if (this.raf == null) break block3;
                this.raf.close();
            }
        }
        this._$3();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reopen() throws IOException {
        Object syncObj;
        this.raf = new RandomAccessFile(this.file, "rw");
        Object object = syncObj = this._$1();
        synchronized (object) {
            int dsCount;
            this.restoreTransaction();
            this.raf.seek(0L);
            byte[] bytes = new byte[32];
            this.raf.read(bytes);
            if (bytes[0] != 114 || bytes[1] != 113 || bytes[2] != 100 || bytes[3] != 119 || bytes[4] != 103 || bytes[5] != 116) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("license.fileFormatError"));
            }
            if (bytes[6] != 99 && bytes[6] != 67) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("license.fileFormatError"));
            }
            BufferReader reader = new BufferReader(this.structManager, bytes, 7, 25);
            this.setBlockSize(reader.readInt32());
            this.headerBlockLink = new BlockLink(this);
            this.headerBlockLink.readExternal(reader);
            BlockLinkReader headerReader = new BlockLinkReader(this.headerBlockLink);
            bytes = headerReader.readBlocks();
            headerReader.close();
            reader = new BufferReader(this.structManager, bytes);
            reader.read();
            reader.read();
            reader.read();
            reader.read();
            reader.read();
            reader.read();
            reader.read();
            this.blockSize = reader.readInt32();
            this.headerBlockLink.readExternal(reader);
            reader.read(this.reserve);
            this.freePos = reader.readLong40();
            this.fileSize = reader.readLong40();
            if (this.reserve[0] > 0) {
                this.writePswHash = reader.readString();
                this.readPswHash = reader.readString();
                this.checkPassword(null);
                if (this.reserve[0] > 1) {
                    this.distribute = reader.readString();
                }
            }
            if ((dsCount = reader.readInt()) > 0) {
                ArrayList<DataStruct> dsList = new ArrayList<DataStruct>(dsCount);
                for (int i = 0; i < dsCount; ++i) {
                    String[] fieldNames = reader.readStrings();
                    DataStruct ds = new DataStruct(fieldNames);
                    dsList.add(ds);
                }
                this.structManager = new StructManager(dsList);
            } else {
                this.structManager = new StructManager();
            }
            this.baseTable.readExternal(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readHeader() throws IOException {
        Object syncObj;
        Object object = syncObj = this._$1();
        synchronized (object) {
            int dsCount;
            this.raf.seek(0L);
            byte[] bytes = new byte[32];
            this.raf.read(bytes);
            if (bytes[0] != 114 || bytes[1] != 113 || bytes[2] != 100 || bytes[3] != 119 || bytes[4] != 103 || bytes[5] != 116) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("license.fileFormatError"));
            }
            if (bytes[6] != 99 && bytes[6] != 67) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("license.fileFormatError"));
            }
            BufferReader reader = new BufferReader(this.structManager, bytes, 7, 25);
            this.setBlockSize(reader.readInt32());
            this.headerBlockLink = new BlockLink(this);
            this.headerBlockLink.readExternal(reader);
            BlockLinkReader headerReader = new BlockLinkReader(this.headerBlockLink);
            bytes = headerReader.readBlocks();
            headerReader.close();
            reader = new BufferReader(this.structManager, bytes);
            reader.read();
            reader.read();
            reader.read();
            reader.read();
            reader.read();
            reader.read();
            reader.read();
            this.blockSize = reader.readInt32();
            this.headerBlockLink.readExternal(reader);
            reader.read(this.reserve);
            this.freePos = reader.readLong40();
            this.fileSize = reader.readLong40();
            if (this.reserve[0] > 0) {
                this.writePswHash = reader.readString();
                this.readPswHash = reader.readString();
                this.checkPassword(null);
                if (this.reserve[0] > 1) {
                    this.distribute = reader.readString();
                }
            }
            if ((dsCount = reader.readInt()) > 0) {
                ArrayList<DataStruct> dsList = new ArrayList<DataStruct>(dsCount);
                for (int i = 0; i < dsCount; ++i) {
                    String[] fieldNames = reader.readStrings();
                    DataStruct ds = new DataStruct(fieldNames);
                    dsList.add(ds);
                }
                this.structManager = new StructManager(dsList);
            } else {
                this.structManager = new StructManager();
            }
            this.baseTable = new ColPhyTable(this);
            this.baseTable.readExternal(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHeader() throws IOException {
        Object syncObj;
        if (this.reserve[0] < 4) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.oldVersion2"));
        }
        Object object = syncObj = this._$1();
        synchronized (object) {
            this.beginTransaction(null);
            BufferWriter writer = new BufferWriter(this.structManager);
            writer.write(114);
            writer.write(113);
            writer.write(100);
            writer.write(119);
            writer.write(103);
            writer.write(116);
            writer.write(67);
            writer.writeInt32(this.blockSize);
            this.headerBlockLink.writeExternal(writer);
            this.reserve[0] = 4;
            writer.write(this.reserve);
            writer.writeLong40(this.freePos);
            writer.writeLong40(this.fileSize);
            writer.writeString(this.writePswHash);
            writer.writeString(this.readPswHash);
            writer.writeString(this.distribute);
            ArrayList<DataStruct> dsList = this.structManager.getStructList();
            if (dsList != null) {
                writer.writeInt(dsList.size());
                for (DataStruct ds : dsList) {
                    String[] fieldNames = ds.getFieldNames();
                    writer.writeStrings(fieldNames);
                }
            } else {
                writer.writeInt(0);
            }
            this.baseTable.writeExternal(writer);
            BlockLinkWriter headerWriter = new BlockLinkWriter(this.headerBlockLink, false);
            headerWriter.rewriteBlocks(writer.finish());
            headerWriter.close();
            writer.write(114);
            writer.write(113);
            writer.write(100);
            writer.write(119);
            writer.write(103);
            writer.write(116);
            writer.write(67);
            writer.writeInt32(this.blockSize);
            this.headerBlockLink.writeExternal(writer);
            this.raf.seek(0L);
            this.raf.write(writer.finish());
            this.raf.getChannel().force(true);
            this.commitTransaction(0);
        }
    }

    public long[] getBlockLinkInfo() {
        ColumnMetaData[] columns;
        LongArray info = new LongArray(1024);
        ColPhyTable baseTable = (ColPhyTable)this.baseTable;
        BlockLink segmentBlockLink = baseTable.segmentBlockLink;
        info.add(segmentBlockLink._$4);
        info.add(segmentBlockLink._$3);
        info.add(segmentBlockLink._$2);
        info.add(segmentBlockLink._$1);
        for (ColumnMetaData col : columns = baseTable.getColumns()) {
            col.getBlockLinkInfo(info);
        }
        for (PhyTable table : baseTable.tableList) {
            segmentBlockLink = table.segmentBlockLink;
            info.add(segmentBlockLink._$4);
            info.add(segmentBlockLink._$3);
            info.add(segmentBlockLink._$2);
            info.add(segmentBlockLink._$1);
            ((ColPhyTable)table).getGuideColumn().getBlockLinkInfo(info);
            for (ColumnMetaData col : columns = ((ColPhyTable)table).getColumns()) {
                col.getBlockLinkInfo(info);
            }
        }
        return info.getDatas();
    }

    public boolean isPureFormat() {
        return this.reserve[0] > 3;
    }
}

