/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.array.LongArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.ObjectReader;
import com.scudata.dm.ObjectWriter;
import com.scudata.dm.Sequence;
import com.scudata.dw.BlockLink;
import com.scudata.dw.BlockLinkReader;
import com.scudata.dw.BlockLinkWriter;
import com.scudata.dw.BufferReader;
import com.scudata.dw.BufferWriter;
import com.scudata.dw.ColPhyTable;
import com.scudata.dw.ComTable;
import com.scudata.dw.DataBlockType;
import com.scudata.resources.EngineMessage;
import java.io.IOException;

public class ColumnMetaData {
    protected ComTable groupTable;
    private String _$13;
    private boolean _$12;
    private boolean _$11;
    private int _$10 = 0;
    private BlockLink _$9;
    private BlockLink _$8;
    private transient BlockLinkWriter _$7;
    private transient BlockLinkWriter _$6;
    private transient ObjectWriter _$5;
    private Sequence _$4;
    private Object _$3;
    private boolean _$2;
    private int _$1 = 255;

    public ColumnMetaData() {
    }

    public ColumnMetaData(ColPhyTable table) {
        this.groupTable = table.groupTable;
        this._$9 = new BlockLink(this.groupTable);
        this._$8 = new BlockLink(this.groupTable);
        this._$4 = new Sequence();
    }

    public ColumnMetaData(ColPhyTable table, ColumnMetaData src) {
        this(table);
        this._$13 = src._$13;
        this._$12 = src._$12;
        this._$11 = src._$11;
        this._$2 = src._$2;
        this._$10 = src._$10;
    }

    public ColumnMetaData(ColumnMetaData src) {
        this.groupTable = src.groupTable;
        this._$9 = src._$9;
        this._$8 = src._$8;
        this._$13 = src._$13;
        this._$12 = src._$12;
        this._$11 = src._$11;
        this._$10 = src._$10;
        this._$2 = src._$2;
    }

    public ColumnMetaData(ColPhyTable table, String name, boolean isDim, boolean isKey) {
        this(table);
        this._$13 = name;
        this._$12 = isDim;
        this._$11 = isKey;
        this._$2 = true;
    }

    public ColumnMetaData(ColPhyTable table, String name, int serialBytesLen) throws IOException {
        this(table);
        if (name.startsWith("#")) {
            this._$13 = name.substring(1);
            this._$12 = true;
        } else {
            this._$13 = name;
            this._$12 = false;
        }
        this._$10 = serialBytesLen;
        this._$2 = true;
    }

    public boolean isSerialBytes() {
        return this._$10 > 0;
    }

    public int getSerialBytesLen() {
        return this._$10;
    }

    public String getColName() {
        return this._$13;
    }

    public void setColName(String colName) {
        this._$13 = colName;
    }

    public boolean isDim() {
        return this._$12;
    }

    public boolean isKey() {
        return this._$11;
    }

    void _$2() throws IOException {
        if (this._$9.isEmpty()) {
            this._$9.setFirstBlockPos(this.groupTable.applyNewBlock());
        }
    }

    void _$1() throws IOException {
        if (this._$9.isEmpty()) {
            this._$8.setFirstBlockPos(this.groupTable.applyNewBlock());
        }
    }

    public boolean isColumn(String name) {
        return this._$13.equals(name);
    }

    public void readExternal(BufferReader reader, byte version) throws IOException {
        this._$13 = reader.readUTF();
        this._$12 = reader.readBoolean();
        this._$10 = reader.readInt();
        this._$9.readExternal(reader);
        this._$8.readExternal(reader);
        this._$11 = version > 0 ? reader.readBoolean() : this._$12;
        this._$2 = this._$12;
        if (version > 3) {
            this._$4 = (Sequence)reader.readObject();
            if (this._$4 == null) {
                this._$4 = new Sequence();
            }
            this._$2 = true;
        }
        if (version > 4) {
            reader.readInt();
            this._$1 = reader.readInt();
            this.initDictArray();
        } else {
            this._$1 = 255;
        }
    }

    public void writeExternal(BufferWriter writer) throws IOException {
        writer.writeUTF(this._$13);
        writer.writeBoolean(this._$12);
        writer.writeInt(this._$10);
        this._$9.writeExternal(writer);
        this._$8.writeExternal(writer);
        writer.writeBoolean(this._$11);
        Sequence dict = this._$4;
        if (dict != null && dict.length() == 0) {
            dict = null;
        }
        writer.flush();
        writer.writeObject(dict);
        writer.flush();
        writer.writeInt(0);
        writer.writeInt(this._$1);
    }

    public void prepareWrite() throws IOException {
        this._$7 = new BlockLinkWriter(this._$9, true);
        this._$6 = new BlockLinkWriter(this._$8, true);
        this._$5 = new ObjectWriter(this._$6, this.groupTable.getBlockSize() - 5);
    }

    public void finishWrite() throws IOException {
        this._$7.finishWrite();
        this._$7 = null;
        this._$5.flush();
        this._$6.finishWrite();
        this._$6 = null;
        this._$5 = null;
    }

    public void appendColBlock(byte[] bytes) throws IOException {
        long pos = this._$7.writeDataBlock(bytes);
        this._$5.writeLong40(pos);
    }

    public void appendColBlock(byte[] bytes, Object minValue, Object maxValue, Object startValue) throws IOException {
        long pos = this._$7.writeDataBlock(bytes);
        this._$5.writeLong40(pos);
        this._$5.writeObject(minValue);
        this._$5.writeObject(maxValue);
        this._$5.writeObject(startValue);
    }

    public void copyColBlock(BlockLinkReader colReader, ObjectReader segmentReader) throws IOException {
        byte[] data = colReader.readDataBlock0();
        long pos = this._$7.writeDataBlock0(data);
        segmentReader.readLong40();
        this._$5.writeLong40(pos);
        if (this.hasMaxMinValues()) {
            this._$5.writeObject(segmentReader.readObject());
            this._$5.writeObject(segmentReader.readObject());
            this._$5.writeObject(segmentReader.readObject());
        }
    }

    public void copyColBlock(BlockLinkReader colReader, ObjectReader segmentReader, BufferWriter bufferWriter, byte[] dict) throws IOException {
        byte[] data = colReader.readDataBlock();
        if (data[0] == 127 && data[1] == 0) {
            int len = data.length - 2;
            bufferWriter.reset();
            bufferWriter.write(127);
            bufferWriter.write(1);
            bufferWriter.write(dict);
            bufferWriter.write(data, 2, len);
            data = bufferWriter.finish();
        }
        long pos = this._$7.writeDataBlock(data);
        segmentReader.readLong40();
        this._$5.writeLong40(pos);
        if (this.hasMaxMinValues()) {
            this._$5.writeObject(segmentReader.readObject());
            this._$5.writeObject(segmentReader.readObject());
            this._$5.writeObject(segmentReader.readObject());
        }
    }

    public BlockLinkReader getColReader(boolean isLoadFirstBlock) {
        BlockLinkReader reader = new BlockLinkReader(this._$9, this._$10);
        reader._$2(4096);
        if (isLoadFirstBlock) {
            try {
                reader.loadFirstBlock();
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        reader.setDict(this._$4);
        return reader;
    }

    public ObjectReader getSegmentReader() {
        BlockLinkReader segmentReader = new BlockLinkReader(this._$8);
        try {
            segmentReader.loadFirstBlock();
            return new ObjectReader(segmentReader, this.groupTable.getBlockSize() - 5);
        }
        catch (IOException e) {
            segmentReader.close();
            throw new RQException(e.getMessage(), e);
        }
    }

    public BufferWriter getColDataBufferWriter() {
        return new BufferWriter(this.groupTable.getStructManager());
    }

    public void getBlockLinkInfo(LongArray info) {
        info.add(this._$8._$4);
        info.add(this._$8._$3);
        info.add(this._$8._$2);
        info.add(this._$8._$1);
        info.add(this._$9._$4);
        info.add(this._$9._$3);
        info.add(this._$9._$2);
        info.add(this._$9._$1);
    }

    public BlockLink getSegmentBlockLink() {
        return this._$8;
    }

    public BlockLink getDataBlockLink() {
        return this._$9;
    }

    public Sequence getDict() {
        return this._$4;
    }

    public void setDict(Sequence dict) {
        this._$4 = dict;
    }

    public boolean hasMaxMinValues() {
        return this._$2;
    }

    public int getDataType() {
        return this._$1;
    }

    public void setDataType(int dataType) {
        this._$1 = dataType;
    }

    public String getDataLen() {
        return DataBlockType.getTypeLen(this._$1);
    }

    public void adjustDataType(int newType, boolean checkDataPure) {
        if (checkDataPure && !this._$1(newType)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", DataBlockType.getTypeName(this._$1), DataBlockType.getTypeName(newType)));
        }
        int curType = this._$1;
        if (curType == newType || newType == 0) {
            return;
        }
        if (curType == 80 && newType == 81) {
            return;
        }
        if (newType == 80 && curType == 81) {
            return;
        }
        switch (curType) {
            case 255: {
                this._$1 = newType;
                break;
            }
            case 126: {
                break;
            }
            case 64: 
            case 68: 
            case 69: 
            case 80: {
                this._$1 = 126;
                break;
            }
            case 66: {
                if (newType == 67) break;
                this._$1 = 126;
                break;
            }
            case 67: {
                if (newType == 66) {
                    this._$1 = 66;
                    break;
                }
                this._$1 = 126;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                if ((newType & 0xF0) == 16) {
                    this._$1 = 16;
                    break;
                }
                this._$1 = 126;
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 40: {
                if ((newType & 0xF0) == 32) {
                    this._$1 = 32;
                    break;
                }
                this._$1 = 126;
                break;
            }
            case 48: {
                if (newType == 56) {
                    this._$1 = 48;
                    break;
                }
                this._$1 = 126;
                break;
            }
            case 56: {
                if (newType == 48) {
                    this._$1 = 48;
                    break;
                }
                this._$1 = 126;
                break;
            }
            default: {
                this._$1 = 126;
            }
        }
    }

    private boolean _$1(int newType) {
        int curType = this._$1;
        if (curType == newType || newType == 0) {
            return true;
        }
        switch (curType) {
            case 255: {
                break;
            }
            case 126: {
                break;
            }
            case 64: 
            case 68: 
            case 69: 
            case 80: {
                return false;
            }
            case 66: {
                if (newType != 67) {
                    return false;
                }
            }
            case 67: {
                if (newType != 66) break;
                return false;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                if ((newType & 0xF0) == 16) break;
                return false;
            }
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 40: {
                if ((newType & 0xF0) == 32) break;
                return false;
            }
            case 48: {
                if (newType == 56) break;
                return false;
            }
            case 56: {
                if (newType == 48) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public Object getDictArray() {
        return this._$3;
    }

    public void initDictArray() {
        if (this._$4 == null || this._$4.length() == 0) {
            return;
        }
        this._$3 = DataBlockType.dictToArray(this._$4, this._$1);
    }
}

