/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.array.BoolArray;
import com.scudata.array.IArray;
import com.scudata.array.ObjectArray;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.dw.ColumnMetaData;
import com.scudata.dw.FindFilter;
import com.scudata.expression.Constant;
import com.scudata.expression.Expression;
import com.scudata.expression.Node;
import com.scudata.util.Variant;

public class MemberFilter
extends FindFilter {
    public static final int MAX_CHECK_NUMBER = 500;
    private IArray _$1;

    public MemberFilter(ColumnMetaData column, int priority, Sequence sequence, Node node) {
        super(column, priority);
        this._$1 = sequence.getMems();
        if (node != null) {
            this.exp = new Expression(node);
        }
        this.right = new Expression(column.getColName());
    }

    public MemberFilter(String columnName, int priority, Sequence sequence) {
        super(columnName, priority);
        this._$1 = sequence.getMems();
    }

    public boolean match(Object value) {
        try {
            int n = ((Number)value).intValue();
            if (n < 1 || n > this._$1.size()) {
                this.findResult = null;
                return false;
            }
            this.findResult = this._$1.get(n);
            return Variant.isTrue(this.findResult);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean match(Object minValue, Object maxValue) {
        int max;
        int min;
        try {
            min = minValue == null ? 1 : ((Number)minValue).intValue();
            max = ((Number)maxValue).intValue();
        }
        catch (Exception e) {
            return false;
        }
        if (max >= min && max - min <= 500) {
            IArray array = this._$1;
            for (int i = min; i <= max; ++i) {
                if (!Variant.isTrue(array.get(i))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public Object getFindResult() {
        return this.findResult;
    }

    public IArray getFindResultArray() {
        int[] pos = this.pos;
        int len = pos.length - 1;
        IArray array = this._$1;
        ObjectArray resultValue = new ObjectArray(len);
        for (int i = 1; i <= len; ++i) {
            if (pos[i] != 0) {
                resultValue.push(array.get(pos[i]));
                continue;
            }
            resultValue.push(null);
        }
        return resultValue;
    }

    public IArray calculateAll(Context ctx) {
        IArray key = this.right.calculateAll(ctx);
        int len = key.size();
        IArray array = this._$1;
        int codeLen = array.size();
        boolean[] result = new boolean[len + 1];
        int[] pos = new int[len + 1];
        if (key.isNumberArray()) {
            for (int i = 1; i <= len; ++i) {
                int n = key.getInt(i);
                if (n <= 0 || n > codeLen || array.isFalse(n)) continue;
                result[i] = true;
                pos[i] = n;
            }
        }
        this.pos = pos;
        BoolArray resultArray = new BoolArray(result, len);
        resultArray.setTemporary(true);
        return resultArray;
    }

    public IArray calculateAnd(Context ctx, IArray leftResult) {
        BoolArray left = leftResult.isTrue();
        boolean[] leftArray = left.getDatas();
        IArray key = this.right.calculateAll(ctx);
        int len = key.size();
        IArray array = this._$1;
        int codeLen = array.size();
        boolean[] result = new boolean[len + 1];
        int[] pos = new int[len + 1];
        if (key.isNumberArray()) {
            for (int i = 1; i <= len; ++i) {
                int n;
                if (!leftArray[i] || (n = key.getInt(i)) <= 0 || n > codeLen || array.isFalse(n)) continue;
                result[i] = true;
                pos[i] = n;
            }
        }
        this.pos = pos;
        BoolArray resultArray = new BoolArray(result, len);
        resultArray.setTemporary(true);
        return resultArray;
    }

    public void initExp() {
        if (this.exp == null) {
            String s = "null(" + this.column.getColName() + ")";
            this.exp = new Expression(new Context(), s);
            this.exp.getHome().setLeft(new Constant(new Sequence(this._$1)));
        }
    }
}

