/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.array.IArray;
import com.scudata.common.IntArrayList;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.CompressIndexTable;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.IndexTable;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dw.MemoryTableIndex;
import com.scudata.dw.PhyTable;
import com.scudata.dw.compress.ColumnList;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.fn.string.Like;
import com.scudata.expression.mfn.sequence.Contain;
import com.scudata.expression.operator.DotOperator;
import com.scudata.resources.EngineMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MemoryTable
extends Table {
    private static final long serialVersionUID = 53542916L;
    private String _$8;
    private int _$7 = -1;
    private int[] _$6;
    private List<MemoryTableIndex> _$5;

    public MemoryTable() {
    }

    public MemoryTable(String[] fields) {
        super(fields);
    }

    public MemoryTable(DataStruct ds) {
        super(ds);
    }

    public MemoryTable(String[] fields, int initialCapacity) {
        super(fields, initialCapacity);
    }

    public MemoryTable(DataStruct ds, int initialCapacity) {
        super(ds, initialCapacity);
    }

    public MemoryTable(Table table) {
        this.ds = table.dataStruct();
        this.mems = table.getMems();
    }

    public MemoryTable(ICursor cursor) {
        this.mems = new ColumnList(cursor);
        this.ds = ((ColumnList)this.mems).dataStruct();
        if (this.ds == null) {
            return;
        }
        int[] index = this.ds.getPKIndex();
        if (index == null) {
            return;
        }
        CompressIndexTable indexTable = new CompressIndexTable((ColumnList)this.mems, index);
        this.setIndexTable(indexTable);
    }

    public MemoryTable(ICursor cursor, int n) {
        this.mems = new ColumnList(cursor, n);
        this.ds = ((ColumnList)this.mems).dataStruct();
        if (this.ds == null) {
            return;
        }
        int[] index = this.ds.getPKIndex();
        if (index == null) {
            return;
        }
        CompressIndexTable indexTable = new CompressIndexTable((ColumnList)this.mems, index);
        this.setIndexTable(indexTable);
    }

    public boolean isCompressTable() {
        return this.mems instanceof ColumnList;
    }

    public Sequence append(Sequence table) {
        IArray addMems = table.getMems();
        DataStruct ds = this.ds;
        int addCount = addMems.size();
        for (int i = 1; i <= addCount; ++i) {
            Record r = (Record)addMems.get(i);
            r.setDataStruct(ds);
        }
        this.mems.addAll(addMems);
        return this;
    }

    public Sequence update(Sequence data, String opt) {
        Record r;
        int i;
        DataStruct ds;
        boolean isInsert = true;
        boolean isUpdate = true;
        Sequence result = null;
        if (opt != null) {
            if (opt.indexOf(105) != -1) {
                isUpdate = false;
            }
            if (opt.indexOf(117) != -1) {
                if (!isUpdate) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(opt + mm.getMessage("engine.optConflict"));
                }
                isInsert = false;
            }
            if (opt.indexOf(110) != -1) {
                result = new Sequence();
            }
        }
        if ((ds = data.dataStruct()) == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        if (!ds.isCompatible(this.ds)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.dsNotMatch"));
        }
        int oldLen = this.length();
        if (oldLen == 0) {
            if (isInsert) {
                this.append(data);
                if (result != null) {
                    result.addAll(data);
                }
            }
            if (result == null) {
                return this;
            }
            return result;
        }
        ds = this.ds;
        int[] keyIndex = ds.getPKIndex();
        if (keyIndex == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("ds.lessKey"));
        }
        int keyCount = keyIndex.length;
        int len = data.length();
        int[] seqs = new int[len + 1];
        if (keyCount == 1) {
            int k = keyIndex[0];
            for (i = 1; i <= len; ++i) {
                r = (Record)data.getMem(i);
                seqs[i] = this.pfindByKey(r.getNormalFieldValue(k), true);
            }
        } else {
            Object[] keyValues = new Object[keyCount];
            for (i = 1; i <= len; ++i) {
                r = (Record)data.getMem(i);
                for (int k = 0; k < keyCount; ++k) {
                    keyValues[k] = r.getNormalFieldValue(keyIndex[k]);
                }
                seqs[i] = this.pfindByFields(keyValues, keyIndex);
            }
        }
        IArray mems = this.mems;
        for (i = 1; i <= len; ++i) {
            r = (Record)data.getMem(i);
            if (seqs[i] > 0) {
                if (!isUpdate) continue;
                Record sr = (Record)mems.get(seqs[i]);
                sr.set(r);
                if (result == null) continue;
                result.add(r);
                continue;
            }
            if (!isInsert) continue;
            r = new Record(ds, r.getFieldValues());
            mems.add(r);
            if (result == null) continue;
            result.add(r);
        }
        if (mems.size() > oldLen) {
            this.sortFields(keyIndex);
        }
        this.rebuildIndexTable();
        if (result == null) {
            return this;
        }
        return result;
    }

    public Sequence delete(Sequence data, String opt) {
        if (data == null || data.length() == 0) {
            if (opt == null || opt.indexOf(110) == -1) {
                return this;
            }
            return new Sequence(0);
        }
        String[] pks = this.getPrimary();
        if (pks == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("ds.lessKey"));
        }
        DataStruct ds = data.dataStruct();
        if (ds == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        int keyCount = pks.length;
        int[] keyIndex = new int[keyCount];
        for (int k = 0; k < keyCount; ++k) {
            keyIndex[k] = ds.getFieldIndex(pks[k]);
            if (keyIndex[k] >= 0) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(pks[k] + mm.getMessage("ds.fieldNotExist"));
        }
        IArray mems = this.mems;
        int delCount = 0;
        IArray dataMems = data.getMems();
        int count = dataMems.size();
        int[] index = new int[count];
        Sequence delete = null;
        if (opt != null && opt.indexOf(110) != -1) {
            delete = new Sequence(count);
        }
        if (keyCount == 1) {
            int ki = keyIndex[0];
            for (int i = 1; i <= count; ++i) {
                BaseRecord r = (BaseRecord)dataMems.get(i);
                int seq = this.pfindByKey(r.getNormalFieldValue(ki), true);
                if (seq <= 0) continue;
                index[delCount] = seq;
                ++delCount;
                if (delete == null) continue;
                delete.add(r);
            }
        } else {
            int[] srcPKIndex = this.ds.getPKIndex();
            Object[] keyValues = new Object[keyCount];
            for (int i = 1; i <= count; ++i) {
                BaseRecord r = (BaseRecord)dataMems.get(i);
                for (int k = 0; k < keyCount; ++k) {
                    keyValues[k] = r.getNormalFieldValue(keyIndex[k]);
                }
                int seq = this.pfindByFields(keyValues, srcPKIndex);
                if (seq <= 0) continue;
                index[delCount] = seq;
                ++delCount;
                if (delete == null) continue;
                delete.add(r);
            }
        }
        if (delCount == 0) {
            if (opt == null || opt.indexOf(110) == -1) {
                return this;
            }
            return new Sequence(0);
        }
        if (delCount < count) {
            int[] tmp = new int[delCount];
            System.arraycopy(index, 0, tmp, 0, delCount);
            index = tmp;
        }
        Arrays.sort(index);
        mems.remove(index);
        this.rebuildIndexTable();
        if (delete == null) {
            return this;
        }
        return delete;
    }

    public Object findByKey(Object key, boolean isSorted) {
        IndexTable indexTable = this.getIndexTable();
        if (indexTable == null) {
            int index = this.pfindByKey(key, true);
            return index > 0 ? this.mems.get(index) : null;
        }
        if (key instanceof Sequence) {
            Sequence seq;
            int klen;
            if (this.length() == 0) {
                return null;
            }
            Object startVal = this.mems.get(1);
            if (startVal instanceof BaseRecord) {
                startVal = ((BaseRecord)startVal).getPKValue();
            }
            if ((klen = (seq = (Sequence)key).length()) == 0) {
                return 0;
            }
            if (startVal instanceof Sequence) {
                int klen2 = ((Sequence)startVal).length();
                if (klen2 == 1) {
                    return indexTable.find(seq.getMem(1));
                }
                if (klen > klen2) {
                    Object[] vals = new Object[klen2];
                    for (int i = 1; i <= klen2; ++i) {
                        vals[i - 1] = seq.getMem(i);
                    }
                    return indexTable.find(vals);
                }
                return indexTable.find(seq.toArray());
            }
            return indexTable.find(seq.getMem(1));
        }
        return indexTable.find(key);
    }

    public void setDistribute(String exp) {
        this._$8 = exp;
    }

    public String getDistribute() {
        return this._$8;
    }

    public void setPart(int part) {
        this._$7 = part;
    }

    public int getPart() {
        return this._$7;
    }

    public void setSegmentFields(String[] fields) {
        IntArrayList list = new IntArrayList(fields.length);
        for (String field : fields) {
            int f = this.ds.getFieldIndex(field);
            if (f == -1) continue;
            list.addInt(f);
        }
        if (list.size() > 0) {
            this._$6 = list.toIntArray();
        }
    }

    public void setSegmentField1() {
        this._$6 = new int[]{0};
    }

    public int[] getSegmentFields() {
        return this._$6;
    }

    private int _$1(int i, int[] segmentFields) {
        BaseRecord r = (BaseRecord)this.getMem(i);
        int len = this.length();
        ++i;
        while (i <= len) {
            BaseRecord record = (BaseRecord)this.getMem(i);
            if (!r.isEquals(record, segmentFields)) {
                return i;
            }
            ++i;
        }
        return len + 1;
    }

    public ICursor cursor(int segSeq, int segCount, Context ctx) {
        int end;
        if (segCount <= 1) {
            return new MemoryCursor(this);
        }
        int len = this.length();
        int blockSize = len / segCount;
        int[] segmentFields = this._$6;
        if (segSeq < 1) {
            if (blockSize < 0) {
                return new MemoryCursor(this);
            }
            ICursor[] cursors = new ICursor[segCount];
            int start = 1;
            if (segmentFields == null) {
                for (int i = 1; i <= segCount; ++i) {
                    int end2 = i == segCount ? len + 1 : start + blockSize;
                    cursors[i - 1] = new MemoryCursor(this, start, end2);
                    start = end2;
                }
            } else {
                for (int i = 1; i <= segCount; ++i) {
                    int end3;
                    if (i == segCount) {
                        end3 = len + 1;
                    } else {
                        end3 = blockSize * i;
                        if (start <= end3) {
                            end3 = this._$1(end3, segmentFields);
                        }
                    }
                    cursors[i - 1] = new MemoryCursor(this, start, end3);
                    start = end3;
                }
            }
            return new MultipathCursors(cursors, ctx);
        }
        int start = 1;
        if (segSeq == segCount) {
            start = blockSize * (segSeq - 1) + 1;
            end = len + 1;
        } else {
            start = blockSize * (segSeq - 1) + 1;
            end = start + blockSize;
        }
        if (segmentFields != null) {
            if (start > 1) {
                start = this._$1(start - 1, segmentFields);
            }
            if (start < end) {
                end = this._$1(end - 1, segmentFields);
            }
        }
        return new MemoryCursor(this, start, end);
    }

    public MemoryTableIndex getIndex(String name) {
        List<MemoryTableIndex> indexs = this._$5;
        if (indexs == null || indexs.size() == 0) {
            return null;
        }
        for (MemoryTableIndex index : indexs) {
            if (!index.getByName(name)) continue;
            return index;
        }
        return null;
    }

    public void createIMemoryTableIndex(String I, String[] fields, Object obj, String opt, Expression w, Context ctx) {
        if (this.getIndex(I) != null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(I + " " + mm.getMessage("dw.indexNameAlreadyExist"));
        }
        List<MemoryTableIndex> indexs = this._$5;
        if (indexs == null) {
            this._$5 = indexs = new ArrayList<MemoryTableIndex>();
        }
        if (obj == null) {
            if (opt != null) {
                if (opt.indexOf(119) != -1) {
                    MemoryTableIndex index = new MemoryTableIndex(I, this, fields, w, 0, 2, ctx);
                    indexs.add(index);
                    return;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("index" + mm.getMessage("function.invalidParam"));
            }
            MemoryTableIndex index = new MemoryTableIndex(I, this, fields, w, 0, 0, ctx);
            indexs.add(index);
        } else if (obj instanceof String[]) {
            MemoryTableIndex index = new MemoryTableIndex(I, this, fields, w, 0, 0, ctx);
            indexs.add(index);
        } else if (obj instanceof Integer) {
            MemoryTableIndex index = new MemoryTableIndex(I, this, fields, w, (Integer)obj, 1, ctx);
            indexs.add(index);
        }
    }

    private String _$1(String[] fieldNames) {
        if (fieldNames == null || this._$5 == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int count = this._$5.size();
        int fcount = fieldNames.length;
        for (int i = 0; i < count; ++i) {
            String[] ifields = this._$5.get(i).getIfields();
            int cnt = ifields.length;
            if (cnt < fcount) continue;
            list.clear();
            for (int j = 0; j < fcount; ++j) {
                list.add(ifields[j]);
            }
            for (String str : fieldNames) {
                list.remove(str);
            }
            if (!list.isEmpty()) continue;
            return this._$5.get(i).getName();
        }
        return null;
    }

    public ICursor icursor(String[] fields, Expression filter, String iname, String opt, Context ctx) {
        MemoryTableIndex index = null;
        if (iname != null) {
            index = this.getIndex(iname);
            if (index == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("icursor" + mm.getMessage("dw.indexNotExist") + " : " + iname);
            }
        } else {
            String[] indexFields;
            if (filter.getHome() instanceof DotOperator) {
                Node right = filter.getHome().getRight();
                if (!(right instanceof Contain)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("icursor" + mm.getMessage("function.invalidParam"));
                }
                String str = ((Contain)right).getParamString();
                str = str.replaceAll("\\[", "");
                str = str.replaceAll("\\]", "");
                str = str.replaceAll(" ", "");
                indexFields = str.split(",");
            } else if (filter.getHome() instanceof Like) {
                IParam sub1 = ((Like)filter.getHome()).getParam().getSub(0);
                String f = sub1.getLeafExpression().getIdentifierName();
                indexFields = new String[]{f};
            } else {
                indexFields = PhyTable.getExpFields(filter, this.ds.getFieldNames());
            }
            String indexName = this._$1(indexFields);
            if (indexFields == null || indexName == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("icursor" + mm.getMessage("function.invalidParam"));
            }
            index = this.getIndex(indexName);
        }
        ICursor cursor = index.select(filter, fields, opt, ctx);
        return cursor;
    }

    public Object ifind(Object key, String iname, String opt, Context ctx) {
        MemoryTableIndex index = null;
        index = this.getIndex(iname);
        if (index == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("ifind" + mm.getMessage("dw.indexNotExist") + " : " + iname);
        }
        return index.ifind(key, opt, ctx);
    }
}

