/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.FileObject;
import com.scudata.dm.LongArray;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ConjxCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MergeCursor2;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dm.op.Select;
import com.scudata.dw.BlockLink;
import com.scudata.dw.BlockLinkReader;
import com.scudata.dw.BlockLinkWriter;
import com.scudata.dw.BufferReader;
import com.scudata.dw.BufferWriter;
import com.scudata.dw.ColPhyTable;
import com.scudata.dw.ColumnMetaData;
import com.scudata.dw.ComTable;
import com.scudata.dw.Cuboid;
import com.scudata.dw.IDWCursor;
import com.scudata.dw.IPhyTable;
import com.scudata.dw.ITableIndex;
import com.scudata.dw.IndexCursor;
import com.scudata.dw.IndexFCursor;
import com.scudata.dw.ModifyRecord;
import com.scudata.dw.PhyTableIndex;
import com.scudata.dw.RowPhyTable;
import com.scudata.dw.StructManager;
import com.scudata.dw.TableFulltextIndex;
import com.scudata.dw.TableHashIndex;
import com.scudata.dw.TableKeyValueIndex;
import com.scudata.dw.lllllIlIIlIIIIII;
import com.scudata.expression.CurrentElement;
import com.scudata.expression.Expression;
import com.scudata.expression.FieldRef;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.Operator;
import com.scudata.expression.UnknownSymbol;
import com.scudata.expression.ValueList;
import com.scudata.expression.fn.string.Like;
import com.scudata.expression.mfn.sequence.Contain;
import com.scudata.expression.mfn.serial.Sbs;
import com.scudata.expression.operator.Add;
import com.scudata.expression.operator.And;
import com.scudata.expression.operator.DotOperator;
import com.scudata.expression.operator.Equals;
import com.scudata.expression.operator.Greater;
import com.scudata.expression.operator.NotGreater;
import com.scudata.expression.operator.NotSmaller;
import com.scudata.expression.operator.Smaller;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PhyTable
implements IPhyTable {
    protected static String KEY_PREFIX = "#";
    protected static int MIN_BLOCK_RECORD_COUNT = 8192;
    protected static int MAX_BLOCK_RECORD_COUNT = 163840;
    protected byte[] reserve = new byte[32];
    protected ComTable groupTable;
    protected PhyTable parent;
    protected ArrayList<PhyTable> tableList;
    protected String segmentCol;
    protected int segmentSerialLen;
    protected String tableName;
    protected String[] colNames;
    protected String[] allColNames;
    protected int dataBlockCount;
    protected long totalRecordCount;
    protected BlockLink segmentBlockLink;
    protected byte curModifyBlock;
    protected BlockLink modifyBlockLink1;
    protected BlockLink modifyBlockLink2;
    protected Object[] maxValues;
    protected boolean hasPrimaryKey = true;
    public boolean isSorted = true;
    protected String[] indexNames;
    protected String[][] indexFields;
    protected String[][] indexValueFields;
    protected String[] cuboids;
    protected transient DataStruct ds;
    protected transient BlockLinkWriter segmentWriter;
    protected transient ArrayList<ModifyRecord> modifyRecords;
    private transient HashMap<String, SoftReference<ITableIndex>> _$1 = new HashMap();
    protected Sequence appendCache;

    public boolean isBaseTable() {
        return this.parent == null;
    }

    public boolean isSingleTable() {
        return this.parent == null && (this.tableList == null || this.tableList.size() == 0);
    }

    @Override
    public void close() {
        this.getGroupTable().close();
    }

    @Override
    public PhyTable createAnnexTable(String[] colNames, int[] serialBytesLen, String tableName) throws IOException {
        if (!this.hasPrimaryKey) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.lessKey"));
        }
        if (this.getAnnexTable(tableName) != null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(tableName + mm.getMessage("dw.tableAlreadyExist"));
        }
        this.appendCache();
        this.groupTable.checkWritable();
        PhyTable table = null;
        table = this instanceof ColPhyTable ? new ColPhyTable(this.groupTable, colNames, serialBytesLen, tableName, (ColPhyTable)this) : new RowPhyTable(this.groupTable, colNames, serialBytesLen, tableName, (RowPhyTable)this);
        this.tableList.add(table);
        PhyTable tmd = this.getSupplementTable(false);
        if (tmd != null) {
            tmd.createAnnexTable(colNames, serialBytesLen, tableName);
        }
        this.groupTable._$3();
        return table;
    }

    @Override
    public PhyTable getAnnexTable(String tableName) {
        for (PhyTable table : this.tableList) {
            if (!table.isTable(tableName)) continue;
            return table;
        }
        return null;
    }

    StructManager _$1() {
        return this.groupTable.getStructManager();
    }

    public PhyTable getParent() {
        return this.parent;
    }

    public ArrayList<PhyTable> getTableList() {
        return this.tableList;
    }

    public static void setMinBlockRecordCount(int count) {
        MIN_BLOCK_RECORD_COUNT = count;
    }

    public static void setMaxBlockRecordCount(int count) {
        MAX_BLOCK_RECORD_COUNT = count;
    }

    protected abstract void init();

    public void setSegmentCol(String col, int serialLen) throws IOException {
        if (col == null) {
            return;
        }
        if (col.startsWith("#")) {
            col = col.substring(1);
        }
        this.segmentCol = col;
        this.segmentSerialLen = serialLen;
        this.groupTable._$3();
    }

    public String getSegmentCol() {
        if (this.parent != null) {
            return this.parent.getSegmentCol();
        }
        return this.segmentCol;
    }

    public int getSegmentSerialLen() {
        if (this.parent != null) {
            return this.parent.getSegmentSerialLen();
        }
        return this.segmentSerialLen;
    }

    public DataStruct getDataStruct() {
        return this.ds;
    }

    public ComTable getGroupTable() {
        return this.groupTable;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String[] getColNames() {
        return this.colNames;
    }

    public String getColName(int col) {
        return this.colNames[col];
    }

    @Override
    public String[] getAllColNames() {
        if (this.parent == null) {
            return this.colNames;
        }
        return this.allColNames;
    }

    public String[] getIndexNames() {
        return this.indexNames;
    }

    public String[][] getIndexFields() {
        return this.indexFields;
    }

    public String[][] getIndexValueFields() {
        return this.indexValueFields;
    }

    public String chooseIndex(String[] fieldNames) {
        if (fieldNames == null || this.indexNames == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int count = this.indexNames.length;
        int fcount = fieldNames.length;
        for (int i = 0; i < count; ++i) {
            int cnt = this.indexFields[i].length;
            if (cnt < fcount) continue;
            list.clear();
            for (int j = 0; j < fcount; ++j) {
                list.add(this.indexFields[i][j]);
            }
            for (String str : fieldNames) {
                list.remove(str);
            }
            if (!list.isEmpty()) continue;
            return this.indexNames[i];
        }
        return null;
    }

    @Override
    public boolean deleteIndex(String indexName) throws IOException {
        this.getGroupTable().checkWritable();
        PhyTable tmd = this.getSupplementTable(false);
        if (tmd != null) {
            tmd.deleteIndex(indexName);
        }
        String[] oldFileName = this.indexNames;
        String dir = this.groupTable.getFile().getAbsolutePath() + "_";
        if (oldFileName == null) {
            return false;
        }
        if (indexName == null) {
            for (String name : oldFileName) {
                FileObject tmpFile = new FileObject(dir + this.tableName + "_" + name);
                tmpFile.delete();
            }
            this.indexNames = null;
        } else {
            FileObject tmpFile = new FileObject(dir + this.tableName + "_" + indexName);
            if (!tmpFile.isExists()) {
                return false;
            }
            int size = oldFileName.length;
            int id = -1;
            for (int i = 0; i < size; ++i) {
                if (!oldFileName[i].equals(indexName)) continue;
                id = i;
                break;
            }
            if (id < 0) {
                return false;
            }
            if (size == 1) {
                this.indexNames = null;
                this.indexFields = null;
                this.indexValueFields = null;
            } else {
                String[][] oldIndexFields = this.indexFields;
                String[][] oldIndexValueFields = this.indexValueFields;
                this.indexNames = new String[size - 1];
                this.indexFields = new String[size - 1][];
                this.indexValueFields = new String[size - 1][];
                int j = 0;
                for (int i = 0; i < size; ++i) {
                    if (i == id) continue;
                    this.indexNames[j] = oldFileName[i];
                    this.indexFields[j] = oldIndexFields[i];
                    this.indexValueFields[j] = oldIndexValueFields[i];
                    ++j;
                }
            }
            tmpFile.delete();
        }
        this.groupTable._$3();
        return true;
    }

    public void addIndex(String indexName, String[] indexFields, String[] indexValueFields) throws IOException {
        PhyTable tmd = this.getSupplementTable(false);
        if (tmd != null) {
            tmd.addIndex(indexName, indexFields, indexValueFields);
        }
        int size = 0;
        if (this.indexNames != null) {
            size = this.indexNames.length;
        }
        String[] newNames = new String[size + 1];
        String[][] newFieldNames = new String[size + 1][];
        String[][] newValueFieldNames = new String[size + 1][];
        if (size > 0) {
            System.arraycopy(this.indexNames, 0, newNames, 0, size);
            System.arraycopy(this.indexFields, 0, newFieldNames, 0, size);
            System.arraycopy(this.indexValueFields, 0, newValueFieldNames, 0, size);
        }
        newNames[size] = indexName;
        newFieldNames[size] = indexFields;
        newValueFieldNames[size] = indexValueFields;
        this.indexNames = newNames;
        this.indexFields = newFieldNames;
        this.indexValueFields = newValueFieldNames;
        this.groupTable._$3();
    }

    public void updateIndex() {
        if (this.indexNames == null) {
            return;
        }
        Context ctx = this.groupTable.ctx;
        String dir = this.groupTable.getFile().getAbsolutePath() + "_";
        int size = this.indexNames.length;
        for (int i = 0; i < size; ++i) {
            ITableIndex index;
            byte[] type;
            FileObject tmpFile = new FileObject(dir + this.tableName + "_" + this.indexNames[i]);
            try {
                type = (byte[])tmpFile.read(6L, 6L, "b");
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
            String[] ifields = this.indexFields[i];
            String[] vfields = this.indexValueFields[i];
            if (type[0] == 104) {
                index = new TableHashIndex(this, this.indexNames[i]);
                ((TableHashIndex)index).setFields(ifields, vfields);
                ((TableHashIndex)index).create(this.indexFields[i], "a", ctx, null);
                continue;
            }
            if (type[0] == 120) {
                index = new PhyTableIndex(this, this.indexNames[i]);
                ((PhyTableIndex)index).setFields(ifields, vfields);
                ((PhyTableIndex)index).create(this.indexFields[i], "a", ctx, null);
                continue;
            }
            index = new TableKeyValueIndex(this, this.indexNames[i]);
            ((TableKeyValueIndex)index).setFields(ifields, vfields);
            ((TableKeyValueIndex)index).create(this.indexFields[i], this.indexValueFields[i], "a", ctx, null);
        }
    }

    @Override
    public void createIndex(String I, String[] fields, Object obj, String opt, Expression w, Context ctx) {
        PhyTable tmd = this.getSupplementTable(false);
        if (tmd != null) {
            tmd.createIndex(I, fields, obj, opt, w, ctx);
        }
        try {
            this.appendCache();
        }
        catch (IOException e) {
            throw new RQException(e);
        }
        if (obj == null) {
            if (opt != null) {
                if (opt.indexOf(119) != -1) {
                    TableFulltextIndex index = new TableFulltextIndex(this, I, (Integer)obj);
                    index.create(fields, opt, ctx, w);
                    return;
                }
                FileObject indexFile = null;
                String dir = this.getGroupTable().getFile().getAbsolutePath() + "_";
                if (I != null && !(indexFile = new FileObject(dir + this.getTableName() + "_" + I)).isExists()) {
                    return;
                }
                ITableIndex index = this.getTableMetaDataIndex(indexFile, I, true);
                if (opt.indexOf(50) != -1) {
                    index.loadAllBlockInfo();
                } else if (opt.indexOf(51) != -1) {
                    index.loadAllKeys();
                } else if (opt.indexOf(48) != -1) {
                    index.unloadAllBlockInfo();
                }
                return;
            }
            PhyTableIndex index = new PhyTableIndex(this, I);
            index.create(fields, opt, ctx, w);
        } else if (obj instanceof String[]) {
            TableKeyValueIndex index = new TableKeyValueIndex(this, I);
            index.create(fields, (String[])obj, opt, ctx, w);
        } else if (obj instanceof Integer) {
            TableHashIndex index = new TableHashIndex(this, I, (int)((Integer)obj));
            index.create(fields, opt, ctx, w);
        }
    }

    public void createIndex(FileObject file, String[] fields, Object obj, String opt, Expression w, Context ctx) {
        PhyTable tmd = this.getSupplementTable(false);
        if (tmd != null) {
            tmd.createIndex(file, fields, obj, opt, w, ctx);
        }
        try {
            this.appendCache();
        }
        catch (IOException e) {
            throw new RQException(e);
        }
        boolean hasOpt = false;
        if (opt == null) {
            opt = "U";
        } else {
            hasOpt = true;
            opt = opt + "U";
        }
        if (hasOpt && opt.indexOf(119) != -1) {
            TableFulltextIndex index = new TableFulltextIndex(this, file, (Integer)obj);
            index.create(fields, opt, ctx, w);
            return;
        }
        if (obj == null) {
            if (hasOpt) {
                FileObject indexFile = file;
                String[][] fileds = PhyTableIndex.readIndexFields(file);
                ITableIndex index = this.getTableMetaDataIndex(indexFile, fileds[0], fileds[1], true);
                if (opt.indexOf(50) != -1) {
                    index.loadAllBlockInfo();
                } else if (opt.indexOf(51) != -1) {
                    index.loadAllKeys();
                } else if (opt.indexOf(48) != -1) {
                    index.unloadAllBlockInfo();
                }
                return;
            }
            PhyTableIndex index = new PhyTableIndex(this, file);
            index.create(fields, opt, ctx, w);
        } else if (obj instanceof String[]) {
            TableKeyValueIndex index = new TableKeyValueIndex(this, file);
            index.create(fields, (String[])obj, opt, ctx, w);
        } else if (obj instanceof Integer) {
            TableHashIndex index = new TableHashIndex(this, file, (int)((Integer)obj));
            index.create(fields, opt, ctx, w);
        }
    }

    public void resetIndex(Context ctx) {
        this.getGroupTable().checkWritable();
        if (this.indexNames == null) {
            return;
        }
        String dir = this.groupTable.getFile().getAbsolutePath() + "_";
        int size = this.indexNames.length;
        for (int i = 0; i < size; ++i) {
            ITableIndex index;
            byte[] type;
            FileObject tmpFile = new FileObject(dir + this.tableName + "_" + this.indexNames[i]);
            try {
                type = (byte[])tmpFile.read(6L, 6L, "b");
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
            if (type[0] == 104) {
                index = new TableHashIndex(this, this.indexNames[i]);
                ((TableHashIndex)index).create(this.indexFields[i], "ar", ctx, null);
                continue;
            }
            if (type[0] == 120) {
                index = new PhyTableIndex(this, this.indexNames[i]);
                ((PhyTableIndex)index).create(this.indexFields[i], "ar", ctx, null);
                continue;
            }
            if (type[0] == 118) {
                index = new TableKeyValueIndex(this, this.indexNames[i]);
                ((TableKeyValueIndex)index).create(this.indexFields[i], this.indexValueFields[i], "ar", ctx, null);
                continue;
            }
            index = new TableFulltextIndex(this, this.indexNames[i], null);
            ((PhyTableIndex)index).create(this.indexFields[i], "ar", ctx, null);
        }
    }

    public abstract String[] getSortedColNames();

    @Override
    public abstract String[] getAllSortedColNames();

    public int[] getSortedColIndex() {
        String[] keyNames = this.parent == null ? this.getSortedColNames() : this.getAllSortedColNames();
        int sortedColCount = keyNames.length;
        int[] findex = new int[sortedColCount];
        for (int f = 0; f < sortedColCount; ++f) {
            findex[f] = this.ds.getFieldIndex(keyNames[f]);
        }
        return findex;
    }

    public boolean isTable(String name) {
        return this.tableName.equals(name);
    }

    public long getTotalRecordCount() {
        return this.totalRecordCount;
    }

    public long getActualRecordCount() {
        long count = this.totalRecordCount;
        ArrayList<ModifyRecord> modifyRecords = this.getModifyRecords();
        if (modifyRecords != null) {
            for (ModifyRecord r : modifyRecords) {
                if (r.isDelete()) {
                    --count;
                    continue;
                }
                if (!r.isInsert()) continue;
                ++count;
            }
        }
        return count;
    }

    public int getDataBlockCount() {
        return this.dataBlockCount;
    }

    public int getAllSortedColNamesLength() {
        String[] names = this.getAllSortedColNames();
        if (names == null) {
            return 0;
        }
        return names.length;
    }

    public boolean hasPrimaryKey() {
        return this.hasPrimaryKey;
    }

    protected abstract void applyFirstBlock() throws IOException;

    public BlockLinkReader getSegmentReader() {
        BlockLinkReader reader = new BlockLinkReader(this.segmentBlockLink);
        try {
            reader.loadFirstBlock();
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        return reader;
    }

    protected abstract void prepareAppend() throws IOException;

    protected abstract void finishAppend() throws IOException;

    public abstract void readExternal(BufferReader var1) throws IOException;

    public abstract void writeExternal(BufferWriter var1) throws IOException;

    public abstract void appendCache() throws IOException;

    public abstract int[] getSerialBytesLen();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveModifyRecords() throws IOException {
        Object syncObj;
        BufferWriter writer = new BufferWriter(this._$1());
        ArrayList<ModifyRecord> modifyRecords = this.modifyRecords;
        if (modifyRecords == null) {
            return;
        }
        int count = modifyRecords.size();
        writer.writeInt(count);
        for (int i = 0; i < count; ++i) {
            ModifyRecord r = modifyRecords.get(i);
            r.writeExternal(writer);
        }
        Object object = syncObj = this.groupTable._$1();
        synchronized (object) {
            BlockLink modifyBlockLink = null;
            if (this.curModifyBlock == 2) {
                modifyBlockLink = this.modifyBlockLink1;
                this.curModifyBlock = 1;
            } else {
                modifyBlockLink = this.modifyBlockLink2;
                this.curModifyBlock = (byte)2;
            }
            if (modifyBlockLink.isEmpty()) {
                modifyBlockLink.setFirstBlockPos(this.groupTable.applyNewBlock());
            }
            BlockLinkWriter blockWriter = new BlockLinkWriter(modifyBlockLink, false);
            blockWriter.rewriteBlocks(writer.finish());
            blockWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ModifyRecord> getModifyRecords() {
        if (this.modifyRecords != null) {
            if (this.modifyRecords.size() == 0) {
                return null;
            }
            return this.modifyRecords;
        }
        if (this.modifyBlockLink1.isEmpty() && this.modifyBlockLink2.isEmpty()) {
            return null;
        }
        try {
            byte[] bytes;
            Object syncObj;
            Object object = syncObj = this.groupTable._$1();
            synchronized (object) {
                BlockLink modifyBlockLink = null;
                modifyBlockLink = this.curModifyBlock == 2 ? this.modifyBlockLink2 : this.modifyBlockLink1;
                BlockLinkReader blockReader = new BlockLinkReader(modifyBlockLink);
                bytes = blockReader.readBlocks();
                blockReader.close();
            }
            BufferReader reader = new BufferReader(this._$1(), bytes);
            int count = reader.readInt();
            ArrayList<ModifyRecord> modifyRecords = new ArrayList<ModifyRecord>(count);
            this.modifyRecords = modifyRecords;
            DataStruct ds = new DataStruct(this.getAllColNames());
            for (int i = 0; i < count; ++i) {
                ModifyRecord r = new ModifyRecord();
                r.readExternal(reader, ds);
                modifyRecords.add(r);
            }
            if (count == 0) {
                return null;
            }
            return modifyRecords;
        }
        catch (IOException e) {
            throw new RQException(e);
        }
    }

    @Override
    public abstract Sequence update(Sequence var1, String var2) throws IOException;

    @Override
    public abstract Sequence delete(Sequence var1, String var2) throws IOException;

    public static String[] getExpFields(Expression exp, String[] colNames) {
        ArrayList<String> fields = new ArrayList<String>();
        PhyTable._$1(exp.getHome(), fields, colNames);
        int size = fields.size();
        if (size == 0) {
            return null;
        }
        String[] array = new String[size];
        fields.toArray(array);
        return array;
    }

    public ArrayList<String> getExpFields(Expression[] exps) {
        if (exps == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        String[] columns = this.getAllColNames();
        int srcCount = columns.length;
        int count = exps.length;
        block0: for (int i = 0; i < count; ++i) {
            if (exps[i].getHome() instanceof DotOperator) {
                String col = null;
                Node left = exps[i].getHome().getLeft();
                Node right = exps[i].getHome().getRight();
                if (!(left instanceof UnknownSymbol) || !(right instanceof Sbs)) continue;
                col = ((UnknownSymbol)left).getName();
                for (int s = 0; s < srcCount; ++s) {
                    if (!columns[s].equals(col)) continue;
                    if (result.contains(columns[s])) continue block0;
                    result.add(columns[s]);
                    continue block0;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException(col + mm.getMessage("ds.fieldNotExist"));
            }
            if (!(exps[i].getHome() instanceof Add)) continue;
            String col1 = null;
            String col2 = null;
            Node obj1 = exps[i].getHome().getLeft();
            Node obj2 = exps[i].getHome().getRight();
            if (obj1 instanceof UnknownSymbol && obj2 instanceof UnknownSymbol) {
                col1 = ((UnknownSymbol)obj1).getName();
                col2 = ((UnknownSymbol)obj2).getName();
            }
            boolean b1 = false;
            boolean b2 = false;
            for (int s = 0; s < srcCount; ++s) {
                if (columns[s].equals(col1)) {
                    if (!result.contains(columns[s])) {
                        result.add(columns[s]);
                    }
                    b1 = true;
                }
                if (!columns[s].equals(col2)) continue;
                if (!result.contains(columns[s])) {
                    result.add(columns[s]);
                }
                b2 = true;
            }
            if (b1 && b2) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(col1 + " or " + col2 + mm.getMessage("ds.fieldNotExist"));
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    private static void _$1(Node home, ArrayList<String> fields, String[] colNames) {
        int index = PhyTable._$1(home, colNames);
        if (index >= 0) {
            String s = colNames[index];
            if (!fields.contains(s)) {
                fields.add(s);
            }
            return;
        }
        Node left = home.getLeft();
        Node right = home.getRight();
        if (left != null) {
            PhyTable._$1(left, fields, colNames);
        }
        if (right != null) {
            PhyTable._$1(right, fields, colNames);
        }
    }

    private static int _$1(Node node, String[] keyNames) {
        block3: {
            block2: {
                if (!(node instanceof UnknownSymbol)) break block2;
                String keyName = ((UnknownSymbol)node).getName();
                int len = keyNames.length;
                for (int i = 0; i < len; ++i) {
                    if (!keyName.equals(keyNames[i])) continue;
                    return i;
                }
                break block3;
            }
            if (!(node instanceof DotOperator) || !(node.getLeft() instanceof CurrentElement) || !(node.getRight() instanceof FieldRef)) break block3;
            FieldRef fieldNode = (FieldRef)node.getRight();
            String keyName = fieldNode.getName();
            int len = keyNames.length;
            for (int i = 0; i < len; ++i) {
                if (!keyName.equals(keyNames[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static ArrayList<ModifyRecord> getModifyRecord(PhyTable table, Expression exp, Context ctx) {
        ArrayList<ModifyRecord> modifyRecords = table.getModifyRecords();
        if (modifyRecords == null) {
            return null;
        }
        int size = modifyRecords.size();
        ArrayList<ModifyRecord> mrs = new ArrayList<ModifyRecord>(size);
        for (int i = 0; i < size; ++i) {
            ModifyRecord mr = modifyRecords.get(i);
            if (mr.isDelete()) {
                mrs.add(mr);
                continue;
            }
            if (exp != null) {
                Record sr = mr.getRecord();
                if (Variant.isTrue(sr.calc(exp, ctx))) {
                    mrs.add(mr);
                    continue;
                }
                if (!mr.isUpdate()) continue;
                ModifyRecord temp = new ModifyRecord(mr.getRecordSeq());
                temp.setDelete();
                mrs.add(temp);
                continue;
            }
            mrs.add(mr);
        }
        if (mrs.size() == 0) {
            return null;
        }
        return mrs;
    }

    abstract long[] _$1(String var1, Node var2, Context var3);

    private void _$1(Node home, ArrayList<Object> indexs, ArrayList<Long> intervals, FileObject[] indexFiles, Context ctx) {
        if (!(home instanceof Operator) && !(home instanceof Like)) {
            return;
        }
        Node left = home.getLeft();
        Node right = home.getRight();
        if (home instanceof And) {
            this._$1(left, indexs, intervals, indexFiles, ctx);
            this._$1(right, indexs, intervals, indexFiles, ctx);
            return;
        }
        String[] fields = null;
        if (home instanceof Equals || home instanceof NotSmaller || home instanceof Greater || home instanceof NotGreater || home instanceof Smaller) {
            if (left instanceof UnknownSymbol) {
                fields = new String[]{((UnknownSymbol)left).getName()};
            } else if (right instanceof UnknownSymbol) {
                fields = new String[]{((UnknownSymbol)right).getName()};
            }
        } else if (home instanceof DotOperator) {
            if (!(left instanceof ValueList) || !(right instanceof Contain)) {
                return;
            }
            String str = ((Contain)right).getParamString();
            str = str.replaceAll("\\[", "");
            str = str.replaceAll("\\]", "");
            str = str.replaceAll(" ", "");
            fields = str.split(",");
        } else if (home instanceof Like) {
            if (((Like)home).getParam().getSubSize() != 2) {
                return;
            }
            IParam sub1 = ((Like)home).getParam().getSub(0);
            fields = new String[]{sub1.getLeafExpression().getIdentifierName()};
        }
        if (fields == null) {
            return;
        }
        ITableIndex index = null;
        if (indexFiles == null) {
            String indexName = this.chooseIndex(fields);
            if (indexName == null) {
                long[] posArray = this._$1(fields[0], home, ctx);
                if (posArray != null) {
                    for (long pos : posArray) {
                        if (intervals.contains(pos)) continue;
                        intervals.add(pos);
                    }
                }
                return;
            }
            String dir = this.getGroupTable().getFile().getAbsolutePath() + "_";
            FileObject indexFile = new FileObject(dir + this.getTableName() + "_" + indexName);
            index = this.getTableMetaDataIndex(indexFile, indexName, true);
        } else {
            for (FileObject file : indexFiles) {
                String[][] indexFileds = PhyTableIndex.readIndexFields(file);
                if (!PhyTableIndex.isCompatible(fields, indexFileds[0])) continue;
                index = this.getTableMetaDataIndex(file, indexFileds[0], indexFileds[1], true);
                break;
            }
        }
        if (index == null) {
            return;
        }
        if (index instanceof TableKeyValueIndex) {
            return;
        }
        if (index instanceof TableHashIndex && !(home instanceof Equals) && !(home instanceof DotOperator)) {
            return;
        }
        if (index instanceof TableFulltextIndex) {
            IParam sub2 = ((Like)home).getParam().getSub(1);
            String fmtExp = (String)sub2.getLeafExpression().calculate(null);
            if (fmtExp.length() <= 2) {
                return;
            }
            int idx = fmtExp.indexOf("*");
            if (idx != 0) {
                return;
            }
            idx = (fmtExp = fmtExp.substring(1)).indexOf("*");
            if (idx != fmtExp.length() - 1) {
                return;
            }
        }
        if (home instanceof Equals || home instanceof NotSmaller || home instanceof Greater || home instanceof NotGreater || home instanceof Smaller) {
            int size = indexs.size();
            for (int i = 0; i < size; ++i) {
                if (index != indexs.get(i)) continue;
                Node node = (Node)indexs.get(i + 1);
                And and = new And();
                and.setLeft(node);
                and.setRight(home);
                indexs.set(i + 1, and);
                return;
            }
        }
        indexs.add(index);
        indexs.add(home);
    }

    private LongArray _$1(LongArray a, ArrayList<Long> intervals) {
        if (a == null || a.size() == 0) {
            return a;
        }
        int intervalSize = intervals.size();
        Object[] intervalArray = new Long[intervalSize];
        intervals.toArray(intervalArray);
        Arrays.sort(intervalArray);
        int j = 0;
        int size = a.size();
        LongArray c = new LongArray(size);
        if (this instanceof RowPhyTable) {
            block0: for (int i = 0; i < size; i += 2) {
                long seq = a.get(i);
                long pos = a.get(i + 1);
                while (j < intervalSize) {
                    long from = (Long)intervalArray[j];
                    long to = (Long)intervalArray[j + 1];
                    if (pos < from) continue block0;
                    if (pos > to) {
                        j += 2;
                        continue;
                    }
                    if (pos < from || pos > to) continue;
                    c.add(seq);
                    c.add(pos);
                    continue block0;
                }
            }
        } else {
            block2: for (int i = 0; i < size; ++i) {
                long pos = a.get(i);
                while (j < intervalSize) {
                    long from = (Long)intervalArray[j];
                    long to = (Long)intervalArray[j + 1];
                    if (pos < from) continue block2;
                    if (pos > to) {
                        j += 2;
                        continue;
                    }
                    if (pos < from || pos > to) continue;
                    c.add(pos);
                    continue block2;
                }
            }
        }
        return c;
    }

    static LongArray _$1(LongArray a, long[] b) {
        if (a == null) {
            LongArray c = new LongArray(b.length);
            for (long l : b) {
                c.add(l);
            }
            return c;
        }
        int lenA = a.size();
        int lenB = b.length;
        if (lenB == 0) {
            return a;
        }
        LongArray c = new LongArray(Math.min(lenA, lenB));
        int i = 0;
        int j = 0;
        while (i < lenA && j < lenB) {
            if (a.get(i) < b[j]) {
                ++i;
                continue;
            }
            if (b[j] < a.get(i)) {
                ++j;
                continue;
            }
            c.add(a.get(i));
            ++i;
            ++j;
        }
        return c;
    }

    static LongArray _$1(LongArray a, long[] b, int posCount, boolean sort) {
        int i;
        int lenB = b.length;
        ++posCount;
        if (sort) {
            int size = lenB / posCount;
            long[][] posArr = new long[size][];
            for (i = 0; i < size; ++i) {
                long[] posRecord = new long[posCount];
                for (int c = 0; c < posCount; ++c) {
                    posRecord[c] = b[i * posCount + c];
                }
                posArr[i] = posRecord;
            }
            Arrays.sort(posArr, new lllllIlIIlIIIIII());
            i = 0;
            long[][] arr$ = posArr;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                long[] arr;
                for (long l : arr = arr$[i$]) {
                    b[i++] = l;
                }
            }
        }
        if (a == null) {
            LongArray c = new LongArray(b.length);
            for (long l : b) {
                c.add(l);
            }
            return c;
        }
        int lenA = a.size();
        if (lenB == 0) {
            return a;
        }
        LongArray c = new LongArray(Math.min(lenA, lenB));
        i = 0;
        int j = 0;
        while (i < lenA && j < lenB) {
            long longB;
            long longA = a.get(i + 1);
            if (longA < (longB = b[j + 1])) {
                i += posCount;
                continue;
            }
            if (longB < longA) {
                j += posCount;
                continue;
            }
            for (int k = 0; k < posCount; ++k) {
                c.add(a.get(i));
                ++i;
                ++j;
            }
        }
        return c;
    }

    public static int getBlockCount(LongArray recNums, long[] recCountOfSegment) {
        if (recNums == null || recNums.size() == 0) {
            return 0;
        }
        int result = 0;
        int size = recNums.size();
        if (size == 1) {
            return 1;
        }
        int len = recCountOfSegment.length;
        int i = 0;
        int j = 0;
        boolean hasRec = false;
        while (i < size && j < len) {
            long recNum = recNums.get(i);
            if (recNum <= recCountOfSegment[j]) {
                if (!hasRec) {
                    ++result;
                    hasRec = true;
                }
                ++i;
                continue;
            }
            ++j;
            hasRec = false;
        }
        return result;
    }

    @Override
    public ICursor icursor(String[] fields, Expression filter, Object indexObj, String opt, Context ctx) {
        ComTable groupTable = this.getGroupTable();
        groupTable.checkReadable();
        boolean isName = indexObj == null || indexObj instanceof String;
        ICursor cs = isName ? this._$1(fields, filter, (String)indexObj, opt, ctx) : this._$1(fields, filter, (FileObject[])indexObj, opt, ctx);
        PhyTable tmd = this.getSupplementTable(false);
        if (tmd == null) {
            return cs;
        }
        ICursor cs2 = isName ? tmd._$1(fields, filter, (String)indexObj, opt, ctx) : tmd._$1(fields, filter, (FileObject[])indexObj, opt, ctx);
        if (cs == null) {
            return cs2;
        }
        if (cs2 == null) {
            return cs;
        }
        int[] ifields = null;
        if (cs instanceof IndexCursor) {
            ifields = ((IndexCursor)cs).getSortFieldsIndex();
        } else if (cs instanceof IndexFCursor) {
            ifields = ((IndexFCursor)cs).getSortFieldsIndex();
        }
        if (ifields == null && cs2 != null) {
            if (cs2 instanceof IndexCursor) {
                ifields = ((IndexCursor)cs2).getSortFieldsIndex();
            } else if (cs2 instanceof IndexFCursor) {
                ifields = ((IndexFCursor)cs2).getSortFieldsIndex();
            }
        }
        if (ifields != null && ifields.length > 0) {
            return new MergeCursor2(cs, cs2, ifields, null, groupTable.ctx);
        }
        return new ConjxCursor(new ICursor[]{cs, cs2});
    }

    private ICursor _$1(String[] fields, Expression filter, String iname, String opt, Context ctx) {
        FileObject indexFile = null;
        if (filter.getHome() instanceof And) {
            int size;
            ArrayList<Object> indexs = new ArrayList<Object>();
            ArrayList<Long> intervals = new ArrayList<Long>();
            this._$1(filter.getHome(), indexs, intervals, null, ctx);
            int intervalSize = intervals.size();
            if (intervalSize > 0 && intervalSize / 2 <= 10) {
                return this.cursor(fields, filter, ctx);
            }
            if (intervalSize == this.dataBlockCount * 2) {
                intervals.clear();
                intervalSize = 0;
            }
            if ((size = indexs.size()) > 0) {
                int i;
                LongArray tempPos = null;
                int maxRecordLen = 0;
                Object[] indexArray = new Object[size];
                if (opt != null && opt.indexOf(117) != -1) {
                    indexs.toArray(indexArray);
                } else {
                    Object node;
                    Object index;
                    int j = 0;
                    i = 0;
                    while (j < size) {
                        index = indexs.get(j++);
                        if (!((node = indexs.get(j++)) instanceof Equals)) continue;
                        indexArray[i++] = index;
                        indexArray[i++] = node;
                    }
                    j = 0;
                    while (j < size) {
                        index = indexs.get(j++);
                        if (!((node = indexs.get(j++)) instanceof Like)) continue;
                        indexArray[i++] = index;
                        indexArray[i++] = node;
                    }
                    j = 0;
                    while (j < size) {
                        index = indexs.get(j++);
                        if (!((node = indexs.get(j++)) instanceof DotOperator)) continue;
                        indexArray[i++] = index;
                        indexArray[i++] = node;
                    }
                    j = 0;
                    while (j < size) {
                        index = indexs.get(j++);
                        if ((node = indexs.get(j++)) instanceof Equals || node instanceof Like || node instanceof DotOperator) continue;
                        indexArray[i++] = index;
                        indexArray[i++] = node;
                    }
                }
                i = 0;
                boolean isRow = this instanceof RowPhyTable;
                long[] recCountOfSegment = null;
                if (!isRow) {
                    recCountOfSegment = ((ColPhyTable)this).getSegmentInfo();
                }
                while (i < size) {
                    ITableIndex index = (ITableIndex)indexArray[i++];
                    Node node = (Node)indexArray[i++];
                    LongArray srcPos = index.select(new Expression(node), opt, ctx);
                    int len = index.getMaxRecordLen();
                    if (len > 0) {
                        maxRecordLen = len;
                    }
                    boolean sort = true;
                    if (isRow) {
                        if ((tempPos = PhyTable._$1(tempPos, srcPos.toArray(), index.getPositionCount(), sort)).size() <= 1000) {
                            break;
                        }
                    } else {
                        long[] arr = srcPos.toArray();
                        if (sort) {
                            Arrays.sort(arr);
                        }
                        if (PhyTable.getBlockCount(tempPos = PhyTable._$1(tempPos, arr), recCountOfSegment) <= 10) break;
                    }
                    if (intervalSize <= 0) continue;
                    tempPos = this._$1(tempPos, intervals);
                    intervalSize = 0;
                    if (!(isRow ? tempPos.size() <= 1000 : PhyTable.getBlockCount(tempPos, recCountOfSegment) <= 10)) continue;
                    break;
                }
                ArrayList<ModifyRecord> mrl = PhyTable.getModifyRecord(this, filter, ctx);
                if (tempPos != null && tempPos.size() > 0) {
                    IndexCursor cs = new IndexCursor(this, fields, null, tempPos.toArray(), opt, ctx);
                    if (cs instanceof IndexCursor) {
                        cs.setModifyRecordList(mrl);
                        if (maxRecordLen != 0) {
                            cs.setRowBufferSize(maxRecordLen);
                        }
                    }
                    Select select = new Select(filter, null);
                    cs.addOperation(select, ctx);
                    return cs;
                }
                if (mrl == null) {
                    return null;
                }
                return new IndexCursor(this, fields, null, null, opt, ctx);
            }
        }
        String dir = this.getGroupTable().getFile().getAbsolutePath() + "_";
        if (iname != null) {
            indexFile = new FileObject(dir + this.getTableName() + "_" + iname);
            if (!indexFile.isExists()) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("icursor" + mm.getMessage("dw.indexNotExist") + " : " + iname);
            }
        } else {
            String[] indexFields;
            if (filter.getHome() instanceof DotOperator) {
                Node right = filter.getHome().getRight();
                if (!(right instanceof Contain)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("icursor" + mm.getMessage("function.invalidParam"));
                }
                String str = ((Contain)right).getParamString();
                str = str.replaceAll("\\[", "");
                str = str.replaceAll("\\]", "");
                str = str.replaceAll(" ", "");
                indexFields = str.split(",");
            } else if (filter.getHome() instanceof Like) {
                IParam sub1 = ((Like)filter.getHome()).getParam().getSub(0);
                String f = sub1.getLeafExpression().getIdentifierName();
                indexFields = new String[]{f};
            } else {
                indexFields = PhyTable.getExpFields(filter, this.getColNames());
            }
            String indexName = this.chooseIndex(indexFields);
            if (indexFields == null || indexName == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("icursor" + mm.getMessage("function.invalidParam"));
            }
            indexFile = new FileObject(dir + this.getTableName() + "_" + indexName);
            iname = indexName;
        }
        ITableIndex index = this.getTableMetaDataIndex(indexFile, iname, true);
        ArrayList<ModifyRecord> mrl = PhyTable.getModifyRecord(this, filter, ctx);
        ICursor cursor = index.select(filter, fields, opt, ctx);
        if (cursor == null) {
            if (mrl == null) {
                return null;
            }
            cursor = new IndexCursor(this, fields, null, null, opt, ctx);
        } else if (cursor instanceof IndexCursor) {
            ((IndexCursor)cursor).setModifyRecordList(mrl);
        }
        return cursor;
    }

    private ICursor _$1(String[] fields, Expression filter, FileObject[] files, String opt, Context ctx) {
        String[] filterFields;
        FileObject indexFile = null;
        String[][] fileds = null;
        if (filter.getHome() instanceof And) {
            int size;
            ArrayList<Object> indexs = new ArrayList<Object>();
            ArrayList<Long> intervals = new ArrayList<Long>();
            this._$1(filter.getHome(), indexs, intervals, files, ctx);
            int intervalSize = intervals.size();
            if (intervalSize > 0 && intervalSize / 2 <= 10) {
                return this.cursor(fields, filter, ctx);
            }
            if (intervalSize == this.dataBlockCount * 2) {
                intervals.clear();
                intervalSize = 0;
            }
            if ((size = indexs.size()) > 0) {
                int i;
                LongArray tempPos = null;
                int maxRecordLen = 0;
                Object[] indexArray = new Object[size];
                if (opt != null && opt.indexOf(117) != -1) {
                    indexs.toArray(indexArray);
                } else {
                    Object node;
                    Object index;
                    int j = 0;
                    i = 0;
                    while (j < size) {
                        index = indexs.get(j++);
                        if (!((node = indexs.get(j++)) instanceof Equals)) continue;
                        indexArray[i++] = index;
                        indexArray[i++] = node;
                    }
                    j = 0;
                    while (j < size) {
                        index = indexs.get(j++);
                        if (!((node = indexs.get(j++)) instanceof Like)) continue;
                        indexArray[i++] = index;
                        indexArray[i++] = node;
                    }
                    j = 0;
                    while (j < size) {
                        index = indexs.get(j++);
                        if (!((node = indexs.get(j++)) instanceof DotOperator)) continue;
                        indexArray[i++] = index;
                        indexArray[i++] = node;
                    }
                    j = 0;
                    while (j < size) {
                        index = indexs.get(j++);
                        if ((node = indexs.get(j++)) instanceof Equals || node instanceof Like || node instanceof DotOperator) continue;
                        indexArray[i++] = index;
                        indexArray[i++] = node;
                    }
                }
                i = 0;
                boolean isRow = this instanceof RowPhyTable;
                long[] recCountOfSegment = null;
                if (!isRow) {
                    recCountOfSegment = ((ColPhyTable)this).getSegmentInfo();
                }
                while (i < size) {
                    ITableIndex index = (ITableIndex)indexArray[i++];
                    Node node = (Node)indexArray[i++];
                    LongArray srcPos = index.select(new Expression(node), opt, ctx);
                    int len = index.getMaxRecordLen();
                    if (len > 0) {
                        maxRecordLen = len;
                    }
                    boolean sort = true;
                    if (isRow) {
                        if ((tempPos = PhyTable._$1(tempPos, srcPos.toArray(), index.getPositionCount(), sort)).size() <= 1000) {
                            break;
                        }
                    } else {
                        long[] arr = srcPos.toArray();
                        if (sort) {
                            Arrays.sort(arr);
                        }
                        if (PhyTable.getBlockCount(tempPos = PhyTable._$1(tempPos, arr), recCountOfSegment) <= 10) break;
                    }
                    if (intervalSize <= 0) continue;
                    tempPos = this._$1(tempPos, intervals);
                    intervalSize = 0;
                    if (!(isRow ? tempPos.size() <= 1000 : PhyTable.getBlockCount(tempPos, recCountOfSegment) <= 10)) continue;
                    break;
                }
                ArrayList<ModifyRecord> mrl = PhyTable.getModifyRecord(this, filter, ctx);
                if (tempPos != null && tempPos.size() > 0) {
                    IndexCursor cs = new IndexCursor(this, fields, null, tempPos.toArray(), opt, ctx);
                    if (cs instanceof IndexCursor) {
                        cs.setModifyRecordList(mrl);
                        if (maxRecordLen != 0) {
                            cs.setRowBufferSize(maxRecordLen);
                        }
                    }
                    Select select = new Select(filter, null);
                    cs.addOperation(select, ctx);
                    return cs;
                }
                if (mrl == null) {
                    return null;
                }
                return new IndexCursor(this, fields, null, null, opt, ctx);
            }
        }
        if (files == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("icursor" + mm.getMessage("function.invalidParam"));
        }
        if (filter.getHome() instanceof DotOperator) {
            Node right = filter.getHome().getRight();
            if (!(right instanceof Contain)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("icursor" + mm.getMessage("function.invalidParam"));
            }
            String str = ((Contain)right).getParamString();
            str = str.replaceAll("\\[", "");
            str = str.replaceAll("\\]", "");
            str = str.replaceAll(" ", "");
            filterFields = str.split(",");
        } else if (filter.getHome() instanceof Like) {
            IParam sub1 = ((Like)filter.getHome()).getParam().getSub(0);
            String f = sub1.getLeafExpression().getIdentifierName();
            filterFields = new String[]{f};
        } else {
            filterFields = PhyTable.getExpFields(filter, this.getColNames());
        }
        for (FileObject file : files) {
            fileds = PhyTableIndex.readIndexFields(file);
            if (!PhyTableIndex.isCompatible(filterFields, fileds[0])) continue;
            indexFile = file;
            break;
        }
        if (filterFields == null || indexFile == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("icursor" + mm.getMessage("function.invalidParam"));
        }
        ITableIndex index = this.getTableMetaDataIndex(indexFile, fileds[0], fileds[1], true);
        ArrayList<ModifyRecord> mrl = PhyTable.getModifyRecord(this, filter, ctx);
        ICursor cursor = index.select(filter, fields, opt, ctx);
        if (cursor == null) {
            if (mrl == null) {
                return null;
            }
            cursor = new IndexCursor(this, fields, null, null, opt, ctx);
        } else if (cursor instanceof IndexCursor) {
            ((IndexCursor)cursor).setModifyRecordList(mrl);
        }
        return cursor;
    }

    public ITableIndex getTableMetaDataIndex(FileObject indexFile, String iname, boolean isRead) {
        String name = indexFile.getFileName().toLowerCase();
        name = name + this.getTableName().toLowerCase();
        if (isRead) {
            ITableIndex ti;
            SoftReference<ITableIndex> ref = this._$1.get(name);
            ITableIndex iTableIndex = ti = ref == null ? null : ref.get();
            if (ti == null) {
                if (!this.getGroupTable().getFile().exists()) {
                    return null;
                }
                try {
                    byte[] type = (byte[])indexFile.read(6L, 6L, "b");
                    ti = type[0] == 120 ? new PhyTableIndex(this, indexFile) : (type[0] == 104 ? new TableHashIndex(this, indexFile) : (type[0] == 119 ? new TableFulltextIndex(this, indexFile, null) : new TableKeyValueIndex(this, indexFile)));
                    String[] ifields = null;
                    String[] vfields = null;
                    for (int i = 0; i < this.indexNames.length; ++i) {
                        if (!iname.equals(this.indexNames[i])) continue;
                        ifields = this.indexFields[i];
                        vfields = this.indexValueFields[i];
                        break;
                    }
                    ti.setName(iname);
                    ti.setFields(ifields, vfields);
                }
                catch (IOException e) {
                    throw new RQException(e.getMessage(), e);
                }
                this._$1.put(name, new SoftReference<ITableIndex>(ti));
            }
            return ti;
        }
        this._$1.remove(name);
        return null;
    }

    public ITableIndex getTableMetaDataIndex(FileObject indexFile, String[] ifields, String[] vfields, boolean isRead) {
        File f = indexFile.getLocalFile().file();
        String name = f.getAbsolutePath().toLowerCase();
        if (!this.getGroupTable().getFile().exists()) {
            return null;
        }
        if (isRead) {
            ITableIndex ti;
            SoftReference<ITableIndex> ref = this._$1.get(name);
            ITableIndex iTableIndex = ti = ref == null ? null : ref.get();
            if (ti == null) {
                if (!this.getGroupTable().getFile().exists()) {
                    return null;
                }
                try {
                    byte[] type = (byte[])indexFile.read(6L, 6L, "b");
                    ti = type[0] == 120 ? new PhyTableIndex(this, indexFile) : (type[0] == 104 ? new TableHashIndex(this, indexFile) : (type[0] == 119 ? new TableFulltextIndex(this, indexFile, null) : new TableKeyValueIndex(this, indexFile)));
                    ti.setFields(ifields, vfields);
                }
                catch (IOException e) {
                    throw new RQException(e.getMessage(), e);
                }
                this._$1.put(name, new SoftReference<ITableIndex>(ti));
            }
            return ti;
        }
        this._$1.remove(name);
        return null;
    }

    public boolean isSubTable(String tableName) {
        for (PhyTable table : this.tableList) {
            if (!tableName.equals(table.getTableName())) continue;
            return true;
        }
        return false;
    }

    private void _$1(String oldName, String newName) {
        int j;
        int i;
        if (this.indexNames == null) {
            return;
        }
        int size = this.indexFields.length;
        for (i = 0; i < size; ++i) {
            for (j = 0; j < this.indexFields[i].length; ++j) {
                if (!oldName.equals(this.indexFields[i][j])) continue;
                this.indexFields[i][j] = newName;
            }
        }
        if (this.indexValueFields == null) {
            return;
        }
        size = this.indexValueFields.length;
        for (i = 0; i < size; ++i) {
            if (this.indexValueFields[i] == null) continue;
            for (j = 0; j < this.indexValueFields[i].length; ++j) {
                if (!oldName.equals(this.indexValueFields[i][j])) continue;
                this.indexValueFields[i][j] = newName;
            }
        }
    }

    @Override
    public void rename(String[] srcFields, String[] newFields, Context ctx) throws IOException {
        int j;
        this.getGroupTable().checkWritable();
        ArrayList<String> list = new ArrayList<String>();
        for (String str : newFields) {
            if (str == null) continue;
            if (list.contains(str)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("rename" + mm.getMessage("function.invalidParam") + " : " + str);
            }
            list.add(str);
        }
        block1: for (String name : srcFields) {
            for (String col : this.colNames) {
                if (col.equals(name)) continue block1;
            }
            boolean find = false;
            if (this.indexNames != null) {
                for (j = 0; j < this.indexNames.length; ++j) {
                    if (!name.equals(this.indexNames[j])) continue;
                    find = true;
                    break;
                }
            }
            if (find) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException("rename" + mm.getMessage("function.invalidParam") + " : " + name);
        }
        for (String newField : newFields) {
            for (String name : this.colNames) {
                if (!newField.equals(name)) continue;
                MessageManager mm = EngineMessage.get();
                throw new RQException("rename" + mm.getMessage("function.invalidParam") + " : " + newField);
            }
            if (this.indexNames == null) continue;
            for (String name : this.indexNames) {
                if (!newField.equals(name)) continue;
                MessageManager mm = EngineMessage.get();
                throw new RQException("rename" + mm.getMessage("function.invalidParam") + " : " + newField);
            }
        }
        int size = this.colNames.length;
        int len = srcFields.length;
        ColumnMetaData[] columns = null;
        if (this instanceof ColPhyTable) {
            columns = ((ColPhyTable)this).getColumns();
        }
        block7: for (int i = 0; i < len; ++i) {
            String name = srcFields[i];
            for (j = 0; j < size; ++j) {
                if (!name.equals(this.colNames[j])) continue;
                this.colNames[j] = newFields[i];
                if (columns != null) {
                    columns[j].setColName(newFields[i]);
                }
                this._$1(name, newFields[i]);
                continue block7;
            }
        }
        if (this.segmentCol != null) {
            for (int j2 = 0; j2 < len; ++j2) {
                if (!this.segmentCol.equals(srcFields[j2])) continue;
                this.segmentCol = newFields[j2];
                break;
            }
        }
        if (this.indexNames != null) {
            String dir = this.groupTable.getFile().getAbsolutePath() + "_";
            for (String name : this.indexNames) {
                for (int j3 = 0; j3 < len; ++j3) {
                    if (!name.equals(srcFields[j3])) continue;
                    FileObject tmpFile = new FileObject(dir + this.tableName + "_" + name);
                    tmpFile.move(dir + this.tableName + "_" + newFields[j3], null);
                    this.indexNames[i] = newFields[j3];
                }
            }
        }
        this.groupTable._$3();
        this.init();
        PhyTable tmd = this.getSupplementTable(false);
        if (tmd != null) {
            tmd.rename(srcFields, newFields, ctx);
        }
    }

    @Override
    public String getDistribute() {
        return this.groupTable.getDistribute();
    }

    public abstract int getFirstBlockFromModifyRecord();

    public abstract long resetByBlock(int var1);

    public void addCuboid(String cuboid) throws IOException {
        int size = 0;
        if (this.cuboids != null) {
            size = this.cuboids.length;
        }
        String[] newCuboids = new String[size + 1];
        if (size > 0) {
            System.arraycopy(this.cuboids, 0, newCuboids, 0, size);
        }
        newCuboids[size] = cuboid;
        this.cuboids = newCuboids;
        this.groupTable._$3();
    }

    public boolean deleteCuboid(String cuboid) throws IOException {
        this.getGroupTable().checkWritable();
        String[] oldFileName = this.cuboids;
        String dir = this.groupTable.getFile().getAbsolutePath() + "_";
        if (oldFileName == null) {
            return false;
        }
        if (cuboid == null) {
            for (String name : oldFileName) {
                FileObject tmpFile = new FileObject(dir + this.tableName + "_CUBOID@" + name);
                tmpFile.delete();
            }
            this.cuboids = null;
        } else {
            FileObject tmpFile = new FileObject(dir + this.tableName + "_CUBOID@" + cuboid);
            if (!tmpFile.isExists()) {
                return false;
            }
            int size = oldFileName.length;
            int id = -1;
            for (int i = 0; i < size; ++i) {
                if (!oldFileName[i].equals(cuboid)) continue;
                id = i;
                break;
            }
            if (id < 0) {
                return false;
            }
            if (size == 1) {
                this.cuboids = null;
            } else {
                this.cuboids = new String[size - 1];
                int j = 0;
                for (int i = 0; i < size; ++i) {
                    if (i == id) continue;
                    this.cuboids[j] = oldFileName[i];
                    ++j;
                }
            }
            tmpFile.delete();
        }
        this.groupTable._$3();
        return true;
    }

    public String[] getCuboids() {
        return this.cuboids;
    }

    public void updateCuboids() {
        if (this.cuboids == null) {
            return;
        }
        String dir = this.groupTable.getFile().getAbsolutePath() + "_";
        for (String cuboid : this.cuboids) {
            FileObject fo = new FileObject(dir + this.tableName + "_CUBOID@" + cuboid);
            if (!fo.isExists()) continue;
            File file = fo.getLocalFile().file();
            ComTable table = null;
            try {
                table = new Cuboid(file, this.groupTable.ctx);
                table.checkPassword("cuboid");
                ((Cuboid)table).update(this);
                table.close();
            }
            catch (Exception e) {
                if (table != null) {
                    table.close();
                }
                for (PhyTable tbl : this.tableList) {
                    tbl.close();
                }
                throw new RQException(e.getMessage(), e);
            }
        }
    }

    public void resetCuboid(Context ctx) {
    }

    ICursor _$1(ICursor cs, ICursor cs2) {
        String[] sortFields = ((IDWCursor)cs).getSortFields();
        if (sortFields != null) {
            int len = sortFields.length;
            int[] dims = new int[len];
            DataStruct ds = cs.getDataStruct();
            for (int i = 0; i < len; ++i) {
                dims[i] = ds.getFieldIndex(sortFields[i]);
            }
            return new MergeCursor2(cs, cs2, dims, null, this.groupTable.ctx);
        }
        return new ConjxCursor(new ICursor[]{cs, cs2});
    }

    MultipathCursors _$1(MultipathCursors cs1, MultipathCursors cs2, String[] sortFields) {
        ICursor[] cursors1 = cs1.getCursors();
        ICursor[] cursors2 = cs2.getCursors();
        int count = cursors1.length;
        ICursor[] result = new ICursor[count];
        int len = sortFields.length;
        int[] dims = new int[len];
        DataStruct ds = cursors1[0].getDataStruct();
        for (int i = 0; i < len; ++i) {
            dims[i] = ds.getFieldIndex(sortFields[i]);
        }
        Context ctx = this.groupTable.ctx;
        for (int i = 0; i < count; ++i) {
            result[i] = new MergeCursor2(cursors1[i], cursors2[i], dims, null, ctx);
        }
        return new MultipathCursors(result, ctx);
    }

    MultipathCursors _$1(MultipathCursors cs1, ICursor cs2) {
        ICursor[] cursors1 = cs1.getCursors();
        int count = cursors1.length;
        ICursor[] result = new ICursor[count];
        Context ctx = this.groupTable.ctx;
        if (cs2 instanceof MultipathCursors) {
            MultipathCursors mcs2 = (MultipathCursors)cs2;
            ICursor[] cursors2 = mcs2.getCursors();
            int count2 = cursors2.length;
            for (int i = 0; i < count; ++i) {
                result[i] = i < count2 ? new ConjxCursor(new ICursor[]{cursors1[i], cursors2[i]}) : cursors1[i];
            }
        } else {
            result[0] = new ConjxCursor(new ICursor[]{cursors1[0], cs2});
            System.arraycopy(cursors1, 1, result, 1, count - 1);
        }
        return new MultipathCursors(result, ctx);
    }

    public PhyTable getSupplementTable(boolean isCreate) {
        ComTable sgt = this.groupTable.getSupplement(isCreate);
        if (sgt == null) {
            return null;
        }
        PhyTable tmd = sgt.getBaseTable();
        if (this.parent == null) {
            return tmd;
        }
        return tmd.getAnnexTable(this.tableName);
    }

    public static String[] getSegmentFields(MultipathCursors mcs, boolean hasK) {
        IDWCursor dwCursor;
        ICursor[] cursors;
        for (ICursor cs : cursors = mcs.getParallelCursors()) {
            if (cs instanceof IDWCursor || cs instanceof MergeCursor2) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("dw.needMCursor"));
        }
        if (cursors[0] instanceof IDWCursor) {
            dwCursor = (IDWCursor)cursors[0];
        } else if (cursors[0] instanceof MergeCursor2) {
            dwCursor = (IDWCursor)((MergeCursor2)cursors[0]).getCursor1();
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("dw.needMCursor"));
        }
        if (hasK) {
            String[] dimFields = dwCursor.getSortFields();
            if (dimFields == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cursor" + mm.getMessage("dw.needMCursor"));
            }
            String firstKeyField = dimFields[0];
            if (dwCursor.getDataStruct().getFieldIndex(firstKeyField) == -1) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cursor" + mm.getMessage("dw.needMCursor"));
            }
            return new String[]{firstKeyField};
        }
        String[] dimFields = dwCursor.getSortFields();
        if (dimFields == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("dw.needMCursor"));
        }
        String segCol = dwCursor.getTableMetaData().getSegmentCol();
        if (segCol != null) {
            for (int i = dimFields.length - 1; i >= 0; --i) {
                if (!dimFields[i].equals(segCol)) continue;
                String[] tmp = new String[i + 1];
                System.arraycopy(dimFields, 0, tmp, 0, i + 1);
                return tmp;
            }
        }
        return dimFields;
    }

    @Override
    public ICursor cursor() {
        return this.cursor(null, null, null, null, null, null, null, this.groupTable.ctx);
    }

    @Override
    public ICursor cursor(String[] fields) {
        return this.cursor(null, fields, null, null, null, null, null, this.groupTable.ctx);
    }

    @Override
    public ICursor cursor(String[] fields, Expression filter, Context ctx) {
        return this.cursor(null, fields, filter, null, null, null, null, ctx);
    }

    public void dupIndexAdnCuboid(PhyTable src) {
        String[] cuboids;
        String[] indexNames = src.indexNames;
        if (indexNames != null) {
            this.indexNames = indexNames;
            this.indexFields = src.indexFields;
            this.indexValueFields = src.indexValueFields;
            String dir = src.getGroupTable().getFile().getAbsolutePath() + "_";
            for (String iname : indexNames) {
                if (iname == null) continue;
                FileObject srcIndexFile = new FileObject(dir + src.getTableName() + "_" + iname);
                ITableIndex srcIndex = src.getTableMetaDataIndex(srcIndexFile, iname, true);
                srcIndex.dup(this);
            }
        }
        if ((cuboids = src.cuboids) != null) {
            this.cuboids = cuboids;
            String srcDir = src.groupTable.getFile().getAbsolutePath() + "_";
            String dir = this.groupTable.getFile().getAbsolutePath() + "_";
            for (String cuboid : cuboids) {
                FileObject srcFo = new FileObject(srcDir + src.tableName + "_CUBOID@" + cuboid);
                File srcFile = srcFo.getLocalFile().file();
                ComTable srcCuboid = null;
                FileObject fo = new FileObject(dir + this.tableName + "_CUBOID@" + cuboid);
                File file = fo.getLocalFile().file();
                ComTable table = null;
                try {
                    srcCuboid = new Cuboid(srcFile, this.groupTable.ctx);
                    table = ((Cuboid)srcCuboid).dup(file);
                    table.close();
                    srcCuboid.close();
                }
                catch (Exception e) {
                    if (table != null) {
                        table.close();
                    }
                    if (srcCuboid != null) {
                        srcCuboid.close();
                    }
                    for (PhyTable tbl : this.tableList) {
                        tbl.close();
                    }
                    throw new RQException(e.getMessage(), e);
                }
            }
        }
    }

    public abstract Object[] getMaxMinValue(String var1) throws IOException;

    @Override
    public int getDeleteFieldIndex(Expression[] exps, String[] fields) {
        block7: {
            if (!this.getGroupTable().hasDeleteKey()) break block7;
            String[] colNames = this.parent == null ? this.colNames : this.allColNames;
            String[] keyNames = this.getAllKeyColNames();
            if (keyNames == null) {
                return -1;
            }
            int keyCount = keyNames.length;
            int colCount = colNames.length;
            if (keyCount >= colCount) {
                return -1;
            }
            String deleteKey = colNames[keyCount];
            if (exps == null) {
                if (fields == null) {
                    return keyCount;
                }
                int len = fields.length;
                for (int i = 0; i < len; ++i) {
                    if (fields[i] == null || !fields[i].equals(deleteKey)) continue;
                    return i;
                }
            } else {
                int len = exps.length;
                for (int i = 0; i < len; ++i) {
                    if (exps[i] == null || !(exps[i].getHome() instanceof UnknownSymbol) || !exps[i].getIdentifierName().equals(deleteKey)) continue;
                    return i;
                }
            }
        }
        return -1;
    }
}

