/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BFileWriter;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.BFileCursor;
import com.scudata.dm.cursor.ConjxCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MergeCursor;
import com.scudata.dm.cursor.MergeCursor2;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dm.cursor.UpdateMergeCursor;
import com.scudata.dm.op.Operation;
import com.scudata.dw.ColPhyTable;
import com.scudata.dw.ComTable;
import com.scudata.dw.Cuboid;
import com.scudata.dw.Cursor;
import com.scudata.dw.IPhyTable;
import com.scudata.dw.IndexCursor;
import com.scudata.dw.IndexFCursor;
import com.scudata.dw.PhyTable;
import com.scudata.expression.Expression;
import com.scudata.resources.EngineMessage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class PhyTableGroup
implements IPhyTable {
    private IPhyTable[] _$7;
    private String _$6;
    private int[] _$5;
    private String _$4;
    private Context _$3;
    private Expression _$2;
    private Sequence _$1;

    public PhyTableGroup(String fileName, IPhyTable[] tables, int[] partitions, String opt, Context ctx) {
        this._$6 = fileName;
        this._$7 = tables;
        this._$5 = partitions;
        this._$4 = opt;
        this._$3 = ctx;
        this._$2 = new Expression(ctx, tables[0].getDistribute());
    }

    public PhyTableGroup(String fileName, IPhyTable[] tables, int[] partitions, String opt, Expression distribute, Context ctx) {
        this._$6 = fileName;
        this._$7 = tables;
        this._$5 = partitions;
        this._$4 = opt;
        this._$3 = ctx;
        this._$2 = distribute;
    }

    public void close() {
        for (IPhyTable table : this._$7) {
            table.close();
        }
    }

    public boolean isColumnStored() {
        return this._$7[0] instanceof ColPhyTable;
    }

    public IPhyTable createAnnexTable(String[] colNames, int[] serialBytesLen, String tableName) throws IOException {
        int count = this._$7.length;
        IPhyTable[] annexTables = new IPhyTable[count];
        for (int i = 0; i < count; ++i) {
            annexTables[i] = this._$7[i].createAnnexTable(colNames, serialBytesLen, tableName);
        }
        return new PhyTableGroup(this._$6, annexTables, this._$5, this._$4, this._$2, this._$3);
    }

    public IPhyTable getAnnexTable(String tableName) {
        int count = this._$7.length;
        IPhyTable[] annexTables = new IPhyTable[count];
        for (int i = 0; i < count; ++i) {
            annexTables[i] = this._$7[i].getAnnexTable(tableName);
        }
        return new PhyTableGroup(this._$6, annexTables, this._$5, this._$4, this._$2, this._$3);
    }

    public void append(ICursor cursor) throws IOException {
        this.append(cursor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$1(ICursor cursor, String opt) throws IOException {
        Expression distribute = this._$2;
        if (distribute == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.lessDistribute"));
        }
        Sequence data = cursor.fetch(ICursor.INITSIZE);
        if (data == null || data.length() == 0) {
            return;
        }
        Context ctx = this._$3;
        DataStruct ds = data.dataStruct();
        if (ds == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        ArrayList<BFileWriter> tmpFiles = new ArrayList<BFileWriter>();
        tmpFiles.add(null);
        int partCount = 0;
        try {
            while (data != null && data.length() > 0) {
                Sequence group = data.group(distribute, null, ctx);
                int gcount = group.length();
                for (int g = 1; g <= gcount; ++g) {
                    BFileWriter writer;
                    Sequence curGroup = (Sequence)group.getMem(g);
                    Object obj = curGroup.calc(1, distribute, ctx);
                    if (!(obj instanceof Number)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("dw.distributeError"));
                    }
                    int p = ((Number)obj).intValue();
                    if (p < 1) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("dw.distributeError"));
                    }
                    if (p > partCount) {
                        while (partCount < p) {
                            tmpFiles.add(null);
                            ++partCount;
                        }
                    }
                    if ((writer = (BFileWriter)tmpFiles.get(p)) == null) {
                        writer = new BFileWriter(FileObject.createTempFileObject(), null);
                        writer.prepareWrite(ds, false);
                        tmpFiles.set(p, writer);
                    }
                    writer.write(curGroup);
                }
                data = cursor.fetch(ICursor.INITSIZE);
            }
            for (int p = 1; p <= partCount; ++p) {
                BFileWriter writer = (BFileWriter)tmpFiles.get(p);
                if (writer == null) continue;
                writer.close();
                BFileCursor bcs = new BFileCursor(writer.getFile(), null, null, ctx);
                this._$1(p).append(bcs, opt);
            }
        }
        finally {
            for (int i = 1; i <= partCount; ++i) {
                BFileWriter writer = (BFileWriter)tmpFiles.get(i);
                if (writer == null) continue;
                writer.getFile().delete();
            }
        }
    }

    public void append(ICursor cursor, String opt) throws IOException {
        Expression distribute;
        if (opt != null) {
            if (opt.indexOf(121) != -1) {
                this._$1 = cursor.fetch();
                return;
            }
            if (opt.indexOf(120) != -1) {
                this._$1(cursor, opt);
                return;
            }
        }
        if ((distribute = this._$2) == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.lessDistribute"));
        }
        if (cursor instanceof MultipathCursors) {
            ICursor[] cursors;
            for (ICursor cs : cursors = ((MultipathCursors)cursor).getCursors()) {
                Sequence data = cs.peek(ICursor.FETCHCOUNT);
                if (data == null || data.length() == 0) continue;
                Object obj = data.calc(1, distribute, this._$3);
                if (!(obj instanceof Number)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("dw.distributeError"));
                }
                int p = ((Number)obj).intValue();
                if (p < 1) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("dw.distributeError"));
                }
                this._$1(p).append(cs, opt);
            }
        } else {
            Sequence data = cursor.peek(ICursor.FETCHCOUNT);
            if (data == null || data.length() == 0) {
                return;
            }
            Object obj = data.calc(1, distribute, this._$3);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("dw.distributeError"));
            }
            int p = ((Number)obj).intValue();
            if (p < 1) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("dw.distributeError"));
            }
            this._$1(p).append(cursor, opt);
        }
    }

    private IPhyTable _$1(int p) {
        int pcount = this._$5.length;
        for (int i = 0; i < pcount; ++i) {
            if (this._$5[i] != p) continue;
            return this._$7[i];
        }
        File file = Env.getPartitionFile(p, this._$6);
        PhyTable tmd = (PhyTable)this._$7[0];
        ComTable gt = tmd.getGroupTable().dupStruct(file);
        PhyTable result = gt.getBaseTable();
        String tableName = tmd.getTableName();
        if (tableName != null && tableName.length() != 0) {
            result = result.getAnnexTable(tableName);
        }
        IPhyTable[] tmpTables = new IPhyTable[pcount + 1];
        int[] tmpPartitions = new int[pcount + 1];
        System.arraycopy(this._$7, 0, tmpTables, 0, pcount);
        System.arraycopy(this._$5, 0, tmpPartitions, 0, pcount);
        tmpTables[pcount] = result;
        tmpPartitions[pcount] = p;
        this._$7 = tmpTables;
        this._$5 = tmpPartitions;
        return result;
    }

    public Sequence update(Sequence data, String opt) {
        throw new RQException("'update' function is unimplemented in file group!");
    }

    public Sequence delete(Sequence data, String opt) {
        throw new RQException("'delete' function is unimplemented in file group!");
    }

    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, MultipathCursors mcs, String opt, Context ctx) {
        int p;
        int i;
        ICursor[] cursors = mcs.getCursors();
        int pathCount = cursors.length;
        int tableCount = this._$7.length;
        ArrayList[] lists = new ArrayList[pathCount];
        if (opt != null && opt.indexOf(119) != -1) {
            int p2;
            MultipathCursors mcs2 = (MultipathCursors)this._$7[0].cursor(exps, fields, filter, fkNames, codes, opts, mcs, opt, ctx);
            int deleteField = this.getDeleteFieldIndex(exps, fields);
            cursors = mcs2.getCursors();
            DataStruct ds = cursors[0].getDataStruct();
            if (ds == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("ds.lessKey"));
            }
            int[] pkIndex = ds.getPKIndex();
            if (pkIndex == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("ds.lessKey"));
            }
            for (int p3 = 0; p3 < cursors.length; ++p3) {
                lists[p3] = new ArrayList(tableCount);
                lists[p3].add(cursors[p3]);
            }
            for (int i2 = 1; i2 < tableCount; ++i2) {
                mcs2 = (MultipathCursors)this._$7[i2].cursor(exps, fields, filter, fkNames, codes, opts, mcs, opt, ctx);
                cursors = mcs2.getCursors();
                for (p2 = 0; p2 < cursors.length; ++p2) {
                    lists[p2].add(cursors[p2]);
                }
            }
            if (this._$1 != null) {
                String[] sortedFields = this.getAllSortedColNames();
                mcs2 = this._$1.cursor(mcs, sortedFields, exps, fields, filter, fkNames, codes, opts, opt, ctx);
                cursors = mcs2.getCursors();
                for (p2 = 0; p2 < cursors.length; ++p2) {
                    lists[p2].add(cursors[p2]);
                }
            }
            ICursor[] resultCursors = new ICursor[pathCount];
            for (int i3 = 0; i3 < pathCount; ++i3) {
                int size = lists[i3].size();
                if (size > 1) {
                    cursors = new ICursor[size];
                    lists[i3].toArray(cursors);
                    resultCursors[i3] = new UpdateMergeCursor(cursors, pkIndex, deleteField, ctx);
                    continue;
                }
                if (size != 1) continue;
                resultCursors[i3] = (ICursor)lists[i3].get(0);
            }
            return new MultipathCursors(resultCursors, ctx);
        }
        MultipathCursors mcs2 = (MultipathCursors)this._$7[0].cursor(exps, fields, filter, fkNames, codes, opts, mcs, opt, ctx);
        cursors = mcs2.getCursors();
        String[] sortFields = cursors[0].getSortFields();
        DataStruct ds = cursors[0].getDataStruct();
        if (ds == null || sortFields == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("grouptable.dataNeedSorted"));
        }
        int fcount = sortFields.length;
        int[] findex = new int[fcount];
        for (i = 0; i < fcount; ++i) {
            findex[i] = ds.getFieldIndex(sortFields[i]);
        }
        for (int p4 = 0; p4 < cursors.length; ++p4) {
            lists[p4] = new ArrayList(tableCount);
            lists[p4].add(cursors[p4]);
        }
        for (i = 1; i < tableCount; ++i) {
            mcs2 = (MultipathCursors)this._$7[i].cursor(exps, fields, filter, fkNames, codes, opts, mcs, opt, ctx);
            cursors = mcs2.getCursors();
            for (p = 0; p < cursors.length; ++p) {
                lists[p].add(cursors[p]);
            }
        }
        if (this._$1 != null) {
            String[] sortedFields = this.getAllSortedColNames();
            mcs2 = this._$1.cursor(mcs, sortedFields, exps, fields, filter, fkNames, codes, opts, opt, ctx);
            cursors = mcs2.getCursors();
            for (p = 0; p < cursors.length; ++p) {
                lists[p].add(cursors[p]);
            }
        }
        ICursor[] resultCursors = new ICursor[pathCount];
        for (int i4 = 0; i4 < pathCount; ++i4) {
            int size = lists[i4].size();
            if (size > 1) {
                cursors = new ICursor[size];
                lists[i4].toArray(cursors);
                resultCursors[i4] = new MergeCursor(cursors, findex, opt, ctx);
                continue;
            }
            if (size != 1) continue;
            resultCursors[i4] = (ICursor)lists[i4].get(0);
        }
        return new MultipathCursors(resultCursors, ctx);
    }

    public void rename(String[] srcFields, String[] newFields, Context ctx) throws IOException {
        throw new RQException("'rename' function is unimplemented in file group!");
    }

    public ICursor cursor() {
        return this.cursor(null, null, null, null, null, null, null, this._$3);
    }

    public ICursor cursor(String[] fields) {
        return this.cursor(null, fields, null, null, null, null, null, this._$3);
    }

    public ICursor cursor(String[] fields, Expression filter, Context ctx) {
        return this.cursor(null, fields, filter, null, null, null, null, ctx);
    }

    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, String opt, Context ctx) {
        ICursor[] cursors;
        int count = this._$7.length;
        if (this._$1 == null) {
            cursors = new ICursor[count];
        } else {
            cursors = new ICursor[count + 1];
            exps = Operation.dupExpressions(exps, ctx);
            filter = Operation.dupExpression(filter, ctx);
            cursors[count] = this._$1.cursor(exps, fields, filter, fkNames, codes, opts, ctx);
        }
        for (int i = 0; i < count; ++i) {
            exps = Operation.dupExpressions(exps, ctx);
            filter = Operation.dupExpression(filter, ctx);
            cursors[i] = this._$7[i].cursor(exps, fields, filter, fkNames, codes, opts, opt, ctx);
        }
        boolean isUpdate = false;
        boolean isMerge = true;
        if (opt != null) {
            if (opt.indexOf(119) != -1) {
                isUpdate = true;
            } else if (opt.indexOf(111) != -1) {
                isMerge = false;
            }
        }
        if (isUpdate) {
            DataStruct ds = cursors[0].getDataStruct();
            if (ds == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("ds.lessKey"));
            }
            int[] pkIndex = ds.getPKIndex();
            if (pkIndex == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("ds.lessKey"));
            }
            int deleteField = this.getDeleteFieldIndex(exps, fields);
            return new UpdateMergeCursor(cursors, pkIndex, deleteField, ctx);
        }
        if (isMerge) {
            String[] sortFields = cursors[0].getSortFields();
            DataStruct ds = cursors[0].getDataStruct();
            if (ds == null || sortFields == null) {
                return new ConjxCursor(cursors);
            }
            int fcount = sortFields.length;
            int[] findex = new int[fcount];
            for (int i = 0; i < fcount; ++i) {
                findex[i] = ds.getFieldIndex(sortFields[i]);
            }
            return new MergeCursor(cursors, findex, opt, ctx);
        }
        return new ConjxCursor(cursors);
    }

    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, int pathCount, String opt, Context ctx) {
        ICursor[] cursors;
        if (pathCount < 2) {
            return this.cursor(exps, fields, filter, fkNames, codes, opts, opt, ctx);
        }
        int tableCount = this._$7.length;
        ArrayList[] lists = new ArrayList[pathCount];
        ICursor cs = this._$7[0].cursor(exps, fields, filter, fkNames, codes, opts, pathCount, opt, ctx);
        boolean isUpdate = false;
        boolean isMerge = true;
        if (opt != null) {
            if (opt.indexOf(119) != -1) {
                isUpdate = true;
            } else if (opt.indexOf(111) != -1) {
                isMerge = false;
            }
        }
        if (isUpdate) {
            ICursor[] cursors2;
            int deleteField = this.getDeleteFieldIndex(exps, fields);
            if (cs instanceof MultipathCursors) {
                int p;
                MultipathCursors mcs2;
                MultipathCursors mcs = (MultipathCursors)cs;
                ICursor[] cursors3 = mcs.getCursors();
                pathCount = cursors3.length;
                DataStruct ds = cursors3[0].getDataStruct();
                if (ds == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("ds.lessKey"));
                }
                int[] pkIndex = ds.getPKIndex();
                if (pkIndex == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("ds.lessKey"));
                }
                for (int p2 = 0; p2 < pathCount; ++p2) {
                    lists[p2] = new ArrayList(tableCount);
                    lists[p2].add(cursors3[p2]);
                }
                for (int i = 1; i < tableCount; ++i) {
                    mcs2 = (MultipathCursors)this._$7[i].cursor(exps, fields, filter, fkNames, codes, opts, mcs, opt, ctx);
                    cursors3 = mcs2.getCursors();
                    for (p = 0; p < cursors3.length; ++p) {
                        lists[p].add(cursors3[p]);
                    }
                }
                if (this._$1 != null) {
                    String[] sortedFields = this.getAllSortedColNames();
                    mcs2 = this._$1.cursor(mcs, sortedFields, exps, fields, filter, fkNames, codes, opts, opt, ctx);
                    cursors3 = mcs2.getCursors();
                    for (p = 0; p < cursors3.length; ++p) {
                        lists[p].add(cursors3[p]);
                    }
                }
                ICursor[] resultCursors = new ICursor[pathCount];
                for (int i = 0; i < pathCount; ++i) {
                    int size = lists[i].size();
                    if (size > 1) {
                        cursors3 = new ICursor[size];
                        lists[i].toArray(cursors3);
                        resultCursors[i] = new UpdateMergeCursor(cursors3, pkIndex, deleteField, ctx);
                        continue;
                    }
                    if (size != 1) continue;
                    resultCursors[i] = (ICursor)lists[i].get(0);
                }
                return new MultipathCursors(resultCursors, ctx);
            }
            DataStruct ds = cs.getDataStruct();
            if (ds == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("ds.lessKey"));
            }
            int[] pkIndex = ds.getPKIndex();
            if (pkIndex == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("ds.lessKey"));
            }
            if (this._$1 == null) {
                cursors2 = new ICursor[tableCount];
            } else {
                cursors2 = new ICursor[tableCount + 1];
                exps = Operation.dupExpressions(exps, ctx);
                filter = Operation.dupExpression(filter, ctx);
                cursors2[tableCount] = this._$1.cursor(exps, fields, filter, fkNames, codes, opts, ctx);
            }
            cursors2[0] = cs;
            for (int i = 1; i < tableCount; ++i) {
                exps = Operation.dupExpressions(exps, ctx);
                filter = Operation.dupExpression(filter, ctx);
                cursors2[i] = this._$7[i].cursor(exps, fields, filter, fkNames, codes, opts, opt, ctx);
            }
            return new UpdateMergeCursor(cursors2, pkIndex, deleteField, ctx);
        }
        if (isMerge) {
            if (cs instanceof MultipathCursors) {
                MultipathCursors mcs = (MultipathCursors)cs;
                cursors = mcs.getCursors();
                pathCount = cursors.length;
                String[] sortFields = cursors[0].getSortFields();
                DataStruct ds = cursors[0].getDataStruct();
                if (ds != null && sortFields != null) {
                    int p;
                    MultipathCursors mcs2;
                    int i;
                    int fcount = sortFields.length;
                    int[] findex = new int[fcount];
                    for (i = 0; i < fcount; ++i) {
                        findex[i] = ds.getFieldIndex(sortFields[i]);
                    }
                    for (int p3 = 0; p3 < pathCount; ++p3) {
                        lists[p3] = new ArrayList(tableCount);
                        lists[p3].add(cursors[p3]);
                    }
                    for (i = 1; i < tableCount; ++i) {
                        mcs2 = (MultipathCursors)this._$7[i].cursor(exps, fields, filter, fkNames, codes, opts, mcs, opt, ctx);
                        cursors = mcs2.getCursors();
                        for (p = 0; p < cursors.length; ++p) {
                            lists[p].add(cursors[p]);
                        }
                    }
                    if (this._$1 != null) {
                        String[] sortedFields = this.getAllSortedColNames();
                        mcs2 = this._$1.cursor(mcs, sortedFields, exps, fields, filter, fkNames, codes, opts, opt, ctx);
                        cursors = mcs2.getCursors();
                        for (p = 0; p < cursors.length; ++p) {
                            lists[p].add(cursors[p]);
                        }
                    }
                    ICursor[] resultCursors = new ICursor[pathCount];
                    for (int i2 = 0; i2 < pathCount; ++i2) {
                        int size = lists[i2].size();
                        if (size > 1) {
                            cursors = new ICursor[size];
                            lists[i2].toArray(cursors);
                            resultCursors[i2] = new MergeCursor(cursors, findex, opt, ctx);
                            continue;
                        }
                        if (size != 1) continue;
                        resultCursors[i2] = (ICursor)lists[i2].get(0);
                    }
                    return new MultipathCursors(resultCursors, ctx);
                }
            } else {
                ICursor[] cursors4;
                if (this._$1 == null) {
                    cursors4 = new ICursor[tableCount];
                } else {
                    cursors4 = new ICursor[tableCount + 1];
                    exps = Operation.dupExpressions(exps, ctx);
                    filter = Operation.dupExpression(filter, ctx);
                    cursors4[tableCount] = this._$1.cursor(exps, fields, filter, fkNames, codes, opts, ctx);
                }
                cursors4[0] = cs;
                for (int i = 1; i < tableCount; ++i) {
                    exps = Operation.dupExpressions(exps, ctx);
                    filter = Operation.dupExpression(filter, ctx);
                    cursors4[i] = this._$7[i].cursor(exps, fields, filter, fkNames, codes, opts, opt, ctx);
                }
                String[] sortFields = cursors4[0].getSortFields();
                DataStruct ds = cursors4[0].getDataStruct();
                if (ds == null || sortFields == null) {
                    return new ConjxCursor(cursors4);
                }
                int fcount = sortFields.length;
                int[] findex = new int[fcount];
                for (int i = 0; i < fcount; ++i) {
                    findex[i] = ds.getFieldIndex(sortFields[i]);
                }
                return new MergeCursor(cursors4, findex, opt, ctx);
            }
        }
        for (int i = 0; i < pathCount; ++i) {
            lists[i] = new ArrayList(tableCount);
        }
        if (cs instanceof MultipathCursors) {
            MultipathCursors mcs = (MultipathCursors)cs;
            cursors = mcs.getCursors();
            for (int c = 0; c < cursors.length; ++c) {
                lists[c].add(cursors[c]);
            }
        } else {
            lists[0].add(cs);
        }
        for (int i = 1; i < tableCount; ++i) {
            cs = this._$7[i].cursor(exps, fields, filter, fkNames, codes, opts, pathCount, opt, ctx);
            if (cs instanceof MultipathCursors) {
                MultipathCursors mcs = (MultipathCursors)cs;
                ICursor[] cursors5 = mcs.getCursors();
                for (int c = 0; c < cursors5.length; ++c) {
                    lists[c].add(cursors5[c]);
                }
                continue;
            }
            lists[0].add(cs);
        }
        if (this._$1 != null) {
            int len = this._$1.length();
            int blockSize = len / pathCount;
            int start = 1;
            for (int i = 1; i <= pathCount; ++i) {
                int end = i == pathCount ? len + 1 : blockSize * i + 1;
                exps = Operation.dupExpressions(exps, ctx);
                filter = Operation.dupExpression(filter, ctx);
                ICursor cursor = this._$1.cursor(start, end, exps, fields, filter, fkNames, codes, opts, ctx);
                lists[i - 1].add(cursor);
                start = end;
            }
        }
        ArrayList<ConjxCursor> list = new ArrayList<ConjxCursor>(pathCount);
        for (int i = 0; i < pathCount; ++i) {
            int size = lists[i].size();
            if (size > 1) {
                ICursor[] cursors6 = new ICursor[size];
                lists[i].toArray(cursors6);
                list.add(new ConjxCursor(cursors6));
                continue;
            }
            if (size != 1) continue;
            list.add((ConjxCursor)lists[i].get(0));
        }
        int size = list.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return (ICursor)list.get(0);
        }
        ICursor[] cursors7 = new ICursor[size];
        list.toArray(cursors7);
        return new MultipathCursors(cursors7, ctx);
    }

    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, int segSeq, int segCount, String opt, Context ctx) {
        if (segCount < 2) {
            return this.cursor(exps, fields, filter, fkNames, codes, opts, opt, ctx);
        }
        int count = this._$7.length;
        ArrayList<ICursor> list = new ArrayList<ICursor>(count);
        for (int i = 0; i < count; ++i) {
            ICursor cursor = this._$7[i].cursor(exps = Operation.dupExpressions(exps, ctx), fields, filter = Operation.dupExpression(filter, ctx), fkNames, codes, opts, segSeq, segCount, opt, ctx);
            if (cursor == null) continue;
            list.add(cursor);
        }
        if (this._$1 != null) {
            int end;
            int start;
            int len = this._$1.length();
            int blockSize = len / segCount;
            if (segSeq == segCount) {
                start = blockSize * (segSeq - 1) + 1;
                end = len + 1;
            } else {
                start = blockSize * (segSeq - 1) + 1;
                end = blockSize * segSeq + 1;
            }
            exps = Operation.dupExpressions(exps, ctx);
            filter = Operation.dupExpression(filter, ctx);
            ICursor cursor = this._$1.cursor(start, end, exps, fields, filter, fkNames, codes, opts, ctx);
            list.add(cursor);
        }
        ICursor[] cursors = new ICursor[list.size()];
        list.toArray(cursors);
        if (opt == null || opt.indexOf(111) == -1) {
            String[] sortFields = cursors[0].getSortFields();
            DataStruct ds = cursors[0].getDataStruct();
            if (ds == null || sortFields == null) {
                return new ConjxCursor(cursors);
            }
            int fcount = sortFields.length;
            int[] findex = new int[fcount];
            for (int i = 0; i < fcount; ++i) {
                findex[i] = ds.getFieldIndex(sortFields[i]);
            }
            return new MergeCursor(cursors, findex, opt, ctx);
        }
        return new ConjxCursor(cursors);
    }

    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, int pathSeq, int pathCount, int pathCount2, String opt, Context ctx) {
        throw new RQException("'mcursor' function is unimplemented in file group!");
    }

    public ICursor cursor(Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, ICursor cs, int seg, Object[][] endValues, Context ctx) {
        throw new RQException("'mcursor' function is unimplemented in file group!");
    }

    public Table finds(Sequence values) throws IOException {
        Sequence result = null;
        for (IPhyTable table : this._$7) {
            Table cur = table.finds(values);
            if (cur == null) continue;
            if (result == null) {
                result = cur;
                continue;
            }
            ((Table)result).append(cur, null);
        }
        if (this._$4 == null || this._$4.indexOf(111) == -1) {
            String[] sortFields = this.getAllSortedColNames();
            result.sortFields(sortFields);
        }
        return result;
    }

    public Table finds(Sequence values, String[] selFields) throws IOException {
        Table result = null;
        for (IPhyTable table : this._$7) {
            Table cur = table.finds(values, selFields);
            if (cur == null) continue;
            if (result == null) {
                result = cur;
                continue;
            }
            result.append(cur, null);
        }
        return result;
    }

    public ICursor icursor(String[] fields, Expression filter, Object iname, String opt, Context ctx) {
        boolean sort = true;
        int[] sortFields = null;
        int count = this._$7.length;
        ArrayList<ICursor> list = new ArrayList<ICursor>(count);
        for (int i = 0; i < count; ++i) {
            ICursor cursor = this._$7[i].icursor(fields, filter, iname, opt, ctx);
            if (cursor == null) continue;
            list.add(cursor);
            if (!sort) continue;
            if (cursor instanceof IndexCursor) {
                sortFields = ((IndexCursor)cursor).getSortFieldsIndex();
                if (sortFields != null) continue;
                sort = false;
                continue;
            }
            if (cursor instanceof IndexFCursor) {
                sortFields = ((IndexFCursor)cursor).getSortFieldsIndex();
                if (sortFields != null) continue;
                sort = false;
                continue;
            }
            if (cursor instanceof Cursor) {
                sort = false;
                continue;
            }
            if (cursor instanceof ConjxCursor) {
                sort = false;
                continue;
            }
            if (!(cursor instanceof MergeCursor2) || (sortFields = ((MergeCursor2)cursor).getFields()) != null) continue;
            sort = false;
        }
        ICursor[] cursors = new ICursor[list.size()];
        list.toArray(cursors);
        if (sort) {
            return new MergeCursor(cursors, sortFields, null, ctx);
        }
        return new ConjxCursor(cursors);
    }

    public String[] getAllKeyColNames() {
        return this._$7[0].getAllKeyColNames();
    }

    public String[] getAllSortedColNames() {
        return this._$7[0].getAllSortedColNames();
    }

    public String[] getAllColNames() {
        return this._$7[0].getAllColNames();
    }

    public boolean deleteIndex(String indexName) throws IOException {
        boolean result = true;
        for (IPhyTable table : this._$7) {
            if (table.deleteIndex(indexName)) continue;
            result = false;
        }
        return result;
    }

    public void createIndex(String I, String[] fields, Object obj, String opt, Expression w, Context ctx) {
        for (IPhyTable table : this._$7) {
            table.createIndex(I, fields, obj, opt, w, ctx);
        }
    }

    public String getDistribute() {
        return this._$7[0].getDistribute();
    }

    public void addColumn(String colName, Expression exp, Context ctx) {
        for (IPhyTable table : this._$7) {
            table.addColumn(colName, exp, ctx);
        }
    }

    public void deleteColumn(String colName) {
        for (IPhyTable table : this._$7) {
            table.deleteColumn(colName);
        }
    }

    public ICursor merge(Context ctx) {
        String[] sortFields = this._$7[0].getAllSortedColNames();
        if (sortFields == null || sortFields.length == 0) {
            return this.cursor();
        }
        int count = this._$7.length;
        ICursor[] cursors = new ICursor[count];
        for (int i = 0; i < count; ++i) {
            cursors[i] = this._$7[i].cursor();
        }
        int fcount = sortFields.length;
        int[] fields = new int[fcount];
        for (int i = 0; i < fcount; ++i) {
            fields[i] = i;
        }
        return new MergeCursor(cursors, fields, null, ctx);
    }

    public IPhyTable[] getTables() {
        return this._$7;
    }

    public Sequence cgroups(String[] expNames, String[] names, String[] newExpNames, String[] newNames, Expression w, boolean hasM, int n, String option, FileObject[] files, Context ctx) {
        int count = this._$7.length;
        Sequence result = Cuboid.cgroups(expNames, names, newExpNames, newNames, (PhyTable)this._$7[0], w, hasM, n, option, files, ctx);
        for (int i = 1; i < count; ++i) {
            Sequence seq = Cuboid.cgroups(expNames, names, newExpNames, newNames, (PhyTable)this._$7[i], w, hasM, n, option, files, ctx);
            result.addAll(seq);
        }
        count = names.length;
        Expression[] exps = new Expression[count];
        for (int i = 0; i < count; ++i) {
            exps[i] = new Expression(names[i]);
        }
        count = newNames.length;
        Expression[] newExps = new Expression[count];
        int len = count;
        for (int i = 0; i < len; ++i) {
            String str = newExpNames[i];
            if (str.indexOf("count(") != -1) {
                str = str.replaceFirst("count", "sum");
            }
            String sub = str.substring(str.indexOf(40) + 1, str.indexOf(41));
            str = str.replaceAll(sub, "'" + newNames[i] + "'");
            newExps[i] = new Expression(str);
        }
        return result.groups(exps, names, newExps, newNames, option, ctx);
    }

    public int getDeleteFieldIndex(Expression[] exps, String[] fields) {
        return this._$7[0].getDeleteFieldIndex(exps, fields);
    }

    public Sequence getMemoryTable() {
        return this._$1;
    }

    public void setMemoryTable(Sequence memoryTable) {
        this._$1 = memoryTable;
    }

    public void append(PhyTable table) throws IOException {
        throw new RuntimeException();
    }
}

