/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.array.BoolArray;
import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.ObjectArray;
import com.scudata.array.SerialBytesArray;
import com.scudata.array.StringArray;
import com.scudata.common.RQException;
import com.scudata.dm.Sequence;
import com.scudata.dm.SerialBytes;
import com.scudata.dw.BufferReader;
import com.scudata.dw.StructManager;
import java.io.IOException;
import java.util.Date;

public class PureBufferReader
extends BufferReader {
    private int _$13;
    private int _$12;
    private Sequence _$11;
    private int[] _$10;
    private Object _$9;
    private int _$8;
    private boolean[] _$7;
    private int _$6 = 0;

    public PureBufferReader(StructManager structManager, byte[] buffer, int recordCount, Sequence columnDict) {
        super(structManager, buffer);
        this._$1(columnDict, recordCount);
    }

    public PureBufferReader(StructManager structManager, byte[] buffer, int index, int count, int recordCount, Sequence columnDict) {
        super(structManager, buffer, index, count);
        this._$1(columnDict, recordCount);
    }

    public static boolean canUseBufferReader(byte[] buffer, int index) {
        byte blockType = buffer[index];
        switch (blockType) {
            case 64: 
            case 80: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    private void _$1(Sequence columnDict, int recordCount) {
        int dataSize = 0;
        try {
            this._$13 = this.readByte();
            switch (this._$13) {
                case 0: {
                    this._$13 = 96;
                    this._$9 = null;
                    return;
                }
                case 17: 
                case 33: {
                    dataSize = 1;
                    break;
                }
                case 18: 
                case 34: {
                    ++this.index;
                    dataSize = 2;
                    break;
                }
                case 20: 
                case 36: {
                    this.index += 3;
                    dataSize = 4;
                    break;
                }
                case 40: 
                case 56: {
                    this.index += 7;
                    dataSize = 8;
                    break;
                }
                case 81: {
                    int idx = this.index;
                    byte[] buf = this.buffer;
                    int[] len = new int[recordCount + 1];
                    for (int i = 1; i <= recordCount; ++i) {
                        len[i] = buf[idx++];
                    }
                    this.index = idx;
                    this._$10 = len;
                    return;
                }
                case 70: {
                    dataSize = 16;
                    break;
                }
                case 127: {
                    this._$11 = this.read() == 0 ? columnDict : (Sequence)super.readObject();
                    this._$12 = this.read();
                    boolean isConst = this.readBoolean();
                    if (isConst) {
                        this._$13 = 96;
                        int pos = this.read();
                        this._$9 = this._$11.get(pos);
                        return;
                    }
                    int index = this.index;
                    byte[] buffer = this.buffer;
                    int[] pos = new int[recordCount + 1];
                    for (int i = 1; i <= recordCount; ++i) {
                        pos[i] = buffer[index++];
                    }
                    this._$10 = pos;
                    return;
                }
                case 3: {
                    this._$9 = super.readObject();
                    this._$8 = super.readInt();
                    this._$12 = this._$9 instanceof Integer ? 16 : 32;
                    return;
                }
                case 16: 
                case 32: 
                case 48: {
                    return;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        catch (IOException e) {
            throw new RQException(e);
        }
        int index = this.index + recordCount * dataSize;
        byte[] buffer = this.buffer;
        if (buffer[index++] != 0) {
            this._$7 = new boolean[recordCount + 1];
            for (int i = 1; i <= recordCount; ++i) {
                this._$7[i] = buffer[index++] != 0;
            }
        }
    }

    private int _$13() {
        byte[] in = this.buffer;
        int offset = this.index;
        this.index += 2;
        return in[offset + 1] << 8 | in[offset] & 0xFF;
    }

    private int _$12() {
        byte[] in = this.buffer;
        int offset = this.index;
        this.index += 4;
        return (in[offset + 3] << 24) + ((in[offset + 2] & 0xFF) << 16) + ((in[offset + 1] & 0xFF) << 8) + (in[offset] & 0xFF);
    }

    private long _$11() {
        byte[] in = this.buffer;
        int offset = this.index;
        this.index += 8;
        return ((long)in[offset + 7] << 56) + ((long)(in[offset + 6] & 0xFF) << 48) + ((long)(in[offset + 5] & 0xFF) << 40) + ((long)(in[offset + 4] & 0xFF) << 32) + ((long)(in[offset + 3] & 0xFF) << 24) + (long)((in[offset + 2] & 0xFF) << 16) + (long)((in[offset + 1] & 0xFF) << 8) + (long)(in[offset] & 0xFF);
    }

    private double _$10() {
        byte[] in = this.buffer;
        int offset = this.index;
        this.index += 8;
        long v = ((long)in[offset + 7] << 56) + ((long)(in[offset + 6] & 0xFF) << 48) + ((long)(in[offset + 5] & 0xFF) << 40) + ((long)(in[offset + 4] & 0xFF) << 32) + ((long)(in[offset + 3] & 0xFF) << 24) + (long)((in[offset + 2] & 0xFF) << 16) + (long)((in[offset + 1] & 0xFF) << 8) + (long)(in[offset] & 0xFF);
        return Double.longBitsToDouble(v);
    }

    public Object readObject() throws IOException {
        switch (this._$13) {
            case 96: {
                return this._$9;
            }
            case 17: {
                if (this._$7 != null) {
                    ++this._$6;
                    if (this._$7[this._$6]) {
                        ++this.index;
                        return null;
                    }
                }
                return (int)this.readByte();
            }
            case 33: {
                if (this._$7 != null) {
                    ++this._$6;
                    if (this._$7[this._$6]) {
                        ++this.index;
                        return null;
                    }
                }
                return (long)this.readByte();
            }
            case 18: {
                if (this._$7 != null) {
                    ++this._$6;
                    if (this._$7[this._$6]) {
                        this.index += 2;
                        return null;
                    }
                }
                return this._$13();
            }
            case 34: {
                if (this._$7 != null) {
                    ++this._$6;
                    if (this._$7[this._$6]) {
                        this.index += 2;
                        return null;
                    }
                }
                return (long)this._$13();
            }
            case 20: {
                if (this._$7 != null) {
                    ++this._$6;
                    if (this._$7[this._$6]) {
                        this.index += 4;
                        return null;
                    }
                }
                return this._$12();
            }
            case 36: {
                if (this._$7 != null) {
                    ++this._$6;
                    if (this._$7[this._$6]) {
                        this.index += 4;
                        return null;
                    }
                }
                return (long)this._$12();
            }
            case 40: {
                if (this._$7 != null) {
                    ++this._$6;
                    if (this._$7[this._$6]) {
                        this.index += 8;
                        return null;
                    }
                }
                return this._$11();
            }
            case 56: {
                if (this._$7 != null) {
                    ++this._$6;
                    if (this._$7[this._$6]) {
                        this.index += 8;
                        return null;
                    }
                }
                return this._$10();
            }
            case 70: {
                if (this._$7 != null) {
                    ++this._$6;
                    if (this._$7[this._$6]) {
                        this.index += 16;
                        return null;
                    }
                }
                long v1 = this.readLong64();
                long v2 = this.readLong64();
                return new SerialBytes(v1, v2);
            }
            case 81: {
                ++this._$6;
                int len = this._$10[this._$6];
                if (len == 0) {
                    return new String();
                }
                byte[] ba = new byte[len];
                super.read(ba);
                return new String(ba);
            }
            case 127: {
                ++this._$6;
                return this._$11.get(this._$10[this._$6]);
            }
            case 3: {
                if (this._$12 == 16) {
                    int value = (Integer)this._$9 + this._$6 * this._$8;
                    ++this._$6;
                    return value;
                }
                long value = (Long)this._$9 + (long)(this._$6 * this._$8);
                ++this._$6;
                return value;
            }
            case 16: 
            case 32: 
            case 48: {
                return super.readObject();
            }
        }
        throw new RuntimeException();
    }

    public void skipObject() throws IOException {
        switch (this._$13) {
            case 96: {
                return;
            }
            case 17: 
            case 33: {
                if (this._$7 != null) {
                    ++this._$6;
                }
                ++this.index;
                return;
            }
            case 18: 
            case 34: {
                if (this._$7 != null) {
                    ++this._$6;
                }
                this.index += 2;
                return;
            }
            case 20: 
            case 36: {
                if (this._$7 != null) {
                    ++this._$6;
                }
                this.index += 4;
                return;
            }
            case 40: 
            case 56: {
                if (this._$7 != null) {
                    ++this._$6;
                }
                this.index += 8;
                return;
            }
            case 70: {
                if (this._$7 != null) {
                    ++this._$6;
                }
                this.index += 16;
                return;
            }
            case 81: {
                ++this._$6;
                int len = this._$10[this._$6];
                if (len != 0) {
                    this.index += len;
                }
                return;
            }
            case 3: 
            case 127: {
                ++this._$6;
                return;
            }
            case 16: 
            case 32: 
            case 48: {
                super.skipObject();
                return;
            }
        }
        throw new RuntimeException();
    }

    public void readObject(IArray array, int index) throws IOException {
        switch (this._$13) {
            case 96: {
                array.set(index, this._$9);
                return;
            }
            case 17: {
                if (this._$7 != null) {
                    ++this._$6;
                    if (this._$7[this._$6]) {
                        array.set(++index, null);
                        return;
                    }
                }
                ((IntArray)array).setInt(index, this.readByte());
                return;
            }
            case 33: {
                if (this._$7 != null) {
                    ++this._$6;
                    if (this._$7[this._$6]) {
                        array.set(++index, null);
                        return;
                    }
                }
                ((LongArray)array).setLong(index, this.readByte());
            }
            case 18: {
                if (this._$7 != null) {
                    ++this._$6;
                    if (this._$7[this._$6]) {
                        array.set(index += 2, null);
                        return;
                    }
                }
                ((IntArray)array).setInt(index, this._$13());
                return;
            }
            case 34: {
                if (this._$7 != null) {
                    ++this._$6;
                    if (this._$7[this._$6]) {
                        array.set(index += 2, null);
                        return;
                    }
                }
                ((LongArray)array).setLong(index, this._$13());
                return;
            }
            case 20: {
                if (this._$7 != null) {
                    ++this._$6;
                    if (this._$7[this._$6]) {
                        array.set(index += 4, null);
                        return;
                    }
                }
                ((IntArray)array).setInt(index, this._$12());
                return;
            }
            case 36: {
                if (this._$7 != null) {
                    ++this._$6;
                    if (this._$7[this._$6]) {
                        array.set(index += 4, null);
                        return;
                    }
                }
                ((LongArray)array).setLong(index, this._$12());
                return;
            }
            case 40: {
                if (this._$7 != null) {
                    ++this._$6;
                    if (this._$7[this._$6]) {
                        array.set(index += 8, null);
                        return;
                    }
                }
                ((LongArray)array).setLong(index, this._$11());
                return;
            }
            case 56: {
                if (this._$7 != null) {
                    ++this._$6;
                    if (this._$7[this._$6]) {
                        array.set(index += 8, null);
                        return;
                    }
                }
                ((DoubleArray)array).setDouble(index, this._$10());
                return;
            }
            case 70: {
                if (this._$7 != null) {
                    ++this._$6;
                    if (this._$7[this._$6]) {
                        array.set(index += 16, null);
                        return;
                    }
                }
                long v1 = this.readLong64();
                long v2 = this.readLong64();
                ((SerialBytesArray)array).set(index, new SerialBytes(v1, v2));
                return;
            }
            case 81: {
                ++this._$6;
                int len = this._$10[this._$6];
                if (len == 0) {
                    array.set(index, new String());
                } else {
                    byte[] ba = new byte[len];
                    super.read(ba);
                    array.set(index, new String(ba));
                }
                return;
            }
            case 127: {
                ++this._$6;
                array.set(index, this._$11.get(this._$10[this._$6]));
                return;
            }
            case 3: {
                if (this._$12 == 16) {
                    int value = (Integer)this._$9 + this._$6 * this._$8;
                    ++this._$6;
                    array.set(index, value);
                } else {
                    long value = (Long)this._$9 + (long)(this._$6 * this._$8);
                    ++this._$6;
                    array.set(index, value);
                }
                return;
            }
            case 16: {
                if (super.isNull()) {
                    super.readObject();
                    array.set(index, null);
                } else {
                    ((IntArray)array).setInt(index, super.readBaseInt());
                }
                return;
            }
            case 32: {
                if (super.isNull()) {
                    super.readObject();
                    array.set(index, null);
                } else {
                    ((LongArray)array).setLong(index, super.readBaseLong());
                }
                return;
            }
            case 48: {
                if (super.isNull()) {
                    super.readObject();
                    array.set(index, null);
                } else {
                    ((DoubleArray)array).setDouble(index, super.readBaseDouble());
                }
                return;
            }
        }
        array.set(index, super.readObject());
    }

    public IArray getEmptyArray(int count) {
        if (this._$13 == 127) {
            return this._$1(this._$12, count);
        }
        return this._$1(this._$13, count);
    }

    private IArray _$1(int dataType, int count) {
        switch (dataType) {
            case 96: {
                return PureBufferReader._$1(this._$9, count);
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                return new IntArray(count);
            }
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 40: {
                return new LongArray(count);
            }
            case 48: 
            case 56: {
                return new DoubleArray(count);
            }
            case 70: {
                return new SerialBytesArray(count);
            }
            case 80: 
            case 81: {
                return new StringArray(count);
            }
            case 64: {
                return new DateArray(count);
            }
            case 3: {
                return this._$1(this._$12, count);
            }
        }
        throw new RuntimeException();
    }

    private static IArray _$1(Object value, int capacity) {
        if (value instanceof Integer) {
            IntArray result = new IntArray(capacity);
            result.pushInt((Integer)value);
            return result;
        }
        if (value instanceof Long) {
            LongArray result = new LongArray(capacity);
            result.pushLong((Long)value);
            return result;
        }
        if (value instanceof Double) {
            DoubleArray result = new DoubleArray(capacity);
            result.pushDouble((Double)value);
            return result;
        }
        if (value instanceof Date) {
            DateArray result = new DateArray(capacity);
            result.pushDate((Date)value);
            return result;
        }
        if (value instanceof SerialBytes) {
            SerialBytesArray result = new SerialBytesArray(capacity);
            result.push((SerialBytes)value);
            return result;
        }
        if (value instanceof String) {
            StringArray result = new StringArray(capacity);
            result.pushString((String)value);
            return result;
        }
        if (value instanceof Boolean) {
            BoolArray result = new BoolArray(capacity);
            result.pushBool((Boolean)value);
            return result;
        }
        ObjectArray result = new ObjectArray(capacity);
        result.push(value);
        return result;
    }
}

