/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.common.RQException;
import com.scudata.dm.ObjectReader;
import com.scudata.dw.BlockLinkReader;
import com.scudata.dw.BufferReader;
import com.scudata.dw.ColPhyTable;
import com.scudata.dw.ColumnMetaData;
import com.scudata.util.Variant;
import java.io.IOException;

class RecordSeqSearcher {
    private ColPhyTable table;
    private long prevRecordCount = 0L;
    private int curBlock = -1;
    private int totalBlockCount;
    private BlockLinkReader rowCountReader;
    private BlockLinkReader[] colReaders;
    private ObjectReader[] segmentReaders;
    private long[] positions;
    private Object[] minValues;
    private Object[] maxValues;
    private int curRecordCount = 0;
    private int curIndex = -1;
    private Object[][] blockKeyValues;
    private boolean isEnd = false;

    public RecordSeqSearcher(ColPhyTable table) {
        this.table = table;
        this.init();
    }

    private void init() {
        this.totalBlockCount = this.table.getDataBlockCount();
        if (this.totalBlockCount == 0) {
            this.isEnd = true;
            return;
        }
        ColumnMetaData[] columns = this.table.getSortedColumns();
        int keyCount = columns.length;
        this.rowCountReader = this.table.getSegmentReader();
        this.colReaders = new BlockLinkReader[keyCount];
        this.segmentReaders = new ObjectReader[keyCount];
        this.positions = new long[keyCount];
        this.minValues = new Object[keyCount];
        this.maxValues = new Object[keyCount];
        this.blockKeyValues = new Object[keyCount][];
        int k = 0;
        while (k < keyCount) {
            this.colReaders[k] = columns[k].getColReader(true);
            this.segmentReaders[k] = columns[k].getSegmentReader();
            ++k;
        }
        this.nextBlock();
    }

    private boolean nextBlock() {
        this.prevRecordCount += (long)this.curRecordCount;
        this.curIndex = -1;
        if (++this.curBlock == this.totalBlockCount) {
            this.isEnd = true;
            return false;
        }
        try {
            this.curRecordCount = this.rowCountReader.readInt32();
            int keyCount = this.segmentReaders.length;
            int k = 0;
            while (k < keyCount) {
                this.positions[k] = this.segmentReaders[k].readLong40();
                this.minValues[k] = this.segmentReaders[k].readObject();
                this.maxValues[k] = this.segmentReaders[k].readObject();
                this.segmentReaders[k].skipObject();
                ++k;
            }
            if (keyCount > 1) {
                this.loadKeyValues();
                int idx = this.blockKeyValues[0].length - 1;
                int k2 = 0;
                while (k2 < keyCount) {
                    this.maxValues[k2] = this.blockKeyValues[k2][idx];
                    ++k2;
                }
            }
            return true;
        }
        catch (IOException e) {
            throw new RQException(e);
        }
    }

    private void loadKeyValues() {
        try {
            int keyCount = this.colReaders.length;
            int count = this.curRecordCount + 1;
            int k = 0;
            while (k < keyCount) {
                BufferReader reader = this.colReaders[k].readBlockData(this.positions[k], this.curRecordCount);
                Object[] vals = new Object[count];
                this.blockKeyValues[k] = vals;
                int i = 1;
                while (i < count) {
                    vals[i] = reader.readObject();
                    ++i;
                }
                ++k;
            }
        }
        catch (IOException e) {
            throw new RQException(e);
        }
    }

    public long findNext(Object keyValue) {
        int cmp;
        if (this.isEnd) {
            return -this.prevRecordCount - 1L;
        }
        if (this.curIndex != -1) {
            int cmp2 = Variant.compare(keyValue, this.maxValues[0]);
            if (cmp2 > 0) {
                this.nextBlock();
                return this.findNext(keyValue);
            }
            if (cmp2 == 0) {
                this.curIndex = this.curRecordCount;
                return this.prevRecordCount + (long)this.curIndex;
            }
            Object[] values = this.blockKeyValues[0];
            int i = this.curIndex;
            int end = this.curRecordCount;
            while (i < end) {
                cmp2 = Variant.compare(keyValue, values[i]);
                if (cmp2 == 0) {
                    this.curIndex = i;
                    return this.prevRecordCount + (long)i;
                }
                if (cmp2 < 0) {
                    this.curIndex = i;
                    return -this.prevRecordCount - (long)i;
                }
                ++i;
            }
            this.curIndex = this.curRecordCount;
            return -this.prevRecordCount - (long)this.curIndex;
        }
        while ((cmp = Variant.compare(keyValue, this.maxValues[0])) > 0) {
            if (this.nextBlock()) continue;
            return -this.prevRecordCount - 1L;
        }
        if (cmp == 0) {
            this.curIndex = this.curRecordCount;
            return this.prevRecordCount + (long)this.curRecordCount;
        }
        this.loadKeyValues();
        this.curIndex = 1;
        return this.findNext(keyValue);
    }

    public long findNext(Object[] keyValues) {
        int cmp;
        if (this.isEnd) {
            return -this.prevRecordCount - 1L;
        }
        if (this.curIndex != -1) {
            int cmp2 = Variant.compareArrays(keyValues, this.maxValues);
            if (cmp2 > 0) {
                this.nextBlock();
                return this.findNext(keyValues);
            }
            if (cmp2 == 0) {
                this.curIndex = this.curRecordCount;
                return this.prevRecordCount + (long)this.curIndex;
            }
            Object[][] blockKeyValues = this.blockKeyValues;
            int keyCount = keyValues.length;
            int i = this.curIndex;
            int end = this.curRecordCount;
            while (i < end) {
                block10: {
                    int k = 0;
                    while (k < keyCount) {
                        cmp2 = Variant.compare(keyValues[k], blockKeyValues[k][i]);
                        if (cmp2 <= 0) {
                            if (cmp2 < 0) {
                                this.curIndex = i;
                                return -this.prevRecordCount - (long)i;
                            }
                            ++k;
                            continue;
                        }
                        break block10;
                    }
                    this.curIndex = i;
                    return this.prevRecordCount + (long)i;
                }
                ++i;
            }
            this.curIndex = this.curRecordCount;
            return -this.prevRecordCount - (long)this.curIndex;
        }
        while ((cmp = Variant.compareArrays(keyValues, this.maxValues)) > 0) {
            if (this.nextBlock()) continue;
            return -this.prevRecordCount - 1L;
        }
        if (cmp == 0) {
            this.curIndex = this.curRecordCount;
            return this.prevRecordCount + (long)this.curRecordCount;
        }
        this.loadKeyValues();
        this.curIndex = 1;
        return this.findNext(keyValues);
    }

    boolean isEnd() {
        return this.isEnd;
    }
}

