/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dw.ColPhyTable;
import com.scudata.dw.ComTableRecord;
import com.scudata.dw.Cursor;
import com.scudata.dw.ModifyRecord;
import com.scudata.resources.EngineMessage;
import java.util.ArrayList;

class RecordValSearcher {
    private Cursor cs;
    private String[] fields;
    private Sequence pkeyData;
    private long recNUM;
    private ComTableRecord curRecord;
    private Record curModifyRecord;
    private int cur;
    private int len;
    private int[] index;
    private int indexSize;
    private ArrayList<ModifyRecord> modifyRecords;

    public RecordValSearcher() {
    }

    public void setData(Sequence pkeyData) {
        this.pkeyData = pkeyData;
        if (pkeyData.hasRecord()) {
            this.curRecord = (ComTableRecord)pkeyData.getMem(1);
            this.len = pkeyData.length();
            this.cur = 1;
            this.recNUM = this.curRecord.getRecordSeq();
        }
        this.fields = this.curRecord.getFieldNames();
    }

    public RecordValSearcher(ColPhyTable table, String[] fields) {
        this.cs = (Cursor)table.cursor(fields);
        this.pkeyData = this.cs.fetch(ICursor.FETCHCOUNT);
        if (this.pkeyData.hasRecord()) {
            this.curRecord = (ComTableRecord)this.pkeyData.getMem(1);
            this.len = this.pkeyData.length();
            this.cur = 1;
            this.recNUM = this.curRecord.getRecordSeq();
        }
        this.fields = this.curRecord.getFieldNames();
    }

    public void setIndex(int[] index) {
        this.index = index;
        if (index == null) {
            return;
        }
        this.indexSize = index.length;
    }

    public long getRecNum() {
        return this.recNUM;
    }

    public void setModifyRecords(ArrayList<ModifyRecord> modifyRecords) {
        this.modifyRecords = modifyRecords;
    }

    public void next() {
        ComTableRecord rec;
        ++this.cur;
        if (this.cur > this.len) {
            return;
        }
        this.curRecord = rec = (ComTableRecord)this.pkeyData.getMem(this.cur);
        this.recNUM = rec.getRecordSeq();
    }

    public int getRecordCount() {
        return this.pkeyData.length();
    }

    public boolean getKeyVals(long recNum, Record r) {
        ComTableRecord rec;
        if (recNum < this.recNUM) {
            return false;
        }
        if (recNum == this.recNUM) {
            rec = this.curRecord;
        } else {
            do {
                ++this.cur;
                if (this.cur > this.len) {
                    return false;
                }
                rec = (ComTableRecord)this.pkeyData.getMem(this.cur);
                if (recNum >= rec.getRecordSeq()) continue;
                this.curRecord = rec;
                this.recNUM = rec.getRecordSeq();
                return false;
            } while (recNum != rec.getRecordSeq());
            this.curRecord = rec;
            this.recNUM = recNum;
        }
        int[] index = this.index;
        int colCount = this.indexSize;
        int i = 0;
        while (i < colCount) {
            int id = index[i];
            if (id >= 0) {
                r.set(id, rec.getFieldValue(i));
            }
            ++i;
        }
        return true;
    }

    public void getKeyValues(long recNum, Record r) {
        ComTableRecord rec;
        if (recNum == this.recNUM) {
            rec = this.curRecord;
        } else {
            do {
                ++this.cur;
                if (this.cur <= this.len) continue;
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(r.toString(null)) + mm.getMessage("grouptable.invalidData"));
            } while (recNum != (rec = (ComTableRecord)this.pkeyData.getMem(this.cur)).getRecordSeq());
            this.curRecord = rec;
            this.recNUM = recNum;
        }
        int[] index = this.index;
        int colCount = this.indexSize;
        int i = 0;
        while (i < colCount) {
            int id = index[i];
            if (id >= 0) {
                r.set(id, rec.getFieldValue(i));
            }
            ++i;
        }
    }

    public void getMKeyValues(long recNum, Record r, int tableId) {
        ArrayList<ModifyRecord> modifyRecords;
        Record record = null;
        if (this.modifyRecords == null) {
            return;
        }
        if (tableId == 0) {
            recNum = -recNum;
            modifyRecords = this.modifyRecords;
            for (ModifyRecord mr : modifyRecords) {
                if (mr.getRecordSeq() != recNum) continue;
                this.curModifyRecord = record = mr.getRecord();
                break;
            }
        } else {
            modifyRecords = this.modifyRecords;
            for (ModifyRecord mr : modifyRecords) {
                if (mr.getParentRecordSeq() != recNum) continue;
                this.curModifyRecord = record = mr.getRecord();
                break;
            }
        }
        String[] fields = this.fields;
        int[] index = this.index;
        int colCount = this.indexSize;
        int i = 0;
        while (i < colCount) {
            int id = index[i];
            if (id >= 0) {
                r.set(id, record.getFieldValue(fields[i]));
            }
            ++i;
        }
    }

    public void getRecordValue(Record r) {
        ComTableRecord rec = this.curRecord;
        int[] index = this.index;
        int colCount = this.indexSize;
        int i = 0;
        while (i < colCount) {
            int id = index[i];
            if (id >= 0) {
                r.set(id, rec.getFieldValue(i));
            }
            ++i;
        }
    }

    public Object getRecordValue(int index) {
        return this.curRecord.getNormalFieldValue(index);
    }

    public Object getModifyRecordValue(int index) {
        return this.curModifyRecord.getNormalFieldValue(index);
    }
}

