/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.common.DateCache;
import com.scudata.common.ObjectCache;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.SerialBytes;
import com.scudata.dm.Table;
import com.scudata.dw.BufferWriter;
import com.scudata.dw.StructManager;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class RowBufferReader {
    private StructManager _$12;
    private byte[] _$11;
    private int _$10;
    private int _$9;
    private byte[] _$8 = new byte[32];
    private char[] _$7 = new char[128];
    private static final String[] _$6 = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    private static final Long _$5 = new Long(0L);
    private static final Double _$4 = new Double(0.0);
    private static final BigDecimal _$3 = new BigDecimal(BigInteger.ZERO);
    private static final Integer[] _$2 = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15)};
    private static final Object _$1 = new Object();

    public RowBufferReader(StructManager structManager, byte[] buffer) {
        this._$12 = structManager;
        this._$11 = buffer;
        this._$9 = buffer.length;
    }

    public RowBufferReader(StructManager structManager, byte[] buffer, int index, int count) {
        this._$12 = structManager;
        this._$11 = buffer;
        this._$10 = index;
        this._$9 = count;
    }

    public long position() {
        return this._$10;
    }

    public void skipFully(int n) throws IOException {
        int total = this._$9 - this._$10;
        if (total >= n) {
            this._$10 += n;
        } else {
            this._$10 = this._$9;
            throw new EOFException();
        }
    }

    public int skipBytes(int n) throws IOException {
        if (n < 1) {
            return 0;
        }
        int total = this._$9 - this._$10;
        if (total >= n) {
            this._$10 += n;
            return n;
        }
        this._$10 = this._$9;
        return total;
    }

    public long skip(long n) throws IOException {
        if (n < 1L) {
            return 0L;
        }
        long total = this._$9 - this._$10;
        if (total >= n) {
            this._$10 += (int)n;
            return n;
        }
        this._$10 = this._$9;
        return total;
    }

    public boolean hasNext() throws IOException {
        return this._$9 > this._$10;
    }

    public int available() throws IOException {
        return this._$9 - this._$10;
    }

    public void reset() {
        this._$10 = 0;
    }

    public void close() throws IOException {
        this._$10 = this._$9;
    }

    public boolean readBoolean() throws IOException {
        return this._$11[this._$10++] != 0;
    }

    public int read() throws IOException {
        return this._$11[this._$10++] & 0xFF;
    }

    private int _$8() throws IOException {
        return this._$11[this._$10++] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int total = this._$9 - this._$10;
        if (total >= len) {
            System.arraycopy(this._$11, this._$10, b, off, len);
            this._$10 += len;
            return len;
        }
        if (total > 0) {
            System.arraycopy(this._$11, this._$10, b, off, total);
            this._$10 = this._$9;
            return total;
        }
        return -1;
    }

    public void readFully(byte[] b) throws IOException {
        if (this.read(b, 0, b.length) != b.length) {
            throw new EOFException();
        }
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (this.read(b, off, len) != len) {
            throw new EOFException();
        }
    }

    public byte readByte() throws IOException {
        return this._$11[this._$10++];
    }

    public int readUnsignedByte() throws IOException {
        return this._$11[this._$10++] & 0xFF;
    }

    public short readShort() throws IOException {
        int ch1 = this._$11[this._$10++] << 8;
        return (short)(ch1 + (this._$11[this._$10++] & 0xFF));
    }

    public int readUnsignedShort() throws IOException {
        int ch1 = (this._$11[this._$10++] & 0xFF) << 8;
        return ch1 + (this._$11[this._$10++] & 0xFF);
    }

    public char readChar() throws IOException {
        int ch1 = this._$11[this._$10++] << 8;
        return (char)(ch1 + (this._$11[this._$10++] & 0xFF));
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        int b = this._$8();
        if (b == 21) {
            int n = this._$7();
            int scale = n >>> 14;
            n &= 0x3FFF;
            if (scale == 0) {
                return n;
            }
            if (scale == 1) {
                return (double)n / 100.0;
            }
            if (scale == 2) {
                return (double)n / 10000.0;
            }
            return n * 100;
        }
        if (b == 22) {
            int n = this.readInt32();
            int scale = n >>> 30;
            n &= 0x3FFFFFFF;
            if (scale == 0) {
                return n;
            }
            if (scale == 1) {
                return (double)n / 100.0;
            }
            if (scale == 2) {
                return (double)n / 10000.0;
            }
            return (double)n * 100.0;
        }
        return Double.longBitsToDouble(this.readLong64());
    }

    public String readLine() throws IOException {
        throw new IOException("readLine not supported");
    }

    public String readUTF() throws IOException {
        return this.readString();
    }

    public byte[] readByteArray() throws IOException {
        int len = this.readInt();
        if (len < 0) {
            return null;
        }
        byte[] buf = new byte[len];
        this.readFully(buf, 0, len);
        return buf;
    }

    public String[] readStrings() throws IOException {
        int len = this.readInt();
        if (len < 0) {
            return null;
        }
        String[] strs = new String[len];
        for (int i = 0; i < len; ++i) {
            strs[i] = this.readString();
        }
        return strs;
    }

    public String readString() throws IOException {
        int b = this._$8();
        if (b == 0) {
            return null;
        }
        int t1 = b & 0xF0;
        if (t1 == 192 || t1 == 208) {
            return this._$8(b & 0x1F);
        }
        if (t1 == 176) {
            return this._$9(b & 0xF);
        }
        if (t1 == 160) {
            return _$6[b & 0xF];
        }
        int n = this.readInt();
        return this._$8(n);
    }

    private String _$9(int size) throws IOException {
        char[] chars;
        int len;
        byte[] readBuffer = this._$8;
        this.readFully(readBuffer, 0, size);
        int b = readBuffer[size - 1] & 0xFF;
        int low = b & 0xF;
        if (low > 9) {
            len = 2 * size - 1;
            chars = new char[len];
            chars[len - 1] = (char)(48 + (b >>> 4));
        } else {
            len = 2 * size;
            chars = new char[len];
            chars[len - 2] = (char)(48 + (b >>> 4));
            chars[len - 1] = (char)(48 + low);
        }
        --size;
        int q = 0;
        for (int i = 0; i < size; ++i) {
            b = readBuffer[i] & 0xFF;
            chars[q++] = (char)(48 + (b >>> 4));
            chars[q++] = (char)(48 + (b & 0xF));
        }
        return new String(chars);
    }

    private String _$8(int size) throws IOException {
        byte[] bytearr;
        if (size == 0) {
            return "";
        }
        char[] charBuffer = this._$7;
        if (size > charBuffer.length) {
            this._$7 = charBuffer = new char[size];
        }
        int seq = 0;
        int i = 0;
        if (this._$9 - this._$10 >= size) {
            bytearr = this._$11;
            i = this._$10;
            this._$10 += size;
            size += i;
        } else {
            bytearr = new byte[size];
            this.readFully(bytearr, 0, size);
        }
        block5: while (i < size) {
            int c = bytearr[i] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++i;
                    charBuffer[seq++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((i += 2) > size) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[i - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    charBuffer[seq++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((i += 3) > size) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[i - 2];
                    byte char3 = bytearr[i - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    charBuffer[seq++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(charBuffer, 0, seq);
    }

    public long readLong() throws IOException {
        int b = this._$8();
        if (b == 3) {
            return 0L;
        }
        if (b == 18) {
            return this._$7();
        }
        if (b == 19) {
            return this.readInt32();
        }
        return this.readLong64();
    }

    public int readInt() throws IOException {
        int b = this._$8();
        if (b == 16) {
            return this._$7();
        }
        if (b == 17) {
            return this.readInt32();
        }
        if ((b & 0xF0) == 144) {
            return ((b & 0xF) << 8) + this._$8();
        }
        return b & 0xF;
    }

    private int _$7() throws IOException {
        int n = ((this._$11[this._$10] & 0xFF) << 8) + (this._$11[this._$10 + 1] & 0xFF);
        this._$10 += 2;
        return n;
    }

    private int _$6() throws IOException {
        byte[] data = this._$11;
        int index = this._$10;
        this._$10 += 3;
        return ((data[index] & 0xFF) << 16) + ((data[index + 1] & 0xFF) << 8) + (data[index + 2] & 0xFF);
    }

    public int readInt32() throws IOException {
        byte[] data = this._$11;
        int index = this._$10;
        this._$10 += 4;
        return (data[index] << 24) + ((data[index + 1] & 0xFF) << 16) + ((data[index + 2] & 0xFF) << 8) + (data[index + 3] & 0xFF);
    }

    private long _$5() throws IOException {
        byte[] data = this._$11;
        int index = this._$10;
        this._$10 += 4;
        return ((long)(data[index] & 0xFF) << 24) + (long)((data[index + 1] & 0xFF) << 16) + (long)((data[index + 2] & 0xFF) << 8) + (long)(data[index + 3] & 0xFF);
    }

    public long readLong40() throws IOException {
        byte[] data = this._$11;
        int index = this._$10;
        this._$10 += 5;
        return ((long)(data[index] & 0xFF) << 32) + ((long)(data[index + 1] & 0xFF) << 24) + (long)((data[index + 2] & 0xFF) << 16) + (long)((data[index + 3] & 0xFF) << 8) + (long)(data[index + 4] & 0xFF);
    }

    public long readLong48() throws IOException {
        byte[] data = this._$11;
        int index = this._$10;
        this._$10 += 6;
        return ((long)(data[index] & 0xFF) << 40) + ((long)(data[index + 1] & 0xFF) << 32) + ((long)(data[index + 2] & 0xFF) << 24) + (long)((data[index + 3] & 0xFF) << 16) + (long)((data[index + 4] & 0xFF) << 8) + (long)(data[index + 5] & 0xFF);
    }

    public long readLong64() throws IOException {
        byte[] data = this._$11;
        int index = this._$10;
        this._$10 += 8;
        return ((long)data[index] << 56) + ((long)(data[index + 1] & 0xFF) << 48) + ((long)(data[index + 2] & 0xFF) << 40) + ((long)(data[index + 3] & 0xFF) << 32) + ((long)(data[index + 4] & 0xFF) << 24) + (long)((data[index + 5] & 0xFF) << 16) + (long)((data[index + 6] & 0xFF) << 8) + (long)(data[index + 7] & 0xFF);
    }

    private Object _$7(int b) throws IOException {
        switch (b) {
            case 0: {
                return null;
            }
            case 4: {
                return _$4;
            }
            case 5: {
                return _$3;
            }
            case 3: {
                return _$5;
            }
            case 1: {
                return Boolean.TRUE;
            }
            case 2: {
                return Boolean.FALSE;
            }
        }
        return _$1;
    }

    private Object _$6(int b) throws IOException {
        switch (b) {
            case 16: {
                return ObjectCache.getInteger(this._$7());
            }
            case 17: {
                return new Integer(this.readInt32());
            }
            case 21: {
                int n = this._$7();
                switch (n >>> 14) {
                    case 0: {
                        return new Double(n & 0x3FFF);
                    }
                    case 1: {
                        return new Double((double)(n & 0x3FFF) / 100.0);
                    }
                    case 2: {
                        return new Double((double)(n & 0x3FFF) / 10000.0);
                    }
                }
                return new Double((n & 0x3FFF) * 100);
            }
            case 22: {
                int n = this.readInt32();
                switch (n >>> 30) {
                    case 0: {
                        return new Double(n & 0x3FFFFFFF);
                    }
                    case 1: {
                        return new Double((double)(n & 0x3FFFFFFF) / 100.0);
                    }
                    case 2: {
                        return new Double((double)(n & 0x3FFFFFFF) / 10000.0);
                    }
                }
                return new Double((n & 0x3FFFFFFF) * 100);
            }
            case 23: {
                return new Double(Double.longBitsToDouble(this.readLong64()));
            }
            case 18: {
                return new Long(this._$7());
            }
            case 19: {
                return new Long(this.readInt32());
            }
        }
        return new Long(this.readLong64());
    }

    private void _$5(int b) throws IOException {
        switch (b) {
            case 16: 
            case 18: 
            case 21: {
                this.skipFully(2);
                break;
            }
            case 17: 
            case 19: 
            case 22: {
                this.skipFully(4);
                break;
            }
            default: {
                this.skipFully(8);
            }
        }
    }

    private Object _$4(int b) throws IOException {
        switch (b) {
            case 33: {
                return this._$8(this.readInt());
            }
            case 32: {
                int scale = this._$8();
                int len = this._$8();
                byte[] buf = new byte[len];
                this.readFully(buf, 0, len);
                return new BigDecimal(new BigInteger(buf), scale);
            }
            case 34: {
                int len = this.readInt();
                Sequence seq = new Sequence(len);
                for (int i = 0; i < len; ++i) {
                    seq.add(this.readObject());
                }
                return seq;
            }
            case 35: {
                return this._$2();
            }
            case 37: {
                return this._$3();
            }
        }
        return this.readByteArray();
    }

    private void _$3(int b) throws IOException {
        switch (b) {
            case 33: {
                this.skipFully(this.readInt());
                break;
            }
            case 32: {
                this.skipFully(1);
                this.skipFully(this._$8());
                break;
            }
            case 34: {
                int len = this.readInt();
                for (int i = 0; i < len; ++i) {
                    this.skipObject();
                }
                break;
            }
            case 35: {
                this._$1();
                break;
            }
            default: {
                int n = this.readInt();
                if (n <= 0) break;
                this.skipFully(n);
            }
        }
    }

    private Object _$2(int b) throws IOException {
        switch (b) {
            case 48: {
                return DateCache.getDate(this._$7());
            }
            case 49: {
                return new Date(BufferWriter.BASEDATE - this._$5() * 1000L);
            }
            case 52: {
                return new Timestamp(this._$5() * 1000L);
            }
            case 53: {
                return new Timestamp(this._$5() * -1000L);
            }
            case 54: {
                return new Timestamp(this.readLong64());
            }
            case 50: {
                return new Time(BufferWriter._$7 + (long)(this._$7() * 1000));
            }
            case 51: {
                return new Time(BufferWriter._$7 + (long)((0x10000 | this._$7()) * 1000));
            }
            case 55: {
                return new Time(BufferWriter._$7 + (long)this.readInt32());
            }
            case 56: {
                return new Date(BufferWriter.BASEDATE + (long)this._$6() * 86400000L);
            }
        }
        return new Date(this.readLong64());
    }

    private void _$1(int b) throws IOException {
        switch (b) {
            case 49: 
            case 52: 
            case 53: 
            case 55: {
                this.skipFully(4);
                break;
            }
            case 54: 
            case 57: {
                this.skipFully(8);
                break;
            }
            case 56: {
                this.skipFully(3);
                break;
            }
            default: {
                this.skipFully(2);
            }
        }
    }

    public boolean isNone(Object obj) {
        return obj == _$1;
    }

    private Object _$4() throws IOException {
        Object obj = this.readObject();
        if (obj == null) {
            this.skipFully(8);
        } else {
            this.skipFully(3);
        }
        return obj;
    }

    public Object readObject() throws IOException {
        int b = this._$8();
        switch (b & 0xF0) {
            case 0: {
                return this._$7(b);
            }
            case 16: {
                return this._$6(b);
            }
            case 32: {
                return this._$4(b);
            }
            case 48: {
                return this._$2(b);
            }
            case 128: {
                return _$2[b & 0xF];
            }
            case 144: {
                return ObjectCache.getInteger(((b & 0xF) << 8) + this._$8());
            }
            case 192: 
            case 208: {
                return this._$8(b & 0x1F);
            }
            case 176: {
                return this._$9(b & 0xF);
            }
            case 160: {
                return _$6[b & 0xF];
            }
            case 224: {
                return this._$4();
            }
            case 64: {
                int len = b & 0xF;
                if (len == 0) {
                    long v1 = this.readLong64();
                    long v2 = this.readLong64();
                    return new SerialBytes(v1, v2);
                }
                byte[] bytes = new byte[len];
                this.read(bytes);
                return new SerialBytes(bytes, len);
            }
        }
        throw new RuntimeException();
    }

    public void skipObject() throws IOException {
        int b = this._$8();
        switch (b & 0xF0) {
            case 0: {
                break;
            }
            case 16: {
                this._$5(b);
                break;
            }
            case 32: {
                this._$3(b);
                break;
            }
            case 48: {
                this._$1(b);
                break;
            }
            case 128: {
                break;
            }
            case 144: {
                this.skipFully(1);
                break;
            }
            case 192: 
            case 208: {
                this.skipFully(b & 0x1F);
                break;
            }
            case 176: {
                this.skipFully(b & 0xF);
                break;
            }
            case 160: {
                break;
            }
            case 224: {
                this.skipFully(8);
                break;
            }
            case 64: {
                int len = b & 0xF;
                if (len > 0) {
                    this.skipFully(len);
                    break;
                }
                this.skipFully(16);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private Record _$3() throws IOException {
        int id = this.readInt();
        DataStruct ds = this._$12.getDataStruct(id);
        int fcount = ds.getFieldCount();
        Object[] vals = new Object[fcount];
        for (int f = 0; f < fcount; ++f) {
            vals[f] = this.readObject();
        }
        return new Record(ds, vals);
    }

    private Table _$2() throws IOException {
        int id = this.readInt();
        int len = this.readInt();
        DataStruct ds = this._$12.getDataStruct(id);
        int fcount = ds.getFieldCount();
        Object[] vals = new Object[fcount];
        Table table = new Table(ds, len);
        for (int i = 1; i <= len; ++i) {
            for (int f = 0; f < fcount; ++f) {
                vals[f] = this.readObject();
            }
            table.newLast(vals);
        }
        return table;
    }

    private void _$1() throws IOException {
        int fcount = this.readInt();
        for (int i = 0; i < fcount; ++i) {
            this.readString();
        }
        int len = this.readInt();
        for (int i = 1; i <= len; ++i) {
            for (int f = 0; f < fcount; ++f) {
                this.skipObject();
            }
        }
    }

    public int getCurPos() {
        return this._$10;
    }
}

