/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.array.IArray;
import com.scudata.common.RQException;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.SerialBytes;
import com.scudata.dw.StructManager;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.util.Arrays;
import java.util.Calendar;

public class RowBufferWriter {
    static final int _$51 = 0;
    static final int _$50 = 0;
    static final int _$49 = 1;
    static final int _$48 = 2;
    static final int _$47 = 3;
    static final int _$46 = 4;
    static final int _$45 = 5;
    static final int _$44 = 7;
    static final int _$43 = 16;
    static final int _$42 = 16;
    static final int _$41 = 17;
    static final int _$40 = 18;
    static final int _$39 = 19;
    static final int _$38 = 20;
    static final int _$37 = 21;
    static final int _$36 = 22;
    static final int _$35 = 23;
    static final int _$34 = 32;
    static final int _$33 = 32;
    static final int _$32 = 33;
    static final int _$31 = 34;
    static final int _$30 = 35;
    static final int _$29 = 36;
    static final int _$28 = 37;
    static final int _$27 = 48;
    static final int _$26 = 48;
    static final int _$25 = 49;
    static final int _$24 = 50;
    static final int _$23 = 51;
    static final int _$22 = 52;
    static final int _$21 = 53;
    static final int _$20 = 54;
    static final int _$19 = 55;
    static final int _$18 = 56;
    static final int _$17 = 57;
    static final int _$16 = 64;
    static final int _$15 = 128;
    static final int _$14 = 144;
    static final int _$13 = 160;
    static final int _$12 = 176;
    static final int _$11 = 192;
    static final int _$10 = 208;
    static final int _$9 = 224;
    private static final double _$8 = 1.0E-6;
    private static final int _$7 = 30;
    static final long _$6;
    static final long _$5;
    static final int _$4 = 65536;
    private byte[] _$3;
    private int _$2 = 0;
    private StructManager _$1;

    public RowBufferWriter(StructManager structManager) {
        this._$3 = new byte[65536];
        this._$1 = structManager;
    }

    public RowBufferWriter(StructManager structManager, byte[] buffer) {
        this._$3 = buffer;
        this._$1 = structManager;
    }

    public byte[] finish() throws IOException {
        int len = this._$2;
        this._$2 = 0;
        return Arrays.copyOf(this._$3, len);
    }

    public int getCount() {
        return this._$2;
    }

    public void reset() {
        this._$2 = 0;
    }

    private void _$1() {
        this._$3 = Arrays.copyOf(this._$3, this._$3.length << 1);
    }

    private void _$1(int newLen) {
        this._$3 = Arrays.copyOf(this._$3, Math.max(this._$3.length << 1, newLen));
    }

    public void write(int b) throws IOException {
        if (this._$2 >= this._$3.length) {
            this._$1();
        }
        this._$3[this._$2++] = (byte)b;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len > this._$3.length - this._$2) {
            this._$1(this._$2 + len);
        }
        System.arraycopy(b, off, this._$3, this._$2, len);
        this._$2 += len;
    }

    public void writeByte(int v) throws IOException {
        if (this._$2 >= this._$3.length) {
            this._$1();
        }
        this._$3[this._$2++] = (byte)v;
    }

    public void writeBoolean(boolean v) throws IOException {
        if (this._$2 >= this._$3.length) {
            this._$1();
        }
        this._$3[this._$2++] = v ? (byte)1 : 0;
    }

    public void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeBytes(String s) throws IOException {
        for (char c : s.toCharArray()) {
            this.write(c);
        }
    }

    public void writeChars(String s) throws IOException {
        for (char c : s.toCharArray()) {
            this.writeChar(c);
        }
    }

    public void writeUTF(String str) throws IOException {
        this.writeString(str);
    }

    public void writeBytes(byte[] v) throws IOException {
        if (v == null) {
            this.writeInt(-1);
        } else {
            int len = v.length;
            this.writeInt(len);
            this.write(v, 0, len);
        }
    }

    public void writeStrings(String[] strs) throws IOException {
        if (strs == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(strs.length);
            for (String str : strs) {
                this.writeString(str);
            }
        }
    }

    private boolean _$2(char[] charr, int len) {
        if (len > 30) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (charr[i] >= '0' && charr[i] <= '9') continue;
            return false;
        }
        return true;
    }

    private void _$1(char[] charr, int len) throws IOException {
        if (this._$3.length - this._$2 < 30) {
            this._$1();
        }
        byte[] writeBuffer = this._$3;
        int seq = this._$2;
        if (len % 2 == 0) {
            writeBuffer[seq++] = (byte)(0xB0 | len / 2);
            int i = 0;
            while (i < len) {
                int d1 = charr[i++] - 48;
                int d2 = charr[i++] - 48;
                writeBuffer[seq++] = (byte)(d1 << 4 | d2);
            }
        } else {
            writeBuffer[seq++] = (byte)(0xB0 | len / 2 + 1);
            --len;
            int i = 0;
            while (i < len) {
                int d1 = charr[i++] - 48;
                int d2 = charr[i++] - 48;
                writeBuffer[seq++] = (byte)(d1 << 4 | d2);
            }
            writeBuffer[seq++] = (byte)(charr[len] - 48 << 4 | 0xF);
        }
        this._$2 = seq;
    }

    public void writeString(String str) throws IOException {
        char c;
        if (str == null) {
            this.write(0);
            return;
        }
        int strlen = str.length();
        if (strlen == 0) {
            this.write(192);
            return;
        }
        if (strlen == 1) {
            char c2 = str.charAt(0);
            if (c2 >= '0' && c2 <= '9') {
                this.write(0xA0 | c2 - 48);
                return;
            }
            if (c2 >= 'A' && c2 <= 'F') {
                this.write(0xA0 | c2 - 65 + 10);
                return;
            }
        }
        char[] charr = new char[strlen];
        str.getChars(0, strlen, charr, 0);
        if (this._$2(charr, strlen)) {
            this._$1(charr, strlen);
            return;
        }
        int utflen = 0;
        int count = 0;
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        byte[] bytearr = new byte[utflen];
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        if (utflen <= 31) {
            this.write(0xC0 | utflen);
            this.write(bytearr);
        } else {
            this.write(33);
            this.writeInt(utflen);
            this.write(bytearr);
        }
    }

    private void _$1(BigDecimal bd) throws IOException {
        byte[] bts = bd.unscaledValue().toByteArray();
        int scale = bd.scale();
        if (scale == 0 && bts[0] == 0 && bts.length == 1) {
            this.write(5);
        } else {
            this.write(32);
            this.write(scale);
            this.write(bts.length);
            this.write(bts);
        }
    }

    private void _$1(BigInteger bi) throws IOException {
        byte[] bts = bi.toByteArray();
        if (bts[0] == 0 && bts.length == 1) {
            this.write(5);
        } else {
            this.write(32);
            this.write(0);
            this.write(bts.length);
            this.write(bts);
        }
    }

    private void _$1(double d, long v, int scale) throws IOException {
        if (v <= 16383L) {
            int n = (int)v;
            this.write(21);
            this.write(n >>> 8 | scale);
            this.write(n & 0xFF);
        } else if (v <= 0x3FFFFFFFL) {
            int n = (int)v;
            this.write(22);
            this.write(n >>> 24 | scale);
            this.write(n >>> 16 & 0xFF);
            this.write(n >>> 8 & 0xFF);
            this.write(n & 0xFF);
        } else {
            this._$1(d);
        }
    }

    private void _$1(double d) throws IOException {
        this.write(23);
        long v = Double.doubleToLongBits(d);
        this.writeLong64(v);
    }

    public void writeDouble(double d) throws IOException {
        if (d > 0.0 && d <= 1.073741823E9) {
            double v = Math.ceil(d);
            if (v - d < 1.0E-6) {
                long l = (long)v;
                if (l % 100L == 0L) {
                    this._$1(d, l / 100L, 192);
                } else {
                    this._$1(d, (long)v, 0);
                }
            } else {
                double d1 = d * 100.0;
                v = Math.ceil(d1);
                if (v - d1 < 1.0E-6) {
                    this._$1(d, (long)v, 64);
                } else {
                    d1 = d * 10000.0;
                    v = Math.ceil(d1);
                    if (v - d1 < 1.0E-6) {
                        this._$1(d, (long)v, 128);
                    } else {
                        this._$1(d);
                    }
                }
            }
        } else if (d == 0.0) {
            this.write(4);
        } else {
            this._$1(d);
        }
    }

    public void writeLong(long v) throws IOException {
        if (v == 0L) {
            this.write(3);
        } else if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
            int n = (int)v;
            if (n >= 0) {
                if (n <= 65535) {
                    this.write(18);
                    this.write(n >>> 8);
                    this.write(n & 0xFF);
                } else {
                    this.write(19);
                    this.write(n >>> 24);
                    this.write(n >>> 16 & 0xFF);
                    this.write(n >>> 8 & 0xFF);
                    this.write(n & 0xFF);
                }
            } else {
                this.write(19);
                this.write(n >>> 24);
                this.write(n >>> 16 & 0xFF);
                this.write(n >>> 8 & 0xFF);
                this.write(n & 0xFF);
            }
        } else {
            this.write(20);
            this.writeLong64(v);
        }
    }

    public void writeInt32(int n) throws IOException {
        this.write(n >>> 24);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public void writeInt64(int n) throws IOException {
        this.write(0);
        this.write(0);
        this.write(0);
        this.write(0);
        this.write(n >>> 24);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public void writeLong40(long v) throws IOException {
        if (this._$3.length - this._$2 < 5) {
            this._$1();
        }
        byte[] writeBuffer = this._$3;
        int seq = this._$2;
        writeBuffer[seq++] = (byte)(v >>> 32);
        writeBuffer[seq++] = (byte)(v >>> 24);
        writeBuffer[seq++] = (byte)(v >>> 16);
        writeBuffer[seq++] = (byte)(v >>> 8);
        writeBuffer[seq++] = (byte)(v >>> 0);
        this._$2 = seq;
    }

    public void writeLong48(long v) throws IOException {
        if (this._$3.length - this._$2 < 6) {
            this._$1();
        }
        byte[] writeBuffer = this._$3;
        int seq = this._$2;
        writeBuffer[seq++] = (byte)(v >>> 40);
        writeBuffer[seq++] = (byte)(v >>> 32);
        writeBuffer[seq++] = (byte)(v >>> 24);
        writeBuffer[seq++] = (byte)(v >>> 16);
        writeBuffer[seq++] = (byte)(v >>> 8);
        writeBuffer[seq++] = (byte)(v >>> 0);
        this._$2 = seq;
    }

    public void writeLong64(long v) throws IOException {
        if (this._$3.length - this._$2 < 8) {
            this._$1();
        }
        byte[] writeBuffer = this._$3;
        int seq = this._$2;
        writeBuffer[seq++] = (byte)(v >>> 56);
        writeBuffer[seq++] = (byte)(v >>> 48);
        writeBuffer[seq++] = (byte)(v >>> 40);
        writeBuffer[seq++] = (byte)(v >>> 32);
        writeBuffer[seq++] = (byte)(v >>> 24);
        writeBuffer[seq++] = (byte)(v >>> 16);
        writeBuffer[seq++] = (byte)(v >>> 8);
        writeBuffer[seq++] = (byte)(v >>> 0);
        this._$2 = seq;
    }

    public void writeInt(int n) throws IOException {
        if (n >= 0) {
            if (n <= 15) {
                this.write(0x80 | n);
            } else if (n <= 4095) {
                this.write(0x90 | n >>> 8);
                this.write(n & 0xFF);
            } else if (n <= 65535) {
                this.write(16);
                this.write(n >>> 8);
                this.write(n & 0xFF);
            } else {
                this.write(17);
                this.write(n >>> 24);
                this.write(n >>> 16 & 0xFF);
                this.write(n >>> 8 & 0xFF);
                this.write(n & 0xFF);
            }
        } else {
            this.write(17);
            this.write(n >>> 24);
            this.write(n >>> 16 & 0xFF);
            this.write(n >>> 8 & 0xFF);
            this.write(n & 0xFF);
        }
    }

    private void _$1(java.util.Date dt) throws IOException {
        long t = dt.getTime();
        if (t % 1000L == 0L) {
            long v = t / 1000L;
            if (v < 0L) {
                if ((v = -v) <= 0xFFFFFFFFL) {
                    this.write(53);
                    this.write((int)(v >>> 24));
                    this.write((int)(v >>> 16));
                    this.write((int)(v >>> 8));
                    this.write((int)(v >>> 0));
                    return;
                }
            } else if (v <= 0xFFFFFFFFL) {
                this.write(52);
                this.write((int)(v >>> 24));
                this.write((int)(v >>> 16));
                this.write((int)(v >>> 8));
                this.write((int)(v >>> 0));
                return;
            }
        }
        this.write(54);
        this.writeLong64(t);
    }

    private void _$1(Date date) throws IOException {
        long v = date.getTime();
        if (v >= _$6) {
            int d = (int)((v - _$6) / 86400000L);
            if (d > 65535) {
                if (d > 0xFFFFFF) {
                    this.write(57);
                    this.writeLong64(v);
                } else {
                    this.write(56);
                    this.write(d >>> 16);
                    this.write(d >>> 8 & 0xFF);
                    this.write(d & 0xFF);
                }
            } else {
                this.write(48);
                this.write(d >>> 8);
                this.write(d & 0xFF);
            }
        } else {
            long d = (_$6 - v) / 1000L;
            if (d > 0xFFFFFFFFL) {
                this.write(57);
                this.writeLong64(v);
            } else {
                this.write(49);
                this.writeInt32((int)d);
            }
        }
    }

    private void _$2(Time time) throws IOException {
        int t = (int)((time.getTime() - _$5) % 86400000L);
        if (t < 0) {
            t += 86400000;
        }
        if (t % 1000 == 0) {
            if ((t /= 1000) > 65535) {
                this.write(51);
                this.write(t >>> 8 & 0xFF);
                this.write(t & 0xFF);
            } else {
                this.write(50);
                this.write(t >>> 8);
                this.write(t & 0xFF);
            }
        } else {
            this.write(55);
            this.write(t >>> 24);
            this.write(t >>> 16 & 0xFF);
            this.write(t >>> 8 & 0xFF);
            this.write(t & 0xFF);
        }
    }

    private void _$1(Time time) throws IOException {
        int t = (int)((time.getTime() - _$5) % 86400000L);
        if (t < 0) {
            t += 86400000;
        }
        this.write(55);
        this.write(t >>> 24);
        this.write(t >>> 16 & 0xFF);
        this.write(t >>> 8 & 0xFF);
        this.write(t & 0xFF);
    }

    private void _$1(Record r) throws IOException {
        DataStruct ds = r.dataStruct();
        int fcount = ds.getFieldCount();
        int id = this._$1.getDataStructID(ds);
        Object[] vals = r.getFieldValues();
        this.write(37);
        this.writeInt(id);
        for (int f = 0; f < fcount; ++f) {
            this.writeObject(vals[f]);
        }
    }

    private void _$1(Sequence seq) throws IOException {
        IArray mems = seq.getMems();
        int len = mems.size();
        DataStruct ds = seq.dataStruct();
        if (ds == null) {
            this.write(34);
            this.writeInt(len);
            for (int i = 1; i <= len; ++i) {
                this.writeObject(mems.get(i));
            }
        } else {
            int fcount = ds.getFieldCount();
            int id = this._$1.getDataStructID(ds);
            this.write(35);
            this.writeInt(id);
            this.writeInt(len);
            for (int i = 1; i <= len; ++i) {
                Record r = (Record)mems.get(i);
                Object[] vals = r.getFieldValues();
                for (int f = 0; f < fcount; ++f) {
                    this.writeObject(vals[f]);
                }
            }
        }
    }

    public void writeObject(Object obj) throws IOException {
        if (obj == null) {
            this.write(0);
        } else if (obj instanceof String) {
            this.writeString((String)obj);
        } else if (obj instanceof Integer) {
            this.writeInt(((Number)obj).intValue());
        } else if (obj instanceof Double) {
            this.writeDouble(((Number)obj).doubleValue());
        } else if (obj instanceof BigDecimal) {
            this._$1((BigDecimal)obj);
        } else if (obj instanceof Long) {
            this.writeLong(((Number)obj).longValue());
        } else if (obj instanceof Date) {
            this._$1((Date)obj);
        } else if (obj instanceof Time) {
            this._$2((Time)obj);
        } else if (obj instanceof java.util.Date) {
            this._$1((java.util.Date)obj);
        } else if (obj instanceof Boolean) {
            if (((Boolean)obj).booleanValue()) {
                this.write(1);
            } else {
                this.write(2);
            }
        } else if (obj instanceof BigInteger) {
            this._$1((BigInteger)obj);
        } else if (obj instanceof Float) {
            this.writeDouble(((Number)obj).doubleValue());
        } else if (obj instanceof Number) {
            this.writeInt(((Number)obj).intValue());
        } else if (obj instanceof Sequence) {
            this._$1((Sequence)obj);
        } else if (obj instanceof Record) {
            this._$1((Record)obj);
        } else if (obj instanceof byte[]) {
            this.write(36);
            this.writeBytes((byte[])obj);
        } else if (obj instanceof SerialBytes) {
            SerialBytes sb = (SerialBytes)obj;
            this.write(64);
            this.writeLong64(sb.getValue1());
            this.writeLong64(sb.getValue2());
        } else {
            throw new RQException("error type: " + obj.getClass().getName());
        }
    }

    public void writeFixedLengthObject(Object obj) throws IOException {
        if (obj == null) {
            this.write(224);
            this.writeInt64(0);
        } else if (obj instanceof Integer) {
            this.write(224);
            this.write(17);
            this.writeInt32(((Number)obj).intValue());
            this.write(0);
            this.write(0);
            this.write(0);
        } else if (obj instanceof Double) {
            this._$1(((Number)obj).doubleValue());
        } else if (obj instanceof Long) {
            this.write(20);
            this.writeLong64(((Number)obj).longValue());
        } else if (obj instanceof Date) {
            this.write(57);
            this.writeLong64(((Date)obj).getTime());
        } else if (obj instanceof Time) {
            this.write(224);
            this._$1((Time)obj);
            this.write(0);
            this.write(0);
            this.write(0);
        } else if (obj instanceof java.util.Date) {
            this.write(54);
            this.writeLong64(((java.util.Date)obj).getTime());
        } else if (obj instanceof Float) {
            this._$1(((Number)obj).doubleValue());
        } else if (obj instanceof Number) {
            this.write(224);
            this.write(17);
            this.writeInt32(((Number)obj).intValue());
            this.write(0);
            this.write(0);
            this.write(0);
        } else if (obj instanceof SerialBytes) {
            SerialBytes sb = (SerialBytes)obj;
            this.write(64);
            this.writeLong64(sb.getValue1());
            this.writeLong64(sb.getValue2());
        } else {
            throw new RQException("error type: " + obj.getClass().getName());
        }
    }

    public void writeNone() throws IOException {
        this.write(7);
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1970, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        _$5 = calendar.getTimeInMillis();
        calendar.set(1, 2000);
        _$6 = calendar.getTimeInMillis();
    }
}

