/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.common.RQException;
import com.scudata.dm.ObjectReader;
import com.scudata.dw.BlockLinkReader;
import com.scudata.dw.BufferReader;
import com.scudata.dw.RowPhyTable;
import com.scudata.util.Variant;
import java.io.IOException;

class RowRecordSeqSearcher {
    private RowPhyTable table;
    private long prevRecordCount = 0L;
    private int curBlock = -1;
    private int totalBlockCount;
    private BlockLinkReader rowReader;
    private ObjectReader segmentReader;
    private long position;
    private Object[] minValues;
    private Object[] maxValues;
    private int curRecordCount = 0;
    private int curIndex = -1;
    private Object[][] blockKeyValues;
    private boolean isEnd = false;

    public RowRecordSeqSearcher(RowPhyTable table) {
        this.table = table;
        this.init();
    }

    private void init() {
        this.totalBlockCount = this.table.getDataBlockCount();
        if (this.totalBlockCount == 0) {
            this.isEnd = true;
            return;
        }
        String[] columns = this.table.getSortedColNames();
        int keyCount = columns.length;
        this.rowReader = this.table.getRowReader(true);
        this.segmentReader = this.table.getSegmentObjectReader();
        this.minValues = new Object[keyCount];
        this.maxValues = new Object[keyCount];
        this.blockKeyValues = new Object[keyCount][];
        this.nextBlock();
    }

    private boolean nextBlock() {
        this.prevRecordCount += (long)this.curRecordCount;
        this.curIndex = -1;
        if (++this.curBlock == this.totalBlockCount) {
            this.isEnd = true;
            return false;
        }
        try {
            this.curRecordCount = this.segmentReader.readInt32();
            this.position = this.segmentReader.readLong40();
            int keyCount = this.minValues.length;
            int k = 0;
            while (k < keyCount) {
                this.minValues[k] = this.segmentReader.readObject();
                this.maxValues[k] = this.segmentReader.readObject();
                ++k;
            }
            if (keyCount > 1) {
                this.loadKeyValues();
                int idx = this.blockKeyValues[0].length - 1;
                int k2 = 0;
                while (k2 < keyCount) {
                    this.maxValues[k2] = this.blockKeyValues[k2][idx];
                    ++k2;
                }
            }
            return true;
        }
        catch (IOException e) {
            throw new RQException(e);
        }
    }

    private void loadKeyValues() {
        try {
            int keyCount = this.blockKeyValues.length;
            int skipCount = this.table.getColNames().length - keyCount;
            int count = this.curRecordCount + 1;
            BufferReader reader = this.rowReader.readBlockBuffer(this.position);
            Object[][] vals = new Object[keyCount][count];
            int k = 0;
            while (k < keyCount) {
                this.blockKeyValues[k] = vals[k];
                ++k;
            }
            int i = 1;
            while (i < count) {
                reader.skipObject();
                int k2 = 0;
                while (k2 < keyCount) {
                    vals[k2][i] = reader.readObject();
                    ++k2;
                }
                int s = 0;
                while (s < skipCount) {
                    reader.skipObject();
                    ++s;
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new RQException(e);
        }
    }

    public long findNext(Object keyValue) {
        int cmp;
        if (this.isEnd) {
            return -this.prevRecordCount - 1L;
        }
        if (this.curIndex != -1) {
            int cmp2 = Variant.compare(keyValue, this.maxValues[0]);
            if (cmp2 > 0) {
                this.nextBlock();
                return this.findNext(keyValue);
            }
            if (cmp2 == 0) {
                this.curIndex = this.curRecordCount;
                return this.prevRecordCount + (long)this.curIndex;
            }
            Object[] values = this.blockKeyValues[0];
            int i = this.curIndex;
            int end = this.curRecordCount;
            while (i < end) {
                cmp2 = Variant.compare(keyValue, values[i]);
                if (cmp2 == 0) {
                    this.curIndex = i;
                    return this.prevRecordCount + (long)i;
                }
                if (cmp2 < 0) {
                    this.curIndex = i;
                    return -this.prevRecordCount - (long)i;
                }
                ++i;
            }
            this.curIndex = this.curRecordCount;
            return -this.prevRecordCount - (long)this.curIndex;
        }
        while ((cmp = Variant.compare(keyValue, this.maxValues[0])) > 0) {
            if (this.nextBlock()) continue;
            return -this.prevRecordCount - 1L;
        }
        if (cmp == 0) {
            this.curIndex = this.curRecordCount;
            return this.prevRecordCount + (long)this.curRecordCount;
        }
        this.loadKeyValues();
        this.curIndex = 1;
        return this.findNext(keyValue);
    }

    public long findNext(Object[] keyValues) {
        int cmp;
        if (this.isEnd) {
            return -this.prevRecordCount - 1L;
        }
        if (this.curIndex != -1) {
            int cmp2 = Variant.compareArrays(keyValues, this.maxValues);
            if (cmp2 > 0) {
                this.nextBlock();
                return this.findNext(keyValues);
            }
            if (cmp2 == 0) {
                this.curIndex = this.curRecordCount;
                return this.prevRecordCount + (long)this.curIndex;
            }
            Object[][] blockKeyValues = this.blockKeyValues;
            int keyCount = keyValues.length;
            int i = this.curIndex;
            int end = this.curRecordCount;
            while (i < end) {
                block10: {
                    int k = 0;
                    while (k < keyCount) {
                        cmp2 = Variant.compare(keyValues[k], blockKeyValues[k][i]);
                        if (cmp2 <= 0) {
                            if (cmp2 < 0) {
                                this.curIndex = i;
                                return -this.prevRecordCount - (long)i;
                            }
                            ++k;
                            continue;
                        }
                        break block10;
                    }
                    this.curIndex = i;
                    return this.prevRecordCount + (long)i;
                }
                ++i;
            }
            this.curIndex = this.curRecordCount;
            return -this.prevRecordCount - (long)this.curIndex;
        }
        while ((cmp = Variant.compareArrays(keyValues, this.maxValues)) > 0) {
            if (this.nextBlock()) continue;
            return -this.prevRecordCount - 1L;
        }
        if (cmp == 0) {
            this.curIndex = this.curRecordCount;
            return this.prevRecordCount + (long)this.curRecordCount;
        }
        this.curIndex = 1;
        return this.findNext(keyValues);
    }

    boolean isEnd() {
        return this.isEnd;
    }
}

