/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw;

import com.scudata.common.RQException;
import com.scudata.dm.ObjectReader;
import com.scudata.dw.BlockLinkReader;
import com.scudata.dw.BufferReader;
import com.scudata.dw.RowPhyTable;
import com.scudata.util.Variant;
import java.io.IOException;

class RowRecordSeqSearcher2 {
    private RowPhyTable table;
    private RowPhyTable baseTable;
    private long prevRecordCount = 0L;
    private int curBlock = -1;
    private int totalBlockCount;
    private BlockLinkReader rowReader;
    private ObjectReader segmentReader;
    private BlockLinkReader baseRowReader;
    private ObjectReader baseSegmentReader;
    private long position;
    private long basePosition;
    private Object[] minValues;
    private Object[] maxValues;
    private int curRecordCount = 0;
    private int curIndex = -1;
    private Object[][] blockKeyValues;
    private boolean isEnd = false;
    private int baseKeyCount;
    private long[] guideVals;
    private int[] baseKeyIndex;
    private int[] keyIndex;

    public RowRecordSeqSearcher2(RowPhyTable table) {
        this.table = table;
        this.baseTable = (RowPhyTable)table.groupTable.baseTable;
        this.init();
    }

    private void init() {
        this.totalBlockCount = this.table.getDataBlockCount();
        this.baseKeyCount = this.table.sortedColStartIndex;
        if (this.totalBlockCount == 0) {
            this.isEnd = true;
            return;
        }
        String[] columns = this.table.getAllSortedColNames();
        int keyCount = columns.length;
        this.rowReader = this.table.getRowReader(true);
        this.segmentReader = this.table.getSegmentObjectReader();
        this.minValues = new Object[keyCount];
        this.maxValues = new Object[keyCount];
        this.blockKeyValues = new Object[keyCount][];
        this.baseRowReader = this.baseTable.getRowReader(true);
        this.baseSegmentReader = this.baseTable.getSegmentObjectReader();
        this.keyIndex = this.table.getSortedColIndex();
        this.baseKeyIndex = this.baseTable.getSortedColIndex();
        this.nextBlock();
    }

    private boolean nextBlock() {
        this.prevRecordCount += (long)this.curRecordCount;
        this.curIndex = -1;
        if (++this.curBlock == this.totalBlockCount) {
            this.isEnd = true;
            return false;
        }
        try {
            this.curRecordCount = this.segmentReader.readInt32();
            this.baseSegmentReader.readInt32();
            this.position = this.segmentReader.readLong40();
            this.basePosition = this.baseSegmentReader.readLong40();
            int k = 0;
            while (k < this.baseKeyCount) {
                this.minValues[k] = this.baseSegmentReader.readObject();
                this.maxValues[k] = this.baseSegmentReader.readObject();
                ++k;
            }
            int keyCount = this.minValues.length;
            int k2 = this.baseKeyCount;
            while (k2 < keyCount) {
                this.minValues[k2] = this.segmentReader.readObject();
                this.maxValues[k2] = this.segmentReader.readObject();
                ++k2;
            }
            return true;
        }
        catch (IOException e) {
            throw new RQException(e);
        }
    }

    private void loadKeyValues() {
        try {
            int keyCount = this.blockKeyValues.length;
            int baseKeyCount = this.baseKeyCount;
            int colCount = this.table.getAllColNames().length;
            int baseColCount = this.baseTable.getColNames().length;
            int count = this.curRecordCount + 1;
            long[] guideVals = new long[count];
            this.guideVals = guideVals;
            BufferReader reader = this.rowReader.readBlockBuffer(this.position);
            BufferReader baseReader = this.baseRowReader.readBlockBuffer(this.basePosition);
            Object[][] vals = new Object[keyCount][count];
            int k = 0;
            while (k < keyCount) {
                this.blockKeyValues[k] = vals[k];
                ++k;
            }
            Object[] temp = new Object[this.table.getTotalColNames().length];
            Object[] baseVals = new Object[baseKeyCount];
            long baseSeq = (Long)baseReader.readObject();
            int k2 = 0;
            while (k2 < baseColCount) {
                temp[k2] = baseReader.readObject();
                ++k2;
            }
            k2 = 0;
            while (k2 < baseKeyCount) {
                baseVals[k2] = temp[this.baseKeyIndex[k2]];
                ++k2;
            }
            int i = 1;
            while (i < count) {
                long seq;
                reader.skipObject();
                guideVals[i] = seq = ((Long)reader.readObject()).longValue();
                int k3 = baseKeyCount;
                while (k3 < colCount) {
                    temp[k3] = reader.readObject();
                    ++k3;
                }
                k3 = baseKeyCount;
                while (k3 < keyCount) {
                    vals[k3][i] = temp[this.keyIndex[k3]];
                    ++k3;
                }
                while (seq != baseSeq) {
                    baseSeq = (Long)baseReader.readObject();
                    k3 = 0;
                    while (k3 < baseColCount) {
                        temp[k3] = baseReader.readObject();
                        ++k3;
                    }
                    k3 = 0;
                    while (k3 < baseKeyCount) {
                        baseVals[k3] = temp[this.baseKeyIndex[k3]];
                        ++k3;
                    }
                }
                k3 = 0;
                while (k3 < baseKeyCount) {
                    vals[k3][i] = baseVals[k3];
                    ++k3;
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new RQException(e);
        }
    }

    public long findNext(Object keyValue, int[] block) {
        int cmp;
        block[0] = -1;
        if (this.isEnd) {
            return -this.prevRecordCount - 1L;
        }
        if (this.curIndex != -1) {
            int cmp2 = Variant.compare(keyValue, this.maxValues[0]);
            if (cmp2 > 0) {
                this.nextBlock();
                return this.findNext(keyValue, block);
            }
            Object[] values = this.blockKeyValues[0];
            int i = this.curIndex;
            int end = this.curRecordCount;
            while (i <= end) {
                cmp2 = Variant.compare(keyValue, values[i]);
                if (cmp2 == 0) {
                    this.curIndex = i;
                    return this.prevRecordCount + (long)i;
                }
                if (cmp2 < 0) {
                    this.curIndex = i;
                    return -this.prevRecordCount - (long)i;
                }
                ++i;
            }
            this.curIndex = this.curRecordCount;
            block[0] = this.curBlock + 1;
            return -this.prevRecordCount - (long)this.curIndex;
        }
        while ((cmp = Variant.compare(keyValue, this.maxValues[0])) > 0) {
            if (this.nextBlock()) continue;
            return -this.prevRecordCount - 1L;
        }
        if (cmp == 0) {
            this.curIndex = this.curRecordCount;
            return this.prevRecordCount + (long)this.curRecordCount;
        }
        this.loadKeyValues();
        this.curIndex = 1;
        return this.findNext(keyValue, block);
    }

    public long findNext(Object[] keyValues, int[] block) {
        int cmp;
        block[0] = -1;
        if (this.isEnd) {
            return -this.prevRecordCount - 1L;
        }
        if (this.curRecordCount == 0 && (cmp = Variant.compareArrays(keyValues, this.maxValues, this.baseKeyCount)) <= 0) {
            block[0] = this.curBlock + 1;
            return -this.prevRecordCount;
        }
        if (this.curIndex != -1) {
            cmp = this.curRecordCount == 0 ? Variant.compareArrays(keyValues, this.maxValues, this.baseKeyCount) : Variant.compareArrays(keyValues, this.maxValues);
            if (cmp > 0) {
                this.nextBlock();
                return this.findNext(keyValues, block);
            }
            if (cmp == 0) {
                if (this.curRecordCount == 0) {
                    block[0] = this.curBlock + 1;
                    return -this.prevRecordCount;
                }
                this.curIndex = this.curRecordCount;
                return this.prevRecordCount + (long)this.curIndex;
            }
            Object[][] blockKeyValues = this.blockKeyValues;
            int keyCount = keyValues.length;
            int i = this.curIndex;
            int end = this.curRecordCount;
            while (i <= end) {
                block13: {
                    int k = 0;
                    while (k < keyCount) {
                        cmp = Variant.compare(keyValues[k], blockKeyValues[k][i]);
                        if (cmp <= 0) {
                            if (cmp < 0) {
                                this.curIndex = i;
                                return -this.prevRecordCount - (long)i;
                            }
                            ++k;
                            continue;
                        }
                        break block13;
                    }
                    this.curIndex = i;
                    return this.prevRecordCount + (long)i;
                }
                ++i;
            }
            this.curIndex = this.curRecordCount;
            block[0] = this.curBlock + 1;
            return -this.prevRecordCount - (long)this.curIndex;
        }
        while ((cmp = this.curRecordCount == 0 ? Variant.compareArrays(keyValues, this.maxValues, this.baseKeyCount) : Variant.compareArrays(keyValues, this.maxValues)) > 0) {
            if (this.nextBlock()) continue;
            return -this.prevRecordCount - 1L;
        }
        if (cmp == 0) {
            if (this.curRecordCount == 0) {
                block[0] = this.curBlock + 1;
                return -this.prevRecordCount;
            }
            this.curIndex = this.curRecordCount;
            return this.prevRecordCount + (long)this.curRecordCount;
        }
        this.loadKeyValues();
        this.curIndex = 1;
        return this.findNext(keyValues, block);
    }

    public long findNext(Object[] keyValues, int keyLen) {
        int cmp;
        if (this.isEnd) {
            return -this.prevRecordCount - 1L;
        }
        if (this.curIndex != -1) {
            int cmp2 = Variant.compareArrays(keyValues, this.maxValues, keyLen);
            if (cmp2 > 0) {
                this.nextBlock();
                return this.findNext(keyValues, keyLen);
            }
            Object[][] blockKeyValues = this.blockKeyValues;
            int i = this.curIndex;
            int end = this.curRecordCount;
            while (i <= end) {
                block8: {
                    int k = 0;
                    while (k < keyLen) {
                        cmp2 = Variant.compare(keyValues[k], blockKeyValues[k][i]);
                        if (cmp2 <= 0) {
                            if (cmp2 < 0) {
                                this.curIndex = i + 1;
                                return -this.prevRecordCount - (long)i;
                            }
                            ++k;
                            continue;
                        }
                        break block8;
                    }
                    this.curIndex = i + 1;
                    return this.prevRecordCount + (long)i;
                }
                ++i;
            }
            this.nextBlock();
            return this.findNext(keyValues, keyLen);
        }
        while ((cmp = Variant.compareArrays(keyValues, this.maxValues, keyLen)) > 0) {
            if (this.nextBlock()) continue;
            return -this.prevRecordCount - 1L;
        }
        this.loadKeyValues();
        this.curIndex = 1;
        return this.findNext(keyValues, keyLen);
    }

    long getRecNum() {
        if (this.isEnd || this.guideVals == null) {
            return 0L;
        }
        return this.guideVals[this.curIndex];
    }

    public boolean isEnd() {
        return this.isEnd;
    }
}

