/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dw.compress;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dw.BufferReader;
import com.scudata.dw.compress.Column;
import com.scudata.resources.EngineMessage;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;

public class BigDecimalColumn
extends Column {
    private static final int _$7 = -1;
    private int _$6 = Integer.MIN_VALUE;
    private ArrayList<byte[]> _$5 = new ArrayList(1024);
    private ArrayList<int[]> _$4 = new ArrayList(1024);
    private int _$3 = 8192;
    private int _$2 = -1;
    private byte[] _$1 = new byte[65536];

    public void addData(Object data) {
        int[] posBlock;
        if (this._$3 == 8192) {
            if (this._$5.size() > 0) {
                byte[] block = new byte[this._$2];
                System.arraycopy(this._$1, 0, block, 0, this._$2);
                this._$5.set(this._$5.size() - 1, block);
            }
            posBlock = new int[8192];
            this._$5.add(this._$1);
            this._$4.add(posBlock);
            this._$3 = 0;
            this._$2 = 0;
        }
        if (data instanceof BigDecimal) {
            byte[] bts;
            int len;
            int free;
            BigDecimal decimal = (BigDecimal)data;
            int scale = decimal.scale();
            if (this._$6 != scale) {
                if (scale != Integer.MIN_VALUE) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("ds.colTypeDif"));
                }
                this._$6 = scale;
            }
            if ((free = this._$1.length - this._$2) < (len = (bts = decimal.unscaledValue().toByteArray()).length)) {
                byte[] tmp = new byte[this._$1.length * 3 / 2];
                System.arraycopy(this._$1, 0, tmp, 0, this._$1.length);
                this._$1 = tmp;
                this._$5.set(this._$5.size() - 1, tmp);
            }
            System.arraycopy(bts, 0, this._$1, this._$2, len);
            int[] posBlock2 = this._$4.get(this._$4.size() - 1);
            posBlock2[this._$3++] = this._$2;
            this._$2 += len;
        } else if (data == null) {
            posBlock = this._$4.get(this._$4.size() - 1);
            posBlock[this._$3++] = -1;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("ds.colTypeDif"));
        }
    }

    public Object getData(int row) {
        int i;
        int endPos;
        int b = --row / 8192;
        int index = row % 8192;
        int[] posBlock = this._$4.get(b);
        int startPos = posBlock[index];
        if (startPos == -1) {
            return null;
        }
        byte[] block = this._$5.get(b);
        if (b == this._$5.size() - 1) {
            endPos = this._$2;
            int end = this._$3;
            for (i = index + 1; i < end; ++i) {
                if (posBlock[i] == -1) continue;
                endPos = posBlock[i];
                break;
            }
        } else {
            endPos = block.length;
            for (i = index + 1; i < 8192; ++i) {
                if (posBlock[i] == -1) continue;
                endPos = posBlock[i];
                break;
            }
        }
        int len = endPos - startPos;
        byte[] bts = new byte[len];
        System.arraycopy(block, startPos, bts, 0, len);
        BigInteger bigInt = new BigInteger(bts);
        return new BigDecimal(bigInt, this._$6);
    }

    public Column clone() {
        return new BigDecimalColumn();
    }

    public void appendData(BufferReader br) throws IOException {
        this.addData(br.readObject());
    }
}

