/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.excel;

import com.scudata.app.common.AppUtil;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.Escape;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.ide.common.GM;
import com.scudata.util.CellSetUtil;
import com.scudata.util.Variant;

public class ExcelApi {
    public static final String EXCEL_SPLIT_CHAR = "\\";

    public static Object executeExcel(Sequence params, Context ctx) throws Exception {
        return ExcelApi.executeExcel(params, false, ctx);
    }

    public static Object executeExcel(Sequence params, boolean parseParam, Context ctx) throws Exception {
        ExcelApi.printParameters(params);
        if (params == null || params.length() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        Sequence args = new Sequence();
        boolean isSplEnd = false;
        int i = 1;
        int len = params.length();
        while (i <= len) {
            Object mem = params.get(i);
            if (isSplEnd) {
                Object param = params.get(i);
                if (parseParam && param instanceof String) {
                    param = Variant.parse((String)param);
                }
                args.add(param);
            } else {
                String spl = String.valueOf(mem);
                if (spl.endsWith(EXCEL_SPLIT_CHAR)) {
                    spl = spl.substring(0, spl.length() - 1);
                } else {
                    isSplEnd = true;
                }
                buf.append(spl);
            }
            ++i;
        }
        String spl = buf.toString();
        PgmCellSet cellSet = ExcelApi.excelSplToCellSet(spl, false);
        Object val = AppUtil.executeCmd(spl = ExcelApi.cellSetToJdbcSpl(cellSet), args, ctx, false);
        if (val == null) {
            return null;
        }
        if (val instanceof PgmCellSet) {
            PgmCellSet result = (PgmCellSet)val;
            if (result.hasNextResult()) {
                val = result.nextResult();
            } else {
                return null;
            }
        }
        if (val instanceof ICursor) {
            ICursor cursor = (ICursor)val;
            return cursor.fetch();
        }
        return val;
    }

    public static String cellSetToJdbcSpl(PgmCellSet cellSet) {
        if (cellSet.getRowCount() == 1 && cellSet.getColCount() == 1) {
            PgmNormalCell cell = cellSet.getPgmNormalCell(1, 1);
            String cellExp = cell.getExpString();
            switch (cell.getType()) {
                case 16: 
                case 32: {
                    if (16 == cell.getType() && cellExp.startsWith("$")) {
                        return cellExp;
                    }
                    if (cellExp.indexOf("(") > 0 && cellExp.endsWith(")")) {
                        int index;
                        String spl = cellExp.trim();
                        String splFile = spl.substring(0, index = spl.indexOf("("));
                        if (splFile.startsWith("call")) {
                            splFile = splFile.substring("call".length()).trim();
                        }
                        String splArgs = "";
                        if (index < spl.length() - 2) {
                            splArgs = "," + spl.substring(index + 1, spl.length() - 1);
                        }
                        spl = "jdbccall(" + Escape.addEscAndQuote(splFile) + splArgs + ")";
                        return spl;
                    }
                    return "=" + cellExp;
                }
                case 64: 
                case 128: 
                case 256: {
                    return null;
                }
                case 1: 
                case 2: {
                    return "=" + cellExp;
                }
                case 4: 
                case 8: {
                    return cellExp;
                }
            }
            return cellExp;
        }
        String spl = CellSetUtil.toString(cellSet);
        return "=" + spl;
    }

    public static PgmCellSet excelSplToCellSet(String spl, boolean escape) {
        if (!StringUtils.isValidString(spl)) {
            return null;
        }
        if (escape) {
            spl = Escape.removeEscAndQuote(spl, '\"');
        }
        spl = spl.replaceAll("\\\\", "\\\\\\\\");
        PgmCellSet cellSet = CellSetUtil.toPgmCellSet(spl);
        return cellSet;
    }

    private static void printParameters(Sequence params) {
        if (params == null) {
            Logger.debug("SPL Parameters: null");
            return;
        }
        if (params.length() == 0) {
            Logger.debug("SPL Parameters: []");
            return;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int i = 1;
        int len = params.length();
        while (i <= len) {
            if (i > 1) {
                buf.append(",");
            }
            buf.append(GM.renderValueText(params.get(i)));
            ++i;
        }
        buf.append("]");
        Logger.debug("SPL Parameters: " + buf.toString());
    }
}

