/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.excel;

import com.scudata.common.CellLocation;
import com.scudata.common.Matrix;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.DataStruct;
import com.scudata.dm.FileObject;
import com.scudata.dm.ILineInput;
import com.scudata.dm.ILineOutput;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.excel.ExcelUtils;
import com.scudata.excel.IExcelTool;
import com.scudata.excel.IXlsExporter;
import com.scudata.excel.IXlsImporter;
import com.scudata.excel.XlsExporter;
import com.scudata.excel.XlsImporter;
import com.scudata.excel.XlsPaste;
import com.scudata.excel.XlsxExporter;
import com.scudata.excel.XlsxImporter;
import com.scudata.excel.XlsxPaste;
import com.scudata.excel.XlsxSExporter;
import com.scudata.expression.Expression;
import com.scudata.resources.AppMessage;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class ExcelTool
implements ILineInput,
ILineOutput {
    private IExcelTool impl;
    public static final String ROW_SEP = ExcelUtils.getLineSeparator();
    public static final String COL_SEP = "\t";
    private static final int BLOCKCOUNT = 1000;

    private void checkVersion() throws RQException {
        String v = System.getProperty("java.specification.version");
        if ((double)Float.parseFloat(v) < 1.6) {
            throw new RQException(AppMessage.get().getMessage("excel.jreversion"));
        }
    }

    public ExcelTool(FileObject fo, boolean hasTitle, boolean isXlsx, boolean isSsxxf, Object sheetName) {
        this(fo, hasTitle, isXlsx, isSsxxf, sheetName, null);
    }

    public ExcelTool(FileObject fo, boolean hasTitle, boolean isXlsx, boolean isSsxxf, Object sheetName, String pwd) {
        this(fo, hasTitle, isXlsx, isSsxxf, true, sheetName, pwd, false, false);
    }

    public ExcelTool(FileObject fo, boolean hasTitle, boolean isXlsx, boolean isSsxxf, boolean isAppend, Object sheetName, String pwd, boolean isW, boolean isK) {
        if (isXlsx) {
            this.checkVersion();
            this.impl = isSsxxf ? new XlsxSExporter(fo, hasTitle, isAppend, sheetName, pwd, isK) : new XlsxExporter(fo, hasTitle, isAppend, sheetName, pwd, isK);
        } else {
            this.impl = new XlsExporter(fo, hasTitle, isAppend, sheetName, pwd, isK);
        }
    }

    public ExcelTool(InputStream fis, boolean isXlsx) {
        this(fis, isXlsx, null);
    }

    public ExcelTool(InputStream fis, boolean isXlsx, String pwd) {
        if (isXlsx) {
            this.checkVersion();
            this.impl = new XlsxImporter(fis, pwd);
        } else {
            this.impl = new XlsImporter(fis, pwd);
        }
    }

    public int getMaxLineCount() {
        return this.impl.getMaxLineCount();
    }

    @Override
    public void writeLine(Object[] items) throws IOException {
        if (this.impl != null) {
            this.impl.writeLine(items);
        }
    }

    @Override
    public Object[] readLine() throws IOException {
        if (this.impl != null) {
            return this.impl.readLine();
        }
        return null;
    }

    @Override
    public boolean skipLine() throws IOException {
        return this.impl.readLine() != null;
    }

    public void output() {
        if (this.impl != null) {
            this.impl.output();
        }
    }

    public void setSheet(String name) {
        if (this.impl != null) {
            this.impl.setSheet(name);
        }
    }

    public void setSheet(int index) {
        if (this.impl != null) {
            this.impl.setSheet(index);
        }
    }

    public int totalCount() {
        if (this.impl != null) {
            return this.impl.totalCount();
        }
        return 0;
    }

    public void setStartRow(int start) {
        if (this.impl != null) {
            this.impl.setStartRow(start);
        }
    }

    public void setFetchCount(int fetchCount) {
        if (this.impl != null) {
            this.impl.setFetchCount(fetchCount);
        }
    }

    @Override
    public void close() throws IOException {
        this.output();
    }

    public static void pasteXls(FileObject fo, boolean isXlsx, Object s, String c, String t, boolean isRowInsert, String pwd) {
        CellLocation pos = CellLocation.parse(c);
        if (pos == null) {
            throw new RQException(AppMessage.get().getMessage("excel.invalidcell", c));
        }
        Matrix data = ExcelUtils.getStringMatrix(t, true);
        if (isXlsx) {
            new XlsxPaste(fo, s, pos, data, isRowInsert, pwd).output();
        } else {
            new XlsPaste(fo, s, pos, data, isRowInsert, pwd).output();
        }
    }

    public static String pasteXlsRead(FileObject fo, boolean isXlsx, Object s, String c, String t, String pwd) {
        String string;
        CellLocation startPos = CellLocation.parse(c);
        if (startPos == null) {
            throw new RQException(AppMessage.get().getMessage("excel.invalidcell", c));
        }
        CellLocation endPos = null;
        if (StringUtils.isValidString(t) && (endPos = CellLocation.parse(t)) == null) {
            throw new RQException(AppMessage.get().getMessage("excel.invalidcell", t));
        }
        int r1 = startPos.getRow();
        int c1 = startPos.getCol();
        if (endPos != null) {
            int r2 = endPos.getRow();
            int c2 = endPos.getCol();
            startPos = new CellLocation(Math.min(r1, r2), Math.min(c1, c2));
            endPos = new CellLocation(Math.max(r1, r2), Math.max(c1, c2));
        }
        int startRow = startPos.getRow();
        InputStream fis = null;
        try {
            ExcelTool et = new ExcelTool(fis, isXlsx, pwd);
            if (s instanceof String) {
                et.setSheet((String)s);
            } else if (s instanceof Number) {
                et.setSheet(((Number)s).intValue() - 1);
            } else if (s != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("xlspaste" + mm.getMessage("function.paramTypeError"));
            }
            et.setStartRow(startRow);
            Object[] line = et.readLine();
            if (line == null || line.length == 0) {
                return null;
            }
            int endCol = -1;
            endCol = endPos != null ? endPos.getCol() : line.length - 1;
            int startCol = startPos.getCol();
            int colCount = endCol - startCol + 1;
            ArrayList<Object[]> dataList = new ArrayList<Object[]>();
            Object[] lineArea = new Object[colCount];
            System.arraycopy(line, startCol, lineArea, 0, colCount);
            dataList.add(lineArea);
            int row = startRow + 1;
            while (endPos == null || row <= endPos.getRow()) {
                line = et.readLine();
                if (line == null) break;
                lineArea = new Object[colCount];
                System.arraycopy(line, startCol, lineArea, 0, colCount);
                dataList.add(lineArea);
                ++row;
            }
            int colSep = 9;
            String rowSep = ExcelUtils.getLineSeparator();
            StringBuffer buf = new StringBuffer();
            int r = 0;
            int len = dataList.size();
            while (r < len) {
                if (r > 0) {
                    buf.append(rowSep);
                }
                Object[] rowData = (Object[])dataList.get(r);
                int i = 0;
                while (i < rowData.length) {
                    if (i > 0) {
                        buf.append('\t');
                    }
                    buf.append(Variant.toExportString(rowData[i]));
                    ++i;
                }
                ++r;
            }
            string = buf.toString();
        }
        catch (Exception ex) {
            throw new RQException(ex.getMessage(), ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        return string;
    }

    public Object fileXlsImport(String opt) throws IOException {
        return this.fileXlsImport(null, 0, Integer.MAX_VALUE, null, opt);
    }

    public Object fileXlsImport(String[] fields, int startRow, int endRow, Object s, String opt) throws IOException {
        if (s instanceof String) {
            this.setSheet((String)s);
        } else if (s instanceof Number) {
            this.setSheet(((Number)s).intValue() - 1);
        } else if (s != null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("import" + mm.getMessage("function.paramTypeError"));
        }
        IXlsImporter xlsImporter = new IXlsImporter(){

            @Override
            public Object[] readLine(int row, boolean isN, boolean isW) throws IOException {
                Object[] line = ExcelTool.this.readLine();
                if (line == null) {
                    return null;
                }
                if (isN) {
                    int i = 0;
                    while (i < line.length) {
                        line[i] = ExcelUtils.trim(line[i], isW);
                        ++i;
                    }
                }
                return line;
            }

            @Override
            public int totalCount() {
                return ExcelTool.this.totalCount();
            }

            @Override
            public void setStartRow(int startRow) {
                ExcelTool.this.setStartRow(startRow);
            }
        };
        return ExcelTool.fileXlsImport(fields, startRow, endRow, opt, xlsImporter);
    }

    public static Object fileXlsImport(String[] fields, int startRow, int endRow, String opt, IXlsImporter xlsImporter) throws IOException {
        Table table;
        DataStruct ds;
        String[] items;
        int fcount;
        boolean removeBlank;
        boolean isS;
        boolean isW;
        int rowCount;
        if (startRow > 0) {
            --startRow;
        } else if (startRow < 0 && (startRow += (rowCount = xlsImporter.totalCount())) < 0) {
            startRow = 0;
        }
        if (endRow > 0) {
            --endRow;
        } else if (endRow == 0) {
            endRow = xlsImporter.totalCount() - 1;
        } else if (endRow < 0) {
            rowCount = xlsImporter.totalCount();
            endRow += rowCount;
        }
        if (endRow < startRow) {
            return null;
        }
        xlsImporter.setStartRow(startRow);
        boolean bl = isW = opt != null && opt.indexOf(119) != -1;
        if (isW) {
            return ExcelTool.xlsImportW(startRow, endRow, opt, xlsImporter);
        }
        boolean bl2 = isS = opt != null && opt.indexOf(115) != -1;
        if (isS) {
            return ExcelTool.xlsImportS(startRow, endRow, opt, xlsImporter);
        }
        boolean isN = opt != null && opt.indexOf(110) != -1;
        Object[] line = xlsImporter.readLine(startRow, isN, false);
        if (line == null) {
            return null;
        }
        boolean bTitle = opt != null && opt.indexOf(116) != -1;
        boolean bl3 = removeBlank = opt != null && opt.indexOf(98) != -1;
        if (removeBlank) {
            while (ExcelUtils.isBlankRow(line)) {
                if (++startRow > endRow) {
                    return null;
                }
                line = xlsImporter.readLine(startRow, isN, false);
                if (line != null) continue;
                return null;
            }
        }
        if ((fcount = line.length) == 0) {
            return null;
        }
        if (bTitle) {
            items = new String[fcount];
            int f = 0;
            while (f < fcount) {
                items[f] = Variant.toString(line[f]);
                ++f;
            }
            ds = new DataStruct(items);
            ++startRow;
        } else {
            items = new String[fcount];
            ds = new DataStruct(items);
            xlsImporter.setStartRow(startRow);
        }
        if (fields == null || fields.length == 0) {
            table = new Table(ds);
            while (startRow <= endRow) {
                line = xlsImporter.readLine(startRow, isN, false);
                if (line != null) {
                    ++startRow;
                    int curLen = line.length;
                    if (curLen > fcount) {
                        curLen = fcount;
                    }
                    BaseRecord r = table.newLast();
                    int f = 0;
                    while (f < curLen) {
                        r.setNormalFieldValue(f, line[f]);
                        ++f;
                    }
                    continue;
                }
                break;
            }
        } else {
            int[] index = new int[fcount];
            int i = 0;
            while (i < fcount) {
                index[i] = -1;
                ++i;
            }
            i = 0;
            int count = fields.length;
            while (i < count) {
                int q = ds.getFieldIndex(fields[i]);
                if (q < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(String.valueOf(fields[i]) + mm.getMessage("ds.fieldNotExist"));
                }
                if (index[q] != -1) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(String.valueOf(fields[i]) + mm.getMessage("ds.colNameRepeat"));
                }
                index[q] = i;
                fields[i] = ds.getFieldName(q);
                ++i;
            }
            DataStruct newDs = new DataStruct(fields);
            table = new Table(newDs);
            while (startRow <= endRow) {
                line = xlsImporter.readLine(startRow, isN, false);
                if (line != null) {
                    ++startRow;
                    int curLen = line.length;
                    if (curLen > fcount) {
                        curLen = fcount;
                    }
                    BaseRecord r = table.newLast();
                    int f = 0;
                    while (f < curLen) {
                        if (index[f] != -1) {
                            r.setNormalFieldValue(index[f], line[f]);
                        }
                        ++f;
                    }
                    continue;
                }
                break;
            }
        }
        table.trimToSize();
        if (removeBlank) {
            ExcelTool.removeTableTailBlank(table);
        }
        return table;
    }

    private Object[] readLine(boolean isN, boolean isW) throws IOException {
        Object[] line = this.readLine();
        if (line == null) {
            return null;
        }
        if (isN) {
            int i = 0;
            while (i < line.length) {
                line[i] = ExcelUtils.trim(line[i], isW);
                ++i;
            }
        }
        return line;
    }

    public static Sequence xlsImportW(int startRow, int endRow, String opt, IXlsImporter xlsImporter) throws IOException {
        boolean isP = opt != null && opt.indexOf("p") > -1;
        boolean isN = opt != null && opt.indexOf("n") > -1;
        Sequence seq = new Sequence();
        while (startRow <= endRow) {
            Object[] line = xlsImporter.readLine(startRow, isN, true);
            if (line == null) break;
            ++startRow;
            Sequence subSeq = new Sequence(line.length);
            Object[] objectArray = line;
            int n = line.length;
            int n2 = 0;
            while (n2 < n) {
                Object data = objectArray[n2];
                subSeq.add(data);
                ++n2;
            }
            seq.add(subSeq);
        }
        if (isP) {
            seq = ExcelUtils.transpose(seq);
        }
        return seq;
    }

    public static String xlsImportS(int startRow, int endRow, String opt, IXlsImporter xlsImporter) throws IOException {
        boolean isN = opt != null && opt.indexOf("n") != -1;
        StringBuffer buf = new StringBuffer();
        boolean firstLine = true;
        while (startRow <= endRow) {
            Object[] line = xlsImporter.readLine(startRow, isN, false);
            if (line == null) break;
            ++startRow;
            if (firstLine) {
                firstLine = false;
            } else {
                buf.append(ROW_SEP);
            }
            int c = 0;
            while (c < line.length) {
                if (c > 0) {
                    buf.append(COL_SEP);
                }
                buf.append(line[c] == null ? "" : line[c].toString());
                ++c;
            }
        }
        return buf.toString();
    }

    public static void removeTableTailBlank(Table table) {
        int len;
        int lastContentRow = len = table.length();
        int i = len;
        while (i >= 1) {
            Object[] line = table.getRecord(i).getFieldValues();
            if (!ExcelUtils.isBlankRow(line)) {
                lastContentRow = i;
                break;
            }
            --i;
        }
        if (lastContentRow < len) {
            table.delete(lastContentRow + 1, len);
        }
    }

    public void fileXlsExport(Sequence series, Expression[] exps, String[] names, String opt, Context ctx) throws IOException {
        IXlsExporter xlsExporter = new IXlsExporter(){

            @Override
            public void writeLine(int row, Object[] items) throws IOException {
                ExcelTool.this.writeLine(items);
            }
        };
        ExcelTool.fileXlsExport(series, exps, names, 0, opt, ctx, xlsExporter);
    }

    public void fileXlsExport(ICursor cursor, Expression[] exps, String[] names, String opt, Context ctx) throws IOException {
        IXlsExporter xlsExporter = new IXlsExporter(){

            @Override
            public void writeLine(int row, Object[] items) throws IOException {
                ExcelTool.this.writeLine(items);
            }
        };
        ExcelTool.fileXlsExport(cursor, exps, names, 0, opt, ctx, xlsExporter);
    }

    public static int[] fileXlsExport(Sequence series, Expression[] exps, String[] names, int startRow, String opt, Context ctx, IXlsExporter xlsExporter) throws IOException {
        boolean bTitle;
        boolean isW = opt != null && opt.indexOf("w") != -1;
        boolean bl = bTitle = opt != null && opt.indexOf("t") != -1;
        if (isW) {
            return ExcelTool.fileXlsExportW(series, startRow, xlsExporter);
        }
        int colCount = -1;
        if (exps == null) {
            int fcount = 1;
            DataStruct ds = series.dataStruct();
            if (ds == null) {
                int len = series.length();
                if (bTitle && len > 0) {
                    xlsExporter.writeLine(startRow, new String[]{"_1"});
                    ++startRow;
                }
                Object[] lineObjs = new Object[fcount];
                int i = 1;
                while (i <= len) {
                    lineObjs[0] = series.getMem(i);
                    xlsExporter.writeLine(startRow, lineObjs);
                    ++startRow;
                    ++i;
                }
            } else {
                fcount = ds.getFieldCount();
                if (bTitle) {
                    xlsExporter.writeLine(startRow, ds.getFieldNames());
                    ++startRow;
                }
                Object[] lineObjs = new Object[fcount];
                int i = 1;
                int len = series.length();
                while (i <= len) {
                    BaseRecord r = (BaseRecord)series.getMem(i);
                    Object[] vals = r.getFieldValues();
                    int f = 0;
                    while (f < fcount) {
                        lineObjs[f] = vals[f] instanceof BaseRecord ? ((BaseRecord)vals[f]).value() : vals[f];
                        ++f;
                    }
                    xlsExporter.writeLine(startRow, lineObjs);
                    ++startRow;
                    ++i;
                }
            }
            colCount = fcount;
        } else {
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(series);
            stack.push(current);
            try {
                int fcount = exps.length;
                if (bTitle) {
                    if (names == null) {
                        names = new String[fcount];
                    }
                    series.getNewFieldNames(exps, names, "export");
                    xlsExporter.writeLine(startRow, names);
                    ++startRow;
                }
                Object[] lineObjs = new Object[fcount];
                int i = 1;
                int len = series.length();
                while (i <= len) {
                    current.setCurrent(i);
                    int f = 0;
                    while (f < fcount) {
                        lineObjs[f] = exps[f].calculate(ctx);
                        if (lineObjs[f] instanceof BaseRecord) {
                            lineObjs[f] = ((BaseRecord)lineObjs[f]).value();
                        }
                        ++f;
                    }
                    xlsExporter.writeLine(startRow, lineObjs);
                    ++startRow;
                    ++i;
                }
                colCount = fcount;
            }
            finally {
                stack.pop();
            }
        }
        return new int[]{startRow, colCount};
    }

    public static int[] fileXlsExport(ICursor cursor, Expression[] exps, String[] names, int startRow, String opt, Context ctx, IXlsExporter xlsExporter) throws IOException {
        boolean bTitle;
        boolean isW = opt != null && opt.indexOf("w") != -1;
        boolean bl = bTitle = opt != null && opt.indexOf("t") != -1;
        if (isW) {
            return ExcelTool.fileXlsExportW(cursor, startRow, xlsExporter);
        }
        Sequence table = cursor.fetch(1000);
        if (table == null || table.length() == 0) {
            return null;
        }
        int colCount = -1;
        if (exps == null) {
            int fcount = 1;
            DataStruct ds = table.dataStruct();
            if (ds == null) {
                if (bTitle) {
                    xlsExporter.writeLine(startRow, new String[]{"_1"});
                    ++startRow;
                }
            } else {
                fcount = ds.getFieldCount();
                if (bTitle) {
                    xlsExporter.writeLine(startRow, ds.getFieldNames());
                    ++startRow;
                }
            }
            Object[] lineObjs = new Object[fcount];
            do {
                int len;
                int i;
                if (ds == null) {
                    i = 1;
                    len = table.length();
                    while (i <= len) {
                        lineObjs[0] = table.getMem(i);
                        xlsExporter.writeLine(startRow, lineObjs);
                        ++startRow;
                        ++i;
                    }
                } else {
                    i = 1;
                    len = table.length();
                    while (i <= len) {
                        BaseRecord r = (BaseRecord)table.getMem(i);
                        Object[] vals = r.getFieldValues();
                        int f = 0;
                        while (f < fcount) {
                            lineObjs[f] = vals[f] instanceof BaseRecord ? ((BaseRecord)vals[f]).value() : vals[f];
                            ++f;
                        }
                        xlsExporter.writeLine(startRow, lineObjs);
                        ++startRow;
                        ++i;
                    }
                }
            } while ((table = cursor.fetch(1000)) != null && table.length() != 0);
            colCount = fcount;
        } else {
            int fcount = exps.length;
            Object[] lineObjs = new Object[fcount];
            if (bTitle) {
                if (names == null) {
                    names = new String[fcount];
                }
                table.getNewFieldNames(exps, names, "export");
                xlsExporter.writeLine(startRow, names);
                ++startRow;
            }
            ComputeStack stack = ctx.getComputeStack();
            do {
                Current current = new Current(table);
                stack.push(current);
                try {
                    int i = 1;
                    int len = table.length();
                    while (i <= len) {
                        current.setCurrent(i);
                        int f = 0;
                        while (f < fcount) {
                            lineObjs[f] = exps[f].calculate(ctx);
                            if (lineObjs[f] instanceof BaseRecord) {
                                lineObjs[f] = ((BaseRecord)lineObjs[f]).value();
                            }
                            ++f;
                        }
                        xlsExporter.writeLine(startRow, lineObjs);
                        ++startRow;
                        ++i;
                    }
                }
                finally {
                    stack.pop();
                }
            } while ((table = cursor.fetch(1000)) != null && table.length() != 0);
            colCount = fcount;
        }
        return new int[]{startRow, colCount};
    }

    private static int[] fileXlsExportW(Sequence seq, int startRow, IXlsExporter xlsExporter) throws IOException {
        if (seq == null || seq.length() == 0) {
            return null;
        }
        int colCount = 1;
        int i = 1;
        int len = seq.length();
        while (i <= len) {
            Object rowData = seq.get(i);
            Object[] line = ExcelTool.getLine(rowData);
            xlsExporter.writeLine(startRow, line);
            ++startRow;
            if (line != null) {
                colCount = Math.max(colCount, line.length);
            }
            ++i;
        }
        return new int[]{startRow, colCount};
    }

    private static int[] fileXlsExportW(ICursor cursor, int startRow, IXlsExporter xlsExporter) throws IOException {
        Sequence seq;
        if (cursor == null) {
            return null;
        }
        int colCount = 1;
        while ((seq = cursor.fetch(1000)) != null && seq.length() != 0) {
            int i = 1;
            int len = seq.length();
            while (i <= len) {
                Object rowData = seq.get(i);
                Object[] line = ExcelTool.getLine(rowData);
                xlsExporter.writeLine(startRow, line);
                ++startRow;
                if (line != null) {
                    colCount = Math.max(colCount, line.length);
                }
                ++i;
            }
        }
        return new int[]{startRow, colCount};
    }

    public static Object[] getLine(Object rowData) {
        Object[] line = null;
        if (rowData != null) {
            if (rowData instanceof Sequence) {
                Sequence subSeq = (Sequence)rowData;
                int subLen = subSeq.length();
                line = new Object[subLen];
                int j = 1;
                while (j <= subLen) {
                    line[j - 1] = subSeq.get(j);
                    ++j;
                }
            } else if (rowData instanceof BaseRecord) {
                BaseRecord record = (BaseRecord)rowData;
                line = record.getFieldValues();
            } else {
                line = rowData instanceof Object[] ? (Object[])rowData : new Object[]{rowData};
            }
        }
        return line;
    }
}

