/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.excel;

import com.scudata.app.common.AppUtil;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.Matrix;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.excel.ExcelVersionCompatibleUtilGetter;
import com.scudata.excel.IExcelTool;
import com.scudata.resources.AppMessage;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCell;

public class ExcelUtils {
    public static final byte TYPE_DATE = 0;
    public static final byte TYPE_TIME = 1;
    public static final byte TYPE_DATETIME = 2;

    public static InputStream decrypt(POIFSFileSystem pfs, String pwd) throws Exception {
        EncryptionInfo info = new EncryptionInfo(pfs);
        Decryptor d = Decryptor.getInstance((EncryptionInfo)info);
        if (!d.verifyPassword(pwd)) {
            throw new RQException(AppMessage.get().getMessage("excel.invalidpwd", pwd));
        }
        return d.getDataStream(pfs);
    }

    public static void encrypt(FileObject fo, String pwd) {
        block45: {
            POIFSFileSystem fs;
            block44: {
                fs = new POIFSFileSystem();
                InputStream in = null;
                OPCPackage opc = null;
                OutputStream os = null;
                try {
                    try {
                        EncryptionInfo info = new EncryptionInfo(EncryptionMode.standard);
                        Encryptor enc = info.getEncryptor();
                        enc.confirmPassword(pwd);
                        in = fo.getInputStream();
                        opc = OPCPackage.open((InputStream)in);
                        os = enc.getDataStream(fs);
                        opc.save(os);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (opc != null) {
                            try {
                                opc.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (Exception exception) {}
                        }
                        break block44;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (opc != null) {
                        try {
                            opc.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (opc != null) {
                    try {
                        opc.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            OutputStream out = null;
            try {
                try {
                    out = fo.getOutputStream(false);
                    fs.writeFilesystem(out);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (out == null) break block45;
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static boolean isXlsxFile(FileObject fo) {
        block42: {
            boolean bl;
            if (fo == null) {
                return false;
            }
            InputStream in = null;
            PushbackInputStream pin = null;
            BufferedInputStream bis = null;
            try {
                String fileName;
                boolean isXlsx;
                in = fo.getInputStream();
                if (!in.markSupported()) {
                    pin = new PushbackInputStream(in, 8);
                }
                if (isXlsx = ExcelUtils.isXlsxFile(bis = new BufferedInputStream(pin, Env.FILE_BUFSIZE))) {
                    return true;
                }
                if (fo == null || !StringUtils.isValidString(fileName = fo.getFileName())) break block42;
                bl = fileName.toLowerCase().endsWith(".xlsx");
            }
            catch (Exception e) {
                boolean bl2 = fo.getFileName().toLowerCase().endsWith(".xlsx");
                return bl2;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (pin != null) {
                    try {
                        pin.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            return bl;
        }
        return false;
    }

    public static boolean isXlsxFile(InputStream is) throws IOException {
        return FileMagic.OOXML.compareTo((Enum)FileMagic.valueOf((InputStream)is)) == 0;
    }

    public static boolean isCellDateFormatted(Cell cell, DataFormat df) {
        if (cell == null) {
            return false;
        }
        double d = cell.getNumericCellValue();
        if (DateUtil.isValidExcelDate((double)d)) {
            CellStyle style = cell.getCellStyle();
            short formatIndex = style.getDataFormat();
            String formatString = null;
            if (df != null) {
                formatString = df.getFormat(formatIndex);
            }
            if (formatString == null) {
                formatString = style.getDataFormatString();
            }
            return ExcelUtils.isADateFormat(formatIndex, formatString);
        }
        return false;
    }

    public static boolean isADateFormat(int formatIndex, String formatString) {
        if (DateUtil.isADateFormat((int)formatIndex, (String)formatString)) {
            return true;
        }
        return ExcelUtils.isChineseDateFormat(formatIndex, formatString);
    }

    private static boolean isChineseDateFormat(int formatIndex, String formatString) {
        if (!ExcelUtils.isChineseLanguage()) {
            return false;
        }
        if (ExcelUtils.isChineseInternalDateFormat(formatIndex)) {
            return true;
        }
        if (formatString == null || formatString.length() == 0) {
            return false;
        }
        return formatString.startsWith("reserved-0x");
    }

    private static boolean isChineseLanguage() {
        Locale local = Locale.getDefault();
        return "zh".equalsIgnoreCase(local.getLanguage());
    }

    private static boolean isChineseInternalDateFormat(int formatIndex) {
        switch (formatIndex) {
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return true;
            }
        }
        return false;
    }

    public static int getDateType(short format, String sformat) {
        switch (format) {
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 32: 
            case 33: 
            case 55: 
            case 56: {
                return 1;
            }
            case 22: {
                return 2;
            }
        }
        if (format >= 201 && format <= 211) {
            return 1;
        }
        if (sformat != null) {
            String s = sformat.toLowerCase();
            if (s.indexOf("y") < 0 && s.indexOf("d") < 0) {
                return 1;
            }
            if (s.indexOf("h") > -1 || s.indexOf("s") > -1 || s.indexOf("amp") > -1) {
                return 2;
            }
        }
        return 0;
    }

    public static Table import_x(IExcelTool importer, String[] fields, int startRow, int endRow, Object s, boolean bTitle) throws IOException {
        Table table;
        DataStruct ds;
        String[] items;
        int rowCount;
        if (startRow > 0) {
            --startRow;
        } else if (startRow < 0 && (startRow += (rowCount = importer.totalCount())) < 0) {
            startRow = 0;
        }
        if (endRow > 0) {
            --endRow;
        } else if (endRow == 0) {
            endRow = importer.totalCount() - 1;
        } else if (endRow < 0) {
            rowCount = importer.totalCount();
            endRow += rowCount;
        }
        if (endRow < startRow) {
            return null;
        }
        importer.setStartRow(startRow);
        Object[] line = importer.readLine();
        if (line == null) {
            return null;
        }
        int fcount = line.length;
        if (fcount == 0) {
            return null;
        }
        if (bTitle) {
            items = new String[fcount];
            int f = 0;
            while (f < fcount) {
                items[f] = Variant.toString(line[f]);
                ++f;
            }
            ds = new DataStruct(items);
            ++startRow;
        } else {
            items = new String[fcount];
            ds = new DataStruct(items);
            importer.setStartRow(startRow);
        }
        if (fields == null || fields.length == 0) {
            table = new Table(ds);
            while (startRow <= endRow) {
                line = importer.readLine();
                if (line != null) {
                    ++startRow;
                    int curLen = line.length;
                    if (curLen > fcount) {
                        curLen = fcount;
                    }
                    BaseRecord r = table.newLast();
                    int f = 0;
                    while (f < curLen) {
                        r.setNormalFieldValue(f, line[f]);
                        ++f;
                    }
                    continue;
                }
                break;
            }
        } else {
            int[] index = new int[fcount];
            int i = 0;
            while (i < fcount) {
                index[i] = -1;
                ++i;
            }
            i = 0;
            int count = fields.length;
            while (i < count) {
                int q = ds.getFieldIndex(fields[i]);
                if (q < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(String.valueOf(fields[i]) + mm.getMessage("ds.fieldNotExist"));
                }
                if (index[q] != -1) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(String.valueOf(fields[i]) + mm.getMessage("ds.colNameRepeat"));
                }
                index[q] = i;
                fields[i] = ds.getFieldName(q);
                ++i;
            }
            DataStruct newDs = new DataStruct(fields);
            table = new Table(newDs);
            while (startRow <= endRow) {
                line = importer.readLine();
                if (line != null) {
                    ++startRow;
                    int curLen = line.length;
                    if (curLen > fcount) {
                        curLen = fcount;
                    }
                    BaseRecord r = table.newLast();
                    int f = 0;
                    while (f < curLen) {
                        if (index[f] != -1) {
                            r.setNormalFieldValue(index[f], line[f]);
                        }
                        ++f;
                    }
                    continue;
                }
                break;
            }
        }
        table.trimToSize();
        return table;
    }

    public static Matrix getStringMatrix(String data, boolean parse) {
        Matrix matrix = new Matrix(1, 1);
        if (data == null || data.equals("")) {
            return matrix;
        }
        int r = 0;
        int c = 0;
        try {
            data = data.replaceAll("\r\n", "\r");
            data = data.replaceAll("\n", "\r");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArgumentTokenizer rows = new ArgumentTokenizer(data, '\r', true, true, true);
        while (rows.hasMoreTokens()) {
            String ls_row = rows.nextToken();
            ArgumentTokenizer items = new ArgumentTokenizer(ls_row, '\t', true, true, true);
            c = 0;
            if (r >= matrix.getRowSize()) {
                matrix.addRow();
            }
            while (items.hasMoreTokens()) {
                if (c >= matrix.getColSize()) {
                    matrix.addCol();
                }
                String item = items.nextToken();
                Object val = item;
                if (parse) {
                    val = item.startsWith("'") && !item.endsWith("'") ? item.substring(1) : Variant.parseCellValue(item);
                }
                matrix.set(r, c, val);
                ++c;
            }
            ++r;
        }
        return matrix;
    }

    public static String getLineSeparator() {
        return AppUtil.isWindowsOS() ? "\n" : System.getProperties().getProperty("line.separator");
    }

    public static Object[] getRowData(Row row, DataFormat dataFormat, FormulaEvaluator evaluator) {
        if (row == null) {
            return new Object[0];
        }
        int maxCol = row.getLastCellNum();
        if (maxCol < 0) {
            return new Object[0];
        }
        int firstCol = 0;
        Object[] items = new Object[maxCol - firstCol];
        int currCol = firstCol;
        while (currCol < maxCol) {
            block30: {
                CellType type;
                Cell cell;
                block35: {
                    block34: {
                        block33: {
                            block32: {
                                int colIndex;
                                block31: {
                                    cell = row.getCell(currCol);
                                    colIndex = currCol - firstCol;
                                    if (cell != null) break block31;
                                    items[colIndex] = null;
                                    break block30;
                                }
                                type = ExcelVersionCompatibleUtilGetter.getInstance().getCellType(cell);
                                if (CellType.FORMULA.compareTo((Enum)type) == 0) {
                                    try {
                                        type = ExcelVersionCompatibleUtilGetter.getInstance().getCellType(evaluator.evaluate(cell));
                                    }
                                    catch (Exception e) {
                                        try {
                                            type = ExcelVersionCompatibleUtilGetter.getInstance().getCachedFormulaResultType(cell);
                                        }
                                        catch (Exception ex) {
                                            try {
                                                items[colIndex] = new Boolean(cell.getBooleanCellValue());
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                            if (items[colIndex] == null) {
                                                try {
                                                    items[colIndex] = ExcelUtils.getNumericCellValue(cell, type, dataFormat);
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                            }
                                            if (items[colIndex] == null) {
                                                try {
                                                    items[colIndex] = cell.getStringCellValue();
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                            }
                                            if (items[colIndex] == null) {
                                                try {
                                                    items[colIndex] = cell.getRichStringCellValue().toString();
                                                }
                                                catch (Exception exception) {}
                                            }
                                            break block30;
                                        }
                                    }
                                }
                                if (CellType.BLANK.compareTo((Enum)type) != 0) break block32;
                                items[colIndex] = null;
                                break block30;
                            }
                            if (CellType.BOOLEAN.compareTo((Enum)type) != 0) break block33;
                            items[colIndex] = new Boolean(cell.getBooleanCellValue());
                            break block30;
                        }
                        if (CellType.STRING.compareTo((Enum)type) != 0) break block34;
                        items[colIndex] = cell.getStringCellValue();
                        break block30;
                    }
                    if (CellType.ERROR.compareTo((Enum)type) != 0) break block35;
                    try {
                        if (cell instanceof XSSFCell) {
                            items[colIndex] = ((XSSFCell)cell).getErrorCellString();
                            break block30;
                        }
                        items[colIndex] = null;
                    }
                    catch (Exception ex) {
                        items[colIndex] = null;
                        String errorMessage = ex.getMessage();
                        if (!StringUtils.isValidString(errorMessage)) break block30;
                        try {
                            if (errorMessage.toUpperCase().indexOf("NUMERIC") > -1) {
                                items[colIndex] = ExcelUtils.getNumericCellValue(cell, type, dataFormat);
                            } else if (errorMessage.toUpperCase().indexOf("BOOLEAN") > -1) {
                                items[colIndex] = new Boolean(cell.getBooleanCellValue());
                            } else if (errorMessage.toUpperCase().indexOf("STRING") > -1) {
                                items[colIndex] = cell.getStringCellValue();
                            }
                            break block30;
                        }
                        catch (Exception ex1) {
                            items[colIndex] = null;
                        }
                    }
                    break block30;
                }
                if (CellType.NUMERIC.compareTo((Enum)type) == 0) {
                    items[colIndex] = ExcelUtils.getNumericCellValue(cell, type, dataFormat);
                }
            }
            ++currCol;
        }
        return items;
    }

    private static Object getNumericCellValue(Cell cell, CellType type, DataFormat dataFormat) {
        try {
            CellStyle cellStyle = cell.getCellStyle();
            String dataFormatString = cellStyle.getDataFormatString();
            double d = cell.getNumericCellValue();
            if ("@".equals(dataFormatString)) {
                DataFormatter dataFormatter = new DataFormatter();
                return dataFormatter.formatCellValue(cell);
            }
            if (ExcelUtils.isCellDateFormatted(cell, dataFormat)) {
                java.util.Date dd;
                java.util.Date date = dd = DateUtil.getJavaDate((double)d);
                int dateType = ExcelUtils.getDateType(cellStyle.getDataFormat(), cellStyle.getDataFormatString());
                if (dateType == 0) {
                    date = new Date(dd.getTime());
                } else if (dateType == 1) {
                    date = new Time(dd.getTime());
                } else if (dateType == 2) {
                    date = new Timestamp(dd.getTime());
                }
                return date;
            }
            return ExcelUtils.getNumericCellValue(cell.getNumericCellValue());
        }
        catch (Exception e) {
            if (CellType.FORMULA.compareTo((Enum)type) == 0) {
                try {
                    return cell.getStringCellValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static Object getNumericCellValue(double d) {
        try {
            BigDecimal big = new BigDecimal(d);
            String v = big.toString();
            int pos = v.indexOf(".");
            if (pos >= 0) {
                boolean allZero = true;
                ++pos;
                while (pos < v.length()) {
                    if (v.charAt(pos) != '0') {
                        allZero = false;
                        break;
                    }
                    ++pos;
                }
                if (allZero) {
                    v = v.substring(0, v.indexOf("."));
                }
            }
            return PgmNormalCell.parseConstValue(v);
        }
        catch (Exception e) {
            return new Double(d);
        }
    }

    public static boolean setCellValue(Cell cell, Object value) {
        boolean isNumericString = false;
        if (value == null) {
            cell.setCellValue("");
        } else if (value instanceof java.util.Date) {
            cell.setCellValue((java.util.Date)value);
        } else if (value instanceof String) {
            String sValue = (String)value;
            isNumericString = ExcelUtils.isNumeric(sValue);
            cell.setCellValue(sValue);
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else {
            String s = value.toString();
            try {
                double d = Double.parseDouble(s);
                cell.setCellValue(d);
            }
            catch (Throwable e1) {
                cell.setCellValue(s);
            }
        }
        return isNumericString;
    }

    public static boolean isNumeric(String str) {
        if (str.length() == 0) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmptyRow(Row hr, int lastCol) {
        int c = 0;
        while (c <= lastCol) {
            if (!ExcelUtils.isEmptyCell(hr.getCell(c))) {
                return false;
            }
            ++c;
        }
        return true;
    }

    private static boolean isEmptyCell(Cell cell) {
        if (cell == null) {
            return true;
        }
        CellType type = ExcelVersionCompatibleUtilGetter.getInstance().getCellType(cell);
        if (CellType.BOOLEAN.compareTo((Enum)type) == 0 || CellType.NUMERIC.compareTo((Enum)type) == 0 || CellType.FORMULA.compareTo((Enum)type) == 0 || CellType.ERROR.compareTo((Enum)type) == 0) {
            return false;
        }
        if (CellType.STRING.compareTo((Enum)type) == 0) {
            return !StringUtils.isValidString(cell.getStringCellValue());
        }
        if (CellType.BLANK.compareTo((Enum)type) == 0) {
            return true;
        }
        return true;
    }

    public static int getLabelNumber(String cellName) {
        String c = cellName.toUpperCase().replaceAll("[A-Z]", "");
        return Integer.parseInt(c);
    }

    public static int nameToColumn(String name) {
        int column = -1;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            column = (column + 1) * 26 + c - 65;
            ++i;
        }
        return column;
    }

    public static boolean isBlankRow(Object[] line) {
        if (line != null) {
            Object[] objectArray = line;
            int n = line.length;
            int n2 = 0;
            while (n2 < n) {
                Object data = objectArray[n2];
                if (data != null) {
                    if (data instanceof String) {
                        if (StringUtils.isValidString((String)data)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public static float transferRowHeight(float poundValue) {
        int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        float px = poundValue * (float)dpi / 72.0f;
        return (int)px;
    }

    public static float transferColWidth(float poiValue) {
        float charLen = poiValue / 256.0f;
        return (int)(5.0f + charLen * (float)(ExcelUtils.getDefaultCharWidth() - 1));
    }

    private static int getDefaultCharWidth() {
        int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        if (dpi <= 96) {
            return 8;
        }
        return 10;
    }

    public static Object trim(Object data, boolean isW) {
        if (data == null) {
            return null;
        }
        if (data instanceof String) {
            String str = (String)data;
            str = str.trim();
            if (isW && "".equals(str)) {
                str = null;
            }
            data = str;
        }
        return data;
    }

    public static Sequence transpose(Sequence seq) {
        if (seq == null || seq.length() == 0) {
            return seq;
        }
        int colCount = ExcelUtils.getSequenceColCount(seq);
        int len = seq.length();
        Sequence transSeq = new Sequence(colCount);
        int c = 0;
        while (c < colCount) {
            Sequence colSeq = new Sequence(len);
            int r = 1;
            while (r <= len) {
                Object data = seq.get(r);
                if (data == null) {
                    colSeq.add(null);
                } else if (data instanceof Sequence) {
                    Sequence dataSeq = (Sequence)data;
                    if (dataSeq.length() > c) {
                        colSeq.add(dataSeq.get(c + 1));
                    } else {
                        colSeq.add(null);
                    }
                } else if (data instanceof BaseRecord) {
                    BaseRecord dataRec = (BaseRecord)data;
                    if (dataRec.getFieldCount() > c) {
                        colSeq.add(dataRec.getFieldValue(c + 1));
                    } else {
                        colSeq.add(null);
                    }
                } else if (c == 0) {
                    colSeq.add(data);
                } else {
                    colSeq.add(null);
                }
                ++r;
            }
            transSeq.add(colSeq);
            ++c;
        }
        return transSeq;
    }

    public static int getSequenceColCount(Sequence seq) {
        int colCount = 0;
        int len = seq.length();
        int r = 1;
        while (r <= len) {
            Object data = seq.get(r);
            if (data != null) {
                colCount = data instanceof Sequence ? Math.max(colCount, ((Sequence)data).length()) : (data instanceof BaseRecord ? Math.max(colCount, ((BaseRecord)data).getFieldCount()) : Math.max(colCount, 1));
            }
            ++r;
        }
        return colCount;
    }

    public static double getExcelTimeDouble(Time time) {
        double DAY_SECONDS = 86400.0;
        int hh = time.getHours();
        int mm = time.getMinutes();
        int ss = time.getSeconds();
        int seconds = (hh * 60 + mm) * 60 + ss;
        return (double)seconds / 86400.0;
    }

    public static java.util.Date excelDateNumber2JavaDate(Number excelDateNumber) {
        java.util.Date date = DateUtil.getJavaDate((double)excelDateNumber.doubleValue());
        if (excelDateNumber instanceof Integer) {
            date = new Date(date.getTime());
        } else if (new Double(excelDateNumber.doubleValue()).compareTo(1.0) < 0) {
            date = new Time(date.getTime());
        }
        return date;
    }

    public static Number javaDate2ExcelDateNumber(java.util.Date date) {
        double time;
        if (date instanceof Time) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(1900, 0, 1);
            time = DateUtil.getExcelDate((java.util.Date)cal.getTime());
            time -= 1.0;
        } else {
            time = DateUtil.getExcelDate((java.util.Date)date);
            if (Double.compare(time, Math.round(time)) == 0) {
                return new Double(time).intValue();
            }
        }
        return time;
    }

    public static void checkSheetName(Object s) {
        if (!StringUtils.isValidString(s)) {
            return;
        }
        String sheetName = s.toString();
        if (sheetName.length() > 31) {
            throw new RQException(AppMessage.get().getMessage("excelutils.invalidsheetname"));
        }
    }
}

