/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.excel;

import com.scudata.common.ImageUtils;
import com.scudata.common.Logger;
import com.scudata.excel.ExcelVersionCompatibleUtilInterface;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFPictureData;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;

public class ExcelVersionCompatibleUtil5
implements ExcelVersionCompatibleUtilInterface {
    private static final String ROW_COL_SEP = "_";

    @Override
    public int getXSSFShape_EMU_PER_PIXEL() {
        return 9525;
    }

    @Override
    public CellType getCellType(Cell c) {
        return c.getCellType();
    }

    @Override
    public short getHSSFColor_AUTOMATIC_Index() {
        return HSSFColor.HSSFColorPredefined.AUTOMATIC.getIndex();
    }

    @Override
    public HorizontalAlignment getHSSFAlignmentEnum(HSSFCellStyle style) {
        return style.getAlignment();
    }

    @Override
    public VerticalAlignment getHSSFVerticalAlignmentEnum(HSSFCellStyle style) {
        return style.getVerticalAlignment();
    }

    @Override
    public short getHSSFBorderLeft(HSSFCellStyle style) {
        return style.getBorderLeft().getCode();
    }

    @Override
    public short getHSSFBorderRight(HSSFCellStyle style) {
        return style.getBorderRight().getCode();
    }

    @Override
    public short getHSSFBorderTop(HSSFCellStyle style) {
        return style.getBorderTop().getCode();
    }

    @Override
    public short getHSSFBorderBottom(HSSFCellStyle style) {
        return style.getBorderBottom().getCode();
    }

    @Override
    public HorizontalAlignment getXSSFAlignmentEnum(XSSFCellStyle style) {
        return style.getAlignment();
    }

    @Override
    public VerticalAlignment getXSSFVerticalAlignmentEnum(XSSFCellStyle style) {
        return style.getVerticalAlignment();
    }

    @Override
    public short getXSSFBorderLeft(XSSFCellStyle style) {
        return style.getBorderLeft().getCode();
    }

    @Override
    public short getXSSFBorderRight(XSSFCellStyle style) {
        return style.getBorderRight().getCode();
    }

    @Override
    public short getXSSFBorderTop(XSSFCellStyle style) {
        return style.getBorderTop().getCode();
    }

    @Override
    public short getXSSFBorderBottom(XSSFCellStyle style) {
        return style.getBorderBottom().getCode();
    }

    @Override
    public boolean isCellTypeFomula(Cell cell) {
        return cell.getCellType().compareTo((Enum)CellType.FORMULA) == 0;
    }

    @Override
    public int getColor(XSSFColor xc, Color defColor) {
        byte[] argb;
        Color c = defColor;
        if (xc != null && (argb = xc.getARGB()) != null) {
            if (argb.length == 3) {
                byte[] tmp = new byte[]{-1, argb[0], argb[1], argb[2]};
                argb = tmp;
            }
            c = new Color(this.byteToInt(argb[1]), this.byteToInt(argb[2]), this.byteToInt(argb[3]), this.byteToInt(argb[0]));
        }
        return c.getRGB();
    }

    @Override
    public int byteToInt(byte b) {
        if (b >= 0) {
            return b;
        }
        return b + 256;
    }

    @Override
    public void addWaterRemarkToExcel(Workbook wbp, BufferedImage img, Sheet s) throws IOException {
        byte[] bytes = ImageUtils.writePNG(img);
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream(bytes.length);
        byteArrayOut.write(bytes);
        XSSFWorkbook xssfWb = null;
        if (wbp instanceof XSSFWorkbook) {
            xssfWb = (XSSFWorkbook)wbp;
        } else if (wbp instanceof SXSSFWorkbook) {
            xssfWb = ((SXSSFWorkbook)wbp).getXSSFWorkbook();
        }
        Iterator poisheets = xssfWb.sheetIterator();
        Class<?> XR = null;
        try {
            XR = Class.forName("org.apache.poi.xssf.usermodel.XSSFRelation");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Field relationTypeEnumField = null;
        try {
            relationTypeEnumField = XR.getField("IMAGES");
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        while (poisheets.hasNext()) {
            XSSFSheet poisheet = (XSSFSheet)poisheets.next();
            int pictureIdx = wbp.addPicture(bytes, 6);
            if (poisheet.getCTWorksheet().isSetPicture()) continue;
            Class<?> class1 = poisheet.getClass();
            Method method = null;
            try {
                Class<?> poiXMlRelationClass = Class.forName("org.apache.poi.ooxml.POIXMLRelation");
                Class<?> pOIXMLDocumentPartClass = Class.forName("org.apache.poi.ooxml.POIXMLDocumentPart");
                method = class1.getMethod("addRelation", String.class, poiXMlRelationClass, pOIXMLDocumentPartClass);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            PackageRelationship prs = null;
            try {
                Object relationPart = method.invoke((Object)poisheet, null, relationTypeEnumField.get(XR), xssfWb.getAllPictures().get(pictureIdx));
                Class<?> relationPartClass = relationPart.getClass();
                Method method2 = relationPartClass.getMethod("getRelationship", new Class[0]);
                Object invoke = method2.invoke(relationPart, new Object[0]);
                prs = (PackageRelationship)invoke;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            String rID = prs.getId();
            poisheet.getCTWorksheet().addNewPicture().setId(rID);
        }
    }

    @Override
    public short getBorderStyle(byte borderStyle, float width) {
        try {
            Class<?> clazz = Class.forName("com.raqsoft.report.view.ExportExcelUtil2");
            Object o = clazz.newInstance();
            Method m = clazz.getMethod("getBorderStyle", Byte.class, Float.class);
            return (Short)m.invoke(o, borderStyle, Float.valueOf(width));
        }
        catch (Exception e) {
            return BorderStyle.THIN.getCode();
        }
    }

    @Override
    public short getISheetBorderStyle(byte borderStyle) {
        try {
            Class<?> clazz = Class.forName("com.raqsoft.report.view.ExportExcelUtil2");
            Object o = clazz.newInstance();
            Method m = clazz.getMethod("getISheetBorderStyle", Byte.TYPE);
            return (Short)m.invoke(o, borderStyle);
        }
        catch (Exception e) {
            return BorderStyle.THIN.getCode();
        }
    }

    @Override
    public CellType getCellType(CellValue value) {
        return value.getCellType();
    }

    @Override
    public RichTextString getItemAt(SharedStrings sst, int idx) {
        return sst.getItemAt(idx);
    }

    @Override
    public void getSheetPictures(XSSFSheet sheet, Map<String, byte[]> graphMap) {
        List list = sheet.getRelations();
        for (POIXMLDocumentPart part : list) {
            if (!(part instanceof XSSFDrawing)) continue;
            XSSFDrawing drawing = (XSSFDrawing)part;
            List shapes = drawing.getShapes();
            for (XSSFShape shape : shapes) {
                XSSFPicture picture = (XSSFPicture)shape;
                XSSFPictureData pdata = picture.getPictureData();
                if (pdata == null) continue;
                XSSFClientAnchor anchor = picture.getPreferredSize();
                CTMarker marker = anchor.getFrom();
                String key = String.valueOf(marker.getRow()) + ROW_COL_SEP + marker.getCol();
                graphMap.put(key, pdata.getData());
                if (pdata.getPictureType() == 6) continue;
                picture.resize();
            }
        }
    }

    @Override
    public int getFontIndex(Font font) {
        return font.getIndex();
    }

    @Override
    public int getFontIndex(CellStyle style) {
        return style.getFontIndex();
    }

    @Override
    public int getNumberOfFonts(Workbook wb) {
        return wb.getNumberOfFonts();
    }

    @Override
    public int getNumberOfSheets(Workbook wb) {
        return wb.getNumberOfSheets();
    }

    @Override
    public Font getFontAt(Workbook wb, Number index) {
        return wb.getFontAt(index.intValue());
    }

    @Override
    public CellType getCachedFormulaResultType(Cell cell) {
        return cell.getCachedFormulaResultType();
    }

    @Override
    public XSSFColor getXSSFColor(int color) {
        try {
            Constructor constructor = XSSFColor.class.getConstructor(Color.class);
            return (XSSFColor)constructor.newInstance(new Color(color));
        }
        catch (Exception e) {
            return this.getXSSFColor525(color);
        }
    }

    public XSSFColor getXSSFColor525(int color) {
        Color color2 = new Color(color);
        try {
            Constructor constructor = XSSFColor.class.getConstructor(Color.class, IndexedColorMap.class);
            return (XSSFColor)constructor.newInstance(color2, null);
        }
        catch (Exception e) {
            Logger.debug(e);
            return null;
        }
    }

    @Override
    public SharedStrings readSharedStrings(XSSFReader xssfReader) {
        try {
            Method m = XSSFReader.class.getMethod("getSharedStringsTable", new Class[0]);
            Class<?> returnType = m.getReturnType();
            if (returnType.getName().contains("SharedStringsTable")) {
                SharedStringsTable sst = (SharedStringsTable)m.invoke((Object)xssfReader, new Object[0]);
                return sst;
            }
            return this.readSharedStrings525(xssfReader);
        }
        catch (Exception e) {
            Logger.debug(e);
            return null;
        }
    }

    public SharedStrings readSharedStrings525(XSSFReader xssfReader) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method m = XSSFReader.class.getMethod("getSharedStringsTable", new Class[0]);
        Class<?> returnType = m.getReturnType();
        assert (returnType.getName().endsWith("org.apache.poi.xssf.model.SharedStrings"));
        SharedStrings sst = (SharedStrings)m.invoke((Object)xssfReader, new Object[0]);
        return sst;
    }
}

