/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.excel;

import com.scudata.app.config.ConfigUtil;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.excel.BreakException;
import com.scudata.excel.ExcelUtils;
import com.scudata.excel.SheetInfo;
import com.scudata.excel.SheetInfoHandler;
import com.scudata.excel.SheetObject;
import com.scudata.excel.SheetXlsR;
import com.scudata.excel.XlsFileObject;
import com.scudata.resources.AppMessage;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class FileXlsR
extends XlsFileObject {
    private OPCPackage xlsxPackage = null;
    private XSSFReader xssfReader = null;

    public FileXlsR(FileObject fo, String pwd) {
        this.fileType = 1;
        InputStream is = null;
        InputStream in = null;
        BufferedInputStream bis = null;
        POIFSFileSystem pfs = null;
        String filePath = fo.getFileName();
        try {
            try {
                boolean isXlsx;
                if (fo.isRemoteFile()) {
                    is = fo.getInputStream();
                } else {
                    filePath = ConfigUtil.getPath(Env.getMainPath(), filePath);
                    is = new FileInputStream(filePath);
                }
                if (!is.markSupported()) {
                    is = new PushbackInputStream(is, 8);
                }
                if (!(isXlsx = ExcelUtils.isXlsxFile(fo))) {
                    MessageManager mm = AppMessage.get();
                    throw new RQException("xlsopen" + mm.getMessage("filexls.rwforxlsx"));
                }
                if (pwd != null) {
                    bis = new BufferedInputStream(is, Env.FILE_BUFSIZE);
                    pfs = new POIFSFileSystem((InputStream)bis);
                    in = ExcelUtils.decrypt(pfs, pwd);
                    this.xlsxPackage = OPCPackage.open((InputStream)in);
                } else if (fo.isRemoteFile()) {
                    this.xlsxPackage = OPCPackage.open((InputStream)is);
                } else {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.xlsxPackage = OPCPackage.open((String)filePath, (PackageAccess)PackageAccess.READ);
                }
                this.xssfReader = new XSSFReader(this.xlsxPackage);
                this.initSheetInfos(this.xssfReader);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (pfs != null) {
                try {
                    pfs.close();
                }
                catch (Throwable throwable) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Throwable throwable) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void initSheetInfos(XSSFReader xssfReader) throws IOException, OpenXML4JException, SAXException {
        final Vector countSet = new Vector();
        HashSet<String> nameSet = new HashSet<String>();
        XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
        int index = 0;
        while (iter.hasNext()) {
            final InputStream stream = iter.next();
            final String sheetName = iter.getSheetName();
            if (nameSet.contains(sheetName)) continue;
            nameSet.add(sheetName);
            final BaseRecord record = this.newLast(new Object[]{sheetName, new Integer(0), new Integer(0)});
            Thread t = new Thread(Thread.currentThread().getThreadGroup(), new Runnable(){

                @Override
                public void run() {
                    FileXlsR.this.initSheetInfo(stream, sheetName, record, countSet);
                }
            });
            t.start();
            ++index;
        }
        while (countSet.size() < index) {
            try {
                Thread.sleep(10L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * Loose catch block
     */
    private void initSheetInfo(InputStream sheetInputStream, String sheetName, BaseRecord record, Vector<String> countSet) {
        SheetInfo si = new SheetInfo(sheetName);
        try {
            try {
                InputSource sheetSource = new InputSource(sheetInputStream);
                XMLReader parser = XMLReaderFactory.createXMLReader();
                SheetInfoHandler handler = new SheetInfoHandler(si);
                parser.setContentHandler(handler);
                parser.parse(sheetSource);
                record.set(1, (Object)new Integer(si.getRowCount()));
                record.set(2, (Object)new Integer(si.getColCount()));
            }
            catch (ZipException e1) {
                if (!this.isClosed) {
                    throw new RuntimeException(e1);
                }
                if (sheetInputStream != null) {
                    try {
                        sheetInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                countSet.add(sheetName);
            }
            catch (BreakException e) {
                block21: {
                    record.set(1, (Object)new Integer(si.getRowCount()));
                    record.set(2, (Object)new Integer(si.getColCount()));
                    if (sheetInputStream == null) break block21;
                    try {
                        sheetInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                countSet.add(sheetName);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            if (sheetInputStream != null) {
                try {
                    sheetInputStream.close();
                }
                catch (IOException iOException) {}
            }
            countSet.add(sheetName);
        }
    }

    @Override
    public boolean supportCursor() {
        return true;
    }

    @Override
    public void xlswrite(FileObject fo, String pwd) {
        throw new RQException("xlswrite" + AppMessage.get().getMessage("filexls.xlswriter"));
    }

    private SheetInfo getSheetInfo(String name) {
        int i = 1;
        int len = this.length();
        while (i <= len) {
            if (name.equals(this.getRecord(i).getFieldValue(0))) {
                return this.getSheetInfo(i);
            }
            ++i;
        }
        return null;
    }

    private SheetInfo getSheetInfo(int index) {
        BaseRecord r = this.getRecord(index);
        SheetInfo si = new SheetInfo((String)r.getFieldValue(0));
        si.setRowCount((Integer)r.getFieldValue(1));
        si.setColCount((Integer)r.getFieldValue(2));
        return si;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SheetObject getSheetObject(Object s, boolean createSheet, boolean deleteOldSheet) throws Exception {
        SheetXlsR sx;
        Map map = this.sheets;
        synchronized (map) {
            SheetInfo si;
            block9: {
                if (s == null) {
                    s = new Integer(1);
                }
                if (StringUtils.isValidString(s)) {
                    si = this.getSheetInfo((String)s);
                    if (si == null) {
                        throw new RQException(AppMessage.get().getMessage("excel.nosheetname", s));
                    }
                    break block9;
                }
                if (s instanceof Number) {
                    int index = ((Number)s).intValue();
                    if (index > this.length() || index < 1) {
                        throw new RQException(AppMessage.get().getMessage("excel.nosheetindex", index));
                    }
                    si = this.getSheetInfo(index);
                    break block9;
                }
                return null;
            }
            sx = new SheetXlsR(this.xssfReader, si);
            this.sheets.put(new Integer(this.sheets.size()), sx);
        }
        return sx;
    }

    @Override
    public void xlsclose() throws IOException {
        try {
            for (SheetObject sx : this.sheets.values()) {
                if (sx == null) continue;
                sx.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.sheets.clear();
        this.isClosed = true;
        try {
            if (this.xlsxPackage != null) {
                this.xlsxPackage.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

