/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.excel;

import com.scudata.app.config.ConfigUtil;
import com.scudata.common.RQException;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.Sequence;
import com.scudata.excel.ExcelVersionCompatibleUtilGetter;
import com.scudata.excel.XlsImporter;
import com.scudata.excel.XlsxSImporter;
import com.scudata.resources.AppMessage;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XlsCount {
    private FileObject fo;
    private boolean isXlsx;
    private boolean getCount;
    private Object s;
    private int titleRow = 0;
    private String pwd;

    public XlsCount(FileObject fo, boolean isXlsx, boolean getCount) {
        this(fo, isXlsx, getCount, null, 1, null);
    }

    public XlsCount(FileObject fo, boolean isXlsx, boolean getCount, Object s, int titleRow, String pwd) {
        this.fo = fo;
        this.isXlsx = isXlsx;
        this.getCount = getCount;
        this.s = s;
        this.titleRow = titleRow - 1;
        this.pwd = pwd;
    }

    public Object getCount() throws Exception {
        if (this.s != null) {
            InputStream in = null;
            try {
                Object[] titles;
                in = this.fo.getInputStream();
                if (this.isXlsx) {
                    XlsxSImporter importer = new XlsxSImporter(this.fo, null, this.titleRow, this.titleRow, this.s, "t", this.pwd);
                    titles = importer.readLine();
                    try {
                        importer.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    XlsImporter importer = new XlsImporter(in, this.pwd);
                    if (this.s instanceof Number) {
                        int sheetIndex = ((Number)this.s).intValue() - 1;
                        importer.setSheet(sheetIndex);
                    } else if (this.s instanceof String) {
                        importer.setSheet((String)this.s);
                    }
                    importer.setStartRow(this.titleRow);
                    titles = importer.readLine();
                }
                if (this.getCount) {
                    Integer n = titles == null ? 0 : titles.length;
                    return n;
                }
                Sequence sequence = new Sequence(titles);
                return sequence;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (this.isXlsx) {
            return this.getXlsxCount();
        }
        return this.getXlsCount();
    }

    private Object getXlsCount() {
        InputStream in = null;
        HSSFWorkbook wb = null;
        try {
            in = this.fo.getInputStream();
            Biff8EncryptionKey.setCurrentUserPassword((String)this.pwd);
            wb = new HSSFWorkbook(in);
            int sheetCount = ExcelVersionCompatibleUtilGetter.getInstance().getNumberOfSheets((Workbook)wb);
            if (this.getCount) {
                Integer n = sheetCount;
                return n;
            }
            Sequence names = new Sequence();
            int i = 0;
            while (i < sheetCount) {
                names.add(wb.getSheetName(i));
                ++i;
            }
            Sequence sequence = names;
            return sequence;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage());
        }
        finally {
            Biff8EncryptionKey.setCurrentUserPassword(null);
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private Object getXlsxCount() throws Exception {
        String filePath = this.fo.getFileName();
        filePath = ConfigUtil.getPath(Env.getMainPath(), filePath);
        OPCPackage pkg = null;
        InputStream workbook = null;
        FileInputStream is = null;
        POIFSFileSystem pfs = null;
        InputStream in = null;
        try {
            if (this.pwd != null) {
                is = new FileInputStream(filePath);
                pfs = new POIFSFileSystem((InputStream)is);
                EncryptionInfo info = new EncryptionInfo(pfs);
                Decryptor d = Decryptor.getInstance((EncryptionInfo)info);
                if (!d.verifyPassword(this.pwd)) {
                    throw new RQException(AppMessage.get().getMessage("excel.invalidpwd", this.pwd));
                }
                in = d.getDataStream(pfs);
                pkg = OPCPackage.open((InputStream)in);
            } else {
                pkg = OPCPackage.open((String)filePath, (PackageAccess)PackageAccess.READ);
            }
            XSSFReader reader = new XSSFReader(pkg);
            workbook = reader.getWorkbookData();
            XMLReader wbParser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            WorkbookHandler wbHandler = new WorkbookHandler();
            wbParser.setContentHandler(wbHandler);
            InputSource wbSource = new InputSource(workbook);
            wbParser.parse(wbSource);
            Sequence sheetNames = wbHandler.getSheetNames();
            if (this.getCount) {
                Integer n = sheetNames == null ? 0 : sheetNames.length();
                return n;
            }
            Sequence sequence = sheetNames;
            return sequence;
        }
        finally {
            if (pkg != null) {
                try {
                    pkg.close();
                }
                catch (Exception exception) {}
            }
            if (workbook != null) {
                try {
                    workbook.close();
                }
                catch (Exception exception) {}
            }
            if (pfs != null) {
                try {
                    pfs.close();
                }
                catch (Throwable throwable) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    class WorkbookHandler
    extends DefaultHandler {
        private Sequence sheetNames = new Sequence();

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("sheet")) {
                String sheetName = attributes.getValue("name");
                this.sheetNames.add(sheetName);
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        public Sequence getSheetNames() {
            return this.sheetNames;
        }
    }
}

