/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.excel;

import com.scudata.common.CellLocation;
import com.scudata.common.Logger;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.FileObject;
import com.scudata.dm.IResource;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.excel.FileXls;
import com.scudata.excel.SheetInfo;
import com.scudata.excel.SheetObject;
import com.scudata.excel.SheetXls;
import com.scudata.expression.Expression;
import com.scudata.resources.AppMessage;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.PaneInformation;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public abstract class XlsFileObject
extends Table
implements IResource {
    public static final byte TYPE_NORMAL = 0;
    public static final byte TYPE_READ = 1;
    public static final byte TYPE_WRITE = 2;
    protected byte fileType = 0;
    public static final int COL_NAME = 0;
    public static final int COL_ROW_COUNT = 1;
    public static final int COL_COL_COUNT = 2;
    private static final String LABEL_SHEET_NAME = "stname";
    private static final String LABEL_ROW_COUNT = "nrows";
    private static final String LABEL_COL_COUNT = "ncols";
    protected Map<Integer, SheetObject> sheets = new HashMap<Integer, SheetObject>();
    public static final String PRE_SHEET_NAME = "Sheet";
    protected boolean isClosed = false;
    private Map<Integer, CellStyle> moveStyleMap = new HashMap<Integer, CellStyle>();

    public XlsFileObject() {
        super(new String[]{LABEL_SHEET_NAME, LABEL_ROW_COUNT, LABEL_COL_COUNT});
    }

    public byte getFileType() {
        return this.fileType;
    }

    public void removeSheet(String sheetName) {
        int i = 1;
        int len = this.length();
        while (i <= len) {
            Object labelName = this.getRecord(i).getFieldValue(0);
            if (sheetName.equals(labelName)) {
                this.delete(i);
                break;
            }
            ++i;
        }
    }

    public SheetObject getSheetObject(Object s, boolean createSheet) throws Exception {
        return this.getSheetObject(s, createSheet, false);
    }

    public abstract SheetObject getSheetObject(Object var1, boolean var2, boolean var3) throws Exception;

    public synchronized void resetSheetInfo(SheetInfo si) {
        if (si != null) {
            int i = 1;
            int len = this.length();
            while (i <= len) {
                BaseRecord r = this.getRecord(i);
                if (si.getSheetName().equals(r.getFieldValue(0))) {
                    r.set(1, (Object)si.getRowCount());
                    r.set(2, (Object)si.getColCount());
                    break;
                }
                ++i;
            }
        }
    }

    public abstract boolean supportCursor();

    public abstract void xlswrite(FileObject var1, String var2);

    public Object xlsimport(String opt) throws Exception {
        return this.xlsimport(null, null, 0, 0, opt);
    }

    public Object xlsimport(String[] fields, Object s, int startRow, int endRow, String opt) throws Exception {
        if (this.fileType == 2) {
            throw new RQException("xlsimport" + AppMessage.get().getMessage("filexls.wimport"));
        }
        SheetObject sx = this.getSheetObject(s, false);
        Object result = sx.xlsimport(fields, startRow, endRow, opt);
        return result;
    }

    public void xlsexport(SheetObject so, Object A, Expression[] exps, String[] fields, Object s, int startRow, String opt, Context ctx) throws Exception {
        if (this.fileType == 1) {
            throw new RQException("xlsexport" + AppMessage.get().getMessage("filexls.rexport"));
        }
        SheetXls sx = (SheetXls)so;
        if (A instanceof Sequence) {
            sx.xlsexport((Sequence)A, exps, fields, startRow, opt, ctx);
        } else if (A instanceof ICursor) {
            sx.xlsexport((ICursor)A, exps, fields, startRow, opt, ctx);
        }
        this.resetSheetInfo(sx.sheetInfo);
    }

    public Object xlscell(CellLocation pos1, CellLocation pos2, Object sheet, Object content, boolean isRowInsert, boolean isGraph, boolean isW, boolean isP, boolean isN) throws Exception {
        SheetObject sheetObject = this.getSheetObject(sheet, false);
        SheetXls sx = (SheetXls)sheetObject;
        int row1 = pos1.getRow();
        int col1 = pos1.getCol();
        if (pos2 != null) {
            int row2 = pos2.getRow();
            int col2 = pos2.getCol();
            pos1 = new CellLocation(Math.min(row1, row2), Math.min(col1, col2));
            pos2 = new CellLocation(Math.max(row1, row2), Math.max(col1, col2));
        } else {
            pos2 = content == null ? new CellLocation(sx.sheetInfo.getRowCount(), sx.sheetInfo.getColCount()) : new CellLocation(sx.getMaxRowCount(), sx.getMaxColCount());
        }
        if (content == null) {
            return sx.getCells(pos1, pos2, isGraph, isW, isP, isN);
        }
        sx.setCells(pos1, pos2, content, isRowInsert, isGraph);
        this.resetSheetInfo(sx.sheetInfo);
        return null;
    }

    public void rename(Object sheet, String newSheetName) throws Exception {
        SheetObject sheetObject = this.getSheetObject(sheet, false);
        SheetXls sx = (SheetXls)sheetObject;
        String oldSheetName = sx.sheetInfo.getSheetName();
        sx.rename(newSheetName);
        int i = 1;
        int len = this.length();
        while (i <= len) {
            BaseRecord r = this.getRecord(i);
            if (oldSheetName.equals(r.getFieldValue(0))) {
                r.set(0, (Object)newSheetName);
                break;
            }
            ++i;
        }
    }

    @Override
    public void close() {
        try {
            if (!this.isClosed) {
                this.xlsclose();
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    public abstract void xlsclose() throws IOException;

    protected String getNewSheetName() {
        Sequence sheetNames = this.fieldValues(0);
        int index = 1;
        while (sheetNames.contains(PRE_SHEET_NAME + index, false)) {
            ++index;
        }
        return PRE_SHEET_NAME + index;
    }

    public void xlsmove(String s, String s1, XlsFileObject xo1, boolean isCopy) throws Exception {
        FileXls fileXls = (FileXls)this;
        if (xo1 == null) {
            if (s1 == null) {
                int sheetIndex = fileXls.wb.getSheetIndex(s);
                fileXls.wb.removeSheetAt(sheetIndex);
                this.removeSheet(s);
            } else if (isCopy) {
                fileXls.cloneSheet(s, s1);
            } else {
                this.rename(s, s1);
            }
        } else {
            FileXls fileXls1 = (FileXls)xo1;
            String toSheetName = StringUtils.isValidString(s1) ? s1 : s;
            xo1.getSheetObject(toSheetName, true, true);
            int fromSheetIndex = fileXls.wb.getSheetIndex(s);
            int toSheetIndex = fileXls1.wb.getSheetIndex(toSheetName);
            this.copySheet(fileXls.wb, fileXls.wb.getSheetAt(fromSheetIndex), fileXls1.wb, fileXls1.wb.getSheetAt(toSheetIndex), this.moveStyleMap);
            if (!isCopy) {
                int sheetIndex = fileXls.wb.getSheetIndex(s);
                fileXls.wb.removeSheetAt(sheetIndex);
                this.removeSheet(s);
            }
        }
    }

    private void copySheet(Workbook fromWorkbook, Sheet fromSheet, Workbook toWorkbook, Sheet toSheet, Map<Integer, CellStyle> styleMap) {
        boolean fromXlsx = fromSheet instanceof XSSFSheet;
        boolean toXlsx = toSheet instanceof XSSFSheet;
        boolean isSameFileType = fromXlsx == toXlsx;
        toSheet.setForceFormulaRecalculation(fromSheet.getForceFormulaRecalculation());
        SheetConditionalFormatting scf = fromSheet.getSheetConditionalFormatting();
        SheetConditionalFormatting toSheetConditionFormat = toSheet.getSheetConditionalFormatting();
        int i = 0;
        while (i < scf.getNumConditionalFormattings()) {
            toSheetConditionFormat.addConditionalFormatting(scf.getConditionalFormattingAt(i));
            ++i;
        }
        PaneInformation paneInformation = fromSheet.getPaneInformation();
        if (Objects.nonNull(paneInformation)) {
            toSheet.createFreezePane((int)paneInformation.getHorizontalSplitPosition(), (int)paneInformation.getVerticalSplitPosition(), (int)paneInformation.getHorizontalSplitTopRow(), (int)paneInformation.getVerticalSplitLeftColumn());
        }
        int numMergedRegions = fromSheet.getNumMergedRegions();
        int i2 = 0;
        while (i2 < numMergedRegions) {
            CellRangeAddress mergedRegion = fromSheet.getMergedRegion(i2);
            toSheet.addMergedRegion(mergedRegion.copy());
            ++i2;
        }
        int physicalNumberOfCells = fromSheet.getRow(0).getPhysicalNumberOfCells();
        int i3 = 0;
        while (i3 < physicalNumberOfCells) {
            toSheet.setColumnWidth(i3, 5120);
            ++i3;
        }
        int maxColumnNum = 0;
        int i4 = fromSheet.getFirstRowNum();
        int lastRow = fromSheet.getLastRowNum();
        while (i4 <= lastRow) {
            Row fromRow = fromSheet.getRow(i4);
            Row toRow = toSheet.createRow(i4);
            if (fromRow != null) {
                toRow.setHeight(fromRow.getHeight());
                toRow.setZeroHeight(fromRow.getZeroHeight());
                toRow.setRowNum(fromRow.getRowNum());
                CellStyle fromRowStyle = fromRow.getRowStyle();
                CellStyle toRowStyle = this.cloneCellStyle(fromWorkbook, fromRowStyle, toWorkbook, styleMap, isSameFileType);
                if (toRowStyle != null) {
                    toRow.setRowStyle(toRowStyle);
                }
                int jn = fromRow.getFirstCellNum() < 0 ? 0 : fromRow.getFirstCellNum();
                short lastCol = fromRow.getLastCellNum();
                if (lastCol > maxColumnNum) {
                    maxColumnNum = lastCol;
                }
                int j = jn;
                while (j <= lastCol) {
                    Cell fromCell = fromRow.getCell(j);
                    Cell toCell = toRow.createCell(j);
                    if (fromCell != null) {
                        CellStyle fromCellStyle = fromCell.getCellStyle();
                        CellStyle toCellStyle = this.cloneCellStyle(fromWorkbook, fromCellStyle, toWorkbook, styleMap, isSameFileType);
                        if (toCellStyle != null) {
                            toCell.setCellStyle(toCellStyle);
                        }
                        switch (fromCell.getCellType()) {
                            case NUMERIC: {
                                if (DateUtil.isCellDateFormatted((Cell)fromCell)) {
                                    Date date1 = fromCell.getDateCellValue();
                                    toCell.setCellValue(date1);
                                    break;
                                }
                                double cellValue1 = fromCell.getNumericCellValue();
                                toCell.setCellValue(cellValue1);
                                break;
                            }
                            case STRING: {
                                toCell.setCellValue(fromCell.getStringCellValue());
                                break;
                            }
                            case BLANK: {
                                break;
                            }
                            case ERROR: {
                                toCell.setCellValue((double)fromCell.getErrorCellValue());
                                break;
                            }
                            case BOOLEAN: {
                                toCell.setCellValue(fromCell.getBooleanCellValue());
                                break;
                            }
                            case FORMULA: {
                                toCell.setCellFormula(fromCell.getCellFormula());
                                break;
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i4;
        }
        i4 = 0;
        while (i4 <= maxColumnNum) {
            toSheet.setColumnWidth(i4, fromSheet.getColumnWidth(i4));
            toSheet.setColumnHidden(i4, fromSheet.isColumnHidden(i4));
            if (fromSheet.isColumnBroken(i4)) {
                toSheet.setColumnBreak(i4);
            }
            ++i4;
        }
    }

    private CellStyle cloneCellStyle(Workbook fromWorkbook, CellStyle fromStyle, Workbook toWorkbook, Map<Integer, CellStyle> styleMap, boolean isSameFileType) {
        if (fromStyle == null) {
            return null;
        }
        int stHashCode = fromStyle.hashCode();
        CellStyle toStyle = styleMap.get(stHashCode);
        if (toStyle == null) {
            toStyle = toWorkbook.createCellStyle();
            if (isSameFileType) {
                toStyle.cloneStyleFrom(fromStyle);
            } else {
                this.copyCellStyle(fromWorkbook, fromStyle, toWorkbook, toStyle);
            }
            styleMap.put(stHashCode, toStyle);
        }
        return toStyle;
    }

    private void copyCellStyle(Workbook fromWorkbook, CellStyle fromStyle, Workbook toWorkbook, CellStyle toStyle) {
        toStyle.setAlignment(fromStyle.getAlignment());
        toStyle.setVerticalAlignment(fromStyle.getVerticalAlignment());
        toStyle.setBorderBottom(fromStyle.getBorderBottom());
        toStyle.setBorderLeft(fromStyle.getBorderLeft());
        toStyle.setBorderRight(fromStyle.getBorderRight());
        toStyle.setBorderTop(fromStyle.getBorderTop());
        toStyle.setTopBorderColor(fromStyle.getTopBorderColor());
        toStyle.setBottomBorderColor(fromStyle.getBottomBorderColor());
        toStyle.setRightBorderColor(fromStyle.getRightBorderColor());
        toStyle.setLeftBorderColor(fromStyle.getLeftBorderColor());
        toStyle.setFillBackgroundColor(fromStyle.getFillBackgroundColor());
        toStyle.setFillForegroundColor(fromStyle.getFillForegroundColor());
        toStyle.setDataFormat(fromStyle.getDataFormat());
        toStyle.setFillPattern(fromStyle.getFillPattern());
        if (fromStyle instanceof HSSFCellStyle) {
            HSSFCellStyle style = (HSSFCellStyle)fromStyle;
            HSSFFont fromFont = style.getFont(fromWorkbook);
            Font toFont = this.copyFont(toWorkbook, (Font)fromFont);
            toStyle.setFont(toFont);
        } else if (fromStyle instanceof XSSFCellStyle) {
            XSSFCellStyle style = (XSSFCellStyle)fromStyle;
            XSSFFont fromFont = style.getFont();
            Font toFont = this.copyFont(toWorkbook, (Font)fromFont);
            toStyle.setFont(toFont);
        }
        toStyle.setHidden(fromStyle.getHidden());
        toStyle.setIndention(fromStyle.getIndention());
        toStyle.setLocked(fromStyle.getLocked());
        toStyle.setQuotePrefixed(fromStyle.getQuotePrefixed());
        toStyle.setRotation(fromStyle.getRotation());
        toStyle.setWrapText(fromStyle.getWrapText());
        toStyle.setShrinkToFit(fromStyle.getShrinkToFit());
    }

    private Font copyFont(Workbook workbook, Font fromFont) {
        byte underline;
        short typeOffset;
        boolean isStrikeout;
        boolean isItalic;
        String fontName;
        short fontHeight;
        short color;
        boolean isBold = fromFont.getBold();
        Font toFont = workbook.findFont(isBold, color = fromFont.getColor(), fontHeight = fromFont.getFontHeight(), fontName = fromFont.getFontName(), isItalic = fromFont.getItalic(), isStrikeout = fromFont.getStrikeout(), typeOffset = fromFont.getTypeOffset(), underline = fromFont.getUnderline());
        if (toFont == null) {
            toFont = workbook.createFont();
            toFont.setBold(isBold);
            toFont.setColor(color);
            toFont.setFontHeight(fontHeight);
            toFont.setFontName(fontName);
            toFont.setItalic(isItalic);
            toFont.setStrikeout(isStrikeout);
            toFont.setTypeOffset(typeOffset);
            toFont.setUnderline(underline);
        }
        return toFont;
    }
}

