/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.excel;

import com.scudata.common.RQException;
import com.scudata.excel.ExcelUtils;
import com.scudata.excel.IExcelTool;
import com.scudata.resources.AppMessage;
import java.io.InputStream;
import org.apache.poi.openxml4j.exceptions.OLE2NotOfficeXmlFileException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XlsxImporter
implements IExcelTool {
    private XSSFWorkbook wb = null;
    private XSSFSheet sheet = null;
    private int currRow;
    private XSSFDataFormat dataFormat;
    private FormulaEvaluator evaluator;
    private int maxRow;

    public XlsxImporter(InputStream is, String pwd) {
        POIFSFileSystem pfs = null;
        InputStream in = null;
        try {
            try {
                if (pwd != null) {
                    pfs = new POIFSFileSystem(is);
                    in = ExcelUtils.decrypt(pfs, pwd);
                    this.wb = new XSSFWorkbook(in);
                } else {
                    this.wb = new XSSFWorkbook(is);
                }
                this.sheet = this.wb.getSheetAt(0);
                this.dataFormat = this.wb.createDataFormat();
            }
            catch (RQException e) {
                throw e;
            }
            catch (OLE2NotOfficeXmlFileException e) {
                if (pwd == null) {
                    throw new RQException(AppMessage.get().getMessage("xlsximporter.ole2nopwd"), e);
                }
                throw new RQException(AppMessage.get().getMessage("xlsximporter.ole2pwd"), e);
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (pfs != null) {
                try {
                    pfs.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public int getMaxLineCount() {
        return 0x100000;
    }

    @Override
    public void setSheet(String name) {
        XSSFSheet s = this.wb.getSheet(name);
        if (s == null) {
            throw new RQException(AppMessage.get().getMessage("excel.nosheetname", name));
        }
        this.sheet = s;
    }

    @Override
    public void setSheet(int index) {
        XSSFSheet s = this.wb.getSheetAt(index);
        if (s == null) {
            throw new RQException(AppMessage.get().getMessage("excel.nosheetindex", String.valueOf(index)));
        }
        this.sheet = s;
    }

    @Override
    public int totalCount() {
        return this.sheet.getLastRowNum() + 1;
    }

    @Override
    public void setStartRow(int start) {
        this.currRow = start;
    }

    @Override
    public void setFetchCount(int fetchCount) {
        this.maxRow = this.currRow + fetchCount - 1;
        if (this.maxRow > this.sheet.getLastRowNum()) {
            this.maxRow = this.sheet.getLastRowNum();
        }
    }

    @Override
    public Object[] readLine() {
        if (this.sheet != null) {
            if (this.maxRow == 0) {
                this.maxRow = this.sheet.getLastRowNum();
            }
            if (this.currRow > this.maxRow) {
                return null;
            }
            XSSFRow row = this.sheet.getRow(this.currRow);
            ++this.currRow;
            return ExcelUtils.getRowData((Row)row, (DataFormat)this.dataFormat, this.evaluator);
        }
        return null;
    }

    @Override
    public void output() {
    }

    @Override
    public void writeLine(Object[] items) {
    }

    private void formulaEvaluate() {
        if (this.evaluator != null) {
            return;
        }
        this.evaluator = this.wb.getCreationHelper().createFormulaEvaluator();
        if (this.evaluator != null) {
            this.evaluator.clearAllCachedResultValues();
            this.evaluator.evaluateAll();
        }
    }
}

