/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.excel;

import com.scudata.common.Logger;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.excel.ExcelUtils;
import com.scudata.excel.ExcelVersionCompatibleUtilGetter;
import com.scudata.excel.IExcelTool;
import com.scudata.excel.RowAndCellStyle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XlsxSExporter
implements IExcelTool {
    private SXSSFWorkbook wb = null;
    private Sheet sheet = null;
    private FileObject fo = null;
    private HashMap<Integer, CellStyle> styles = new HashMap();
    private boolean hasTitle;
    private boolean writeTitle;
    private boolean isAppend;
    private boolean isK;
    private boolean resetDataStyle = true;
    private int currRow = 0;
    private int maxWriteCount = 0x100000;
    private RowAndCellStyle dataStyle;
    private CellStyle[] colStyles;
    private String pwd;
    private boolean sheetExists = false;

    public XlsxSExporter(FileObject fo, boolean hasTitle, boolean isAppend, Object sheetName, String pwd, boolean isK) {
        this.fo = fo;
        this.hasTitle = hasTitle;
        this.writeTitle = hasTitle;
        this.isAppend = isAppend;
        this.isK = isK;
        this.pwd = pwd;
        try {
            this.wb = new SXSSFWorkbook(500);
            this.sheet = this.wb.createSheet();
            this.loadSheet(StringUtils.isValidString(sheetName) ? (String)sheetName : "");
        }
        catch (Exception e) {
            throw new RQException(e.getMessage());
        }
    }

    @Override
    public int getMaxLineCount() {
        return this.maxWriteCount;
    }

    @Override
    public void writeLine(Object[] items) {
        if (this.sheet == null) {
            return;
        }
        Row row = null;
        if (this.currRow <= this.sheet.getLastRowNum()) {
            row = this.sheet.getRow(this.currRow);
        }
        if (row == null) {
            row = this.sheet.createRow(this.currRow);
        }
        RowAndCellStyle rowStyle = this.writeTitle ? this.getRowStyle(this.currRow) : this.dataStyle;
        this.writeRowData(row, items, rowStyle == null ? null : rowStyle.rowStyle, rowStyle == null ? null : rowStyle.cellStyles);
        if (this.writeTitle) {
            this.writeTitle = false;
        } else if (this.sheetExists && this.resetDataStyle) {
            this.resetDataStyle(row);
        }
        ++this.currRow;
    }

    private void resetDataStyle(Row row) {
        int lastCol;
        if (this.dataStyle == null) {
            this.dataStyle = new RowAndCellStyle();
        }
        if ((lastCol = row.getLastCellNum()) > 0) {
            CellStyle[] cellStyles = new CellStyle[lastCol];
            int c = 0;
            while (c < lastCol) {
                Cell cell = row.getCell(c);
                if (cell != null) {
                    cellStyles[c] = cell.getCellStyle();
                }
                ++c;
            }
            this.dataStyle.cellStyles = cellStyles;
        }
        this.resetDataStyle = false;
    }

    private void writeRowData(Row row, Object[] items, CellStyle rowStyle, CellStyle[] cellStyles) {
        if (items == null || items.length == 0) {
            return;
        }
        CellStyle rowOrColStyle = null;
        int currCol = 0;
        int maxCol = items.length;
        while (currCol < maxCol) {
            Object value;
            CellStyle cellStyle;
            Cell cell = row.getCell(currCol);
            if (cell == null) {
                cellStyle = null;
                cell = row.createCell(currCol);
                if (cellStyles != null && cellStyles.length > currCol) {
                    cellStyle = cellStyles[currCol];
                    cell.setCellStyle(cellStyle);
                }
            } else {
                cellStyle = cell.getCellStyle();
            }
            if (cellStyle == null) {
                if (rowStyle != null) {
                    cell.setCellStyle(rowStyle);
                    rowOrColStyle = rowStyle;
                } else if (this.colStyles != null && currCol < this.colStyles.length && this.colStyles[currCol] != null) {
                    cell.setCellStyle(this.colStyles[currCol]);
                    rowOrColStyle = this.colStyles[currCol];
                }
            }
            if ((value = items[currCol]) instanceof Date) {
                if (value instanceof Time) {
                    cell.setCellValue(ExcelUtils.getExcelTimeDouble((Time)value));
                } else {
                    cell.setCellValue((Date)value);
                }
                DataFormat dFormat = this.wb.createDataFormat();
                if (cellStyle == null && !ExcelUtils.isCellDateFormatted(cell, dFormat)) {
                    CellStyle style = null;
                    short format = 49;
                    format = value instanceof Timestamp ? (short)dFormat.getFormat(Env.getDateTimeFormat()) : (value instanceof Time ? (short)dFormat.getFormat(Env.getTimeFormat()) : (short)dFormat.getFormat(Env.getDateFormat()));
                    style = this.styles.get(new Integer(currCol));
                    if (style == null) {
                        style = this.wb.createCellStyle();
                        if (rowOrColStyle != null) {
                            style.cloneStyleFrom(rowOrColStyle);
                        }
                        style.setDataFormat(format);
                        this.styles.put(new Integer(currCol), style);
                    }
                    cell.setCellStyle(style);
                }
            } else if (value instanceof String) {
                String sValue = (String)value;
                if (ExcelUtils.isNumeric(sValue)) {
                    cell.setCellType(CellType.STRING);
                }
                cell.setCellValue(sValue);
            } else if (value instanceof Boolean) {
                cell.setCellValue(((Boolean)value).booleanValue());
            } else if (value != null) {
                String s = value.toString();
                try {
                    double d = Double.parseDouble(s);
                    cell.setCellValue(d);
                }
                catch (Throwable e1) {
                    cell.setCellValue(s);
                }
            }
            ++currCol;
        }
        if (rowStyle != null) {
            row.setRowStyle(rowStyle);
        }
    }

    private RowAndCellStyle getRowStyle(int r) {
        Row hr = this.sheet.getRow(r);
        if (hr == null) {
            return null;
        }
        RowAndCellStyle style = new RowAndCellStyle();
        style.rowStyle = hr.getRowStyle();
        int lastCol = hr.getLastCellNum();
        if (lastCol > 0) {
            CellStyle[] cellStyles = new CellStyle[lastCol];
            int c = 0;
            while (c < lastCol) {
                Cell cell = hr.getCell(c);
                if (cell != null) {
                    cellStyles[c] = cell.getCellStyle();
                }
                ++c;
            }
            style.cellStyles = cellStyles;
        }
        style.rowHeight = hr.getHeightInPoints();
        return style;
    }

    @Override
    public void setSheet(String sheetName) {
        this.currRow = 0;
        int index = 1;
        while (this.wb.getSheet("Sheet" + index) != null) {
            ++index;
        }
        String newName = "Sheet" + index;
        this.sheet = this.wb.createSheet();
        int sheetIndex = this.wb.getSheetIndex(this.sheet);
        this.wb.setSheetName(sheetIndex, newName);
    }

    @Override
    public void setSheet(int index) {
    }

    @Override
    public int totalCount() {
        return 0;
    }

    @Override
    public void setStartRow(int start) {
    }

    @Override
    public void setFetchCount(int fetchCount) {
    }

    @Override
    public void output() {
        if (this.wb != null && this.fo != null) {
            OutputStream out = null;
            try {
                try {
                    out = this.fo.getBufferedOutputStream(false);
                    this.wb.write(out);
                }
                catch (Exception e) {
                    throw new RQException(e.getMessage());
                }
            }
            finally {
                try {
                    this.wb.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.pwd != null) {
                ExcelUtils.encrypt(this.fo, this.pwd);
            }
        }
    }

    public void close() throws IOException {
        this.output();
    }

    @Override
    public Object[] readLine() {
        return null;
    }

    private void loadSheet(String sheetName) {
        block29: {
            InputStream is = null;
            XSSFWorkbook wbOld = null;
            try {
                try {
                    if (this.fo.isExists() && (this.isAppend || this.isK)) {
                        is = this.fo.getInputStream();
                        wbOld = new XSSFWorkbook(is);
                        XSSFSheet oldSheet = null;
                        if (StringUtils.isValidString(sheetName)) {
                            this.wb.setSheetName(this.wb.getSheetIndex(this.sheet), sheetName);
                            oldSheet = wbOld.getSheet(sheetName);
                        } else {
                            int sheetCount = ExcelVersionCompatibleUtilGetter.getInstance().getNumberOfSheets((Workbook)wbOld);
                            if (sheetCount > 0) {
                                oldSheet = wbOld.getSheetAt(0);
                            }
                        }
                        if (oldSheet != null) {
                            this.sheetExists = true;
                            this.loadSheet(oldSheet);
                            if (this.isAppend) {
                                this.loadStylesA(oldSheet);
                            } else if (this.isK) {
                                this.loadStylesK(oldSheet);
                            }
                        }
                        break block29;
                    }
                    String name = "Sheet1";
                    if (StringUtils.isValidString(sheetName)) {
                        name = sheetName;
                    }
                    this.wb.setSheetName(this.wb.getSheetIndex(this.sheet), name);
                }
                catch (Exception e) {
                    Logger.error("Error while reading the file: " + this.fo.getFileName());
                    e.getMessage();
                    if (wbOld != null) {
                        try {
                            wbOld.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (is == null) break block29;
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (wbOld != null) {
                    try {
                        wbOld.close();
                    }
                    catch (IOException iOException) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void loadSheet(XSSFSheet oldSheet) {
        int c;
        XSSFRow oldRow;
        int lastRow = oldSheet.getLastRowNum();
        int totalColCount = 0;
        int r = 0;
        while (r <= lastRow) {
            oldRow = oldSheet.getRow(r);
            if (oldRow != null) {
                totalColCount = Math.max(oldRow.getLastCellNum(), totalColCount);
            }
            ++r;
        }
        HashMap<CellStyle, CellStyle> styleMap = new HashMap<CellStyle, CellStyle>();
        if (totalColCount > 0) {
            try {
                this.colStyles = new CellStyle[totalColCount];
                c = 0;
                while (c < totalColCount) {
                    this.sheet.setColumnWidth(c, oldSheet.getColumnWidth(c));
                    CellStyle oldColStyle = oldSheet.getColumnStyle(c);
                    this.colStyles[c] = this.cloneCellStyle(styleMap, oldColStyle);
                    ++c;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        int r2 = 0;
        while (r2 <= lastRow) {
            Row row = this.sheet.createRow(r2);
            oldRow = oldSheet.getRow(r2);
            row.setHeightInPoints(oldRow.getHeightInPoints());
            XSSFCellStyle oldRowStyle = oldRow.getRowStyle();
            if (oldRowStyle != null) {
                CellStyle rowStyle = (CellStyle)styleMap.get(oldRowStyle);
                if (rowStyle == null) {
                    rowStyle = this.wb.createCellStyle();
                    rowStyle.cloneStyleFrom((CellStyle)oldRowStyle);
                    styleMap.put((CellStyle)oldRowStyle, rowStyle);
                }
                row.setRowStyle(rowStyle);
            }
            c = 0;
            while (c < oldRow.getLastCellNum()) {
                Cell cell = row.createCell(c);
                XSSFCell oldCell = oldRow.getCell(c);
                XSSFCellStyle oldCellStyle = oldCell.getCellStyle();
                if (oldCellStyle != null) {
                    CellStyle cellStyle = this.cloneCellStyle(styleMap, (CellStyle)oldCellStyle);
                    cell.setCellStyle(cellStyle);
                } else if (this.colStyles[c] != null) {
                    cell.setCellStyle(this.colStyles[c]);
                }
                CellType cellType = ExcelVersionCompatibleUtilGetter.getInstance().getCellType((Cell)oldCell);
                cell.setCellType(cellType);
                if (CellType.BLANK.compareTo((Enum)cellType) != 0) {
                    if (CellType.BOOLEAN.compareTo((Enum)cellType) == 0) {
                        cell.setCellValue(oldCell.getBooleanCellValue());
                    } else if (CellType.ERROR.compareTo((Enum)cellType) == 0) {
                        cell.setCellErrorValue(oldCell.getErrorCellValue());
                    } else if (CellType.FORMULA.compareTo((Enum)cellType) == 0) {
                        cell.setCellFormula(oldCell.getCellFormula());
                    } else if (CellType.NUMERIC.compareTo((Enum)cellType) == 0) {
                        cell.setCellValue(oldCell.getNumericCellValue());
                    } else if (CellType.STRING.compareTo((Enum)cellType) == 0) {
                        cell.setCellValue(oldCell.getStringCellValue());
                    }
                }
                ++c;
            }
            ++r2;
        }
    }

    private void loadStylesA(XSSFSheet sheet) {
        if (sheet == null) {
            return;
        }
        try {
            int lastRow = sheet.getLastRowNum();
            if (lastRow < 0) {
                return;
            }
            int lastContentRow = -1;
            int r = lastRow;
            while (r >= 0) {
                short lastCol;
                XSSFRow hr = sheet.getRow(r);
                if (hr != null && !ExcelUtils.isEmptyRow((Row)hr, lastCol = hr.getLastCellNum())) {
                    lastContentRow = r;
                    break;
                }
                --r;
            }
            if (this.hasTitle) {
                if (lastContentRow == -1) {
                    lastContentRow = 0;
                }
                this.currRow = lastContentRow;
                this.dataStyle = this.getRowStyle(lastContentRow + 1);
            } else {
                this.currRow = lastContentRow == -1 ? 0 : lastContentRow + 1;
                this.dataStyle = lastContentRow < lastRow ? this.getRowStyle(lastContentRow + 1) : this.getRowStyle(lastContentRow);
            }
            this.maxWriteCount -= this.currRow + 1;
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    private CellStyle cloneCellStyle(HashMap<CellStyle, CellStyle> styleMap, CellStyle oldCellStyle) {
        CellStyle cellStyle = styleMap.get(oldCellStyle);
        if (cellStyle == null) {
            cellStyle = this.wb.createCellStyle();
            cellStyle.cloneStyleFrom(oldCellStyle);
            styleMap.put(oldCellStyle, cellStyle);
        }
        return cellStyle;
    }

    private void loadStylesK(XSSFSheet sheet) {
        if (sheet == null) {
            return;
        }
        try {
            int lastRow = sheet.getLastRowNum();
            if (lastRow < 0) {
                return;
            }
            this.currRow = 0;
            this.dataStyle = this.hasTitle ? this.getRowStyle(1) : this.getRowStyle(0);
            this.maxWriteCount -= this.currRow + 1;
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }
}

