/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.excel;

import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.DataStruct;
import com.scudata.dm.ILineInput;
import com.scudata.dm.Table;
import com.scudata.dm.UserUtils;
import com.scudata.excel.ExcelTool;
import com.scudata.excel.ExcelUtils;
import com.scudata.excel.ExcelVersionCompatibleUtilGetter;
import com.scudata.excel.SheetHandler;
import com.scudata.resources.AppMessage;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.StylesTable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XlsxSSheetParser
implements ILineInput {
    private int currRow = 0;
    private int startRow = 0;
    private int endRow = -1;
    private Boolean parseFinished = Boolean.FALSE;
    private String[] fields = null;
    private boolean bTitle;
    private boolean isCursor;
    private boolean isN;
    private boolean removeBlank;
    private volatile boolean isClosed = false;
    public static final int QUEUE_SIZE = 500;
    private final ArrayBlockingQueue<Object> que = new ArrayBlockingQueue(500);
    private static final Boolean ENDING_OBJECT = Boolean.FALSE;

    public XlsxSSheetParser(XSSFReader xssfReader, String[] fields, int startRow, int endRow, Object s, String opt) {
        try {
            this.fields = fields;
            this.isCursor = opt != null && opt.indexOf("c") > -1;
            this.bTitle = opt != null && opt.indexOf("t") > -1;
            this.isN = opt != null && opt.indexOf("n") > -1;
            boolean bl = this.removeBlank = opt != null && opt.indexOf("b") > -1;
            if (startRow > 0) {
                --startRow;
            } else if (startRow < 0) {
                startRow = 0;
            }
            this.startRow = startRow;
            if (endRow > 0) {
                --endRow;
            } else if (endRow == 0) {
                endRow = 0x100000;
            } else if (endRow < 0) {
                throw new RQException("xlsimport" + AppMessage.get().getMessage("filexls.eerror"));
            }
            this.endRow = endRow;
            this.process(xssfReader, s);
        }
        catch (RQException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void process(XSSFReader xssfReader, Object sheet) throws IOException, OpenXML4JException, SAXException {
        SharedStrings sst = ExcelVersionCompatibleUtilGetter.getInstance().readSharedStrings(xssfReader);
        StylesTable styles = xssfReader.getStylesTable();
        XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
        int index = 0;
        boolean findSheet = false;
        while (iter.hasNext()) {
            InputStream stream = iter.next();
            if (StringUtils.isValidString(sheet)) {
                String sheetName = iter.getSheetName();
                if (!sheet.equals(sheetName)) {
                    ++index;
                    continue;
                }
            } else {
                int sheetIndex = 0;
                if (sheet != null && sheet instanceof Number) {
                    sheetIndex = ((Number)sheet).intValue() - 1;
                }
                if (index != sheetIndex) {
                    ++index;
                    continue;
                }
            }
            this.processSheet(styles, sst, stream);
            findSheet = true;
            break;
        }
        if (!findSheet && sheet != null) {
            if (StringUtils.isValidString(sheet)) {
                throw new RQException(AppMessage.get().getMessage("excel.nosheetname", sheet));
            }
            if (sheet instanceof Number) {
                throw new RQException(AppMessage.get().getMessage("excel.nosheetindex", String.valueOf(((Number)sheet).intValue())));
            }
        }
    }

    private void processSheet(StylesTable styles, SharedStrings sst, final InputStream sheetInputStream) throws IOException, SAXException {
        final InputSource sheetSource = new InputSource(sheetInputStream);
        try {
            final XMLReader parser = XMLReaderFactory.createXMLReader();
            SheetHandler handler = new SheetHandler(styles, sst, this.fields, this.startRow, this.endRow, this.removeBlank, this.bTitle, this.que);
            parser.setContentHandler(handler);
            Thread parseThread = new Thread(){

                @Override
                public void run() {
                    try {
                        try {
                            parser.parse(sheetSource);
                        }
                        catch (Throwable e) {
                            if (!XlsxSSheetParser.this.isClosed) {
                                Logger.error(e);
                            }
                            if (sheetInputStream != null) {
                                try {
                                    sheetInputStream.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            XlsxSSheetParser.this.parseFinished = Boolean.TRUE;
                        }
                    }
                    finally {
                        if (sheetInputStream != null) {
                            try {
                                sheetInputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        XlsxSSheetParser.this.parseFinished = Boolean.TRUE;
                    }
                }
            };
            parseThread.start();
        }
        catch (Exception e) {
            this.parseFinished = true;
            throw new RuntimeException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object[] readLine() {
        block6: {
            if (this.endRow <= -1 || this.currRow <= this.endRow) ** GOTO lbl5
            return null;
lbl-1000:
            // 1 sources

            {
                if (!this.parseFinished.booleanValue()) continue;
                return null;
lbl5:
                // 2 sources

                ** while (this.que.isEmpty())
            }
lbl7:
            // 2 sources

            ++this.currRow;
            obj = this.que.take();
            if (!XlsxSSheetParser.ENDING_OBJECT.equals(obj)) break block6;
            return null;
        }
        try {
            line = (Object[])obj;
            if (this.isN && line != null) {
                i = 0;
                while (i < line.length) {
                    line[i] = ExcelUtils.trim(line[i], false);
                    ++i;
                }
            }
            return line;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean skipLine() throws IOException {
        Object[] line = this.readLine();
        if (line == null) {
            return false;
        }
        if (this.endRow > -1 && this.currRow == this.endRow) {
            return false;
        }
        ++this.currRow;
        return true;
    }

    @Override
    public void close() throws IOException {
        this.que.clear();
        this.isClosed = true;
    }

    public Object xlsimport() {
        Table table;
        DataStruct ds;
        String[] items;
        int fcount;
        if (this.isCursor) {
            String cursorOpt = "";
            if (this.bTitle) {
                cursorOpt = String.valueOf(cursorOpt) + "t";
            }
            return UserUtils.newCursor(this, cursorOpt);
        }
        Object[] line = this.readLine();
        if (line == null) {
            if (this.fields != null && this.fields.length > 0) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(this.fields[0]) + mm.getMessage("ds.fieldNotExist"));
            }
            return null;
        }
        if (this.removeBlank) {
            while (ExcelUtils.isBlankRow(line)) {
                ++this.startRow;
                if (this.startRow > this.endRow) {
                    return null;
                }
                line = this.readLine();
                if (line != null) continue;
                return null;
            }
        }
        if ((fcount = line.length) == 0) {
            if (this.fields != null && this.fields.length > 0) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(this.fields[0]) + mm.getMessage("ds.fieldNotExist"));
            }
            return null;
        }
        if (this.bTitle) {
            items = new String[fcount];
            int f = 0;
            while (f < fcount) {
                items[f] = Variant.toString(line[f]);
                ++f;
            }
            ds = new DataStruct(items);
        } else {
            items = new String[fcount];
            ds = new DataStruct(items);
        }
        ++this.startRow;
        if (this.fields == null || this.fields.length == 0) {
            int f;
            table = new Table(ds);
            if (!this.bTitle) {
                int curLen = line.length;
                BaseRecord r = table.newLast();
                f = 0;
                while (f < curLen) {
                    r.setNormalFieldValue(f, line[f]);
                    ++f;
                }
            }
            while (this.startRow <= this.endRow) {
                line = this.readLine();
                if (line != null) {
                    ++this.startRow;
                    int curLen = line.length;
                    if (curLen > fcount) {
                        curLen = fcount;
                    }
                    BaseRecord r = table.newLast();
                    f = 0;
                    while (f < curLen) {
                        r.setNormalFieldValue(f, line[f]);
                        ++f;
                    }
                    continue;
                }
                break;
            }
        } else {
            int f;
            int curLen;
            int[] index = new int[fcount];
            int i = 0;
            while (i < fcount) {
                index[i] = -1;
                ++i;
            }
            i = 0;
            int count = this.fields.length;
            while (i < count) {
                int q = ds.getFieldIndex(this.fields[i]);
                if (q < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(String.valueOf(this.fields[i]) + mm.getMessage("ds.fieldNotExist"));
                }
                if (index[q] != -1) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(String.valueOf(this.fields[i]) + mm.getMessage("ds.colNameRepeat"));
                }
                index[q] = i;
                this.fields[i] = ds.getFieldName(q);
                ++i;
            }
            DataStruct newDs = new DataStruct(this.fields);
            table = new Table(newDs);
            if (!this.bTitle) {
                curLen = line.length;
                BaseRecord r = table.newLast();
                f = 0;
                while (f < curLen) {
                    if (index[f] != -1) {
                        r.setNormalFieldValue(index[f], line[f]);
                    }
                    ++f;
                }
            }
            while (this.startRow <= this.endRow) {
                line = this.readLine();
                if (line != null) {
                    ++this.startRow;
                    curLen = line.length;
                    if (curLen > fcount) {
                        curLen = fcount;
                    }
                    BaseRecord r = table.newLast();
                    f = 0;
                    while (f < curLen) {
                        if (index[f] != -1) {
                            r.setNormalFieldValue(index[f], line[f]);
                        }
                        ++f;
                    }
                    continue;
                }
                break;
            }
        }
        table.trimToSize();
        if (this.removeBlank) {
            ExcelTool.removeTableTailBlank(table);
        }
        return table;
    }
}

