/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression;

import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.Sequence;
import com.scudata.expression.Node;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class ArgNode
extends Node {
    private int _$1 = -1;

    public ArgNode(String id) {
        if (id.length() > 1) {
            this._$1 = Integer.parseInt(id.substring(1));
        }
    }

    public Object calculate(Context ctx) {
        ComputeStack stack = ctx.getComputeStack();
        Current current = stack.getArg();
        if (current == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.argStackEmpty"));
        }
        if (this._$1 > 0) {
            return current.get(this._$1);
        }
        if (this._$1 == 0) {
            return current.getCurrentSequence();
        }
        this._$1 = current.getCurrentIndex() + 1;
        if (this._$1 <= current.length()) {
            current.setCurrent(this._$1);
            return current.get(this._$1);
        }
        if (current.length() > 0) {
            this._$1 = 1;
            current.setCurrent(1);
            return current.get(1);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("engine.argStackEmpty"));
    }

    public IArray calculateAll(Context ctx) {
        Sequence sequence = ctx.getComputeStack().getTopSequence();
        Object value = this.calculate(ctx);
        return new ConstArray(value, sequence.length());
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        return this.calculateAll(ctx);
    }

    public BoolArray calculateAnd(Context ctx, IArray leftResult) {
        Object value = this.calculate(ctx);
        BoolArray result = leftResult.isTrue();
        if (Variant.isFalse(value)) {
            int size = result.size();
            for (int i = 1; i <= size; ++i) {
                result.set(i, false);
            }
        }
        return result;
    }

    public boolean isMonotone() {
        return true;
    }
}

